/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.BaselineComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.ContainerSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.IndentedComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.SameSizeSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPointCommand;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoints;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormLayoutVisualDataProvider;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.PercentageSnapPoint;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

final class FormLayoutSnapPointsProvider<C extends IControlInfo>
extends SnapPoints.DefaultSnapPoints {
    private final FormLayoutVisualDataProvider<C> m_vdProvider;
    private final List<? extends IAbstractComponentInfo> m_allWidgets;
    private final IFormLayoutInfo<C> m_layout;

    public FormLayoutSnapPointsProvider(IFormLayoutInfo<C> layout, FormLayoutVisualDataProvider<C> visualDataProvider, List<? extends IAbstractComponentInfo> allWidgets) {
        super(visualDataProvider, allWidgets);
        this.m_layout = layout;
        this.m_vdProvider = visualDataProvider;
        this.m_allWidgets = allWidgets;
    }

    public List<SnapPoint> forComponent(IAbstractComponentInfo target, boolean isHorizontal) {
        IndentedComponentSnapPoint snapPoint;
        ArrayList<SnapPoint> pts = new ArrayList<SnapPoint>();
        int lSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)true);
        int tSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)false);
        if (isHorizontal) {
            snapPoint = new IndentedComponentSnapPoint(this.m_vdProvider, target);
            pts.add((SnapPoint)snapPoint);
        } else {
            snapPoint = new BaselineComponentSnapPoint(this.m_vdProvider, target);
            pts.add((SnapPoint)snapPoint);
        }
        snapPoint = new ComponentSnapPoint(this.m_vdProvider, target, lSide, 1, true);
        snapPoint.setCommand(new MoveToComponentCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new ComponentSnapPoint(this.m_vdProvider, target, lSide, 0);
        snapPoint.setCommand(new MoveToComponentCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new ComponentSnapPoint(this.m_vdProvider, target, tSide, 0, true);
        snapPoint.setCommand(new MoveToComponentCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new ComponentSnapPoint(this.m_vdProvider, target, tSide, 1);
        snapPoint.setCommand(new MoveToComponentCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        return pts;
    }

    public List<SnapPoint> forContainer(boolean isHorizontal) {
        ArrayList<SnapPoint> pts = new ArrayList<SnapPoint>();
        int leadingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)true);
        int trailingSide = PlacementUtils.getSide((boolean)isHorizontal, (boolean)false);
        ContainerSnapPoint snapPoint = new ContainerSnapPoint(this.m_vdProvider, leadingSide, true);
        snapPoint.setCommand(new MoveToContainerCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new ContainerSnapPoint(this.m_vdProvider, leadingSide);
        snapPoint.setCommand(new MoveToContainerCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new ContainerSnapPoint(this.m_vdProvider, trailingSide, true);
        snapPoint.setCommand(new MoveToContainerCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new ContainerSnapPoint(this.m_vdProvider, trailingSide);
        snapPoint.setCommand(new MoveToContainerCommand<C>(this.m_layout, (SnapPoint)snapPoint));
        pts.add((SnapPoint)snapPoint);
        snapPoint = new SameSizeSnapPoint(this.m_vdProvider, this.m_allWidgets, leadingSide);
        pts.add((SnapPoint)snapPoint);
        snapPoint = new SameSizeSnapPoint(this.m_vdProvider, this.m_allWidgets, trailingSide);
        pts.add((SnapPoint)snapPoint);
        for (Integer percent : this.m_vdProvider.getPercentsValues(isHorizontal)) {
            PercentageSnapPoint<C> snapPoint2 = new PercentageSnapPoint<C>(this.m_vdProvider, leadingSide, percent, true);
            snapPoint2.setCommand(new MoveToPercentCommand<C>(this.m_layout, snapPoint2));
            pts.add(snapPoint2);
            snapPoint2 = new PercentageSnapPoint<C>(this.m_vdProvider, leadingSide, percent);
            snapPoint2.setCommand(new MoveToPercentCommand<C>(this.m_layout, snapPoint2));
            pts.add(snapPoint2);
            snapPoint2 = new PercentageSnapPoint<C>(this.m_vdProvider, trailingSide, percent, true);
            snapPoint2.setCommand(new MoveToPercentCommand<C>(this.m_layout, snapPoint2));
            pts.add(snapPoint2);
            snapPoint2 = new PercentageSnapPoint<C>(this.m_vdProvider, trailingSide, percent);
            snapPoint2.setCommand(new MoveToPercentCommand<C>(this.m_layout, snapPoint2));
            pts.add(snapPoint2);
        }
        return pts;
    }

    static final class MoveFreelyCommand<C extends IControlInfo>
    extends EditCommand {
        private final List<? extends IAbstractComponentInfo> m_components;
        private final int m_moveDirection;
        private final boolean m_isHorizontal;
        private final IFormLayoutInfo<C> m_layout;
        private final IVisualDataProvider m_visualDataProvider;
        private final Rectangle m_bounds;

        MoveFreelyCommand(IFormLayoutInfo<C> layoutInfo, Rectangle bounds, List<? extends IAbstractComponentInfo> components, int moveDirection, boolean isHorizontal, IVisualDataProvider provider) {
            super(layoutInfo);
            this.m_layout = layoutInfo;
            this.m_bounds = bounds;
            this.m_components = components;
            this.m_moveDirection = moveDirection;
            this.m_isHorizontal = isHorizontal;
            this.m_visualDataProvider = provider;
        }

        protected void executeEdit() throws Exception {
            FormLayoutInfoImplAutomatic impl = (FormLayoutInfoImplAutomatic)this.m_layout.getImpl();
            IAbstractComponentInfo nearestComponentToSide = SnapPoint.getNearestComponentToSide(this.m_components, (int)this.m_moveDirection, (boolean)this.m_isHorizontal, (IVisualDataProvider)this.m_visualDataProvider);
            impl.command_moveFreely(this.m_bounds, this.m_components, nearestComponentToSide, this.m_moveDirection, this.m_isHorizontal);
        }
    }

    private static final class MoveToComponentCommand<C extends IControlInfo>
    extends SnapPointCommand {
        private final IFormLayoutInfo<C> m_layout;

        public MoveToComponentCommand(IFormLayoutInfo<C> layoutInfo, SnapPoint snapPoint) {
            super(layoutInfo.getUnderlyingModel(), snapPoint);
            this.m_layout = layoutInfo;
        }

        protected void executeEdit() throws Exception {
            ComponentSnapPoint snapPoint = (ComponentSnapPoint)this.getSnapPoint();
            int targetSide = snapPoint.getSide();
            int gap = snapPoint.getGap();
            int sourceSide = gap > 0 ? PlacementUtils.getOppositeSide((int)targetSide) : targetSide;
            FormLayoutInfoImplAutomatic impl = (FormLayoutInfoImplAutomatic)this.m_layout.getImpl();
            impl.command_moveAsAttachedToComponent(snapPoint.getWorkingSet(), snapPoint.getNearestBeingSnapped(), sourceSide, snapPoint.getComponent(), targetSide, gap);
        }
    }

    private static final class MoveToContainerCommand<C extends IControlInfo>
    extends SnapPointCommand {
        private final IFormLayoutInfo<C> m_layout;

        public MoveToContainerCommand(IFormLayoutInfo<C> layoutInfo, SnapPoint snapPoint) {
            super(layoutInfo.getUnderlyingModel(), snapPoint);
            this.m_layout = layoutInfo;
        }

        protected void executeEdit() throws Exception {
            SnapPoint snapPoint = this.getSnapPoint();
            int value = snapPoint.getValue();
            FormLayoutInfoImplAutomatic impl = (FormLayoutInfoImplAutomatic)this.m_layout.getImpl();
            impl.command_moveToContainer(snapPoint.getWorkingSet(), snapPoint.getNearestBeingSnapped(), snapPoint.getSide(), value);
        }
    }

    private static final class MoveToPercentCommand<C extends IControlInfo>
    extends SnapPointCommand {
        private final IFormLayoutInfo<C> m_layout;

        public MoveToPercentCommand(IFormLayoutInfo<C> layoutInfo, SnapPoint snapPoint) {
            super(layoutInfo.getUnderlyingModel(), snapPoint);
            this.m_layout = layoutInfo;
        }

        protected void executeEdit() throws Exception {
            PercentageSnapPoint snapPoint = (PercentageSnapPoint)this.getSnapPoint();
            FormLayoutInfoImplAutomatic impl = (FormLayoutInfoImplAutomatic)this.m_layout.getImpl();
            impl.command_moveToPercent(snapPoint.getWorkingSet(), snapPoint.getNearestBeingSnapped(), snapPoint.getSide(), snapPoint.getPercent(), snapPoint.getGap());
        }
    }
}

