/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IHasChildren;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.BundleImageResource;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ImageContainer;
import org.osgi.framework.Bundle;

public class BundleImageContainer
extends ImageContainer
implements IHasChildren {
    private static final String[] PATTERNS = new String[]{".gif", ".png", ".jpg", ".jpeg", ".bmp", ".ico"};
    private final String m_name;
    private final Bundle m_bundle;
    private final String m_symbolicName;
    private final String m_path;
    private IImageElement[] m_resources;
    private boolean m_calculateHasChildren = true;
    private boolean m_hasChildren;

    public BundleImageContainer(String name, Bundle bundle, String symbolicName, String path) {
        this.m_name = name;
        this.m_bundle = bundle;
        this.m_symbolicName = symbolicName;
        this.m_path = path;
    }

    private void ensureResources() {
        if (this.m_resources == null) {
            Enumeration entryPaths = this.m_bundle.getEntryPaths(this.m_path);
            ArrayList<Object> resources = new ArrayList<Object>();
            block0: while (entryPaths.hasMoreElements()) {
                String entry = (String)entryPaths.nextElement();
                if (entry.endsWith("/")) {
                    if (!BundleImageContainer.isContainsResources(this.m_bundle, entry)) continue;
                    String entryName = entry.substring(0, entry.length() - 1);
                    int lastSlashIndex = entryName.lastIndexOf(47);
                    if (lastSlashIndex != -1) {
                        entryName = entryName.substring(lastSlashIndex + 1);
                    }
                    resources.add(new BundleImageContainer(entryName, this.m_bundle, this.m_symbolicName, entry));
                    continue;
                }
                int i = 0;
                while (i < PATTERNS.length) {
                    if (entry.endsWith(PATTERNS[i])) {
                        resources.add(new BundleImageResource(this.m_bundle.getEntry(entry), this.m_symbolicName));
                        continue block0;
                    }
                    ++i;
                }
            }
            this.m_resources = resources.toArray(new IImageElement[resources.size()]);
        }
    }

    private static boolean isContainsResources(Bundle bundle, String path) {
        Enumeration entryPaths = bundle.getEntryPaths(path);
        ArrayList<String> folders = new ArrayList<String>();
        while (entryPaths.hasMoreElements()) {
            String entry = (String)entryPaths.nextElement();
            if (entry.endsWith("/")) {
                folders.add(entry);
                continue;
            }
            int i = 0;
            while (i < PATTERNS.length) {
                if (entry.endsWith(PATTERNS[i])) {
                    return true;
                }
                ++i;
            }
        }
        for (String entry : folders) {
            if (!BundleImageContainer.isContainsResources(bundle, entry)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        try {
            if (this.m_calculateHasChildren) {
                this.m_calculateHasChildren = false;
                this.m_hasChildren = BundleImageContainer.isContainsResources(this.m_bundle, this.m_path);
            }
            return this.m_hasChildren;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public IImageElement[] elements() {
        this.ensureResources();
        return this.m_resources;
    }

    @Override
    protected IImageElement[] directElements() {
        return this.m_resources;
    }

    public Image getImage() {
        return DesignerPlugin.getImage((String)"folder_open.gif");
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean findResource(List<Object> paths, String imagePath) {
        paths.add(this);
        IImageElement[] iImageElementArray = this.elements();
        int n = iImageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImageElement element = iImageElementArray[n2];
            IImageElement iImageElement = element;
            if (iImageElement instanceof BundleImageContainer) {
                void container;
                BundleImageContainer cfr_ignored_0 = (BundleImageContainer)iImageElement;
                BundleImageContainer cfr_ignored_1 = (BundleImageContainer)iImageElement;
                if (container.findResource(paths, imagePath)) {
                    return true;
                }
            } else {
                IImageElement iImageElement2 = element;
                if (iImageElement2 instanceof BundleImageResource) {
                    void resource;
                    BundleImageResource cfr_ignored_2 = (BundleImageResource)iImageElement2;
                    BundleImageResource cfr_ignored_3 = (BundleImageResource)iImageElement2;
                    if (resource.getPath().equals(imagePath)) {
                        paths.add(resource);
                        return true;
                    }
                }
            }
            ++n2;
        }
        paths.remove(this);
        return false;
    }

    @Override
    public Object[] findResource(String symbolicName, String imagePath) {
        return null;
    }
}

