/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.palette.ICategory;
import org.eclipse.wb.core.controls.palette.IEntry;
import org.eclipse.wb.core.controls.palette.IPalette;
import org.eclipse.wb.core.controls.palette.IPalettePreferences;
import org.eclipse.wb.core.controls.palette.PaletteComposite;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.model.entry.IDefaultEntryInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.editor.palette.DesignerPalettePopupActions;
import org.eclipse.wb.internal.core.xml.editor.palette.PaletteEventListener;
import org.eclipse.wb.internal.core.xml.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.xml.editor.palette.PluginPalettePreferences;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryMoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryRemoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.Command;
import org.eclipse.wb.internal.core.xml.editor.palette.command.EntryMoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.EntryRemoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.CategoryAddDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.CategoryEditDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.ComponentAddDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.ComponentEditDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.PaletteManagerDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.PalettePreferencesDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ComponentEntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.EntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.IPaletteSite;
import org.eclipse.wb.internal.core.xml.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ToolEntryInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.core.IDefaultToolProvider;

public class DesignerPalette {
    public static final String FLAG_NO_PALETTE = "FLAG_NO_PALETTE";
    private final boolean m_isMainPalette;
    private final PluginPalettePreferences m_preferences;
    private final PaletteComposite m_paletteComposite;
    private final DesignerPaletteOperations m_operations;
    private IEditPartViewer m_editPartViewer;
    private XmlObjectInfo m_rootObject;
    private PaletteManager m_manager;
    private IEntry m_defaultEntry;
    private final IPaletteSite m_paletteSite = new IPaletteSite(){

        @Override
        public Shell getShell() {
            return DesignerPalette.this.getOperations().getShell();
        }

        @Override
        public PaletteInfo getPalette() {
            return DesignerPalette.this.m_manager.getPalette();
        }

        @Override
        public void addCommand(Command command) {
            DesignerPalette.this.commands_addWrite(command);
        }

        @Override
        public void editPalette() {
            DesignerPalette.this.getOperations().editPalette();
        }
    };
    private final Map<CategoryInfo, ICategory> m_categoryInfoToVisual = new HashMap<CategoryInfo, ICategory>();
    private final Map<ICategory, CategoryInfo> m_visualToCategoryInfo = new HashMap<ICategory, CategoryInfo>();
    private final Map<String, Boolean> m_openCategories = new HashMap<String, Boolean>();
    private final Set<EntryInfo> m_knownEntryInfos = new HashSet<EntryInfo>();
    private final Set<EntryInfo> m_goodEntryInfos = new HashSet<EntryInfo>();
    private final Map<EntryInfo, IEntry> m_entryInfoToVisual = new HashMap<EntryInfo, IEntry>();
    private final Map<IEntry, EntryInfo> m_visualToEntryInfo = new HashMap<IEntry, EntryInfo>();

    public DesignerPalette(Composite parent, int style, boolean isMainPalette) {
        this.m_isMainPalette = isMainPalette;
        this.m_operations = new DesignerPaletteOperations();
        this.m_preferences = new PluginPalettePreferences(DesignerPlugin.getPreferences());
        this.m_paletteComposite = new PaletteComposite(parent, 0);
    }

    public Control getControl() {
        return this.m_paletteComposite;
    }

    public void setInput(IEditPartViewer editPartViewer, final XmlObjectInfo rootObject, String toolkitId) {
        this.m_editPartViewer = editPartViewer;
        this.m_rootObject = rootObject;
        if (this.m_rootObject != null) {
            IJobManager manager = Job.getJobManager();
            manager.cancel((Object)"palette pre-load");
            try {
                manager.join((Object)"palette pre-load", null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_manager = new PaletteManager(this.m_rootObject, toolkitId);
            this.reloadPalette();
            this.m_preferences.setPrefix(toolkitId);
            this.m_paletteComposite.setPreferences((IPalettePreferences)this.m_preferences);
            IPaletteSite.Helper.setSite(this.m_rootObject, this.m_paletteSite);
            rootObject.addBroadcastListener(new ObjectEventListener(){

                public void refreshed() throws Exception {
                    if (DesignerPalette.this.m_paletteComposite.isDisposed()) {
                        rootObject.removeBroadcastListener((Object)this);
                        return;
                    }
                    DesignerPalette.this.refreshVisualPalette();
                }
            });
        }
    }

    private PaletteEventListener getBroadcastPalette() throws Exception {
        return (PaletteEventListener)this.m_rootObject.getBroadcast(PaletteEventListener.class);
    }

    private void reloadPalette() {
        this.m_manager.reloadPalette();
        this.showPalette();
    }

    private void commands_addWrite(Command command) {
        this.commands_addWrite(List.of(command));
    }

    private void commands_addWrite(List<Command> commands) {
        for (Command command : commands) {
            this.m_manager.commands_add(command);
        }
        this.m_manager.commands_write();
        this.refreshVisualPalette();
    }

    private void clearEntryCaches() {
        this.m_categoryInfoToVisual.clear();
        this.m_visualToCategoryInfo.clear();
        this.m_knownEntryInfos.clear();
        this.m_goodEntryInfos.clear();
        this.m_entryInfoToVisual.clear();
        this.m_visualToEntryInfo.clear();
        this.m_defaultEntry = null;
    }

    private IEntry getVisualEntry(final EntryInfo entryInfo) {
        IEntry entry = this.m_entryInfoToVisual.get(entryInfo);
        if (entry == null && !this.m_knownEntryInfos.contains(entryInfo)) {
            this.m_knownEntryInfos.add(entryInfo);
            if (entryInfo.initialize(this.m_editPartViewer, this.m_rootObject)) {
                entry = new IEntry(){

                    public boolean isEnabled() {
                        return entryInfo.isEnabled();
                    }

                    public ImageDescriptor getIcon() {
                        return entryInfo.getIcon();
                    }

                    public String getText() {
                        return entryInfo.getName();
                    }

                    public String getToolTipText() {
                        return entryInfo.getDescription();
                    }

                    public boolean activate(boolean reload) {
                        return entryInfo.activate(reload);
                    }
                };
                this.m_goodEntryInfos.add(entryInfo);
                this.m_entryInfoToVisual.put(entryInfo, entry);
                this.m_visualToEntryInfo.put(entry, entryInfo);
                if (this.m_defaultEntry == null && entryInfo instanceof IDefaultEntryInfo) {
                    this.m_defaultEntry = entry;
                }
            }
        }
        return entry;
    }

    private ICategory getVisualCategory(final CategoryInfo categoryInfo) {
        ICategory category = this.m_categoryInfoToVisual.get(categoryInfo);
        if (category == null) {
            final String categoryId = categoryInfo.getId();
            category = new ICategory(){
                private boolean m_open;

                public List<IEntry> getEntries() {
                    final ArrayList entryInfoList = Lists.newArrayList(categoryInfo.getEntries());
                    ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            DesignerPalette.this.getBroadcastPalette().entries(categoryInfo, entryInfoList);
                        }
                    });
                    ArrayList<IEntry> entries = new ArrayList<IEntry>();
                    for (EntryInfo entryInfo : entryInfoList) {
                        IEntry entry;
                        if (!entryInfo.isVisible() || (entry = DesignerPalette.this.getVisualEntry(entryInfo)) == null) continue;
                        entries.add(entry);
                    }
                    return entries;
                }

                public String getText() {
                    return categoryInfo.getName();
                }

                public String getToolTipText() {
                    return categoryInfo.getDescription();
                }

                public boolean isOpen() {
                    return this.m_open;
                }

                public void setOpen(boolean open) {
                    this.m_open = open;
                    DesignerPalette.this.m_openCategories.put(categoryId, open);
                }
            };
            this.m_categoryInfoToVisual.put(categoryInfo, category);
            this.m_visualToCategoryInfo.put(category, categoryInfo);
            if (this.m_openCategories.containsKey(categoryId)) {
                category.setOpen(this.m_openCategories.get(categoryId).booleanValue());
            } else {
                category.setOpen(categoryInfo.isOpen());
            }
        }
        return category;
    }

    private void showPalette() {
        this.clearEntryCaches();
        IPalette palette = new IPalette(){

            public List<ICategory> getCategories() {
                if (System.getProperty(DesignerPalette.FLAG_NO_PALETTE) != null) {
                    return Collections.emptyList();
                }
                List<CategoryInfo> pristineCategories = DesignerPalette.this.m_manager.getPalette().getCategories();
                final ArrayList categoryInfoList = Lists.newArrayList(pristineCategories);
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        DesignerPalette.this.getBroadcastPalette().categories(categoryInfoList);
                        DesignerPalette.this.getBroadcastPalette().categories2(categoryInfoList);
                    }
                });
                ArrayList<ICategory> categories = new ArrayList<ICategory>();
                for (CategoryInfo categoryInfo : categoryInfoList) {
                    if (!DesignerPalette.this.shouldBeDisplayed(categoryInfo)) continue;
                    ICategory category = DesignerPalette.this.getVisualCategory(categoryInfo);
                    categories.add(category);
                }
                return categories;
            }

            public void addPopupActions(IMenuManager menuManager, Object target, int iconsType) {
                new DesignerPalettePopupActions(DesignerPalette.this.getOperations()).addPopupActions(menuManager, target);
            }

            public void selectDefault() {
                DesignerPalette.this.m_editPartViewer.getEditDomain().loadDefaultTool();
            }

            public void moveCategory(ICategory _category, ICategory _nextCategory) {
                CategoryInfo category = DesignerPalette.this.m_visualToCategoryInfo.get(_category);
                CategoryInfo nextCategory = DesignerPalette.this.m_visualToCategoryInfo.get(_nextCategory);
                DesignerPalette.this.commands_addWrite(new CategoryMoveCommand(category, nextCategory));
            }

            public void moveEntry(IEntry _entry, ICategory _targetCategory, IEntry _nextEntry) {
                EntryInfo entry = DesignerPalette.this.m_visualToEntryInfo.get(_entry);
                CategoryInfo category = DesignerPalette.this.m_visualToCategoryInfo.get(_targetCategory);
                EntryInfo nextEntry = DesignerPalette.this.m_visualToEntryInfo.get(_nextEntry);
                DesignerPalette.this.commands_addWrite(new EntryMoveCommand(entry, category, nextEntry));
            }
        };
        this.m_paletteComposite.setPalette(palette);
        this.configure_EditDomain_DefaultTool();
    }

    private DesignerPaletteOperations getOperations() {
        return this.m_operations;
    }

    private boolean shouldBeDisplayed(CategoryInfo category) {
        if (!category.isVisible()) {
            return false;
        }
        if (category.isOptional()) {
            return !this.getVisualCategory(category).getEntries().isEmpty();
        }
        return true;
    }

    private void configure_EditDomain_DefaultTool() {
        if (this.m_isMainPalette) {
            final EditDomain editDomain = this.m_editPartViewer.getEditDomain();
            editDomain.setDefaultToolProvider(new IDefaultToolProvider(){

                public void loadDefaultTool() {
                    if (DesignerPalette.this.m_defaultEntry != null) {
                        DesignerPalette.this.m_paletteComposite.selectEntry(DesignerPalette.this.m_defaultEntry, false);
                    } else {
                        editDomain.setActiveTool((Tool)new SelectionTool());
                    }
                }
            });
            editDomain.loadDefaultTool();
        }
    }

    private void refreshVisualPalette() {
        this.m_paletteComposite.refreshPalette();
    }

    final class DesignerPaletteOperations {
        DesignerPaletteOperations() {
        }

        public void editPalette() {
            PaletteManagerDialog dialog = new PaletteManagerDialog(DesignerPalette.this.m_rootObject.getContext(), DesignerPalette.this.m_manager.getPalette(), DesignerPalette.this.m_goodEntryInfos);
            DesignerPalette.this.reloadPalette();
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommands());
            }
        }

        public void defaultPalette() {
            DesignerPalette.this.m_manager.commands_clear();
            DesignerPalette.this.m_manager.commands_write();
            DesignerPalette.this.m_openCategories.clear();
            DesignerPalette.this.reloadPalette();
        }

        public void editPreferences() {
            PalettePreferencesDialog dialog = new PalettePreferencesDialog(this.getShell(), DesignerPalette.this.m_preferences);
            if (dialog.open() == 0) {
                dialog.commit();
                DesignerPalette.this.m_paletteComposite.setPreferences((IPalettePreferences)DesignerPalette.this.m_preferences);
            }
        }

        public EntryInfo getEntry(Object target) {
            return DesignerPalette.this.m_visualToEntryInfo.get(target);
        }

        public CategoryInfo getCategory(Object target) {
            return DesignerPalette.this.m_visualToCategoryInfo.get(target);
        }

        public void addComponent(CategoryInfo category) {
            ComponentAddDialog dialog = new ComponentAddDialog(this.getShell(), DesignerPalette.this.m_rootObject.getContext(), DesignerPalette.this.m_manager.getPalette(), category);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        /*
         * WARNING - void declaration
         */
        public void editEntry(ToolEntryInfo targetEntry) {
            ComponentEditDialog dialog = null;
            ToolEntryInfo toolEntryInfo = targetEntry;
            if (toolEntryInfo instanceof ComponentEntryInfo) {
                void entryInfo;
                ComponentEntryInfo componentEntryInfo = (ComponentEntryInfo)toolEntryInfo;
                ComponentEntryInfo cfr_ignored_0 = (ComponentEntryInfo)toolEntryInfo;
                dialog = new ComponentEditDialog(this.getShell(), DesignerPalette.this.m_rootObject.getContext(), (ComponentEntryInfo)entryInfo);
            }
            if (dialog != null && dialog.open() == 0) {
                DesignerPalette.this.m_entryInfoToVisual.remove(targetEntry);
                DesignerPalette.this.m_knownEntryInfos.remove(targetEntry);
                DesignerPalette.this.m_goodEntryInfos.remove(targetEntry);
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void removeEntry(EntryInfo targetEntry) {
            DesignerPalette.this.commands_addWrite(new EntryRemoveCommand(targetEntry));
        }

        public void addCategory(CategoryInfo nextCategory) {
            CategoryAddDialog dialog = new CategoryAddDialog(this.getShell(), DesignerPalette.this.m_manager.getPalette(), nextCategory);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void editCategory(CategoryInfo targetCategory) {
            CategoryEditDialog dialog = new CategoryEditDialog(this.getShell(), targetCategory);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void removeCategory(CategoryInfo targetCategory) {
            DesignerPalette.this.commands_addWrite(new CategoryRemoveCommand(targetCategory));
        }

        public void importPalette(String path) throws Exception {
            DesignerPalette.this.m_manager.importFrom(path);
            DesignerPalette.this.reloadPalette();
        }

        public void exportPalette(String path) throws Exception {
            DesignerPalette.this.m_manager.exportTo(path);
        }

        public String getToolkitId() {
            return DesignerPalette.this.m_manager.getToolkitId();
        }

        public Shell getShell() {
            return DesignerPalette.this.m_paletteComposite.getShell();
        }
    }
}

