/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description.rules;

import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.description.rules.AbstractDesignerRule;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.xml.sax.Attributes;

public abstract class PropertiesFlagRule
extends AbstractDesignerRule {
    public final void begin(String namespace, String tagName, Attributes attributes) throws Exception {
        String[] names;
        ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
        String namesString = PropertiesFlagRule.getRequiredAttribute((String)tagName, (Attributes)attributes, (String)"names");
        String[] stringArray = names = StringUtils.split((String)namesString);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            for (GenericPropertyDescription propertyDescription : componentDescription.getProperties()) {
                String id = propertyDescription.getId();
                if (!PropertiesFlagRule.matchPropertyId(id, name)) continue;
                this.configure(propertyDescription, attributes);
            }
            ++n2;
        }
    }

    protected abstract void configure(GenericPropertyDescription var1, Attributes var2);

    public static boolean matchPropertyId(String id, String name) {
        if (name.startsWith("m:")) {
            String signaturePrefix = "set" + StringUtils.capitalize((String)name.substring(2)) + "(";
            return PropertiesFlagRule.matchAsSetter(id, signaturePrefix);
        }
        if (name.startsWith("f:")) {
            String fieldName = name.substring(2);
            return PropertiesFlagRule.matchAsField(id, fieldName);
        }
        if (name.indexOf(40) != -1) {
            return PropertiesFlagRule.matchAsSetter(id, name);
        }
        String signaturePrefix = "set" + StringUtils.capitalize((String)name) + "(";
        if (PropertiesFlagRule.matchAsSetter(id, signaturePrefix)) {
            return true;
        }
        return PropertiesFlagRule.matchAsField(id, name);
    }

    private static boolean matchAsSetter(String id, String signaturePrefix) {
        return id.startsWith(signaturePrefix);
    }

    private static boolean matchAsField(String id, String fieldName) {
        return id.equals(fieldName);
    }
}

