/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;

public class DelegatingLayout
extends AbstractLayout {
    private Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();

    @Override
    protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
        Dimension d = new Dimension();
        parent.getChildren().forEach(child -> {
            Dimension dimension2 = d.union(child.getPreferredSize());
        });
        return d;
    }

    @Override
    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    @Override
    public void layout(IFigure parent) {
        for (IFigure iFigure : parent.getChildren()) {
            Locator locator = (Locator)this.constraints.get(iFigure);
            if (locator == null) continue;
            locator.relocate(iFigure);
        }
    }

    @Override
    public void remove(IFigure child) {
        this.constraints.remove(child);
    }

    @Override
    public void setConstraint(IFigure figure, Object constraint) {
        super.setConstraint(figure, constraint);
        if (constraint != null) {
            this.constraints.put(figure, constraint);
        }
    }
}

