/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

class InitialRankSolver
extends GraphVisitor {
    protected DirectedGraph graph;
    protected EdgeList candidates = new EdgeList();
    protected NodeList members = new NodeList();

    InitialRankSolver() {
    }

    @Override
    public void visit(DirectedGraph graph) {
        this.graph = graph;
        graph.edges.resetFlags(false);
        graph.nodes.resetFlags();
        this.solve();
    }

    protected void solve() {
        if (this.graph.nodes.isEmpty()) {
            return;
        }
        NodeList unranked = new NodeList(this.graph.nodes);
        NodeList rankMe = new NodeList();
        while (!unranked.isEmpty()) {
            rankMe.clear();
            int i = 0;
            while (i < unranked.size()) {
                Node node = (Node)unranked.get(i);
                if (node.incoming.isCompletelyFlagged()) {
                    rankMe.add(node);
                    unranked.remove(i);
                    continue;
                }
                ++i;
            }
            if (rankMe.isEmpty()) {
                throw new RuntimeException("Cycle detected in graph");
            }
            for (Node node : rankMe) {
                InitialRankSolver.assignMinimumRank(node);
                node.outgoing.setFlags(true);
            }
        }
        this.connectForest();
    }

    private void connectForest() {
        ArrayList<NodeList> forest = new ArrayList<NodeList>();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        this.graph.nodes.resetFlags();
        for (Node n : this.graph.nodes) {
            if (n.flag) continue;
            NodeList tree = new NodeList();
            stack.push(n);
            while (!stack.isEmpty()) {
                Node neighbor;
                n = (Node)stack.pop();
                n.flag = true;
                tree.add(n);
                for (Edge e : n.incoming) {
                    neighbor = e.source;
                    if (neighbor.flag) continue;
                    stack.push(neighbor);
                }
                for (Edge e : n.outgoing) {
                    neighbor = e.target;
                    if (neighbor.flag) continue;
                    stack.push(neighbor);
                }
            }
            forest.add(tree);
        }
        if (forest.size() > 1) {
            this.graph.forestRoot = new Node("the forest root");
            this.graph.nodes.add(this.graph.forestRoot);
            for (NodeList tree : forest) {
                this.graph.edges.add(new Edge(this.graph.forestRoot, (Node)tree.get(0), 0, 0));
            }
        }
    }

    private static void assignMinimumRank(Node node) {
        int rank = 0;
        for (Edge e : node.incoming) {
            rank = Math.max(rank, e.delta + e.source.rank);
        }
        node.rank = rank;
    }
}

