/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.IDocumentEditor;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.beans.XmlElementBeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.XmlObjectReferenceProvider;

public class AttributeDocumentEditor
implements IDocumentEditor {
    private final BindingInfo m_binding;
    private DocumentAttribute m_attribute;

    public AttributeDocumentEditor(BindingInfo binding) {
        this.m_binding = binding;
    }

    public AttributeDocumentEditor(BindingInfo binding, DocumentAttribute attribute) {
        this.m_binding = binding;
        this.m_attribute = attribute;
    }

    private String getValue() throws Exception {
        StringBuffer value = new StringBuffer("{Binding ");
        if (this.m_binding.getModel() instanceof WidgetBindableInfo) {
            WidgetBindableInfo model = (WidgetBindableInfo)this.m_binding.getModel();
            String modelProperty = this.m_binding.getModelProperty().getPresentation().getText();
            value.append(" elementName=" + model.getReference() + ", Path=" + modelProperty);
        } else {
            BindableInfo modelProperty = (BindableInfo)this.m_binding.getModelProperty();
            Object property = StringUtils.remove((String)modelProperty.getReference(), (char)'\"');
            XmlElementBeanBindableInfo model = (XmlElementBeanBindableInfo)this.m_binding.getModel();
            if (!model.isDataContext()) {
                property = "{StaticResource " + (String)property + "}";
            }
            value.append(" Path=" + (String)property);
        }
        if (this.m_binding.getMode() != 0) {
            value.append(", Mode=" + BindingInfo.MODES[this.m_binding.getMode()]);
        }
        if (this.m_binding.getTriger() != 0) {
            value.append(", updateSourceTrigger=" + BindingInfo.TRIGGERS[this.m_binding.getTriger()]);
        }
        this.m_binding.getConverter().appendValue(value);
        this.m_binding.getValidator().appendValue(value);
        value.append("}");
        return value.toString();
    }

    @Override
    public void add() throws Exception {
        this.m_binding.modify(new RunnableEx(){

            public void run() throws Exception {
                if (AttributeDocumentEditor.this.m_binding.getModel() instanceof WidgetBindableInfo) {
                    WidgetBindableInfo model = (WidgetBindableInfo)AttributeDocumentEditor.this.m_binding.getModel();
                    XmlObjectReferenceProvider.generateName(model.getXMLObjectInfo());
                }
                String property = AttributeDocumentEditor.this.m_binding.getTargetProperty().getPresentation().getText();
                DocumentElement element = AttributeDocumentEditor.this.m_binding.getTargetElement();
                AttributeDocumentEditor.this.m_attribute = element.setAttribute(property, AttributeDocumentEditor.this.getValue());
                AttributeDocumentEditor.this.m_binding.getConverter().applyChanges((AbstractDocumentObject)AttributeDocumentEditor.this.m_attribute);
                AttributeDocumentEditor.this.m_binding.getValidator().applyChanges((AbstractDocumentObject)AttributeDocumentEditor.this.m_attribute);
            }
        });
    }

    @Override
    public void delete() throws Exception {
        this.m_binding.modify(new RunnableEx(){

            public void run() throws Exception {
                AttributeDocumentEditor.this.m_binding.getTargetElement().removeDocumentAttribute(AttributeDocumentEditor.this.m_attribute);
            }
        });
    }

    @Override
    public void update() throws Exception {
        final String value = this.getValue();
        if (!value.equals(this.m_attribute.getValue())) {
            this.m_binding.modify(new RunnableEx(){

                public void run() throws Exception {
                    AttributeDocumentEditor.this.m_attribute.setValue(value);
                    AttributeDocumentEditor.this.m_binding.getConverter().applyChanges((AbstractDocumentObject)AttributeDocumentEditor.this.m_attribute);
                    AttributeDocumentEditor.this.m_binding.getValidator().applyChanges((AbstractDocumentObject)AttributeDocumentEditor.this.m_attribute);
                }
            });
        }
    }

    @Override
    public int getDefinitionOffset() {
        return this.m_attribute == null ? -1 : this.m_attribute.getValueOffset();
    }
}

