/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class IntegerEvaluator
implements IExpressionEvaluator {
    /*
     * WARNING - void declaration
     */
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("int".equals(typeQualifiedName)) {
            Expression expression2;
            InfixExpression operator;
            Expression expression3;
            PostfixExpression operator2;
            Expression expression4 = expression;
            if (expression4 instanceof NumberLiteral) {
                void numberLiteral;
                NumberLiteral numberLiteral2 = (NumberLiteral)expression4;
                NumberLiteral cfr_ignored_0 = (NumberLiteral)expression4;
                String token = numberLiteral.getToken();
                if (token.startsWith("0x")) {
                    return Integer.valueOf(token.substring(2), 16);
                }
                if (token.startsWith("0")) {
                    return Integer.valueOf(token, 8);
                }
                return Integer.valueOf(token);
            }
            Expression expression5 = expression;
            if (expression5 instanceof PrefixExpression) {
                void prefixExpression;
                PrefixExpression token = (PrefixExpression)expression5;
                PrefixExpression cfr_ignored_1 = (PrefixExpression)expression5;
                operator2 = prefixExpression.getOperator();
                Expression operand = prefixExpression.getOperand();
                int operandValue = IntegerEvaluator.getIntegerValue(context, operand);
                if (operator2 == PrefixExpression.Operator.PLUS) {
                    return operandValue;
                }
                if (operator2 == PrefixExpression.Operator.MINUS) {
                    return -operandValue;
                }
                if (operator2 == PrefixExpression.Operator.COMPLEMENT) {
                    return ~operandValue;
                }
            }
            if ((expression3 = expression) instanceof PostfixExpression) {
                void postfixExpression;
                operator2 = (PostfixExpression)expression3;
                PostfixExpression cfr_ignored_2 = (PostfixExpression)expression3;
                operator = postfixExpression.getOperator();
                Expression operand = postfixExpression.getOperand();
                ExecutionFlowDescription flowDescription = context.getFlowDescription();
                ExpressionValue value = ExecutionFlowUtils2.getValuePrev(flowDescription, operand);
                if (value != null) {
                    operand = value.getExpression();
                }
                int operandValue = IntegerEvaluator.getIntegerValue(context, operand);
                if (operator == PostfixExpression.Operator.INCREMENT) {
                    return operandValue + 1;
                }
                if (operator == PostfixExpression.Operator.DECREMENT) {
                    return operandValue - 1;
                }
            }
            if ((expression2 = expression) instanceof InfixExpression) {
                void infixExpression;
                operator = (InfixExpression)expression2;
                InfixExpression cfr_ignored_3 = (InfixExpression)expression2;
                List<Expression> extendedOperands = DomGenerics.extendedOperands((InfixExpression)infixExpression);
                int[] operands = new int[2 + extendedOperands.size()];
                operands[0] = IntegerEvaluator.getIntegerValue(context, infixExpression.getLeftOperand());
                operands[1] = IntegerEvaluator.getIntegerValue(context, infixExpression.getRightOperand());
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = IntegerEvaluator.getIntegerValue(context, operandExpression);
                    ++i;
                }
                int value = operands[0];
                InfixExpression.Operator operator3 = infixExpression.getOperator();
                int i2 = 1;
                while (i2 < operands.length) {
                    int operand = operands[i2];
                    if (operator3 == InfixExpression.Operator.PLUS) {
                        value += operand;
                    } else if (operator3 == InfixExpression.Operator.MINUS) {
                        value -= operand;
                    } else if (operator3 == InfixExpression.Operator.TIMES) {
                        value *= operand;
                    } else if (operator3 == InfixExpression.Operator.DIVIDE) {
                        value /= operand;
                    } else if (operator3 == InfixExpression.Operator.REMAINDER) {
                        value %= operand;
                    } else if (operator3 == InfixExpression.Operator.OR) {
                        value |= operand;
                    } else if (operator3 == InfixExpression.Operator.XOR) {
                        value ^= operand;
                    } else if (operator3 == InfixExpression.Operator.AND) {
                        value &= operand;
                    } else if (operator3 == InfixExpression.Operator.LEFT_SHIFT) {
                        value <<= operand;
                    } else if (operator3 == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                        value >>= operand;
                    } else if (operator3 == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
                        value >>>= operand;
                    }
                    ++i2;
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private static int getIntegerValue(EvaluationContext context, Expression expression) throws Exception {
        Object value = AstEvaluationEngine.evaluate(context, expression);
        Object object = value;
        if (object instanceof Character) {
            void character;
            Character c = (Character)object;
            Character cfr_ignored_0 = (Character)object;
            return character.charValue();
        }
        Number number = (Number)value;
        return number.intValue();
    }
}

