/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.IKeyRenameStrategy;
import org.eclipse.wb.internal.core.nls.model.KeyToComponentsSupport;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public abstract class AbstractSource {
    protected final JavaInfo m_root;
    protected final IJavaProject m_javaProject;
    private final KeyToComponentsSupport m_keyToComponentsSupport = new KeyToComponentsSupport(true);
    private final Set<String> m_formKeys = new TreeSet<String>();
    private static final String KEY_LOCALE = "KEY_LOCALE";

    public AbstractSource(JavaInfo root) {
        this.m_root = root;
        this.m_javaProject = this.m_root.getEditor().getJavaProject();
    }

    public void attachPossible() throws Exception {
    }

    protected final Set<String> getFormKeys() {
        return this.m_formKeys;
    }

    public KeyToComponentsSupport getKeyToComponentsSupport() {
        return this.m_keyToComponentsSupport;
    }

    public abstract String getTitle() throws Exception;

    public abstract String getTypeTitle() throws Exception;

    public abstract LocaleInfo[] getLocales() throws Exception;

    public abstract Set<String> getKeys() throws Exception;

    public abstract void externalize(JavaInfo var1, GenericProperty var2, String var3) throws Exception;

    public static void setLocaleInfo(JavaInfo javaInfo, LocaleInfo localeInfo) {
        javaInfo.getRoot().putArbitraryValue((Object)KEY_LOCALE, (Object)localeInfo);
    }

    public static LocaleInfo getLocaleInfo(JavaInfo javaInfo) {
        LocaleInfo localeInfo = (LocaleInfo)javaInfo.getRoot().getArbitraryValue((Object)KEY_LOCALE);
        if (localeInfo == null) {
            localeInfo = LocaleInfo.DEFAULT;
        }
        return localeInfo;
    }

    protected final LocaleInfo getLocaleInfo() {
        return AbstractSource.getLocaleInfo(this.m_root);
    }

    public abstract String getValue(Expression var1) throws Exception;

    public abstract void setValue(Expression var1, String var2) throws Exception;

    public abstract String getKey(Expression var1) throws Exception;

    public abstract boolean isExternallyChanged() throws Exception;

    public abstract IEditableSource getEditable() throws Exception;

    public abstract IKeyRenameStrategy getKeyRenameStrategy();

    public abstract void apply_setValues(LocaleInfo var1, Map<String, String> var2) throws Exception;

    public abstract void apply_renameKeys(Map<String, String> var1) throws Exception;

    public abstract void apply_addKey(String var1) throws Exception;

    public abstract void apply_externalizeProperty(GenericProperty var1, String var2) throws Exception;

    public abstract void apply_internalizeKeys(Set<String> var1) throws Exception;

    public abstract void apply_addLocale(LocaleInfo var1, Map<String, String> var2) throws Exception;

    public abstract void apply_removeLocale(LocaleInfo var1) throws Exception;

    public abstract void replace_toStringLiteral(GenericProperty var1, String var2) throws Exception;

    public abstract void useKey(GenericProperty var1, String var2) throws Exception;

    protected final void onKeyAdd(JavaInfo component, String key) {
        this.m_formKeys.add(key);
        this.m_keyToComponentsSupport.add(component, key);
    }

    protected final void onKeyRename(String oldKey, String newKey) {
        this.m_formKeys.remove(oldKey);
        this.m_formKeys.add(newKey);
        this.m_keyToComponentsSupport.rename(oldKey, newKey);
    }

    protected final void onKeyInternalize(String key) {
        this.m_formKeys.remove(key);
        this.m_keyToComponentsSupport.remove(key);
    }

    public static String generateUniqueKey(HashMap<String, String> keyToValue, String baseKey, String value) {
        if (keyToValue == null || keyToValue.isEmpty()) {
            return baseKey;
        }
        if (!keyToValue.containsKey(baseKey)) {
            return baseKey;
        }
        if (!keyToValue.get(baseKey).equals(value)) {
            int index = 1;
            while (true) {
                String key;
                if (!keyToValue.containsKey(key = baseKey + "_" + index)) {
                    return key;
                }
                ++index;
            }
        }
        return baseKey;
    }

    public static String shrinkText(String text) {
        String strippedOnlyText;
        text = text.replaceAll("[^a-zA-Z0-9\\s]", "");
        text = text.replaceAll("\\r\\n|\\r|\\n|\\t", " ");
        text = StringUtils.stripToEmpty((String)text);
        String shrinkedText = strippedOnlyText = text.replaceAll("\\s{2,}", " ");
        if (strippedOnlyText == null || strippedOnlyText.isEmpty()) {
            return null;
        }
        ArrayList<String> normalWords = new ArrayList<String>();
        String[] words = strippedOnlyText.split(" ");
        if (words.length > 5) {
            int i = 0;
            while (i < words.length) {
                if (words[i].length() > 3) {
                    normalWords.add(words[i]);
                }
                ++i;
            }
            if (normalWords.size() < 5) {
                shrinkedText = strippedOnlyText.replace(" ", "_");
            } else if (normalWords.size() < 10) {
                shrinkedText = StringUtils.join(normalWords, (String)"_");
            } else {
                StringBuilder sb = new StringBuilder();
                int i2 = 0;
                while (i2 < 4) {
                    sb.append(words[i2]);
                    if (i2 < 3) {
                        sb.append("_");
                    }
                    ++i2;
                }
                sb.append("...");
                i2 = words.length - 4;
                while (i2 < words.length) {
                    sb.append(words[i2]);
                    if (i2 < words.length - 1) {
                        sb.append("_");
                    }
                    ++i2;
                }
                shrinkedText = sb.toString();
            }
        } else {
            shrinkedText = strippedOnlyText.replace(" ", "_");
        }
        return shrinkedText;
    }

    protected static String getTypeName(JavaInfo component) {
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(component);
        IPreferenceStore preferences = component.getDescription().getToolkit().getPreferences();
        if (preferences.getBoolean("nls.useQualifiedTypeNameForKey")) {
            return AstNodeUtils.getFullyQualifiedName(typeDeclaration, false);
        }
        return typeDeclaration.getName().getIdentifier();
    }

    protected static void ensureStringLiteral(GenericProperty property) throws Exception {
        Expression expression = property.getExpression();
        if (expression != null) {
            AbstractSource oldSource = NlsSupport.getSource(expression);
            if (oldSource != null) {
                oldSource.replace_toStringLiteral(property, null);
            }
        } else {
            property.setExpression("(java.lang.String) null", Property.UNKNOWN_VALUE);
        }
    }
}

