/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.images;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xwt.tools.ui.designer.core.figures.ImageFigure;
import org.eclipse.xwt.tools.ui.designer.core.images.IImageListener;
import org.eclipse.xwt.tools.ui.designer.core.images.IImageNotifier;

public class ImageFigureController {
    private ImageFigure figure;
    private IImageNotifier imageNotifier;
    private Image image;
    private IImageListener imageListener = new IImageListener(){

        public void imageChanged(Image newImage) {
            ImageFigureController.this.setImage(newImage);
        }
    };

    public void setImageFigure(ImageFigure imageFigure) {
        this.figure = imageFigure;
    }

    public void setImageNotifier(IImageNotifier notifier) {
        if (notifier != null) {
            this.imageNotifier = notifier;
            this.imageNotifier.addImageListener(this.imageListener);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ImageFigureController.this.imageNotifier.refreshImage();
                }
            });
        }
    }

    public void deactivate() {
        if (this.imageNotifier != null) {
            this.imageNotifier.removeImageListener(this.imageListener);
        }
        if (this.figure != null) {
            this.figure.setImage(null);
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void setImage(Image newImage) {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = newImage;
        if (this.figure != null) {
            this.figure.setImage(this.image);
        }
    }
}

