/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.databinding.BindingMode;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.jface.JFacesHelper;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingConstants;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.xwt.tools.ui.designer.databinding.DataContext;
import org.eclipse.xwt.tools.ui.designer.databinding.Observable;
import org.eclipse.xwt.tools.ui.designer.databinding.ObservableUtil;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHelper
implements BindingConstants {
    private static Map<XamlNode, BindingInfo> bindingCache = new HashMap<XamlNode, BindingInfo>();

    public static List<BindingInfo> getBindings(EditPart editPart) {
        if (editPart == null) {
            return Collections.emptyList();
        }
        Widget component = null;
        if (editPart instanceof WidgetEditPart) {
            component = ((WidgetEditPart)editPart).getWidget();
        } else if (editPart instanceof ViewerEditPart) {
            component = ((ViewerEditPart)editPart).getJfaceViewer();
        }
        if (component == null) {
            return Collections.emptyList();
        }
        ArrayList<BindingInfo> bindings = new ArrayList<BindingInfo>();
        BindingHelper.collectBindings(component, bindings);
        return bindings;
    }

    private static void collectBindings(Object component, List<BindingInfo> bindings) {
        if (component == null) {
            return;
        }
        List<BindingInfo> childBindings = BindingHelper.getBindings(component);
        if (childBindings != null) {
            bindings.addAll(childBindings);
        }
        if (JFacesHelper.isViewer((Object)component)) {
            return;
        }
        Viewer viewer = UserData.getLocalViewer((Object)component);
        if (viewer != null) {
            BindingHelper.collectBindings(viewer, bindings);
        }
        if (component instanceof Widget) {
            Widget[] children;
            Widget[] widgetArray = children = SWTTools.getChildren((Widget)((Widget)component));
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Widget widget = widgetArray[n2];
                BindingHelper.collectBindings(widget, bindings);
                ++n2;
            }
        }
    }

    public static List<BindingInfo> getBindings(Object component) {
        XamlNode node = XWTProxy.getModel(component);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<BindingInfo> bindings = new ArrayList<BindingInfo>();
        for (XamlAttribute attribute : node.getAttributes()) {
            BindingInfo binding;
            XamlElement bindNode = attribute.getChild("Binding");
            if (bindNode == null || (binding = BindingHelper.createBindingInfo(component, attribute.getName(), bindNode)) == null) continue;
            bindings.add(binding);
        }
        return bindings;
    }

    private static BindingInfo createBindingInfo(Object targetSource, String propertyName, XamlElement bindingNode) {
        Object modelSource;
        Observable model;
        BindingInfo bindingInfo = bindingCache.get(bindingNode);
        if (bindingInfo != null) {
            return bindingInfo;
        }
        Observable target = ObservableUtil.getObservable(targetSource);
        Property targetProperty = target.getProperty(propertyName);
        String elementName = null;
        String modelPropertyName = null;
        String bindingMode = null;
        String updateTtrigger = null;
        String converter = null;
        XamlAttribute attribute = bindingNode.getAttribute("ElementName");
        if (attribute != null) {
            elementName = attribute.getValue();
        }
        if ((attribute = bindingNode.getAttribute("Path")) != null) {
            modelPropertyName = attribute.getValue();
        }
        if ((attribute = bindingNode.getAttribute("BindingMode")) != null) {
            bindingMode = attribute.getValue();
        }
        if ((attribute = bindingNode.getAttribute("Converter")) != null) {
            converter = attribute.getValue();
        }
        if ((attribute = bindingNode.getAttribute("UpdateSourceTrigger")) != null) {
            updateTtrigger = attribute.getValue();
        }
        if ((model = ObservableUtil.getObservable(modelSource = elementName != null ? XWT.findElementByName((Object)targetSource, (String)elementName) : BindingHelper.getDataContext(targetSource))) == null) {
            return null;
        }
        Property modelProperty = model.getProperty(modelPropertyName);
        bindingInfo = new BindingInfo(new BindingContext(target, targetProperty, model, modelProperty));
        bindingInfo.setElementName(elementName);
        if (bindingMode != null) {
            bindingInfo.setBindingMode(BindingMode.valueOf((String)bindingMode));
        }
        if (updateTtrigger != null) {
            bindingInfo.setTriggerMode(UpdateSourceTrigger.valueOf((String)updateTtrigger));
        }
        bindingInfo.setConverter(converter);
        bindingInfo.setBindingNode(bindingNode);
        bindingCache.put((XamlNode)bindingNode, bindingInfo);
        return bindingInfo;
    }

    public static DataContext getDataContext(Object widget) {
        Map resources;
        Object dataContext;
        block8: {
            if (widget == null) {
                return null;
            }
            dataContext = XWT.getDataContext((Object)widget);
            resources = UserData.getResources((Object)widget);
            if (resources != null) break block8;
            return null;
        }
        try {
            if (dataContext != null && !resources.isEmpty()) {
                Set entrySet = resources.entrySet();
                for (Map.Entry object : entrySet) {
                    Map.Entry entry = object;
                    Object value = entry.getValue();
                    if (!dataContext.equals(value)) continue;
                    Object key = entry.getKey();
                    return new DataContext(key.toString(), value);
                }
            } else {
                Set entrySet = resources.entrySet();
                Iterator iterator = entrySet.iterator();
                if (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    return new DataContext(key.toString(), value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

