/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections.AbstractAttributeSection;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.xwt.tools.ui.designer.utils.FontUtil;

public class FontSection
extends AbstractAttributeSection {
    private CCombo fontFamilyCombo;
    private CCombo fontSizeCombo;
    private Button fontBoldButton;
    private Button fontItalicButton;
    private String fontName;
    private int height;
    private int style;

    public FontSection() {
        this.initDefaults();
    }

    private void initDefaults() {
        try {
            Font systemFont = Display.getCurrent().getSystemFont();
            if (systemFont != null) {
                FontData fd = systemFont.getFontData()[0];
                this.fontName = fd.getName();
                this.height = fd.getHeight();
                this.style = fd.getStyle();
            }
        }
        catch (Exception e) {
            System.out.println();
        }
    }

    protected Control createSection(Composite parent) {
        Composite fontGroup = this.getWidgetFactory().createComposite(parent);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 1;
        fontGroup.setLayout((Layout)layout);
        this.fontFamilyCombo = this.getWidgetFactory().createCCombo(fontGroup, 8);
        this.fontFamilyCombo.setItems(FontUtil.getFontNames());
        this.fontFamilyCombo.setLayoutData((Object)new GridData(768));
        this.fontFamilyCombo.addListener(13, (Listener)this);
        this.fontSizeCombo = this.getWidgetFactory().createCCombo(fontGroup, 8);
        this.fontSizeCombo.setItems(FontUtil.getFontSizes());
        this.fontSizeCombo.addListener(13, (Listener)this);
        this.fontBoldButton = this.getWidgetFactory().createButton(fontGroup, "", 2);
        this.fontBoldButton.setImage(ImageShop.get("/icons/full/tools/bold.gif"));
        this.fontBoldButton.setToolTipText("font bold");
        this.fontBoldButton.addListener(13, (Listener)this);
        this.fontItalicButton = this.getWidgetFactory().createButton(fontGroup, "", 2);
        this.fontItalicButton.setImage(ImageShop.get("/icons/full/tools/italic.gif"));
        this.fontItalicButton.setToolTipText("font italic");
        this.fontItalicButton.addListener(13, (Listener)this);
        return fontGroup;
    }

    public void doRefresh() {
        int index;
        FontData fd = FontUtil.getFontData(this.getValue());
        if (fd != null) {
            this.fontName = fd.getName();
            this.height = fd.getHeight();
            this.style = fd.getStyle();
        } else {
            this.initDefaults();
        }
        if (this.fontFamilyCombo != null && !this.fontFamilyCombo.isDisposed()) {
            this.fontFamilyCombo.removeListener(13, (Listener)this);
            index = this.fontFamilyCombo.indexOf(this.fontName);
            this.fontFamilyCombo.select(index);
            this.fontFamilyCombo.addListener(13, (Listener)this);
        }
        if (this.fontSizeCombo != null && !this.fontSizeCombo.isDisposed()) {
            this.fontSizeCombo.removeListener(13, (Listener)this);
            index = this.fontSizeCombo.indexOf(Integer.toString(this.height));
            this.fontSizeCombo.select(index);
            this.fontSizeCombo.addListener(13, (Listener)this);
        }
        if (this.fontBoldButton != null && !this.fontBoldButton.isDisposed()) {
            this.fontBoldButton.removeListener(13, (Listener)this);
            this.fontBoldButton.setSelection((1 & this.style) != 0);
            this.fontBoldButton.addListener(13, (Listener)this);
        }
        if (this.fontItalicButton != null && !this.fontItalicButton.isDisposed()) {
            this.fontItalicButton.removeListener(13, (Listener)this);
            this.fontItalicButton.setSelection((2 & this.style) != 0);
            this.fontItalicButton.addListener(13, (Listener)this);
        }
        super.refresh();
    }

    protected String getNewValue(Event event) {
        Widget widget = event.widget;
        if (widget == this.fontFamilyCombo) {
            this.fontName = this.fontFamilyCombo.getText();
        } else if (widget == this.fontSizeCombo) {
            String text = this.fontSizeCombo.getText();
            try {
                this.height = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (widget == this.fontBoldButton) {
            this.style = this.fontBoldButton.getSelection() ? (this.style |= 1) : (this.style ^= 1);
        } else if (widget == this.fontItalicButton) {
            this.style = this.fontItalicButton.getSelection() ? (this.style |= 2) : (this.style ^= 2);
        }
        return FontUtil.getFontStr(new FontData(this.fontName, this.height, this.style));
    }

    protected String getAttributeName() {
        return "font";
    }
}

