/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor.jdt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTHelper {
    public static void generateEventHandler(final IType type, final String argumentType, final String handleName) throws Exception {
        ASTHelper helper = new ASTHelper();
        Runnable typeRunner = new Runnable(){

            public void run() {
                try {
                    ASTHelper.this.createEventHandlers(type, handleName, argumentType);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        };
        helper.generateTypeMembers(type, argumentType, true, typeRunner);
    }

    public static void generateInitialization(final IType type, final String method, final Set<String> fieldNames) throws Exception {
        ASTHelper helper = new ASTHelper();
        Runnable typeRunner = new Runnable(){

            public void run() {
                try {
                    ASTHelper.this.createInitializeMembers(type, method, fieldNames);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        };
        helper.generateTypeMembers(type, null, true, typeRunner);
    }

    public void generateTypeMembers(IType type, String argumentType, boolean needsSave, Runnable typeRunner) throws Exception {
        int indent = 0;
        NullProgressMonitor monitor = new NullProgressMonitor();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)type.getJavaProject());
        ICompilationUnit cu = type.getCompilationUnit();
        cu.becomeWorkingCopy((IProgressMonitor)monitor);
        CompilationUnit astRoot = this.createASTForImports(cu);
        Set existingImports = this.getExistingImports(astRoot);
        ImportsManager imports = new ImportsManager(astRoot);
        if (argumentType != null) {
            imports.addImport(argumentType);
        }
        typeRunner.run();
        imports.create(false, (IProgressMonitor)monitor);
        this.removeUnusedImports(cu, existingImports, false);
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        ISourceRange range = type.getSourceRange();
        IBuffer buf = cu.getBuffer();
        String originalContent = buf.getText(range.getOffset(), range.getLength());
        String formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)indent, (String)lineDelimiter, (IJavaProject)type.getJavaProject());
        formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
        if (needsSave) {
            cu.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    private CompilationUnit createASTForImports(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(false);
        parser.setFocalPosition(0);
        return (CompilationUnit)parser.createAST(null);
    }

    private Set getExistingImports(CompilationUnit root) {
        List imports = root.imports();
        HashSet<String> res = new HashSet<String>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            res.add(ASTNodes.asString((ASTNode)((ImportDeclaration)imports.get(i))));
            ++i;
        }
        return res;
    }

    public static void removeUnusedImports(IType type) {
        try {
            ASTHelper helper = new ASTHelper();
            ICompilationUnit cu = type.getCompilationUnit();
            CompilationUnit astRoot = helper.createASTForImports(cu);
            Set existingImports = helper.getExistingImports(astRoot);
            helper.removeUnusedImports(cu, existingImports, true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void removeUnusedImports(ICompilationUnit cu, Set existingImports, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root.getProblems().length == 0) {
            return;
        }
        List importsDecls = root.imports();
        if (importsDecls.isEmpty()) {
            return;
        }
        ImportsManager imports = new ImportsManager(root);
        int importsEnd = ASTNodes.getExclusiveEnd((ASTNode)((ASTNode)importsDecls.get(importsDecls.size() - 1)));
        IProblem[] problems = root.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id;
            IProblem curr = problems[i];
            if (curr.getSourceEnd() < importsEnd && ((id = curr.getID()) == 268435844 || id == 0x1000003)) {
                int pos = curr.getSourceStart();
                int k = 0;
                while (k < importsDecls.size()) {
                    ImportDeclaration decl = (ImportDeclaration)importsDecls.get(k);
                    if (decl.getStartPosition() <= pos && pos < decl.getStartPosition() + decl.getLength()) {
                        if (!existingImports.isEmpty() && existingImports.contains(ASTNodes.asString((ASTNode)decl))) break;
                        String name = decl.getName().getFullyQualifiedName();
                        if (decl.isOnDemand()) {
                            name = String.valueOf(name) + ".*";
                        }
                        if (decl.isStatic()) {
                            imports.removeStaticImport(name);
                            break;
                        }
                        imports.removeImport(name);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        imports.create(needsSave, null);
    }

    protected void createEventHandlers(IType type, String method, String argumentType) throws CoreException {
        int lastIndexOf = argumentType.lastIndexOf(".");
        String shortArgTypeName = argumentType.substring(lastIndexOf + 1);
        StringBuffer buf = new StringBuffer();
        String lineDelim = "\n";
        String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)method, (String[])new String[]{"event"}, (String[])new String[0], (String)Signature.createTypeSignature((String)"void", (boolean)true), null, (String)"\n");
        if (comment != null) {
            buf.append(comment);
            buf.append("\n");
        }
        buf.append("public void " + method + "( ");
        buf.append(shortArgTypeName);
        buf.append(" event) {");
        buf.append("\n");
        String content = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)method, (boolean)false, (String)"", (String)"\n");
        if (content != null && content.length() != 0) {
            buf.append(content);
        }
        buf.append("\n");
        buf.append("}");
        type.createMethod(buf.toString(), null, false, null);
    }

    protected void createInitializeMembers(IType type, String method, Set<String> fieldNames) throws CoreException {
        String content;
        IMethod[] methods;
        IMethod init = null;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method2 = iMethodArray[n2];
            if (method2.getElementName().equals(method)) {
                init = method2;
                break;
            }
            ++n2;
        }
        if (init != null) {
            init.delete(false, null);
        }
        StringBuffer buf = new StringBuffer();
        String lineDelim = "\n";
        String comment = "/**\n  * Generated Initialization.\n */";
        if (comment != null) {
            buf.append(comment);
            buf.append("\n");
        }
        buf.append("protected void " + method + " () {");
        buf.append("\n");
        if (fieldNames.isEmpty() && (content = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)method, (boolean)false, (String)"", (String)"\n")) != null && content.length() != 0) {
            buf.append(content);
        }
        for (String fieidName : fieldNames) {
            IField field = type.getField(fieidName);
            if (field == null) continue;
            String initialize = String.valueOf(fieidName) + " = (" + Signature.toString((String)field.getTypeSignature()) + ") findElement(\"" + fieidName + "\");";
            buf.append(initialize);
        }
        buf.append("\n");
        buf.append("}");
        type.createMethod(buf.toString(), null, false, null);
    }

    public static void generateNamedFields(IType type, String fieldType, String fieldName) {
        try {
            ASTHelper helper = new ASTHelper();
            helper.createNamedFields(type, fieldType, fieldName, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createNamedFields(IType type, String fieldType, String fieldName, boolean needSave) throws Exception {
        if (fieldType == null || fieldName == null) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)type.getJavaProject());
        ICompilationUnit cu = type.getCompilationUnit();
        cu.becomeWorkingCopy((IProgressMonitor)monitor);
        CompilationUnit astRoot = this.createASTForImports(cu);
        Set existingImports = this.getExistingImports(astRoot);
        ImportsManager imports = new ImportsManager(astRoot);
        imports.addImport(fieldType);
        this.createField(type, fieldType, fieldName);
        imports.create(false, (IProgressMonitor)monitor);
        this.removeUnusedImports(cu, existingImports, false);
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        ISourceRange range = type.getSourceRange();
        IBuffer buf = cu.getBuffer();
        String originalContent = buf.getText(range.getOffset(), range.getLength());
        String formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)0, (String)lineDelimiter, (IJavaProject)type.getJavaProject());
        formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
        if (needSave) {
            cu.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    private void createField(IType type, String paraType, String paraName) throws Exception {
        int lastIndexOf = paraType.lastIndexOf(".");
        String property = paraType.substring(lastIndexOf + 1);
        if (property == null || property.equals("")) {
            property = paraType;
        }
        String contents = "protected " + property + " " + paraName + ";";
        type.createField(contents, null, false, null);
    }

    public static class ImportsManager {
        private ImportRewrite fImportsRewrite;

        ImportsManager(CompilationUnit astRoot) throws CoreException {
            this.fImportsRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        }

        ICompilationUnit getCompilationUnit() {
            return this.fImportsRewrite.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            return this.fImportsRewrite.addImport(qualifiedTypeName);
        }

        public String addImport(ITypeBinding typeBinding) {
            return this.fImportsRewrite.addImport(typeBinding);
        }

        public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
            return this.fImportsRewrite.addStaticImport(declaringTypeName, simpleName, isField);
        }

        void create(boolean needsSave, IProgressMonitor monitor) throws CoreException {
            TextEdit edit = this.fImportsRewrite.rewriteImports(monitor);
            JavaModelUtil.applyEdit((ICompilationUnit)this.fImportsRewrite.getCompilationUnit(), (TextEdit)edit, (boolean)needsSave, null);
        }

        void removeImport(String qualifiedName) {
            this.fImportsRewrite.removeImport(qualifiedName);
        }

        void removeStaticImport(String qualifiedName) {
            this.fImportsRewrite.removeStaticImport(qualifiedName);
        }
    }
}

