/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.utils;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderHelper {
    public static URL getResourceAsURL(IJavaProject javaProject, String name) {
        IFile file;
        if (javaProject == null) {
            return null;
        }
        HashSet<IJavaProject> visited = new HashSet<IJavaProject>();
        URL url = ClassLoaderHelper.findResourceURL(javaProject, visited, true, name);
        if (url == null && (file = javaProject.getProject().getFile(name)).exists()) {
            url = ClassLoaderHelper.toURL(file.getLocation());
        }
        return url;
    }

    public static byte[] getClassContent(IJavaProject javaProject, String className) {
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        String resourceName = String.valueOf(className.replace('.', '/')) + ".class";
        try {
            IPath outPath = javaProject.getProject().getLocation().removeLastSegments(1).append(javaProject.getOutputLocation());
            outPath = outPath.addTrailingSeparator();
            URL url = ClassLoaderHelper.toURL(outPath.append(resourceName));
            if (url != null) {
                InputStream inputStream = url.openStream();
                byte[] content = new byte[inputStream.available()];
                inputStream.read(content);
                return content;
            }
            IProject[] iProjectArray = javaProject.getProject().getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] content;
                IJavaProject javaReferencedProject;
                IProject project = iProjectArray[n2];
                if (project.isOpen() && (javaReferencedProject = JavaCore.create((IProject)project)).exists() && (content = ClassLoaderHelper.getClassContent(javaReferencedProject, className)) != null) {
                    return content;
                }
                ++n2;
            }
            IType type = javaProject.findType(className);
            if (type != null && type.exists()) {
                if (type.isBinary()) {
                    return type.getClassFile().getBytes();
                }
                IJavaProject typeProject = type.getJavaProject();
                if (!javaProject.equals(typeProject)) {
                    return ClassLoaderHelper.getClassContent(typeProject, className);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static URL[] getClasspathAsURLArray(IJavaProject javaProject) {
        if (javaProject == null) {
            return null;
        }
        HashSet<IJavaProject> visited = new HashSet<IJavaProject>();
        ArrayList<URL> urls = new ArrayList<URL>(20);
        ClassLoaderHelper.collectClasspathURLs(javaProject, urls, visited, true);
        URL[] result = new URL[urls.size()];
        urls.toArray(result);
        return result;
    }

    private static URL findResourceURL(IJavaProject javaProject, Set<IJavaProject> visited, boolean isFirstProject, String name) {
        if (visited.contains(javaProject)) {
            return null;
        }
        visited.add(javaProject);
        try {
            IClasspathEntry[] entries;
            IPath outPath = javaProject.getProject().getLocation().removeLastSegments(1).append(javaProject.getOutputLocation());
            outPath = outPath.addTrailingSeparator();
            URL url = ClassLoaderHelper.toURL(outPath.append(name));
            if (url != null) {
                return url;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url2;
                IPackageFragmentRoot fragment = iPackageFragmentRootArray[n2];
                if (fragment.getKind() == 1 && (url2 = ClassLoaderHelper.toURL(fragment.getResource().getLocation().append(name))) != null) {
                    return url2;
                }
                ++n2;
            }
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getResolvedClasspath(true);
            int n3 = entries.length;
            n = 0;
            while (n < n3) {
                IClasspathEntry entry = iClasspathEntryArray[n];
                switch (entry.getEntryKind()) {
                    case 1: {
                        IClasspathEntry resolveEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                        File file = resolveEntry.getPath().toFile();
                        IPath path = resolveEntry.getPath();
                        if (!file.exists()) {
                            String projectName = path.segment(0);
                            IProject project = javaProject.getProject().getWorkspace().getRoot().getProject(projectName);
                            path = project.getLocation().append(path.removeFirstSegments(1));
                        }
                        String spec = "jar:file:" + path.toString() + "!/" + name;
                        try {
                            URL url2 = new URL(spec);
                            url2.getContent();
                            return url2;
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        URL url3 = ClassLoaderHelper.toURL(outPath.append(name));
                        if (url3 == null) break;
                        return url3;
                    }
                    case 2: {
                        URL url3;
                        if (!isFirstProject && !entry.isExported() || (url3 = ClassLoaderHelper.findResourceURL(ClassLoaderHelper.getJavaProject(entry), visited, false, name)) == null) break;
                        return url3;
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static URL toURL(IPath outPath) {
        File file = outPath.toFile();
        if (file != null && file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void collectClasspathURLs(IJavaProject javaProject, List<URL> urls, Set<IJavaProject> visited, boolean isFirstProject) {
        if (visited.contains(javaProject)) {
            return;
        }
        visited.add(javaProject);
        try {
            IPath outPath = javaProject.getProject().getWorkspace().getRoot().getFullPath().append(javaProject.getOutputLocation());
            outPath = outPath.addTrailingSeparator();
            URL out = ClassLoaderHelper.createFileURL(outPath);
            urls.add(out);
            IClasspathEntry[] entries = null;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getResolvedClasspath(true);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                switch (entry.getEntryKind()) {
                    case 1: 
                    case 4: 
                    case 5: {
                        ClassLoaderHelper.collectClasspathEntryURL(entry, urls);
                        break;
                    }
                    case 2: {
                        if (!isFirstProject && !entry.isExported()) break;
                        ClassLoaderHelper.collectClasspathURLs(ClassLoaderHelper.getJavaProject(entry), urls, visited, false);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }

    private static URL createFileURL(IPath path) {
        URL url = null;
        try {
            url = new URL("file://" + path.toOSString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    private static void collectClasspathEntryURL(IClasspathEntry entry, List<URL> urls) {
        URL url = ClassLoaderHelper.createFileURL(entry.getPath());
        if (url != null) {
            urls.add(url);
        }
    }

    private static IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }
}

