/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor.outline.dnd;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineDropManager;
import org.eclipse.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineNodeTransfer;

public class OutlineDropListener
extends ViewerDropAdapter {
    private OutlineDropManager dropManager;
    private Command dropCommand;

    public OutlineDropListener(TreeViewer viewer, OutlineDropManager dropManager) {
        super((Viewer)viewer);
        this.dropManager = dropManager;
    }

    public boolean performDrop(Object data) {
        return this.dropManager.execute(this.dropCommand);
    }

    protected Object determineTarget(DropTargetEvent event) {
        Object target = super.determineTarget(event);
        if (target instanceof EditPart) {
            target = ((EditPart)target).getModel();
        }
        return target;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (this.dropManager == null || target == null) {
            return false;
        }
        OutlineNodeTransfer transfer = OutlineNodeTransfer.getTransfer();
        IStructuredSelection selection = transfer.getSelection();
        if (selection == null) {
            return false;
        }
        int currentLocation = this.getCurrentLocation();
        switch (currentLocation) {
            case 2: {
                this.dropCommand = this.dropManager.getMoveAfter(selection, target, this.getCurrentOperation());
                break;
            }
            case 1: {
                this.dropCommand = this.dropManager.getMoveBefore(selection, target, this.getCurrentOperation());
                break;
            }
            case 3: {
                this.dropCommand = this.dropManager.getMoveOn(selection, target, this.getCurrentOperation());
            }
        }
        return this.dropCommand != null && this.dropCommand.canExecute();
    }
}

