/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.util.swt;

import java.lang.reflect.Field;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class GridLayoutHelper_30 {
    private Composite fComposite;
    public int[] widths;
    public int[] heights;
    private int[] expandableColumns;
    private int[] expandableRows;
    private Field pixelColumnWidthsFieldProxy;
    private Field pixelRowHeightsFieldProxy;
    private Field expandableColumnsFieldProxy;
    private Field expandableRowsFieldProxy;
    private GridLayout gridLayout;

    public void setComposite(Composite aComposite) {
        this.fComposite = aComposite;
        aComposite.layout();
        this.computeValues();
    }

    private void computeValues() {
        this.gridLayout = (GridLayout)this.fComposite.getLayout();
        this.fComposite.layout();
        if (this.fComposite.getChildren().length == 0) {
            this.heights = new int[0];
            this.widths = this.heights;
            return;
        }
        try {
            if (this.pixelColumnWidthsFieldProxy == null) {
                this.pixelColumnWidthsFieldProxy = this.gridLayout.getClass().getDeclaredField("pixelColumnWidths");
                this.pixelColumnWidthsFieldProxy.setAccessible(true);
            }
            if (this.pixelRowHeightsFieldProxy == null) {
                this.pixelRowHeightsFieldProxy = this.gridLayout.getClass().getDeclaredField("pixelRowHeights");
                this.pixelRowHeightsFieldProxy.setAccessible(true);
            }
            if (this.expandableColumnsFieldProxy == null) {
                this.expandableColumnsFieldProxy = this.gridLayout.getClass().getDeclaredField("expandableColumns");
                this.expandableColumnsFieldProxy.setAccessible(true);
            }
            if (this.expandableRowsFieldProxy == null) {
                this.expandableRowsFieldProxy = this.gridLayout.getClass().getDeclaredField("expandableRows");
                this.expandableRowsFieldProxy.setAccessible(true);
            }
            this.widths = (int[])this.pixelColumnWidthsFieldProxy.get(this.gridLayout);
            this.heights = (int[])this.pixelRowHeightsFieldProxy.get(this.gridLayout);
            this.expandableColumns = (int[])this.expandableColumnsFieldProxy.get(this.gridLayout);
            this.expandableRows = (int[])this.expandableRowsFieldProxy.get(this.gridLayout);
            if (this.expandableColumns.length > 0 || this.expandableRows.length > 0) {
                this.adjustGridDimensions(this.gridLayout);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void adjustGridDimensions(GridLayout gridLayout) {
        int i;
        int i2;
        int availableHorizontal = this.fComposite.getClientArea().width;
        int availableVerical = this.fComposite.getClientArea().height;
        if (this.expandableColumns.length > 0) {
            availableHorizontal -= gridLayout.marginWidth * 2;
            if (this.widths.length >= 2) {
                availableHorizontal -= (this.widths.length - 1) * gridLayout.horizontalSpacing;
            }
            i2 = 0;
            while (i2 < this.widths.length) {
                availableHorizontal -= this.widths[i2];
                ++i2;
            }
            int widthAdjustment = availableHorizontal / this.expandableColumns.length;
            i = 0;
            while (i < this.expandableColumns.length) {
                this.widths[this.expandableColumns[i]] = widthAdjustment + this.widths[this.expandableColumns[i]];
                ++i;
            }
        }
        if (this.expandableRows.length > 0) {
            availableVerical -= gridLayout.marginHeight * 2;
            if (this.heights.length >= 2) {
                availableVerical -= (this.heights.length - 1) * gridLayout.verticalSpacing;
            }
            i2 = 0;
            while (i2 < this.heights.length) {
                availableVerical -= this.heights[i2];
                ++i2;
            }
            int heightAdjustment = availableVerical / this.expandableRows.length;
            i = 0;
            while (i < this.expandableRows.length) {
                this.heights[this.expandableRows[i]] = heightAdjustment + this.heights[this.expandableRows[i]];
                ++i;
            }
        }
    }
}

