/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.XWTDesignerPlugin;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.AdvancedBindingDialog;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.IGroup;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class BindingTableGroup
implements IGroup {
    private static final String[] COLUMNS = new String[]{"Target", "Target Properties", "Model", "Model Properties"};
    private TableViewer viewer;
    private ToolItem editAction;
    private ToolItem deleteAction;
    private ToolItem deleteAllAction;
    private ToolItem gotoAction;
    private CommandStack commandStack;

    public BindingTableGroup(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    @Override
    public Composite createGroup(final Composite parent, int style) {
        Composite group = new Composite(parent, style);
        group.setLayout((Layout)new GridLayout(2, false));
        Composite tableComp = new Composite(group, 0);
        GridData layoutData = new GridData(770);
        tableComp.setLayoutData((Object)layoutData);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        this.viewer = new TableViewer(tableComp, 68100);
        this.viewer.setColumnProperties(COLUMNS);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        Table table = this.viewer.getTable();
        String[] stringArray = COLUMNS;
        int n = COLUMNS.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(table, 0x1000000);
            column.setText(columnName);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnName.length()));
            ++n2;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BindingTableGroup.this.enableActions();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BindingTableGroup.this.edit();
            }
        });
        Composite toolsComp = new Composite(group, 0);
        toolsComp.setLayoutData((Object)new GridData(258));
        toolsComp.setLayout((Layout)new FillLayout());
        ToolBar toolBar = new ToolBar(toolsComp, 0x800200);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (13 != event.type) {
                    return;
                }
                if (event.widget == BindingTableGroup.this.editAction) {
                    BindingTableGroup.this.edit();
                } else if (event.widget == BindingTableGroup.this.deleteAction) {
                    BindingTableGroup.this.delete();
                } else if (event.widget == BindingTableGroup.this.deleteAllAction) {
                    BindingTableGroup.this.deleteAll();
                } else if (event.widget == BindingTableGroup.this.gotoAction) {
                    BindingTableGroup.this.goTo();
                    parent.getShell().setMinimized(true);
                }
            }
        };
        this.editAction = new ToolItem(toolBar, 8);
        this.editAction.setImage(ImageShop.get("/icons/full/tools/binding/binding_edit.png"));
        this.editAction.setToolTipText("Edit");
        this.editAction.setEnabled(false);
        this.editAction.addListener(13, listener);
        new ToolItem(toolBar, 258);
        this.deleteAction = new ToolItem(toolBar, 8);
        this.deleteAction.setToolTipText("Delete");
        this.deleteAction.setImage(ImageShop.get("/icons/full/tools/binding/binding_delete.png"));
        this.deleteAction.setEnabled(false);
        this.deleteAction.addListener(13, listener);
        this.deleteAllAction = new ToolItem(toolBar, 8);
        this.deleteAllAction.setToolTipText("Delete All");
        this.deleteAllAction.setImage(ImageShop.get("/icons/full/tools/binding/binding_remove_all.png"));
        this.deleteAllAction.addListener(13, listener);
        this.deleteAllAction.setEnabled(false);
        new ToolItem(toolBar, 258);
        this.gotoAction = new ToolItem(toolBar, 8);
        this.gotoAction.setImage(ImageShop.get("/icons/full/tools/goto_definition.gif"));
        this.gotoAction.setEnabled(false);
        this.gotoAction.setToolTipText("Go to definition");
        this.gotoAction.addListener(13, listener);
        Point size = toolBar.computeSize(-1, -1);
        layoutData.heightHint = size.y;
        layoutData.minimumHeight = size.y;
        return group;
    }

    private void executeCommand(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        if (this.commandStack == null) {
            command.execute();
        } else {
            this.commandStack.execute(command);
        }
    }

    protected void edit() {
        BindingInfo binding = this.getSelection();
        AdvancedBindingDialog dialog = new AdvancedBindingDialog(new Shell(), binding);
        if (dialog.open() == 0) {
            this.executeCommand(binding.bindWithCommand());
        }
    }

    protected void delete() {
        BindingInfo binding = this.getSelection();
        this.executeCommand(this.computeDeleteCommand(binding));
        this.viewer.remove((Object)binding);
    }

    private Command computeDeleteCommand(final BindingInfo binding) {
        XamlElement bindingNode = binding.getBindingNode();
        if (bindingNode == null) {
            return null;
        }
        final XamlNode parent = bindingNode.getParent();
        if (parent == null) {
            return null;
        }
        parent.eContainer().eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getEventType() == 3 && parent == msg.getNewValue()) {
                    BindingTableGroup.this.viewer.add((Object)binding);
                }
            }
        });
        return binding.deleteWithCommand();
    }

    protected void deleteAll() {
        Object input = this.viewer.getInput();
        if (input instanceof BindingInfo[]) {
            CompoundCommand cmd = new CompoundCommand("Delete All");
            BindingInfo[] bindingInfoArray = (BindingInfo[])input;
            int n = bindingInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                BindingInfo binding = bindingInfoArray[n2];
                Command deleteCmd = this.computeDeleteCommand(binding);
                if (deleteCmd != null && deleteCmd.canExecute()) {
                    cmd.add(deleteCmd);
                }
                ++n2;
            }
            this.executeCommand(cmd.unwrap());
        }
        this.viewer.setInput(null);
    }

    protected void goTo() {
        XWTDesigner designer;
        BindingInfo binding = this.getSelection();
        if (binding == null) {
            return;
        }
        XamlElement bindingNode = binding.getBindingNode();
        if (bindingNode != null && bindingNode.eContainer() != null && (designer = XWTDesignerPlugin.getDefault().getActiveDesigner()) != null) {
            designer.gotoDefinition((EObject)((XamlNode)bindingNode.eContainer()));
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    protected void enableActions() {
        boolean enabled;
        ISelection selection = this.viewer.getSelection();
        boolean bl = enabled = !selection.isEmpty();
        if (this.editAction != null) {
            this.editAction.setEnabled(enabled);
        }
        if (this.deleteAction != null) {
            this.deleteAction.setEnabled(enabled);
        }
        if (this.gotoAction != null) {
            this.gotoAction.setEnabled(enabled);
        }
    }

    public BindingInfo getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            return (BindingInfo)selection.getFirstElement();
        }
        return null;
    }

    @Override
    public void setInput(Object input) {
        if (this.viewer != null) {
            this.viewer.setInput(input);
            if (this.deleteAllAction != null) {
                this.deleteAllAction.setEnabled(true);
            }
        }
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement.getClass().isArray()) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray(new Object[0]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            if (element instanceof BindingInfo) {
                BindingInfo binding = (BindingInfo)element;
                BindingContext bindingContext = binding.getBindingContext();
                IObservable target = bindingContext.getTarget();
                IObservable model = bindingContext.getModel();
                Property targetProperty = bindingContext.getTargetProperty();
                Property modelProperty = bindingContext.getModelProperty();
                switch (columnIndex) {
                    case 0: {
                        return target.getDisplayName();
                    }
                    case 1: {
                        return targetProperty == null ? "" : targetProperty.toString();
                    }
                    case 2: {
                        return model.getDisplayName();
                    }
                    case 3: {
                        return modelProperty == null ? "" : modelProperty.toString();
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

