/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.sash;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.xwt.tools.ui.designer.core.parts.tools.SelectionHandle;
import org.eclipse.xwt.tools.ui.designer.core.util.SashUtil;
import org.eclipse.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.misc.CompositeEditPartHelper;
import org.eclipse.xwt.tools.ui.designer.parts.misc.DragSashTracker;

public class SashMoveableEditPolicy
extends ResizableEditPolicy {
    private SashEditPart editPart;
    private Label label;
    private Point location = new Point();

    public SashMoveableEditPolicy(SashEditPart editPart) {
        this.editPart = editPart;
    }

    protected IFigure createDragSourceFeedbackFigure() {
        this.label = new Label();
        this.label.setForegroundColor(ColorConstants.blue);
        this.getFeedbackLayer().add((IFigure)this.label);
        return super.createDragSourceFeedbackFigure();
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.label != null) {
            this.removeFeedback((IFigure)this.label);
        }
        this.label = null;
    }

    protected List<SelectionHandle> createSelectionHandles() {
        ArrayList<SelectionHandle> list = new ArrayList<SelectionHandle>();
        list.add(new SelectionHandle((GraphicalEditPart)this.editPart));
        ResizableHandleKit.moveHandle((GraphicalEditPart)this.editPart, (DragTracker)new DragSashTracker(this.editPart), null);
        return list;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        int previousWeight;
        int end;
        GraphicalEditPart next;
        int start;
        Rectangle rectangle;
        IFigure figure;
        GraphicalEditPart previous;
        IFigure feedback = this.getDragSourceFeedbackFigure();
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.editPart.isHorizontal());
        Rectangle rect = this.getInitialFeedbackBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect = transposer.t(rect);
        Point moveDelta = request.getMoveDelta().getCopy();
        moveDelta = transposer.t(moveDelta);
        rect.performTranslate(0, moveDelta.y);
        SashFormEditPart sashFormEditPart = (SashFormEditPart)this.editPart.getParent();
        List<ControlEditPart> children = CompositeEditPartHelper.getChildren(sashFormEditPart);
        SashForm sashForm = (SashForm)sashFormEditPart.getWidget();
        int[] weights = sashForm.getWeights();
        int index = children.indexOf((Object)this.editPart);
        if (index - 2 < 0) {
            previous = (GraphicalEditPart)children.get(0);
            figure = previous.getFigure();
            rectangle = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rectangle);
            rectangle = transposer.t(rectangle);
            start = rectangle.y;
        } else {
            previous = (GraphicalEditPart)children.get(index - 2);
            figure = previous.getFigure();
            rectangle = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rectangle);
            rectangle = transposer.t(rectangle);
            start = rectangle.y + rectangle.height;
        }
        if (index + 2 > children.size() - 1) {
            next = (GraphicalEditPart)children.get(children.size() - 1);
            figure = next.getFigure();
            rectangle = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rectangle);
            rectangle = transposer.t(rectangle);
            end = rectangle.y + rectangle.height;
        } else {
            next = (GraphicalEditPart)children.get(index + 2);
            figure = next.getFigure();
            rectangle = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rectangle);
            rectangle = transposer.t(rectangle);
            end = rectangle.y;
        }
        if (rect.y < start) {
            rect.y = start;
        }
        if (rect.y + rect.height > end) {
            rect.y = end - rect.height;
        }
        int weightIndex = index / 2;
        int total = weights[weightIndex] + weights[weightIndex + 1];
        weights[weightIndex] = previousWeight = (rect.y - start) * total / (end - start - rect.height);
        weights[weightIndex + 1] = total - previousWeight;
        this.label.setText(SashUtil.weightsDisplayString((int[])weights));
        Dimension dimension = this.label.getPreferredSize();
        this.label.setSize(dimension);
        dimension = transposer.t(dimension);
        this.location.y = rect.y + 10;
        this.location.x = rect.x + (rect.width - dimension.width) / 2;
        this.location = transposer.t(this.location);
        rect = transposer.t(rect);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds(rect);
        this.label.translateToRelative((Translatable)this.location);
        this.label.setLocation(this.location);
    }
}

