/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.layouts.control;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditorEvent;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditorListener;

public abstract class FieldEditor {
    protected String fieldName;
    protected String labelText;
    private Control editor;
    private List<FieldEditorListener> listeners;
    private boolean updating;
    private boolean dispatching;

    protected FieldEditor() {
    }

    protected FieldEditor(String fieldName, String labelText, Composite parent) {
        this.init(fieldName, labelText);
        this.createControl(parent);
    }

    protected void createControl(Composite parent) {
        this.editor = this.createEditor(parent);
    }

    protected void init(String fieldName, String labelText) {
        Assert.isNotNull((Object)fieldName);
        this.fieldName = fieldName;
        this.labelText = labelText;
    }

    public Control getEditor() {
        return this.editor;
    }

    public void apply(Object source) {
        if (!this.isValid() || source == null) {
            return;
        }
        try {
            Field field = source.getClass().getField(this.fieldName);
            Object value = field.get(source);
            this.doUpdate(value == null ? "" : value.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isValid() {
        return this.editor != null && !this.editor.isDisposed() && !this.dispatching;
    }

    protected void doUpdate(String newValue) {
        this.updating = true;
        this.update(newValue == null ? "" : newValue);
        this.updating = false;
    }

    protected void dispatchEvent(String oldValue, String newValue) {
        if (this.listeners == null || this.updating || oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.dispatching = true;
        FieldEditorEvent event = new FieldEditorEvent(this, this.fieldName, oldValue, newValue);
        for (FieldEditorListener l : this.listeners) {
            if (event.doit) break;
            l.handleEvent(event);
        }
        this.dispatching = false;
    }

    public void addListener(FieldEditorListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<FieldEditorListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(FieldEditorListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected void adapt(Control control) {
        control.setBackground(control.getDisplay().getSystemColor(1));
    }

    protected abstract void update(String var1);

    protected abstract Control createEditor(Composite var1);
}

