/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.xwt.converters.StringToInteger;
import org.eclipse.xwt.jface.ComboBoxCellEditor;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.commands.SetStyleCommand;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.core.properties.editors.BooleanCellEditor;
import org.eclipse.xwt.tools.ui.designer.core.style.SWTStyles;
import org.eclipse.xwt.tools.ui.designer.core.style.StyleGroup;
import org.eclipse.xwt.tools.ui.designer.utils.StyleHelper;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class StylePropertyHelper {
    private static final String CATEGORY = "Style";
    private static final String PREFIX_STAR = "*";
    private XamlNode model;
    private EditDomain editDomain;

    public StylePropertyHelper(XamlNode model) {
        this.model = model;
    }

    public List<IPropertyDescriptor> createPropertyDescriptors() {
        StyleGroup[] styleGrps;
        if (this.model == null) {
            return Collections.emptyList();
        }
        IMetaclass metaclass = XWTUtility.getMetaclass(this.model);
        if (metaclass == null) {
            return Collections.emptyList();
        }
        Class type = metaclass.getType();
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        StyleGroup[] styleGroupArray = styleGrps = SWTStyles.getStyles((Class)type);
        int n = styleGrps.length;
        int n2 = 0;
        while (n2 < n) {
            StyleGroup styleGroup = styleGroupArray[n2];
            if (styleGroup.match(type)) {
                String groupName = styleGroup.getGroupName();
                String[] styles = styleGroup.getStyles();
                if ("default".equals(groupName)) {
                    String[] stringArray = styles;
                    int n3 = styles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String style = stringArray[n4];
                        descriptors.add(this.createDescriptor(style));
                        ++n4;
                    }
                } else {
                    descriptors.add(this.createDescriptor(styleGroup));
                }
            }
            ++n2;
        }
        return descriptors;
    }

    private IPropertyDescriptor createDescriptor(final StyleGroup styleGroup) {
        PropertyDescriptor descriptor = new PropertyDescriptor(styleGroup, styleGroup.getGroupName()){

            public CellEditor createPropertyEditor(Composite parent) {
                return new ComboBoxCellEditor(parent, styleGroup.getStyles());
            }
        };
        descriptor.setCategory(CATEGORY);
        return descriptor;
    }

    private IPropertyDescriptor createDescriptor(String style) {
        PropertyDescriptor descriptor = new PropertyDescriptor(PREFIX_STAR + style, style.toLowerCase()){

            public CellEditor createPropertyEditor(Composite parent) {
                return new BooleanCellEditor(parent);
            }
        };
        descriptor.setCategory(CATEGORY);
        return descriptor;
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        if (id.toString().startsWith(PREFIX_STAR)) {
            String style = id.toString().substring(1);
            int intStyle = (Integer)StringToInteger.instance.convert((Object)style);
            if (StyleHelper.checkStyle(this.model, intStyle)) {
                return "true";
            }
            return "false";
        }
        if (id instanceof StyleGroup) {
            StyleGroup styles = (StyleGroup)id;
            String[] stringArray = styles.getStyles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String style = stringArray[n2];
                int intStyle = (Integer)StringToInteger.instance.convert((Object)style);
                if (StyleHelper.checkStyle(this.model, intStyle)) {
                    return style;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == null || this.model == null) {
            return;
        }
        SetStyleCommand command = null;
        if (id.toString().startsWith(PREFIX_STAR)) {
            String newStyle = id.toString().substring(PREFIX_STAR.length());
            command = new SetStyleCommand(this.model, newStyle, Boolean.FALSE.equals(value));
        } else if (id instanceof StyleGroup) {
            command = new SetStyleCommand(this.model, value.toString(), (StyleGroup)id);
        }
        if (command != null && command.canExecute()) {
            if (this.editDomain != null) {
                this.editDomain.getCommandStack().execute((Command)command);
            } else {
                command.execute();
            }
        }
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
    }
}

