/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.palette;

import java.util.List;
import java.util.Map;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xwt.vex.Activator;
import org.eclipse.xwt.vex.palette.customize.CustomWidgetManager;
import org.eclipse.xwt.vex.palette.part.ToolPaletteDrawer;
import org.eclipse.xwt.vex.toolpalette.Entry;
import org.eclipse.xwt.vex.toolpalette.ToolPaletteFactory;

public class CustomWidgetDrawer {
    public static void addCustomWidgets(PaletteDrawer parentDrawer) {
        Map<CustomWidgetManager.Category, List<CustomWidgetManager.Tool>> widgetMap = CustomWidgetManager.getInstance().getWidgetCategories();
        for (Map.Entry<CustomWidgetManager.Category, List<CustomWidgetManager.Tool>> widgetMapEntry : widgetMap.entrySet()) {
            CustomWidgetManager.Category widgetCategory = widgetMapEntry.getKey();
            List<CustomWidgetManager.Tool> widgetList = widgetMapEntry.getValue();
            if (widgetList.isEmpty()) continue;
            String nameCat = widgetCategory.getName();
            PaletteDrawer componentsDrawer = CustomWidgetDrawer.findPaletteDrawer(parentDrawer, nameCat);
            if (componentsDrawer == null) {
                componentsDrawer = new ToolPaletteDrawer(widgetCategory.getName());
                componentsDrawer.setInitialState(1);
                ImageDescriptor iconCat = CustomWidgetDrawer._getImageDescriptor(widgetCategory.getIcon());
                componentsDrawer.setSmallIcon(iconCat);
                componentsDrawer.setLargeIcon(iconCat);
                parentDrawer.add((PaletteEntry)componentsDrawer);
            }
            for (CustomWidgetManager.Tool widget : widgetList) {
                Entry entry = ToolPaletteFactory.eINSTANCE.createEntry();
                entry.setName(widget.getName());
                entry.setScope(widget.getScope());
                entry.setToolTip(widget.getToolTip());
                entry.setContent(widget.getContent());
                ImageDescriptor icon = CustomWidgetDrawer._getImageDescriptor(widget.getIcon());
                CombinedTemplateCreationEntry paletteEntry = new CombinedTemplateCreationEntry(entry.getName(), entry.getToolTip(), (Object)entry, (CreationFactory)new SimpleFactory(entry.getClass()), icon, icon);
                componentsDrawer.add((PaletteEntry)paletteEntry);
            }
        }
    }

    private static PaletteDrawer findPaletteDrawer(PaletteDrawer parentDrawer, String name) {
        if (name != null) {
            for (Object object : parentDrawer.getChildren()) {
                PaletteDrawer paletteDrawer;
                if (!(object instanceof PaletteDrawer) || !name.equals((paletteDrawer = (PaletteDrawer)object).getLabel())) continue;
                return paletteDrawer;
            }
        }
        return null;
    }

    private static ImageDescriptor _getImageDescriptor(CustomWidgetManager.WidgetIcon widgetIcon) {
        return Activator.getImageDescriptor(widgetIcon.getBundleID(), widgetIcon.getPath());
    }
}

