/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.palette.customize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xwt.vex.Activator;
import org.eclipse.xwt.vex.EditorMessages;
import org.eclipse.xwt.vex.VEXEditor;
import org.eclipse.xwt.vex.palette.CustomPalettePage;
import org.eclipse.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.xwt.vex.palette.customize.model.CustomizeComponent;
import org.eclipse.xwt.vex.palette.part.CustomizePaletteViewer;
import org.eclipse.xwt.vex.toolpalette.Entry;
import org.eclipse.xwt.vex.toolpalette.ToolPalette;
import org.eclipse.xwt.vex.toolpalette.ToolPaletteFactory;
import org.eclipse.xwt.vex.toolpalette.impl.ToolPaletteImpl;
import org.eclipse.xwt.vex.util.ImageHelper;

public class CustomizeComponentFactory {
    private static final String CUSTOMER_COMPONENT_ROOT = "VEX_CUSTOMIZE_COMPONENT_LIST";
    private List<VEXEditor> allVEXEditorList = new ArrayList<VEXEditor>();
    private static final String PREFIX_COMPONENT = "CUSTOMIZE_COMPONENT_";
    private static final String POSTFIX_NAME = "_name";
    private static final String POSTFIX_SCOPE = "_scope";
    private static final String POSTFIX_ICON = "_icon";
    private static final String POSTFIX_LARGE_ICON = "_large_icon";
    private static final String POSTFIX_TOOLTIP = "_tooltip";
    private static final String POSTFIX_CONTENT = "_content";
    private static CustomizeComponentFactory customizeComponentFactory;
    private static List<CustomizeComponent> customizeComponentList;

    static {
        customizeComponentList = new ArrayList<CustomizeComponent>();
    }

    public static CustomizeComponentFactory getCustomizeComponentFactory() {
        if (customizeComponentFactory == null) {
            customizeComponentFactory = new CustomizeComponentFactory();
        }
        return customizeComponentFactory;
    }

    private void refreshVEXEditorList() {
        IEditorReference[] editorList;
        this.allVEXEditorList.clear();
        IEditorReference[] iEditorReferenceArray = editorList = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorList.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorTemp = editorReference.getEditor(false);
            if (editorTemp instanceof VEXEditor) {
                this.allVEXEditorList.add((VEXEditor)editorTemp);
            }
            ++n2;
        }
    }

    private CustomizeComponentFactory() {
        customizeComponentList.addAll(CustomizeComponentFactory.loadCustomizeComponents());
    }

    public static List<CustomizeComponent> loadCustomizeComponents() {
        ArrayList<CustomizeComponent> result = new ArrayList<CustomizeComponent>();
        String customizeComponents = CustomizeComponentFactory.getCustomizeComponentNames();
        if (customizeComponents != null && !customizeComponents.equals("")) {
            List<String> componentNameList = CustomizeComponentFactory.getSubString(customizeComponents);
            for (String componentName : componentNameList) {
                result.add(CustomizeComponentFactory.loadComponent(componentName));
            }
        }
        return result;
    }

    private static String getCustomizeComponentNames() {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        String customizeComponents = preferences.getString(CUSTOMER_COMPONENT_ROOT);
        return customizeComponents;
    }

    private void saveChangeAndRefresh() {
        this.deleteRootComponentPreferenceStorage();
        this.addComponentPreferenceStorage();
        this.refreshPalette();
    }

    private void deleteRootComponentPreferenceStorage() {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue(CUSTOMER_COMPONENT_ROOT, "");
        try {
            ((ScopedPreferenceStore)preferences).save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addComponentPreferenceStorage() {
        if (customizeComponentList.size() > 0) {
            IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
            String customizeComponents = "";
            StringBuilder sb = new StringBuilder();
            for (CustomizeComponent customizeComponent : customizeComponentList) {
                this.updateComponentInPreference(preferences, customizeComponent);
                sb.append(String.valueOf(customizeComponent.getName()) + ",");
            }
            customizeComponents = sb.substring(0, sb.length() - 1);
            preferences.setValue(CUSTOMER_COMPONENT_ROOT, customizeComponents);
            try {
                ((ScopedPreferenceStore)preferences).save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateComponentInPreference(IPreferenceStore preferences, CustomizeComponent customizeComponent) {
        preferences.setValue(CustomizeComponentFactory.getComponentNameKey(customizeComponent.getName()), customizeComponent.getName());
        preferences.setValue(CustomizeComponentFactory.getComponentScopeKey(customizeComponent.getName()), customizeComponent.getScope());
        preferences.setValue(CustomizeComponentFactory.getComponentIconKey(customizeComponent.getName()), customizeComponent.getIcon());
        preferences.setValue(CustomizeComponentFactory.getComponentLargeIconKey(customizeComponent.getName()), customizeComponent.getLargeIcon());
        preferences.setValue(CustomizeComponentFactory.getComponentTooltipKey(customizeComponent.getName()), customizeComponent.getTooptip());
        preferences.setValue(CustomizeComponentFactory.getComponentContentKey(customizeComponent.getName()), customizeComponent.getContent());
        try {
            ((ScopedPreferenceStore)preferences).save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void refreshPalette() {
        this.refreshVEXEditorList();
        for (VEXEditor editor : this.allVEXEditorList) {
            PaletteViewer paletteViewer = ((CustomPalettePage)editor.getVEXEditorPalettePage()).getPaletteViewer();
            PaletteResourceManager tResourceManager = editor.getPaletteResourceManager();
            if (tResourceManager == null) {
                return;
            }
            Resource resource = tResourceManager.getCustomizeResource();
            CustomizePaletteViewer customizePaletteViewer = null;
            Object objectPaletteViewer = paletteViewer.getProperty("Customize_PaletteViewer");
            if (objectPaletteViewer instanceof CustomizePaletteViewer) {
                customizePaletteViewer = (CustomizePaletteViewer)((Object)objectPaletteViewer);
            }
            if (customizePaletteViewer == null) {
                return;
            }
            PaletteRoot root = customizePaletteViewer.getPaletteRoot();
            List paletteChildren = root.getChildren();
            PaletteGroup customizePaletteGroup = null;
            for (Object object : paletteChildren) {
                if (!((PaletteGroup)object).getLabel().equals(EditorMessages.CustomizeComponentFactory_Customize)) continue;
                customizePaletteGroup = (PaletteGroup)object;
                break;
            }
            if (customizePaletteGroup == null) {
                customizePaletteGroup = new PaletteGroup(EditorMessages.CustomizeComponentFactory_Customize);
            }
            List children = customizePaletteGroup.getChildren();
            int count = children.size();
            int i = 0;
            while (i < count) {
                customizePaletteGroup.remove((PaletteEntry)children.get(0));
                ++i;
            }
            root.remove((PaletteEntry)customizePaletteGroup);
            if (customizeComponentList.size() > 0) {
                for (CustomizeComponent customizeComponent : customizeComponentList) {
                    Entry subEntry = ToolPaletteFactory.eINSTANCE.createEntry();
                    subEntry.setName(customizeComponent.getName());
                    subEntry.setScope(customizeComponent.getScope());
                    subEntry.setIcon(customizeComponent.getIcon());
                    subEntry.setLargeIcon(customizeComponent.getLargeIcon());
                    subEntry.setToolTip(customizeComponent.getTooptip());
                    subEntry.setContent(customizeComponent.getContent());
                    CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(subEntry.getName(), subEntry.getToolTip(), (Object)subEntry, (CreationFactory)new SimpleFactory(resource.getClass()), ImageHelper.getImageDescriptor(tResourceManager, subEntry.getIcon()), ImageHelper.getImageDescriptor(tResourceManager, subEntry.getLargeIcon()));
                    customizePaletteGroup.add((PaletteEntry)component);
                }
            }
            root.add((PaletteEntry)customizePaletteGroup);
        }
    }

    public ToolPalette getCustomizeToolPalette() {
        ToolPalette toolPalette = ToolPaletteFactory.eINSTANCE.createToolPalette();
        if (customizeComponentList.size() > 0) {
            for (CustomizeComponent customizeComponent : customizeComponentList) {
                Entry entry = ToolPaletteFactory.eINSTANCE.createEntry();
                entry.setName(customizeComponent.getName());
                entry.setScope(customizeComponent.getScope());
                entry.setIcon(customizeComponent.getIcon());
                entry.setLargeIcon(customizeComponent.getLargeIcon());
                entry.setToolTip(customizeComponent.getTooptip());
                entry.setContent(customizeComponent.getContent());
                toolPalette.getEntries().add((Object)entry);
            }
        }
        return toolPalette;
    }

    public void importCustomizeTool(Resource resource) {
        EList contents = resource.getContents();
        for (EObject object : contents) {
            if (!(object instanceof ToolPaletteImpl)) continue;
            ToolPaletteImpl toolPaletteImpl = (ToolPaletteImpl)object;
            EList<Entry> entries = toolPaletteImpl.getEntries();
            for (Entry entry : entries) {
                CustomizeComponent component = new CustomizeComponent();
                component.setName(entry.getName());
                component.setScope(entry.getScope());
                component.setIcon(entry.getIcon());
                component.setLargeIcon(entry.getLargeIcon());
                component.setTooptip(entry.getToolTip());
                component.setContent(entry.getContent());
                customizeComponentList.add(component);
            }
        }
        this.refreshPalette();
    }

    public List<CustomizeComponent> getComponents() {
        return customizeComponentList;
    }

    public void addComponent(CustomizeComponent component) {
        customizeComponentList.add(component);
        this.saveChangeAndRefresh();
    }

    public void modifyComponent(CustomizeComponent component, String oldName) {
        if (component == null) {
            return;
        }
        for (CustomizeComponent customizeComponent : customizeComponentList) {
            if (!customizeComponent.getName().equals(oldName)) continue;
            customizeComponent.setName(component.getName());
            customizeComponent.setScope(component.getScope());
            customizeComponent.setIcon(component.getIcon());
            customizeComponent.setLargeIcon(component.getLargeIcon());
            customizeComponent.setTooptip(component.getTooptip());
            customizeComponent.setContent(component.getContent());
        }
        this.saveChangeAndRefresh();
    }

    public void deleteComponent(String componentName) {
        if (customizeComponentList.size() > 0) {
            for (CustomizeComponent customizeComponent : customizeComponentList) {
                if (!customizeComponent.getName().equals(componentName)) continue;
                customizeComponentList.remove(customizeComponent);
                break;
            }
            this.saveChangeAndRefresh();
        }
    }

    private static List<String> getSubString(String str) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] parts = str.split(",");
        int i = 0;
        while (i < parts.length) {
            arrayList.add(parts[i]);
            ++i;
        }
        return arrayList;
    }

    private static String getComponentNameKey(String componentName) {
        return PREFIX_COMPONENT + componentName + POSTFIX_NAME;
    }

    private static String getComponentScopeKey(String componentName) {
        return PREFIX_COMPONENT + componentName + POSTFIX_SCOPE;
    }

    private static String getComponentIconKey(String componentName) {
        return PREFIX_COMPONENT + componentName + POSTFIX_ICON;
    }

    private static String getComponentLargeIconKey(String componentName) {
        return PREFIX_COMPONENT + componentName + POSTFIX_LARGE_ICON;
    }

    private static String getComponentTooltipKey(String componentName) {
        return PREFIX_COMPONENT + componentName + POSTFIX_TOOLTIP;
    }

    private static String getComponentContentKey(String componentName) {
        return PREFIX_COMPONENT + componentName + POSTFIX_CONTENT;
    }

    public static CustomizeComponent loadComponent(String componentName) {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        CustomizeComponent component = new CustomizeComponent();
        component.setName(preferences.getString(CustomizeComponentFactory.getComponentNameKey(componentName)));
        component.setScope(preferences.getString(CustomizeComponentFactory.getComponentScopeKey(componentName)));
        component.setIcon(preferences.getString(CustomizeComponentFactory.getComponentIconKey(componentName)));
        component.setLargeIcon(preferences.getString(CustomizeComponentFactory.getComponentLargeIconKey(componentName)));
        component.setTooptip(preferences.getString(CustomizeComponentFactory.getComponentTooltipKey(componentName)));
        component.setContent(preferences.getString(CustomizeComponentFactory.getComponentContentKey(componentName)));
        return component;
    }

    public boolean isComponentExist(String componentName) {
        if (customizeComponentList == null) {
            return false;
        }
        for (CustomizeComponent component : customizeComponentList) {
            if (!component.getName().equals(componentName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getCustomizeComponentNameList() {
        ArrayList<String> customizeComponentNameList = new ArrayList<String>();
        if (customizeComponentList != null) {
            for (CustomizeComponent component : customizeComponentList) {
                String name = component.getName();
                customizeComponentNameList.add(name);
            }
        }
        return customizeComponentNameList;
    }

    public CustomizeComponent getCustomizeComponentByName(String name) {
        CustomizeComponent component = null;
        if (customizeComponentList != null) {
            for (CustomizeComponent comp : customizeComponentList) {
                if (!comp.getName().equals(name)) continue;
                component = comp;
                break;
            }
        }
        return component;
    }
}

