/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.xaml.impl;

import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.xwt.tools.ui.xaml.XamlPackage;
import org.eclipse.xwt.tools.ui.xaml.impl.XamlNodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XamlAttributeImpl
extends XamlNodeImpl
implements XamlAttribute {
    protected static final boolean USE_FLAT_VALUE_EDEFAULT = false;
    protected boolean useFlatValue = false;
    protected static final String GROUP_NAME_EDEFAULT = null;
    protected String groupName = GROUP_NAME_EDEFAULT;

    protected XamlAttributeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XamlPackage.Literals.XAML_ATTRIBUTE;
    }

    @Override
    public boolean isUseFlatValue() {
        return this.useFlatValue;
    }

    @Override
    public void setUseFlatValue(boolean newUseFlatValue) {
        boolean oldUseFlatValue = this.useFlatValue;
        this.useFlatValue = newUseFlatValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldUseFlatValue, this.useFlatValue));
        }
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String newGroupName) {
        if (this.equals(this.groupName, newGroupName)) {
            return;
        }
        String oldGroupName = this.groupName;
        this.groupName = newGroupName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldGroupName, (Object)this.groupName));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isUseFlatValue();
            }
            case 11: {
                return this.getGroupName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setUseFlatValue((Boolean)newValue);
                return;
            }
            case 11: {
                this.setGroupName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setUseFlatValue(false);
                return;
            }
            case 11: {
                this.setGroupName(GROUP_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.useFlatValue;
            }
            case 11: {
                return GROUP_NAME_EDEFAULT == null ? this.groupName != null : !GROUP_NAME_EDEFAULT.equals(this.groupName);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (useFlatValue: ");
        result.append(this.useFlatValue);
        result.append(", groupName: ");
        result.append(this.groupName);
        result.append(')');
        return result.toString();
    }

    @Override
    public Node generate(Document document, Map<String, Object> options) {
        if (document == null) {
            return null;
        }
        Node attrNode = null;
        String name = this.getName();
        String value = this.getValue();
        if (value != null) {
            attrNode = document.createAttributeNS(this.getNamespace(), this.getQualifiedName());
            attrNode.setNodeValue(value);
        } else if (this.isUseFlatValue()) {
            attrNode = document.createAttributeNS(this.getNamespace(), this.getQualifiedName());
            attrNode.setNodeValue("{" + this.getFlatValue() + "}");
        } else if (!this.getAttributes().isEmpty() || !this.getChildNodes().isEmpty()) {
            String parentName = null;
            XamlNode parentElement = null;
            if (this.getParent() != null) {
                parentElement = this.getParent();
                while (parentElement != null) {
                    parentName = parentName == null ? parentElement.getName() : String.valueOf(parentElement.getName()) + "." + parentName;
                    if (parentElement instanceof XamlElement) break;
                    parentElement = parentElement.getParent();
                }
            }
            if (parentName != null) {
                name = String.valueOf(parentName) + "." + name;
            }
            attrNode = document.createElementNS(this.namespace, this.getQualifiedName(name));
            for (XamlAttribute childAttr : this.getAttributes()) {
                Node newAttr = childAttr.generate(document, options);
                if (newAttr == null) continue;
                if (newAttr instanceof Attr) {
                    ((Element)attrNode).setAttributeNode((Attr)newAttr);
                    continue;
                }
                ((Element)attrNode).appendChild(newAttr);
            }
            for (XamlElement childEle : this.getChildNodes()) {
                Node newChild = childEle.generate(document, options);
                if (newChild == null) continue;
                attrNode.appendChild(newChild);
            }
        }
        return attrNode;
    }

    @Override
    public String getFlatValue() {
        EList<XamlElement> childNodes = this.getChildNodes();
        if (childNodes.isEmpty()) {
            return this.getValue();
        }
        return ((XamlElement)this.getChildNodes().get(0)).getFlatValue();
    }
}

