/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor.dnd.palette;

import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.DropAdapter;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.DropContext;
import org.eclipse.xwt.tools.ui.palette.ContextType;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.w3c.dom.Node;

public class PaletteDropAdapter
implements DropAdapter {
    static final int CARET_WIDTH = 2;
    protected int dropCaretOffset = -1;
    protected Designer designer;
    protected LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
    protected DropContext context;
    protected Entry entry;

    public PaletteDropAdapter(Designer designer, DropContext context) {
        this.designer = designer;
        this.context = context;
    }

    public void drop(DropTargetEvent event) {
        Object selection = this.getSelection();
        if (!this.isAccept() || !(selection instanceof Entry)) {
            return;
        }
        final Template template = this.createTemplate(this.entry);
        if (template == null) {
            return;
        }
        Runnable dropRunnable = new Runnable(){

            @Override
            public void run() {
                PaletteDropAdapter.this.drop(template, PaletteDropAdapter.this.dropCaretOffset, 0);
            }
        };
    }

    protected void drop(Template template, int dropCaretOffset, int length) {
    }

    protected Template createTemplate(Entry entry) {
        return new Template(entry.getName(), "", this.getContextType().getName(), entry.getContent(), true);
    }

    protected int getCursorOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public void dragOver(DropTargetEvent event) {
    }

    protected Node getCurrentNode(DropTargetEvent event) {
        return null;
    }

    protected int getCursor(DropTargetEvent event) {
        return 0;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected void refreshCaret(StyledText text, int newOffset) {
        if (newOffset != -1) {
            Point newPos = text.getLocationAtOffset(newOffset);
            int newHeight = text.getLineHeight(newOffset);
            text.redraw(newPos.x, newPos.y, 2, newHeight, false);
        }
    }

    public void setDesigner(Designer editor) {
        this.designer = editor;
    }

    public Designer getDesigner() {
        return this.designer;
    }

    protected Object getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.transfer.getSelection();
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    @Override
    public boolean isAccept() {
        Object selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        return this.isAccept(selection);
    }

    protected boolean isAccept(Object selection) {
        return selection instanceof Entry;
    }

    public void setDropCaretOffset(int dropCaretOffset) {
        this.dropCaretOffset = dropCaretOffset;
    }

    public int getDropCaretOffset() {
        return this.dropCaretOffset;
    }

    @Override
    public ContextType getContextType() {
        return this.entry.getContext();
    }

    @Override
    public String getScope() {
        return this.entry.getScope();
    }
}

