/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.dnd;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.DropContext;
import org.eclipse.xwt.tools.ui.designer.core.util.DomHelper;
import org.w3c.dom.Node;

public class XWTDropContext
extends DropContext {
    private String getNodeName(Node node) {
        String name = node.getNodeName();
        int index = name.indexOf(":");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    protected boolean isKindOf(Node node, String targetType) {
        if (node.getNodeType() == 9) {
            return false;
        }
        String namespace = DomHelper.lookupNamespaceURI((Node)node);
        String tagName = this.getNodeName(node);
        if (tagName.indexOf(".") > 0) {
            tagName = tagName.substring(tagName.lastIndexOf(".") + 1);
            tagName = String.valueOf(Character.toUpperCase(tagName.charAt(0))) + tagName.substring(1);
            namespace = "http://www.eclipse.org/xwt/presentation";
        }
        try {
            return this.isKindOf(tagName, namespace, targetType);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isKindOf(String nodeName, String namespace, String targetType) throws Exception {
        if (nodeName == null || namespace == null || targetType == null) {
            return false;
        }
        if ("Composite".equalsIgnoreCase(targetType)) {
            IMetaclass metaclass = XWT.getMetaclass((String)nodeName, (String)namespace);
            if (metaclass == null) {
                return false;
            }
            return Composite.class.isAssignableFrom(metaclass.getType());
        }
        if ("Control".equalsIgnoreCase(targetType)) {
            IMetaclass metaclass = XWT.getMetaclass((String)nodeName, (String)namespace);
            if (metaclass == null) {
                return false;
            }
            return Control.class.isAssignableFrom(metaclass.getType());
        }
        return targetType.equalsIgnoreCase(nodeName);
    }
}

