/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.source;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xwt.tools.ui.designer.core.ceditor.ISourcePage;
import org.eclipse.xwt.tools.ui.designer.model.XamlDocumentProvider;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;

public class XWTJavaEditor
extends CompilationUnitEditor
implements ISourcePage {
    private IType type;

    public IType getType() {
        return this.type;
    }

    public String getPageName() {
        return "Java";
    }

    public boolean isEnabledFor(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        if (editorInput == null || !(editorInput instanceof FileEditorInput)) {
            return false;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (file == null || !file.exists() || !"xwt".equals(file.getFileExtension())) {
            return false;
        }
        String clr = this.loadCLR(file);
        if (clr == null) {
            return false;
        }
        IProject project = file.getProject();
        IJavaProject create = JavaCore.create((IProject)project);
        try {
            this.type = create.findType(clr);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return this.type != null;
    }

    private String loadCLR(IFile file) {
        XamlDocument document = XamlDocumentProvider.getDocument(file);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        XamlElement root = document.getRootElement();
        XamlAttribute attribute = root.getAttribute("Class", "http://www.eclipse.org/xwt");
        return attribute != null ? attribute.getValue() : null;
    }

    public void configureSourcePage(IEditorPart editorPart) {
        if (this.type == null) {
            return;
        }
        this.setInput((IEditorInput)new FileEditorInput((IFile)this.type.getResource()));
    }
}

