/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Group;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ChangeConstraintCommand;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.core.util.StringUtil;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.policies.layout.ILayoutEditPolicy;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutPolicyHelper;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.xwt.tools.ui.xaml.tools.AnnotationTools;

public class SurroundWithCommand
extends Command {
    protected List<EditPart> selectedObjects;
    protected List<WidgetEditPart> surroundings;
    protected Class<?> type;
    protected EditPart parent;
    protected LayoutType layoutType;
    protected Command executeCommand;

    public SurroundWithCommand(List<EditPart> selectedObjects) {
        this.selectedObjects = selectedObjects;
    }

    public boolean canExecute() {
        if (this.selectedObjects == null || this.selectedObjects.isEmpty()) {
            return false;
        }
        for (EditPart child : this.selectedObjects) {
            EObject object;
            if (this.parent == null) {
                this.parent = child.getParent();
            } else if (this.parent != child.getParent()) {
                return false;
            }
            Object model = child.getModel();
            if (!(model instanceof EObject) || (object = (EObject)model).eContainer() != null) continue;
            return false;
        }
        if (this.parent == null) {
            return false;
        }
        ILayoutEditPolicy layoutEdiPolicy = (ILayoutEditPolicy)this.parent.getAdapter(ILayoutEditPolicy.class);
        if (layoutEdiPolicy == null) {
            return false;
        }
        this.layoutType = layoutEdiPolicy.getType();
        this.surroundings = new ArrayList<WidgetEditPart>();
        if (this.selectedObjects.size() == 1) {
            EditPart editPart = this.selectedObjects.get(0);
            if (!(editPart instanceof WidgetEditPart)) {
                return false;
            }
            if (((WidgetEditPart)editPart).isRoot()) {
                return false;
            }
            this.surroundings.add((WidgetEditPart)editPart);
            return true;
        }
        if (this.layoutType == LayoutType.GridLayout) {
            int min = -1;
            int max = -1;
            XamlNode parentNode = (XamlNode)this.parent.getModel();
            EList childNodes = parentNode.getChildNodes();
            for (EditPart child : this.selectedObjects) {
                XamlNode node = (XamlNode)child.getModel();
                int index = childNodes.indexOf((Object)node);
                min = min == -1 ? index : Math.min(min, index);
                max = max == -1 ? index : Math.max(max, index);
            }
            int i = min;
            while (i <= max) {
                XamlElement child = (XamlElement)childNodes.get(i);
                Object childEp = this.parent.getViewer().getEditPartRegistry().get(child);
                if (AnnotationTools.isAnnotated((XamlNode)child, (String)"Filter_DATA")) {
                    this.surroundings.add((WidgetEditPart)((Object)childEp));
                } else if (this.selectedObjects.contains(childEp)) {
                    this.surroundings.add((WidgetEditPart)((Object)childEp));
                } else {
                    return false;
                }
                ++i;
            }
        } else {
            for (EditPart child : this.selectedObjects) {
                if (!(child instanceof WidgetEditPart)) continue;
                this.surroundings.add((WidgetEditPart)child);
            }
        }
        return this.layoutType != null && !this.surroundings.isEmpty();
    }

    public void execute() {
        XamlNode parentModel = (XamlNode)this.parent.getModel();
        this.sort(this.surroundings, (List<XamlElement>)parentModel.getChildNodes());
        CompoundCommand commands = new CompoundCommand();
        XamlElement newParent = this.createParent();
        if (this.parent instanceof SashFormEditPart) {
            int index = -1;
            for (WidgetEditPart child : this.surroundings) {
                XamlElement castModel = (XamlElement)child.getCastModel();
                if (index == -1) {
                    index = parentModel.getChildNodes().indexOf((Object)castModel);
                }
                XamlElement newChild = (XamlElement)EcoreUtil.copy((EObject)castModel);
                newParent.getChildNodes().add((Object)newChild);
            }
            commands.add((Command)new AddNewChildCommand(parentModel, (XamlNode)newParent, index));
        } else if (LayoutType.NullLayout == this.layoutType) {
            int x = -1;
            int y = -1;
            int right = 0;
            int bottom = 0;
            for (WidgetEditPart child : this.surroundings) {
                Rectangle r = child.getVisualInfo().getBounds();
                x = x == -1 ? r.x : Math.min(x, r.x);
                y = y == -1 ? r.y : Math.min(y, r.y);
                right = Math.max(right, r.right());
                bottom = Math.max(bottom, r.bottom());
            }
            XamlAttribute boundsAttr = XamlFactory.eINSTANCE.createAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
            boundsAttr.setValue(StringUtil.format((Rectangle)new Rectangle(x, y, right - x, bottom - y)));
            newParent.getAttributes().add((Object)boundsAttr);
            for (WidgetEditPart child : this.surroundings) {
                XamlElement castModel = (XamlElement)child.getCastModel();
                Rectangle r = child.getVisualInfo().getBounds().getCopy();
                r.translate(-x, -y);
                XamlElement newChild = (XamlElement)EcoreUtil.copy((EObject)castModel);
                ChangeConstraintCommand cmd = new ChangeConstraintCommand((XamlNode)newChild, r);
                cmd.execute();
                newParent.getChildNodes().add((Object)newChild);
            }
            commands.add((Command)new AddNewChildCommand(parentModel, (XamlNode)newParent));
        } else if (LayoutType.GridLayout == this.layoutType) {
            int numRows = -1;
            int numColumns = 0;
            if (this.surroundings.size() == 1) {
                numColumns = 1;
                numRows = 1;
            } else {
                GridLayoutPolicyHelper helper = new GridLayoutPolicyHelper();
                helper.setHost((CompositeEditPart)this.parent);
                GridLayoutPolicyHelper.GridComponent[][] layoutTable = helper.getLayoutTable();
                int i = 0;
                while (i < layoutTable.length) {
                    GridLayoutPolicyHelper.GridComponent[] cells = layoutTable[i];
                    int row = 0;
                    boolean recorded = false;
                    int j = 0;
                    while (j < cells.length) {
                        GridLayoutPolicyHelper.GridComponent cell = cells[j];
                        XamlNode model = cell.getModel();
                        Object childEp = this.parent.getViewer().getEditPartRegistry().get(model);
                        if (this.surroundings.contains(childEp)) {
                            int spanHeight;
                            if (!recorded) {
                                int span = cell.getSpanWidth();
                                numColumns = span > 1 ? (numColumns += span) : ++numColumns;
                                recorded = true;
                            }
                            row = (spanHeight = cell.getSpanHeight()) > 1 ? (row += spanHeight) : ++row;
                        }
                        ++j;
                    }
                    numRows = Math.max(numRows, row);
                    ++i;
                }
            }
            int index = -1;
            EList childNodes = parentModel.getChildNodes();
            for (WidgetEditPart child : this.surroundings) {
                XamlElement castModel = (XamlElement)child.getCastModel();
                int i = childNodes.indexOf((Object)castModel);
                index = index == -1 ? i : Math.min(index, i);
                XamlElement newChild = (XamlElement)EcoreUtil.copy((EObject)castModel);
                newParent.getChildNodes().add((Object)newChild);
            }
            XamlElement gridLayout = XamlFactory.eINSTANCE.createElement("GridLayout", "http://www.eclipse.org/xwt/presentation");
            XamlAttribute numColumnsAttr = XamlFactory.eINSTANCE.createAttribute("numColumns", "http://www.eclipse.org/xwt/presentation");
            numColumnsAttr.setValue(Integer.toString(numColumns));
            gridLayout.getAttributes().add((Object)numColumnsAttr);
            XamlAttribute gridLayoutAttr = XamlFactory.eINSTANCE.createAttribute("layout", "http://www.eclipse.org/xwt/presentation");
            gridLayoutAttr.getChildNodes().add((Object)gridLayout);
            newParent.getAttributes().add((Object)gridLayoutAttr);
            XamlElement gridData = XamlFactory.eINSTANCE.createElement("GridData", "http://www.eclipse.org/xwt/presentation");
            this.createAttr((XamlNode)gridData, "horizontalAlignment", "SWT.FILL");
            this.createAttr((XamlNode)gridData, "verticalAlignment", "SWT.FILL");
            this.createAttr((XamlNode)gridData, "horizontalSpan", Integer.toString(numColumns));
            this.createAttr((XamlNode)gridData, "verticalSpan", Integer.toString(numRows));
            XamlAttribute gridDataAttr = XamlFactory.eINSTANCE.createAttribute("layoutData", "http://www.eclipse.org/xwt/presentation");
            gridDataAttr.getChildNodes().add((Object)gridData);
            newParent.getAttributes().add((Object)gridDataAttr);
            commands.add((Command)new AddNewChildCommand(parentModel, (XamlNode)newParent, index));
        } else if (LayoutType.RowLayout == this.layoutType || LayoutType.FillLayout == this.layoutType) {
            XamlAttribute a = parentModel.getAttribute("layout");
            if (a != null) {
                XamlAttribute layoutAttr = (XamlAttribute)EcoreUtil.copy((EObject)a);
                newParent.getAttributes().add((Object)layoutAttr);
            }
            int index = -1;
            EList childNodes = parentModel.getChildNodes();
            for (WidgetEditPart child : this.surroundings) {
                XamlElement castModel = (XamlElement)child.getCastModel();
                int i = childNodes.indexOf((Object)castModel);
                index = index == -1 ? i : Math.min(index, i);
                XamlElement newChild = (XamlElement)EcoreUtil.copy((EObject)castModel);
                newParent.getChildNodes().add((Object)newChild);
            }
            commands.add((Command)new AddNewChildCommand(parentModel, (XamlNode)newParent, index));
        }
        ArrayList<XamlNode> forDelete = new ArrayList<XamlNode>();
        for (WidgetEditPart node : this.surroundings) {
            forDelete.add(node.getCastModel());
        }
        commands.add((Command)new DeleteCommand(forDelete));
        this.executeCommand = commands.unwrap();
        if (this.executeCommand.canExecute()) {
            this.executeCommand.execute();
        }
    }

    private void sort(List<WidgetEditPart> surroundings, final List<XamlElement> childNodes) {
        Collections.sort(surroundings, new Comparator<WidgetEditPart>(){

            @Override
            public int compare(WidgetEditPart o1, WidgetEditPart o2) {
                int i1 = childNodes.indexOf(o1.getCastModel());
                int i2 = childNodes.indexOf(o2.getCastModel());
                return i1 - i2;
            }
        });
    }

    private XamlAttribute createAttr(XamlNode parent, String name, String value) {
        XamlAttribute attr = XamlFactory.eINSTANCE.createAttribute(name, "http://www.eclipse.org/xwt/presentation");
        attr.setValue(value);
        parent.getAttributes().add((Object)attr);
        return attr;
    }

    public void undo() {
        this.executeCommand.undo();
    }

    public boolean canUndo() {
        return this.executeCommand != null && this.executeCommand.canUndo();
    }

    protected XamlElement createParent() {
        XamlElement newParent = XamlFactory.eINSTANCE.createElement(this.type.getSimpleName(), "http://www.eclipse.org/xwt/presentation");
        if (Group.class == this.type) {
            XamlAttribute textAttr = XamlFactory.eINSTANCE.createAttribute("text", "http://www.eclipse.org/xwt/presentation");
            textAttr.setValue("New Group");
            newParent.getAttributes().add((Object)textAttr);
        }
        return newParent;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    static class Counter {
        List<Integer> indexes;
        int count = 0;

        Counter() {
        }

        void add(int index, int span) {
            if (this.indexes == null) {
                this.indexes = new ArrayList<Integer>();
            }
            if (this.indexes.contains(index)) {
                return;
            }
            this.indexes.add(index);
            this.count = span == 0 ? ++this.count : (this.count += span);
        }
    }
}

