/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public abstract class LayoutCommandsFactory {
    private EditPart host;

    public LayoutCommandsFactory(EditPart host) {
        this.host = host;
    }

    public EditPart getHost() {
        return this.host;
    }

    public XamlNode getModel() {
        return (XamlNode)this.host.getModel();
    }

    public Command getDeleteCommand(Request request) {
        if (!(request instanceof ForwardedRequest)) {
            return null;
        }
        EditPart sender = ((ForwardedRequest)request).getSender();
        Object model = sender.getModel();
        if (this.isRoot(model)) {
            return null;
        }
        return this.getDeleteCommand(Collections.singletonList(sender));
    }

    private boolean isRoot(Object model) {
        return model != null && model instanceof XamlElement && ((XamlElement)model).eContainer() instanceof XamlDocument;
    }

    public Command getDeleteCommand(List deleteObjects) {
        if (deleteObjects == null || deleteObjects.isEmpty()) {
            return null;
        }
        return new DeleteCommand(deleteObjects);
    }
}

