/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xwt.javabean.metadata.BeanEvent;
import org.eclipse.xwt.metadata.IEvent;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.editor.actions.AddEventHandlerAction;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class EventMenuManager
extends MenuManager {
    private EditPart editpart;
    private XWTDesigner designer;

    static Map<String, List<String>> createEventMap() {
        HashMap<String, List<String>> eventsMap = new HashMap<String, List<String>>();
        ArrayList<String> events = new ArrayList<String>();
        events.add("Active");
        events.add("Close");
        events.add("Deactive");
        events.add("Deiconify");
        events.add("Iconify");
        eventsMap.put("shell", events);
        events = new ArrayList();
        events.add("Move");
        events.add("Resize");
        eventsMap.put("control", events);
        events = new ArrayList();
        events.add("Collapse");
        events.add("Expand");
        eventsMap.put("tree", events);
        events = new ArrayList();
        events.add("Collapse");
        events.add("Expand");
        eventsMap.put("item", events);
        events = new ArrayList();
        events.add("Selection");
        events.add("DefaultSelection");
        eventsMap.put("selection", events);
        events = new ArrayList();
        events.add("FocusIn");
        events.add("FocusOut");
        eventsMap.put("focus", events);
        events = new ArrayList();
        events.add("HardKeyUp");
        events.add("HardKeyDown");
        eventsMap.put("hardKey", events);
        events = new ArrayList();
        events.add("KeyUp");
        events.add("KeyDown");
        eventsMap.put("key", events);
        events = new ArrayList();
        events.add("Traverse");
        eventsMap.put("traverse", events);
        events = new ArrayList();
        events.add("MouseDoubleClick");
        events.add("MouseUp");
        events.add("MouseDown");
        eventsMap.put("mouse", events);
        events = new ArrayList();
        events.add("MouseMove");
        eventsMap.put("mouseMove", events);
        events = new ArrayList();
        events.add("MouseWheel");
        eventsMap.put("mouseWheel", events);
        events = new ArrayList();
        events.add("MouseEnter");
        events.add("MouseEit");
        events.add("MouseHover");
        eventsMap.put("mouseTrack", events);
        events = new ArrayList();
        events.add("Show");
        events.add("Hide");
        eventsMap.put("menu", events);
        events = new ArrayList();
        events.add("EraseItem");
        events.add("MeasureItem");
        events.add("PaintItem");
        eventsMap.put("item", events);
        events = new ArrayList();
        events.add("Arm");
        eventsMap.put("arm", events);
        events = new ArrayList();
        events.add("Dispose");
        eventsMap.put("dispose", events);
        events = new ArrayList();
        events.add("Help");
        eventsMap.put("help", events);
        events = new ArrayList();
        events.add("Paint");
        eventsMap.put("paint", events);
        events = new ArrayList();
        events.add("Settings");
        eventsMap.put("settings", events);
        events = new ArrayList();
        events.add("Verify");
        eventsMap.put("verify", events);
        events = new ArrayList();
        events.add("Modify");
        eventsMap.put("modify", events);
        events = new ArrayList();
        events.add("DragDetect");
        eventsMap.put("dragDetect", events);
        events = new ArrayList();
        events.add("MenuDetect");
        eventsMap.put("menuDetect", events);
        return eventsMap;
    }

    public EventMenuManager(EditPart editpart, XWTDesigner designer) {
        super("Add event handler");
        this.editpart = editpart;
        this.designer = designer;
        this.createMenus(this);
    }

    protected void updateMap(Map<String, List<String>> eventsMap, Collection<String> existingEvents) {
        Set<Map.Entry<String, List<String>>> entrySet = eventsMap.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> value = entry.getValue();
            String[] stringArray = value.toArray(new String[value.size()]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String eventKey = string.toLowerCase();
                if (existingEvents.contains(eventKey)) {
                    value.remove(string);
                }
                ++n2;
            }
        }
    }

    private void createMenus(MenuManager parent) {
        Map<String, List<String>> eventsMap = EventMenuManager.createEventMap();
        ArrayList<Object[]> eventNames = new ArrayList<Object[]>();
        IEvent[] beanEvents = this.getBeanEvents(this.editpart);
        if (beanEvents.length != 0) {
            Object[] name;
            IEvent[] iEventArray = beanEvents;
            int n = beanEvents.length;
            int n2 = 0;
            while (n2 < n) {
                IEvent iEvent = iEventArray[n2];
                name = iEvent.getName().trim();
                if (eventsMap.get(name) != null) {
                    eventNames.add(name);
                } else {
                    System.err.println((String)name + " Not Defined...");
                }
                ++n2;
            }
            Collection<String> collection = this.getEventKeys(this.editpart);
            this.updateMap(eventsMap, collection);
            name = eventsMap.keySet().toArray();
            int n3 = name.length;
            n = 0;
            while (n < n3) {
                Object key = name[n];
                List<String> events = eventsMap.get(key);
                if (events.isEmpty()) {
                    eventsMap.remove(key);
                }
                ++n;
            }
        }
        Collections.sort(eventNames);
        for (String string : eventNames) {
            ImageDescriptor image = ImageShop.getImageDescriptor("/icons/full/tools/event.png");
            MenuManager menu = new MenuManager(string, image, null);
            List<String> events = eventsMap.get(string);
            if (events == null) continue;
            for (String event : events) {
                menu.add((IAction)new AddEventHandlerAction(this.editpart, this.designer, event));
            }
            parent.add((IContributionItem)menu);
        }
    }

    private IEvent[] getBeanEvents(EditPart editpart) {
        IMetaclass metaclass;
        if (editpart == null) {
            return new IEvent[0];
        }
        Object model = editpart.getModel();
        if (model instanceof XamlNode && (metaclass = XWTUtility.getMetaclass((XamlNode)model)) != null) {
            IEvent[] events = metaclass.getEvents();
            ArrayList<IEvent> result = new ArrayList<IEvent>();
            IEvent[] iEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IEvent event = iEventArray[n2];
                if (event instanceof BeanEvent) {
                    result.add(event);
                }
                ++n2;
            }
            return result.toArray(new IEvent[result.size()]);
        }
        return new IEvent[0];
    }

    private Collection<String> getEventKeys(EditPart editpart) {
        XamlNode xamlNode;
        IMetaclass metaclass;
        if (editpart == null) {
            return Collections.EMPTY_LIST;
        }
        Object model = editpart.getModel();
        if (model instanceof XamlNode && (metaclass = XWTUtility.getMetaclass(xamlNode = (XamlNode)model)) != null) {
            IEvent[] events = metaclass.getEvents();
            HashSet<String> result = new HashSet<String>();
            IEvent[] iEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IEvent event = iEventArray[n2];
                String name = event.getName();
                if (this.hasEvent(xamlNode, name)) {
                    result.add(name.toLowerCase());
                }
                ++n2;
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean hasEvent(XamlNode xamlNode, String name) {
        String eventName = name + "Event";
        EList attributes = xamlNode.getAttributes();
        for (XamlAttribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (!eventName.equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }
}

