# GRT Avionics EIS Model 2000G by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var eis2000g_page = [nil, nil, nil, nil, nil, nil, nil];
var eis2000g_checklist = nil;
var eis2000g_display = nil;

var main_pages = [ nil, nil, nil, nil, nil, nil, nil ];
var groupMain = nil;

var base = "/instrumentation/eis2000g/";


var page = "checklist";
var page_n = 0;

var on = 0;

var qnh_hpa = "instrumentation/altimeter/setting-hpa";

var fuel	=	props.globals.getNode("/consumables/fuel/tank/level-lbs");
var engine	=	props.globals.getNode("/engines/engine[0]");
var eng_cht	=	engine.getNode("cht-degf");
var eng_egt	=	engine.getNode("egt-degf");
var eng_rpm	=	engine.getNode("rpm");
var eng_coolant	=	engine.getNode("coolant-degf");
var elec_volts	=	props.globals.getNode("/systems/electrical/volts");
var oat		=	props.globals.getNode("/environment/temperature-degf");
var vs		=	props.globals.getNode("/instrumentation/vertical-speed-indicator/indicated-speed-fpm");
var alt		=	props.globals.getNode("/instrumentation/altimeter/indicated-altitude-ft");
var gs		=	props.globals.getNode("/velocities/groundspeed-kt");
var track	=	props.globals.getNode("/orientation/track-deg");

var disp_btn_p	=	props.globals.getNode("/instrumentation/eis2000g/buttons/display");

var show_eis	=	props.globals.getNode("/sim/model/eis");

var volt_prop = "/systems/electrical/outputs/eis";	#TODO

var home_pos	=	nil;


#roundToNearest function used for alt tape, thanks @Soitanen (737-800)!
var roundToNearest = func(n, m) {
	var x = int(n/m)*m;
	if((math.mod(n,m)) > (m/2) and n > 0)
			x = x + m;
	if((m - (math.mod(n,m))) > (m/2) and n < 0)
			x = x - m;
	return x;
}

var gps_valid = 0; 	# 0 = invalid 1 = valid

var steer = 0.0;
var dist = 0.0;
var bearing = 0.0;

var update_gps = func () {
	var ac_pos = geo.aircraft_position();
	dist = ac_pos.distance_to( home_pos )*M2NM;
	
	if( gs.getValue() > 3 and dist < 200 and dist > 0.0823 ){
		bearing = ac_pos.course_to( home_pos );
		steer = -geo.normdeg180(track.getValue() - bearing);
		
		gps_valid = 1;
	} else {
		gps_valid = 0;
	}	
	
}

var canvas_eis2000g_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "lcd.txf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var hide_main = 0;
		if ( on ) {
			if(page=="main"){
				eis2000g_checklist.page.hide();
				for ( var i=0; i<=6; i=i+1 ){
					if ( i == page_n ){
						eis2000g_page[i].page.show();
						eis2000g_page[i].update();
					} else {
						eis2000g_page[i].page.hide();
					}
				}
			} else if ( page == "checklist" ) {
				eis2000g_checklist.page.show();
				eis2000g_checklist.update();
				hide_main = 1;
			} else {
				eis2000g_checklist.page.hide();
				hide_main = 1;
			}
		} else {
			eis2000g_checklist.page.hide();
			hide_main = 1;
		}
		if ( hide_main ) {
			foreach( var el; eis2000g_page ){
				el.page.hide();
			}
		}
	},
};

main_pages[0] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[0] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm","cht","egt","rpm.label","cht.label","egt.label"];
	},
	update: func() {
		me["rpm"].setText(sprintf("%4d", eng_rpm.getValue() ) );
		me["cht"].setText(sprintf("%3d", eng_cht.getValue() ) );
		me["egt"].setText(sprintf("%4d", eng_egt.getValue() ) );
	}
	
};
main_pages[1] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[1] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["cool","volt","oat"];
	},
	update: func() {
		me["cool"].setText(sprintf("%3d", eng_coolant.getValue())~"°");
		me["volt"].setText(sprintf("%3.1f", elec_volts.getValue()));
		me["oat"].setText(sprintf("%3d", oat.getValue())~"°");
	}
	
};
main_pages[2] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[2] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["fuel","timer","unit"];
	},
	update: func() {
		me["fuel"].setText(sprintf("%2d", fuel.getValue()));
		me["timer"].setText("--:--");
		me["unit"].setText(sprintf("%3d", oat.getValue())~"°");
	}
	
};
main_pages[3] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[3] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm","cool","fuel","cht","alt","vs","vs.arrow","egt"];
	},
	update: func() {
		if( disp_btn_p.getValue() ) {
			me["rpm"].setText("RPM");
			me["cool"].setText("COOL");
			me["fuel"].setText("FUEL");
			me["cht"].setText("CHT");
			
			me["alt"].setText("ALT");
			me["vs"].setText("VS");
			me["vs.arrow"].hide();
			me["egt"].setText("EGT");
		} else {
			me["rpm"].setText(sprintf("%4d", eng_rpm.getValue() ) );
			me["cool"].setText(sprintf("%3d", eng_coolant.getValue())~"°");
			me["fuel"].setText(sprintf("%2d", fuel.getValue()));
			me["cht"].setText(sprintf("%3d", eng_cht.getValue() ) );
			
			me["alt"].setText(sprintf("%5d", alt.getValue() )~"'");
			var vs_v = vs.getValue();
			me["vs"].setText(sprintf("%4d", math.abs(vs_v)));
			me["vs.arrow"].show();
			if ( vs_v < 0 ){
				me["vs.arrow"].setRotation(180*D2R);
			} else {
				me["vs.arrow"].setRotation(0);
			}
			me["egt"].setText(sprintf("%4d", eng_egt.getValue() ) );
		}
	}
	
};
main_pages[4] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[4] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm","cool","cht.1","cht.2","alt","egt.1","egt.2"];
	},
	update: func() {
		if( disp_btn_p.getValue() ) {
			me["rpm"].setText("RPM");
			me["cool"].setText("COOL");
			me["cht.1"].setText("1-");
			me["cht.2"].setText("CHT-2");
			
			me["alt"].setText("ALT");
			me["egt.1"].setText("EGT 1");
			me["egt.2"].setText("EGT 2");
		} else {
			me["rpm"].setText(sprintf("%4d", eng_rpm.getValue() ) );
			me["cool"].setText(sprintf("%3d", eng_coolant.getValue())~"°");
			me["cht.1"].setText(sprintf("%3d", eng_cht.getValue() ) );
			me["cht.2"].setText(sprintf("%3d", eng_cht.getValue() ) );
			
			me["alt"].setText(sprintf("%5d", alt.getValue() )~"'");
			me["egt.1"].setText(sprintf("%4d", eng_egt.getValue() ) );
			me["egt.2"].setText(sprintf("%4d", eng_egt.getValue() ) );
		}
	}
	
};
main_pages[5] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[5] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm","steer","steer.arrow","dist","alt","bearing","groundspeed"];
	},
	update: func() {
		if( disp_btn_p.getValue() ) {
			me["rpm"].setText("RPM");
			me["steer"].setText("STEER");
			me["steer.arrow"].hide();
			me["dist"].setText("DIST");
			me["bearing"].setText("BRG");
			me["alt"].setText("ALT");
			me["groundspeed"].setText("GS");
		} else {
			update_gps();
			me["rpm"].setText(sprintf("%4d", eng_rpm.getValue() ) );
			if ( gps_valid == 1 ) {
				me["steer"].setText(sprintf("%3d", steer));
				me["steer.arrow"].show();
				me["steer.arrow"].setRotation(steer*D2R);
				if( dist < 100 ){
					me["dist"].setText(sprintf("%3.1f", dist));
				} else {
					me["dist"].setText(sprintf("%3d", dist));
				}
				me["bearing"].setText(sprintf("%3d", bearing));
			} else {
				me["steer"].setText("--");
				me["steer.arrow"].hide();
				me["bearing"].setText("---");
			}
			me["alt"].setText(sprintf("%5d", alt.getValue() )~"'");
			
			me["groundspeed"].setText(sprintf("%3d", gs.getValue() )~"'");
		}
	}
	
};
main_pages[6] = {
	new: func(canvas_group, file) {
		var m = { parents: [main_pages[6] , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};

var canvas_eis2000g_checklist = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_eis2000g_checklist , canvas_eis2000g_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["line1","line2"];
	},
	update: func() {
		me["line1"].setText( items[checklist_item][0] );
		me["line2"].setText( items[checklist_item][1] );
	}
	
};


var eis2000g_update = maketimer(0.2, func {
	canvas_eis2000g_base.update();
});


setlistener("sim/signals/fdm-initialized", func {
	eis2000g_display = canvas.new({
		"name": "EIS-2000G",
		"size": [512, 128],
		"view": [512, 128],
		"mipmapping": 1
	});
	eis2000g_display.addPlacement({"node": "eis2000g.display"});
	var groupChecklist = eis2000g_display.createGroup();

	for(var i=0; i<=6; i=i+1){
		eis2000g_page[i] = main_pages[i].new(eis2000g_display.createGroup(), "Aircraft/Dragonfly/Models/Instruments/EIS-2000G/eis2000g_page"~i~".svg");
	}
	eis2000g_checklist = canvas_eis2000g_checklist.new(groupChecklist, "Aircraft/Dragonfly/Models/Instruments/EIS-2000G/eis2000g_checklist.svg");
	eis2000g_update.start();
});


var checklist_item=0;
var items = [ 	["SEATBELTS", "SECURELY BUCKLED"], 
		["FLIGHT CONTROLS", "FREE MOVEMENT"], 
		["PARACHUTE", "REMOVE SAFETY PIN"],
		["FUEL", "SUFFICIENT"], 
		["ENGINE", "WATER MIN 140F/60C"], 
		["ALTIMETER", "ADJUST"], 
		["WIND", "CHECK DIRECTION"], ];
		
var set_item = func ( n ) {
	checklist_item = n;
}

var next_btn = func (){
	if ( page == "checklist" ) {
		if ( checklist_item < size(items)-1 ) {
			checklist_item = checklist_item + 1;
		} else {
			page = "main";
		}
	} else if ( page == "main" ) {
		if ( page_n == 6 ) {
			page_n = 0;
		} else {
			page_n = page_n + 1;
		}
	}
}
var previous_btn = func (){
	if ( page == "checklist" ) {
		checklist_item = math.max(checklist_item - 1, 0);
	} else if ( page == "main" ) {
		if ( page_n == 0 ) {
			page_n = 6;
		} else {
			page_n = page_n - 1;
		}
	}
}
var display_btn = func (){
	if ( page == "checklist" ) {
		page = "main";
		page_n = 0;
	}
}

setlistener(volt_prop, func(i){
	if(i.getValue() >= 8 and on == 0){
		page = "checklist";
		checklist_item = 0;
		on = 1;
	} else if (i.getValue() < 8 and on == 1 ){
		on = 0;
	}
});

setlistener("/sim/signals/fdm-initialized", func () {
	home_pos = geo.aircraft_position();
});

var shown = 0;

setlistener(show_eis, func() {
	if( show_eis.getValue() == 0 and shown != 0 ){
		eis2000g_update.stop();
		shown = 0;
	} else if ( show_eis.getValue() == 1 and shown != 1 ){
		eis2000g_update.restart(0.2);
		shown = 1;
	}
});
