# Deflecting wool thread
# Status: May 31, 2020
#
# 1. deflection due to flow direction
# 2. deflection due to flow speed
# 3. deflection due to gravity
# 4. deflection due to pitch and yaw rate

var woolthread = func {

 if( getprop("sim/model/woolthread" ) ) {

   var airspeed = getprop("velocities/airspeed-kt");

   var severity1 = (airspeed / 20) * ( rand() - 0.5 ) ;
   var severity2 = (airspeed / 20) * ( rand() - 0.5 ) ;

   var u_m_s = getprop("fdm/jsbsim/velocities/u-aero-fps") * FT2M;
   var v_m_s = getprop("fdm/jsbsim/velocities/v-aero-fps") * FT2M;
   var w_m_s = getprop("fdm/jsbsim/velocities/w-aero-fps") * FT2M;

   # taking yaw and pitch rate into account
   # dist_x_m: (loction x wool thread) - (location x c.g.)
   # JSBsim structural frame (x positive to aft)

   # ----------------  input  ----------------
   # Location wool thread
   var woolthread_x_m = -1.9;
   # -----------------------------------------

   var cg_x_m = getprop ("fdm/jsbsim/inertia/cg-x-in") * IN2M;
   var dist_x_m = woolthread_x_m - cg_x_m;

   var pitch_rate_rad_sec = getprop("fdm/jsbsim/velocities/q-aero-rad_sec");
   var yaw_rate_rad_sec   = getprop("fdm/jsbsim/velocities/r-aero-rad_sec");
   
   v_woolthread_m_s = v_m_s - yaw_rate_rad_sec * dist_x_m;
   w_woolthread_m_s = w_m_s - pitch_rate_rad_sec * dist_x_m;

   # influence of gravity on wool-thread only for low airspeed
   # gravity omitted for airspeed > 10kt / airspeed is always positive
   # deflection_aero: 0:= only deflection due to gravity / 1:= only deflection due to aero
   var deflection_aero = airspeed / 10. ;

   if( deflection_aero < 1 ) {

     var nx = getprop("accelerations/pilot/x-accel-fps_sec");
     var ny = getprop("accelerations/pilot/y-accel-fps_sec");
     var nz = getprop("accelerations/pilot/z-accel-fps_sec");

     var x = nx + (u_m_s - nx)            * deflection_aero;
     var y = ny + (v_woolthread_m_s - ny) * deflection_aero;
     var z = nz + (w_woolthread_m_s - nz) * deflection_aero;
     var xy = math.sqrt(x*x+y*y);
     
     var alpha_woolthread_deg = math.atan2(z,xy) * R2D;
     var beta_woolthread_deg  = math.atan2(y,x)  * R2D;
   }
   else {
     var vxy = math.sqrt(u_m_s*u_m_s + v_woolthread_m_s*v_woolthread_m_s);
     var alpha_woolthread_deg = math.atan2(w_woolthread_m_s,vxy)   * R2D;
     var beta_woolthread_deg  = math.atan2(v_woolthread_m_s,u_m_s) * R2D;
   }

   # alpha_woolthread and beta_woolthred depend on woolthread animation 
   #(first rotation about woolthread z-axis, second  rotation about woolthread y-axis)
   setprop("instrumentation/woolthread/alpha-woolthread-deg", alpha_woolthread_deg );
   setprop("instrumentation/woolthread/beta-woolthread-deg" , beta_woolthread_deg  );

   setprop("instrumentation/woolthread/severity1",severity1);
   setprop("instrumentation/woolthread/severity2",severity2);

 }

 settimer(woolthread,0);

}

# Start the woolthread ASAP
#woolthread();
settimer(woolthread,2);
