###############################################################################
##
##  Dornier 228 Callsign Placard
##
##  Original: Davtron 803
##  Original from Nasal for DR400-dauphin by dany93;
##                    Clément de l'Hamaide - PAF Team - http://equipe-flightgear.forumactif.com
##  Heavily modified in 2017 for c182s by Benedikt Hallinger
##  Modified in 2020 for M811 by Bea Wolf
##  Modified in 2020 for Callsign Placard by Bea Wolf
##  
##  This file is licensed under the GPL license version 2 or later.
##
###############################################################################

# Properties
var callsign = props.globals.getNode("/sim/model/livery/file", 1);	# Require file name to be the callsign
if( callsign.getValue() == nil ){
	callsign.setValue("N/A");
}

############################
# Canvas implementation
############################

var my_canvas = canvas.new({
	"name": "Callsign Placard",   # The name is optional but allow for easier identification
	"size": [256, 128], # Size of the underlying texture (should be a power of 2, required) [Resolution]
	"view": [256, 128],  # Virtual resolution (Defines the coordinate system of the canvas [Dimensions]
	# which will be stretched the size of the texture, required)
	"mipmapping": 1       # Enable mipmapping (optional)
});

my_canvas.addPlacement({"node": "callsign_placard"});
my_canvas.setColorBackground(1, 1, 1, 1);

# create groups holding some stuff
var bggroup  = my_canvas.createGroup();
var textgroup = my_canvas.createGroup();

var label_line = textgroup.createChild("text", "callsign.placard.label")
		.setTranslation(128, 40)   		 		# The origin is in the top left corner
		.setAlignment("center-center") 				# All values from osgText are supported (see $FG_ROOT/Docs/README.osgtext)
		.setFont("LiberationFonts/LiberationSans-Bold.ttf")	# Fonts are loaded either from $AIRCRAFT_DIR/Fonts or $FG_ROOT/Fonts
		.setFontSize(25, 1.0)					# Set fontsize and optionally character aspect ratio
		.setColor(0.0,0.0,0.0)					# Text color
		.setText("RADIO CALL");
		
var callsign_line = textgroup.createChild("text", "callsign.placard.callsign")
		.setTranslation(128, 100)   		 		# The origin is in the top left corner
		.setAlignment("center-center") 				# All values from osgText are supported (see $FG_ROOT/Docs/README.osgtext)
		.setFont("LiberationFonts/LiberationSans-Bold.ttf")	# Fonts are loaded either from $AIRCRAFT_DIR/Fonts or $FG_ROOT/Fonts
		.setFontSize(54, 1.0)					# Set fontsize and optionally character aspect ratio
		.setColor(0.0,0.0,0.0)					# Text color
		.setText(callsign.getValue());

var update_callsign = func () {
	callsign_line.setText( callsign.getValue() );
}

setlistener(callsign, update_callsign);
