/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* browser.h: widget tree browser functions
 * RCS_ID("$Id: browser.h,v 1.5 1997/05/14 15:40:19 tim Exp $")
*/


#ifndef		__browser_h__
#define		__browser_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"gbconf.h"
#include	"windows.h"
#include	"wdtree.h"



/* --- typedefs ---*/
typedef	enum
{
	ADD_AS_CHILD,
	ADD_AS_PARENT,
	ADD_AS_SIB_BEFORE,
	ADD_AS_SIB_AFTER
} add_type_E;



/* --- prototypes --- */
void	Browser_create			(gb_wdat_base_S	*WidDat);
void	Browser_refresh			(gb_wdat_base_S	*WidDat,
					 guint		selection_only);
void	Browser_tree_select		(tree_S		*tree,
					 gboolean	selected);
void	SigH_TypeList_Add_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	SigH_TypeList_AddType_changed	(GtkWidget	*widget,
					 add_type_E	add_type);






#ifdef		__cplusplus
  }
#endif
#endif		/*__browser_h__*/
