/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: misc.c,v 1.3 1997/05/20 21:17:50 tim Exp $")


#define		__misc_c__

#include	"misc.h"
#include	<glib.h>
#include	<ctype.h>
#include	<sys/stat.h>
#include	<stdarg.h>



/* --- variables --- */
static	FILE	*file_stream_out=NULL;



/* --- functions --- */
int
get_stat_mode	(const	char	*file_name)
{
	register struct	stat	*stat_buf;
	register int		st_mode;
	
	stat_buf=g_new0(struct stat, 1);
	
	stat(file_name, stat_buf);
	
	st_mode=stat_buf->st_mode;
	
	g_free(stat_buf);
	
	return st_mode;
}


gchar*
string_to_case		(const gchar	*string,
			 gboolean	to_upper,
			 gboolean	all_chars)
{
	static	 gchar	*buffer=NULL;
	register guint	i;
	register guint	len;
	
	if (!string)
		return NULL;
	
	g_free(buffer);
	
	len=strlen(string);
	
	buffer=g_new(gchar, len+1);
	
	strcpy(buffer, string);
	
	if (buffer[0]) {
		if (to_upper)
			buffer[0]=toupper(buffer[0]);
		else
			buffer[0]=tolower(buffer[0]);
	}
	
	for (i=1; i<len; i++)
		if (all_chars || buffer[i-1]=='_' || buffer[i-1]==' ') {
		if (to_upper)
			buffer[i]=toupper(buffer[i]);
		else
			buffer[i]=tolower(buffer[i]);
		}
	
	return buffer;
}


void
file_printf_set		(FILE	*stream)
{
	file_stream_out=stream;
}


int
file_printf	(const char	*format,
		 ...)
{
	register int		i;
		 va_list	args;
	
	g_assert(format);
	
	va_start(args, format);
	if (file_stream_out)
		i=vfprintf(file_stream_out, format, args);
	else
		i=0;
	va_end(args);
	
	if (file_stream_out)
		fflush(file_stream_out);
	
	file_stream_out=NULL;
	
	return i;
}
