dnl ## --------------------------------------------------------- ##
dnl ##  Check if ps_gecos is in struct passwd                    ##
dnl ##                           demaille@inf.enst.fr            ##
dnl ## --------------------------------------------------------- ##
dnl
dnl
dnl acconfig.h should contains these lines
dnl
dnl /* Define if your struct passwd has pw_gecos.  */
dnl #undef HAVE_PW_GECOS

# serial 1
# If struct passwd contains pw_gecos define HAVE_PW_GECOS
AC_DEFUN(ad_STRUCT_PW_GECOS,
[AC_CACHE_CHECK([for pw_gecos in struct passwd], ac_cv_struct_pw_gecos,
[AC_TRY_COMPILE([#include <pwd.h>], [struct passwd s; s.pw_gecos;],
ac_cv_struct_pw_gecos=yes, ac_cv_struct_pw_gecos=no)])
if test $ac_cv_struct_pw_gecos = yes; then
  AC_DEFINE(HAVE_PW_GECOS, 1,
	    [Define if your struct passwd has pw_gecos.])
fi
])
