/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Quick {
    private static final double TINYDELTA = DBMath.getEpsilon() * 1.1;
    private static final int SPACINGERROR = 1;
    private static final int MINWIDTHERROR = 2;
    private static final int NOTCHERROR = 3;
    private static final int MINSIZEERROR = 4;
    private static final int BADLAYERERROR = 5;
    private static final int LAYERSURROUNDERROR = 6;
    private static final int MINAREAERROR = 7;
    private static final int ENCLOSEDAREAERROR = 8;
    private static final int POLYSELECTERROR = 9;
    private static final int ZEROLENGTHARCWARN = 10;
    private static final int TECHMIXWARN = 11;
    private HashMap checkInsts = null;
    private HashMap checkProtos = null;
    private HashMap networkLists = null;
    private HashMap minAreaLayerMap = new HashMap();
    private HashMap enclosedAreaLayerMap = new HashMap();
    private DRC.CheckDRCLayoutJob job;
    private HashMap cellsMap = new HashMap();
    private HashMap nodesMap = new HashMap();
    private byte activeBits = 0;
    private List instanceInteractionList = new ArrayList();
    private List exclusionList = new ArrayList();
    private int numberOfThreads;
    private boolean onlyFirstError;
    private boolean ignoreCenterCuts;
    private double worstInteractionDistance;
    private int checkTimeStamp;
    private int checkNetNumber;
    private int totalMsgFound;
    private NodeInst tinyNodeInst;
    private Geometric tinyGeometric;
    private HashMap goodDRCDate = new HashMap();
    private HashMap cleanDRCDate = new HashMap();
    private ErrorLogger errorLogger;
    private static ErrorLogger errorLoggerIncremental = null;
    private Cell topCell;
    private Technology layersValidTech = null;
    private boolean[] layersValid;
    private Technology layerInterTech = null;
    private HashMap layersInterNodes = null;
    private HashMap layersInterArcs = null;

    public Quick(DRC.CheckDRCLayoutJob job) {
        this.job = job;
    }

    public static int checkDesignRules(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity, Rectangle2D bounds, DRC.CheckDRCLayoutJob drcJob) {
        Quick q = new Quick(drcJob);
        return q.doCheck(cell, count, geomsToCheck, validity, bounds);
    }

    private int doCheck(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity, Rectangle2D bounds) {
        DRCRules rules = DRC.getRules(cell.getTechnology());
        this.activeBits = DRC.getActiveBits();
        if (rules == null || rules.getNumberOfRules() == 0) {
            return 0;
        }
        this.onlyFirstError = DRC.isOneErrorPerCell();
        this.ignoreCenterCuts = DRC.isIgnoreCenterCuts();
        this.numberOfThreads = DRC.getNumberOfThreads();
        this.topCell = cell;
        if (count > 0) {
            this.onlyFirstError = true;
            this.numberOfThreads = 1;
        }
        Technology tech = cell.getTechnology();
        this.cacheValidLayers(tech);
        this.buildLayerInteractions(tech);
        this.instanceInteractionList.clear();
        this.worstInteractionDistance = DRC.getWorstSpacingDistance(tech);
        this.minAreaLayerMap.clear();
        this.enclosedAreaLayerMap.clear();
        this.cellsMap.clear();
        this.nodesMap.clear();
        if (!DRC.isIgnoreAreaChecking() && !this.onlyFirstError) {
            Iterator it = tech.getLayers();
            while (it.hasNext()) {
                DRCRules.DRCRule enclosedAreaRule;
                Layer layer = (Layer)it.next();
                DRCRules.DRCRule minAreaRule = DRC.getMinValue(layer, 21);
                if (minAreaRule != null) {
                    this.minAreaLayerMap.put(layer, minAreaRule);
                }
                if ((enclosedAreaRule = DRC.getMinValue(layer, 22)) == null) continue;
                this.enclosedAreaLayerMap.put(layer, enclosedAreaRule);
            }
        }
        this.checkProtos = new HashMap();
        this.checkInsts = new HashMap();
        Netlist netlist = cell.getNetlist(false);
        CheckProto cp = this.checkEnumerateProtos(cell, netlist);
        if (cp.treeParameterized && this.numberOfThreads > 1) {
            System.out.println("Parameterized layout being used: multiprocessor decomposition disabled");
            this.numberOfThreads = 1;
        }
        cp.hierInstanceCount = 1;
        this.checkTimeStamp = 0;
        this.checkEnumerateInstances(cell);
        int totalNetworks = 0;
        this.networkLists = new HashMap();
        Iterator it = this.checkProtos.entrySet().iterator();
        while (it.hasNext()) {
            NodeProto np;
            NodeInst ni;
            Iterator nIt;
            Map.Entry e = it.next();
            Cell libCell = (Cell)e.getKey();
            CheckProto subCP = (CheckProto)e.getValue();
            if (subCP.hierInstanceCount > 0) {
                nIt = subCP.netlist.getNetworks();
                while (nIt.hasNext()) {
                    Network net = (Network)nIt.next();
                    Integer[] netNumbers = new Integer[subCP.hierInstanceCount];
                    for (int i = 0; i < subCP.hierInstanceCount; ++i) {
                        netNumbers[i] = new Integer(0);
                    }
                    this.networkLists.put(net, netNumbers);
                    totalNetworks += subCP.hierInstanceCount;
                }
            }
            nIt = libCell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                np = ni.getProto();
                if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
                CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                CheckProto ocp = this.getCheckProto((Cell)np);
                ci.offset = ocp.totalPerCell;
            }
            ++this.checkTimeStamp;
            nIt = libCell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                np = ni.getProto();
                if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
                CheckProto ocp = this.getCheckProto((Cell)np);
                if (ocp.timeStamp == this.checkTimeStamp) continue;
                CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                ocp.timeStamp = this.checkTimeStamp;
                ocp.totalPerCell += subCP.hierInstanceCount * ci.multiplier;
            }
        }
        this.checkTimeStamp = 0;
        this.checkNetNumber = 1;
        HashMap<Network, Integer> enumeratedNets = new HashMap<Network, Integer>();
        Iterator nIt = cp.netlist.getNetworks();
        while (nIt.hasNext()) {
            Network net = (Network)nIt.next();
            enumeratedNets.put(net, new Integer(this.checkNetNumber));
            ++this.checkNetNumber;
        }
        this.checkEnumerateNetworks(cell, cp, 0, enumeratedNets);
        if (count <= 0) {
            System.out.println("Found " + this.checkNetNumber + " networks");
        }
        this.exclusionList.clear();
        this.accumulateExclusion(cell, DBMath.MATID);
        boolean validVersion = true;
        Version version = cell.getLibrary().getVersion();
        if (version != null) {
            validVersion = version.compareTo(Version.getVersion()) >= 0;
        }
        this.errorLogger = null;
        int logsFound = 0;
        int totalErrors = 0;
        if (count == 0) {
            this.errorLogger = ErrorLogger.newInstance("DRC (full)");
            totalErrors = this.checkThisCell(cell, 0, bounds, validVersion);
            this.errorLogger.sortLogs();
        } else {
            if (validity == null) {
                if (errorLoggerIncremental == null) {
                    errorLoggerIncremental = ErrorLogger.newInstance("DRC (incremental)", true);
                }
                errorLoggerIncremental.clearLogs(cell);
                this.errorLogger = errorLoggerIncremental;
                logsFound = errorLoggerIncremental.getNumLogs();
            }
            this.checkTheseGeometrics(cell, count, geomsToCheck, validity);
        }
        if (this.errorLogger != null) {
            this.errorLogger.termLogging(true);
            logsFound = this.errorLogger.getNumLogs() - logsFound;
        }
        if (totalErrors != 0) {
            this.goodDRCDate.clear();
        }
        if (this.goodDRCDate.size() > 0 || this.cleanDRCDate.size() > 0) {
            UpdateDRCDates job = new UpdateDRCDates(this.goodDRCDate, this.cleanDRCDate);
        }
        return logsFound;
    }

    private int checkThisCell(Cell cell, int globalIndex, Rectangle2D bounds, boolean validVersion) {
        Date lastChangeDate;
        Date lastGoodDate;
        if (this.job != null && this.job.checkAbort()) {
            return -1;
        }
        if (this.cellsMap.get(cell) != null) {
            if (Main.LOCALDEBUGFLAG) {
                System.out.println("Done already cell " + cell.getName());
            }
            return 0;
        }
        int prevErrors = 0;
        int prevWarns = 0;
        if (this.errorLogger != null) {
            prevErrors = this.errorLogger.getNumErrors();
            prevWarns = this.errorLogger.getNumWarnings();
        }
        this.cellsMap.put(cell, cell);
        boolean allSubCellsStillOK = true;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            Rectangle2D subBounds = bounds;
            if (subBounds != null) {
                if (!ni.getBounds().intersects(bounds)) continue;
                AffineTransform trans = ni.rotateIn();
                AffineTransform xTrnI = ni.translateIn();
                trans.preConcatenate(xTrnI);
                subBounds = new Rectangle2D.Double();
                subBounds.setRect(bounds);
                DBMath.transformRect(subBounds, trans);
            }
            CheckProto cp = this.getCheckProto((Cell)np);
            if (cp.cellChecked && !cp.cellParameterized) continue;
            CheckInst ci = (CheckInst)this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            int retval = this.checkThisCell((Cell)np, localIndex, subBounds, validVersion);
            if (retval < 0) {
                return -1;
            }
            if (retval <= 0) continue;
            allSubCellsStillOK = false;
        }
        CheckProto cp = this.getCheckProto(cell);
        cp.cellChecked = true;
        if (validVersion && allSubCellsStillOK && (lastGoodDate = DRC.getLastDRCDateBasedOnBits(cell, this.activeBits)) != null && lastGoodDate.after(lastChangeDate = cell.getRevisionDate())) {
            return 0;
        }
        System.out.println("Checking cell " + cell.describe());
        this.totalMsgFound = 0;
        if (cell == this.topCell && !DRC.isIgnoreAreaChecking() && !this.onlyFirstError) {
            this.totalMsgFound = this.checkMinArea(cell);
        }
        Iterator it2 = cell.getNodes();
        while (it2.hasNext()) {
            boolean ret;
            NodeInst ni = (NodeInst)it2.next();
            if (bounds != null && !ni.getBounds().intersects(bounds) || !(ret = ni.getProto() instanceof Cell ? this.checkCellInst(ni, globalIndex) : this.checkNodeInst(ni, globalIndex))) continue;
            ++this.totalMsgFound;
            if (!this.onlyFirstError) continue;
            break;
        }
        Technology cellTech = cell.getTechnology();
        Iterator it3 = cell.getArcs();
        while (it3.hasNext()) {
            ArcInst ai = (ArcInst)it3.next();
            Technology tech = ai.getProto().getTechnology();
            if (tech != cellTech) {
                this.reportError(11, " belongs to " + tech.getTechName(), cell, 0.0, 0.0, null, null, ai, null, null, null, null);
                continue;
            }
            if (bounds != null && !ai.getBounds().intersects(bounds) || !this.checkArcInst(cp, ai, globalIndex)) continue;
            ++this.totalMsgFound;
            if (!this.onlyFirstError) continue;
            break;
        }
        if (this.totalMsgFound > 0 || !allSubCellsStillOK) {
            this.cleanDRCDate.put(cell, cell);
        } else {
            this.goodDRCDate.put(cell, new Date());
        }
        if (this.errorLogger != null) {
            int localErrors = this.errorLogger.getNumErrors() - prevErrors;
            int localWarnings = this.errorLogger.getNumWarnings() - prevWarns;
            if (localErrors == 0 && localWarnings == 0) {
                System.out.println("   No errors/warnings found");
            } else {
                if (localErrors > 0) {
                    System.out.println("   FOUND " + localErrors + " ERRORS");
                }
                if (localWarnings > 0) {
                    System.out.println("   FOUND " + localWarnings + " WARNINGS");
                }
            }
        }
        return this.totalMsgFound;
    }

    private boolean checkNodeInst(NodeInst ni, int globalIndex) {
        Cell cell = ni.getParent();
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        NodeProto np = ni.getProto();
        Technology tech = np.getTechnology();
        AffineTransform trans = ni.rotateOut();
        if (this.nodesMap.get(ni) != null) {
            if (Main.LOCALDEBUGFLAG) {
                System.out.println("Done already node " + ni.getName());
            }
            return false;
        }
        this.nodesMap.put(ni, ni);
        if (NodeInst.isSpecialNode(ni)) {
            return false;
        }
        if (np.getFunction() == PrimitiveNode.Function.PIN) {
            return false;
        }
        Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts, null);
        this.convertPseudoLayers(ni, nodeInstPolyList);
        int tot = nodeInstPolyList.length;
        boolean isTransistor = np.getFunction().isTransistor();
        boolean errorsFound = false;
        for (int j = 0; j < tot; ++j) {
            Poly poly = nodeInstPolyList[j];
            Layer layer = poly.getLayer();
            if (layer == null) continue;
            poly.transform(trans);
            int netNumber = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex);
            boolean ret = this.badBox(poly, layer, netNumber, tech, ni, trans, cell, globalIndex);
            if (ret) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkMinWidth(ni, layer, poly, tot == 1)) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            boolean bl = ret = !isTransistor && this.checkSelectOverPolysilicon(ni, layer, poly, cell);
            if (ret) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (tech != this.layersValidTech || this.layersValid[layer.getIndex()]) continue;
            this.reportError(5, null, cell, 0.0, 0.0, null, poly, ni, layer, null, null, null);
            if (this.onlyFirstError) {
                return true;
            }
            errorsFound = true;
        }
        DRC.NodeSizeRule sizeRule = DRC.getMinSize(np);
        if (sizeRule != null && (ni.getXSize() < sizeRule.sizeX || ni.getYSize() < sizeRule.sizeY)) {
            SizeOffset so = ni.getSizeOffset();
            double minSize = 0.0;
            double actual = 0.0;
            String msg = "X axis";
            if (sizeRule.sizeX - ni.getXSize() > sizeRule.sizeY - ni.getYSize()) {
                minSize = sizeRule.sizeX - so.getLowXOffset() - so.getHighXOffset();
                actual = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
            } else {
                msg = "Y axis";
                minSize = sizeRule.sizeY - so.getLowYOffset() - so.getHighYOffset();
                actual = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
            }
            this.reportError(4, msg, cell, minSize, actual, sizeRule.rule, null, ni, null, null, null, null);
        }
        return errorsFound;
    }

    private boolean checkArcInst(CheckProto cp, ArcInst ai, int globalIndex) {
        Network net = cp.netlist.getNetwork(ai, 0);
        if (net == null) {
            return false;
        }
        Integer[] netNumbers = (Integer[])this.networkLists.get(net);
        if (this.nodesMap.get(ai) != null) {
            if (Main.LOCALDEBUGFLAG) {
                System.out.println("Done already arc " + ai.getName());
            }
            return false;
        }
        this.nodesMap.put(ai, ai);
        Technology tech = ai.getProto().getTechnology();
        Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
        this.cropActiveArc(ai, arcInstPolyList);
        int tot = arcInstPolyList.length;
        boolean errorsFound = false;
        for (int j = 0; j < tot; ++j) {
            Poly poly = arcInstPolyList[j];
            Layer layer = poly.getLayer();
            if (layer == null || layer.isNonElectrical()) continue;
            int layerNum = layer.getIndex();
            int netNumber = netNumbers[globalIndex];
            boolean ret = this.badBox(poly, layer, netNumber, tech, ai, DBMath.MATID, ai.getParent(), globalIndex);
            if (ret) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkMinWidth(ai, layer, poly, tot == 1)) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkSelectOverPolysilicon(ai, layer, poly, ai.getParent())) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (tech != this.layersValidTech || this.layersValid[layerNum]) continue;
            this.reportError(5, null, ai.getParent(), 0.0, 0.0, null, tot == 1 ? null : poly, ai, layer, null, null, null);
            if (this.onlyFirstError) {
                return true;
            }
            errorsFound = true;
        }
        return errorsFound;
    }

    private boolean checkCellInst(NodeInst ni, int globalIndex) {
        AffineTransform upTrans = ni.translateOut(ni.rotateOut());
        CheckInst ci = (CheckInst)this.checkInsts.get(ni);
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        boolean errorFound = false;
        Rectangle2D nodeBounds = ni.getBounds();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - this.worstInteractionDistance, nodeBounds.getMinY() - this.worstInteractionDistance, nodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
        Iterator it = ni.getParent().searchIterator(searchBounds);
        while (it.hasNext()) {
            Rectangle2D nearNodeBounds;
            Rectangle2D.Double subBounds;
            boolean ret;
            NodeInst oNi;
            Geometric geom = (Geometric)it.next();
            if (geom == ni || !(geom instanceof NodeInst) || (oNi = (NodeInst)geom).getNodeIndex() <= ni.getNodeIndex() || !(oNi.getProto() instanceof Cell) || this.checkInteraction(ni, oNi) || !(ret = this.checkCellInstContents(subBounds = new Rectangle2D.Double((nearNodeBounds = oNi.getBounds()).getMinX() - this.worstInteractionDistance, nearNodeBounds.getMinY() - this.worstInteractionDistance, nearNodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nearNodeBounds.getHeight() + this.worstInteractionDistance * 2.0), ni, upTrans, localIndex, oNi, globalIndex))) continue;
            errorFound = true;
        }
        return errorFound;
    }

    private boolean checkCellInstContents(Rectangle2D bounds, NodeInst thisNi, AffineTransform upTrans, int globalIndex, NodeInst oNi, int topGlobalIndex) {
        if (this.job != null && this.job.checkAbort()) {
            return true;
        }
        Cell cell = (Cell)thisNi.getProto();
        boolean logsFound = false;
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Technology cellTech = cell.getTechnology();
        Rectangle2D bb = (Rectangle2D)bounds.clone();
        AffineTransform downTrans = thisNi.transformIn();
        DBMath.transformRect(bb, downTrans);
        Iterator it = cell.searchIterator(bb);
        while (it.hasNext()) {
            int j;
            Geometric geom = (Geometric)it.next();
            if (Main.getDebug() && geom == thisNi) {
                System.out.println("Should I skip it 2?");
            }
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                NodeProto np = ni.getProto();
                if (NodeInst.isSpecialNode(ni)) continue;
                if (np instanceof Cell) {
                    AffineTransform subUpTrans = ni.translateOut(ni.rotateOut());
                    subUpTrans.preConcatenate(upTrans);
                    CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                    int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    boolean ret = this.checkCellInstContents(bb, ni, subUpTrans, localIndex, oNi, topGlobalIndex);
                    if (!ret) continue;
                    if (this.onlyFirstError) {
                        return true;
                    }
                    logsFound = true;
                    continue;
                }
                AffineTransform rTrans = ni.rotateOut();
                rTrans.preConcatenate(upTrans);
                if (np.getFunction() == PrimitiveNode.Function.PIN) {
                    System.out.println("This should not happend in Quick.checkCellInstContents()");
                    continue;
                }
                Technology tech = np.getTechnology();
                Poly[] primPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts, null);
                this.convertPseudoLayers(ni, primPolyList);
                int tot = primPolyList.length;
                for (int j2 = 0; j2 < tot; ++j2) {
                    Poly poly = primPolyList[j2];
                    Layer layer = poly.getLayer();
                    if (layer == null) {
                        if (!Main.LOCALDEBUGFLAG) continue;
                        System.out.println("When is this case?");
                        continue;
                    }
                    poly.transform(rTrans);
                    int net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex);
                    boolean ret = this.badSubBox(poly, layer, net, tech, ni, rTrans, globalIndex, oNi, topGlobalIndex);
                    if (!ret) continue;
                    if (this.onlyFirstError) {
                        return true;
                    }
                    logsFound = true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            if (tech != cellTech) {
                this.reportError(11, " belongs to " + tech.getTechName(), cell, 0.0, 0.0, null, null, ai, null, null, null, null);
                continue;
            }
            Poly[] arcPolyList = tech.getShapeOfArc(ai);
            int tot = arcPolyList.length;
            for (j = 0; j < tot; ++j) {
                arcPolyList[j].transform(upTrans);
            }
            this.cropActiveArc(ai, arcPolyList);
            for (j = 0; j < tot; ++j) {
                boolean ret;
                Poly poly = arcPolyList[j];
                Layer layer = poly.getLayer();
                if (layer == null || layer.isNonElectrical()) continue;
                Network jNet = netlist.getNetwork(ai, 0);
                int net = -1;
                if (jNet != null) {
                    Integer[] netList = (Integer[])this.networkLists.get(jNet);
                    net = netList[globalIndex];
                }
                if (!(ret = this.badSubBox(poly, layer, net, tech, ai, upTrans, globalIndex, oNi, topGlobalIndex))) continue;
                if (this.onlyFirstError) {
                    return true;
                }
                logsFound = true;
            }
        }
        return logsFound;
    }

    private boolean badSubBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, int globalIndex, NodeInst oNi, int topGlobalIndex) {
        double maxSize = poly.getMaxSize();
        double bound = DRC.getMaxSurround(layer, maxSize);
        if (bound < 0.0) {
            return false;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
        AffineTransform downTrans = oNi.rotateIn();
        AffineTransform tTransI = oNi.translateIn();
        downTrans.preConcatenate(tTransI);
        DBMath.transformRect(bounds, downTrans);
        double minSize = poly.getMinSize();
        AffineTransform upTrans = oNi.translateOut(oNi.rotateOut());
        CheckInst ci = (CheckInst)this.checkInsts.get(oNi);
        int localIndex = topGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
        boolean baseMulti = false;
        if (geom instanceof NodeInst) {
            baseMulti = tech.isMultiCutCase((NodeInst)geom);
        }
        ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
        return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, (Cell)oNi.getProto(), localIndex, oNi.getParent(), topGlobalIndex, upTrans, minSize, baseMulti, false);
    }

    private boolean badBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, Cell cell, int globalIndex) {
        double maxSize = poly.getMaxSize();
        double bound = DRC.getMaxSurround(layer, maxSize);
        if (bound < 0.0) {
            return false;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
        double minSize = poly.getMinSize();
        boolean baseMulti = false;
        if (geom instanceof NodeInst) {
            baseMulti = tech.isMultiCutCase((NodeInst)geom);
        }
        ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
        return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, cell, globalIndex, cell, globalIndex, DBMath.MATID, minSize, baseMulti, true);
    }

    private boolean badBoxInArea(Poly poly, Layer layer, Technology tech, int net, Geometric geom, AffineTransform trans, int globalIndex, Rectangle2D bounds, Cell cell, int cellGlobalIndex, Cell topCell, int topGlobalIndex, AffineTransform upTrans, double minSize, boolean baseMulti, boolean sameInstance) {
        Rectangle2D.Double rBound = new Rectangle2D.Double();
        ((Rectangle2D)rBound).setRect(bounds);
        DBMath.transformRect(rBound, upTrans);
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Rectangle2D.Double subBound = new Rectangle2D.Double();
        if (geom instanceof NodeInst && NodeInst.isSpecialNode((NodeInst)geom)) {
            return false;
        }
        Iterator it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric nGeom = (Geometric)it.next();
            if (sameInstance && nGeom == geom) continue;
            if (nGeom instanceof NodeInst) {
                NodeInst ni = (NodeInst)nGeom;
                NodeProto np = ni.getProto();
                if (NodeInst.isSpecialNode(ni)) continue;
                if (np instanceof Cell) {
                    AffineTransform rTransI = ni.rotateIn();
                    AffineTransform tTransI = ni.translateIn();
                    rTransI.preConcatenate(tTransI);
                    ((Rectangle2D)subBound).setRect(bounds);
                    DBMath.transformRect(subBound, rTransI);
                    CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                    int localIndex = cellGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    AffineTransform subTrans = ni.translateOut(ni.rotateOut());
                    subTrans.preConcatenate(upTrans);
                    if (!this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, subBound, (Cell)np, localIndex, topCell, topGlobalIndex, subTrans, minSize, baseMulti, sameInstance)) continue;
                    return true;
                }
                if (np.getTechnology() != tech || !this.checkLayerWithNode(layer, np)) continue;
                if (np.getFunction() == PrimitiveNode.Function.PIN) {
                    System.out.println("This should not happen in Quick.badBoxInArea");
                    continue;
                }
                boolean touch = Geometric.objectsTouch(nGeom, geom);
                AffineTransform rTrans = ni.rotateOut();
                rTrans.preConcatenate(upTrans);
                Poly[] subPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts, null);
                this.convertPseudoLayers(ni, subPolyList);
                int tot = subPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    subPolyList[i].transform(rTrans);
                }
                boolean multi = baseMulti;
                if (!multi) {
                    multi = tech.isMultiCutCase(ni);
                }
                for (int j = 0; j < tot; ++j) {
                    String rule;
                    Rectangle2D nPolyRect;
                    Poly npoly = subPolyList[j];
                    Layer nLayer = npoly.getLayer();
                    if (nLayer == null || (nPolyRect = npoly.getBounds2D()).getMinX() > rBound.getMaxX() || nPolyRect.getMaxX() < rBound.getMinX() || nPolyRect.getMinY() > rBound.getMaxY() || nPolyRect.getMaxY() < rBound.getMinY()) continue;
                    int nNet = this.getDRCNetNumber(netlist, npoly.getPort(), ni, cellGlobalIndex);
                    boolean con = false;
                    if (nNet >= 0 && nNet == net) {
                        con = true;
                    }
                    if (con && touch) continue;
                    double nMinSize = npoly.getMinSize();
                    DRCRules.DRCRule dRule = this.getAdjustedMinDist(layer, minSize, nLayer, nMinSize, con, multi);
                    DRCRules.DRCRule eRule = DRC.getEdgeRule(layer, nLayer);
                    if (dRule == null && eRule == null) continue;
                    double dist = -1.0;
                    boolean edge = false;
                    if (dRule != null) {
                        dist = dRule.value;
                        rule = dRule.rule;
                    } else {
                        dist = eRule.value;
                        rule = eRule.rule;
                        edge = true;
                    }
                    boolean ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, npoly, nLayer, nNet, nGeom, rTrans, cellGlobalIndex, con, dist, edge, rule);
                    if (!ret) continue;
                    return true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)nGeom;
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() != tech || !this.checkLayerWithArc(layer, ap)) continue;
            boolean touch = Geometric.objectsTouch(nGeom, geom);
            Network jNet = netlist.getNetwork(ai, 0);
            Integer[] netNumbers = (Integer[])this.networkLists.get(jNet);
            int nNet = netNumbers[cellGlobalIndex];
            boolean con = false;
            if (net >= 0 && nNet == net) {
                con = true;
            }
            if (con && touch) continue;
            Poly[] subPolyList = tech.getShapeOfArc(ai);
            int tot = subPolyList.length;
            for (int i = 0; i < tot; ++i) {
                subPolyList[i].transform(upTrans);
            }
            this.cropActiveArc(ai, subPolyList);
            boolean multi = baseMulti;
            for (int j = 0; j < tot; ++j) {
                String rule;
                Rectangle2D nPolyRect;
                Poly nPoly = subPolyList[j];
                Layer nLayer = nPoly.getLayer();
                if (nLayer == null || (nPolyRect = nPoly.getBounds2D()).getMinX() > rBound.getMaxX() || nPolyRect.getMaxX() < rBound.getMinX() || nPolyRect.getMinY() > rBound.getMaxY() || nPolyRect.getMaxY() < rBound.getMinY()) continue;
                double nMinSize = nPoly.getMinSize();
                DRCRules.DRCRule dRule = this.getAdjustedMinDist(layer, minSize, nLayer, nMinSize, con, multi);
                DRCRules.DRCRule eRule = DRC.getEdgeRule(layer, nLayer);
                if (dRule == null && eRule == null) continue;
                double dist = -1.0;
                boolean edge = false;
                if (dRule != null) {
                    dist = dRule.value;
                    rule = dRule.rule;
                } else {
                    dist = eRule.value;
                    rule = eRule.rule;
                    edge = true;
                }
                boolean ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, nPoly, nLayer, nNet, nGeom, upTrans, cellGlobalIndex, con, dist, edge, rule);
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDist(Technology tech, Cell cell, int globalIndex, Poly poly1, Layer layer1, int net1, Geometric geom1, AffineTransform trans1, int globalIndex1, Poly poly2, Layer layer2, int net2, Geometric geom2, AffineTransform trans2, int globalIndex2, boolean con, double dist, boolean edge, String rule) {
        Rectangle2D isBox2;
        Rectangle2D trueBox2;
        this.tinyNodeInst = null;
        Poly origPoly1 = poly1;
        Poly origPoly2 = poly2;
        Rectangle2D isBox1 = poly1.getBox();
        Rectangle2D trueBox1 = isBox1;
        if (trueBox1 == null) {
            trueBox1 = poly1.getBounds2D();
        }
        if ((trueBox2 = (isBox2 = poly2.getBox())) == null) {
            trueBox2 = poly2.getBounds2D();
        }
        boolean maytouch = false;
        if (tech.sameLayer(layer1, layer2)) {
            Layer.Function fun = layer1.getFunction();
            if (con) {
                if (!fun.isContact()) {
                    maytouch = true;
                }
            } else if (fun.isSubstrate()) {
                maytouch = true;
            } else {
                int funExtras = layer1.getFunctionExtras();
                if (fun.isDiff() && (funExtras & 0x800000) != 0) {
                    if (Main.LOCALDEBUGFLAG) {
                        System.out.println("Thick active found in Quick.checkDist");
                    }
                    maytouch = true;
                }
            }
        }
        double pd = 0.0;
        boolean overlap = false;
        if (isBox1 != null && isBox2 != null) {
            double pdx = Math.max(trueBox2.getMinX() - trueBox1.getMaxX(), trueBox1.getMinX() - trueBox2.getMaxX());
            double pdy = Math.max(trueBox2.getMinY() - trueBox1.getMaxY(), trueBox1.getMinY() - trueBox2.getMaxY());
            pd = Math.max(pdx, pdy);
            if (pdx == 0.0 && pdy == 0.0) {
                pd = 0.0;
            }
            if (maytouch) {
                DRCRules.DRCRule wRule;
                boolean bl = overlap = pd < 0.0;
                if (pd <= 0.0 && (wRule = DRC.getMinValue(layer1, 1)) != null) {
                    double minWidth = wRule.value;
                    double lxb = Math.max(trueBox1.getMinX(), trueBox2.getMinX());
                    double hxb = Math.min(trueBox1.getMaxX(), trueBox2.getMaxX());
                    double lyb = Math.max(trueBox1.getMinY(), trueBox2.getMinY());
                    double hyb = Math.min(trueBox1.getMaxY(), trueBox2.getMaxY());
                    Point2D.Double lowB = new Point2D.Double(lxb, lyb);
                    Point2D.Double highB = new Point2D.Double(hxb, hyb);
                    Rectangle2D.Double bounds = new Rectangle2D.Double(lxb, lyb, hxb - lxb, hyb - lyb);
                    Rectangle2D.Double search = new Rectangle2D.Double(DBMath.round(lxb - TINYDELTA), DBMath.round(lyb - TINYDELTA), DBMath.round(hxb - lxb + 2.0 * TINYDELTA), DBMath.round(hyb - lyb + 2.0 * TINYDELTA));
                    double actual = lowB.distance(highB);
                    if (actual != 0.0 && DBMath.isGreaterThan(minWidth, actual)) {
                        boolean[] pointsFound = new boolean[2];
                        pointsFound[1] = false;
                        pointsFound[0] = false;
                        Point2D pt1 = new Point2D.Double(lxb - TINYDELTA, lyb - TINYDELTA);
                        Point2D pt2 = new Point2D.Double(lxb - TINYDELTA, hyb + TINYDELTA);
                        Point2D.Double pt3 = new Point2D.Double(hxb + TINYDELTA, lyb - TINYDELTA);
                        Point2D.Double pt4 = new Point2D.Double(hxb + TINYDELTA, hyb + TINYDELTA);
                        Poly rebuild = new Poly(bounds);
                        if (pd == 0.0) {
                            pt1 = lowB;
                            pt2 = highB;
                        } else {
                            Point2D[] points = rebuild.getPoints();
                            int[] cornerPoints = new int[2];
                            int corners = 0;
                            for (int i = 0; i < points.length && corners < 2; ++i) {
                                if (DBMath.pointInsideRect(points[i], poly1.getBounds2D()) || DBMath.pointInsideRect(points[i], poly2.getBounds2D())) continue;
                                cornerPoints[corners++] = i;
                            }
                            if (corners != 2) {
                                throw new Error("Wrong corners in Quick.checkMinArea()");
                            }
                            pt1 = points[cornerPoints[0]];
                            pt2 = points[cornerPoints[1]];
                        }
                        boolean oldCheck = true;
                        boolean allFound = true;
                        this.lookForLayerNew(geom1, poly1, geom2, poly2, cell, layer1, DBMath.MATID, search, pt1, pt2, null, pointsFound, false);
                        if (!pointsFound[0] && !pointsFound[1]) {
                            this.reportError(2, null, cell, minWidth, actual, wRule.rule, rebuild, geom1, layer1, rebuild, geom2, layer2);
                            allFound = false;
                        }
                        if (Main.LOCALDEBUGFLAG) {
                            if (hxb - lxb > hyb - lyb) {
                                pt1 = new Point2D.Double(lxb - TINYDELTA, lyb - TINYDELTA);
                                pt2 = new Point2D.Double(lxb - TINYDELTA, hyb + TINYDELTA);
                                pt3 = new Point2D.Double(hxb + TINYDELTA, lyb - TINYDELTA);
                                pt4 = new Point2D.Double(hxb + TINYDELTA, hyb + TINYDELTA);
                                if (!this.lookForPoints(pt1, pt2, layer1, cell, true) && !this.lookForPoints(pt3, pt4, layer1, cell, true)) {
                                    rebuild = new Poly((lxb + hxb) / 2.0, ((lyb -= minWidth / 2.0) + (hyb += minWidth / 2.0)) / 2.0, hxb - lxb, hyb - lyb);
                                    rebuild.setStyle(Poly.Type.FILLED);
                                    System.out.println("Quick.checkDist code decomissioned");
                                    oldCheck = false;
                                }
                            } else {
                                pt1 = new Point2D.Double(lxb - TINYDELTA, lyb - TINYDELTA);
                                pt2 = new Point2D.Double(hxb + TINYDELTA, lyb - TINYDELTA);
                                pt3 = new Point2D.Double(lxb - TINYDELTA, hyb + TINYDELTA);
                                pt4 = new Point2D.Double(hxb + TINYDELTA, hyb + TINYDELTA);
                                if (!this.lookForPoints(pt1, pt2, layer1, cell, true) && !this.lookForPoints(pt3, pt4, layer1, cell, true)) {
                                    rebuild = new Poly(((lxb -= minWidth / 2.0) + (hxb += minWidth / 2.0)) / 2.0, (lyb + hyb) / 2.0, hxb - lxb, hyb - lyb);
                                    rebuild.setStyle(Poly.Type.FILLED);
                                    System.out.println("Quick.checkDist code decomissioned");
                                    oldCheck = false;
                                }
                            }
                            if (oldCheck != allFound) {
                                System.out.println("Different results in Quick.checkDist");
                            }
                        }
                        if (!allFound) {
                            return true;
                        }
                    }
                }
            }
            trueBox1 = new Rectangle2D.Double(trueBox1.getMinX(), trueBox1.getMinY(), trueBox1.getWidth(), trueBox1.getHeight());
            trueBox2 = new Rectangle2D.Double(trueBox2.getMinX(), trueBox2.getMinY(), trueBox2.getWidth(), trueBox2.getHeight());
            if (geom1 instanceof NodeInst ? this.cropNodeInst((NodeInst)geom1, globalIndex1, trans1, layer2, net2, geom2, trueBox2) : this.cropArcInst((ArcInst)geom1, layer1, trans1, trueBox1)) {
                return false;
            }
            if (geom2 instanceof NodeInst ? this.cropNodeInst((NodeInst)geom2, globalIndex2, trans2, layer1, net1, geom1, trueBox1) : this.cropArcInst((ArcInst)geom2, layer2, trans2, trueBox2)) {
                return false;
            }
            poly1 = new Poly(trueBox1);
            poly1.setStyle(Poly.Type.FILLED);
            poly2 = new Poly(trueBox2);
            poly2.setStyle(Poly.Type.FILLED);
            double lX1 = trueBox1.getMinX();
            double hX1 = trueBox1.getMaxX();
            double lY1 = trueBox1.getMinY();
            double hY1 = trueBox1.getMaxY();
            double lX2 = trueBox2.getMinX();
            double hX2 = trueBox2.getMaxX();
            double lY2 = trueBox2.getMinY();
            double hY2 = trueBox2.getMaxY();
            if (edge) {
                double pdedge = Math.min(Math.min(Math.min(Math.abs(lX1 - lX2), Math.abs(lX1 - hX2)), Math.min(Math.abs(hX1 - lX2), Math.abs(hX1 - hX2))), Math.min(Math.min(Math.abs(lY1 - lY2), Math.abs(lY1 - hY2)), Math.min(Math.abs(hY1 - lY2), Math.abs(hY1 - hY2))));
                pd = Math.max(pd, pdedge);
            } else {
                pdx = Math.max(lX2 - hX1, lX1 - hX2);
                pdy = Math.max(lY2 - hY1, lY1 - hY2);
                if (pdx == 0.0 && pdy == 0.0) {
                    pd = 0.0;
                } else {
                    pd = DBMath.round(Math.max(pdx, pdy));
                    if (pd < dist && pd > 0.0) {
                        pd = poly1.separation(poly2);
                    }
                }
            }
        } else {
            Poly.Type style = poly1.getStyle();
            if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                return false;
            }
            style = poly2.getStyle();
            if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                return false;
            }
            double pd1 = poly1.separation(poly2);
            if (pd1 != (pd = poly1.intersects(poly2) ? 0.0 : poly1.separation(poly2))) {
                System.out.println("Wrong case in non-nonmanhattan, Quick.");
            }
        }
        if (pd >= dist) {
            return false;
        }
        int errorType = 1;
        if (this.activeOnTransistor(poly1, layer1, net1, poly2, layer2, net2, cell, globalIndex)) {
            return false;
        }
        if (tech.sameLayer(layer1, layer2) && maytouch) {
            if (pd <= 0.0) {
                return false;
            }
            boolean newR = this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
            if (Main.LOCALDEBUGFLAG) {
                boolean oldR;
                Point2D.Double pt1 = new Point2D.Double();
                Point2D.Double pt2 = new Point2D.Double();
                int intervening = this.findInterveningPoints(poly1, poly2, pt1, pt2, false);
                if (intervening == 0 && !newR) {
                    System.out.println("DIfferent");
                    this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
                }
                boolean needBoth = true;
                if (intervening == 1) {
                    needBoth = false;
                }
                if (this.lookForPoints(pt1, pt2, layer1, cell, needBoth) && !newR) {
                    System.out.println("DIfferent");
                    this.lookForPoints(pt1, pt2, layer1, cell, needBoth);
                    this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
                }
                if ((oldR = this.lookForPoints(pt1, pt2, layer1, cell, needBoth)) != newR) {
                    System.out.println("DIfferent 2");
                }
            }
            if (newR) {
                return false;
            }
            errorType = 3;
        }
        String msg = null;
        if (!(this.tinyNodeInst == null || this.tinyNodeInst != geom1 && this.tinyNodeInst != geom2 || this.tinyGeometric != geom1 && this.tinyGeometric != geom2)) {
            msg = this.tinyNodeInst.describe() + " is too small for the " + this.tinyGeometric.describe();
        }
        this.reportError(errorType, msg, cell, dist, pd, rule, origPoly1, geom1, layer1, origPoly2, geom2, layer2);
        return true;
    }

    private void checkTheseGeometrics(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity) {
        CheckProto cp = this.getCheckProto(cell);
        for (int i = 0; i < count; ++i) {
            Geometric geomToCheck = geomsToCheck[i];
            boolean errors = false;
            if (geomToCheck instanceof NodeInst) {
                NodeInst ni = (NodeInst)geomToCheck;
                errors = ni.getProto() instanceof Cell ? this.checkThisCellPlease(ni) : this.checkNodeInst(ni, 0);
            } else {
                ArcInst ai = (ArcInst)geomToCheck;
                errors = this.checkArcInst(cp, ai, 0);
            }
            if (validity == null) continue;
            validity[i] = !errors;
        }
    }

    private boolean checkThisCellPlease(NodeInst ni) {
        Cell cell = ni.getParent();
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        int globalIndex = 0;
        AffineTransform upTrans = ni.translateOut(ni.rotateOut());
        CheckInst ci = (CheckInst)this.checkInsts.get(ni);
        if (ci == null) {
            return false;
        }
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        Rectangle2D nodeBounds = ni.getBounds();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - this.worstInteractionDistance, nodeBounds.getMinY() - this.worstInteractionDistance, nodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
        Iterator it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Rectangle2D subNodeBounds;
            Rectangle2D.Double subBounds;
            NodeInst oNi;
            Geometric geom = (Geometric)it.next();
            if (geom == ni || !(geom instanceof ArcInst ? this.checkGeomAgainstInstance(netlist, geom, ni) : ((oNi = (NodeInst)geom).getProto() instanceof PrimitiveNode ? this.checkGeomAgainstInstance(netlist, geom, ni) : this.checkCellInstContents(subBounds = new Rectangle2D.Double((subNodeBounds = oNi.getBounds()).getMinX() - this.worstInteractionDistance, subNodeBounds.getMinY() - this.worstInteractionDistance, subNodeBounds.getWidth() + this.worstInteractionDistance * 2.0, subNodeBounds.getHeight() + this.worstInteractionDistance * 2.0), ni, upTrans, localIndex, oNi, globalIndex)))) continue;
            return true;
        }
        return false;
    }

    private boolean checkGeomAgainstInstance(Netlist netlist, Geometric geom, NodeInst ni) {
        NodeProto np = ni.getProto();
        int globalIndex = 0;
        Cell subCell = geom.getParent();
        boolean baseMulti = false;
        Technology tech = null;
        Poly[] nodeInstPolyList = null;
        AffineTransform trans = DBMath.MATID;
        if (geom instanceof NodeInst) {
            NodeInst oNi = (NodeInst)geom;
            tech = oNi.getProto().getTechnology();
            trans = oNi.rotateOut();
            nodeInstPolyList = tech.getShapeOfNode(oNi, null, true, this.ignoreCenterCuts, null);
            this.convertPseudoLayers(oNi, nodeInstPolyList);
            baseMulti = tech.isMultiCutCase(oNi);
        } else {
            ArcInst oAi = (ArcInst)geom;
            tech = oAi.getProto().getTechnology();
            nodeInstPolyList = tech.getShapeOfArc(oAi);
        }
        if (nodeInstPolyList == null) {
            return false;
        }
        int tot = nodeInstPolyList.length;
        CheckInst ci = (CheckInst)this.checkInsts.get(ni);
        if (ci == null) {
            return false;
        }
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        for (int j = 0; j < tot; ++j) {
            int net;
            double maxSize;
            double bound;
            Poly poly = nodeInstPolyList[j];
            Layer polyLayer = poly.getLayer();
            if (polyLayer == null || (bound = DRC.getMaxSurround(polyLayer, maxSize = poly.getMaxSize())) < 0.0) continue;
            if (geom instanceof NodeInst) {
                net = this.getDRCNetNumber(netlist, poly.getPort(), (NodeInst)geom, globalIndex);
            } else {
                ArcInst oAi = (ArcInst)geom;
                Network jNet = netlist.getNetwork(oAi, 0);
                Integer[] netNumbers = (Integer[])this.networkLists.get(jNet);
                net = netNumbers[globalIndex];
            }
            double minSize = poly.getMinSize();
            Rectangle2D polyBounds = poly.getBounds2D();
            Rectangle2D.Double subBounds = new Rectangle2D.Double(polyBounds.getMinX() - bound, polyBounds.getMinY() - bound, polyBounds.getWidth() + bound * 2.0, polyBounds.getHeight() + bound * 2.0);
            AffineTransform tempTrans = ni.rotateIn();
            AffineTransform tTransI = ni.translateIn();
            tempTrans.preConcatenate(tTransI);
            DBMath.transformRect(subBounds, tempTrans);
            AffineTransform subTrans = ni.translateOut(ni.rotateOut());
            if (!this.badBoxInArea(poly, polyLayer, tech, net, geom, trans, globalIndex, subBounds, (Cell)np, localIndex, subCell, globalIndex, subTrans, minSize, baseMulti, false)) continue;
            return true;
        }
        return false;
    }

    private boolean checkInteraction(NodeInst ni1, NodeInst ni2) {
        CheckProto cp = this.getCheckProto((Cell)ni1.getProto());
        if (cp.cellParameterized) {
            return false;
        }
        cp = this.getCheckProto((Cell)ni2.getProto());
        if (cp.cellParameterized) {
            return false;
        }
        if (ni1.getNodeIndex() < ni2.getNodeIndex()) {
            NodeInst swapni = ni1;
            ni1 = ni2;
            ni2 = swapni;
        } else if (ni1 == ni2) {
            int node1Orientation = ni1.getAngle();
            if (ni1.isMirroredAboutXAxis()) {
                node1Orientation += 3600;
            }
            if (ni1.isMirroredAboutYAxis()) {
                node1Orientation += 7200;
            }
            int node2Orientation = ni2.getAngle();
            if (ni2.isMirroredAboutXAxis()) {
                node2Orientation += 3600;
            }
            if (ni2.isMirroredAboutYAxis()) {
                node2Orientation += 7200;
            }
            if (node1Orientation < node2Orientation) {
                NodeInst swapNI = ni1;
                ni1 = ni2;
                ni2 = swapNI;
                System.out.println("Check this case in Quick.checkInteraction");
            }
        }
        InstanceInter dii = new InstanceInter();
        dii.cell1 = (Cell)ni1.getProto();
        dii.rot1 = ni1.getAngle();
        dii.mirrorX1 = ni1.isMirroredAboutXAxis();
        dii.mirrorY1 = ni1.isMirroredAboutYAxis();
        dii.cell2 = (Cell)ni2.getProto();
        dii.rot2 = ni2.getAngle();
        dii.mirrorX2 = ni2.isMirroredAboutXAxis();
        dii.mirrorY2 = ni2.isMirroredAboutYAxis();
        dii.dx = ni2.getAnchorCenterX() - ni1.getAnchorCenterX();
        dii.dy = ni2.getAnchorCenterY() - ni1.getAnchorCenterY();
        if (this.findInteraction(dii)) {
            return true;
        }
        this.instanceInteractionList.add(dii);
        return false;
    }

    private boolean findInteraction(InstanceInter dii) {
        Iterator it = this.instanceInteractionList.iterator();
        while (it.hasNext()) {
            InstanceInter thisII = (InstanceInter)it.next();
            if (thisII.cell1 != dii.cell1 || thisII.cell2 != dii.cell2 || thisII.rot1 != dii.rot1 || thisII.rot2 != dii.rot2 || thisII.mirrorX1 != dii.mirrorX1 || thisII.mirrorX2 != dii.mirrorX2 || thisII.mirrorY1 != dii.mirrorY1 || thisII.mirrorY2 != dii.mirrorY2 || thisII.dx != dii.dx || thisII.dy != dii.dy) continue;
            return true;
        }
        return false;
    }

    private CheckProto checkEnumerateProtos(Cell cell, Netlist netlist) {
        CheckProto cp = this.getCheckProto(cell);
        if (cp != null) {
            return cp;
        }
        cp = new CheckProto();
        cp.instanceCount = 0;
        cp.timeStamp = 0;
        cp.hierInstanceCount = 0;
        cp.totalPerCell = 0;
        cp.cellChecked = false;
        cp.cellParameterized = false;
        cp.treeParameterized = false;
        cp.netlist = netlist;
        Iterator vIt = cell.getVariables();
        while (vIt.hasNext()) {
            Variable var = (Variable)vIt.next();
            if (!var.getTextDescriptor().isParam()) continue;
            cp.cellParameterized = true;
            cp.treeParameterized = true;
            break;
        }
        this.checkProtos.put(cell, cp);
        Iterator nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = (NodeInst)nIt.next();
            if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
            Cell subCell = (Cell)ni.getProto();
            CheckInst ci = new CheckInst();
            this.checkInsts.put(ni, ci);
            CheckProto subCP = this.checkEnumerateProtos(subCell, netlist.getNetlist(ni));
            if (!subCP.treeParameterized) continue;
            cp.treeParameterized = true;
        }
        return cp;
    }

    private final CheckProto getCheckProto(Cell cell) {
        return (CheckProto)this.checkProtos.get(cell);
    }

    private void checkEnumerateInstances(Cell cell) {
        NodeProto np;
        NodeInst ni;
        if (this.job != null && this.job.checkAbort()) {
            return;
        }
        ++this.checkTimeStamp;
        ArrayList<CheckProto> subCheckProtos = new ArrayList<CheckProto>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            CheckProto cp = this.getCheckProto((Cell)np);
            if (cp.timeStamp != this.checkTimeStamp) {
                cp.timeStamp = this.checkTimeStamp;
                cp.instanceCount = 0;
                cp.nodesInCell = new ArrayList();
                subCheckProtos.add(cp);
            }
            CheckInst ci = (CheckInst)this.checkInsts.get(ni);
            ++cp.instanceCount;
            ci.localIndex = ci.localIndex;
            cp.nodesInCell.add(ci);
        }
        it = subCheckProtos.iterator();
        while (it.hasNext()) {
            CheckProto cp = (CheckProto)it.next();
            cp.hierInstanceCount += cp.instanceCount;
            Iterator nIt = cp.nodesInCell.iterator();
            while (nIt.hasNext()) {
                CheckInst ci = (CheckInst)nIt.next();
                ci.multiplier = cp.instanceCount;
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            this.checkEnumerateInstances((Cell)np);
        }
    }

    private void checkEnumerateNetworks(Cell cell, CheckProto cp, int globalIndex, HashMap enumeratedNets) {
        Iterator nIt = cp.netlist.getNetworks();
        while (nIt.hasNext()) {
            Network net = (Network)nIt.next();
            Integer netNumber = (Integer)enumeratedNets.get(net);
            Integer[] netNumbers = (Integer[])this.networkLists.get(net);
            netNumbers[globalIndex] = netNumber;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            CheckInst ci = (CheckInst)this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            Cell subCell = (Cell)np;
            CheckProto subCP = this.getCheckProto(subCell);
            HashMap<Network, Integer> subEnumeratedNets = new HashMap<Network, Integer>();
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                Export subPP = (Export)pi.getPortProto();
                Network net = cp.netlist.getNetwork(ni, subPP, 0);
                if (net == null) continue;
                Integer netNumber = (Integer)enumeratedNets.get(net);
                Network subNet = subCP.netlist.getNetwork(subPP, 0);
                subEnumeratedNets.put(subNet, netNumber);
            }
            Iterator nIt2 = subCP.netlist.getNetworks();
            while (nIt2.hasNext()) {
                Network net = (Network)nIt2.next();
                if (subEnumeratedNets.get(net) != null) continue;
                subEnumeratedNets.put(net, new Integer(this.checkNetNumber++));
            }
            this.checkEnumerateNetworks(subCell, subCP, localIndex, subEnumeratedNets);
        }
    }

    private boolean checkMinWidth(Geometric geom, Layer layer, Poly poly, boolean onlyOne) {
        Cell cell = geom.getParent();
        DRCRules.DRCRule minWidthRule = DRC.getMinValue(layer, 1);
        if (minWidthRule == null) {
            return false;
        }
        Rectangle2D bounds = poly.getBox();
        if (bounds != null) {
            Point2D.Double right3;
            Point2D.Double right2;
            Point2D.Double right1;
            Point2D.Double left3;
            Point2D.Double left2;
            Point2D.Double left1;
            boolean tooSmallWidth = DBMath.isGreaterThan(minWidthRule.value, bounds.getWidth());
            boolean tooSmallHeight = DBMath.isGreaterThan(minWidthRule.value, bounds.getHeight());
            if (!tooSmallWidth && !tooSmallHeight) {
                return false;
            }
            double actual = 0.0;
            String msg = "(X axis)";
            if (tooSmallWidth) {
                actual = bounds.getWidth();
                left1 = new Point2D.Double(bounds.getMinX() - TINYDELTA, bounds.getMinY());
                left2 = new Point2D.Double(bounds.getMinX() - TINYDELTA, bounds.getMaxY());
                left3 = new Point2D.Double(bounds.getMinX() - TINYDELTA, bounds.getCenterY());
                right1 = new Point2D.Double(bounds.getMaxX() + TINYDELTA, bounds.getMinY());
                right2 = new Point2D.Double(bounds.getMaxX() + TINYDELTA, bounds.getMaxY());
                right3 = new Point2D.Double(bounds.getMaxX() + TINYDELTA, bounds.getCenterY());
            } else {
                actual = bounds.getHeight();
                msg = "(Y axis)";
                left1 = new Point2D.Double(bounds.getMinX(), bounds.getMinY() - TINYDELTA);
                left2 = new Point2D.Double(bounds.getMaxX(), bounds.getMinY() - TINYDELTA);
                left3 = new Point2D.Double(bounds.getCenterX(), bounds.getMinY() - TINYDELTA);
                right1 = new Point2D.Double(bounds.getMinX(), bounds.getMaxY() + TINYDELTA);
                right2 = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY() + TINYDELTA);
                right3 = new Point2D.Double(bounds.getCenterX(), bounds.getMaxY() + TINYDELTA);
            }
            boolean[] pointsFound = new boolean[3];
            pointsFound[2] = false;
            pointsFound[1] = false;
            pointsFound[0] = false;
            Rectangle2D.Double newBounds = new Rectangle2D.Double(bounds.getMinX() - TINYDELTA, bounds.getMinY() - TINYDELTA, bounds.getWidth() + TINYDELTA * 2.0, bounds.getHeight() + TINYDELTA * 2.0);
            boolean zeroWide = bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0;
            boolean overlapLayer = this.lookForLayer(poly, cell, layer, DBMath.MATID, newBounds, left1, left2, left3, pointsFound);
            if (overlapLayer && !zeroWide) {
                return false;
            }
            pointsFound[2] = false;
            pointsFound[1] = false;
            pointsFound[0] = false;
            overlapLayer = this.lookForLayer(poly, cell, layer, DBMath.MATID, newBounds, right1, right2, right3, pointsFound);
            if (overlapLayer && !zeroWide) {
                return false;
            }
            int errorType = 2;
            String extraMsg = msg;
            String rule = minWidthRule.rule;
            if (zeroWide) {
                if (overlapLayer) {
                    extraMsg = " but covered by other layer";
                }
                errorType = 10;
                rule = null;
            }
            this.reportError(errorType, extraMsg, cell, minWidthRule.value, actual, rule, onlyOne ? null : poly, geom, layer, null, null, null);
            return !overlapLayer;
        }
        Poly.Type style = poly.getStyle();
        if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
            return false;
        }
        bounds = poly.getBounds2D();
        double actual = Math.min(bounds.getWidth(), bounds.getHeight());
        if (actual < minWidthRule.value) {
            this.reportError(2, null, cell, minWidthRule.value, actual, minWidthRule.rule, onlyOne ? null : poly, geom, layer, null, null, null);
            return true;
        }
        Point2D[] points = poly.getPoints();
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            Point2D to;
            Point2D from = i == 0 ? points[count - 1] : points[i - 1];
            if (from.equals(to = points[i])) continue;
            double ang = DBMath.figureAngleRadians(from, to);
            Point2D.Double center = new Point2D.Double((from.getX() + to.getX()) / 2.0, (from.getY() + to.getY()) / 2.0);
            double perpang = ang + 1.5707963267948966;
            for (int j = 0; j < count; ++j) {
                double fdy;
                double fdx;
                Point2D inter;
                double rOAng;
                Point2D oTo;
                Point2D oFrom;
                if (j == i || (oFrom = j == 0 ? points[count - 1] : points[j - 1]).equals(oTo = points[j])) continue;
                double oAng = DBMath.figureAngleRadians(oFrom, oTo);
                for (double rAng = ang; rAng > Math.PI; rAng -= Math.PI) {
                }
                for (rOAng = oAng; rOAng > Math.PI; rOAng -= Math.PI) {
                }
                if (DBMath.doublesEqual(oAng, rOAng) && (DBMath.isOnLine(from, to, oFrom) || DBMath.isOnLine(from, to, oTo) || DBMath.isOnLine(oFrom, oTo, from) || DBMath.isOnLine(oFrom, oTo, to)) || (inter = DBMath.intersectRadians(center, perpang, oFrom, oAng)) == null || inter.getX() < Math.min(oFrom.getX(), oTo.getX()) || inter.getX() > Math.max(oFrom.getX(), oTo.getX()) || inter.getY() < Math.min(oFrom.getY(), oTo.getY()) || inter.getY() > Math.max(oFrom.getY(), oTo.getY()) || !((actual = DBMath.round(Math.sqrt((fdx = ((Point2D)center).getX() - inter.getX()) * fdx + (fdy = ((Point2D)center).getY() - inter.getY()) * fdy))) < minWidthRule.value)) continue;
                if (poly.isInside(new Point2D.Double((((Point2D)center).getX() + inter.getX()) / 2.0, (((Point2D)center).getY() + inter.getY()) / 2.0))) {
                    this.reportError(2, null, cell, minWidthRule.value, actual, minWidthRule.rule, onlyOne ? null : poly, geom, layer, null, null, null);
                } else {
                    this.reportError(3, null, cell, minWidthRule.value, actual, minWidthRule.rule, onlyOne ? null : poly, geom, layer, poly, geom, layer);
                }
                return true;
            }
        }
        return false;
    }

    private int checkMinAreaLayer(GeometryHandler merge, Cell cell, Layer layer) {
        int errorFound = 0;
        DRCRules.DRCRule minAreaRule = (DRCRules.DRCRule)this.minAreaLayerMap.get(layer);
        DRCRules.DRCRule encloseAreaRule = (DRCRules.DRCRule)this.enclosedAreaLayerMap.get(layer);
        if (minAreaRule == null && encloseAreaRule == null) {
            return 0;
        }
        Collection set = merge.getObjects(layer, false, true);
        Iterator pIt = set.iterator();
        while (pIt.hasNext()) {
            PolyQTree.PolyNode pn = (PolyQTree.PolyNode)pIt.next();
            if (pn == null) {
                throw new Error("wrong condition in Quick.checkMinArea()");
            }
            List list = pn.getSortedLoops();
            DRCRules.DRCRule evenRule = list.size() % 2 == 0 ? encloseAreaRule : minAreaRule;
            DRCRules.DRCRule oddRule = evenRule == minAreaRule ? encloseAreaRule : minAreaRule;
            for (int i = 0; i < list.size(); ++i) {
                DRCRules.DRCRule minRule;
                PolyQTree.PolyNode simplePn = (PolyQTree.PolyNode)list.get(i);
                double area = simplePn.getArea();
                DRCRules.DRCRule dRCRule = minRule = i % 2 == 0 ? evenRule : oddRule;
                if (minRule == null || !DBMath.isGreaterThan(minRule.value, area)) continue;
                ++errorFound;
                int errorType = minRule == minAreaRule ? 7 : 8;
                this.reportError(errorType, null, cell, minRule.value, area, minRule.rule, new Poly(simplePn.getPoints()), null, layer, null, null, null);
            }
        }
        return errorFound;
    }

    private int checkMinArea(Cell cell) {
        CheckProto cp = this.getCheckProto(cell);
        int errorFound = 0;
        if (this.minAreaLayerMap.isEmpty() && this.enclosedAreaLayerMap.isEmpty()) {
            return 0;
        }
        PolyQTree selectMerge = new PolyQTree(cell.getBounds());
        HashMap notExportedNodes = new HashMap();
        HashMap checkedNodes = new HashMap();
        Iterator netIt = cp.netlist.getNetworks();
        while (netIt.hasNext()) {
            Network net = (Network)netIt.next();
            QuickAreaEnumerator quickArea = new QuickAreaEnumerator(net, selectMerge, notExportedNodes, checkedNodes);
            HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, cp.netlist, quickArea);
            if (this.job != null && this.job.checkAbort()) {
                return 0;
            }
            Iterator it = quickArea.mainMerge.getKeyIterator();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                errorFound += this.checkMinAreaLayer(quickArea.mainMerge, cell, layer);
            }
        }
        QuickAreaEnumerator quickArea = new QuickAreaEnumerator(notExportedNodes, checkedNodes);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, cp.netlist, quickArea);
        Iterator it = selectMerge.getKeyIterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            errorFound += this.checkMinAreaLayer(selectMerge, cell, layer);
        }
        return errorFound;
    }

    private int findInterveningPoints(Poly poly1, Poly poly2, Point2D pt1, Point2D pt2, boolean newFix) {
        Rectangle2D isBox1 = poly1.getBox();
        Rectangle2D isBox2 = poly2.getBox();
        if (newFix) {
            if (isBox1 == null) {
                isBox1 = poly1.getBounds2D();
            }
            if (isBox2 == null) {
                isBox2 = poly2.getBounds2D();
            }
        }
        if (isBox1 != null && isBox2 != null) {
            if (isBox1.getMinX() > isBox2.getMaxX() || isBox2.getMinX() > isBox1.getMaxX()) {
                if (isBox1.getMinY() <= isBox2.getMaxY() && isBox2.getMinY() <= isBox1.getMaxY()) {
                    double yf1 = Math.max(isBox1.getMinY(), isBox2.getMinY());
                    double yf2 = Math.min(isBox1.getMaxY(), isBox2.getMaxY());
                    if (isBox1.getMinX() > isBox2.getMaxX()) {
                        double x = (isBox1.getMinX() + isBox2.getMaxX()) / 2.0;
                        pt1.setLocation(x, yf1);
                        pt2.setLocation(x, yf2);
                    } else {
                        double x = (isBox2.getMinX() + isBox1.getMaxX()) / 2.0;
                        pt1.setLocation(x, yf1);
                        pt2.setLocation(x, yf2);
                    }
                    return 2;
                }
            } else if (isBox1.getMinY() > isBox2.getMaxY() || isBox2.getMinY() > isBox1.getMaxY()) {
                if (isBox1.getMinX() <= isBox2.getMaxX() && isBox2.getMinX() <= isBox1.getMaxX()) {
                    double xf1 = Math.max(isBox1.getMinX(), isBox2.getMinX());
                    double xf2 = Math.min(isBox1.getMaxX(), isBox2.getMaxX());
                    if (isBox1.getMinY() > isBox2.getMaxY()) {
                        double y = (isBox1.getMinY() + isBox2.getMaxY()) / 2.0;
                        pt1.setLocation(xf1, y);
                        pt2.setLocation(xf2, y);
                    } else {
                        double y = (isBox2.getMinY() + isBox1.getMaxY()) / 2.0;
                        pt1.setLocation(xf1, y);
                        pt2.setLocation(xf2, y);
                    }
                    return 2;
                }
            } else if (isBox1.getMinX() == isBox2.getMaxX() || isBox2.getMinX() == isBox1.getMaxX() || isBox1.getMinY() == isBox2.getMaxY() || isBox2.getMinY() == isBox2.getMaxY()) {
                double xc = isBox2.getMinX();
                if (isBox1.getMinX() == isBox2.getMaxX()) {
                    xc = isBox1.getMinX();
                }
                double yc = isBox2.getMinY();
                if (isBox1.getMinY() == isBox2.getMaxY()) {
                    yc = isBox1.getMinY();
                }
                double xPlus = xc + TINYDELTA;
                double yPlus = yc + TINYDELTA;
                pt1.setLocation(xPlus, yPlus);
                pt2.setLocation(xPlus, yPlus);
                if ((xPlus < isBox1.getMinX() || xPlus > isBox1.getMaxX() || yPlus < isBox1.getMinY() || yPlus > isBox1.getMaxY()) && (xPlus < isBox2.getMinX() || xPlus > isBox2.getMaxX() || yPlus < isBox2.getMinY() || yPlus > isBox2.getMaxY())) {
                    return 1;
                }
                pt1.setLocation(xc + TINYDELTA, yc - TINYDELTA);
                pt2.setLocation(xc - TINYDELTA, yc + TINYDELTA);
                return 1;
            }
            if (isBox1.getMinX() > isBox2.getMaxX()) {
                if (isBox1.getMinY() > isBox2.getMaxY()) {
                    pt1.setLocation(isBox1.getMinX(), isBox1.getMinY());
                    pt2.setLocation(isBox2.getMaxX(), isBox2.getMaxY());
                    return 1;
                }
                if (isBox2.getMinY() > isBox1.getMaxY()) {
                    pt1.setLocation(isBox1.getMinX(), isBox1.getMaxY());
                    pt2.setLocation(isBox2.getMaxX(), isBox2.getMinY());
                    return 1;
                }
            }
            if (isBox2.getMinX() > isBox1.getMaxX()) {
                if (isBox1.getMinY() > isBox2.getMaxY()) {
                    pt1.setLocation(isBox1.getMaxX(), isBox1.getMinY());
                    pt2.setLocation(isBox2.getMinX(), isBox2.getMaxY());
                    return 1;
                }
                if (isBox2.getMinY() > isBox1.getMaxY()) {
                    pt1.setLocation(isBox1.getMaxX(), isBox1.getMaxY());
                    pt2.setLocation(isBox2.getMinX(), isBox2.getMinY());
                    return 1;
                }
            }
        }
        isBox1 = poly1.getBounds2D();
        isBox2 = poly2.getBounds2D();
        pt1.setLocation((isBox1.getMinX() + isBox1.getMaxX()) / 2.0, (isBox2.getMinY() + isBox2.getMaxY()) / 2.0);
        pt2.setLocation((isBox2.getMinX() + isBox2.getMaxX()) / 2.0, (isBox1.getMinY() + isBox1.getMaxY()) / 2.0);
        return 1;
    }

    private boolean lookForPoints(Point2D pt1, Point2D pt2, Layer layer, Cell cell, boolean needBoth) {
        Point2D.Double pt3 = new Point2D.Double((pt1.getX() + pt2.getX()) / 2.0, (pt1.getY() + pt2.getY()) / 2.0);
        double flx = Math.min(pt1.getX(), pt2.getX());
        double fhx = Math.max(pt1.getX(), pt2.getX());
        double fly = Math.min(pt1.getY(), pt2.getY());
        double fhy = Math.max(pt1.getY(), pt2.getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(flx, fly, fhx - flx, fhy - fly);
        boolean[] pointsFound = new boolean[3];
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        boolean allFound = this.lookForLayer(null, cell, layer, DBMath.MATID, bounds, pt1, pt2, pt3, pointsFound);
        return needBoth ? allFound : pointsFound[0] || pointsFound[1];
    }

    private boolean lookForCrossPolygons(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Layer layer, Cell cell, boolean overlap) {
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        int intervening = this.findInterveningPoints(poly1, poly2, pt1, pt2, true);
        double flx = Math.min(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
        double fhx = Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
        double fly = Math.min(((Point2D)pt1).getY(), ((Point2D)pt2).getY());
        double fhy = Math.max(((Point2D)pt1).getY(), ((Point2D)pt2).getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(DBMath.round(flx - TINYDELTA), DBMath.round(fly - TINYDELTA), DBMath.round(fhx - flx + 2.0 * TINYDELTA), DBMath.round(fhy - fly + 2.0 * TINYDELTA));
        boolean[] pointsFound = new boolean[2];
        pointsFound[1] = false;
        pointsFound[0] = false;
        boolean allFound = this.lookForLayerNew(geo1, poly1, geo2, poly2, cell, layer, DBMath.MATID, bounds, pt1, pt2, null, pointsFound, overlap);
        return allFound;
    }

    private boolean lookForLayer(Poly thisPoly, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound) {
        boolean skip = false;
        Rectangle2D.Double newBounds = new Rectangle2D.Double();
        Iterator it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            Geometric g = (Geometric)it.next();
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.getProto() instanceof Cell) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut(ni.rotateOut());
                    trans.preConcatenate(moreTrans);
                    if (!this.lookForLayer(thisPoly, (Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                Poly[] layerLookPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts, null);
                int tot = layerLookPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    boolean newR;
                    Poly poly = layerLookPolyList[i];
                    if (!tech.sameLayer(poly.getLayer(), layer) || thisPoly != null && poly.polySame(thisPoly)) continue;
                    poly.transform(bound);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    boolean bl = newR = j == pointsFound.length;
                    if (!newR) continue;
                    return true;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                Poly[] layerLookPolyList = tech.getShapeOfArc(ai);
                int tot = layerLookPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    boolean newR;
                    Poly poly = layerLookPolyList[i];
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    boolean bl = newR = j == pointsFound.length;
                    if (!newR) continue;
                    return true;
                }
            }
            for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
            }
            if (j != pointsFound.length) continue;
            System.out.println("When?");
            return true;
        }
        if (skip) {
            System.out.println("This case in lookForLayerNew antes");
        }
        return false;
    }

    private boolean lookForLayerNew(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound, boolean overlap) {
        Rectangle2D.Double newBounds = new Rectangle2D.Double();
        Iterator it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            Geometric g = (Geometric)it.next();
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.getProto() instanceof Cell) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut(ni.rotateOut());
                    trans.preConcatenate(moreTrans);
                    if (!this.lookForLayerNew(geo1, poly1, geo2, poly2, (Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound, overlap)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                Poly[] layerLookPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts, null);
                int tot = layerLookPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = layerLookPolyList[i];
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(bound);
                    if (poly1 != null && !overlap && poly.polySame(poly1) || poly2 != null && !overlap && poly.polySame(poly2)) continue;
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    if (j == pointsFound.length) {
                        return true;
                    }
                    break;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                Poly[] layerLookPolyList = tech.getShapeOfArc(ai);
                int tot = layerLookPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = layerLookPolyList[i];
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    if (j == pointsFound.length) {
                        return true;
                    }
                    break;
                }
            }
            for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
            }
            if (j != pointsFound.length) continue;
            System.out.println("When?");
            return true;
        }
        return false;
    }

    private boolean checkSelectOverPolysilicon(Geometric geom, Layer layer, Poly poly, Cell cell) {
        if (DRC.isIgnorePolySelectChecking()) {
            return false;
        }
        if (!layer.getFunction().isPoly()) {
            return false;
        }
        DRCRules.DRCRule minOverlapRule = DRC.getMinValue(layer, 23);
        if (minOverlapRule == null) {
            return false;
        }
        Rectangle2D polyBnd = poly.getBounds2D();
        Area polyArea = new Area(poly);
        boolean found = polyArea.isEmpty();
        ArrayList checkExtraPoints = new ArrayList();
        if (!(found = this.checkThisCellSelectPolysilicon(geom, layer, poly, cell, polyArea, polyBnd, minOverlapRule, found, checkExtraPoints))) {
            List polyList = PolyBase.getPointsInArea(polyArea, layer, true);
            Iterator it = polyList.iterator();
            while (it.hasNext()) {
                PolyBase nPoly = (PolyBase)it.next();
                this.reportError(9, "Polysilicon not covered, ", cell, minOverlapRule.value, -1.0, minOverlapRule.rule, nPoly, geom, layer, null, null, null);
            }
        } else {
            Point2D[] extraPoints = new Point2D[checkExtraPoints.size()];
            checkExtraPoints.toArray(extraPoints);
            boolean[] founds = new boolean[checkExtraPoints.size()];
            Arrays.fill(founds, false);
            Rectangle2D.Double ruleBnd = new Rectangle2D.Double(polyBnd.getMinX() - minOverlapRule.value, polyBnd.getMinY() - minOverlapRule.value, polyBnd.getWidth() + minOverlapRule.value * 2.0, polyBnd.getHeight() + minOverlapRule.value * 2.0);
            boolean foundAll = this.allPointsContainedInLayer(geom, cell, ruleBnd, extraPoints, founds);
            if (!foundAll) {
                this.reportError(9, "No enough surround, ", geom.getParent(), minOverlapRule.value, -1.0, minOverlapRule.rule, poly, geom, layer, null, null, null);
            }
        }
        return !found;
    }

    private boolean checkThisCellSelectPolysilicon(Geometric geom, Layer layer, Poly poly, Cell cell, Area polyArea, Rectangle2D polyBnd, DRCRules.DRCRule minOverlapRule, boolean found, List checkExtraPoints) {
        boolean[] founds = new boolean[4];
        Iterator sIt = cell.searchIterator(polyBnd);
        while (!found && sIt.hasNext()) {
            Geometric g = (Geometric)sIt.next();
            if (g == geom) continue;
            if (!(g instanceof NodeInst)) {
                if (!Main.LOCALDEBUGFLAG) continue;
                System.out.println("Skipping arcs!");
                continue;
            }
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (NodeInst.isSpecialNode(ni)) continue;
            if (np instanceof Cell) {
                AffineTransform cellDownTrans = ni.transformIn();
                AffineTransform cellUpTrans = ni.transformOut();
                DBMath.transformRect(polyBnd, cellDownTrans);
                polyArea.transform(cellDownTrans);
                poly.transform(cellDownTrans);
                ArrayList newExtraPoints = new ArrayList();
                found = this.checkThisCellSelectPolysilicon(geom, layer, poly, (Cell)np, polyArea, polyBnd, minOverlapRule, found, newExtraPoints);
                Iterator it = newExtraPoints.iterator();
                while (it.hasNext()) {
                    Point2D point = (Point2D)it.next();
                    cellUpTrans.transform(point, point);
                    checkExtraPoints.add(point);
                }
                DBMath.transformRect(polyBnd, cellUpTrans);
                polyArea.transform(cellUpTrans);
                poly.transform(cellUpTrans);
            } else {
                Technology tech = np.getTechnology();
                Poly[] primPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts, null);
                int tot = primPolyList.length;
                for (int j = 0; j < tot; ++j) {
                    Poly nPoly = primPolyList[j];
                    if (!nPoly.getLayer().getFunction().isImplant()) continue;
                    Area distPolyArea = (Area)polyArea.clone();
                    Area nPolyArea = new Area(nPoly);
                    polyArea.subtract(nPolyArea);
                    distPolyArea.subtract(polyArea);
                    if (distPolyArea.isEmpty()) continue;
                    Rectangle2D interRect = distPolyArea.getBounds2D();
                    Rectangle2D.Double ruleBnd = new Rectangle2D.Double(interRect.getMinX() - minOverlapRule.value, interRect.getMinY() - minOverlapRule.value, interRect.getWidth() + minOverlapRule.value * 2.0, interRect.getHeight() + minOverlapRule.value * 2.0);
                    PolyBase extPoly = new PolyBase(ruleBnd);
                    PolyBase distPoly = new PolyBase(interRect);
                    Arrays.fill(founds, false);
                    Point2D[] points = extPoly.getPoints();
                    Point2D[] distPoints = distPoly.getPoints();
                    if (distPoints.length != points.length) {
                        System.out.println("This case is not valid in Quick.checkSelectOverPolysilicon");
                    }
                    for (int i = 0; i < points.length; ++i) {
                        found = poly.isPointOnCorner(distPoints[i]);
                        if (found) continue;
                        founds[i] = true;
                    }
                    boolean foundAll = this.allPointsContainedInLayer(geom, cell, ruleBnd, points, founds);
                    if (foundAll) continue;
                    for (int i = 0; i < founds.length; ++i) {
                        if (founds[i]) continue;
                        checkExtraPoints.add(points[i]);
                    }
                }
            }
            found = polyArea.isEmpty();
        }
        return found;
    }

    private boolean allPointsContainedInLayer(Geometric geom, Cell cell, Rectangle2D ruleBnd, Point2D[] points, boolean[] founds) {
        Iterator sIt = cell.searchIterator(ruleBnd);
        while (sIt.hasNext()) {
            Geometric g = (Geometric)sIt.next();
            if (g == geom || !(g instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (NodeInst.isSpecialNode(ni)) continue;
            if (np instanceof Cell) {
                AffineTransform cellDownTrans = ni.transformIn();
                AffineTransform cellUpTrans = ni.transformOut();
                DBMath.transformRect(ruleBnd, cellDownTrans);
                cellDownTrans.transform(points, 0, points, 0, points.length);
                boolean allFound = this.allPointsContainedInLayer(geom, (Cell)np, ruleBnd, points, founds);
                DBMath.transformRect(ruleBnd, cellUpTrans);
                cellUpTrans.transform(points, 0, points, 0, points.length);
                if (!allFound) continue;
                return true;
            }
            Technology tech = np.getTechnology();
            Poly[] primPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts, null);
            int tot = primPolyList.length;
            for (int j = 0; j < tot; ++j) {
                Poly nPoly = primPolyList[j];
                if (!nPoly.getLayer().getFunction().isImplant()) continue;
                boolean allFound = true;
                for (int i = 0; i < points.length; ++i) {
                    if (!founds[i]) {
                        founds[i] = nPoly.contains(points[i]);
                    }
                    if (founds[i]) continue;
                    allFound = false;
                }
                if (!allFound) continue;
                return true;
            }
        }
        return false;
    }

    private boolean activeOnTransistor(Poly poly1, Layer layer1, int net1, Poly poly2, Layer layer2, int net2, Cell cell, int globalIndex) {
        if (net1 == net2) {
            return false;
        }
        Layer.Function fun = layer1.getFunction();
        int funExtras = layer1.getFunctionExtras();
        if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
            return false;
        }
        funExtras = layer2.getFunctionExtras();
        fun = layer2.getFunction();
        if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
            return false;
        }
        Rectangle2D bounds1 = poly1.getBounds2D();
        Rectangle2D bounds2 = poly2.getBounds2D();
        Rectangle2D.union(bounds1, bounds2, bounds1);
        return this.activeOnTransistorRecurse(bounds1, net1, net2, cell, globalIndex, DBMath.MATID);
    }

    private boolean activeOnTransistorRecurse(Rectangle2D bounds, int net1, int net2, Cell cell, int globalIndex, AffineTransform trans) {
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Rectangle2D.Double subBounds = new Rectangle2D.Double();
        Iterator sIt = cell.searchIterator(bounds);
        while (sIt.hasNext()) {
            Geometric g = (Geometric)sIt.next();
            if (!(g instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (np instanceof Cell) {
                AffineTransform rTransI = ni.rotateIn();
                AffineTransform tTransI = ni.translateIn();
                rTransI.preConcatenate(tTransI);
                ((Rectangle2D)subBounds).setRect(bounds);
                DBMath.transformRect(subBounds, rTransI);
                CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                boolean ret = this.activeOnTransistorRecurse(subBounds, net1, net2, (Cell)np, localIndex, trans);
                if (!ret) continue;
                return true;
            }
            if (!ni.isFET()) continue;
            Rectangle2D nodeBounds = ni.getBounds();
            double cX = nodeBounds.getCenterX();
            double cY = nodeBounds.getCenterY();
            if (cX < bounds.getMinX() || cX > bounds.getMaxX() || cY < bounds.getMinY() || cY > bounds.getMaxY()) continue;
            PortProto badport = np.getPort(0);
            Network badNet = netlist.getNetwork(ni, badport, 0);
            boolean on1 = false;
            boolean on2 = false;
            Iterator it = ni.getPortInsts();
            while (it.hasNext()) {
                Integer[] netNumbers;
                int net;
                PortInst pi = (PortInst)it.next();
                PortProto po = pi.getPortProto();
                String name = po.getName();
                boolean found = false;
                boolean oldFound = false;
                Network piNet = netlist.getNetwork(pi);
                if (name.indexOf("poly") != -1) {
                    found = true;
                }
                if (piNet == badNet) {
                    oldFound = true;
                }
                if (Main.LOCALDEBUGFLAG && oldFound != found) {
                    System.out.println("Here is different in activeOnTransistorRecurse");
                }
                if (found || (net = (netNumbers = (Integer[])this.networkLists.get(piNet))[globalIndex].intValue()) < 0) continue;
                if (net == net1) {
                    on1 = true;
                }
                if (net != net2) continue;
                on2 = true;
            }
            if (!on1 || !on2) continue;
            return true;
        }
        return false;
    }

    private boolean cropNodeInst(NodeInst ni, int globalIndex, AffineTransform trans, Layer nLayer, int nNet, Geometric nGeom, Rectangle2D bound) {
        Technology tech = ni.getProto().getTechnology();
        Poly[] cropNodePolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts, null);
        this.convertPseudoLayers(ni, cropNodePolyList);
        int tot = cropNodePolyList.length;
        if (tot < 0) {
            return false;
        }
        for (int j = 0; j < tot; ++j) {
            cropNodePolyList[j].transform(trans);
        }
        boolean isConnected = false;
        Netlist netlist = this.getCheckProto((Cell)ni.getParent()).netlist;
        for (int j = 0; j < tot; ++j) {
            int net;
            Poly poly = cropNodePolyList[j];
            if (!tech.sameLayer(poly.getLayer(), nLayer) || nNet >= 0 && (poly.getPort() == null || (net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex)) >= 0 && net != nNet)) continue;
            isConnected = true;
            break;
        }
        if (!isConnected) {
            return false;
        }
        boolean allgone = false;
        for (int j = 0; j < tot; ++j) {
            Rectangle2D polyBox;
            Poly poly = cropNodePolyList[j];
            if (!tech.sameLayer(poly.getLayer(), nLayer) || (polyBox = poly.getBox()) == null) continue;
            int temp = Poly.cropBox(bound, polyBox);
            if (temp > 0) {
                allgone = true;
                break;
            }
            if (temp >= 0) continue;
            this.tinyNodeInst = ni;
            this.tinyGeometric = nGeom;
        }
        return allgone;
    }

    private boolean cropArcInst(ArcInst ai, Layer lay, AffineTransform inTrans, Rectangle2D bounds) {
        for (int i = 0; i < 2; ++i) {
            Connection con = ai.getConnection(i);
            PortInst pi = con.getPortInst();
            PortOriginal fp = new PortOriginal(pi, inTrans);
            NodeInst ni = fp.getBottomNodeInst();
            NodeProto np = ni.getProto();
            AffineTransform trans = fp.getTransformToTop();
            Technology tech = np.getTechnology();
            Poly[] cropArcPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts, null);
            int tot = cropArcPolyList.length;
            for (int j = 0; j < tot; ++j) {
                Poly poly = cropArcPolyList[j];
                if (!tech.sameLayer(poly.getLayer(), lay)) continue;
                poly.transform(trans);
                Rectangle2D polyBox = poly.getBox();
                if (polyBox == null) continue;
                int temp = Poly.halfCropBox(bounds, polyBox);
                if (temp > 0) {
                    return true;
                }
                if (temp >= 0) continue;
                this.tinyNodeInst = ni;
                this.tinyGeometric = ai;
            }
        }
        return false;
    }

    private void cropActiveArc(ArcInst ai, Poly[] pList) {
        int tot = pList.length;
        int diffPoly = -1;
        for (int j = 0; j < tot; ++j) {
            Layer.Function fun;
            Poly poly = pList[j];
            Layer layer = poly.getLayer();
            if (layer == null || !(fun = layer.getFunction()).isDiff()) continue;
            diffPoly = j;
            break;
        }
        if (diffPoly < 0) {
            return;
        }
        Poly poly = pList[diffPoly];
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        boolean cropped = false;
        boolean halved = false;
        boolean count = false;
        for (int i = 0; i < 2; ++i) {
            Connection con = ai.getConnection(i);
            PortInst pi = con.getPortInst();
            NodeInst ni = pi.getNodeInst();
            if (!ni.isFET()) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] activeCropPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts, null);
            int nTot = activeCropPolyList.length;
            for (int k = 0; k < nTot; ++k) {
                int result;
                Poly nPoly = activeCropPolyList[k];
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int n = result = halved ? Poly.cropBox(polyBounds, nPolyBounds) : Poly.halfCropBox(polyBounds, nPolyBounds);
                if (result == 1) {
                    poly.setLayer(null);
                    return;
                }
                cropped = true;
                halved = true;
            }
        }
        if (cropped) {
            Poly.Type style = poly.getStyle();
            Layer layer = poly.getLayer();
            poly = new Poly(polyBounds);
            poly.setStyle(style);
            poly.setLayer(layer);
            pList[diffPoly] = poly;
        }
    }

    private void convertPseudoLayers(NodeInst ni, Poly[] pList) {
        if (ni.getProto().getFunction() != PrimitiveNode.Function.PIN) {
            return;
        }
        if (ni.getNumConnections() != 0) {
            return;
        }
        if (ni.getNumExports() == 0) {
            return;
        }
        int tot = pList.length;
        for (int i = 0; i < tot; ++i) {
            Poly poly = pList[i];
            Layer layer = poly.getLayer();
            if (layer == null) continue;
            poly.setLayer(layer.getNonPseudoLayer());
        }
    }

    private void cacheValidLayers(Technology tech) {
        Layer layer;
        int i;
        Object[] layers;
        if (tech == null) {
            return;
        }
        if (this.layersValidTech == tech) {
            return;
        }
        this.layersValidTech = tech;
        int numLayers = tech.getNumLayers();
        this.layersValid = new boolean[numLayers];
        for (int i2 = 0; i2 < numLayers; ++i2) {
            this.layersValid[i2] = false;
        }
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (np.isNotUsed()) continue;
            layers = np.getLayers();
            for (i = 0; i < layers.length; ++i) {
                layer = ((Technology.NodeLayer)layers[i]).getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
        it = tech.getArcs();
        while (it.hasNext()) {
            PrimitiveArc ap = (PrimitiveArc)it.next();
            if (ap.isNotUsed()) continue;
            layers = ap.getLayers();
            for (i = 0; i < layers.length; ++i) {
                layer = ((Technology.ArcLayer)layers[i]).getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
    }

    private DRCRules.DRCRule getAdjustedMinDist(Layer layer1, double size1, Layer layer2, double size2, boolean con, boolean multi) {
        if (!con && layer1 == layer2) {
            Layer.Function fun = layer1.getFunction();
            if (!con && fun.isSubstrate()) {
                con = true;
            }
        }
        double wideS = size1 > size2 ? size1 : size2;
        return DRC.getSpacingRule(layer1, layer2, con, multi, wideS);
    }

    private int getDRCNetNumber(Netlist netlist, PortProto pp, NodeInst ni, int globalIndex) {
        if (pp == null) {
            return -1;
        }
        Network net = netlist.getNetwork(ni, pp, 0);
        Integer[] nets = (Integer[])this.networkLists.get(net);
        if (nets == null) {
            return -1;
        }
        return nets[globalIndex];
    }

    private void buildLayerInteractions(Technology tech) {
        Object[] layers;
        Technology old = this.layerInterTech;
        if (this.layerInterTech == tech) {
            return;
        }
        this.layerInterTech = tech;
        int numLayers = tech.getNumLayers();
        if (this.layersInterNodes != null && old != null && this.job != null) {
            ErrorLogger.MessageLog err = this.errorLogger.logWarning("Switching from '" + old.getTechName() + "' to '" + tech.getTechName() + "' in DRC process. Check for non desired nodes in cell '" + this.job.cell.describe() + "'", null, -1);
        }
        this.layersInterNodes = new HashMap();
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            boolean[] layersInNode = new boolean[numLayers];
            Arrays.fill(layersInNode, false);
            layers = np.getLayers();
            Technology.NodeLayer[] eLayers = np.getElectricalLayers();
            if (eLayers != null) {
                layers = eLayers;
            }
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = layers[i].getLayer();
                Iterator lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = (Layer)lIt.next();
                    if (!DRC.isAnyRule(layer, oLayer)) continue;
                    layersInNode[oLayer.getIndex()] = true;
                }
            }
            this.layersInterNodes.put(np, layersInNode);
        }
        this.layersInterArcs = new HashMap();
        it = tech.getArcs();
        while (it.hasNext()) {
            PrimitiveArc ap = (PrimitiveArc)it.next();
            boolean[] layersInArc = new boolean[numLayers];
            for (int i = 0; i < numLayers; ++i) {
                layersInArc[i] = false;
            }
            layers = ap.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = ((Technology.ArcLayer)layers[i]).getLayer();
                Iterator lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = (Layer)lIt.next();
                    if (!DRC.isAnyRule(layer, oLayer)) continue;
                    layersInArc[oLayer.getIndex()] = true;
                }
            }
            this.layersInterArcs.put(ap, layersInArc);
        }
    }

    private boolean checkLayerWithNode(Layer layer, NodeProto np) {
        this.buildLayerInteractions(np.getTechnology());
        boolean[] validLayers = (boolean[])this.layersInterNodes.get(np);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    private boolean checkLayerWithArc(Layer layer, ArcProto ap) {
        this.buildLayerInteractions(ap.getTechnology());
        boolean[] validLayers = (boolean[])this.layersInterArcs.get(ap);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    private void accumulateExclusion(Cell cell, AffineTransform upTrans) {
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (np == Generic.tech.drcNode) {
                DRCExclusion dex = new DRCExclusion();
                dex.cell = cell;
                dex.poly = new Poly(ni.getBounds());
                dex.poly.setStyle(Poly.Type.FILLED);
                dex.ni = ni;
                boolean found = false;
                Iterator dIt = this.exclusionList.iterator();
                while (dIt.hasNext()) {
                    DRCExclusion oDex = (DRCExclusion)dIt.next();
                    if (oDex.cell != cell || !oDex.poly.polySame(dex.poly)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.exclusionList.add(dex);
                continue;
            }
            if (!(np instanceof Cell)) continue;
            AffineTransform tTrans = ni.translateOut(ni.rotateOut());
            this.accumulateExclusion((Cell)np, tTrans);
        }
    }

    private void reportError(int errorType, String msg, Cell cell, double limit, double actual, String rule, PolyBase poly1, Geometric geom1, Layer layer1, PolyBase poly2, Geometric geom2, Layer layer2) {
        Cell np2;
        if (this.errorLogger == null) {
            return;
        }
        StringBuffer DRCexclusionMsg = new StringBuffer();
        if (this.exclusionList.size() > 0) {
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>(2);
            ArrayList<Geometric> geomList = new ArrayList<Geometric>(2);
            polyList.add(poly1);
            geomList.add(geom1);
            if (poly2 != null) {
                polyList.add(poly2);
                geomList.add(geom2);
            }
            Iterator it = this.exclusionList.iterator();
            while (it.hasNext()) {
                DRCExclusion dex = (DRCExclusion)it.next();
                if (cell != dex.cell) continue;
                Poly poly = dex.poly;
                int count = 0;
                for (int i = 0; i < polyList.size(); ++i) {
                    Poly thisPoly = (Poly)polyList.get(i);
                    if (thisPoly == null) continue;
                    boolean found = poly.contains(thisPoly.getBounds2D());
                    if (found) {
                        ++count;
                        continue;
                    }
                    DRCexclusionMsg.append("\n\t(DRC Exclusion '" + dex.ni.getName() + "' does not completely contain '" + ((Geometric)geomList.get(i)).describe() + "')");
                }
                if (count != polyList.size()) continue;
                return;
            }
        }
        Cell np1 = geom1 != null ? geom1.getParent() : null;
        Cell cell2 = np2 = geom2 != null ? geom2.getParent() : null;
        if (geom2 != null && this.errorLogger.findMessage(cell, geom1, geom2.getParent(), geom2)) {
            return;
        }
        StringBuffer errorMessage = new StringBuffer();
        int sortLayer = cell.hashCode();
        if (errorType == 1 || errorType == 3) {
            if (errorType == 1) {
                errorMessage.append("Spacing");
            } else {
                errorMessage.append("Notch");
            }
            if (layer1 == layer2) {
                errorMessage.append(" (layer " + layer1.getName() + ")");
            }
            errorMessage.append(": ");
            if (np1 != np2) {
                errorMessage.append("cell " + np1.describe() + ", ");
            } else if (np1 != cell) {
                errorMessage.append("[in cell " + np1.describe() + "] ");
            }
            if (geom1 instanceof NodeInst) {
                errorMessage.append("node " + geom1.describe());
            } else {
                errorMessage.append("arc " + geom1.describe());
            }
            if (layer1 != layer2) {
                errorMessage.append(", layer " + layer1.getName());
            }
            if (actual < 0.0) {
                errorMessage.append(" OVERLAPS ");
            } else if (actual == 0.0) {
                errorMessage.append(" TOUCHES ");
            } else {
                errorMessage.append(" LESS (BY " + TextUtils.formatDouble(limit - actual) + ") THAN " + TextUtils.formatDouble(limit) + " TO ");
            }
            if (np1 != np2) {
                errorMessage.append("cell " + np2.describe() + ", ");
            }
            if (geom2 instanceof NodeInst) {
                errorMessage.append("node " + geom2.describe());
            } else {
                errorMessage.append("arc " + geom2.describe());
            }
            if (layer1 != layer2) {
                errorMessage.append(", layer " + layer2.getName());
            }
            if (msg != null) {
                errorMessage.append("; " + msg);
            }
        } else {
            StringBuffer errorMessagePart2 = null;
            switch (errorType) {
                case 7: {
                    errorMessage.append("Minimum area error:");
                    errorMessagePart2 = new StringBuffer(", layer " + layer1.getName());
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case 8: {
                    errorMessage.append("Enclosed area error:");
                    errorMessagePart2 = new StringBuffer(", layer " + layer1.getName());
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case 11: {
                    errorMessage.append("Technology mixture warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case 10: {
                    errorMessage.append("Zero width warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case 2: {
                    errorMessage.append("Minimum width/heigh error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer " + layer1.getName());
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case 4: {
                    errorMessage.append("Minimum size error on " + msg + ":");
                    errorMessagePart2 = new StringBuffer(" LESS THAN " + TextUtils.formatDouble(limit) + " IN SIZE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case 5: {
                    errorMessage.append("Invalid layer (" + layer1.getName() + "):");
                    break;
                }
                case 9: {
                    errorMessage.append("Layer surround error: " + msg);
                    errorMessagePart2 = new StringBuffer(", layer " + layer1.getName());
                    errorMessagePart2.append(" NEEDS SURROUND OF LAYER Select BY " + limit);
                    break;
                }
                case 6: {
                    errorMessage.append("Layer surround error:");
                    errorMessagePart2 = new StringBuffer(", layer " + layer1.getName());
                    errorMessagePart2.append(" NEEDS SURROUND OF LAYER " + layer2.getName() + " BY " + limit);
                }
            }
            errorMessage.append(" cell '" + cell.describe() + "'");
            if (geom1 != null) {
                errorMessage.append(geom1 instanceof NodeInst ? ", node '" + geom1.describe() + "'" : ", arc '" + geom1.describe() + "'");
            }
            if (layer1 != null) {
                sortLayer = layer1.getIndex();
            }
            errorMessage.append(errorMessagePart2);
        }
        if (rule != null && rule.length() > 0) {
            errorMessage.append(" [rule " + rule + "]");
        }
        errorMessage.append(DRCexclusionMsg);
        ErrorLogger.MessageLog err = errorType == 10 || errorType == 11 ? this.errorLogger.logWarning(errorMessage.toString(), cell, sortLayer) : this.errorLogger.logError(errorMessage.toString(), cell, sortLayer);
        boolean showGeom = true;
        if (poly1 != null) {
            showGeom = false;
            err.addPoly(poly1, true, cell);
        }
        if (poly2 != null) {
            showGeom = false;
            err.addPoly(poly2, true, cell);
        }
        if (geom1 != null) {
            err.addGeom(geom1, showGeom, cell, null);
        }
        if (geom2 != null) {
            err.addGeom(geom2, showGeom, cell, null);
        }
    }

    private class QuickAreaEnumerator
    extends HierarchyEnumerator.Visitor {
        private Network jNet;
        private GeometryHandler mainMerge;
        private GeometryHandler otherTypeMerge;
        private Layer polyLayer;
        private HashMap notExportedNodes;
        private HashMap checkedNodes;

        public QuickAreaEnumerator(Network jNet, GeometryHandler selectMerge, HashMap notExportedNodes, HashMap checkedNodes) {
            this.jNet = jNet;
            this.otherTypeMerge = selectMerge;
            this.notExportedNodes = notExportedNodes;
            this.checkedNodes = checkedNodes;
        }

        public QuickAreaEnumerator(HashMap notExportedNodes, HashMap checkedNodes) {
            this.notExportedNodes = notExportedNodes;
            this.checkedNodes = checkedNodes;
        }

        private boolean searchNetworkInParent(Network net, HierarchyEnumerator.CellInfo info) {
            if (this.jNet == net) {
                return true;
            }
            HierarchyEnumerator.CellInfo cinfo = info;
            while (net != null && cinfo.getParentInst() != null) {
                if (this.jNet == (net = cinfo.getNetworkInParent(net))) {
                    return true;
                }
                cinfo = cinfo.getParentInfo();
            }
            return false;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (Quick.this.job != null && Quick.this.job.checkAbort()) {
                return false;
            }
            if (this.mainMerge == null) {
                this.mainMerge = new PolyQTree(info.getCell().getBounds());
            }
            AffineTransform rTrans = info.getTransformToRoot();
            if (this.jNet != null) {
                Iterator it = info.getCell().getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    Technology tech = ai.getProto().getTechnology();
                    Network aNet = info.getNetlist().getNetwork(ai, 0);
                    boolean found = false;
                    if (aNet != null) {
                        Iterator arcIt = aNet.getExports();
                        while (!found && arcIt.hasNext()) {
                            Export exp = (Export)arcIt.next();
                            Network net = info.getNetlist().getNetwork(exp, 0);
                            found = this.searchNetworkInParent(net, info);
                        }
                    }
                    if (!found && aNet != this.jNet) continue;
                    Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                    int tot = arcInstPolyList.length;
                    for (int i = 0; i < tot; ++i) {
                        Poly poly = arcInstPolyList[i];
                        Layer layer = poly.getLayer();
                        if (Quick.this.minAreaLayerMap.get(layer) == null && Quick.this.enclosedAreaLayerMap.get(layer) == null) continue;
                        if (layer.getFunction().isPoly()) {
                            if (this.polyLayer == null) {
                                this.polyLayer = layer;
                            }
                            layer = this.polyLayer;
                        }
                        poly.transform(rTrans);
                        if (layer.getFunction().isMetal() || layer.getFunction().isPoly()) {
                            this.mainMerge.add(layer, new PolyQTree.PolyNode(poly.getBounds2D()), false);
                            continue;
                        }
                        this.otherTypeMerge.add(layer, new PolyQTree.PolyNode(poly.getBounds2D()), false);
                    }
                }
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (Quick.this.job != null && Quick.this.job.checkAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            NodeInst ni = no.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            NodeProto np = ni.getProto();
            AffineTransform root = info.getTransformToRoot();
            if (root.getType() != 0) {
                trans.preConcatenate(root);
            }
            if (!(np instanceof PrimitiveNode)) {
                return true;
            }
            PrimitiveNode pNp = (PrimitiveNode)np;
            boolean found = false;
            boolean forceChecking = false;
            if (this.jNet != null) {
                boolean pureNode;
                boolean bl = pureNode = pNp.getFunction() == PrimitiveNode.Function.NODE;
                if (np instanceof PrimitiveNode) {
                    if (NodeInst.isSpecialNode(ni)) {
                        return false;
                    }
                    forceChecking = pNp.isPureImplantNode();
                }
                boolean notExported = false;
                Network thisNet = null;
                Iterator pIt = ni.getPortInsts();
                while (!found && pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    boolean isExported = cell.findPortProto(pi.getPortProto());
                    thisNet = info.getNetlist().getNetwork(pi);
                    found = this.searchNetworkInParent(thisNet, info);
                    if (isExported) continue;
                    notExported = true;
                }
                boolean bl2 = notExported = notExported && !forceChecking && !pureNode && info.getParentInfo() != null;
                if (!found) {
                    if (this.notExportedNodes != null && notExported) {
                        this.notExportedNodes.put(ni, ni);
                    }
                    return false;
                }
                this.notExportedNodes.remove(ni);
                this.checkedNodes.put(ni, ni);
            } else {
                if (!this.notExportedNodes.containsKey(ni)) {
                    return false;
                }
                if (this.checkedNodes.containsKey(ni)) {
                    return false;
                }
            }
            Technology tech = pNp.getTechnology();
            Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, null, true, true, null);
            int tot = nodeInstPolyList.length;
            for (int i = 0; i < tot; ++i) {
                Poly poly = nodeInstPolyList[i];
                Layer layer = poly.getLayer();
                if (Quick.this.minAreaLayerMap.get(layer) == null && Quick.this.enclosedAreaLayerMap.get(layer) == null) continue;
                if (this.jNet != null) {
                    PortProto pp = poly.getPort();
                    boolean bl = found = forceChecking && layer.getFunction().isImplant();
                    if (!found && pp != null) {
                        Network net = info.getNetlist().getNetwork(ni, pp, 0);
                        found = this.searchNetworkInParent(net, info);
                    }
                    if (!found) continue;
                }
                if (layer.getFunction().isPoly()) {
                    if (this.polyLayer == null) {
                        this.polyLayer = layer;
                    }
                    layer = this.polyLayer;
                }
                poly.roundPoints();
                poly.transform(trans);
                if (this.otherTypeMerge == null || layer.getFunction().isMetal() || layer.getFunction().isPoly()) {
                    this.mainMerge.add(layer, new PolyQTree.PolyNode(poly.getBounds2D()), false);
                    continue;
                }
                this.otherTypeMerge.add(layer, new PolyQTree.PolyNode(poly.getBounds2D()), false);
            }
            return true;
        }
    }

    private static class UpdateDRCDates
    extends Job {
        HashMap goodDRCDate;
        HashMap cleanDRCDate;

        protected UpdateDRCDates(HashMap goodDRCDate, HashMap cleanDRCDate) {
            super("Remember DRC Successes and/or Delete Obsolete Dates", DRC.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.goodDRCDate = goodDRCDate;
            this.cleanDRCDate = cleanDRCDate;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell;
            byte bits = DRC.getActiveBits();
            Iterator it = this.goodDRCDate.keySet().iterator();
            while (it.hasNext()) {
                cell = (Cell)it.next();
                Date now = (Date)this.goodDRCDate.get(cell);
                DRC.setLastDRCDateAndBits(cell, now, bits);
            }
            it = this.cleanDRCDate.keySet().iterator();
            while (it.hasNext()) {
                cell = (Cell)it.next();
                DRC.cleanDRCDateAndBits(cell);
            }
            return true;
        }
    }

    private static class DRCExclusion {
        Cell cell;
        Poly poly;
        NodeInst ni;

        private DRCExclusion() {
        }
    }

    private static class InstanceInter {
        Cell cell1;
        Cell cell2;
        int rot1;
        boolean mirrorX1;
        boolean mirrorY1;
        int rot2;
        boolean mirrorX2;
        boolean mirrorY2;
        double dx;
        double dy;

        private InstanceInter() {
        }
    }

    private static class CheckProto {
        int timeStamp;
        int instanceCount;
        int hierInstanceCount;
        int totalPerCell;
        boolean cellChecked;
        boolean cellParameterized;
        boolean treeParameterized;
        List nodesInCell;
        Netlist netlist;

        private CheckProto() {
        }
    }

    private static class CheckInst {
        int localIndex;
        int multiplier;
        int offset;

        private CheckInst() {
        }
    }
}

