/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class OptionReconcile
extends EDialog {
    private HashMap changedOptions;
    private ArrayList currentSettings;
    private JButton ignoreLibraryOptions;
    private JButton ok;
    private JLabel optionHeader;
    private JScrollPane optionPane;
    private JButton useLibraryOptions;

    public OptionReconcile(Frame parent, boolean modal, List optionsThatChanged, String libname) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.changedOptions = new HashMap();
        this.currentSettings = new ArrayList();
        JPanel optionBox = new JPanel();
        optionBox.setLayout(new GridBagLayout());
        this.optionPane.setViewportView(optionBox);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("OPTION"), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("CURRENT VALUE"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("LIBRARY VALUE"), gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        optionBox.add((Component)new JLabel("OPTION LOCATION"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        optionBox.add((Component)new JSeparator(), gbc);
        int rowNumber = 2;
        Iterator it = optionsThatChanged.iterator();
        while (it.hasNext()) {
            Pref.Meaning meaning = (Pref.Meaning)it.next();
            Pref pref = meaning.getPref();
            Object obj = meaning.getDesiredValue();
            if (obj.equals(pref.getValue())) continue;
            String oldValue = null;
            String newValue = null;
            switch (pref.getType()) {
                case 0: {
                    oldValue = (Integer)pref.getValue() == 0 ? "OFF" : "ON";
                    newValue = (Integer)obj == 0 ? "OFF" : "ON";
                    break;
                }
                case 1: {
                    int oldIntValue = (Integer)pref.getValue();
                    int newIntValue = (Integer)obj;
                    String[] trueMeaning = meaning.getTrueMeaning();
                    if (trueMeaning != null) {
                        oldValue = trueMeaning[oldIntValue];
                        newValue = trueMeaning[newIntValue];
                        break;
                    }
                    oldValue = Integer.toString(oldIntValue);
                    newValue = Integer.toString(newIntValue);
                    break;
                }
                case 3: {
                    oldValue = Double.toString((Double)pref.getValue());
                    if (obj instanceof Double) {
                        newValue = Double.toString((Double)obj);
                        break;
                    }
                    if (obj instanceof Float) {
                        newValue = Float.toString(((Float)obj).floatValue());
                        break;
                    }
                    System.out.println("HEY! option " + pref.getPrefName() + " should have Double/Float but instead has value " + obj);
                    break;
                }
                case 4: {
                    oldValue = pref.getValue().toString();
                    newValue = obj.toString();
                }
            }
            gbc.gridx = 1;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            optionBox.add((Component)new JLabel(meaning.getDescription()), gbc);
            gbc.gridx = 2;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            JRadioButton curValue = new JRadioButton(oldValue, false);
            this.currentSettings.add(curValue);
            optionBox.add((Component)curValue, gbc);
            gbc.gridx = 3;
            gbc.gridy = rowNumber;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            JRadioButton libValue = new JRadioButton(newValue, true);
            this.changedOptions.put(libValue, meaning);
            optionBox.add((Component)libValue, gbc);
            ButtonGroup group = new ButtonGroup();
            group.add(curValue);
            group.add(libValue);
            gbc.gridx = 4;
            gbc.gridy = rowNumber++;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            optionBox.add((Component)new JLabel(meaning.getLocation()), gbc);
        }
        this.optionHeader.setText("Library \"" + libname + "\" wants to use the following options which differ from the current options");
        this.pack();
        this.finishInitialization();
    }

    public void termDialog() {
        DoReconciliation job = new DoReconciliation(this.changedOptions);
    }

    private void initComponents() {
        this.ok = new JButton();
        this.optionPane = new JScrollPane();
        this.optionHeader = new JLabel();
        this.ignoreLibraryOptions = new JButton();
        this.useLibraryOptions = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Option Reconciliation");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionReconcile.this.closeDialog(evt);
            }
        });
        this.ok.setText("Use Above Settings");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.ok(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.optionPane.setMinimumSize(new Dimension(500, 150));
        this.optionPane.setPreferredSize(new Dimension(650, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.optionPane, gridBagConstraints);
        this.optionHeader.setText("This library wants to use the following options which are different from the current options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.optionHeader, gridBagConstraints);
        this.ignoreLibraryOptions.setText("Use All Current Options");
        this.ignoreLibraryOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.ignoreLibraryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignoreLibraryOptions, gridBagConstraints);
        this.useLibraryOptions.setText("Use All Library Options");
        this.useLibraryOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionReconcile.this.useLibraryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.useLibraryOptions, gridBagConstraints);
        this.pack();
    }

    private void useLibraryOptionsActionPerformed(ActionEvent evt) {
        Iterator it = this.changedOptions.keySet().iterator();
        while (it.hasNext()) {
            AbstractButton b = (AbstractButton)it.next();
            b.setSelected(true);
        }
        this.ok(null);
    }

    private void ignoreLibraryOptionsActionPerformed(ActionEvent evt) {
        Iterator it = this.currentSettings.iterator();
        while (it.hasNext()) {
            AbstractButton b = (AbstractButton)it.next();
            b.setSelected(true);
        }
        this.ok(null);
    }

    private void ok(ActionEvent evt) {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void updateButtonState() {
        boolean ignoreAllLibOptionsEnabled = false;
        boolean useAllLibOptionsEnabled = false;
        Iterator it = this.currentSettings.iterator();
        while (it.hasNext()) {
            AbstractButton b = (AbstractButton)it.next();
            if (b.isSelected()) {
                useAllLibOptionsEnabled = true;
            }
            if (b.isSelected()) continue;
            ignoreAllLibOptionsEnabled = true;
        }
        this.useLibraryOptions.setEnabled(useAllLibOptionsEnabled);
        this.ignoreLibraryOptions.setEnabled(ignoreAllLibOptionsEnabled);
    }

    private static class DoReconciliation
    extends Job {
        HashMap changedOptions;

        protected DoReconciliation(HashMap changedOptions) {
            super("Reconcile Options", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.changedOptions = changedOptions;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.changedOptions.keySet().iterator();
            while (it.hasNext()) {
                JRadioButton cb = (JRadioButton)it.next();
                if (!cb.isSelected()) continue;
                Pref.Meaning meaning = (Pref.Meaning)this.changedOptions.get(cb);
                Pref pref = meaning.getPref();
                Object obj = meaning.getDesiredValue();
                switch (pref.getType()) {
                    case 0: {
                        pref.setBoolean((Integer)obj != 0);
                        break;
                    }
                    case 1: {
                        pref.setInt((Integer)obj);
                        break;
                    }
                    case 3: {
                        if (obj instanceof Double) {
                            pref.setDouble((Double)obj);
                            break;
                        }
                        if (!(obj instanceof Float)) break;
                        pref.setDouble(((Float)obj).floatValue());
                        break;
                    }
                    case 4: {
                        pref.setString((String)obj);
                    }
                }
            }
            return true;
        }
    }
}

