/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore2.DetailedRouter;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RoutingFrameLeeMoore;
import com.sun.electric.tool.routing.experimentalLeeMoore2.SegPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class DetailedRouterWorker
implements Runnable {
    private MazeField mf;
    private final double offsetX;
    private final double offsetY;
    private final int offsetZ;
    private final int lengthX;
    private final int lengthY;
    private final int lengthZ;
    private static boolean enableOutput = false;
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 0;
    private GlobalRouterV3.RegionToRoute region;
    private final DetailedRouter.DetailedRoutingSolution allSolutions;
    private final DetailedRouter.DetailedRoutingSolution curSolutions;
    private final double tileSize;
    private double wireSpacing;
    private boolean isDone;
    private static RoutingFrameLeeMoore.ManhattenAlignment aStart;
    private static RoutingFrameLeeMoore.ManhattenAlignment aFinish;

    public DetailedRouterWorker(GlobalRouterV3.RegionToRoute region, RoutingFrame.RoutingLayer[] metalLayers, double tileSize) {
        this.tileSize = tileSize;
        this.wireSpacing = Double.MIN_VALUE;
        for (RoutingFrame.RoutingLayer lay : metalLayers) {
            if (null == lay) continue;
            this.wireSpacing = Math.max(lay.getMinSpacing(lay), this.wireSpacing);
        }
        this.offsetX = region.bounds.getMinX();
        this.offsetY = region.bounds.getMinY();
        this.offsetZ = 1;
        this.lengthX = (int)Math.round(region.bounds.getWidth() / tileSize) + 1;
        this.lengthY = (int)Math.round(region.bounds.getHeight() / tileSize) + 1;
        this.lengthZ = metalLayers.length - 1;
        this.allSolutions = new DetailedRouter.DetailedRoutingSolution();
        this.curSolutions = new DetailedRouter.DetailedRoutingSolution();
    }

    public void setRegion(GlobalRouterV3.RegionToRoute region) {
        this.region = region;
    }

    @Override
    public void run() {
        this.isDone = false;
        this.curSolutions.clear();
        List<SegPart> unrouted = this.region.segments_to_route;
        if (unrouted.size() > 0) {
            MazePoint finish;
            MazePoint start;
            this.mf = new MazeField(this.lengthX, this.lengthY, this.lengthZ);
            this.mf.resetAll();
            for (List solution : this.allSolutions.values()) {
                this.mf.addBlockage(this.getPointsToBlock(this.toMazePoint(solution)));
            }
            for (SegPart segs : unrouted) {
                start = this.toMazePoint(segs.segment_part.get(0));
                finish = this.toMazePoint(segs.segment_part.get(1));
                if (!this.mf.canBeReserved(start) || !this.mf.canBeReserved(finish)) continue;
                this.mf.reserve(start);
                this.mf.reserve(finish);
            }
            for (SegPart sp : unrouted) {
                this.mf.reset();
                start = this.toMazePoint(sp.segment_part.get(0));
                aStart = sp.segment_part.get((int)0).alignment;
                finish = this.toMazePoint(sp.segment_part.get(1));
                aFinish = sp.segment_part.get((int)1).alignment;
                if (this.mf.getValue(start) == -16 && this.mf.getValue(finish) == -16 && this.mf.setStart(start) && this.mf.setFinish(finish)) {
                    if (this.mf.wavefront()) {
                        DetailedRouterWorker.debug("1");
                        List<MazePoint> ws = this.mf.backtracking();
                        this.mf.addBlockage(this.getPointsToBlock(ws));
                        this.curSolutions.put(sp, this.toCoordinate(ws));
                        continue;
                    }
                    DetailedRouterWorker.debug("0");
                    continue;
                }
                DetailedRouterWorker.debug("?");
            }
        }
        this.mf = null;
        this.isDone = true;
    }

    private List<MazePoint> getPointsToBlock(List<MazePoint> lmp) {
        ArrayList<MazePoint> result = new ArrayList<MazePoint>();
        for (MazePoint mp : lmp) {
            result.add(mp);
        }
        if (lmp.size() > 0 && this.mf.contains(lmp.get(0))) {
            result.add(lmp.get(0));
        }
        if (lmp.size() > 0 && this.mf.contains(lmp.get(lmp.size() - 1))) {
            result.add(lmp.get(lmp.size() - 1));
        }
        return result;
    }

    private static void debug(String s) {
        if (enableOutput) {
            System.out.print(s);
        }
    }

    public void enableOutput() {
        enableOutput = true;
    }

    public DetailedRouter.DetailedRoutingSolution getSolution() {
        return this.curSolutions;
    }

    public void removeSolutions(List<Integer> ids) {
        Iterator it = this.curSolutions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry s = it.next();
            if (ids.contains(((SegPart)s.getKey()).id)) {
                it.remove();
                continue;
            }
            this.allSolutions.put((SegPart)s.getKey(), (List)s.getValue());
        }
    }

    public boolean isDone() {
        return this.isDone;
    }

    private List<MazePoint> toMazePoint(List<RoutingFrameLeeMoore.Coordinate> lc) {
        ArrayList<MazePoint> lm = new ArrayList<MazePoint>(lc.size());
        for (RoutingFrameLeeMoore.Coordinate c : lc) {
            lm.add(this.toMazePoint(c));
        }
        return lm;
    }

    private MazePoint toMazePoint(RoutingFrameLeeMoore.Coordinate c) {
        int x = (int)Math.floor((c.x - this.offsetX + 0.5 * this.tileSize) / this.tileSize);
        int y = (int)Math.floor((c.y - this.offsetY + 0.5 * this.tileSize) / this.tileSize);
        int z = c.layer - this.offsetZ;
        return new MazePoint(x, y, z);
    }

    private List<RoutingFrameLeeMoore.Coordinate> toCoordinate(List<MazePoint> lm) {
        ArrayList<RoutingFrameLeeMoore.Coordinate> result = new ArrayList<RoutingFrameLeeMoore.Coordinate>(lm.size());
        for (MazePoint mp : lm) {
            double x = (double)mp.x * this.tileSize + this.offsetX;
            double y = (double)mp.y * this.tileSize + this.offsetY;
            int z = mp.z + this.offsetZ;
            result.add(new RoutingFrameLeeMoore.Coordinate(x, y, z));
        }
        return result;
    }

    public static final class MazeField {
        private static final int POINT_UNDEFINED = 0;
        private static final int POINT_START = -1;
        private static final int POINT_FINISH = -2;
        private static final int POINT_BLOCK = -4;
        private static final int POINT_BORDER = -8;
        private static final int POINT_RESERVED = -16;
        private final int[][][] field;
        private MazePoint start;
        private MazePoint finish;

        public MazeField(int sizeX, int sizeY, int sizeZ) {
            this.field = new int[sizeX][sizeY][sizeZ];
        }

        public MazeField reset() {
            for (int x = 0; x < this.field.length; ++x) {
                for (int y = 0; y < this.field[x].length; ++y) {
                    for (int z = 0; z < this.field[x][y].length; ++z) {
                        if (this.getValue(x, y, z) == -4 || this.getValue(x, y, z) == -8 || this.getValue(x, y, z) == -16) continue;
                        this.setValue(x, y, z, 0);
                    }
                }
            }
            if (this.start != null && this.getValue(this.start) != -4) {
                this.setValue(this.start, -8);
            }
            if (this.finish != null && this.getValue(this.finish) != -4) {
                this.setValue(this.finish, -8);
            }
            return this;
        }

        public MazeField resetAll() {
            for (int x = 0; x < this.field.length; ++x) {
                for (int y = 0; y < this.field[x].length; ++y) {
                    for (int z = 0; z < this.field[x][y].length; ++z) {
                        if (x == 0 || x == this.field.length - 1 || y == 0 || y == this.field[x].length - 1) {
                            this.setValue(x, y, z, -8);
                            continue;
                        }
                        this.setValue(x, y, z, 0);
                    }
                }
            }
            return this;
        }

        public boolean setStart(MazePoint mp) {
            if (this.contains(mp) && (this.getValue(mp) == -8 || this.getValue(mp) == 0 || this.getValue(mp) == -16)) {
                this.start = mp;
                this.setValue(mp, -1);
                return true;
            }
            return false;
        }

        public boolean reserve(MazePoint mp) {
            if (this.contains(mp) && (this.getValue(mp) == -8 || this.getValue(mp) == 0)) {
                this.setValue(mp, -16);
                return true;
            }
            return false;
        }

        public boolean canBeReserved(MazePoint mp) {
            if (this.contains(mp)) {
                return this.getValue(mp) == -8 || this.getValue(mp) == 0;
            }
            return false;
        }

        public boolean setFinish(MazePoint mp) {
            if (this.contains(mp) && (this.getValue(mp) == -8 || this.getValue(mp) == 0 || this.getValue(mp) == -16)) {
                this.finish = mp;
                this.setValue(mp, -2);
                return true;
            }
            return false;
        }

        public void addBlockage(List<MazePoint> blockList) {
            for (MazePoint block : blockList) {
                this.addBlockage(block);
            }
        }

        public void addBlockage(MazePoint mp) {
            this.addBlockage(mp.x, mp.y, mp.z);
        }

        public void addBlockage(int x, int y, int z) {
            this.setValue(x, y, z, -4);
        }

        public void setValue(MazePoint mp, int i) {
            this.setValue(mp.x, mp.y, mp.z, i);
        }

        public void setValue(int x, int y, int z, int value) {
            if (this.contains(x, y, z)) {
                this.field[x][y][z] = value;
            }
        }

        public int getValue(MazePoint mp) {
            return this.getValue(mp.x, mp.y, mp.z);
        }

        public int getDistance(MazePoint m, MazePoint n) {
            return Math.abs(m.x - n.x) + Math.abs(m.y - n.y) + Math.abs(m.z - n.z);
        }

        public int getValue(int x, int y, int z) {
            if (this.contains(x, y, z)) {
                return this.field[x][y][z];
            }
            return -4;
        }

        public List<MazePoint> getNeighbours(MazePoint mp) {
            return this.getNeighbours(mp.x, mp.y, mp.z);
        }

        public List<MazePoint> getNeighbours(int x, int y, int z) {
            ArrayList<MazePoint> neighbours = new ArrayList<MazePoint>();
            int[] dx = new int[]{-1, 1, 0, 0, 0, 0};
            int[] dy = new int[]{0, 0, -1, 1, 0, 0};
            int[] dz = new int[]{0, 0, 0, 0, -1, 1};
            for (int i = 0; i < dx.length; ++i) {
                MazePoint n = new MazePoint(x + dx[i], y + dy[i], z + dz[i]);
                if (!this.contains(n)) continue;
                neighbours.add(n);
            }
            return neighbours;
        }

        private boolean contains(MazePoint mp) {
            return this.contains(mp.x, mp.y, mp.z);
        }

        private boolean contains(int x, int y, int z) {
            return 0 <= x && x < this.field.length && 0 <= y && y < this.field[x].length && 0 <= z && z < this.field[x][y].length;
        }

        public boolean wavefront() {
            MazeQueue queue = new MazeQueue();
            queue.add(this.getDistance(this.start, this.finish), this.start);
            while (queue.size() > 0) {
                MazePoint curP = queue.removeNext();
                block6: for (MazePoint nextP : this.getNeighbours(curP)) {
                    int nextValue = this.getValue(curP) + 1;
                    if (this.getValue(curP) == -1) {
                        nextValue = 1;
                    }
                    switch (this.getValue(nextP)) {
                        case -16: 
                        case -8: 
                        case -4: 
                        case -1: {
                            continue block6;
                        }
                        case -2: {
                            return true;
                        }
                        case 0: {
                            this.setValue(nextP, nextValue);
                            queue.add(this.getDistance(nextP, this.finish), nextP);
                            continue block6;
                        }
                    }
                    if (nextValue >= this.getValue(nextP)) continue;
                    this.setValue(nextP, nextValue);
                    queue.add(this.getDistance(nextP, this.finish), nextP);
                }
            }
            return false;
        }

        public List<MazePoint> backtracking() {
            ArrayList<MazePoint> route = new ArrayList<MazePoint>();
            route.add(new MazePoint(this.finish.x, this.finish.y, this.finish.z));
            MazePoint curPoint = this.finish;
            int curValue = Integer.MAX_VALUE;
            while (curValue != -1) {
                MazePoint nextPoint = curPoint;
                List<MazePoint> neighbours = this.getNeighbours(nextPoint);
                this.setValue(curPoint, -4);
                block4: for (MazePoint neighbour : neighbours) {
                    int value = this.getValue(neighbour);
                    switch (value) {
                        case -16: 
                        case -8: 
                        case -4: 
                        case -2: 
                        case 0: {
                            continue block4;
                        }
                    }
                    if (value >= curValue) continue;
                    nextPoint = neighbour;
                }
                if (nextPoint == curPoint) {
                    MazeField.debug("oops, this should never ever happen!\n");
                    continue;
                }
                curPoint = nextPoint;
                curValue = this.getValue(nextPoint);
                route.add(nextPoint);
            }
            Collections.reverse(route);
            return route;
        }

        public void debugPrintField() {
            MazeField.debug("\nstart: ");
            MazeField.printMazePoint(this.start);
            if (aStart == RoutingFrameLeeMoore.ManhattenAlignment.ma_horizontal) {
                MazeField.debug(" h");
            }
            if (aStart == RoutingFrameLeeMoore.ManhattenAlignment.ma_vertical) {
                MazeField.debug(" v");
            }
            if (aStart == RoutingFrameLeeMoore.ManhattenAlignment.ma_undefined) {
                MazeField.debug(" u");
            }
            MazeField.debug("\n");
            MazeField.debug("finish: ");
            MazeField.printMazePoint(this.finish);
            if (aFinish == RoutingFrameLeeMoore.ManhattenAlignment.ma_horizontal) {
                MazeField.debug(" h");
            }
            if (aFinish == RoutingFrameLeeMoore.ManhattenAlignment.ma_vertical) {
                MazeField.debug(" v");
            }
            if (aFinish == RoutingFrameLeeMoore.ManhattenAlignment.ma_undefined) {
                MazeField.debug(" u");
            }
            MazeField.debug("\n");
            for (int z = 0; z < this.field[0][0].length; ++z) {
                MazeField.debug("z: " + z + " " + ((z + 1) % 2 == 0 ? "vertical" : "horizontal") + "\n");
                for (int y = 0; y < this.field[0].length; ++y) {
                    block9: for (int x = 0; x < this.field.length; ++x) {
                        switch (this.getValue(x, y, z)) {
                            case -1: {
                                MazeField.debug("=S=");
                                continue block9;
                            }
                            case -2: {
                                MazeField.debug("=F=");
                                continue block9;
                            }
                            case -8: {
                                MazeField.debug(" B ");
                                continue block9;
                            }
                            case -4: {
                                MazeField.debug(" L ");
                                continue block9;
                            }
                            case -16: {
                                MazeField.debug(" R ");
                                continue block9;
                            }
                            default: {
                                int value = this.getValue(x, y, z);
                                MazeField.debug((value < 10 ? " " : "") + value + " ");
                            }
                        }
                    }
                    MazeField.debug("\n");
                }
            }
        }

        public static void debugPrintMazePointList(List<MazePoint> points) {
            for (MazePoint mp : points) {
                MazeField.printMazePoint(mp);
            }
            MazeField.debug(".\n");
        }

        public static void printMazePoint(MazePoint mp) {
            MazeField.debug("(" + mp.x + "," + mp.y + "," + mp.z + ") ");
        }

        private static void debug(String s) {
            if (enableOutput) {
                System.out.print(s);
            }
        }

        static final class MazeQueue
        extends TreeMap<Integer, List<MazePoint>> {
            private static final long serialVersionUID = -9114852150292907187L;

            MazeQueue() {
            }

            public void add(int distance, MazePoint mp) {
                if (!this.containsKey(distance)) {
                    this.put(distance, new ArrayList());
                }
                ((List)this.get(distance)).add(mp);
            }

            public MazePoint removeNext() {
                while (((List)this.get(this.firstKey())).size() == 0) {
                    this.remove(this.firstKey());
                }
                List next = (List)this.get(this.firstKey());
                MazePoint result = (MazePoint)next.remove(0);
                if (next.size() == 0) {
                    this.remove(this.firstKey());
                }
                return result;
            }
        }
    }

    public static final class MazePoint {
        public final int x;
        public final int y;
        public final int z;

        public MazePoint(int i, int j, int z) {
            this.x = i;
            this.y = j;
            this.z = z;
        }
    }
}

