// This file is part of tdir, the Taler Directory implementation.
// Copyright (C) 2022 Martin Schanzenbach
//
// Taldir is free software: you can redistribute it and/or modify it
// under the terms of the GNU Affero General Public License as published
// by the Free Software Foundation, either version 3 of the License,
// or (at your option) any later version.
//
// Taldir is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// SPDX-License-Identifier: AGPL3.0-or-later

package taldir

import (
	"github.com/schanzen/taler-go/pkg/merchant"
	"gopkg.in/ini.v1"
	"gorm.io/gorm"
)

type TaldirConfig struct {
	// The config to use
	Ini *ini.File

	// The Taldir Version
	Version string

	// The Taldir data home location (usually $datadir/taldir)
	Datahome string

	// The database connection to use
	Db gorm.Dialector

	// The merchant connection to use
	Merchant merchant.Merchant

	// The loglevel to use
	Loglevel LogLevel
}
