;;; Copyright © 2016, 2017  Roel Janssen <roel@gnu.org>
;;; Copyright © 2019 Ricardo Wurmus <rekado@elephly.net>
;;;
;;; This program is free software: you can redistribute it and/or
;;; modify it under the terms of the GNU Affero General Public License
;;; as published by the Free Software Foundation, either version 3 of
;;; the License, or (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Affero General Public License for more details.
;;;
;;; You should have received a copy of the GNU Affero General Public
;;; License along with this program.  If not, see
;;; <http://www.gnu.org/licenses/>.

(define-module (gwl www config)
  #:use-module (ice-9 match)
  #:export (web-config))

(define (web-config key)
  (match key
    ('root
     (dirname (search-path
               (map (lambda (path)
                      (string-append path "/gwl"))
                    %load-path) "web-interface.scm")))
    ('static-root
     (if (getenv "GWL_UNINSTALLED")
         (string-append (getcwd) "/gwl/static")
         "/usr/local/share/gwl/gwl/static"))
    ('examples-root
     (if (getenv "GWL_UNINSTALLED")
         (string-append (getcwd) "/doc/examples")
         "/usr/local/share/gwl/doc/examples"))
    ('workflows-directory #f)
    ('max-file-size 2500000000)
    ('port 5000)
    ('dot "/gnu/store/bqwsngla7ckmpvimg6l9xnp9c8mdhars-profile/bin/dot")))
