/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

const jsChecker = require("js_checker/js_checker");
var testRunner;
const remainingTests;

const constants = require("js_checker/constant_types");
var checkTypes = constants.checkTypes;


var ast;// = jsChecker.searchJs('var myValue = 0;', false, false, true);

var init = function (script) {
    var checker = jsChecker.jsChecker();
    checker.searchJs(script);
    checker.allowTrivial = {allowed: true};
    return checker;
};

exports.trivialTest = function (test) {
    var jsString = "alert('internal script');";
    //var ast = jsChecker.searchJs(jsString, false, false, {allowed: true});
    var res = init(jsString);
    //console.log(JSON.stringify(ast));
    test.assertEqual(checkTypes.TRIVIAL, res.parseTree.freeTrivialCheck);
};

exports.trivialTestWithFuncDef = function (test) {
    var jsString = "function blah (arg) { return arg; }";
    //var ast = jsChecker.searchJs(jsString, false, false, {allowed: true});
    var res = init(jsString);
    //console.log(JSON.stringify(ast));
    test.assertEqual(checkTypes.TRIVIAL_DEFINES_FUNCTION, res.parseTree.freeTrivialCheck);
};

exports.trivialTestWithFunc = function (test) {
    var jsString = "var blah = function (arg) { return arg; };";
    //var ast = jsChecker.searchJs(jsString, false, false, {allowed: true});
    var res = init(jsString);
    //console.log(JSON.stringify(ast));
    test.assertEqual(checkTypes.TRIVIAL_DEFINES_FUNCTION, res.parseTree.freeTrivialCheck);
};


exports.atrivialTest2 = function (test) {
    var jsString = "document.createElement('script');";
    var res = init(jsString);
    test.assertEqual(checkTypes.NONTRIVIAL_GLOBAL, res.parseTree.freeTrivialCheck);
};


exports.testlambdaError1 = function (test) {
    var jsString = "document.write('<scr' + 'ipt type=\"text/javascript\" src=\"' + regs_url + 'fdsfds.dew/' + regs_sitepage + '/1' + regs_rns + '@' + regs_listpos + regs_query + '\"></scr' + 'ipt>');";
    var res = init(jsString);
    //console.log(JSON.stringify(ast));
    test.assertEqual(checkTypes.NONTRIVIAL_GLOBAL, res.parseTree.freeTrivialCheck);
};


exports.testlambdaError = function (test) {
    var jsString = "_version = 11;\nif (navigator.userAgent.indexOf('Mozilla/3') != -1)\nregs_version = 10;\n\n if (regs_version >= 11) {\ndocument.write('<scr' + 'ipt type=\"text/javascript\" src=\"' + regs_url + 'fdsfds.dew/' + regs_sitepage + '/1' + regs_rns + '@' + regs_listpos + regs_query + '\"></scr' + 'ipt>');\n}";
    var res = init(jsString);
    //console.log(JSON.stringify(ast));
    test.assertEqual(checkTypes.NONTRIVIAL_GLOBAL, res.parseTree.freeTrivialCheck);
};


exports.testAstType = function (test) {
    // ensuring an object is returned when calling searchJs
    var res = init('var myValue = 0;');
    test.assertEqual('object', typeof res.parseTree);
    test.done();
};


exports.testAstValueNode = function (test) {
    // making sure we have a correct (as expected) tree
    var res = init('var myValue = 34423;');
    test.assertEqual('myValue', res.parseTree.children[0].children[0].value);
    test.done();
};

exports.testAstFunctionNode = function (test) {
    var res = init('function example (param1) { };');
    test.assertEqual(78, res.parseTree.children[0].type);
    test.done();
};

exports.testAstInvokesEval = function (test) {
    // ensuring "eval" is caught.
    var res = init('var string = "var i = 0;"; eval(string);');
    test.assertEqual('eval', res.parseTree.children[1].value);
    test.done();
};

exports.testBlockcomment = function (test) {
    var jsString = "/* A comment\n* for this new\n* file\n*\/\nvar myJS = 'a string';";
    var res = init(jsString);
    test.assertEqual(" A comment\n* for this new\n* file\n", res.parseTree.children[0].blockComments);
};

exports.testSingleLineComment = function (test) {
    var jsString = "// this is not free software\nvar myJS = 'a string';";
    var res = init(jsString);
    test.assertEqual(" this is not free software", res.parseTree.children[0].blockComments);
};


exports.testMultipleLineComment = function (test) {
    var i = 0, jsString, expectedResult, ast;

    jsString = "// Below I'm assigning 'a string' to variable myJS\n// this is rather complicated\nvar myJS = 'a string';";
    expectedResult = [" Below I'm assigning 'a string' to variable myJS", " this is rather complicated"];
    var res = init(jsString);
    for (; i < expectedResult.length; i++) { 
	test.assertEqual(expectedResult[i], res.parseTree.children[0].blockComments[i]);
    }
};

/*
exports.testFreeCheck = function (test) {
    var jsString = "\/* A comment\n* for this new\n* file\n*\/\nvar myJS = 'a string';";
    var res = init(jsString);
    test.assertNotEqual(true, res.parseTree.children[0]);
};
*/

exports.testContinueKeyword = function (test) {
    var jsString = "for (var i = 0; i < len; i++) {\n if (test) { continue; } }";
    var res = init(jsString);
    test.assertEqual(checkTypes.TRIVIAL, res.parseTree.freeTrivialCheck);
};