/* A Bison parser, made by GNU Bison 3.6.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.6.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         PKL_TAB_STYPE
#define YYLTYPE         PKL_TAB_LTYPE
/* Substitute the variable and function names.  */
#define yyparse         pkl_tab_parse
#define yylex           pkl_tab_lex
#define yyerror         pkl_tab_error
#define yydebug         pkl_tab_debug
#define yynerrs         pkl_tab_nerrs

/* First part of user prologue.  */
#line 35 "pkl-tab.y"

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include <xalloc.h>
#include <assert.h>
#include <string.h>
#include <gettext.h>
#define _(str) gettext (str)

#include "pk-utils.h"

#include "pkl.h"
#include "pkl-diag.h"
#include "pkl-ast.h"
#include "pkl-parser.h" /* For struct pkl_parser.  */

#include "pvm.h"

#define PKL_TAB_LTYPE pkl_ast_loc
#define YYDEBUG 1
#include "pkl-tab.h"
#include "pkl-lex.h"

#ifdef PKL_DEBUG
# include "pkl-gen.h"
#endif

#define scanner (pkl_parser->scanner)

/* YYLLOC_DEFAULT -> default code for computing locations.  */

#define PKL_AST_CHILDREN_STEP 12


/* Emit an error.  */

static void
pkl_tab_error (YYLTYPE *llocp,
               struct pkl_parser *pkl_parser,
               char const *err)
{
    pkl_error (pkl_parser->compiler, pkl_parser->ast, *llocp, "%s", err);
}

/* These are used in the defun_or_method rule.  */

#define IS_DEFUN 0
#define IS_METHOD 1

/* Register an argument in the compile-time environment.  This is used
   by function specifiers and try-catch statements.

   Return 0 if there was an error registering, 1 otherwise.  */

static int
pkl_register_arg (struct pkl_parser *parser, pkl_ast_node arg)
{
  pkl_ast_node arg_decl;
  pkl_ast_node arg_identifier = PKL_AST_FUNC_ARG_IDENTIFIER (arg);

  pkl_ast_node dummy
    = pkl_ast_make_integer (parser->ast, 0);
  PKL_AST_TYPE (dummy) = ASTREF (PKL_AST_FUNC_ARG_TYPE (arg));

  arg_decl = pkl_ast_make_decl (parser->ast,
                                PKL_AST_DECL_KIND_VAR,
                                arg_identifier,
                                dummy,
                                NULL /* source */);
  PKL_AST_LOC (arg_decl) = PKL_AST_LOC (arg);

  if (!pkl_env_register (parser->env,
                         PKL_ENV_NS_MAIN,
                         PKL_AST_IDENTIFIER_POINTER (arg_identifier),
                         arg_decl))
    {
      pkl_error (parser->compiler, parser->ast,PKL_AST_LOC (arg_identifier),
                 "duplicated argument name `%s' in function declaration",
                 PKL_AST_IDENTIFIER_POINTER (arg_identifier));
      /* Make sure to pop the function frame.  */
      parser->env = pkl_env_pop_frame (parser->env);
      return 0;
    }

  return 1;
}

/* Assert statement is a syntatic sugar that transforms to invocation of
   _pkl_assert function with appropriate arguments.

   This function accepts AST nodes corresponding to the condition and
   optional message of the assert statement, and also the location info
   of the statement.

   Returns NULL on failure, and expression statement AST node on success.  */

static pkl_ast_node
pkl_make_assertion (struct pkl_parser *p, pkl_ast_node cond, pkl_ast_node msg,
                    struct pkl_ast_loc stmt_loc)
{
  pkl_ast_node vfunc, call, call_arg;
  pkl_ast_node arg_cond, arg_msg, arg_lineinfo; /* _pkl_assert args */

  /* Make variable for `_pkl_assert` function */
  {
    const char *name = "_pkl_assert";
    pkl_ast_node vfunc_init;
    int back, over;

    vfunc_init = pkl_env_lookup (p->env, PKL_ENV_NS_MAIN, name, &back, &over);
    if (!vfunc_init
        || (PKL_AST_DECL_KIND (vfunc_init) != PKL_AST_DECL_KIND_FUNC))
      {
        pkl_error (p->compiler, p->ast, stmt_loc, "undefined function '%s'",
                   name);
        return NULL;
      }
    vfunc = pkl_ast_make_var (p->ast, pkl_ast_make_identifier (p->ast, name),
                              vfunc_init, back, over);
  }

  /* First argument of _pkl_assert */
  arg_cond = pkl_ast_make_funcall_arg (p->ast, cond, NULL);
  PKL_AST_LOC (arg_cond) = PKL_AST_LOC (cond);

  /* Second argument of _pkl_assert */
  if (msg == NULL)
    {
      pkl_ast_node stype = pkl_ast_make_string_type (p->ast);

      msg = pkl_ast_make_string (p->ast, "");
      PKL_AST_TYPE (msg) = ASTREF (stype);
    }
  arg_msg = pkl_ast_make_funcall_arg (p->ast, msg, NULL);
  arg_msg = ASTREF (arg_msg);
  PKL_AST_LOC (arg_msg) = PKL_AST_LOC (msg);

  /* Third argument of _pkl_assert to report the location of the assert
     statement with the following format "<FILENAME>:<LINE>:<COLUMN>".  */
  {
    char *str;
    pkl_ast_node lineinfo, stype;

    if (asprintf (&str, "%s:%d:%d", p->filename ? p->filename : "<stdin>",
                  stmt_loc.first_line, stmt_loc.first_column)
        == -1)
      return NULL;
    lineinfo = pkl_ast_make_string (p->ast, str);
    free (str);
    stype = pkl_ast_make_string_type (p->ast);
    PKL_AST_TYPE (lineinfo) = ASTREF (stype);

    arg_lineinfo = pkl_ast_make_funcall_arg (p->ast, lineinfo, NULL);
    arg_lineinfo = ASTREF (arg_lineinfo);
  }

  call_arg
      = pkl_ast_chainon (arg_cond, pkl_ast_chainon (arg_msg, arg_lineinfo));
  call = pkl_ast_make_funcall (p->ast, vfunc, call_arg);
  return pkl_ast_make_exp_stmt (p->ast, call);
}

#if 0
/* Register a list of arguments in the compile-time environment.  This
   is used by function specifiers and try-catch statements.

   Return 0 if there was an error registering, 1 otherwise.  */

static int
pkl_register_args (struct pkl_parser *parser, pkl_ast_node arg_list)
{
  pkl_ast_node arg;

  for (arg = arg_list; arg; arg = PKL_AST_CHAIN (arg))
    {
      pkl_ast_node arg_decl;
      pkl_ast_node arg_identifier = PKL_AST_FUNC_ARG_IDENTIFIER (arg);

      pkl_ast_node dummy
        = pkl_ast_make_integer (parser->ast, 0);
      PKL_AST_TYPE (dummy) = ASTREF (PKL_AST_FUNC_ARG_TYPE (arg));

      arg_decl = pkl_ast_make_decl (parser->ast,
                                    PKL_AST_DECL_KIND_VAR,
                                    arg_identifier,
                                    dummy,
                                    NULL /* source */);
      PKL_AST_LOC (arg_decl) = PKL_AST_LOC (arg);

      if (!pkl_env_register (parser->env,
                             PKL_ENV_NS_MAIN,
                             PKL_AST_IDENTIFIER_POINTER (arg_identifier),
                             arg_decl))
        {
          pkl_error (parser->compiler, parser->ast, PKL_AST_LOC (arg_identifier),
                     "duplicated argument name `%s' in function declaration",
                     PKL_AST_IDENTIFIER_POINTER (arg_identifier));
          /* Make sure to pop the function frame.  */
          parser->env = pkl_env_pop_frame (parser->env);
          return 0;
        }
    }

  return 1;
}
#endif

/* Register N dummy entries in the compilation environment.  */

static void
pkl_register_dummies (struct pkl_parser *parser, int n)
{
  int i;
  for (i = 0; i < n; ++i)
    {
      char *name;
      pkl_ast_node id;
      pkl_ast_node decl;
      int r;

      asprintf (&name, "@*UNUSABLE_OFF_%d*@", i);
      id = pkl_ast_make_identifier (parser->ast, name);
      decl = pkl_ast_make_decl (parser->ast,
                                PKL_AST_DECL_KIND_VAR,
                                id, NULL /* initial */,
                                NULL /* source */);

      r = pkl_env_register (parser->env, PKL_ENV_NS_MAIN, name, decl);
      assert (r);
    }
}

/* Load a module, given its name.
   If the module file cannot be read, return 1.
   If there is a parse error loading the module, return 2.
   Otherwise, return 0.  */

static int
load_module (struct pkl_parser *parser,
             const char *module, pkl_ast_node *node,
             int filename_p, char **filename)
{
  char *module_filename = NULL;
  pkl_ast ast;
  FILE *fp;

  module_filename = pkl_resolve_module (parser->compiler,
                                        module,
                                        filename_p);
  if (module_filename == NULL)
    /* No file found.  */
    return 1;

  if (pkl_module_loaded_p (parser->compiler, module_filename))
    {
      /* Module already loaded.  */
      *node = NULL;
      return 0;
    }

  fp = fopen (module_filename, "rb");
  if (!fp)
    {
      free (module_filename);
      return 1;
    }

  /* Parse the file, using the given environment.  The declarations
     found in the parsed file are appended to that environment, so
     nothing extra should be done about that.  */
  if (pkl_parse_file (parser->compiler, &parser->env, &ast, fp,
                      module_filename)
      != 0)
    {
      fclose (fp);
      free (module_filename);
      return 2;
    }

  /* Add the module to the compiler's list of loaded modules.  */
  pkl_add_module (parser->compiler, module_filename);

  /* However, the AST nodes shall be appended explicitly, which is
     achieved by returning them to the caller in the NODE
     argument.  */
  *node = PKL_AST_PROGRAM_ELEMS (ast->ast);

  /* Dirty hack is dirty, but it works.  */
  PKL_AST_PROGRAM_ELEMS (ast->ast) = NULL;
  pkl_ast_free (ast);

  /* Set the `filename' output argument if needed.  */
  if (filename)
    *filename = strdup (module_filename);

  fclose (fp);
  free (module_filename);
  return 0;
}


#line 381 "pkl-tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_PKL_TAB_PKL_TAB_TAB_H_INCLUDED
# define YY_PKL_TAB_PKL_TAB_TAB_H_INCLUDED
/* Debug traces.  */
#ifndef PKL_TAB_DEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define PKL_TAB_DEBUG 1
#  else
#   define PKL_TAB_DEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define PKL_TAB_DEBUG 1
# endif /* ! defined YYDEBUG */
#endif  /* ! defined PKL_TAB_DEBUG */
#if PKL_TAB_DEBUG
extern int pkl_tab_debug;
#endif

/* Token kinds.  */
#ifndef PKL_TAB_TOKENTYPE
# define PKL_TAB_TOKENTYPE
  enum pkl_tab_tokentype
  {
    PKL_TAB_EMPTY = -2,
    PKL_TAB_EOF = 0,               /* "end of file"  */
    PKL_TAB_error = 256,           /* error  */
    PKL_TAB_UNDEF = 257,           /* "invalid token"  */
    INTEGER = 258,                 /* "integer literal"  */
    INTEGER_OVERFLOW = 259,        /* INTEGER_OVERFLOW  */
    CHAR = 260,                    /* "character literal"  */
    STR = 261,                     /* "string"  */
    IDENTIFIER = 262,              /* "identifier"  */
    TYPENAME = 263,                /* "type name"  */
    UNIT = 264,                    /* "offset unit"  */
    ENUM = 265,                    /* "keyword `enum'"  */
    PINNED = 266,                  /* "keyword `pinned'"  */
    STRUCT = 267,                  /* "keyword `struct'"  */
    token = 268,                   /* token  */
    UNION = 269,                   /* "keyword `union'"  */
    CONST = 270,                   /* "keyword `const'"  */
    CONTINUE = 271,                /* "keyword `continue'"  */
    ELSE = 272,                    /* "keyword `else'"  */
    IF = 273,                      /* "keyword `if'"  */
    WHILE = 274,                   /* "keyword `while"  */
    UNTIL = 275,                   /* "keyword `until'"  */
    FOR = 276,                     /* "keyword `for'"  */
    IN = 277,                      /* "keyword `in'"  */
    WHERE = 278,                   /* "keyword `where'"  */
    SIZEOF = 279,                  /* "keyword `sizeof'"  */
    ASSERT = 280,                  /* "keyword `assert'"  */
    ERR = 281,                     /* "token"  */
    ALIEN = 282,                   /* ALIEN  */
    INTCONSTR = 283,               /* "int type constructor"  */
    UINTCONSTR = 284,              /* "uint type constructor"  */
    OFFSETCONSTR = 285,            /* "offset type constructor"  */
    DEFUN = 286,                   /* "keyword `fun'"  */
    DEFSET = 287,                  /* "keyword `defset'"  */
    DEFTYPE = 288,                 /* "keyword `type'"  */
    DEFVAR = 289,                  /* "keyword `var'"  */
    DEFUNIT = 290,                 /* "keyword `unit'"  */
    METHOD = 291,                  /* "keyword `method'"  */
    RETURN = 292,                  /* "keyword `return'"  */
    BREAK = 293,                   /* "keyword `break'"  */
    STRING = 294,                  /* "string type specifier"  */
    TRY = 295,                     /* "keyword `try'"  */
    CATCH = 296,                   /* "keyword `catch'"  */
    RAISE = 297,                   /* "keyword `raise'"  */
    VOID = 298,                    /* "void type specifier"  */
    ANY = 299,                     /* "any type specifier"  */
    PRINT = 300,                   /* "keyword `print'"  */
    PRINTF = 301,                  /* "keyword `printf'"  */
    LOAD = 302,                    /* "keyword `load'"  */
    LAMBDA = 303,                  /* "keyword `lambda'"  */
    BUILTIN_RAND = 304,            /* BUILTIN_RAND  */
    BUILTIN_GET_ENDIAN = 305,      /* BUILTIN_GET_ENDIAN  */
    BUILTIN_SET_ENDIAN = 306,      /* BUILTIN_SET_ENDIAN  */
    BUILTIN_GET_IOS = 307,         /* BUILTIN_GET_IOS  */
    BUILTIN_SET_IOS = 308,         /* BUILTIN_SET_IOS  */
    BUILTIN_OPEN = 309,            /* BUILTIN_OPEN  */
    BUILTIN_CLOSE = 310,           /* BUILTIN_CLOSE  */
    BUILTIN_IOSIZE = 311,          /* BUILTIN_IOSIZE  */
    BUILTIN_IOFLAGS = 312,         /* BUILTIN_IOFLAGS  */
    BUILTIN_GETENV = 313,          /* BUILTIN_GETENV  */
    BUILTIN_FORGET = 314,          /* BUILTIN_FORGET  */
    BUILTIN_GET_TIME = 315,        /* BUILTIN_GET_TIME  */
    BUILTIN_STRACE = 316,          /* BUILTIN_STRACE  */
    BUILTIN_TERM_RGB_TO_COLOR = 317, /* BUILTIN_TERM_RGB_TO_COLOR  */
    BUILTIN_TERM_GET_COLOR = 318,  /* BUILTIN_TERM_GET_COLOR  */
    BUILTIN_TERM_SET_COLOR = 319,  /* BUILTIN_TERM_SET_COLOR  */
    BUILTIN_TERM_GET_BGCOLOR = 320, /* BUILTIN_TERM_GET_BGCOLOR  */
    BUILTIN_TERM_SET_BGCOLOR = 321, /* BUILTIN_TERM_SET_BGCOLOR  */
    BUILTIN_TERM_BEGIN_CLASS = 322, /* BUILTIN_TERM_BEGIN_CLASS  */
    BUILTIN_TERM_END_CLASS = 323,  /* BUILTIN_TERM_END_CLASS  */
    BUILTIN_TERM_BEGIN_HYPERLINK = 324, /* BUILTIN_TERM_BEGIN_HYPERLINK  */
    BUILTIN_TERM_END_HYPERLINK = 325, /* BUILTIN_TERM_END_HYPERLINK  */
    BUILTIN_UNSAFE_STRING_SET = 326, /* BUILTIN_UNSAFE_STRING_SET  */
    POWA = 327,                    /* "power-and-assign operator"  */
    MULA = 328,                    /* "multiply-and-assign operator"  */
    DIVA = 329,                    /* "divide-and-assing operator"  */
    MODA = 330,                    /* "modulus-and-assign operator"  */
    ADDA = 331,                    /* "add-and-assing operator"  */
    SUBA = 332,                    /* "subtract-and-assign operator"  */
    SLA = 333,                     /* "shift-left-and-assign operator"  */
    SRA = 334,                     /* "shift-right-and-assign operator"  */
    BANDA = 335,                   /* "bit-and-and-assign operator"  */
    XORA = 336,                    /* "bit-xor-and-assign operator"  */
    IORA = 337,                    /* "bit-or-and-assign operator"  */
    RANGEA = 338,                  /* "range separator"  */
    OR = 339,                      /* "logical or operator"  */
    AND = 340,                     /* "logical and operator"  */
    EQ = 341,                      /* "equality operator"  */
    NE = 342,                      /* "inequality operator"  */
    LE = 343,                      /* "less-or-equal operator"  */
    GE = 344,                      /* "bigger-or-equal-than operator"  */
    SL = 345,                      /* "left shift operator"  */
    SR = 346,                      /* "right shift operator"  */
    CEILDIV = 347,                 /* "ceiling division operator"  */
    POW = 348,                     /* "power operator"  */
    BCONC = 349,                   /* "bit-concatenation operator"  */
    NSMAP = 350,                   /* "non-strict map operator"  */
    INC = 351,                     /* "increment operator"  */
    DEC = 352,                     /* "decrement operator"  */
    AS = 353,                      /* "cast operator"  */
    ISA = 354,                     /* "type identification operator"  */
    ATTR = 355,                    /* "attribute"  */
    UNMAP = 356,                   /* "unmap operator"  */
    BIG = 357,                     /* "keyword `big'"  */
    LITTLE = 358,                  /* "keyword `little'"  */
    SIGNED = 359,                  /* "keyword `signed'"  */
    UNSIGNED = 360,                /* "keyword `unsigned'"  */
    THREEDOTS = 361,               /* "varargs indicator"  */
    THEN = 362,                    /* THEN  */
    UNARY = 363,                   /* UNARY  */
    HYPERUNARY = 364,              /* HYPERUNARY  */
    START_EXP = 365,               /* START_EXP  */
    START_DECL = 366,              /* START_DECL  */
    START_STMT = 367,              /* START_STMT  */
    START_PROGRAM = 368            /* START_PROGRAM  */
  };
  typedef enum pkl_tab_tokentype pkl_tab_token_kind_t;
#endif

/* Value type.  */
#if ! defined PKL_TAB_STYPE && ! defined PKL_TAB_STYPE_IS_DECLARED
union PKL_TAB_STYPE
{
#line 338 "pkl-tab.y"

  pkl_ast_node ast;
  pkl_ast_node astpair[2];
  enum pkl_ast_op opcode;
  int integer;

#line 559 "pkl-tab.c"

};
typedef union PKL_TAB_STYPE PKL_TAB_STYPE;
# define PKL_TAB_STYPE_IS_TRIVIAL 1
# define PKL_TAB_STYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined PKL_TAB_LTYPE && ! defined PKL_TAB_LTYPE_IS_DECLARED
typedef struct PKL_TAB_LTYPE PKL_TAB_LTYPE;
struct PKL_TAB_LTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define PKL_TAB_LTYPE_IS_DECLARED 1
# define PKL_TAB_LTYPE_IS_TRIVIAL 1
#endif



int pkl_tab_parse (struct pkl_parser *pkl_parser);

#endif /* !YY_PKL_TAB_PKL_TAB_TAB_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_INTEGER = 3,                    /* "integer literal"  */
  YYSYMBOL_INTEGER_OVERFLOW = 4,           /* INTEGER_OVERFLOW  */
  YYSYMBOL_CHAR = 5,                       /* "character literal"  */
  YYSYMBOL_STR = 6,                        /* "string"  */
  YYSYMBOL_IDENTIFIER = 7,                 /* "identifier"  */
  YYSYMBOL_TYPENAME = 8,                   /* "type name"  */
  YYSYMBOL_UNIT = 9,                       /* "offset unit"  */
  YYSYMBOL_ENUM = 10,                      /* "keyword `enum'"  */
  YYSYMBOL_PINNED = 11,                    /* "keyword `pinned'"  */
  YYSYMBOL_STRUCT = 12,                    /* "keyword `struct'"  */
  YYSYMBOL_token = 13,                     /* token  */
  YYSYMBOL_UNION = 14,                     /* "keyword `union'"  */
  YYSYMBOL_CONST = 15,                     /* "keyword `const'"  */
  YYSYMBOL_CONTINUE = 16,                  /* "keyword `continue'"  */
  YYSYMBOL_ELSE = 17,                      /* "keyword `else'"  */
  YYSYMBOL_IF = 18,                        /* "keyword `if'"  */
  YYSYMBOL_WHILE = 19,                     /* "keyword `while"  */
  YYSYMBOL_UNTIL = 20,                     /* "keyword `until'"  */
  YYSYMBOL_FOR = 21,                       /* "keyword `for'"  */
  YYSYMBOL_IN = 22,                        /* "keyword `in'"  */
  YYSYMBOL_WHERE = 23,                     /* "keyword `where'"  */
  YYSYMBOL_SIZEOF = 24,                    /* "keyword `sizeof'"  */
  YYSYMBOL_ASSERT = 25,                    /* "keyword `assert'"  */
  YYSYMBOL_ERR = 26,                       /* "token"  */
  YYSYMBOL_ALIEN = 27,                     /* ALIEN  */
  YYSYMBOL_INTCONSTR = 28,                 /* "int type constructor"  */
  YYSYMBOL_UINTCONSTR = 29,                /* "uint type constructor"  */
  YYSYMBOL_OFFSETCONSTR = 30,              /* "offset type constructor"  */
  YYSYMBOL_DEFUN = 31,                     /* "keyword `fun'"  */
  YYSYMBOL_DEFSET = 32,                    /* "keyword `defset'"  */
  YYSYMBOL_DEFTYPE = 33,                   /* "keyword `type'"  */
  YYSYMBOL_DEFVAR = 34,                    /* "keyword `var'"  */
  YYSYMBOL_DEFUNIT = 35,                   /* "keyword `unit'"  */
  YYSYMBOL_METHOD = 36,                    /* "keyword `method'"  */
  YYSYMBOL_RETURN = 37,                    /* "keyword `return'"  */
  YYSYMBOL_BREAK = 38,                     /* "keyword `break'"  */
  YYSYMBOL_STRING = 39,                    /* "string type specifier"  */
  YYSYMBOL_TRY = 40,                       /* "keyword `try'"  */
  YYSYMBOL_CATCH = 41,                     /* "keyword `catch'"  */
  YYSYMBOL_RAISE = 42,                     /* "keyword `raise'"  */
  YYSYMBOL_VOID = 43,                      /* "void type specifier"  */
  YYSYMBOL_ANY = 44,                       /* "any type specifier"  */
  YYSYMBOL_PRINT = 45,                     /* "keyword `print'"  */
  YYSYMBOL_PRINTF = 46,                    /* "keyword `printf'"  */
  YYSYMBOL_LOAD = 47,                      /* "keyword `load'"  */
  YYSYMBOL_LAMBDA = 48,                    /* "keyword `lambda'"  */
  YYSYMBOL_BUILTIN_RAND = 49,              /* BUILTIN_RAND  */
  YYSYMBOL_BUILTIN_GET_ENDIAN = 50,        /* BUILTIN_GET_ENDIAN  */
  YYSYMBOL_BUILTIN_SET_ENDIAN = 51,        /* BUILTIN_SET_ENDIAN  */
  YYSYMBOL_BUILTIN_GET_IOS = 52,           /* BUILTIN_GET_IOS  */
  YYSYMBOL_BUILTIN_SET_IOS = 53,           /* BUILTIN_SET_IOS  */
  YYSYMBOL_BUILTIN_OPEN = 54,              /* BUILTIN_OPEN  */
  YYSYMBOL_BUILTIN_CLOSE = 55,             /* BUILTIN_CLOSE  */
  YYSYMBOL_BUILTIN_IOSIZE = 56,            /* BUILTIN_IOSIZE  */
  YYSYMBOL_BUILTIN_IOFLAGS = 57,           /* BUILTIN_IOFLAGS  */
  YYSYMBOL_BUILTIN_GETENV = 58,            /* BUILTIN_GETENV  */
  YYSYMBOL_BUILTIN_FORGET = 59,            /* BUILTIN_FORGET  */
  YYSYMBOL_BUILTIN_GET_TIME = 60,          /* BUILTIN_GET_TIME  */
  YYSYMBOL_BUILTIN_STRACE = 61,            /* BUILTIN_STRACE  */
  YYSYMBOL_BUILTIN_TERM_RGB_TO_COLOR = 62, /* BUILTIN_TERM_RGB_TO_COLOR  */
  YYSYMBOL_BUILTIN_TERM_GET_COLOR = 63,    /* BUILTIN_TERM_GET_COLOR  */
  YYSYMBOL_BUILTIN_TERM_SET_COLOR = 64,    /* BUILTIN_TERM_SET_COLOR  */
  YYSYMBOL_BUILTIN_TERM_GET_BGCOLOR = 65,  /* BUILTIN_TERM_GET_BGCOLOR  */
  YYSYMBOL_BUILTIN_TERM_SET_BGCOLOR = 66,  /* BUILTIN_TERM_SET_BGCOLOR  */
  YYSYMBOL_BUILTIN_TERM_BEGIN_CLASS = 67,  /* BUILTIN_TERM_BEGIN_CLASS  */
  YYSYMBOL_BUILTIN_TERM_END_CLASS = 68,    /* BUILTIN_TERM_END_CLASS  */
  YYSYMBOL_BUILTIN_TERM_BEGIN_HYPERLINK = 69, /* BUILTIN_TERM_BEGIN_HYPERLINK  */
  YYSYMBOL_BUILTIN_TERM_END_HYPERLINK = 70, /* BUILTIN_TERM_END_HYPERLINK  */
  YYSYMBOL_BUILTIN_UNSAFE_STRING_SET = 71, /* BUILTIN_UNSAFE_STRING_SET  */
  YYSYMBOL_POWA = 72,                      /* "power-and-assign operator"  */
  YYSYMBOL_MULA = 73,                      /* "multiply-and-assign operator"  */
  YYSYMBOL_DIVA = 74,                      /* "divide-and-assing operator"  */
  YYSYMBOL_MODA = 75,                      /* "modulus-and-assign operator"  */
  YYSYMBOL_ADDA = 76,                      /* "add-and-assing operator"  */
  YYSYMBOL_SUBA = 77,                      /* "subtract-and-assign operator"  */
  YYSYMBOL_SLA = 78,                       /* "shift-left-and-assign operator"  */
  YYSYMBOL_SRA = 79,                       /* "shift-right-and-assign operator"  */
  YYSYMBOL_BANDA = 80,                     /* "bit-and-and-assign operator"  */
  YYSYMBOL_XORA = 81,                      /* "bit-xor-and-assign operator"  */
  YYSYMBOL_IORA = 82,                      /* "bit-or-and-assign operator"  */
  YYSYMBOL_RANGEA = 83,                    /* "range separator"  */
  YYSYMBOL_OR = 84,                        /* "logical or operator"  */
  YYSYMBOL_AND = 85,                       /* "logical and operator"  */
  YYSYMBOL_86_bit_wise_or_operator_ = 86,  /* "bit-wise or operator"  */
  YYSYMBOL_87_bit_wise_xor_operator_ = 87, /* "bit-wise xor operator"  */
  YYSYMBOL_88_bit_wise_and_operator_ = 88, /* "bit-wise and operator"  */
  YYSYMBOL_EQ = 89,                        /* "equality operator"  */
  YYSYMBOL_NE = 90,                        /* "inequality operator"  */
  YYSYMBOL_LE = 91,                        /* "less-or-equal operator"  */
  YYSYMBOL_GE = 92,                        /* "bigger-or-equal-than operator"  */
  YYSYMBOL_93_less_than_operator_ = 93,    /* "less-than operator"  */
  YYSYMBOL_94_bigger_than_operator_ = 94,  /* "bigger-than operator"  */
  YYSYMBOL_SL = 95,                        /* "left shift operator"  */
  YYSYMBOL_SR = 96,                        /* "right shift operator"  */
  YYSYMBOL_97_addition_operator_ = 97,     /* "addition operator"  */
  YYSYMBOL_98_subtraction_operator_ = 98,  /* "subtraction operator"  */
  YYSYMBOL_99_multiplication_operator_ = 99, /* "multiplication operator"  */
  YYSYMBOL_100_division_operator_ = 100,   /* "division operator"  */
  YYSYMBOL_CEILDIV = 101,                  /* "ceiling division operator"  */
  YYSYMBOL_102_modulus_operator_ = 102,    /* "modulus operator"  */
  YYSYMBOL_POW = 103,                      /* "power operator"  */
  YYSYMBOL_BCONC = 104,                    /* "bit-concatenation operator"  */
  YYSYMBOL_105_map_operator_ = 105,        /* "map operator"  */
  YYSYMBOL_NSMAP = 106,                    /* "non-strict map operator"  */
  YYSYMBOL_INC = 107,                      /* "increment operator"  */
  YYSYMBOL_DEC = 108,                      /* "decrement operator"  */
  YYSYMBOL_AS = 109,                       /* "cast operator"  */
  YYSYMBOL_ISA = 110,                      /* "type identification operator"  */
  YYSYMBOL_111_dot_operator_ = 111,        /* "dot operator"  */
  YYSYMBOL_ATTR = 112,                     /* "attribute"  */
  YYSYMBOL_UNMAP = 113,                    /* "unmap operator"  */
  YYSYMBOL_BIG = 114,                      /* "keyword `big'"  */
  YYSYMBOL_LITTLE = 115,                   /* "keyword `little'"  */
  YYSYMBOL_SIGNED = 116,                   /* "keyword `signed'"  */
  YYSYMBOL_UNSIGNED = 117,                 /* "keyword `unsigned'"  */
  YYSYMBOL_THREEDOTS = 118,                /* "varargs indicator"  */
  YYSYMBOL_THEN = 119,                     /* THEN  */
  YYSYMBOL_120_ = 120,                     /* '?'  */
  YYSYMBOL_121_ = 121,                     /* ':'  */
  YYSYMBOL_UNARY = 122,                    /* UNARY  */
  YYSYMBOL_HYPERUNARY = 123,               /* HYPERUNARY  */
  YYSYMBOL_START_EXP = 124,                /* START_EXP  */
  YYSYMBOL_START_DECL = 125,               /* START_DECL  */
  YYSYMBOL_START_STMT = 126,               /* START_STMT  */
  YYSYMBOL_START_PROGRAM = 127,            /* START_PROGRAM  */
  YYSYMBOL_128_ = 128,                     /* ','  */
  YYSYMBOL_129_ = 129,                     /* ';'  */
  YYSYMBOL_130_ = 130,                     /* '('  */
  YYSYMBOL_131_ = 131,                     /* ')'  */
  YYSYMBOL_132_ = 132,                     /* '{'  */
  YYSYMBOL_133_ = 133,                     /* '}'  */
  YYSYMBOL_134_ = 134,                     /* '~'  */
  YYSYMBOL_135_ = 135,                     /* '!'  */
  YYSYMBOL_136_ = 136,                     /* '['  */
  YYSYMBOL_137_ = 137,                     /* ']'  */
  YYSYMBOL_138_ = 138,                     /* '='  */
  YYSYMBOL_YYACCEPT = 139,                 /* $accept  */
  YYSYMBOL_pushlevel = 140,                /* pushlevel  */
  YYSYMBOL_start = 141,                    /* start  */
  YYSYMBOL_program = 142,                  /* program  */
  YYSYMBOL_program_elem_list = 143,        /* program_elem_list  */
  YYSYMBOL_program_elem = 144,             /* program_elem  */
  YYSYMBOL_load = 145,                     /* load  */
  YYSYMBOL_identifier = 146,               /* identifier  */
  YYSYMBOL_expression_list = 147,          /* expression_list  */
  YYSYMBOL_expression_opt = 148,           /* expression_opt  */
  YYSYMBOL_expression = 149,               /* expression  */
  YYSYMBOL_bconc = 150,                    /* bconc  */
  YYSYMBOL_mapop = 151,                    /* mapop  */
  YYSYMBOL_map = 152,                      /* map  */
  YYSYMBOL_unary_operator = 153,           /* unary_operator  */
  YYSYMBOL_primary = 154,                  /* primary  */
  YYSYMBOL_155_1 = 155,                    /* $@1  */
  YYSYMBOL_funcall = 156,                  /* funcall  */
  YYSYMBOL_funcall_arg_list = 157,         /* funcall_arg_list  */
  YYSYMBOL_funcall_arg = 158,              /* funcall_arg  */
  YYSYMBOL_opt_comma = 159,                /* opt_comma  */
  YYSYMBOL_struct_field_list = 160,        /* struct_field_list  */
  YYSYMBOL_struct_field = 161,             /* struct_field  */
  YYSYMBOL_array = 162,                    /* array  */
  YYSYMBOL_array_initializer_list = 163,   /* array_initializer_list  */
  YYSYMBOL_array_initializer = 164,        /* array_initializer  */
  YYSYMBOL_pushlevel_args = 165,           /* pushlevel_args  */
  YYSYMBOL_function_specifier = 166,       /* function_specifier  */
  YYSYMBOL_function_arg_list = 167,        /* function_arg_list  */
  YYSYMBOL_function_arg = 168,             /* function_arg  */
  YYSYMBOL_function_arg_initial = 169,     /* function_arg_initial  */
  YYSYMBOL_type_specifier = 170,           /* type_specifier  */
  YYSYMBOL_typename = 171,                 /* typename  */
  YYSYMBOL_string_type_specifier = 172,    /* string_type_specifier  */
  YYSYMBOL_simple_type_specifier = 173,    /* simple_type_specifier  */
  YYSYMBOL_cons_type_specifier = 174,      /* cons_type_specifier  */
  YYSYMBOL_integral_type_specifier = 175,  /* integral_type_specifier  */
  YYSYMBOL_integral_type_sign = 176,       /* integral_type_sign  */
  YYSYMBOL_offset_type_specifier = 177,    /* offset_type_specifier  */
  YYSYMBOL_array_type_specifier = 178,     /* array_type_specifier  */
  YYSYMBOL_function_type_specifier = 179,  /* function_type_specifier  */
  YYSYMBOL_function_type_arg_list = 180,   /* function_type_arg_list  */
  YYSYMBOL_function_type_arg = 181,        /* function_type_arg  */
  YYSYMBOL_struct_type_specifier = 182,    /* struct_type_specifier  */
  YYSYMBOL_183_2 = 183,                    /* $@2  */
  YYSYMBOL_struct_or_union = 184,          /* struct_or_union  */
  YYSYMBOL_struct_type_pinned = 185,       /* struct_type_pinned  */
  YYSYMBOL_integral_struct = 186,          /* integral_struct  */
  YYSYMBOL_struct_type_elem_list = 187,    /* struct_type_elem_list  */
  YYSYMBOL_endianness = 188,               /* endianness  */
  YYSYMBOL_struct_type_field = 189,        /* struct_type_field  */
  YYSYMBOL_190_3 = 190,                    /* $@3  */
  YYSYMBOL_struct_type_field_identifier = 191, /* struct_type_field_identifier  */
  YYSYMBOL_struct_type_field_label = 192,  /* struct_type_field_label  */
  YYSYMBOL_struct_type_field_constraint_and_init = 193, /* struct_type_field_constraint_and_init  */
  YYSYMBOL_struct_type_field_optcond = 194, /* struct_type_field_optcond  */
  YYSYMBOL_simple_declaration = 195,       /* simple_declaration  */
  YYSYMBOL_declaration = 196,              /* declaration  */
  YYSYMBOL_197_4 = 197,                    /* @4  */
  YYSYMBOL_defun_or_method = 198,          /* defun_or_method  */
  YYSYMBOL_defvar_list = 199,              /* defvar_list  */
  YYSYMBOL_defvar = 200,                   /* defvar  */
  YYSYMBOL_deftype_list = 201,             /* deftype_list  */
  YYSYMBOL_deftype = 202,                  /* deftype  */
  YYSYMBOL_defunit_list = 203,             /* defunit_list  */
  YYSYMBOL_defunit = 204,                  /* defunit  */
  YYSYMBOL_comp_stmt = 205,                /* comp_stmt  */
  YYSYMBOL_builtin = 206,                  /* builtin  */
  YYSYMBOL_stmt_decl_list = 207,           /* stmt_decl_list  */
  YYSYMBOL_ass_exp_op = 208,               /* ass_exp_op  */
  YYSYMBOL_simple_stmt_list = 209,         /* simple_stmt_list  */
  YYSYMBOL_simple_stmt = 210,              /* simple_stmt  */
  YYSYMBOL_stmt = 211,                     /* stmt  */
  YYSYMBOL_212_5 = 212,                    /* @5  */
  YYSYMBOL_213_6 = 213,                    /* @6  */
  YYSYMBOL_print_stmt_arg_list = 214,      /* print_stmt_arg_list  */
  YYSYMBOL_funcall_stmt = 215,             /* funcall_stmt  */
  YYSYMBOL_funcall_stmt_arg_list = 216,    /* funcall_stmt_arg_list  */
  YYSYMBOL_funcall_stmt_arg = 217          /* funcall_stmt_arg  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef N_
# define N_(Msgid) Msgid
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL \
             && defined PKL_TAB_STYPE_IS_TRIVIAL && PKL_TAB_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  82
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3229

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  139
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  79
/* YYNRULES -- Number of rules.  */
#define YYNRULES  276
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  480

#define YYMAXUTOK   368


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   135,     2,     2,     2,   102,    88,     2,
     130,   131,    99,    97,   128,    98,   111,   100,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   121,   129,
      93,   138,    94,   120,   105,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   136,     2,   137,    87,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   132,    86,   133,   134,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    89,    90,    91,    92,    95,    96,   101,   103,   104,
     106,   107,   108,   109,   110,   112,   113,   114,   115,   116,
     117,   118,   119,   122,   123,   124,   125,   126,   127
};

#if PKL_TAB_DEBUG
  /* YYRLINEYYN -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   551,   551,   566,   572,   579,   585,   591,   597,   607,
     613,   619,   628,   632,   636,   637,   647,   648,   649,   653,
     687,   727,   728,   736,   738,   739,   746,   747,   751,   752,
     758,   763,   770,   776,   782,   788,   794,   799,   804,   810,
     816,   822,   828,   834,   840,   846,   852,   858,   864,   870,
     876,   882,   888,   894,   899,   904,   910,   924,   944,   959,
     974,   980,   986,   987,   991,  1000,  1001,  1005,  1011,  1020,
    1021,  1022,  1023,  1024,  1028,  1057,  1063,  1070,  1076,  1082,
    1090,  1091,  1097,  1102,  1108,  1114,  1120,  1126,  1132,  1133,
    1138,  1137,  1152,  1158,  1167,  1176,  1178,  1179,  1186,  1195,
    1196,  1200,  1202,  1203,  1210,  1217,  1228,  1239,  1240,  1247,
    1253,  1266,  1280,  1290,  1303,  1304,  1311,  1321,  1347,  1348,
    1356,  1357,  1358,  1362,  1377,  1385,  1390,  1395,  1396,  1397,
    1398,  1399,  1403,  1404,  1405,  1409,  1420,  1421,  1425,  1456,
    1467,  1473,  1481,  1488,  1498,  1499,  1506,  1512,  1519,  1538,
    1558,  1556,  1618,  1619,  1623,  1624,  1628,  1629,  1633,  1634,
    1635,  1637,  1642,  1643,  1644,  1649,  1648,  1757,  1758,  1762,
    1766,  1774,  1779,  1785,  1791,  1799,  1810,  1814,  1826,  1827,
    1828,  1833,  1832,  1895,  1899,  1900,  1904,  1905,  1910,  1932,
    1933,  1938,  1962,  1963,  1968,  2007,  2015,  2023,  2034,  2035,
    2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,
    2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,
    2059,  2060,  2062,  2063,  2068,  2069,  2070,  2071,  2072,  2073,
    2074,  2075,  2076,  2077,  2078,  2082,  2083,  2084,  2089,  2095,
    2106,  2112,  2118,  2124,  2133,  2140,  2147,  2156,  2157,  2162,
    2166,  2172,  2178,  2194,  2214,  2232,  2231,  2285,  2284,  2337,
    2342,  2347,  2353,  2359,  2365,  2371,  2381,  2392,  2398,  2404,
    2410,  2422,  2426,  2437,  2446,  2447,  2454
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  static const char *const yy_sname[] =
  {
  N_("end of file"), N_("error"), N_("invalid token"),
  N_("integer literal"), "INTEGER_OVERFLOW", N_("character literal"),
  N_("string"), N_("identifier"), N_("type name"), N_("offset unit"),
  N_("keyword `enum'"), N_("keyword `pinned'"), N_("keyword `struct'"),
  "token", N_("keyword `union'"), N_("keyword `const'"),
  N_("keyword `continue'"), N_("keyword `else'"), N_("keyword `if'"),
  N_("keyword `while"), N_("keyword `until'"), N_("keyword `for'"),
  N_("keyword `in'"), N_("keyword `where'"), N_("keyword `sizeof'"),
  N_("keyword `assert'"), N_("token"), "ALIEN", N_("int type constructor"),
  N_("uint type constructor"), N_("offset type constructor"),
  N_("keyword `fun'"), N_("keyword `defset'"), N_("keyword `type'"),
  N_("keyword `var'"), N_("keyword `unit'"), N_("keyword `method'"),
  N_("keyword `return'"), N_("keyword `break'"),
  N_("string type specifier"), N_("keyword `try'"), N_("keyword `catch'"),
  N_("keyword `raise'"), N_("void type specifier"),
  N_("any type specifier"), N_("keyword `print'"), N_("keyword `printf'"),
  N_("keyword `load'"), N_("keyword `lambda'"), "BUILTIN_RAND",
  "BUILTIN_GET_ENDIAN", "BUILTIN_SET_ENDIAN", "BUILTIN_GET_IOS",
  "BUILTIN_SET_IOS", "BUILTIN_OPEN", "BUILTIN_CLOSE", "BUILTIN_IOSIZE",
  "BUILTIN_IOFLAGS", "BUILTIN_GETENV", "BUILTIN_FORGET",
  "BUILTIN_GET_TIME", "BUILTIN_STRACE", "BUILTIN_TERM_RGB_TO_COLOR",
  "BUILTIN_TERM_GET_COLOR", "BUILTIN_TERM_SET_COLOR",
  "BUILTIN_TERM_GET_BGCOLOR", "BUILTIN_TERM_SET_BGCOLOR",
  "BUILTIN_TERM_BEGIN_CLASS", "BUILTIN_TERM_END_CLASS",
  "BUILTIN_TERM_BEGIN_HYPERLINK", "BUILTIN_TERM_END_HYPERLINK",
  "BUILTIN_UNSAFE_STRING_SET", N_("power-and-assign operator"),
  N_("multiply-and-assign operator"), N_("divide-and-assing operator"),
  N_("modulus-and-assign operator"), N_("add-and-assing operator"),
  N_("subtract-and-assign operator"), N_("shift-left-and-assign operator"),
  N_("shift-right-and-assign operator"), N_("bit-and-and-assign operator"),
  N_("bit-xor-and-assign operator"), N_("bit-or-and-assign operator"),
  N_("range separator"), N_("logical or operator"),
  N_("logical and operator"), N_("bit-wise or operator"),
  N_("bit-wise xor operator"), N_("bit-wise and operator"),
  N_("equality operator"), N_("inequality operator"),
  N_("less-or-equal operator"), N_("bigger-or-equal-than operator"),
  N_("less-than operator"), N_("bigger-than operator"),
  N_("left shift operator"), N_("right shift operator"),
  N_("addition operator"), N_("subtraction operator"),
  N_("multiplication operator"), N_("division operator"),
  N_("ceiling division operator"), N_("modulus operator"),
  N_("power operator"), N_("bit-concatenation operator"),
  N_("map operator"), N_("non-strict map operator"),
  N_("increment operator"), N_("decrement operator"), N_("cast operator"),
  N_("type identification operator"), N_("dot operator"), N_("attribute"),
  N_("unmap operator"), N_("keyword `big'"), N_("keyword `little'"),
  N_("keyword `signed'"), N_("keyword `unsigned'"),
  N_("varargs indicator"), "THEN", "'?'", "':'", "UNARY", "HYPERUNARY",
  "START_EXP", "START_DECL", "START_STMT", "START_PROGRAM", "','", "';'",
  "'('", "')'", "'{'", "'}'", "'~'", "'!'", "'['", "']'", "'='", "$accept",
  "pushlevel", "start", "program", "program_elem_list", "program_elem",
  "load", "identifier", "expression_list", "expression_opt", "expression",
  "bconc", "mapop", "map", "unary_operator", "primary", "$@1", "funcall",
  "funcall_arg_list", "funcall_arg", "opt_comma", "struct_field_list",
  "struct_field", "array", "array_initializer_list", "array_initializer",
  "pushlevel_args", "function_specifier", "function_arg_list",
  "function_arg", "function_arg_initial", "type_specifier", "typename",
  "string_type_specifier", "simple_type_specifier", "cons_type_specifier",
  "integral_type_specifier", "integral_type_sign", "offset_type_specifier",
  "array_type_specifier", "function_type_specifier",
  "function_type_arg_list", "function_type_arg", "struct_type_specifier",
  "$@2", "struct_or_union", "struct_type_pinned", "integral_struct",
  "struct_type_elem_list", "endianness", "struct_type_field", "$@3",
  "struct_type_field_identifier", "struct_type_field_label",
  "struct_type_field_constraint_and_init", "struct_type_field_optcond",
  "simple_declaration", "declaration", "@4", "defun_or_method",
  "defvar_list", "defvar", "deftype_list", "deftype", "defunit_list",
  "defunit", "comp_stmt", "builtin", "stmt_decl_list", "ass_exp_op",
  "simple_stmt_list", "simple_stmt", "stmt", "@5", "@6",
  "print_stmt_arg_list", "funcall_stmt", "funcall_stmt_arg_list",
  "funcall_stmt_arg", YY_NULLPTR
  };
  /* YYTRANSLATABLE[SYMBOL-NUM] -- Whether YY_SNAME[SYMBOL-NUM] is
     internationalizable.  */
  static yytype_int8 yytranslatable[] =
  {
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0
  };
  return (yysymbol < YYNTOKENS && yytranslatable[yysymbol]
          ? _(yy_sname[yysymbol])
          : yy_sname[yysymbol]);
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   124,    94,    38,   341,
     342,   343,   344,    60,    62,   345,   346,    43,    45,    42,
      47,   347,    37,   348,   349,    64,   350,   351,   352,   353,
     354,    46,   355,   356,   357,   358,   359,   360,   361,   362,
      63,    58,   363,   364,   365,   366,   367,   368,    44,    59,
      40,    41,   123,   125,   126,    33,    91,    93,    61
};
#endif

#define YYPACT_NINF (-380)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-258)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

  /* YYPACTSTATE-NUM -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -40,  1660,   192,  1263,   648,    36,  -380,  -380,  -380,  -380,
    -380,  -380,  -380,   -84,  -380,  -380,   351,  -380,  -380,  -380,
    -380,  -380,  -380,  1660,  1660,  -380,  1660,  -380,  -380,  1426,
    2588,  -380,  -380,  1660,   -48,  -380,  -380,  -125,   -75,   -72,
      -9,  -380,    39,  -380,    -7,  -380,    89,    89,    89,  -380,
       4,    23,    89,    28,    32,    38,    51,    56,  1497,    74,
    1309,  1543,  1660,     7,   133,  -380,  3090,    87,  2780,    58,
      79,  3091,  -380,    95,   102,  -380,  -380,   785,  -380,  -380,
    -380,  -380,  -380,   351,  -380,  -380,   -57,  -380,    37,    68,
      68,  2156,   -74,    35,    82,  2780,   105,  -380,  -380,  1660,
    1660,  1660,  1660,  1660,  1660,  1660,  1660,  1660,  1660,  1660,
    1660,  1660,  1660,  1660,  1660,  1660,  1660,  1660,  1660,  1660,
    1660,  -380,  -380,   351,   351,  -380,  1660,  -380,    90,    89,
    1660,  1614,  1773,  -380,  -380,   831,  1660,  1660,   141,  -380,
    -380,    99,   111,  -380,   103,   112,  -380,   104,   117,  -380,
    -380,  -380,  -380,  -380,  1660,  1660,    20,  1660,  -380,  2396,
    -380,     0,  -380,  2444,  2492,  -380,   241,   115,   119,  -380,
    -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,
    -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,
    -380,  1083,  -380,  -380,  1660,  1660,  -380,  -380,  -380,  -380,
    -380,  -380,  -380,  -380,  -380,  -380,  -380,   242,  1660,  1660,
     129,  -380,  -380,  -380,  -380,   -88,    86,  -380,  -380,   -77,
    -380,  -380,  1660,  1426,   114,  2903,  2828,  2876,  2930,  2972,
    2999,  3026,  3026,   478,   478,   478,   478,   266,   266,   627,
     627,   156,   156,   156,   156,   220,   175,   125,   125,  2636,
    -380,  2780,    19,  -380,   902,  1742,   134,   -87,   135,  2780,
     124,  -380,  -380,  1838,  2684,   139,  2780,  -380,   116,    89,
    1660,    89,  1660,    89,   136,  2204,  2252,   248,  1660,   177,
    2108,  -380,  1660,     8,  -380,  -380,    85,  -380,  -380,  -380,
    -380,  -380,  1129,  -380,  2780,  2780,  1660,  2780,  2780,  -380,
    -380,   182,   194,   162,  -380,  1892,  -380,  -380,  1660,  1660,
    -380,  -380,  1946,  1660,   948,  -380,  1660,  1773,   153,  -380,
    1660,  1660,   158,    10,   280,  -380,   125,  -380,  -380,  -380,
    2780,  -380,  2780,  -380,    37,  1309,  1309,  1660,   163,  2780,
     164,  1660,  -380,  2540,  1660,  -380,  -380,  1660,  -380,    30,
    -380,  -380,  -380,  2780,  -380,  -380,   176,   165,   171,    -4,
    -380,   166,  2780,  -380,  -380,  2000,  -380,  2054,  2780,  -380,
    -380,  2780,  2780,  -380,  -380,   351,  -101,   169,   173,  -380,
      60,  -380,   286,  -380,  2780,  1380,  1660,  2300,  -380,  2780,
     162,  2780,  -380,  -380,   351,   162,   168,  -380,  1660,  -380,
    -380,   125,  -380,   351,   144,  -380,  -380,   351,  1309,   288,
     179,    54,  -380,   185,  -380,  -380,   186,   -53,  -380,  1660,
    -380,  2780,   125,  -380,   125,   191,  -380,   187,   308,  1380,
    1309,  1380,  -380,  -380,  2780,   202,  1309,  1660,  -380,  -380,
      67,  -380,  -380,  -380,   450,  -380,  2348,  1309,  -380,  -380,
     376,   116,  -380,  -380,  1309,  -380,  -380,  -380,  -380,    89,
    -380,  -380,  -380,  -109,  1660,  1660,   234,   613,  2732,  1660,
     323,  1660,  1660,  2780,  1660,   213,  2780,  2780,  2780,  -380
};

  /* YYDEFACTSTATE-NUM -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,     0,     2,     2,     0,    75,    76,    77,    78,
      74,   123,    58,     0,   136,   137,     0,   124,   126,   125,
      90,    70,    69,     0,     0,    73,     0,    71,    72,     0,
       3,    62,    63,     0,    28,    88,    80,   127,   131,     0,
       0,   128,     0,   129,   130,   184,     0,     0,     0,   185,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       2,     0,     0,     0,     0,   248,     0,     9,   242,    62,
      63,    28,   247,     0,     7,   246,    11,     2,    14,    18,
      16,    17,     1,     0,   127,   131,     0,   130,     0,    60,
      61,     0,    28,     0,     0,   109,    99,   107,    59,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    92,    93,     0,     0,    31,     0,     4,    29,     0,
      95,     0,   101,    65,    66,     0,     0,    23,     0,    22,
      21,     0,   179,   189,     0,   178,   186,     0,   180,   192,
     183,     6,   181,   260,     0,     0,     2,     0,   261,     0,
     259,     0,   267,     0,     0,   271,     0,     0,     0,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,     2,   197,    10,     0,     0,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   234,   233,     0,     0,     0,
     273,   274,   249,     8,    15,     0,     0,   111,    91,     0,
      79,    89,     0,   100,     0,    52,    51,    50,    47,    48,
      49,    41,    42,    45,    46,    43,    44,    39,    40,    32,
      33,    34,    35,    36,    38,    37,    64,    53,    54,     0,
      81,    98,     0,    96,     0,     0,    74,   123,     0,   104,
      99,   102,   140,     0,    67,    99,    24,   135,     2,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    26,     0,
       0,   262,     0,     2,   268,   269,     0,   271,    20,    19,
     195,   222,     2,   220,   240,   241,     0,   238,   239,   275,
      30,     0,     0,     0,   111,     0,   108,   106,     0,     0,
      94,    85,     0,     0,     0,    82,     0,   100,     0,   141,
       0,   100,     0,     0,   154,   191,   120,   122,   121,   190,
     188,   187,   194,   193,     0,     2,     2,     0,     0,    27,
       0,     0,   244,     0,     0,     2,   263,     0,   270,     0,
     196,   223,   221,   276,   139,   138,     0,     0,   114,     0,
       2,     0,    55,    97,    86,     0,    87,     0,   105,   103,
      57,    68,    25,    56,   148,     0,   146,     0,   144,   155,
       0,   182,   250,   252,     2,   235,    26,     0,   266,     2,
       0,   272,   243,   117,     0,     0,   118,   113,     0,    83,
      84,   143,   147,     0,     0,   152,   153,   156,     2,   255,
       0,     0,   236,     0,   245,   264,     0,     0,   115,     0,
     116,   110,   142,   145,   157,     0,   251,     0,     0,     0,
       2,   235,     2,     2,   119,   150,     2,     0,   237,   254,
       0,   265,   112,   149,   162,   256,     0,     2,   164,   163,
     162,     2,   158,   159,     2,   253,   151,   161,   160,   167,
     258,   168,   165,   171,     0,     0,   169,   172,   173,     0,
     176,     0,     0,   170,     0,     0,   175,   174,   177,   166
};

  /* YYPGOTONTERM-NUM.  */
static const yytype_int16 yypgoto[] =
{
    -380,  -126,  -380,  -380,  -380,   267,   342,   -37,  -380,   -39,
      -1,    13,  -380,    66,  -380,    -2,  -380,  -380,  -380,    41,
    -138,  -380,    34,  -380,  -380,   137,    48,    21,   -38,   -34,
    -380,   -80,   132,   155,   214,  -380,  -380,  -380,  -380,   238,
    -380,   -32,  -380,  -380,  -380,  -380,  -380,  -380,  -380,  -380,
     -73,  -380,  -380,  -380,  -380,  -380,   107,     6,  -380,  -380,
    -380,   113,  -380,   118,  -380,   109,  -269,  -380,  -380,  -380,
     -43,  -379,    18,  -380,  -380,   106,   363,  -380,   181
};

  /* YYDEFGOTONTERM-NUM.  */
static const yytype_int16 yydefgoto[] =
{
      -1,    66,     5,    76,    77,    78,    79,   356,   265,   338,
      68,    31,   136,    32,    33,    34,    88,    35,   252,   253,
     224,   260,   261,    36,    96,    97,   303,   218,   357,   358,
     420,   325,    37,    38,    39,    40,    41,    42,    43,    44,
     327,   377,   378,   328,   444,   407,   380,   425,   450,   451,
     452,   463,   462,   470,   466,   475,    50,    80,   274,    52,
     145,   146,   142,   143,   148,   149,    72,   192,   292,   209,
     411,    73,    81,   427,   428,   286,    75,   210,   211
};

  /* YYTABLEYYPACT[STATE-NUM] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      30,    71,    71,   139,   140,  -132,   412,   132,    51,   141,
     144,   147,   464,   165,   346,   152,    69,    69,    11,   402,
     282,    74,    89,    90,    92,    91,   344,   277,    95,   465,
     279,   -21,   128,   133,   134,   135,    82,   129,    14,    15,
      16,   283,   138,   300,   304,    11,    83,   207,   135,    17,
     438,   -21,   412,    18,    19,  -134,   130,   159,    71,   135,
     163,   164,   131,   129,   135,    14,    15,    16,   433,    70,
      70,   216,   405,    69,   406,    71,    17,  -258,   161,   135,
      18,    19,   130,   135,     1,     2,     3,     4,   131,   301,
      69,   397,   250,   139,   140,   258,   139,   140,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     415,   137,   318,  -133,    11,   249,    70,   322,   374,   251,
     255,   259,   135,   150,   263,   264,   266,   166,   345,   167,
     168,   375,   324,    70,    14,    15,    16,   309,    84,   278,
     310,   151,    11,   275,   276,    17,   280,   153,   347,    18,
      19,   392,   154,   441,   442,    98,   221,   217,   155,   139,
     257,    85,    14,    15,    16,  -258,  -258,   123,   124,   302,
     125,   156,   429,    17,    98,   430,   157,    18,    19,    71,
      14,    15,    16,   294,   295,   429,   194,   291,   447,   123,
     124,    17,   125,   160,    69,    18,    19,   297,   298,   293,
      46,    47,    48,   347,   348,    84,   193,   195,   222,   390,
      84,   305,    95,    45,   212,    46,    47,    48,    49,    98,
      86,   213,   141,   223,   144,   267,   147,   268,    85,   269,
     271,   270,   272,    85,   288,   273,   323,   287,   289,   296,
     207,   307,   317,   312,    87,    84,    84,    70,   409,   119,
     120,   135,   374,   121,   122,   123,   124,   321,   125,   330,
     337,   332,   -22,   316,   334,    98,   354,   339,    85,    85,
     258,   343,   121,   122,   123,   124,   370,   125,   355,   373,
      71,   379,   385,   386,   393,   353,   394,   215,   351,   395,
     403,   404,   219,   408,   398,    69,   419,   362,   251,   166,
     352,  -257,   365,   367,   431,   368,   259,   432,   436,   371,
     372,    87,   396,   435,   120,   324,    87,   121,   122,   123,
     124,   437,   125,    71,    71,   443,   384,   247,   248,   469,
     387,   474,   479,   389,   214,    67,   391,   413,    69,    69,
     363,   369,   360,   382,   383,   381,   416,   418,    70,    11,
     306,    87,    87,   113,   114,   115,   116,   117,   118,   119,
     120,   459,   423,   121,   122,   123,   124,   457,   125,    14,
      15,    16,   333,    71,   331,   339,   340,   329,   440,    93,
      17,   299,     0,   349,    18,    19,     0,   421,    69,     0,
      84,    70,    70,     0,     0,     0,    71,    45,     0,    46,
      47,    48,    49,     0,     0,     0,     0,     0,   434,     0,
       0,    69,   461,    85,     0,     0,   426,    71,    71,    71,
       0,     0,     0,     0,    71,    84,   446,     0,     0,     0,
       0,     0,    69,    69,    69,    71,     0,     0,   439,    69,
     453,    70,    71,     0,   445,    84,   458,     0,    85,     0,
      69,     0,     0,   467,   468,   455,    84,    69,   473,     0,
     476,   477,   460,   478,    70,     0,     0,     0,    85,     0,
       0,    45,   326,    46,    47,    48,    49,    98,     0,    85,
     448,   449,     0,     0,     0,    70,    70,    70,     0,     0,
       0,     0,    70,     0,     0,     0,    87,    84,     0,   456,
       0,     0,     0,    70,     0,     0,     0,   359,     0,     0,
      70,     0,    84,     0,     0,     0,    84,    84,     0,     0,
      85,     0,     0,     0,     0,    84,    84,   376,     0,    84,
       0,    87,     0,     0,     0,    85,     0,     0,   219,    85,
      85,     0,     0,     0,     0,     0,     0,     0,    85,    85,
       0,    87,    85,     0,   448,   449,     0,     0,     0,     0,
       0,     0,    87,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,    84,     0,   121,   122,   123,   124,   401,
     125,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   359,     0,    85,     0,   417,   359,
       0,     0,     0,    87,     0,     0,     0,   422,   376,     0,
       0,   424,    98,     0,     0,     0,     0,     0,    87,     0,
       0,     0,    87,    87,     0,    99,    98,     0,     0,     0,
       0,    87,    87,     0,     0,    87,     0,     0,   -12,     0,
       0,     6,     7,     8,     9,    10,    11,    12,     0,     0,
       0,     0,     0,     0,    53,   326,    54,    55,     0,    56,
       0,     0,    13,    57,     0,     0,    14,    15,    16,    45,
       0,    46,    47,    48,    49,    58,    59,    17,    60,    87,
      61,    18,    19,    62,    63,    64,    20,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,     0,     0,
     121,   122,   123,   124,     0,   125,   115,   116,   117,   118,
     119,   120,     0,   126,   121,   122,   123,   124,     0,   125,
       0,     0,     0,     0,     0,    21,    22,     0,     0,     0,
       0,   471,     0,     0,     0,    23,    24,     0,     0,     0,
       0,    25,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    65,    26,     0,
       0,     0,    27,    28,    29,   -13,     0,     0,     6,     7,
       8,     9,    10,    11,    12,     0,     0,     0,     0,     0,
       0,    53,     0,    54,    55,     0,    56,     0,     0,    13,
      57,     0,     0,    14,    15,    16,    45,     0,    46,    47,
      48,    49,    58,    59,    17,    60,     0,    61,    18,    19,
      62,    63,    64,    20,     6,     7,     8,     9,    10,    11,
      12,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,     0,     0,     0,    14,
      15,    16,     0,     0,     0,     0,     0,     0,     0,     0,
      17,     0,     0,     0,    18,    19,     0,     0,     0,    20,
       0,     0,    21,    22,     0,     0,     0,     0,     0,     0,
       0,     0,    23,    24,     0,     0,     0,     0,    25,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,    10,
      11,    12,     0,     0,    65,    26,     0,     0,     0,    27,
      28,    29,     0,     0,     0,     0,    13,     0,    21,    22,
      14,    15,    16,     0,     0,     0,     0,     0,    23,    24,
       0,    17,     0,     0,    25,    18,    19,     0,     0,     0,
      20,     6,     7,     8,     9,    10,    11,    12,     0,     0,
       0,    26,     0,     0,     0,    27,    28,    29,   262,     0,
       0,     0,    13,     0,     0,     0,    14,    15,    16,     0,
       0,     0,     0,     0,     0,     0,     0,    17,     0,     0,
       0,    18,    19,     0,     0,     0,    20,     0,     0,    21,
      22,     0,     0,     0,     0,     0,     0,     0,     0,    23,
      24,     0,     0,     0,     0,    25,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    26,     0,     0,     0,    27,    28,    29,   311,
       0,     0,     0,     0,     0,    21,    22,     0,     0,     0,
       0,     0,     0,     0,     0,    23,    24,     0,     0,     0,
       0,    25,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    26,     0,
       0,     0,    27,    28,    29,   366,     6,     7,     8,     9,
      10,    11,    12,     0,     0,     0,     0,     0,     0,    53,
       0,    54,    55,     0,    56,     0,     0,    13,    57,     0,
       0,    14,    15,    16,    45,     0,    46,    47,    48,    49,
      58,    59,    17,    60,     0,    61,    18,    19,    62,    63,
       0,    20,     6,     7,     8,     9,    10,    11,    12,     0,
       0,     0,     0,     0,     0,    53,     0,    54,    55,     0,
      56,     0,     0,    13,    57,     0,     0,    14,    15,    16,
      45,     0,    46,    47,    48,    49,    58,    59,    17,    60,
       0,    61,    18,    19,    62,    63,     0,    20,     0,     0,
      21,    22,     0,     0,     0,     0,     0,     0,     0,     0,
      23,    24,     0,     0,     0,     0,    25,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    65,    26,     0,     0,   290,    27,    28,    29,
       0,     0,     0,     0,     0,     0,    21,    22,     0,     0,
       0,     0,     0,     0,     0,     0,    23,    24,     0,     0,
       0,     0,    25,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    65,    26,
       0,     0,   350,    27,    28,    29,     6,     7,     8,     9,
      10,    11,    12,     0,     0,     0,     0,     0,     0,    53,
       0,    54,    55,     0,    56,     0,     0,    13,    57,     0,
       0,    14,    15,    16,     0,     0,     0,     0,     0,     0,
      58,    59,    17,    60,     0,    61,    18,    19,    62,    63,
      64,    20,     6,     7,     8,     9,    10,    11,    12,     0,
       0,     0,     0,     0,     0,    53,     0,    54,    55,     0,
      56,     0,     0,    13,    57,     0,     0,    14,    15,    16,
       0,     0,     0,     0,     0,     0,    58,    59,    17,    60,
       0,    61,    18,    19,    62,    63,     0,    20,     0,     0,
      21,    22,     0,     0,     0,     0,     0,     0,     0,     0,
      23,    24,     0,     0,     0,     0,    25,     0,     0,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,    12,
       0,     0,    65,    26,     0,     0,     0,    27,    28,    29,
       0,     0,     0,     0,    13,    57,    21,    22,    14,    15,
      16,     0,     0,     0,     0,     0,    23,    24,     0,    17,
       0,     0,    25,    18,    19,     0,   410,     0,    20,     6,
       7,     8,     9,    10,    11,    12,     0,     0,    65,    26,
       0,     0,     0,    27,    28,    29,     0,     0,     0,     0,
      13,     0,     0,     0,    14,    15,    16,     0,     0,     0,
       0,     0,     0,     0,     0,    17,     0,     0,     0,    18,
      19,     0,     0,     0,    20,     0,     0,    21,    22,     0,
       0,     0,     0,     0,     0,     0,     0,    23,    24,     0,
       0,     0,     0,    25,     0,     0,     0,     0,     0,     0,
       6,     7,     8,     9,    10,    11,    12,     0,     0,     0,
      26,     0,     0,     0,    27,    28,    29,     0,     0,     0,
       0,    13,     0,    21,    22,    14,    15,    16,     0,     0,
       0,     0,     0,    23,    24,     0,    17,    94,     0,    25,
      18,    19,     0,     0,     0,    20,     6,     7,     8,     9,
      10,    11,    12,     0,     0,     0,    26,     0,     0,     0,
      27,    28,    29,     0,     0,     0,     0,    13,     0,     0,
       0,    14,    15,    16,     0,     0,     0,     0,     0,     0,
       0,     0,    17,     0,     0,     0,    18,    19,     0,     0,
       0,    20,     0,     0,    21,    22,     0,     0,     0,     0,
       0,     0,     0,     0,    23,    24,     0,     0,     0,     0,
      25,     0,     0,     0,     0,     0,     0,     6,     7,     8,
       9,    10,    11,    12,     0,     0,   158,    26,     0,     0,
       0,    27,    28,    29,     0,     0,     0,     0,    13,     0,
      21,    22,    14,    15,    16,     0,     0,     0,     0,     0,
      23,    24,     0,    17,     0,     0,    25,    18,    19,     0,
       0,     0,    20,     6,     7,     8,     9,    10,    11,    12,
       0,     0,   162,    26,     0,     0,     0,    27,    28,    29,
       0,     0,     0,     0,    13,     0,     0,     0,    14,    15,
      16,     0,     0,     0,     0,     0,     0,     0,     0,    17,
       0,     0,     0,    18,    19,     0,     0,     0,    20,     0,
       0,    21,    22,     0,     0,     0,     0,     0,     0,     0,
       0,    23,    24,     0,     0,     0,     0,    25,     0,     0,
       0,     0,     0,     0,     0,   254,     0,     0,     0,     0,
       0,     0,     0,     0,    26,     0,     0,     0,    27,    28,
      29,    98,     0,     0,     0,     0,     0,    21,    22,     0,
       0,     0,     0,     0,    99,     0,     0,    23,    24,     0,
       0,     0,     0,    25,     0,     0,     6,     7,     8,     9,
     256,   257,    12,     0,     0,     0,     0,     0,     0,     0,
      26,     0,     0,     0,    27,    28,    29,    13,     0,     0,
       0,    14,    15,    16,     0,     0,     0,     0,     0,     0,
       0,     0,    17,     0,     0,     0,    18,    19,     0,     0,
       0,    20,     0,     0,     0,   313,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    98,     0,   121,
     122,   123,   124,     0,   125,     0,     0,     0,     0,     0,
      99,     0,   126,   314,     0,     0,     0,     0,     0,     0,
      21,    22,     0,     0,     0,     0,     0,     0,     0,   315,
      23,    24,     0,     0,     0,     0,    25,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    98,     0,    26,     0,     0,     0,    27,    28,    29,
       0,     0,     0,     0,    99,     0,     0,     0,     0,     0,
       0,     0,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,     0,     0,   121,   122,   123,   124,     0,
     125,     0,     0,     0,     0,    98,     0,     0,   126,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    99,     0,
       0,     0,     0,     0,     0,   319,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,     0,     0,   121,
     122,   123,   124,     0,   125,     0,     0,     0,     0,    98,
       0,     0,   126,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    99,     0,     0,     0,     0,     0,     0,   361,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,     0,     0,   121,   122,   123,   124,     0,   125,     0,
       0,     0,     0,    98,     0,     0,   126,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    99,     0,     0,     0,
       0,     0,     0,   364,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,     0,     0,   121,   122,   123,
     124,     0,   125,     0,     0,     0,     0,    98,     0,     0,
     126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      99,     0,     0,     0,     0,     0,     0,   399,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,     0,
       0,   121,   122,   123,   124,    98,   125,     0,     0,     0,
       0,     0,     0,     0,   126,     0,     0,     0,    99,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   400,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,    98,     0,   121,   122,   123,   124,     0,
     125,     0,     0,     0,     0,     0,    99,     0,   126,     0,
       0,     0,     0,     0,     0,     0,   341,     0,     0,   342,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    98,     0,   121,   122,   123,   124,     0,   125,     0,
       0,     0,     0,     0,    99,     0,   126,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   220,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,    98,
       0,   121,   122,   123,   124,     0,   125,     0,     0,     0,
       0,     0,    99,     0,   126,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   335,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    98,     0,   121,
     122,   123,   124,     0,   125,     0,     0,     0,     0,     0,
      99,     0,   126,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   336,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    98,     0,   121,   122,   123,
     124,     0,   125,     0,     0,     0,     0,     0,    99,     0,
     126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   414,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,    98,     0,   121,   122,   123,   124,     0,
     125,     0,     0,     0,     0,     0,    99,     0,   126,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   454,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    98,     0,   121,   122,   123,   124,     0,   125,     0,
       0,     0,     0,     0,    99,     0,   126,     0,     0,     0,
       0,     0,     0,     0,     0,   281,     0,     0,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,    98,
       0,   121,   122,   123,   124,     0,   125,     0,     0,     0,
       0,     0,    99,     0,   126,     0,     0,     0,     0,     0,
       0,     0,     0,   284,     0,     0,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    98,     0,   121,
     122,   123,   124,     0,   125,     0,     0,     0,     0,     0,
      99,     0,   126,     0,     0,     0,     0,     0,     0,     0,
       0,   285,     0,     0,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    98,     0,   121,   122,   123,
     124,     0,   125,     0,     0,     0,     0,     0,    99,     0,
     126,     0,     0,     0,     0,     0,     0,     0,     0,   388,
       0,     0,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,    98,     0,   121,   122,   123,   124,     0,
     125,     0,     0,     0,     0,     0,    99,     0,   126,     0,
       0,     0,     0,     0,     0,     0,   127,     0,     0,     0,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    98,     0,   121,   122,   123,   124,     0,   125,     0,
       0,     0,     0,     0,    99,     0,   126,   308,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,    98,
       0,   121,   122,   123,   124,     0,   125,     0,     0,     0,
       0,     0,    99,     0,   126,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    98,     0,   121,
     122,   123,   124,     0,   125,     0,     0,     0,     0,     0,
      99,     0,   126,   472,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    98,     0,   121,   122,   123,
     124,     0,   125,     0,     0,     0,     0,     0,    99,     0,
     126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    98,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,     0,     0,   121,   122,   123,   124,    98,
     125,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    98,     0,   121,   122,   123,   124,     0,   125,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,    98,     0,
     121,   122,   123,   124,     0,   125,     0,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    98,     0,   121,   122,   123,
     124,     0,   125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,     0,     0,   121,
     122,   123,   124,     0,   125,     0,     0,     0,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,     0,     0,   121,   122,   123,   124,
       0,   125,     0,     0,     0,     0,     0,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,     0,     0,   121,   122,   123,   124,     0,   125,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,   182,   183,   184,   185,   186,   187,   188,
     189,   190,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,   130,   191,     0,     0,     0,     0,   131,     0,   208
};

static const yytype_int16 yycheck[] =
{
       1,     3,     4,     7,     8,   130,   385,   132,     2,    46,
      47,    48,   121,     6,   283,    52,     3,     4,     8,   120,
      20,     3,    23,    24,    26,    26,    18,     7,    29,   138,
     156,   118,    33,   105,   106,   136,     0,   111,    28,    29,
      30,    41,     3,   131,   121,     8,   130,   121,   136,    39,
     429,   138,   431,    43,    44,   130,   130,    58,    60,   136,
      61,    62,   136,   111,   136,    28,    29,    30,   121,     3,
       4,   128,    12,    60,    14,    77,    39,     9,    60,   136,
      43,    44,   130,   136,   124,   125,   126,   127,   136,     3,
      77,   360,   129,     7,     8,   132,     7,     8,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     389,   130,   260,   130,     8,   126,    60,   265,   118,   130,
     131,   132,   136,   129,   135,   136,   137,   130,   130,     6,
       7,   131,   268,    77,    28,    29,    30,   128,    16,   129,
     131,   128,     8,   154,   155,    39,   157,   129,   128,    43,
      44,   131,   130,   432,   433,     9,   131,   130,   130,     7,
       8,    16,    28,    29,    30,   107,   108,   109,   110,   216,
     112,   130,   128,    39,     9,   131,   130,    43,    44,   191,
      28,    29,    30,   194,   195,   128,   138,   191,   131,   109,
     110,    39,   112,   129,   191,    43,    44,   208,   209,   191,
      33,    34,    35,   128,   129,    83,   129,   138,   136,   345,
      88,   222,   223,    31,   129,    33,    34,    35,    36,     9,
      16,   129,   269,   128,   271,    94,   273,   138,    83,   128,
     128,   138,   138,    88,   129,   128,   130,     6,   129,     7,
     121,   137,   128,   254,    16,   123,   124,   191,   384,   103,
     104,   136,   118,   107,   108,   109,   110,   128,   112,   270,
      22,   272,   138,   138,   138,     9,    94,   278,   123,   124,
     317,   282,   107,   108,   109,   110,   133,   112,    94,   131,
     292,    11,   129,   129,   118,   296,   131,    83,   292,   128,
     131,   128,    88,    17,   138,   292,   138,   308,   309,   130,
     292,    23,   313,   314,   129,   316,   317,   131,   131,   320,
     321,    83,   359,   132,   104,   451,    88,   107,   108,   109,
     110,    23,   112,   335,   336,   133,   337,   123,   124,   105,
     341,    18,   129,   344,    77,     3,   347,   386,   335,   336,
     309,   317,   304,   335,   336,   334,   390,   395,   292,     8,
     223,   123,   124,    97,    98,    99,   100,   101,   102,   103,
     104,   451,   404,   107,   108,   109,   110,   450,   112,    28,
      29,    30,   273,   385,   271,   386,   279,   269,   431,    26,
      39,   210,    -1,   287,    43,    44,    -1,   398,   385,    -1,
     268,   335,   336,    -1,    -1,    -1,   408,    31,    -1,    33,
      34,    35,    36,    -1,    -1,    -1,    -1,    -1,   419,    -1,
      -1,   408,   459,   268,    -1,    -1,   408,   429,   430,   431,
      -1,    -1,    -1,    -1,   436,   303,   437,    -1,    -1,    -1,
      -1,    -1,   429,   430,   431,   447,    -1,    -1,   430,   436,
     444,   385,   454,    -1,   436,   323,   450,    -1,   303,    -1,
     447,    -1,    -1,   464,   465,   447,   334,   454,   469,    -1,
     471,   472,   454,   474,   408,    -1,    -1,    -1,   323,    -1,
      -1,    31,   268,    33,    34,    35,    36,     9,    -1,   334,
     114,   115,    -1,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,    -1,   436,    -1,    -1,    -1,   268,   375,    -1,   133,
      -1,    -1,    -1,   447,    -1,    -1,    -1,   303,    -1,    -1,
     454,    -1,   390,    -1,    -1,    -1,   394,   395,    -1,    -1,
     375,    -1,    -1,    -1,    -1,   403,   404,   323,    -1,   407,
      -1,   303,    -1,    -1,    -1,   390,    -1,    -1,   334,   394,
     395,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,   404,
      -1,   323,   407,    -1,   114,   115,    -1,    -1,    -1,    -1,
      -1,    -1,   334,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   451,    -1,   107,   108,   109,   110,   375,
     112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,    -1,   451,    -1,   394,   395,
      -1,    -1,    -1,   375,    -1,    -1,    -1,   403,   404,    -1,
      -1,   407,     9,    -1,    -1,    -1,    -1,    -1,   390,    -1,
      -1,    -1,   394,   395,    -1,    22,     9,    -1,    -1,    -1,
      -1,   403,   404,    -1,    -1,   407,    -1,    -1,     0,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    16,   451,    18,    19,    -1,    21,
      -1,    -1,    24,    25,    -1,    -1,    28,    29,    30,    31,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,   451,
      42,    43,    44,    45,    46,    47,    48,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,    -1,    -1,
     107,   108,   109,   110,    -1,   112,    99,   100,   101,   102,
     103,   104,    -1,   120,   107,   108,   109,   110,    -1,   112,
      -1,    -1,    -1,    -1,    -1,    97,    98,    -1,    -1,    -1,
      -1,   138,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,   130,    -1,
      -1,    -1,   134,   135,   136,     0,    -1,    -1,     3,     4,
       5,     6,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    16,    -1,    18,    19,    -1,    21,    -1,    -1,    24,
      25,    -1,    -1,    28,    29,    30,    31,    -1,    33,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      45,    46,    47,    48,     3,     4,     5,     6,     7,     8,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    24,    -1,    -1,    -1,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      39,    -1,    -1,    -1,    43,    44,    -1,    -1,    -1,    48,
      -1,    -1,    97,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    -1,    -1,   129,   130,    -1,    -1,    -1,   134,
     135,   136,    -1,    -1,    -1,    -1,    24,    -1,    97,    98,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,   107,   108,
      -1,    39,    -1,    -1,   113,    43,    44,    -1,    -1,    -1,
      48,     3,     4,     5,     6,     7,     8,     9,    -1,    -1,
      -1,   130,    -1,    -1,    -1,   134,   135,   136,   137,    -1,
      -1,    -1,    24,    -1,    -1,    -1,    28,    29,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    -1,    -1,
      -1,    43,    44,    -1,    -1,    -1,    48,    -1,    -1,    97,
      98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,    -1,    -1,    -1,   134,   135,   136,   137,
      -1,    -1,    -1,    -1,    -1,    97,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,
      -1,    -1,   134,   135,   136,   137,     3,     4,     5,     6,
       7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    16,
      -1,    18,    19,    -1,    21,    -1,    -1,    24,    25,    -1,
      -1,    28,    29,    30,    31,    -1,    33,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    45,    46,
      -1,    48,     3,     4,     5,     6,     7,     8,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    16,    -1,    18,    19,    -1,
      21,    -1,    -1,    24,    25,    -1,    -1,    28,    29,    30,
      31,    -1,    33,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    45,    46,    -1,    48,    -1,    -1,
      97,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   129,   130,    -1,    -1,   133,   134,   135,   136,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,
      -1,    -1,   113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,   130,
      -1,    -1,   133,   134,   135,   136,     3,     4,     5,     6,
       7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    16,
      -1,    18,    19,    -1,    21,    -1,    -1,    24,    25,    -1,
      -1,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    39,    40,    -1,    42,    43,    44,    45,    46,
      47,    48,     3,     4,     5,     6,     7,     8,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    16,    -1,    18,    19,    -1,
      21,    -1,    -1,    24,    25,    -1,    -1,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    39,    40,
      -1,    42,    43,    44,    45,    46,    -1,    48,    -1,    -1,
      97,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      -1,    -1,   129,   130,    -1,    -1,    -1,   134,   135,   136,
      -1,    -1,    -1,    -1,    24,    25,    97,    98,    28,    29,
      30,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    39,
      -1,    -1,   113,    43,    44,    -1,    46,    -1,    48,     3,
       4,     5,     6,     7,     8,     9,    -1,    -1,   129,   130,
      -1,    -1,    -1,   134,   135,   136,    -1,    -1,    -1,    -1,
      24,    -1,    -1,    -1,    28,    29,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    39,    -1,    -1,    -1,    43,
      44,    -1,    -1,    -1,    48,    -1,    -1,    97,    98,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    -1,    -1,    -1,
     130,    -1,    -1,    -1,   134,   135,   136,    -1,    -1,    -1,
      -1,    24,    -1,    97,    98,    28,    29,    30,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    39,   111,    -1,   113,
      43,    44,    -1,    -1,    -1,    48,     3,     4,     5,     6,
       7,     8,     9,    -1,    -1,    -1,   130,    -1,    -1,    -1,
     134,   135,   136,    -1,    -1,    -1,    -1,    24,    -1,    -1,
      -1,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    -1,    -1,    -1,    43,    44,    -1,    -1,
      -1,    48,    -1,    -1,    97,    98,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
     113,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    -1,    -1,   129,   130,    -1,    -1,
      -1,   134,   135,   136,    -1,    -1,    -1,    -1,    24,    -1,
      97,    98,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    39,    -1,    -1,   113,    43,    44,    -1,
      -1,    -1,    48,     3,     4,     5,     6,     7,     8,     9,
      -1,    -1,   129,   130,    -1,    -1,    -1,   134,   135,   136,
      -1,    -1,    -1,    -1,    24,    -1,    -1,    -1,    28,    29,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,
      -1,    -1,    -1,    43,    44,    -1,    -1,    -1,    48,    -1,
      -1,    97,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,   134,   135,
     136,     9,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,
      -1,    -1,    -1,    -1,    22,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,    -1,     3,     4,     5,     6,
       7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     130,    -1,    -1,    -1,   134,   135,   136,    24,    -1,    -1,
      -1,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    -1,    -1,    -1,    43,    44,    -1,    -1,
      -1,    48,    -1,    -1,    -1,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,     9,    -1,   107,
     108,   109,   110,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      22,    -1,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     9,    -1,   130,    -1,    -1,    -1,   134,   135,   136,
      -1,    -1,    -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,    -1,   107,   108,   109,   110,    -1,
     112,    -1,    -1,    -1,    -1,     9,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    22,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,    -1,   107,
     108,   109,   110,    -1,   112,    -1,    -1,    -1,    -1,     9,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,   137,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,    -1,    -1,   107,   108,   109,   110,    -1,   112,    -1,
      -1,    -1,    -1,     9,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    22,    -1,    -1,    -1,
      -1,    -1,    -1,   137,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,    -1,   107,   108,   109,
     110,    -1,   112,    -1,    -1,    -1,    -1,     9,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      22,    -1,    -1,    -1,    -1,    -1,    -1,   137,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
      -1,   107,   108,   109,   110,     9,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    22,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,     9,    -1,   107,   108,   109,   110,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    22,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,   131,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,     9,    -1,   107,   108,   109,   110,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    22,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,     9,
      -1,   107,   108,   109,   110,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    22,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,     9,    -1,   107,
     108,   109,   110,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      22,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,     9,    -1,   107,   108,   109,
     110,    -1,   112,    -1,    -1,    -1,    -1,    -1,    22,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,     9,    -1,   107,   108,   109,   110,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    22,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,     9,    -1,   107,   108,   109,   110,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    22,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   129,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,     9,
      -1,   107,   108,   109,   110,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    22,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   129,    -1,    -1,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,     9,    -1,   107,
     108,   109,   110,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      22,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   129,    -1,    -1,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,     9,    -1,   107,   108,   109,
     110,    -1,   112,    -1,    -1,    -1,    -1,    -1,    22,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,     9,    -1,   107,   108,   109,   110,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    22,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,     9,    -1,   107,   108,   109,   110,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    22,    -1,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,     9,
      -1,   107,   108,   109,   110,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    22,    -1,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,     9,    -1,   107,
     108,   109,   110,    -1,   112,    -1,    -1,    -1,    -1,    -1,
      22,    -1,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,     9,    -1,   107,   108,   109,
     110,    -1,   112,    -1,    -1,    -1,    -1,    -1,    22,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     9,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,    -1,   107,   108,   109,   110,     9,
     112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,     9,    -1,   107,   108,   109,   110,    -1,   112,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,     9,    -1,
     107,   108,   109,   110,    -1,   112,    -1,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,     9,    -1,   107,   108,   109,
     110,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,    -1,   107,
     108,   109,   110,    -1,   112,    -1,    -1,    -1,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,    -1,    -1,   107,   108,   109,   110,
      -1,   112,    -1,    -1,    -1,    -1,    -1,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,    -1,    -1,   107,   108,   109,   110,    -1,   112,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    -1,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,   132,    -1,    -1,    -1,    -1,   136,    -1,   138
};

  /* YYSTOSSTATE-NUM -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   124,   125,   126,   127,   141,     3,     4,     5,     6,
       7,     8,     9,    24,    28,    29,    30,    39,    43,    44,
      48,    97,    98,   107,   108,   113,   130,   134,   135,   136,
     149,   150,   152,   153,   154,   156,   162,   171,   172,   173,
     174,   175,   176,   177,   178,    31,    33,    34,    35,    36,
     195,   196,   198,    16,    18,    19,    21,    25,    37,    38,
      40,    42,    45,    46,    47,   129,   140,   145,   149,   150,
     152,   154,   205,   210,   211,   215,   142,   143,   144,   145,
     196,   211,     0,   130,   171,   172,   173,   178,   155,   149,
     149,   149,   154,   215,   111,   149,   163,   164,     9,    22,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   107,   108,   109,   110,   112,   120,   128,   149,   111,
     130,   136,   132,   105,   106,   136,   151,   130,     3,     7,
       8,   146,   201,   202,   146,   199,   200,   146,   203,   204,
     129,   128,   146,   129,   130,   130,   130,   130,   129,   149,
     129,   211,   129,   149,   149,     6,   130,     6,     7,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    63,    64,    65,    66,    67,    68,    69,    70,
      71,   132,   206,   129,   138,   138,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,   121,   138,   208,
     216,   217,   129,   129,   144,   173,   128,   130,   166,   173,
     131,   131,   136,   128,   159,   149,   149,   149,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   149,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   173,   173,   149,
     146,   149,   157,   158,   121,   149,     7,     8,   146,   149,
     160,   161,   137,   149,   149,   147,   149,    94,   138,   128,
     138,   128,   138,   128,   197,   149,   149,     7,   129,   140,
     149,   129,    20,    41,   129,   129,   214,     6,   129,   129,
     133,   196,   207,   211,   149,   149,     7,   149,   149,   217,
     131,     3,   146,   165,   121,   149,   164,   137,   121,   128,
     131,   137,   149,    83,   121,   137,   138,   128,   159,   137,
     121,   128,   159,   130,   140,   170,   173,   179,   182,   202,
     149,   200,   149,   204,   138,   131,   131,    22,   148,   149,
     195,   128,   131,   149,    18,   130,   205,   128,   129,   214,
     133,   196,   211,   149,    94,    94,   146,   167,   168,   173,
     165,   137,   149,   158,   137,   149,   137,   149,   149,   161,
     133,   149,   149,   131,   118,   131,   173,   180,   181,    11,
     185,   166,   211,   211,   149,   129,   129,   149,   129,   149,
     140,   149,   131,   118,   131,   128,   146,   205,   138,   137,
     137,   173,   120,   131,   128,    12,    14,   184,    17,   140,
      46,   209,   210,   148,   131,   205,   168,   173,   167,   138,
     169,   149,   173,   180,   173,   186,   211,   212,   213,   128,
     131,   129,   131,   121,   149,   132,   131,    23,   210,   211,
     209,   205,   205,   133,   183,   211,   149,   131,   114,   115,
     187,   188,   189,   196,   131,   211,   133,   189,   196,   170,
     211,   146,   191,   190,   121,   138,   193,   149,   149,   105,
     192,   138,   121,   149,    18,   194,   149,   149,   149,   129
};

  /* YYR1YYN -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   139,   140,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   142,   142,   143,   143,   144,   144,   144,   145,
     145,   146,   146,   147,   147,   147,   148,   148,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   149,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   149,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   149,   149,   149,
     149,   149,   149,   149,   150,   151,   151,   152,   152,   153,
     153,   153,   153,   153,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     155,   154,   154,   154,   156,   157,   157,   157,   158,   159,
     159,   160,   160,   160,   161,   161,   162,   163,   163,   164,
     164,   165,   166,   166,   167,   167,   168,   168,   169,   169,
     170,   170,   170,   171,   172,   173,   173,   173,   173,   173,
     173,   173,   174,   174,   174,   175,   176,   176,   177,   177,
     178,   178,   179,   179,   180,   180,   181,   181,   181,   182,
     183,   182,   184,   184,   185,   185,   186,   186,   187,   187,
     187,   187,   188,   188,   188,   190,   189,   191,   191,   192,
     192,   193,   193,   193,   193,   193,   194,   194,   195,   195,
     195,   197,   196,   196,   198,   198,   199,   199,   200,   201,
     201,   202,   203,   203,   204,   205,   205,   205,   206,   206,
     206,   206,   206,   206,   206,   206,   206,   206,   206,   206,
     206,   206,   206,   206,   206,   206,   206,   206,   206,   206,
     207,   207,   207,   207,   208,   208,   208,   208,   208,   208,
     208,   208,   208,   208,   208,   209,   209,   209,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   211,   211,   211,
     211,   211,   211,   211,   211,   212,   211,   213,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   214,   214,   215,   216,   216,   217
};

  /* YYR2YYN -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     0,     1,     1,     2,     1,     1,     1,     3,
       3,     1,     1,     0,     1,     3,     0,     1,     1,     2,
       4,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     5,     5,     1,     2,
       2,     2,     1,     1,     3,     1,     1,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     3,     4,     6,     6,     4,     5,     5,     1,     3,
       0,     3,     2,     2,     4,     0,     1,     3,     1,     0,
       1,     0,     1,     3,     1,     3,     4,     1,     3,     1,
       6,     0,     7,     4,     1,     3,     3,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     5,     5,
       3,     4,     4,     3,     1,     3,     1,     2,     1,     6,
       0,     8,     1,     1,     0,     1,     0,     1,     1,     1,
       2,     2,     0,     1,     1,     0,     8,     0,     1,     0,
       2,     0,     2,     2,     4,     4,     0,     2,     2,     2,
       2,     0,     5,     2,     1,     1,     1,     3,     3,     1,
       3,     3,     1,     3,     3,     3,     4,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     3,     3,     3,
       3,     3,     1,     5,     4,     6,     1,     1,     1,     2,
       5,     7,     5,    10,     8,     0,     9,     0,    11,     2,
       2,     2,     3,     4,     6,     8,     5,     2,     3,     3,
       4,     0,     3,     2,     1,     2,     3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = PKL_TAB_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == PKL_TAB_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, pkl_parser, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use PKL_TAB_error or PKL_TAB_UNDEF. */
#define YYERRCODE PKL_TAB_UNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if PKL_TAB_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YY_LOCATION_PRINT
#  if defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#   define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

#  else
#   define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#  endif
# endif /* !defined YY_LOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, pkl_parser); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct pkl_parser *pkl_parser)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  YYUSE (pkl_parser);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct pkl_parser *pkl_parser)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, pkl_parser);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct pkl_parser *pkl_parser)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), pkl_parser);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, pkl_parser); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !PKL_TAB_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !PKL_TAB_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if PKL_TAB_DEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          goto yyexhaustedlab;                                          \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if PKL_TAB_DEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if PKL_TAB_DEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




/* The kind of the lookahead of this context.  */
static yysymbol_kind_t
yypcontext_token (const yypcontext_t *yyctx) YY_ATTRIBUTE_UNUSED;

static yysymbol_kind_t
yypcontext_token (const yypcontext_t *yyctx)
{
  return yyctx->yytoken;
}

/* The location of the lookahead of this context.  */
static YYLTYPE *
yypcontext_location (const yypcontext_t *yyctx) YY_ATTRIBUTE_UNUSED;

static YYLTYPE *
yypcontext_location (const yypcontext_t *yyctx)
{
  return yyctx->yylloc;
}

/* User defined function to report a syntax error.  */
static int
yyreport_syntax_error (const yypcontext_t *yyctx, struct pkl_parser *pkl_parser);

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct pkl_parser *pkl_parser)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (pkl_parser);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case 3: /* "integer literal"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 2873 "pkl-tab.c"
        break;

    case 5: /* "character literal"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 2901 "pkl-tab.c"
        break;

    case 6: /* "string"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 2929 "pkl-tab.c"
        break;

    case 7: /* "identifier"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 2957 "pkl-tab.c"
        break;

    case 8: /* "type name"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 2985 "pkl-tab.c"
        break;

    case 9: /* "offset unit"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3013 "pkl-tab.c"
        break;

    case 112: /* "attribute"  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3041 "pkl-tab.c"
        break;

    case 141: /* start  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3069 "pkl-tab.c"
        break;

    case 142: /* program  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3097 "pkl-tab.c"
        break;

    case 143: /* program_elem_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3125 "pkl-tab.c"
        break;

    case 144: /* program_elem  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3153 "pkl-tab.c"
        break;

    case 145: /* load  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3181 "pkl-tab.c"
        break;

    case 146: /* identifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3209 "pkl-tab.c"
        break;

    case 147: /* expression_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3237 "pkl-tab.c"
        break;

    case 148: /* expression_opt  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3265 "pkl-tab.c"
        break;

    case 149: /* expression  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3293 "pkl-tab.c"
        break;

    case 150: /* bconc  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3321 "pkl-tab.c"
        break;

    case 152: /* map  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3349 "pkl-tab.c"
        break;

    case 154: /* primary  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3377 "pkl-tab.c"
        break;

    case 156: /* funcall  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3405 "pkl-tab.c"
        break;

    case 157: /* funcall_arg_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3433 "pkl-tab.c"
        break;

    case 158: /* funcall_arg  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3461 "pkl-tab.c"
        break;

    case 160: /* struct_field_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3489 "pkl-tab.c"
        break;

    case 161: /* struct_field  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3517 "pkl-tab.c"
        break;

    case 162: /* array  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3545 "pkl-tab.c"
        break;

    case 163: /* array_initializer_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3573 "pkl-tab.c"
        break;

    case 164: /* array_initializer  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3601 "pkl-tab.c"
        break;

    case 166: /* function_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3629 "pkl-tab.c"
        break;

    case 167: /* function_arg_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3657 "pkl-tab.c"
        break;

    case 168: /* function_arg  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3685 "pkl-tab.c"
        break;

    case 169: /* function_arg_initial  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3713 "pkl-tab.c"
        break;

    case 170: /* type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3741 "pkl-tab.c"
        break;

    case 171: /* typename  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3769 "pkl-tab.c"
        break;

    case 172: /* string_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3797 "pkl-tab.c"
        break;

    case 173: /* simple_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3825 "pkl-tab.c"
        break;

    case 174: /* cons_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3853 "pkl-tab.c"
        break;

    case 175: /* integral_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3881 "pkl-tab.c"
        break;

    case 177: /* offset_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3909 "pkl-tab.c"
        break;

    case 178: /* array_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3937 "pkl-tab.c"
        break;

    case 179: /* function_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3965 "pkl-tab.c"
        break;

    case 180: /* function_type_arg_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3993 "pkl-tab.c"
        break;

    case 181: /* function_type_arg  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4021 "pkl-tab.c"
        break;

    case 182: /* struct_type_specifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4049 "pkl-tab.c"
        break;

    case 186: /* integral_struct  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4077 "pkl-tab.c"
        break;

    case 187: /* struct_type_elem_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4105 "pkl-tab.c"
        break;

    case 189: /* struct_type_field  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4133 "pkl-tab.c"
        break;

    case 191: /* struct_type_field_identifier  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4161 "pkl-tab.c"
        break;

    case 192: /* struct_type_field_label  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4189 "pkl-tab.c"
        break;

    case 194: /* struct_type_field_optcond  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4217 "pkl-tab.c"
        break;

    case 195: /* simple_declaration  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4245 "pkl-tab.c"
        break;

    case 196: /* declaration  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4273 "pkl-tab.c"
        break;

    case 199: /* defvar_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4301 "pkl-tab.c"
        break;

    case 200: /* defvar  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4329 "pkl-tab.c"
        break;

    case 201: /* deftype_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4357 "pkl-tab.c"
        break;

    case 202: /* deftype  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4385 "pkl-tab.c"
        break;

    case 203: /* defunit_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4413 "pkl-tab.c"
        break;

    case 204: /* defunit  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4441 "pkl-tab.c"
        break;

    case 205: /* comp_stmt  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4469 "pkl-tab.c"
        break;

    case 207: /* stmt_decl_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4497 "pkl-tab.c"
        break;

    case 209: /* simple_stmt_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4525 "pkl-tab.c"
        break;

    case 210: /* simple_stmt  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4553 "pkl-tab.c"
        break;

    case 211: /* stmt  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4581 "pkl-tab.c"
        break;

    case 214: /* print_stmt_arg_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4609 "pkl-tab.c"
        break;

    case 215: /* funcall_stmt  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4637 "pkl-tab.c"
        break;

    case 216: /* funcall_stmt_arg_list  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4665 "pkl-tab.c"
        break;

    case 217: /* funcall_stmt_arg  */
#line 345 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4693 "pkl-tab.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct pkl_parser *pkl_parser)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize;

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    yy_state_t yyesa[20];
    yy_state_t *yyes;
    YYPTRDIFF_T yyes_capacity;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yynerrs = 0;
  yystate = 0;
  yyerrstatus = 0;

  yystacksize = YYINITDEPTH;
  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;

  yyes = yyesa;
  yyes_capacity = 20;
  if (YYMAXDEPTH < yyes_capacity)
    yyes_capacity = YYMAXDEPTH;


  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = PKL_TAB_EMPTY; /* Cause a token to be read.  */

/* User initialization code.  */
#line 30 "pkl-tab.y"
{
    yylloc.first_line = yylloc.last_line = 1;
    yylloc.first_column = yylloc.last_column = 1;
}

#line 4818 "pkl-tab.c"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == PKL_TAB_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, scanner);
    }

  if (yychar <= PKL_TAB_EOF)
    {
      yychar = PKL_TAB_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == PKL_TAB_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = PKL_TAB_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      YY_LAC_ESTABLISH;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = PKL_TAB_EMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 2:
#line 552 "pkl-tab.y"
                {
                  pkl_parser->env = pkl_env_push_frame (pkl_parser->env);
                }
#line 5039 "pkl-tab.c"
    break;

  case 3:
#line 567 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5049 "pkl-tab.c"
    break;

  case 4:
#line 573 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                  YYACCEPT;
                }
#line 5060 "pkl-tab.c"
    break;

  case 5:
#line 580 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5070 "pkl-tab.c"
    break;

  case 6:
#line 586 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5080 "pkl-tab.c"
    break;

  case 7:
#line 592 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5090 "pkl-tab.c"
    break;

  case 8:
#line 598 "pkl-tab.y"
                {
                  /* This rule is to allow the presence of an extra
                     ';' after the sentence.  This to allow the poke
                     command manager to ease the handling of
                     semicolons in the command line.  */
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5104 "pkl-tab.c"
    break;

  case 9:
#line 608 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5114 "pkl-tab.c"
    break;

  case 10:
#line 614 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5124 "pkl-tab.c"
    break;

  case 11:
#line 620 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5134 "pkl-tab.c"
    break;

  case 12:
#line 629 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 5142 "pkl-tab.c"
    break;

  case 15:
#line 638 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) != NULL)
                    (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast));
                  else
                    (yyval.ast) = (yyvsp[-1].ast);
                }
#line 5153 "pkl-tab.c"
    break;

  case 19:
#line 654 "pkl-tab.y"
                {
                  char *filename = NULL;
                  int ret = load_module (pkl_parser,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                         &(yyval.ast), 0 /* filename_p */, &filename);
                  if (ret == 2)
                    /* The sub-parser should have emitted proper error
                       messages.  No need to be verbose here.  */
                    YYERROR;
                  else if (ret == 1)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                 "cannot load `%s'",
                                 PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)));
                      YYERROR;
                    }

                  /* Prepend and append SRC nodes to handle the change of
                     source files.  */
                  {
                      pkl_ast_node src1 = pkl_ast_make_src (pkl_parser->ast,
                                                            filename);
                      pkl_ast_node src2 = pkl_ast_make_src (pkl_parser->ast,
                                                            pkl_parser->filename);

                      (yyval.ast) = pkl_ast_chainon (src1, (yyval.ast));
                      (yyval.ast) = pkl_ast_chainon ((yyval.ast), src2);
                  }

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast));
                  pkl_ast_node_free ((yyvsp[-1].ast));
                  free (filename);
                }
#line 5191 "pkl-tab.c"
    break;

  case 20:
#line 688 "pkl-tab.y"
                {
                  char *filename = PKL_AST_STRING_POINTER ((yyvsp[-1].ast));
                  int ret = load_module (pkl_parser,
                                         filename,
                                         &(yyval.ast), 1 /* filename_p */, NULL);
                  if (ret == 2)
                    /* The sub-parser should have emitted proper error
                       messages.  No need to be verbose here.  */
                    YYERROR;
                  else if (ret == 1)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                 "cannot load module from file `%s'",
                                 filename);
                      YYERROR;
                    }

                  /* Prepend and append SRC nodes to handle the change of
                     source files.  */
                  {
                      pkl_ast_node src1 = pkl_ast_make_src (pkl_parser->ast,
                                                            filename);
                      pkl_ast_node src2 = pkl_ast_make_src (pkl_parser->ast,
                                                            pkl_parser->filename);

                      (yyval.ast) = pkl_ast_chainon (src1, (yyval.ast));
                      (yyval.ast) = pkl_ast_chainon ((yyval.ast), src2);
                  }

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast));
                  pkl_ast_node_free ((yyvsp[-1].ast));
                }
#line 5228 "pkl-tab.c"
    break;

  case 23:
#line 737 "pkl-tab.y"
                  { (yyval.ast) = NULL; }
#line 5234 "pkl-tab.c"
    break;

  case 25:
#line 740 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                  }
#line 5242 "pkl-tab.c"
    break;

  case 26:
#line 746 "pkl-tab.y"
                 { (yyval.ast) = NULL; }
#line 5248 "pkl-tab.c"
    break;

  case 29:
#line 753 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast,
                                               (yyvsp[-1].opcode), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-1]);
                }
#line 5258 "pkl-tab.c"
    break;

  case 30:
#line 759 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_SIZEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 5267 "pkl-tab.c"
    break;

  case 31:
#line 764 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_ATTR,
                                                (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5278 "pkl-tab.c"
    break;

  case 32:
#line 771 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_ADD,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5288 "pkl-tab.c"
    break;

  case 33:
#line 777 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SUB,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5298 "pkl-tab.c"
    break;

  case 34:
#line 783 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_MUL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5308 "pkl-tab.c"
    break;

  case 35:
#line 789 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_DIV,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5318 "pkl-tab.c"
    break;

  case 36:
#line 795 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_CEILDIV, (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5327 "pkl-tab.c"
    break;

  case 37:
#line 800 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_POW, (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5336 "pkl-tab.c"
    break;

  case 38:
#line 805 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_MOD,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5346 "pkl-tab.c"
    break;

  case 39:
#line 811 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5356 "pkl-tab.c"
    break;

  case 40:
#line 817 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5366 "pkl-tab.c"
    break;

  case 41:
#line 823 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EQ,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5376 "pkl-tab.c"
    break;

  case 42:
#line 829 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_NE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5386 "pkl-tab.c"
    break;

  case 43:
#line 835 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_LT,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5396 "pkl-tab.c"
    break;

  case 44:
#line 841 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_GT,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5406 "pkl-tab.c"
    break;

  case 45:
#line 847 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_LE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5416 "pkl-tab.c"
    break;

  case 46:
#line 853 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_GE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5426 "pkl-tab.c"
    break;

  case 47:
#line 859 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IOR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5436 "pkl-tab.c"
    break;

  case 48:
#line 865 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_XOR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5446 "pkl-tab.c"
    break;

  case 49:
#line 871 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_BAND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5456 "pkl-tab.c"
    break;

  case 50:
#line 877 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_AND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5466 "pkl-tab.c"
    break;

  case 51:
#line 883 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_OR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5476 "pkl-tab.c"
    break;

  case 52:
#line 889 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IN,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5486 "pkl-tab.c"
    break;

  case 53:
#line 895 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_cast (pkl_parser->ast, (yyvsp[0].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5495 "pkl-tab.c"
    break;

  case 54:
#line 900 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_isa (pkl_parser->ast, (yyvsp[0].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5504 "pkl-tab.c"
    break;

  case 55:
#line 905 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_cond_exp (pkl_parser->ast,
                                              (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5514 "pkl-tab.c"
    break;

  case 56:
#line 911 "pkl-tab.y"
                {
                  /* This syntax is only used for array
                     constructors.  */
                  if (PKL_AST_TYPE_CODE ((yyvsp[-4].ast)) != PKL_TYPE_ARRAY)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-4]),
                                 "expected array type in constructor");
                      YYERROR;
                    }

                  (yyval.ast) = pkl_ast_make_cons (pkl_parser->ast, (yyvsp[-4].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5532 "pkl-tab.c"
    break;

  case 57:
#line 925 "pkl-tab.y"
                {
                  pkl_ast_node astruct;

                  /* This syntax is only used for struct
                     constructors.  */
                  if (PKL_AST_TYPE_CODE ((yyvsp[-4].ast)) != PKL_TYPE_STRUCT)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-4]),
                                 "expected struct type in constructor");
                      YYERROR;
                    }

                  astruct = pkl_ast_make_struct (pkl_parser->ast,
                                           0 /* nelem */, (yyvsp[-2].ast));
                  PKL_AST_LOC (astruct) = (yyloc);

                  (yyval.ast) = pkl_ast_make_cons (pkl_parser->ast, (yyvsp[-4].ast), astruct);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5556 "pkl-tab.c"
    break;

  case 58:
#line 945 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) == NULL)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "invalid unit in offset");
                      YYERROR;
                    }

                    (yyval.ast) = pkl_ast_make_offset (pkl_parser->ast, NULL, (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    if (PKL_AST_TYPE ((yyvsp[0].ast)))
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[0].ast))) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5575 "pkl-tab.c"
    break;

  case 59:
#line 960 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) == NULL)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "invalid unit in offset");
                      YYERROR;
                    }

                    (yyval.ast) = pkl_ast_make_offset (pkl_parser->ast, (yyvsp[-1].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    if (PKL_AST_TYPE ((yyvsp[0].ast)))
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[0].ast))) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5594 "pkl-tab.c"
    break;

  case 60:
#line 975 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[0].ast),
                                              PKL_AST_ORDER_PRE, PKL_AST_SIGN_INCR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5604 "pkl-tab.c"
    break;

  case 61:
#line 981 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[0].ast),
                                              PKL_AST_ORDER_PRE, PKL_AST_SIGN_DECR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5614 "pkl-tab.c"
    break;

  case 64:
#line 992 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_BCONC,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5624 "pkl-tab.c"
    break;

  case 65:
#line 1000 "pkl-tab.y"
             { (yyval.integer) = 1; }
#line 5630 "pkl-tab.c"
    break;

  case 66:
#line 1001 "pkl-tab.y"
                { (yyval.integer) = 0; }
#line 5636 "pkl-tab.c"
    break;

  case 67:
#line 1006 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_map (pkl_parser->ast, (yyvsp[-1].integer),
                                         (yyvsp[-2].ast), NULL, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5646 "pkl-tab.c"
    break;

  case 68:
#line 1012 "pkl-tab.y"
                 {
                   (yyval.ast) = pkl_ast_make_map (pkl_parser->ast, (yyvsp[-3].integer),
                                          (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                   PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5656 "pkl-tab.c"
    break;

  case 69:
#line 1020 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_NEG; }
#line 5662 "pkl-tab.c"
    break;

  case 70:
#line 1021 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_POS; }
#line 5668 "pkl-tab.c"
    break;

  case 71:
#line 1022 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_BNOT; }
#line 5674 "pkl-tab.c"
    break;

  case 72:
#line 1023 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_NOT; }
#line 5680 "pkl-tab.c"
    break;

  case 73:
#line 1024 "pkl-tab.y"
                               { (yyval.opcode) = PKL_AST_OP_UNMAP; }
#line 5686 "pkl-tab.c"
    break;

  case 74:
#line 1029 "pkl-tab.y"
                  {
                  /* Search for a variable definition in the
                     compile-time environment, and create a
                     PKL_AST_VAR node with it's lexical environment,
                     annotated with its initialization.  */

                  int back, over;
                  const char *name = PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast));

                  pkl_ast_node decl
                    = pkl_env_lookup (pkl_parser->env,
                                      PKL_ENV_NS_MAIN,
                                      name, &back, &over);
                  if (!decl
                      || (PKL_AST_DECL_KIND (decl) != PKL_AST_DECL_KIND_VAR
                          && PKL_AST_DECL_KIND (decl) != PKL_AST_DECL_KIND_FUNC))
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "undefined variable '%s'", name);
                      YYERROR;
                    }

                  (yyval.ast) = pkl_ast_make_var (pkl_parser->ast,
                                         (yyvsp[0].ast), /* name.  */
                                         decl,
                                         back, over);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 5719 "pkl-tab.c"
    break;

  case 75:
#line 1058 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 5729 "pkl-tab.c"
    break;

  case 76:
#line 1064 "pkl-tab.y"
                {
                  (yyval.ast) = NULL; /* To avoid bison warning.  */
                  pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                             "integer literal is too big");
                  YYERROR;
                }
#line 5740 "pkl-tab.c"
    break;

  case 77:
#line 1071 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 5750 "pkl-tab.c"
    break;

  case 78:
#line 1077 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 5760 "pkl-tab.c"
    break;

  case 79:
#line 1083 "pkl-tab.y"
                {
                  if (PKL_AST_CODE ((yyvsp[-1].ast)) == PKL_AST_VAR)
                    PKL_AST_VAR_IS_PARENTHESIZED ((yyvsp[-1].ast)) = 1;
                  else if (PKL_AST_CODE ((yyvsp[-1].ast)) == PKL_AST_STRUCT_REF)
                    PKL_AST_STRUCT_REF_IS_PARENTHESIZED ((yyvsp[-1].ast)) = 1;
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 5772 "pkl-tab.c"
    break;

  case 81:
#line 1092 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_ref (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5782 "pkl-tab.c"
    break;

  case 82:
#line 1098 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_indexer (pkl_parser->ast, (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5791 "pkl-tab.c"
    break;

  case 83:
#line 1103 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-5].ast), (yyvsp[-3].ast), NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5801 "pkl-tab.c"
    break;

  case 84:
#line 1109 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-5].ast), (yyvsp[-3].ast), (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5811 "pkl-tab.c"
    break;

  case 85:
#line 1115 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-3].ast), NULL, NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5821 "pkl-tab.c"
    break;

  case 86:
#line 1121 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-4].ast), NULL, (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5831 "pkl-tab.c"
    break;

  case 87:
#line 1127 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-4].ast), (yyvsp[-2].ast), NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5841 "pkl-tab.c"
    break;

  case 89:
#line 1134 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 5849 "pkl-tab.c"
    break;

  case 90:
#line 1138 "pkl-tab.y"
                {
                  /* function_specifier needs to know whether we are
                     in a function declaration or a method
                     declaration.  */
                  pkl_parser->in_method_decl_p = 0;
                }
#line 5860 "pkl-tab.c"
    break;

  case 91:
#line 1145 "pkl-tab.y"
                {
                  /* Annotate the contained RETURN statements with
                     their function and their lexical nest level
                     within the function.  */
                  pkl_ast_finish_returns ((yyvsp[0].ast));
                  (yyval.ast) = pkl_ast_make_lambda (pkl_parser->ast, (yyvsp[0].ast));
                }
#line 5872 "pkl-tab.c"
    break;

  case 92:
#line 1153 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[-1].ast),
                                              PKL_AST_ORDER_POST, PKL_AST_SIGN_INCR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5882 "pkl-tab.c"
    break;

  case 93:
#line 1159 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[-1].ast),
                                              PKL_AST_ORDER_POST, PKL_AST_SIGN_DECR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5892 "pkl-tab.c"
    break;

  case 94:
#line 1168 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall (pkl_parser->ast,
                                             (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5902 "pkl-tab.c"
    break;

  case 95:
#line 1177 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 5908 "pkl-tab.c"
    break;

  case 97:
#line 1180 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 5916 "pkl-tab.c"
    break;

  case 98:
#line 1187 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall_arg (pkl_parser->ast,
                                                 (yyvsp[0].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5926 "pkl-tab.c"
    break;

  case 101:
#line 1201 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 5932 "pkl-tab.c"
    break;

  case 103:
#line 1204 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 5940 "pkl-tab.c"
    break;

  case 104:
#line 1211 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_field (pkl_parser->ast,
                                                    NULL /* name */,
                                                    (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5951 "pkl-tab.c"
    break;

  case 105:
#line 1218 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_field (pkl_parser->ast,
                                                    (yyvsp[-2].ast),
                                                    (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5963 "pkl-tab.c"
    break;

  case 106:
#line 1229 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array (pkl_parser->ast,
                                             0 /* nelem */,
                                             0 /* ninitializer */,
                                             (yyvsp[-2].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5975 "pkl-tab.c"
    break;

  case 108:
#line 1241 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 5983 "pkl-tab.c"
    break;

  case 109:
#line 1248 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_array_initializer (pkl_parser->ast,
                                                         NULL, (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5993 "pkl-tab.c"
    break;

  case 110:
#line 1254 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array_initializer (pkl_parser->ast,
                                                         (yyvsp[-3].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6003 "pkl-tab.c"
    break;

  case 111:
#line 1267 "pkl-tab.y"
                {
                  /* Push the lexical frame for the function's
                     arguments.  */
                  pkl_parser->env = pkl_env_push_frame (pkl_parser->env);

                  /* If in a method, register a dummy for the initial
                     implicit argument.  */
                  if (pkl_parser->in_method_decl_p)
                    pkl_register_dummies (pkl_parser, 1);
                }
#line 6018 "pkl-tab.c"
    break;

  case 112:
#line 1281 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func (pkl_parser->ast,
                                          (yyvsp[-2].ast), (yyvsp[-4].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6032 "pkl-tab.c"
    break;

  case 113:
#line 1291 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func (pkl_parser->ast,
                                          (yyvsp[-3].ast), NULL, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6046 "pkl-tab.c"
    break;

  case 115:
#line 1305 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6054 "pkl-tab.c"
    break;

  case 116:
#line 1312 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_func_arg (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_register_arg (pkl_parser, (yyval.ast)))
                      YYERROR;
                }
#line 6068 "pkl-tab.c"
    break;

  case 117:
#line 1322 "pkl-tab.y"
                {
                  pkl_ast_node type
                    = pkl_ast_make_any_type (pkl_parser->ast);
                  pkl_ast_node array_type
                    = pkl_ast_make_array_type (pkl_parser->ast,
                                               type,
                                               NULL /* bound */);

                  PKL_AST_LOC (type) = (yylsp[-1]);
                  PKL_AST_LOC (array_type) = (yylsp[-1]);

                  (yyval.ast) = pkl_ast_make_func_arg (pkl_parser->ast,
                                              array_type,
                                              (yyvsp[-1].ast),
                                              NULL /* initial */);
                  PKL_AST_FUNC_ARG_VARARG ((yyval.ast)) = 1;
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_register_arg (pkl_parser, (yyval.ast)))
                      YYERROR;
                }
#line 6095 "pkl-tab.c"
    break;

  case 118:
#line 1347 "pkl-tab.y"
                                      { (yyval.ast) = NULL; }
#line 6101 "pkl-tab.c"
    break;

  case 119:
#line 1348 "pkl-tab.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 6107 "pkl-tab.c"
    break;

  case 123:
#line 1363 "pkl-tab.y"
                  {
                  pkl_ast_node decl = pkl_env_lookup (pkl_parser->env,
                                                      PKL_ENV_NS_MAIN,
                                                      PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)),
                                                      NULL, NULL);
                  assert (decl != NULL
                          && PKL_AST_DECL_KIND (decl) == PKL_AST_DECL_KIND_TYPE);
                  (yyval.ast) = PKL_AST_DECL_INITIAL (decl);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  (yyvsp[0].ast) = ASTREF ((yyvsp[0].ast)); pkl_ast_node_free ((yyvsp[0].ast));
                }
#line 6123 "pkl-tab.c"
    break;

  case 124:
#line 1378 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_string_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6132 "pkl-tab.c"
    break;

  case 125:
#line 1386 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_any_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6141 "pkl-tab.c"
    break;

  case 126:
#line 1391 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_void_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6150 "pkl-tab.c"
    break;

  case 135:
#line 1410 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_integral_type (pkl_parser->ast,
                                                     PKL_AST_INTEGER_VALUE ((yyvsp[-1].ast)),
                                                     (yyvsp[-2].integer));
                    (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast)); pkl_ast_node_free ((yyvsp[-1].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6162 "pkl-tab.c"
    break;

  case 136:
#line 1420 "pkl-tab.y"
                           { (yyval.integer) = 1; }
#line 6168 "pkl-tab.c"
    break;

  case 137:
#line 1421 "pkl-tab.y"
                            { (yyval.integer) = 0; }
#line 6174 "pkl-tab.c"
    break;

  case 138:
#line 1426 "pkl-tab.y"
                {
                  pkl_ast_node decl
                    = pkl_env_lookup (pkl_parser->env,
                                      PKL_ENV_NS_UNITS,
                                      PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                      NULL, NULL);

                  if (!decl)
                    {
                      /* This could be the name of a type.  Try it out.  */
                      decl = pkl_env_lookup (pkl_parser->env,
                                             PKL_ENV_NS_MAIN,
                                             PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                             NULL, NULL);

                      if (!decl)
                        {
                          pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                     "invalid unit in offset type");
                          YYERROR;
                        }
                    }

                  (yyval.ast) = pkl_ast_make_offset_type (pkl_parser->ast,
                                                 (yyvsp[-3].ast),
                                                 PKL_AST_DECL_INITIAL (decl));

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast)); pkl_ast_node_free ((yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6209 "pkl-tab.c"
    break;

  case 139:
#line 1457 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_offset_type (pkl_parser->ast,
                                                   (yyvsp[-3].ast), (yyvsp[-1].ast));
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-1].ast))) = (yylsp[-1]);
                    PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6221 "pkl-tab.c"
    break;

  case 140:
#line 1468 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_array_type (pkl_parser->ast, (yyvsp[-2].ast),
                                                NULL /* bound */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6231 "pkl-tab.c"
    break;

  case 141:
#line 1474 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_array_type (pkl_parser->ast, (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6240 "pkl-tab.c"
    break;

  case 142:
#line 1482 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_function_type (pkl_parser->ast,
                                                   (yyvsp[0].ast), 0 /* narg */,
                                                   (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6251 "pkl-tab.c"
    break;

  case 143:
#line 1489 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_function_type (pkl_parser->ast,
                                                   (yyvsp[0].ast), 0 /* narg */,
                                                   NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6262 "pkl-tab.c"
    break;

  case 145:
#line 1500 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6270 "pkl-tab.c"
    break;

  case 146:
#line 1507 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   (yyvsp[0].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6280 "pkl-tab.c"
    break;

  case 147:
#line 1513 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   (yyvsp[-1].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_FUNC_TYPE_ARG_OPTIONAL ((yyval.ast)) = 1;
                }
#line 6291 "pkl-tab.c"
    break;

  case 148:
#line 1520 "pkl-tab.y"
                {
                  pkl_ast_node type
                    = pkl_ast_make_any_type (pkl_parser->ast);
                  pkl_ast_node array_type
                    = pkl_ast_make_array_type (pkl_parser->ast,
                                               type, NULL /* bound */);

                  PKL_AST_LOC (type) = (yylsp[0]);
                  PKL_AST_LOC (array_type) = (yylsp[0]);

                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   array_type, NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_FUNC_TYPE_ARG_VARARG ((yyval.ast)) = 1;
                }
#line 6311 "pkl-tab.c"
    break;

  case 149:
#line 1540 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_type (pkl_parser->ast,
                                                   0 /* nelem */,
                                                   0 /* nfield */,
                                                   0 /* ndecl */,
                                                   (yyvsp[-2].ast),
                                                   NULL /* elems */,
                                                   (yyvsp[-4].integer), (yyvsp[-3].integer));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* The pushlevel in this rule and the subsequent
                       pop_frame, while not strictly needed, is to
                       avoid shift/reduce conflicts with the next
                       rule.  */
                    pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6332 "pkl-tab.c"
    break;

  case 150:
#line 1558 "pkl-tab.y"
                {
                  /* Register dummies for the locals used in
                     pkl-gen.pks:struct_mapper (not counting
                     OFFSET).  */
                  pkl_register_dummies (pkl_parser, 5);

                  /* Now register OFFSET with a type of
                     offset<uint<64>,1> */
                  {
                    pkl_ast_node decl, type;
                    pkl_ast_node offset_identifier
                      = pkl_ast_make_identifier (pkl_parser->ast, "OFFSET");
                    pkl_ast_node offset_magnitude
                      = pkl_ast_make_integer (pkl_parser->ast, 0);
                    pkl_ast_node offset_unit
                      = pkl_ast_make_integer (pkl_parser->ast, 1);
                    pkl_ast_node offset;

                    type = pkl_ast_make_integral_type (pkl_parser->ast, 64, 0);
                    PKL_AST_TYPE (offset_magnitude) = ASTREF (type);
                    PKL_AST_TYPE (offset_unit) = ASTREF (type);

                    offset = pkl_ast_make_offset (pkl_parser->ast,
                                                  offset_magnitude,
                                                  offset_unit);
                    type = pkl_ast_make_offset_type (pkl_parser->ast,
                                                     type,
                                                     offset_unit);
                    PKL_AST_TYPE (offset) = ASTREF (type);

                    decl = pkl_ast_make_decl (pkl_parser->ast,
                                              PKL_AST_DECL_KIND_VAR,
                                              offset_identifier,
                                              offset,
                                              NULL /* source */);

                    if (!pkl_env_register (pkl_parser->env,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER (offset_identifier),
                                           decl))
                      assert (0);
                  }
                }
#line 6380 "pkl-tab.c"
    break;

  case 151:
#line 1602 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_type (pkl_parser->ast,
                                                   0 /* nelem */,
                                                   0 /* nfield */,
                                                   0 /* ndecl */,
                                                   (yyvsp[-4].ast),
                                                   (yyvsp[-1].ast),
                                                   (yyvsp[-6].integer), (yyvsp[-5].integer));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* Pop the frame pushed in the `pushlevel' above.  */
                    pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6398 "pkl-tab.c"
    break;

  case 152:
#line 1618 "pkl-tab.y"
                        { (yyval.integer) = 0; }
#line 6404 "pkl-tab.c"
    break;

  case 153:
#line 1619 "pkl-tab.y"
                        { (yyval.integer) = 1; }
#line 6410 "pkl-tab.c"
    break;

  case 154:
#line 1623 "pkl-tab.y"
                        { (yyval.integer) = 0; }
#line 6416 "pkl-tab.c"
    break;

  case 155:
#line 1624 "pkl-tab.y"
                        { (yyval.integer) = 1; }
#line 6422 "pkl-tab.c"
    break;

  case 156:
#line 1628 "pkl-tab.y"
                         { (yyval.ast) = NULL; }
#line 6428 "pkl-tab.c"
    break;

  case 157:
#line 1629 "pkl-tab.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 6434 "pkl-tab.c"
    break;

  case 160:
#line 1636 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 6440 "pkl-tab.c"
    break;

  case 161:
#line 1638 "pkl-tab.y"
                { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 6446 "pkl-tab.c"
    break;

  case 162:
#line 1642 "pkl-tab.y"
                        { (yyval.integer) = PKL_AST_ENDIAN_DFL; }
#line 6452 "pkl-tab.c"
    break;

  case 163:
#line 1643 "pkl-tab.y"
                        { (yyval.integer) = PKL_AST_ENDIAN_LSB; }
#line 6458 "pkl-tab.c"
    break;

  case 164:
#line 1644 "pkl-tab.y"
                             { (yyval.integer) = PKL_AST_ENDIAN_MSB; }
#line 6464 "pkl-tab.c"
    break;

  case 165:
#line 1649 "pkl-tab.y"
                  {
                    /* Register a variable in the current environment
                       for the field.  We do it in this mid-rule so
                       the element can be used in the constraint.  */

                    pkl_ast_node dummy, decl;
                    pkl_ast_node identifier
                      = ((yyvsp[0].ast) != NULL
                         ? (yyvsp[0].ast)
                         : pkl_ast_make_identifier (pkl_parser->ast, ""));


                    dummy = pkl_ast_make_integer (pkl_parser->ast, 0);
                    PKL_AST_TYPE (dummy) = ASTREF ((yyvsp[-1].ast));
                    decl = pkl_ast_make_decl (pkl_parser->ast,
                                              PKL_AST_DECL_KIND_VAR,
                                              identifier, dummy,
                                              NULL /* source */);
                    PKL_AST_DECL_STRUCT_FIELD_P (decl) = 1;
                    PKL_AST_LOC (decl) = (yyloc);

                    if (!pkl_env_register (pkl_parser->env,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER (identifier),
                                           decl))
                      {
                        pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                   "duplicated struct element '%s'",
                                   PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)));
                        YYERROR;
                      }

                    if (identifier)
                      {
                        identifier = ASTREF (identifier);
                        pkl_ast_node_free (identifier);
                      }
                  }
#line 6507 "pkl-tab.c"
    break;

  case 166:
#line 1689 "pkl-tab.y"
                  {
                    pkl_ast_node constraint = (yyvsp[-3].astpair)[0];
                    pkl_ast_node initializer = (yyvsp[-3].astpair)[1];

                    if (initializer)
                      {
                        pkl_ast_node field_decl, field_var;
                        int back, over;

                        /* We need a field name.  */
                        if ((yyvsp[-5].ast) == NULL)
                          {
                            pkl_error (pkl_parser->compiler, pkl_parser->ast, (yyloc),
                                       "no initializer allowed in anonymous field");
                            YYERROR;
                          }

                        /* Build a constraint derived from the
                           initializer if a constraint has not been
                           specified.  */
                        if (constraint == NULL)
                          {
                            field_decl = pkl_env_lookup (pkl_parser->env,
                                                         PKL_ENV_NS_MAIN,
                                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-5].ast)),
                                                         &back, &over);
                            assert (field_decl);

                            field_var = pkl_ast_make_var (pkl_parser->ast,
                                                          (yyvsp[-5].ast),
                                                          field_decl,
                                                          back, over);
                            PKL_AST_LOC (field_var) = PKL_AST_LOC (initializer);

                            constraint = pkl_ast_make_binary_exp (pkl_parser->ast,
                                                                  PKL_AST_OP_EQ,
                                                                  field_var,
                                                                  initializer);
                            PKL_AST_LOC (constraint) = PKL_AST_LOC (initializer);
                          }
                      }

                    (yyval.ast) = pkl_ast_make_struct_type_field (pkl_parser->ast, (yyvsp[-5].ast), (yyvsp[-6].ast),
                                                         constraint, initializer,
                                                         (yyvsp[-2].ast), (yyvsp[-7].integer), (yyvsp[-1].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* If endianness is empty, bison includes the
                       blank characters before the type field as if
                       they were part of this rule.  Therefore the
                       location should be adjusted here.  */
                    if ((yyvsp[-7].integer) == PKL_AST_ENDIAN_DFL)
                      {
                        PKL_AST_LOC ((yyval.ast)).first_line = (yylsp[-6]).first_line;
                        PKL_AST_LOC ((yyval.ast)).first_column = (yylsp[-6]).first_column;
                      }

                    if ((yyvsp[-5].ast) != NULL)
                      {
                        PKL_AST_LOC ((yyvsp[-5].ast)) = (yylsp[-5]);
                        PKL_AST_TYPE ((yyvsp[-5].ast)) = pkl_ast_make_string_type (pkl_parser->ast);
                        PKL_AST_TYPE ((yyvsp[-5].ast)) = ASTREF (PKL_AST_TYPE ((yyvsp[-5].ast)));
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-5].ast))) = (yylsp[-5]);
                      }
                  }
#line 6577 "pkl-tab.c"
    break;

  case 167:
#line 1757 "pkl-tab.y"
                        { (yyval.ast) = NULL; }
#line 6583 "pkl-tab.c"
    break;

  case 168:
#line 1758 "pkl-tab.y"
                            { (yyval.ast) = (yyvsp[0].ast); }
#line 6589 "pkl-tab.c"
    break;

  case 169:
#line 1763 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 6597 "pkl-tab.c"
    break;

  case 170:
#line 1767 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6606 "pkl-tab.c"
    break;

  case 171:
#line 1775 "pkl-tab.y"
                {
                  (yyval.astpair)[0] = NULL;
                  (yyval.astpair)[1] = NULL;
                }
#line 6615 "pkl-tab.c"
    break;

  case 172:
#line 1780 "pkl-tab.y"
                {
                  (yyval.astpair)[0] = (yyvsp[0].ast);
                  (yyval.astpair)[1] = NULL;
                  PKL_AST_LOC ((yyval.astpair)[0]) = (yyloc);
                }
#line 6625 "pkl-tab.c"
    break;

  case 173:
#line 1786 "pkl-tab.y"
                {
                  (yyval.astpair)[0] = NULL;
                  (yyval.astpair)[1] = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.astpair)[1]) = (yyloc);
                }
#line 6635 "pkl-tab.c"
    break;

  case 174:
#line 1792 "pkl-tab.y"
                {
                  (yyval.astpair)[0] = (yyvsp[0].ast);
                  (yyval.astpair)[1] = (yyvsp[-2].ast);

                  PKL_AST_LOC ((yyval.astpair)[0]) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.astpair)[1]) = (yylsp[-2]);
                }
#line 6647 "pkl-tab.c"
    break;

  case 175:
#line 1800 "pkl-tab.y"
                {
                  (yyval.astpair)[0] = (yyvsp[-2].ast);
                  (yyval.astpair)[1] = (yyvsp[0].ast);

                  PKL_AST_LOC ((yyval.astpair)[0]) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.astpair)[1]) = (yylsp[0]);
                }
#line 6659 "pkl-tab.c"
    break;

  case 176:
#line 1811 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 6667 "pkl-tab.c"
    break;

  case 177:
#line 1815 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6676 "pkl-tab.c"
    break;

  case 178:
#line 1826 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 6682 "pkl-tab.c"
    break;

  case 179:
#line 1827 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 6688 "pkl-tab.c"
    break;

  case 180:
#line 1828 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 6694 "pkl-tab.c"
    break;

  case 181:
#line 1833 "pkl-tab.y"
                {
                  /* In order to allow for the function to be called
                     from within itself (recursive calls) we should
                     register a partial declaration in the
                     compile-time environment before processing the
                     `function_specifier' below.  */

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_FUNC, (yyvsp[0].ast),
                                               NULL /* initial */,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_env_register (pkl_parser->env,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)),
                                         (yyval.ast)))
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "function or variable `%s' already defined",
                                 PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)));
                      YYERROR;
                    }

                  /* function_specifier needs to know whether we are
                     in a function declaration or a method
                     declaration.  */
                  pkl_parser->in_method_decl_p = ((yyvsp[-1].integer) == IS_METHOD);
                }
#line 6729 "pkl-tab.c"
    break;

  case 182:
#line 1864 "pkl-tab.y"
                {
                  /* Complete the declaration registered above with
                     it's initial value, which is the specifier of the
                     function being defined.  */
                  PKL_AST_DECL_INITIAL ((yyvsp[-2].ast))
                    = ASTREF ((yyvsp[0].ast));
                  (yyval.ast) = (yyvsp[-2].ast);

                  /* If the reference counting of the declaration is
                     bigger than 1, this means there are recursive
                     calls in the function body.  Reset the refcount
                     to 1, since these references are weak.  */
                  if (PKL_AST_REFCOUNT ((yyvsp[-2].ast)) > 1)
                    PKL_AST_REFCOUNT ((yyvsp[-2].ast)) = 1;

                  /* Annotate the contained RETURN statements with
                     their function and their lexical nest level
                     within the function.  */
                  pkl_ast_finish_returns ((yyvsp[0].ast));

                  /* Annotate the function to be a method whenever
                     appropriate.  */
                  if ((yyvsp[-4].integer) == IS_METHOD)
                    PKL_AST_FUNC_METHOD_P ((yyvsp[0].ast)) = 1;

                  /* XXX: move to trans1.  */
                  PKL_AST_FUNC_NAME ((yyvsp[0].ast))
                    = xstrdup (PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)));

                  pkl_parser->in_method_decl_p = 0;
                }
#line 6765 "pkl-tab.c"
    break;

  case 183:
#line 1895 "pkl-tab.y"
                                 { (yyval.ast) = (yyvsp[-1].ast); }
#line 6771 "pkl-tab.c"
    break;

  case 184:
#line 1899 "pkl-tab.y"
                               { (yyval.integer) = IS_DEFUN; }
#line 6777 "pkl-tab.c"
    break;

  case 185:
#line 1900 "pkl-tab.y"
                        { (yyval.integer) = IS_METHOD; }
#line 6783 "pkl-tab.c"
    break;

  case 187:
#line 1906 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 6789 "pkl-tab.c"
    break;

  case 188:
#line 1911 "pkl-tab.y"
            {
                (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                        PKL_AST_DECL_KIND_VAR, (yyvsp[-2].ast), (yyvsp[0].ast),
                                        pkl_parser->filename);
                PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                PKL_AST_LOC ((yyval.ast)) = (yyloc);

                if (!pkl_env_register (pkl_parser->env,
                                       PKL_ENV_NS_MAIN,
                                       PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                       (yyval.ast)))
                  {
                    pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                               "the variable `%s' is already defined",
                               PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                    YYERROR;
                  }
          }
#line 6812 "pkl-tab.c"
    break;

  case 190:
#line 1934 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 6818 "pkl-tab.c"
    break;

  case 191:
#line 1939 "pkl-tab.y"
          {
            (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                    PKL_AST_DECL_KIND_TYPE, (yyvsp[-2].ast), (yyvsp[0].ast),
                                    pkl_parser->filename);
            PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
            PKL_AST_LOC ((yyval.ast)) = (yyloc);

            PKL_AST_TYPE_NAME ((yyvsp[0].ast)) = ASTREF ((yyvsp[-2].ast));

            if (!pkl_env_register (pkl_parser->env,
                                   PKL_ENV_NS_MAIN,
                                   PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                   (yyval.ast)))
              {
                pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                           "the type `%s' is already defined",
                           PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                YYERROR;
              }
          }
#line 6843 "pkl-tab.c"
    break;

  case 193:
#line 1964 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 6849 "pkl-tab.c"
    break;

  case 194:
#line 1969 "pkl-tab.y"
            {
              /* We need to cast the expression to uint<64> here,
                 instead of pkl-promo, because the installed
                 initializer is used as earlier as in the lexer.  Not
                 pretty.  */
              pkl_ast_node type
                = pkl_ast_make_integral_type (pkl_parser->ast,
                                              64, 0);
              pkl_ast_node cast
                = pkl_ast_make_cast (pkl_parser->ast,
                                     type, (yyvsp[0].ast));

              (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                      PKL_AST_DECL_KIND_UNIT, (yyvsp[-2].ast), cast,
                                      pkl_parser->filename);

              PKL_AST_LOC (type) = (yylsp[0]);
              PKL_AST_LOC (cast) = (yylsp[0]);
              PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              if (!pkl_env_register (pkl_parser->env,
                                     PKL_ENV_NS_UNITS,
                                     PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                     (yyval.ast)))
                {
                  pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                             "the unit `%s' is already defined",
                             PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                  YYERROR;
                }
            }
#line 6886 "pkl-tab.c"
    break;

  case 195:
#line 2008 "pkl-tab.y"
            {
              (yyval.ast) = pkl_ast_make_comp_stmt (pkl_parser->ast, NULL);
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              /* Pop the frame pushed by the `pushlevel' above.  */
              pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
            }
#line 6898 "pkl-tab.c"
    break;

  case 196:
#line 2016 "pkl-tab.y"
            {
              (yyval.ast) = pkl_ast_make_comp_stmt (pkl_parser->ast, (yyvsp[-1].ast));
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              /* Pop the frame pushed by the `pushlevel' above.  */
              pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
            }
#line 6910 "pkl-tab.c"
    break;

  case 197:
#line 2024 "pkl-tab.y"
        {
          (yyval.ast) = pkl_ast_make_builtin (pkl_parser->ast, (yyvsp[0].integer));
          PKL_AST_LOC ((yyval.ast)) = (yyloc);

          /* Pop the frame pushed by the `pushlevel' above.  */
          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
        }
#line 6922 "pkl-tab.c"
    break;

  case 198:
#line 2034 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_RAND; }
#line 6928 "pkl-tab.c"
    break;

  case 199:
#line 2035 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_GET_ENDIAN; }
#line 6934 "pkl-tab.c"
    break;

  case 200:
#line 2036 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_SET_ENDIAN; }
#line 6940 "pkl-tab.c"
    break;

  case 201:
#line 2037 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_GET_IOS; }
#line 6946 "pkl-tab.c"
    break;

  case 202:
#line 2038 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_SET_IOS; }
#line 6952 "pkl-tab.c"
    break;

  case 203:
#line 2039 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_OPEN; }
#line 6958 "pkl-tab.c"
    break;

  case 204:
#line 2040 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_CLOSE; }
#line 6964 "pkl-tab.c"
    break;

  case 205:
#line 2041 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_IOSIZE; }
#line 6970 "pkl-tab.c"
    break;

  case 206:
#line 2042 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_IOFLAGS; }
#line 6976 "pkl-tab.c"
    break;

  case 207:
#line 2043 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_GETENV; }
#line 6982 "pkl-tab.c"
    break;

  case 208:
#line 2044 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_FORGET; }
#line 6988 "pkl-tab.c"
    break;

  case 209:
#line 2045 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_GET_TIME; }
#line 6994 "pkl-tab.c"
    break;

  case 210:
#line 2046 "pkl-tab.y"
                                { (yyval.integer) = PKL_AST_BUILTIN_STRACE; }
#line 7000 "pkl-tab.c"
    break;

  case 211:
#line 2047 "pkl-tab.y"
                                 { (yyval.integer) = PKL_AST_BUILTIN_TERM_GET_COLOR; }
#line 7006 "pkl-tab.c"
    break;

  case 212:
#line 2048 "pkl-tab.y"
                                 { (yyval.integer) = PKL_AST_BUILTIN_TERM_SET_COLOR; }
#line 7012 "pkl-tab.c"
    break;

  case 213:
#line 2049 "pkl-tab.y"
                                   { (yyval.integer) = PKL_AST_BUILTIN_TERM_GET_BGCOLOR; }
#line 7018 "pkl-tab.c"
    break;

  case 214:
#line 2050 "pkl-tab.y"
                                   { (yyval.integer) = PKL_AST_BUILTIN_TERM_SET_BGCOLOR; }
#line 7024 "pkl-tab.c"
    break;

  case 215:
#line 2051 "pkl-tab.y"
                                   { (yyval.integer) = PKL_AST_BUILTIN_TERM_BEGIN_CLASS; }
#line 7030 "pkl-tab.c"
    break;

  case 216:
#line 2052 "pkl-tab.y"
                                 { (yyval.integer) = PKL_AST_BUILTIN_TERM_END_CLASS; }
#line 7036 "pkl-tab.c"
    break;

  case 217:
#line 2053 "pkl-tab.y"
                                       { (yyval.integer) = PKL_AST_BUILTIN_TERM_BEGIN_HYPERLINK; }
#line 7042 "pkl-tab.c"
    break;

  case 218:
#line 2054 "pkl-tab.y"
                                     { (yyval.integer) = PKL_AST_BUILTIN_TERM_END_HYPERLINK; }
#line 7048 "pkl-tab.c"
    break;

  case 219:
#line 2055 "pkl-tab.y"
                                    { (yyval.integer) = PKL_AST_BUILTIN_UNSAFE_STRING_SET; }
#line 7054 "pkl-tab.c"
    break;

  case 221:
#line 2061 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7060 "pkl-tab.c"
    break;

  case 223:
#line 2064 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7066 "pkl-tab.c"
    break;

  case 224:
#line 2068 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_POW; }
#line 7072 "pkl-tab.c"
    break;

  case 225:
#line 2069 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_MUL; }
#line 7078 "pkl-tab.c"
    break;

  case 226:
#line 2070 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_DIV; }
#line 7084 "pkl-tab.c"
    break;

  case 227:
#line 2071 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_MOD; }
#line 7090 "pkl-tab.c"
    break;

  case 228:
#line 2072 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_ADD; }
#line 7096 "pkl-tab.c"
    break;

  case 229:
#line 2073 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SUB; }
#line 7102 "pkl-tab.c"
    break;

  case 230:
#line 2074 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SL; }
#line 7108 "pkl-tab.c"
    break;

  case 231:
#line 2075 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SR; }
#line 7114 "pkl-tab.c"
    break;

  case 232:
#line 2076 "pkl-tab.y"
                { (yyval.integer) = PKL_AST_OP_BAND; }
#line 7120 "pkl-tab.c"
    break;

  case 233:
#line 2077 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_IOR; }
#line 7126 "pkl-tab.c"
    break;

  case 234:
#line 2078 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_XOR; }
#line 7132 "pkl-tab.c"
    break;

  case 235:
#line 2082 "pkl-tab.y"
                 { (yyval.ast) = NULL; }
#line 7138 "pkl-tab.c"
    break;

  case 237:
#line 2085 "pkl-tab.y"
                 { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7144 "pkl-tab.c"
    break;

  case 238:
#line 2090 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7154 "pkl-tab.c"
    break;

  case 239:
#line 2096 "pkl-tab.y"
                {
                  pkl_ast_node exp
                    = pkl_ast_make_binary_exp (pkl_parser->ast,
                                               (yyvsp[-1].integer), (yyvsp[-2].ast), (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), exp);
                  PKL_AST_LOC (exp) = (yyloc);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7169 "pkl-tab.c"
    break;

  case 240:
#line 2107 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7179 "pkl-tab.c"
    break;

  case 241:
#line 2113 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7189 "pkl-tab.c"
    break;

  case 242:
#line 2119 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_exp_stmt (pkl_parser->ast,
                                              (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7199 "pkl-tab.c"
    break;

  case 243:
#line 2125 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                (yyvsp[-2].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7212 "pkl-tab.c"
    break;

  case 244:
#line 2134 "pkl-tab.y"
                {
                  if (((yyval.ast) = pkl_make_assertion (pkl_parser, (yyvsp[-1].ast), NULL, (yyloc)))
                      == NULL)
                    YYERROR;
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7223 "pkl-tab.c"
    break;

  case 245:
#line 2141 "pkl-tab.y"
                {
                  if (((yyval.ast) = pkl_make_assertion (pkl_parser, (yyvsp[-3].ast), (yyvsp[-1].ast), (yyloc)))
                      == NULL)
                    YYERROR;
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7234 "pkl-tab.c"
    break;

  case 246:
#line 2148 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_exp_stmt (pkl_parser->ast,
                                              (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7244 "pkl-tab.c"
    break;

  case 248:
#line 2158 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_null_stmt (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7253 "pkl-tab.c"
    break;

  case 249:
#line 2163 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 7261 "pkl-tab.c"
    break;

  case 250:
#line 2167 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_if_stmt (pkl_parser->ast,
                                             (yyvsp[-2].ast), (yyvsp[0].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7271 "pkl-tab.c"
    break;

  case 251:
#line 2173 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_if_stmt (pkl_parser->ast,
                                             (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7281 "pkl-tab.c"
    break;

  case 252:
#line 2179 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_WHILE,
                                               NULL, /* iterator */
                                               (yyvsp[-2].ast),   /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast));  /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Annotate the contained BREAK and CONTINUE
                     statements with their lexical level within this
                     loop.  */
                  pkl_ast_finish_breaks ((yyval.ast), (yyvsp[0].ast));
                }
#line 7301 "pkl-tab.c"
    break;

  case 253:
#line 2195 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR,
                                               NULL, /* iterator */
                                               (yyvsp[-4].ast),   /* condition */
                                               (yyvsp[-6].ast),   /* head */
                                               (yyvsp[-2].ast),   /* tail */
                                               (yyvsp[0].ast)); /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Annotate the contained BREAK and CONTINUE
                     statements with their lexical level within this
                     loop.  */
                  pkl_ast_finish_breaks ((yyval.ast), (yyvsp[0].ast));

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7325 "pkl-tab.c"
    break;

  case 254:
#line 2215 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR,
                                               NULL, /* iterator */
                                               (yyvsp[-4].ast),   /* condition */
                                               NULL, /* head */
                                               (yyvsp[-2].ast),   /* tail */
                                               (yyvsp[0].ast));  /* body */

                  /* Annotate the contained BREAK and CONTINUE
                     statements with their lexical level within this
                     loop.  */
                  pkl_ast_finish_breaks ((yyval.ast), (yyvsp[0].ast));

                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7346 "pkl-tab.c"
    break;

  case 255:
#line 2232 "pkl-tab.y"
                {
                  /* Push a new lexical level and register a variable
                     with name IDENTIFIER.  Note that the variable is
                     created with a dummy INITIAL, as there is none.  */

                  pkl_ast_node dummy = pkl_ast_make_integer (pkl_parser->ast,
                                                             0);
                  PKL_AST_LOC (dummy) = (yylsp[-3]);

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_VAR,
                                               (yyvsp[-3].ast),
                                               dummy,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);

                  if (!pkl_env_register (pkl_parser->env,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)),
                                         (yyval.ast)))
                    /* This should never happen.  */
                    assert (0);
                }
#line 7374 "pkl-tab.c"
    break;

  case 256:
#line 2256 "pkl-tab.y"
                {
                  pkl_ast_node iterator
                    = pkl_ast_make_loop_stmt_iterator (pkl_parser->ast,
                                                       (yyvsp[-2].ast), /* decl */
                                                       (yyvsp[-4].ast)); /* container */
                  PKL_AST_LOC (iterator) = (yyloc);

                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR_IN,
                                               iterator,
                                               NULL, /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast));  /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Free the identifier.  */
                  (yyvsp[-6].ast) = ASTREF ((yyvsp[-6].ast)); pkl_ast_node_free ((yyvsp[-6].ast));

                  /* Annotate the contained BREAK and CONTINUE
                     statements with their lexical level within this
                     loop.  */
                  pkl_ast_finish_breaks ((yyval.ast), (yyvsp[0].ast));

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7407 "pkl-tab.c"
    break;

  case 257:
#line 2285 "pkl-tab.y"
                {
                  /* XXX: avoid code replication here.  */

                  /* Push a new lexical level and register a variable
                     with name IDENTIFIER.  Note that the variable is
                     created with a dummy INITIAL, as there is none.  */

                  pkl_ast_node dummy = pkl_ast_make_integer (pkl_parser->ast,
                                                             0);
                  PKL_AST_LOC (dummy) = (yylsp[-3]);

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_VAR,
                                               (yyvsp[-3].ast),
                                               dummy,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);

                  if (!pkl_env_register (pkl_parser->env,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)),
                                         (yyval.ast)))
                    /* This should never happen.  */
                    assert (0);
                }
#line 7437 "pkl-tab.c"
    break;

  case 258:
#line 2311 "pkl-tab.y"
                {
                  pkl_ast_node iterator
                    = pkl_ast_make_loop_stmt_iterator (pkl_parser->ast,
                                                       (yyvsp[-4].ast), /* decl */
                                                       (yyvsp[-6].ast)); /* container */
                  PKL_AST_LOC (iterator) = (yyloc);

                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR_IN,
                                               iterator,
                                               (yyvsp[-2].ast), /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast)); /* body */
                  PKL_AST_LOC ((yyvsp[-8].ast)) = (yylsp[-8]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Annotate the contained BREAK and CONTINUE
                     statements with their lexical level within this
                     loop.  */
                  pkl_ast_finish_breaks ((yyval.ast), (yyvsp[0].ast));

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7468 "pkl-tab.c"
    break;

  case 259:
#line 2338 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_break_stmt (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7477 "pkl-tab.c"
    break;

  case 260:
#line 2343 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_continue_stmt (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7486 "pkl-tab.c"
    break;

  case 261:
#line 2348 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_return_stmt (pkl_parser->ast,
                                                 NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7496 "pkl-tab.c"
    break;

  case 262:
#line 2354 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_return_stmt (pkl_parser->ast,
                                                 (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7506 "pkl-tab.c"
    break;

  case 263:
#line 2360 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_try_catch_stmt (pkl_parser->ast,
                                                    (yyvsp[-2].ast), (yyvsp[0].ast), NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7516 "pkl-tab.c"
    break;

  case 264:
#line 2366 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_try_catch_stmt (pkl_parser->ast,
                                                    (yyvsp[-4].ast), (yyvsp[0].ast), NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7526 "pkl-tab.c"
    break;

  case 265:
#line 2372 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_try_catch_stmt (pkl_parser->ast,
                                                    (yyvsp[-6].ast), (yyvsp[0].ast), (yyvsp[-2].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7540 "pkl-tab.c"
    break;

  case 266:
#line 2382 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_try_until_stmt (pkl_parser->ast,
                                                    (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Annotate the contained BREAK and CONTINUE
                     statements with their lexical level within this
                     loop.  */
                  pkl_ast_finish_breaks ((yyval.ast), (yyvsp[-3].ast));
                }
#line 7555 "pkl-tab.c"
    break;

  case 267:
#line 2393 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_raise_stmt (pkl_parser->ast,
                                                NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7565 "pkl-tab.c"
    break;

  case 268:
#line 2399 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_raise_stmt (pkl_parser->ast,
                                                (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7575 "pkl-tab.c"
    break;

  case 269:
#line 2405 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                NULL /* fmt */, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7585 "pkl-tab.c"
    break;

  case 270:
#line 2411 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                (yyvsp[-2].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7598 "pkl-tab.c"
    break;

  case 271:
#line 2423 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7606 "pkl-tab.c"
    break;

  case 272:
#line 2427 "pkl-tab.y"
                {
                  pkl_ast_node arg
                    = pkl_ast_make_print_stmt_arg (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC (arg) = (yylsp[0]);

                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), arg);
                }
#line 7618 "pkl-tab.c"
    break;

  case 273:
#line 2438 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_funcall (pkl_parser->ast,
                                             (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7628 "pkl-tab.c"
    break;

  case 275:
#line 2448 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast));
                }
#line 7636 "pkl-tab.c"
    break;

  case 276:
#line 2455 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall_arg (pkl_parser->ast,
                                                 (yyvsp[0].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7647 "pkl-tab.c"
    break;


#line 7651 "pkl-tab.c"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == PKL_TAB_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken, &yylloc};
        if (yychar != PKL_TAB_EMPTY)
          YY_LAC_ESTABLISH;
        if (yyreport_syntax_error (&yyctx, pkl_parser) == 2)
          goto yyexhaustedlab;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= PKL_TAB_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == PKL_TAB_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, pkl_parser);
          yychar = PKL_TAB_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, pkl_parser);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if 1
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, pkl_parser, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != PKL_TAB_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, pkl_parser);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, pkl_parser);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);

  return yyresult;
}

#line 2494 "pkl-tab.y"


/* Handle syntax errors.  */

int
yyreport_syntax_error (const yypcontext_t *ctx,
                       struct pkl_parser *pkl_parser)
{
  int res = 0;
  yysymbol_kind_t lookahead = yypcontext_token (ctx);

  /* if the unexpected token is alien, then report
     pkl_parser->alien_err_msg.  */
  if (lookahead == YYSYMBOL_ALIEN)
    {
      pkl_tab_error (yypcontext_location (ctx),
                     pkl_parser,
                     pkl_parser->alien_errmsg);
      free (pkl_parser->alien_errmsg);
      pkl_parser->alien_errmsg = NULL;
    }
  else
    {
      /* report tokens expected at this point.  */
      yysymbol_kind_t expected[YYNTOKENS];
      int nexpected = yypcontext_expected_tokens (ctx, expected, YYNTOKENS);

      if (nexpected < 0)
        /* forward errors to yyparse.  */
        res = nexpected;
      else
        {
          char *errmsg = strdup ("syntax error");

          if (!errmsg)
            return YYENOMEM;

          if (lookahead != YYSYMBOL_YYEMPTY)
            {
              char *tmp = pk_str_concat (errmsg,
                                         ": unexpected ",
                                         yysymbol_name (lookahead),
                                         NULL);
              free (errmsg);
              if (!tmp)
                return YYENOMEM;
              errmsg = tmp;
            }

          pkl_tab_error (yypcontext_location (ctx), pkl_parser, errmsg);
          free (errmsg);
        }
    }

  return res;
}
