// ============================================================================
//
// Copyright (c) 2006-2015, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.configurationsync_4_4;

import routines.Numeric;
import routines.DataOperation;
import routines.TalendDataGenerator;
import routines.TalendString;
import routines.RoutineHistoryETL;
import routines.StringHandling;
import routines.Relational;
import routines.TalendDate;
import routines.Mathematical;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: ConfigurationSync Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 6.1.1.20151214_1327
 * @status 
 */
public class ConfigurationSync implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "4.4";
	private final String jobName = "ConfigurationSync";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private Exception exception;

	public Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					ConfigurationSync.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(ConfigurationSync.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (TalendException e) {
					// do nothing

				} catch (Exception e) {
					this.e.printStackTrace();
				}
			}
		}
	}

	public void tPrejob_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_9_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_11_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_10_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_10_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_15_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_14_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_14_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_18_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_15_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_15_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_20_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_16_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_16_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_33_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_33_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_23_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_33_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_23_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_33_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_34_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_34_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_22_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_34_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_24_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_34_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_22_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_17_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_17_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_24_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_18_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_18_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_6_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_26_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_19_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_19_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_7_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_7_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_7_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_28_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_28_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_20_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_28_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_20_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_28_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_8_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_8_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_8_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_30_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_30_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_21_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_30_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_21_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_30_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_53_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_53_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_31_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_53_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_31_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_53_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_56_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_56_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_32_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_56_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_32_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_56_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_45_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_45_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_26_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_45_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_26_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_45_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_48_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_48_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_27_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_48_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_27_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_48_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_46_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCSP_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_28_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_28_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_46_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_50_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_50_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_29_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_50_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_29_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_50_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRow_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRow_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_52_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_30_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_33_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_52_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_10_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_11_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_11_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_39_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_39_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_40_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_40_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_41_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_41_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_43_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_43_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_42_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_42_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_44_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_44_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_14_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_17_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_17_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_19_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_19_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_21_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_23_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_23_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_25_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_25_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_27_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_27_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_29_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_29_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_35_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_35_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_32_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_32_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_58_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_58_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_47_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_47_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_59_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_59_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_49_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_49_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_55_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_55_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_54_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_54_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_65_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_65_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_66_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_66_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_12_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row35_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_39_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row36_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_40_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row37_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_41_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row38_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_43_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row39_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_42_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row40_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_44_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row15_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row16_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_17_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row18_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_19_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row20_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row22_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_23_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row24_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_25_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row26_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_27_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row28_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_29_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row33_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_35_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row32_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_32_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row34_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_58_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row11_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_47_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row43_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_59_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row13_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_49_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row47_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_55_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row46_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_54_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row53_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_65_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row54_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_66_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row58_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_9_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_11_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_15_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_18_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_20_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_33_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_34_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_22_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_24_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_6_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_26_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_7_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_28_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_8_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_30_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_53_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_56_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_45_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_48_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_46_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_50_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRow_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_52_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_10_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_39_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_40_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_41_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_43_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_42_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_44_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_14_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_17_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_19_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_21_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_23_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_25_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_27_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_29_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_35_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_32_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_58_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_47_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_59_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_49_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_55_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_54_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_65_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_66_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_12_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPrejob_1 begin ] start
				 */

				ok_Hash.put("tPrejob_1", false);
				start_Hash.put("tPrejob_1", System.currentTimeMillis());

				currentComponent = "tPrejob_1";

				int tos_count_tPrejob_1 = 0;

				/**
				 * [tPrejob_1 begin ] stop
				 */

				/**
				 * [tPrejob_1 main ] start
				 */

				currentComponent = "tPrejob_1";

				tos_count_tPrejob_1++;

				/**
				 * [tPrejob_1 main ] stop
				 */

				/**
				 * [tPrejob_1 end ] start
				 */

				currentComponent = "tPrejob_1";

				ok_Hash.put("tPrejob_1", true);
				end_Hash.put("tPrejob_1", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tPrejob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPrejob_1 finally ] start
				 */

				currentComponent = "tPrejob_1";

				/**
				 * [tPrejob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "engine";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				tJDBCConnection_2Process(globalMap);

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_2 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_2 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_2 = decryptedPassword_tJDBCConnection_2;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "sample_ovirt_engine_history";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_2, dbUser_tJDBCConnection_2,
						dbPwd_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// dbUser_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// dbPwd_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */

				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */

				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public static class insert_new_usersStruct implements
			routines.system.IPersistableRow<insert_new_usersStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String first_name;

		public String getFirst_name() {
			return this.first_name;
		}

		public String last_name;

		public String getLast_name() {
			return this.last_name;
		}

		public String domain;

		public String getDomain() {
			return this.domain;
		}

		public String username;

		public String getUsername() {
			return this.username;
		}

		public String department;

		public String getDepartment() {
			return this.department;
		}

		public String user_role_title;

		public String getUser_role_title() {
			return this.user_role_title;
		}

		public String email;

		public String getEmail() {
			return this.email;
		}

		public String external_id;

		public String getExternal_id() {
			return this.external_id;
		}

		public Boolean active;

		public Boolean getActive() {
			return this.active;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.user_id == null) ? 0 : this.user_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final insert_new_usersStruct other = (insert_new_usersStruct) obj;

			if (this.user_id == null) {
				if (other.user_id != null)
					return false;

			} else if (!this.user_id.equals(other.user_id))

				return false;

			return true;
		}

		public void copyDataTo(insert_new_usersStruct other) {

			other.user_id = this.user_id;
			other.first_name = this.first_name;
			other.last_name = this.last_name;
			other.domain = this.domain;
			other.username = this.username;
			other.department = this.department;
			other.user_role_title = this.user_role_title;
			other.email = this.email;
			other.external_id = this.external_id;
			other.active = this.active;
			other.create_date = this.create_date;
			other.update_date = this.update_date;

		}

		public void copyKeysDataTo(insert_new_usersStruct other) {

			other.user_id = this.user_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.user_id = (Object) dis.readObject();

					this.first_name = readString(dis);

					this.last_name = readString(dis);

					this.domain = readString(dis);

					this.username = readString(dis);

					this.department = readString(dis);

					this.user_role_title = readString(dis);

					this.email = readString(dis);

					this.external_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.active = null;
					} else {
						this.active = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.first_name, dos);

				// String

				writeString(this.last_name, dos);

				// String

				writeString(this.domain, dos);

				// String

				writeString(this.username, dos);

				// String

				writeString(this.department, dos);

				// String

				writeString(this.user_role_title, dos);

				// String

				writeString(this.email, dos);

				// String

				writeString(this.external_id, dos);

				// Boolean

				if (this.active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.active);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("user_id=" + String.valueOf(user_id));
			sb.append(",first_name=" + first_name);
			sb.append(",last_name=" + last_name);
			sb.append(",domain=" + domain);
			sb.append(",username=" + username);
			sb.append(",department=" + department);
			sb.append(",user_role_title=" + user_role_title);
			sb.append(",email=" + email);
			sb.append(",external_id=" + external_id);
			sb.append(",active=" + String.valueOf(active));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(insert_new_usersStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.user_id, other.user_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row55Struct implements
			routines.system.IPersistableRow<row55Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String first_name;

		public String getFirst_name() {
			return this.first_name;
		}

		public String last_name;

		public String getLast_name() {
			return this.last_name;
		}

		public String domain;

		public String getDomain() {
			return this.domain;
		}

		public String username;

		public String getUsername() {
			return this.username;
		}

		public String department;

		public String getDepartment() {
			return this.department;
		}

		public String user_role_title;

		public String getUser_role_title() {
			return this.user_role_title;
		}

		public String email;

		public String getEmail() {
			return this.email;
		}

		public String external_id;

		public String getExternal_id() {
			return this.external_id;
		}

		public Boolean active;

		public Boolean getActive() {
			return this.active;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.user_id = (Object) dis.readObject();

					this.first_name = readString(dis);

					this.last_name = readString(dis);

					this.domain = readString(dis);

					this.username = readString(dis);

					this.department = readString(dis);

					this.user_role_title = readString(dis);

					this.email = readString(dis);

					this.external_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.active = null;
					} else {
						this.active = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.first_name, dos);

				// String

				writeString(this.last_name, dos);

				// String

				writeString(this.domain, dos);

				// String

				writeString(this.username, dos);

				// String

				writeString(this.department, dos);

				// String

				writeString(this.user_role_title, dos);

				// String

				writeString(this.email, dos);

				// String

				writeString(this.external_id, dos);

				// Boolean

				if (this.active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.active);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("user_id=" + String.valueOf(user_id));
			sb.append(",first_name=" + first_name);
			sb.append(",last_name=" + last_name);
			sb.append(",domain=" + domain);
			sb.append(",username=" + username);
			sb.append(",department=" + department);
			sb.append(",user_role_title=" + user_role_title);
			sb.append(",email=" + email);
			sb.append(",external_id=" + external_id);
			sb.append(",active=" + String.valueOf(active));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row55Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_9Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row55Struct row55 = new row55Struct();
				insert_new_usersStruct insert_new_users = new insert_new_usersStruct();

				/**
				 * [tJDBCOutput_9 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_9", false);
				start_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_9";

				int tos_count_tJDBCOutput_9 = 0;

				int updateKeyCount_tJDBCOutput_9 = 1;
				if (updateKeyCount_tJDBCOutput_9 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_9 = 0;
				int nb_line_update_tJDBCOutput_9 = 0;
				int nb_line_inserted_tJDBCOutput_9 = 0;
				int nb_line_deleted_tJDBCOutput_9 = 0;
				int nb_line_rejected_tJDBCOutput_9 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_9 = 0;

				int deletedCount_tJDBCOutput_9 = 0;
				int updatedCount_tJDBCOutput_9 = 0;
				int insertedCount_tJDBCOutput_9 = 0;
				int rejectedCount_tJDBCOutput_9 = 0;

				boolean whetherReject_tJDBCOutput_9 = false;

				java.sql.Connection connection_tJDBCOutput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.PreparedStatement pstmt_tJDBCOutput_9 = connection_tJDBCOutput_9
						.prepareStatement("SELECT COUNT(1) FROM "
								+ "users_details_history"
								+ " WHERE user_id = ?");
				String insert_tJDBCOutput_9 = "INSERT INTO "
						+ "users_details_history"
						+ " (user_id,first_name,last_name,domain,username,department,user_role_title,email,external_id,active,create_date,update_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmtInsert_tJDBCOutput_9 = connection_tJDBCOutput_9
						.prepareStatement(insert_tJDBCOutput_9);
				String update_tJDBCOutput_9 = "UPDATE "
						+ "users_details_history"
						+ " SET first_name = ?,last_name = ?,domain = ?,username = ?,department = ?,user_role_title = ?,email = ?,external_id = ?,active = ?,create_date = ?,update_date = ? WHERE user_id = ?";
				java.sql.PreparedStatement pstmtUpdate_tJDBCOutput_9 = connection_tJDBCOutput_9
						.prepareStatement(update_tJDBCOutput_9);

				/**
				 * [tJDBCOutput_9 begin ] stop
				 */

				/**
				 * [tMap_9 begin ] start
				 */

				ok_Hash.put("tMap_9", false);
				start_Hash.put("tMap_9", System.currentTimeMillis());

				currentComponent = "tMap_9";

				int tos_count_tMap_9 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_9__Struct {
				}
				Var__tMap_9__Struct Var__tMap_9 = new Var__tMap_9__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				insert_new_usersStruct insert_new_users_tmp = new insert_new_usersStruct();
				// ###############################

				/**
				 * [tMap_9 begin ] stop
				 */

				/**
				 * [tJDBCInput_9 begin ] start
				 */

				ok_Hash.put("tJDBCInput_9", false);
				start_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				currentComponent = "tJDBCInput_9";

				int tos_count_tJDBCInput_9 = 0;

				int nb_line_tJDBCInput_9 = 0;
				java.sql.Connection conn_tJDBCInput_9 = null;
				conn_tJDBCInput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_9 = conn_tJDBCInput_9
						.createStatement();

				String dbquery_tJDBCInput_9 = "SELECT\n    user_id,\n    first_name,\n    last_name,\n    domain,\n    username,\n    department,\n    user_role_title,\n    email,\n    external_id,\n    active,\n    create_date,\n    update_date\nFROM dwh_users_history_view";

				globalMap.put("tJDBCInput_9_QUERY", dbquery_tJDBCInput_9);

				java.sql.ResultSet rs_tJDBCInput_9 = null;
				try {
					rs_tJDBCInput_9 = stmt_tJDBCInput_9
							.executeQuery(dbquery_tJDBCInput_9);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_9 = rs_tJDBCInput_9
							.getMetaData();
					int colQtyInRs_tJDBCInput_9 = rsmd_tJDBCInput_9
							.getColumnCount();

					String tmpContent_tJDBCInput_9 = null;

					while (rs_tJDBCInput_9.next()) {
						nb_line_tJDBCInput_9++;

						if (colQtyInRs_tJDBCInput_9 < 1) {
							row55.user_id = null;
						} else {

							if (rs_tJDBCInput_9.getObject(1) != null) {
								row55.user_id = rs_tJDBCInput_9.getObject(1);
							} else {
								row55.user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_9 < 2) {
							row55.first_name = null;
						} else {

							row55.first_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 2, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 3) {
							row55.last_name = null;
						} else {

							row55.last_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 3, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 4) {
							row55.domain = null;
						} else {

							row55.domain = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_9, 4, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 5) {
							row55.username = null;
						} else {

							row55.username = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 5, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 6) {
							row55.department = null;
						} else {

							row55.department = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 6, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 7) {
							row55.user_role_title = null;
						} else {

							row55.user_role_title = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 7, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 8) {
							row55.email = null;
						} else {

							row55.email = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_9, 8, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 9) {
							row55.external_id = null;
						} else {

							row55.external_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_9, 9, false);
						}
						if (colQtyInRs_tJDBCInput_9 < 10) {
							row55.active = null;
						} else {

							if (rs_tJDBCInput_9.getObject(10) != null) {
								row55.active = rs_tJDBCInput_9.getBoolean(10);
							} else {
								row55.active = null;
							}
						}
						if (colQtyInRs_tJDBCInput_9 < 11) {
							row55.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_9 = null;
							try {
								date_tJDBCInput_9 = rs_tJDBCInput_9
										.getTimestamp(11);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_9 = rs_tJDBCInput_9.getDate(11);
							}
							row55.create_date = date_tJDBCInput_9;
						}
						if (colQtyInRs_tJDBCInput_9 < 12) {
							row55.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_9 = null;
							try {
								date_tJDBCInput_9 = rs_tJDBCInput_9
										.getTimestamp(12);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_9 = rs_tJDBCInput_9.getDate(12);
							}
							row55.update_date = date_tJDBCInput_9;
						}

						/**
						 * [tJDBCInput_9 begin ] stop
						 */

						/**
						 * [tJDBCInput_9 main ] start
						 */

						currentComponent = "tJDBCInput_9";

						tos_count_tJDBCInput_9++;

						/**
						 * [tJDBCInput_9 main ] stop
						 */

						/**
						 * [tMap_9 main ] start
						 */

						currentComponent = "tMap_9";

						boolean hasCasePrimitiveKeyWithNull_tMap_9 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_9 = false;
						boolean mainRowRejected_tMap_9 = false;

						if (

						(

						row55.update_date == null ? TalendDate.compareDate(
								row55.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row55.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row55'
							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_9__Struct Var = Var__tMap_9;// ###############################
								// ###############################
								// # Output tables

								insert_new_users = null;

								// # Output table : 'insert_new_users'
								insert_new_users_tmp.user_id = row55.user_id;
								insert_new_users_tmp.first_name = row55.first_name;
								insert_new_users_tmp.last_name = row55.last_name;
								insert_new_users_tmp.domain = row55.domain;
								insert_new_users_tmp.username = row55.username;
								insert_new_users_tmp.department = row55.department;
								insert_new_users_tmp.user_role_title = row55.user_role_title;
								insert_new_users_tmp.email = row55.email;
								insert_new_users_tmp.external_id = row55.external_id;
								insert_new_users_tmp.active = row55.active;
								insert_new_users_tmp.create_date = row55.create_date;
								insert_new_users_tmp.update_date = row55.update_date;
								insert_new_users = insert_new_users_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_9 = false;

							tos_count_tMap_9++;

							/**
							 * [tMap_9 main ] stop
							 */
							// Start of branch "insert_new_users"
							if (insert_new_users != null) {

								/**
								 * [tJDBCOutput_9 main ] start
								 */

								currentComponent = "tJDBCOutput_9";

								whetherReject_tJDBCOutput_9 = false;
								if (insert_new_users.user_id == null) {
									pstmt_tJDBCOutput_9.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_9.setObject(1,
											insert_new_users.user_id);
								}

								java.sql.ResultSet rs_tJDBCOutput_9 = pstmt_tJDBCOutput_9
										.executeQuery();
								int checkCount_tJDBCOutput_9 = -1;
								while (rs_tJDBCOutput_9.next()) {
									checkCount_tJDBCOutput_9 = rs_tJDBCOutput_9
											.getInt(1);
								}
								if (checkCount_tJDBCOutput_9 > 0) {
									if (insert_new_users.first_name == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(1,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(1,
												insert_new_users.first_name);
									}

									if (insert_new_users.last_name == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(2,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(2,
												insert_new_users.last_name);
									}

									if (insert_new_users.domain == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(3,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(3,
												insert_new_users.domain);
									}

									if (insert_new_users.username == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(4,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(4,
												insert_new_users.username);
									}

									if (insert_new_users.department == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(5,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(5,
												insert_new_users.department);
									}

									if (insert_new_users.user_role_title == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(6,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9
												.setString(
														6,
														insert_new_users.user_role_title);
									}

									if (insert_new_users.email == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(7,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(7,
												insert_new_users.email);
									}

									if (insert_new_users.external_id == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(8,
												java.sql.Types.VARCHAR);
									} else {
										pstmtUpdate_tJDBCOutput_9.setString(8,
												insert_new_users.external_id);
									}

									if (insert_new_users.active == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(9,
												java.sql.Types.BOOLEAN);
									} else {
										pstmtUpdate_tJDBCOutput_9.setBoolean(9,
												insert_new_users.active);
									}

									if (insert_new_users.create_date != null) {
										pstmtUpdate_tJDBCOutput_9
												.setTimestamp(
														10,
														new java.sql.Timestamp(
																insert_new_users.create_date
																		.getTime()));
									} else {
										pstmtUpdate_tJDBCOutput_9.setNull(10,
												java.sql.Types.DATE);
									}

									if (insert_new_users.update_date != null) {
										pstmtUpdate_tJDBCOutput_9
												.setTimestamp(
														11,
														new java.sql.Timestamp(
																insert_new_users.update_date
																		.getTime()));
									} else {
										pstmtUpdate_tJDBCOutput_9.setNull(11,
												java.sql.Types.DATE);
									}

									if (insert_new_users.user_id == null) {
										pstmtUpdate_tJDBCOutput_9.setNull(12,
												java.sql.Types.OTHER);
									} else {
										pstmtUpdate_tJDBCOutput_9.setObject(12,
												insert_new_users.user_id);
									}

									try {
										updatedCount_tJDBCOutput_9 = updatedCount_tJDBCOutput_9
												+ pstmtUpdate_tJDBCOutput_9
														.executeUpdate();
										nb_line_tJDBCOutput_9++;
									} catch (java.lang.Exception e) {
										whetherReject_tJDBCOutput_9 = true;
										throw (e);
									}
								} else {
									if (insert_new_users.user_id == null) {
										pstmtInsert_tJDBCOutput_9.setNull(1,
												java.sql.Types.OTHER);
									} else {
										pstmtInsert_tJDBCOutput_9.setObject(1,
												insert_new_users.user_id);
									}

									if (insert_new_users.first_name == null) {
										pstmtInsert_tJDBCOutput_9.setNull(2,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(2,
												insert_new_users.first_name);
									}

									if (insert_new_users.last_name == null) {
										pstmtInsert_tJDBCOutput_9.setNull(3,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(3,
												insert_new_users.last_name);
									}

									if (insert_new_users.domain == null) {
										pstmtInsert_tJDBCOutput_9.setNull(4,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(4,
												insert_new_users.domain);
									}

									if (insert_new_users.username == null) {
										pstmtInsert_tJDBCOutput_9.setNull(5,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(5,
												insert_new_users.username);
									}

									if (insert_new_users.department == null) {
										pstmtInsert_tJDBCOutput_9.setNull(6,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(6,
												insert_new_users.department);
									}

									if (insert_new_users.user_role_title == null) {
										pstmtInsert_tJDBCOutput_9.setNull(7,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9
												.setString(
														7,
														insert_new_users.user_role_title);
									}

									if (insert_new_users.email == null) {
										pstmtInsert_tJDBCOutput_9.setNull(8,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(8,
												insert_new_users.email);
									}

									if (insert_new_users.external_id == null) {
										pstmtInsert_tJDBCOutput_9.setNull(9,
												java.sql.Types.VARCHAR);
									} else {
										pstmtInsert_tJDBCOutput_9.setString(9,
												insert_new_users.external_id);
									}

									if (insert_new_users.active == null) {
										pstmtInsert_tJDBCOutput_9.setNull(10,
												java.sql.Types.BOOLEAN);
									} else {
										pstmtInsert_tJDBCOutput_9.setBoolean(
												10, insert_new_users.active);
									}

									if (insert_new_users.create_date != null) {
										pstmtInsert_tJDBCOutput_9
												.setTimestamp(
														11,
														new java.sql.Timestamp(
																insert_new_users.create_date
																		.getTime()));
									} else {
										pstmtInsert_tJDBCOutput_9.setNull(11,
												java.sql.Types.DATE);
									}

									if (insert_new_users.update_date != null) {
										pstmtInsert_tJDBCOutput_9
												.setTimestamp(
														12,
														new java.sql.Timestamp(
																insert_new_users.update_date
																		.getTime()));
									} else {
										pstmtInsert_tJDBCOutput_9.setNull(12,
												java.sql.Types.DATE);
									}

									try {
										insertedCount_tJDBCOutput_9 = insertedCount_tJDBCOutput_9
												+ pstmtInsert_tJDBCOutput_9
														.executeUpdate();
										nb_line_tJDBCOutput_9++;
									} catch (java.lang.Exception e) {
										whetherReject_tJDBCOutput_9 = true;
										throw (e);
									}
								}

								tos_count_tJDBCOutput_9++;

								/**
								 * [tJDBCOutput_9 main ] stop
								 */

							} // End of branch "insert_new_users"

						} // G_TM_M_280 close main tMap filter for table 'row55'

						/**
						 * [tJDBCInput_9 end ] start
						 */

						currentComponent = "tJDBCInput_9";

					}
				} finally {
					if (rs_tJDBCInput_9 != null) {
						rs_tJDBCInput_9.close();
					}
					stmt_tJDBCInput_9.close();

				}
				globalMap.put("tJDBCInput_9_NB_LINE", nb_line_tJDBCInput_9);

				ok_Hash.put("tJDBCInput_9", true);
				end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				/**
				 * [tJDBCInput_9 end ] stop
				 */

				/**
				 * [tMap_9 end ] start
				 */

				currentComponent = "tMap_9";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_9", true);
				end_Hash.put("tMap_9", System.currentTimeMillis());

				/**
				 * [tMap_9 end ] stop
				 */

				/**
				 * [tJDBCOutput_9 end ] start
				 */

				currentComponent = "tJDBCOutput_9";

				if (pstmtUpdate_tJDBCOutput_9 != null) {

					pstmtUpdate_tJDBCOutput_9.close();

				}
				if (pstmtInsert_tJDBCOutput_9 != null) {

					pstmtInsert_tJDBCOutput_9.close();

				}
				if (pstmt_tJDBCOutput_9 != null) {

					pstmt_tJDBCOutput_9.close();

				}

				nb_line_deleted_tJDBCOutput_9 = nb_line_deleted_tJDBCOutput_9
						+ deletedCount_tJDBCOutput_9;
				nb_line_update_tJDBCOutput_9 = nb_line_update_tJDBCOutput_9
						+ updatedCount_tJDBCOutput_9;
				nb_line_inserted_tJDBCOutput_9 = nb_line_inserted_tJDBCOutput_9
						+ insertedCount_tJDBCOutput_9;
				nb_line_rejected_tJDBCOutput_9 = nb_line_rejected_tJDBCOutput_9
						+ rejectedCount_tJDBCOutput_9;

				globalMap.put("tJDBCOutput_9_NB_LINE", nb_line_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_9);

				ok_Hash.put("tJDBCOutput_9", true);
				end_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_9 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_9:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_11Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_9 finally ] start
				 */

				currentComponent = "tJDBCInput_9";

				/**
				 * [tJDBCInput_9 finally ] stop
				 */

				/**
				 * [tMap_9 finally ] start
				 */

				currentComponent = "tMap_9";

				/**
				 * [tMap_9 finally ] stop
				 */

				/**
				 * [tJDBCOutput_9 finally ] start
				 */

				currentComponent = "tJDBCOutput_9";

				/**
				 * [tJDBCOutput_9 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 1);
	}

	public static class delete_usersStruct implements
			routines.system.IPersistableRow<delete_usersStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String first_name;

		public String getFirst_name() {
			return this.first_name;
		}

		public String last_name;

		public String getLast_name() {
			return this.last_name;
		}

		public String domain;

		public String getDomain() {
			return this.domain;
		}

		public String username;

		public String getUsername() {
			return this.username;
		}

		public String department;

		public String getDepartment() {
			return this.department;
		}

		public String user_role_title;

		public String getUser_role_title() {
			return this.user_role_title;
		}

		public String email;

		public String getEmail() {
			return this.email;
		}

		public String external_id;

		public String getExternal_id() {
			return this.external_id;
		}

		public Boolean active;

		public Boolean getActive() {
			return this.active;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.user_id == null) ? 0 : this.user_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final delete_usersStruct other = (delete_usersStruct) obj;

			if (this.user_id == null) {
				if (other.user_id != null)
					return false;

			} else if (!this.user_id.equals(other.user_id))

				return false;

			return true;
		}

		public void copyDataTo(delete_usersStruct other) {

			other.user_id = this.user_id;
			other.first_name = this.first_name;
			other.last_name = this.last_name;
			other.domain = this.domain;
			other.username = this.username;
			other.department = this.department;
			other.user_role_title = this.user_role_title;
			other.email = this.email;
			other.external_id = this.external_id;
			other.active = this.active;
			other.create_date = this.create_date;
			other.update_date = this.update_date;
			other.delete_date = this.delete_date;

		}

		public void copyKeysDataTo(delete_usersStruct other) {

			other.user_id = this.user_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.user_id = (Object) dis.readObject();

					this.first_name = readString(dis);

					this.last_name = readString(dis);

					this.domain = readString(dis);

					this.username = readString(dis);

					this.department = readString(dis);

					this.user_role_title = readString(dis);

					this.email = readString(dis);

					this.external_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.active = null;
					} else {
						this.active = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.first_name, dos);

				// String

				writeString(this.last_name, dos);

				// String

				writeString(this.domain, dos);

				// String

				writeString(this.username, dos);

				// String

				writeString(this.department, dos);

				// String

				writeString(this.user_role_title, dos);

				// String

				writeString(this.email, dos);

				// String

				writeString(this.external_id, dos);

				// Boolean

				if (this.active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.active);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("user_id=" + String.valueOf(user_id));
			sb.append(",first_name=" + first_name);
			sb.append(",last_name=" + last_name);
			sb.append(",domain=" + domain);
			sb.append(",username=" + username);
			sb.append(",department=" + department);
			sb.append(",user_role_title=" + user_role_title);
			sb.append(",email=" + email);
			sb.append(",external_id=" + external_id);
			sb.append(",active=" + String.valueOf(active));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_usersStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.user_id, other.user_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row57Struct implements
			routines.system.IPersistableRow<row57Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_join_id;

		public String getUser_join_id() {
			return this.user_join_id;
		}

		public String first_name;

		public String getFirst_name() {
			return this.first_name;
		}

		public String last_name;

		public String getLast_name() {
			return this.last_name;
		}

		public String domain;

		public String getDomain() {
			return this.domain;
		}

		public String username;

		public String getUsername() {
			return this.username;
		}

		public String department;

		public String getDepartment() {
			return this.department;
		}

		public String user_role_title;

		public String getUser_role_title() {
			return this.user_role_title;
		}

		public String email;

		public String getEmail() {
			return this.email;
		}

		public String external_id;

		public String getExternal_id() {
			return this.external_id;
		}

		public Boolean active;

		public Boolean getActive() {
			return this.active;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.user_id = (Object) dis.readObject();

					this.user_join_id = readString(dis);

					this.first_name = readString(dis);

					this.last_name = readString(dis);

					this.domain = readString(dis);

					this.username = readString(dis);

					this.department = readString(dis);

					this.user_role_title = readString(dis);

					this.email = readString(dis);

					this.external_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.active = null;
					} else {
						this.active = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_join_id, dos);

				// String

				writeString(this.first_name, dos);

				// String

				writeString(this.last_name, dos);

				// String

				writeString(this.domain, dos);

				// String

				writeString(this.username, dos);

				// String

				writeString(this.department, dos);

				// String

				writeString(this.user_role_title, dos);

				// String

				writeString(this.email, dos);

				// String

				writeString(this.external_id, dos);

				// Boolean

				if (this.active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.active);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("user_id=" + String.valueOf(user_id));
			sb.append(",user_join_id=" + user_join_id);
			sb.append(",first_name=" + first_name);
			sb.append(",last_name=" + last_name);
			sb.append(",domain=" + domain);
			sb.append(",username=" + username);
			sb.append(",department=" + department);
			sb.append(",user_role_title=" + user_role_title);
			sb.append(",email=" + email);
			sb.append(",external_id=" + external_id);
			sb.append(",active=" + String.valueOf(active));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row57Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_11Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_11Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object user_id;

		public Object getUser_id() {
			return this.user_id;
		}

		public String user_join_id;

		public String getUser_join_id() {
			return this.user_join_id;
		}

		public String first_name;

		public String getFirst_name() {
			return this.first_name;
		}

		public String last_name;

		public String getLast_name() {
			return this.last_name;
		}

		public String domain;

		public String getDomain() {
			return this.domain;
		}

		public String username;

		public String getUsername() {
			return this.username;
		}

		public String department;

		public String getDepartment() {
			return this.department;
		}

		public String user_role_title;

		public String getUser_role_title() {
			return this.user_role_title;
		}

		public String email;

		public String getEmail() {
			return this.email;
		}

		public String external_id;

		public String getExternal_id() {
			return this.external_id;
		}

		public Boolean active;

		public Boolean getActive() {
			return this.active;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.user_join_id == null) ? 0 : this.user_join_id
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final after_tJDBCInput_11Struct other = (after_tJDBCInput_11Struct) obj;

			if (this.user_join_id == null) {
				if (other.user_join_id != null)
					return false;

			} else if (!this.user_join_id.equals(other.user_join_id))

				return false;

			return true;
		}

		public void copyDataTo(after_tJDBCInput_11Struct other) {

			other.user_id = this.user_id;
			other.user_join_id = this.user_join_id;
			other.first_name = this.first_name;
			other.last_name = this.last_name;
			other.domain = this.domain;
			other.username = this.username;
			other.department = this.department;
			other.user_role_title = this.user_role_title;
			other.email = this.email;
			other.external_id = this.external_id;
			other.active = this.active;
			other.create_date = this.create_date;
			other.update_date = this.update_date;

		}

		public void copyKeysDataTo(after_tJDBCInput_11Struct other) {

			other.user_join_id = this.user_join_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.user_id = (Object) dis.readObject();

					this.user_join_id = readString(dis);

					this.first_name = readString(dis);

					this.last_name = readString(dis);

					this.domain = readString(dis);

					this.username = readString(dis);

					this.department = readString(dis);

					this.user_role_title = readString(dis);

					this.email = readString(dis);

					this.external_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.active = null;
					} else {
						this.active = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.user_id);

				// String

				writeString(this.user_join_id, dos);

				// String

				writeString(this.first_name, dos);

				// String

				writeString(this.last_name, dos);

				// String

				writeString(this.domain, dos);

				// String

				writeString(this.username, dos);

				// String

				writeString(this.department, dos);

				// String

				writeString(this.user_role_title, dos);

				// String

				writeString(this.email, dos);

				// String

				writeString(this.external_id, dos);

				// Boolean

				if (this.active == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.active);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("user_id=" + String.valueOf(user_id));
			sb.append(",user_join_id=" + user_join_id);
			sb.append(",first_name=" + first_name);
			sb.append(",last_name=" + last_name);
			sb.append(",domain=" + domain);
			sb.append(",username=" + username);
			sb.append(",department=" + department);
			sb.append(",user_role_title=" + user_role_title);
			sb.append(",email=" + email);
			sb.append(",external_id=" + external_id);
			sb.append(",active=" + String.valueOf(active));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_11Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.user_join_id,
					other.user_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_11Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_12Process(globalMap);

				row57Struct row57 = new row57Struct();
				delete_usersStruct delete_users = new delete_usersStruct();

				/**
				 * [tJDBCOutput_10 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_10", false);
				start_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_10";

				int tos_count_tJDBCOutput_10 = 0;

				int updateKeyCount_tJDBCOutput_10 = 1;
				if (updateKeyCount_tJDBCOutput_10 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_10 = 0;
				int nb_line_update_tJDBCOutput_10 = 0;
				int nb_line_inserted_tJDBCOutput_10 = 0;
				int nb_line_deleted_tJDBCOutput_10 = 0;
				int nb_line_rejected_tJDBCOutput_10 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_10 = 0;

				int deletedCount_tJDBCOutput_10 = 0;
				int updatedCount_tJDBCOutput_10 = 0;
				int insertedCount_tJDBCOutput_10 = 0;
				int rejectedCount_tJDBCOutput_10 = 0;

				boolean whetherReject_tJDBCOutput_10 = false;

				java.sql.Connection connection_tJDBCOutput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String update_tJDBCOutput_10 = "UPDATE "
						+ "users_details_history"
						+ " SET first_name = ?,last_name = ?,domain = ?,username = ?,department = ?,user_role_title = ?,email = ?,external_id = ?,active = ?,create_date = ?,update_date = ?,delete_date = ? WHERE user_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_10 = connection_tJDBCOutput_10
						.prepareStatement(update_tJDBCOutput_10);

				/**
				 * [tJDBCOutput_10 begin ] stop
				 */

				/**
				 * [tMap_10 begin ] start
				 */

				ok_Hash.put("tMap_10", false);
				start_Hash.put("tMap_10", System.currentTimeMillis());

				currentComponent = "tMap_10";

				int tos_count_tMap_10 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row58Struct> tHash_Lookup_row58 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row58Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row58Struct>) globalMap
						.get("tHash_Lookup_row58"));

				row58Struct row58HashKey = new row58Struct();
				row58Struct row58Default = new row58Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_10__Struct {
				}
				Var__tMap_10__Struct Var__tMap_10 = new Var__tMap_10__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_usersStruct delete_users_tmp = new delete_usersStruct();
				// ###############################

				/**
				 * [tMap_10 begin ] stop
				 */

				/**
				 * [tJDBCInput_11 begin ] start
				 */

				ok_Hash.put("tJDBCInput_11", false);
				start_Hash.put("tJDBCInput_11", System.currentTimeMillis());

				currentComponent = "tJDBCInput_11";

				int tos_count_tJDBCInput_11 = 0;

				int nb_line_tJDBCInput_11 = 0;
				java.sql.Connection conn_tJDBCInput_11 = null;
				conn_tJDBCInput_11 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_11 = conn_tJDBCInput_11
						.createStatement();

				String dbquery_tJDBCInput_11 = "SELECT\n    user_id,\n    upper(cast(user_id as char(36))) as user_join_id,\n    first_name,\n    last_name,\n    domain,\n    username,\n    department,\n    user_role_title,\n    email,\n    external_id,\n    active,\n    create_date,\n    update_date\nFROM v4_4_latest_users_details";

				globalMap.put("tJDBCInput_11_QUERY", dbquery_tJDBCInput_11);

				java.sql.ResultSet rs_tJDBCInput_11 = null;
				try {
					rs_tJDBCInput_11 = stmt_tJDBCInput_11
							.executeQuery(dbquery_tJDBCInput_11);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_11 = rs_tJDBCInput_11
							.getMetaData();
					int colQtyInRs_tJDBCInput_11 = rsmd_tJDBCInput_11
							.getColumnCount();

					String tmpContent_tJDBCInput_11 = null;

					while (rs_tJDBCInput_11.next()) {
						nb_line_tJDBCInput_11++;

						if (colQtyInRs_tJDBCInput_11 < 1) {
							row57.user_id = null;
						} else {

							if (rs_tJDBCInput_11.getObject(1) != null) {
								row57.user_id = rs_tJDBCInput_11.getObject(1);
							} else {
								row57.user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 2) {
							row57.user_join_id = null;
						} else {

							row57.user_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 2, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 3) {
							row57.first_name = null;
						} else {

							row57.first_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 3, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 4) {
							row57.last_name = null;
						} else {

							row57.last_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 4, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 5) {
							row57.domain = null;
						} else {

							row57.domain = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_11, 5, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 6) {
							row57.username = null;
						} else {

							row57.username = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 6, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 7) {
							row57.department = null;
						} else {

							row57.department = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 7, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 8) {
							row57.user_role_title = null;
						} else {

							row57.user_role_title = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 8, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 9) {
							row57.email = null;
						} else {

							row57.email = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_11, 9, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 10) {
							row57.external_id = null;
						} else {

							row57.external_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_11, 10, false);
						}
						if (colQtyInRs_tJDBCInput_11 < 11) {
							row57.active = null;
						} else {

							if (rs_tJDBCInput_11.getObject(11) != null) {
								row57.active = rs_tJDBCInput_11.getBoolean(11);
							} else {
								row57.active = null;
							}
						}
						if (colQtyInRs_tJDBCInput_11 < 12) {
							row57.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_11 = null;
							try {
								date_tJDBCInput_11 = rs_tJDBCInput_11
										.getTimestamp(12);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_11 = rs_tJDBCInput_11
										.getDate(12);
							}
							row57.create_date = date_tJDBCInput_11;
						}
						if (colQtyInRs_tJDBCInput_11 < 13) {
							row57.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_11 = null;
							try {
								date_tJDBCInput_11 = rs_tJDBCInput_11
										.getTimestamp(13);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_11 = rs_tJDBCInput_11
										.getDate(13);
							}
							row57.update_date = date_tJDBCInput_11;
						}

						/**
						 * [tJDBCInput_11 begin ] stop
						 */

						/**
						 * [tJDBCInput_11 main ] start
						 */

						currentComponent = "tJDBCInput_11";

						tos_count_tJDBCInput_11++;

						/**
						 * [tJDBCInput_11 main ] stop
						 */

						/**
						 * [tMap_10 main ] start
						 */

						currentComponent = "tMap_10";

						boolean hasCasePrimitiveKeyWithNull_tMap_10 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_10 = false;
						boolean mainRowRejected_tMap_10 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row58"
						// /////////////////////////////////////////////

						boolean forceLooprow58 = false;

						row58Struct row58ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_10) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_10 = false;

							row58HashKey.user_join_id = row57.user_join_id;

							row58HashKey.hashCodeDirty = true;

							tHash_Lookup_row58.lookup(row58HashKey);

							if (!tHash_Lookup_row58.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_10 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row58 != null
								&& tHash_Lookup_row58.getCount(row58HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row58' and it contains more one result from keys :  row58.user_join_id = '"
							// + row58HashKey.user_join_id + "'");
						} // G 071

						row58Struct row58 = null;

						row58Struct fromLookup_row58 = null;
						row58 = row58Default;

						if (tHash_Lookup_row58 != null
								&& tHash_Lookup_row58.hasNext()) { // G 099

							fromLookup_row58 = tHash_Lookup_row58.next();

						} // G 099

						if (fromLookup_row58 != null) {
							row58 = fromLookup_row58;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_10__Struct Var = Var__tMap_10;// ###############################
							// ###############################
							// # Output tables

							delete_users = null;

							if (!rejectedInnerJoin_tMap_10) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_users'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_10) {
								delete_users_tmp.user_id = row57.user_id;
								delete_users_tmp.first_name = row57.first_name;
								delete_users_tmp.last_name = row57.last_name;
								delete_users_tmp.domain = row57.domain;
								delete_users_tmp.username = row57.username;
								delete_users_tmp.department = row57.department;
								delete_users_tmp.user_role_title = row57.user_role_title;
								delete_users_tmp.email = row57.email;
								delete_users_tmp.external_id = row57.external_id;
								delete_users_tmp.active = row57.active;
								delete_users_tmp.create_date = row57.create_date;
								delete_users_tmp.update_date = context.runTime;
								delete_users_tmp.delete_date = context.runTime;
								delete_users = delete_users_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_10 = false;

						tos_count_tMap_10++;

						/**
						 * [tMap_10 main ] stop
						 */
						// Start of branch "delete_users"
						if (delete_users != null) {

							/**
							 * [tJDBCOutput_10 main ] start
							 */

							currentComponent = "tJDBCOutput_10";

							whetherReject_tJDBCOutput_10 = false;
							if (delete_users.first_name == null) {
								pstmt_tJDBCOutput_10.setNull(1,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(1,
										delete_users.first_name);
							}

							if (delete_users.last_name == null) {
								pstmt_tJDBCOutput_10.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(2,
										delete_users.last_name);
							}

							if (delete_users.domain == null) {
								pstmt_tJDBCOutput_10.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(3,
										delete_users.domain);
							}

							if (delete_users.username == null) {
								pstmt_tJDBCOutput_10.setNull(4,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(4,
										delete_users.username);
							}

							if (delete_users.department == null) {
								pstmt_tJDBCOutput_10.setNull(5,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(5,
										delete_users.department);
							}

							if (delete_users.user_role_title == null) {
								pstmt_tJDBCOutput_10.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(6,
										delete_users.user_role_title);
							}

							if (delete_users.email == null) {
								pstmt_tJDBCOutput_10.setNull(7,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(7,
										delete_users.email);
							}

							if (delete_users.external_id == null) {
								pstmt_tJDBCOutput_10.setNull(8,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_10.setString(8,
										delete_users.external_id);
							}

							if (delete_users.active == null) {
								pstmt_tJDBCOutput_10.setNull(9,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_10.setBoolean(9,
										delete_users.active);
							}

							if (delete_users.create_date != null) {
								pstmt_tJDBCOutput_10.setTimestamp(
										10,
										new java.sql.Timestamp(
												delete_users.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_10.setNull(10,
										java.sql.Types.DATE);
							}

							if (delete_users.update_date != null) {
								pstmt_tJDBCOutput_10.setTimestamp(
										11,
										new java.sql.Timestamp(
												delete_users.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_10.setNull(11,
										java.sql.Types.DATE);
							}

							if (delete_users.delete_date != null) {
								pstmt_tJDBCOutput_10.setTimestamp(
										12,
										new java.sql.Timestamp(
												delete_users.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_10.setNull(12,
										java.sql.Types.DATE);
							}

							if (delete_users.user_id == null) {
								pstmt_tJDBCOutput_10.setNull(13,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_10.setObject(13,
										delete_users.user_id);
							}

							try {
								updatedCount_tJDBCOutput_10 = updatedCount_tJDBCOutput_10
										+ pstmt_tJDBCOutput_10.executeUpdate();
								nb_line_tJDBCOutput_10++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_10 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_10++;

							/**
							 * [tJDBCOutput_10 main ] stop
							 */

						} // End of branch "delete_users"

						/**
						 * [tJDBCInput_11 end ] start
						 */

						currentComponent = "tJDBCInput_11";

					}
				} finally {
					if (rs_tJDBCInput_11 != null) {
						rs_tJDBCInput_11.close();
					}
					stmt_tJDBCInput_11.close();

				}
				globalMap.put("tJDBCInput_11_NB_LINE", nb_line_tJDBCInput_11);

				ok_Hash.put("tJDBCInput_11", true);
				end_Hash.put("tJDBCInput_11", System.currentTimeMillis());

				/**
				 * [tJDBCInput_11 end ] stop
				 */

				/**
				 * [tMap_10 end ] start
				 */

				currentComponent = "tMap_10";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row58 != null) {
					tHash_Lookup_row58.endGet();
				}
				globalMap.remove("tHash_Lookup_row58");

				// ###############################

				ok_Hash.put("tMap_10", true);
				end_Hash.put("tMap_10", System.currentTimeMillis());

				/**
				 * [tMap_10 end ] stop
				 */

				/**
				 * [tJDBCOutput_10 end ] start
				 */

				currentComponent = "tJDBCOutput_10";

				if (pstmt_tJDBCOutput_10 != null) {

					pstmt_tJDBCOutput_10.close();

				}

				nb_line_deleted_tJDBCOutput_10 = nb_line_deleted_tJDBCOutput_10
						+ deletedCount_tJDBCOutput_10;
				nb_line_update_tJDBCOutput_10 = nb_line_update_tJDBCOutput_10
						+ updatedCount_tJDBCOutput_10;
				nb_line_inserted_tJDBCOutput_10 = nb_line_inserted_tJDBCOutput_10
						+ insertedCount_tJDBCOutput_10;
				nb_line_rejected_tJDBCOutput_10 = nb_line_rejected_tJDBCOutput_10
						+ rejectedCount_tJDBCOutput_10;

				globalMap.put("tJDBCOutput_10_NB_LINE", nb_line_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_10);

				ok_Hash.put("tJDBCOutput_10", true);
				end_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_10 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_11:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_10"
			globalMap.remove("tHash_Lookup_row58");

			try {

				/**
				 * [tJDBCInput_11 finally ] start
				 */

				currentComponent = "tJDBCInput_11";

				/**
				 * [tJDBCInput_11 finally ] stop
				 */

				/**
				 * [tMap_10 finally ] start
				 */

				currentComponent = "tMap_10";

				/**
				 * [tMap_10 finally ] stop
				 */

				/**
				 * [tJDBCOutput_10 finally ] start
				 */

				currentComponent = "tJDBCOutput_10";

				/**
				 * [tJDBCOutput_10 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", 1);
	}

	public static class datacenter_configurationStruct implements
			routines.system.IPersistableRow<datacenter_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Boolean is_local_storage;

		public Boolean getIs_local_storage() {
			return this.is_local_storage;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_local_storage = null;
					} else {
						this.is_local_storage = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Boolean

				if (this.is_local_storage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_local_storage);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",is_local_storage=" + String.valueOf(is_local_storage));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(datacenter_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Boolean is_local_storage;

		public Boolean getIs_local_storage() {
			return this.is_local_storage;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_local_storage = null;
					} else {
						this.is_local_storage = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Boolean

				if (this.is_local_storage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_local_storage);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",is_local_storage=" + String.valueOf(is_local_storage));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();
				datacenter_configurationStruct datacenter_configuration = new datacenter_configurationStruct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_2 = "INSERT INTO "
						+ "datacenter_configuration"
						+ " (datacenter_id,datacenter_name,datacenter_description,is_local_storage,create_date,update_date) VALUES (?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(insert_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tMap_2 begin ] start
				 */

				ok_Hash.put("tMap_2", false);
				start_Hash.put("tMap_2", System.currentTimeMillis());

				currentComponent = "tMap_2";

				int tos_count_tMap_2 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_2__Struct {
				}
				Var__tMap_2__Struct Var__tMap_2 = new Var__tMap_2__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				datacenter_configurationStruct datacenter_configuration_tmp = new datacenter_configurationStruct();
				// ###############################

				/**
				 * [tMap_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT \n  datacenter_id, \n  datacenter_name, \n  datacenter_description, \n  is_local_storage, \n  create_date, \n  update_date\nFROM dwh_datacenter_configuration_history_view";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);

				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						if (colQtyInRs_tJDBCInput_2 < 1) {
							row3.datacenter_id = null;
						} else {

							if (rs_tJDBCInput_2.getObject(1) != null) {
								row3.datacenter_id = rs_tJDBCInput_2
										.getObject(1);
							} else {
								row3.datacenter_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 2) {
							row3.datacenter_name = null;
						} else {

							row3.datacenter_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 2, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 3) {
							row3.datacenter_description = null;
						} else {

							row3.datacenter_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 3, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 4) {
							row3.is_local_storage = null;
						} else {

							if (rs_tJDBCInput_2.getObject(4) != null) {
								row3.is_local_storage = rs_tJDBCInput_2
										.getBoolean(4);
							} else {
								row3.is_local_storage = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 5) {
							row3.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_2 = null;
							try {
								date_tJDBCInput_2 = rs_tJDBCInput_2
										.getTimestamp(5);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_2 = rs_tJDBCInput_2.getDate(5);
							}
							row3.create_date = date_tJDBCInput_2;
						}
						if (colQtyInRs_tJDBCInput_2 < 6) {
							row3.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_2 = null;
							try {
								date_tJDBCInput_2 = rs_tJDBCInput_2
										.getTimestamp(6);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_2 = rs_tJDBCInput_2.getDate(6);
							}
							row3.update_date = date_tJDBCInput_2;
						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */

						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tMap_2 main ] start
						 */

						currentComponent = "tMap_2";

						boolean hasCasePrimitiveKeyWithNull_tMap_2 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_2 = false;
						boolean mainRowRejected_tMap_2 = false;

						if (

						(

						row3.update_date == null ? TalendDate.compareDate(
								row3.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row3.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row3'
							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_2__Struct Var = Var__tMap_2;// ###############################
								// ###############################
								// # Output tables

								datacenter_configuration = null;

								// # Output table : 'datacenter_configuration'
								datacenter_configuration_tmp.datacenter_id = row3.datacenter_id;
								datacenter_configuration_tmp.datacenter_name = StringHandling
										.TRIM(row3.datacenter_name);
								datacenter_configuration_tmp.datacenter_description = StringHandling
										.TRIM(row3.datacenter_description);
								datacenter_configuration_tmp.is_local_storage = row3.is_local_storage;
								datacenter_configuration_tmp.create_date = row3.create_date;
								datacenter_configuration_tmp.update_date = row3.update_date;
								datacenter_configuration = datacenter_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_2 = false;

							tos_count_tMap_2++;

							/**
							 * [tMap_2 main ] stop
							 */
							// Start of branch "datacenter_configuration"
							if (datacenter_configuration != null) {

								/**
								 * [tJDBCOutput_2 main ] start
								 */

								currentComponent = "tJDBCOutput_2";

								whetherReject_tJDBCOutput_2 = false;
								if (datacenter_configuration.datacenter_id == null) {
									pstmt_tJDBCOutput_2.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_2
											.setObject(
													1,
													datacenter_configuration.datacenter_id);
								}

								if (datacenter_configuration.datacenter_name == null) {
									pstmt_tJDBCOutput_2.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_2
											.setString(
													2,
													datacenter_configuration.datacenter_name);
								}

								if (datacenter_configuration.datacenter_description == null) {
									pstmt_tJDBCOutput_2.setNull(3,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_2
											.setString(
													3,
													datacenter_configuration.datacenter_description);
								}

								if (datacenter_configuration.is_local_storage == null) {
									pstmt_tJDBCOutput_2.setNull(4,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_2
											.setBoolean(
													4,
													datacenter_configuration.is_local_storage);
								}

								if (datacenter_configuration.create_date != null) {
									pstmt_tJDBCOutput_2
											.setTimestamp(
													5,
													new java.sql.Timestamp(
															datacenter_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_2.setNull(5,
											java.sql.Types.DATE);
								}

								if (datacenter_configuration.update_date != null) {
									pstmt_tJDBCOutput_2
											.setTimestamp(
													6,
													new java.sql.Timestamp(
															datacenter_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_2.setNull(6,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_2 = insertedCount_tJDBCOutput_2
											+ pstmt_tJDBCOutput_2
													.executeUpdate();
									nb_line_tJDBCOutput_2++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_2 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_2++;

								/**
								 * [tJDBCOutput_2 main ] stop
								 */

							} // End of branch "datacenter_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row3'

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					if (rs_tJDBCInput_2 != null) {
						rs_tJDBCInput_2.close();
					}
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tMap_2 end ] start
				 */

				currentComponent = "tMap_2";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_2", true);
				end_Hash.put("tMap_2", System.currentTimeMillis());

				/**
				 * [tMap_2 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_15Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tMap_2 finally ] start
				 */

				currentComponent = "tMap_2";

				/**
				 * [tMap_2 finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class delete_datacentersStruct implements
			routines.system.IPersistableRow<delete_datacentersStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Boolean is_local_storage;

		public Boolean getIs_local_storage() {
			return this.is_local_storage;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_local_storage = null;
					} else {
						this.is_local_storage = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Boolean

				if (this.is_local_storage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_local_storage);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",is_local_storage=" + String.valueOf(is_local_storage));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_datacentersStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row14Struct implements
			routines.system.IPersistableRow<row14Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Boolean is_local_storage;

		public Boolean getIs_local_storage() {
			return this.is_local_storage;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_local_storage = null;
					} else {
						this.is_local_storage = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Boolean

				if (this.is_local_storage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_local_storage);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",is_local_storage=" + String.valueOf(is_local_storage));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row14Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_15Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_15Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String datacenter_name;

		public String getDatacenter_name() {
			return this.datacenter_name;
		}

		public String datacenter_description;

		public String getDatacenter_description() {
			return this.datacenter_description;
		}

		public Boolean is_local_storage;

		public Boolean getIs_local_storage() {
			return this.is_local_storage;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.datacenter_name = readString(dis);

					this.datacenter_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_local_storage = null;
					} else {
						this.is_local_storage = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.datacenter_name, dos);

				// String

				writeString(this.datacenter_description, dos);

				// Boolean

				if (this.is_local_storage == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_local_storage);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",datacenter_name=" + datacenter_name);
			sb.append(",datacenter_description=" + datacenter_description);
			sb.append(",is_local_storage=" + String.valueOf(is_local_storage));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_15Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_15Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_14Process(globalMap);

				row14Struct row14 = new row14Struct();
				delete_datacentersStruct delete_datacenters = new delete_datacentersStruct();

				/**
				 * [tJDBCOutput_14 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_14", false);
				start_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_14";

				int tos_count_tJDBCOutput_14 = 0;

				int nb_line_tJDBCOutput_14 = 0;
				int nb_line_update_tJDBCOutput_14 = 0;
				int nb_line_inserted_tJDBCOutput_14 = 0;
				int nb_line_deleted_tJDBCOutput_14 = 0;
				int nb_line_rejected_tJDBCOutput_14 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_14 = 0;

				int deletedCount_tJDBCOutput_14 = 0;
				int updatedCount_tJDBCOutput_14 = 0;
				int insertedCount_tJDBCOutput_14 = 0;
				int rejectedCount_tJDBCOutput_14 = 0;

				boolean whetherReject_tJDBCOutput_14 = false;

				java.sql.Connection connection_tJDBCOutput_14 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_14 = "INSERT INTO "
						+ "datacenter_configuration"
						+ " (datacenter_id,datacenter_name,datacenter_description,is_local_storage,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_14 = connection_tJDBCOutput_14
						.prepareStatement(insert_tJDBCOutput_14);

				/**
				 * [tJDBCOutput_14 begin ] stop
				 */

				/**
				 * [tMap_14 begin ] start
				 */

				ok_Hash.put("tMap_14", false);
				start_Hash.put("tMap_14", System.currentTimeMillis());

				currentComponent = "tMap_14";

				int tos_count_tMap_14 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row15Struct> tHash_Lookup_row15 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row15Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row15Struct>) globalMap
						.get("tHash_Lookup_row15"));

				row15Struct row15HashKey = new row15Struct();
				row15Struct row15Default = new row15Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_14__Struct {
				}
				Var__tMap_14__Struct Var__tMap_14 = new Var__tMap_14__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_datacentersStruct delete_datacenters_tmp = new delete_datacentersStruct();
				// ###############################

				/**
				 * [tMap_14 begin ] stop
				 */

				/**
				 * [tJDBCInput_15 begin ] start
				 */

				ok_Hash.put("tJDBCInput_15", false);
				start_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				currentComponent = "tJDBCInput_15";

				int tos_count_tJDBCInput_15 = 0;

				int nb_line_tJDBCInput_15 = 0;
				java.sql.Connection conn_tJDBCInput_15 = null;
				conn_tJDBCInput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_15 = conn_tJDBCInput_15
						.createStatement();

				String dbquery_tJDBCInput_15 = "SELECT history_id, \n		datacenter_id, \n		upper(cast(datacenter_id as char(36))) as datacenter_join_id,\n		datacenter_name, \n		datacenter_description, \n       	is_local_storage, \n		create_date, \n		update_date\nFROM  v4_4_latest_configuration_datacenters";

				globalMap.put("tJDBCInput_15_QUERY", dbquery_tJDBCInput_15);

				java.sql.ResultSet rs_tJDBCInput_15 = null;
				try {
					rs_tJDBCInput_15 = stmt_tJDBCInput_15
							.executeQuery(dbquery_tJDBCInput_15);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_15 = rs_tJDBCInput_15
							.getMetaData();
					int colQtyInRs_tJDBCInput_15 = rsmd_tJDBCInput_15
							.getColumnCount();

					String tmpContent_tJDBCInput_15 = null;

					while (rs_tJDBCInput_15.next()) {
						nb_line_tJDBCInput_15++;

						if (colQtyInRs_tJDBCInput_15 < 1) {
							row14.history_id = null;
						} else {

							if (rs_tJDBCInput_15.getObject(1) != null) {
								row14.history_id = rs_tJDBCInput_15.getInt(1);
							} else {
								row14.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_15 < 2) {
							row14.datacenter_id = null;
						} else {

							if (rs_tJDBCInput_15.getObject(2) != null) {
								row14.datacenter_id = rs_tJDBCInput_15
										.getObject(2);
							} else {
								row14.datacenter_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_15 < 3) {
							row14.datacenter_join_id = null;
						} else {

							row14.datacenter_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_15, 3, false);
						}
						if (colQtyInRs_tJDBCInput_15 < 4) {
							row14.datacenter_name = null;
						} else {

							row14.datacenter_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_15, 4, false);
						}
						if (colQtyInRs_tJDBCInput_15 < 5) {
							row14.datacenter_description = null;
						} else {

							row14.datacenter_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_15, 5, false);
						}
						if (colQtyInRs_tJDBCInput_15 < 6) {
							row14.is_local_storage = null;
						} else {

							if (rs_tJDBCInput_15.getObject(6) != null) {
								row14.is_local_storage = rs_tJDBCInput_15
										.getBoolean(6);
							} else {
								row14.is_local_storage = null;
							}
						}
						if (colQtyInRs_tJDBCInput_15 < 7) {
							row14.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_15 = null;
							try {
								date_tJDBCInput_15 = rs_tJDBCInput_15
										.getTimestamp(7);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_15 = rs_tJDBCInput_15
										.getDate(7);
							}
							row14.create_date = date_tJDBCInput_15;
						}
						if (colQtyInRs_tJDBCInput_15 < 8) {
							row14.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_15 = null;
							try {
								date_tJDBCInput_15 = rs_tJDBCInput_15
										.getTimestamp(8);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_15 = rs_tJDBCInput_15
										.getDate(8);
							}
							row14.update_date = date_tJDBCInput_15;
						}

						/**
						 * [tJDBCInput_15 begin ] stop
						 */

						/**
						 * [tJDBCInput_15 main ] start
						 */

						currentComponent = "tJDBCInput_15";

						tos_count_tJDBCInput_15++;

						/**
						 * [tJDBCInput_15 main ] stop
						 */

						/**
						 * [tMap_14 main ] start
						 */

						currentComponent = "tMap_14";

						boolean hasCasePrimitiveKeyWithNull_tMap_14 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_14 = false;
						boolean mainRowRejected_tMap_14 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row15"
						// /////////////////////////////////////////////

						boolean forceLooprow15 = false;

						row15Struct row15ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_14) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_14 = false;

							row15HashKey.datacenter_join_id = row14.datacenter_join_id;

							row15HashKey.hashCodeDirty = true;

							tHash_Lookup_row15.lookup(row15HashKey);

							if (!tHash_Lookup_row15.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_14 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row15 != null
								&& tHash_Lookup_row15.getCount(row15HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row15' and it contains more one result from keys :  row15.datacenter_join_id = '"
							// + row15HashKey.datacenter_join_id + "'");
						} // G 071

						row15Struct row15 = null;

						row15Struct fromLookup_row15 = null;
						row15 = row15Default;

						if (tHash_Lookup_row15 != null
								&& tHash_Lookup_row15.hasNext()) { // G 099

							fromLookup_row15 = tHash_Lookup_row15.next();

						} // G 099

						if (fromLookup_row15 != null) {
							row15 = fromLookup_row15;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_14__Struct Var = Var__tMap_14;// ###############################
							// ###############################
							// # Output tables

							delete_datacenters = null;

							if (!rejectedInnerJoin_tMap_14) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_datacenters'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_14) {
								delete_datacenters_tmp.datacenter_id = row14.datacenter_id;
								delete_datacenters_tmp.datacenter_name = row14.datacenter_name;
								delete_datacenters_tmp.datacenter_description = row14.datacenter_description;
								delete_datacenters_tmp.is_local_storage = row14.is_local_storage;
								delete_datacenters_tmp.create_date = row14.create_date;
								delete_datacenters_tmp.update_date = context.runTime;
								delete_datacenters_tmp.delete_date = context.runTime;
								delete_datacenters = delete_datacenters_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_14 = false;

						tos_count_tMap_14++;

						/**
						 * [tMap_14 main ] stop
						 */
						// Start of branch "delete_datacenters"
						if (delete_datacenters != null) {

							/**
							 * [tJDBCOutput_14 main ] start
							 */

							currentComponent = "tJDBCOutput_14";

							whetherReject_tJDBCOutput_14 = false;
							if (delete_datacenters.datacenter_id == null) {
								pstmt_tJDBCOutput_14.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_14.setObject(1,
										delete_datacenters.datacenter_id);
							}

							if (delete_datacenters.datacenter_name == null) {
								pstmt_tJDBCOutput_14.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_14.setString(2,
										delete_datacenters.datacenter_name);
							}

							if (delete_datacenters.datacenter_description == null) {
								pstmt_tJDBCOutput_14.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_14
										.setString(
												3,
												delete_datacenters.datacenter_description);
							}

							if (delete_datacenters.is_local_storage == null) {
								pstmt_tJDBCOutput_14.setNull(4,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_14.setBoolean(4,
										delete_datacenters.is_local_storage);
							}

							if (delete_datacenters.create_date != null) {
								pstmt_tJDBCOutput_14.setTimestamp(
										5,
										new java.sql.Timestamp(
												delete_datacenters.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_14.setNull(5,
										java.sql.Types.DATE);
							}

							if (delete_datacenters.update_date != null) {
								pstmt_tJDBCOutput_14.setTimestamp(
										6,
										new java.sql.Timestamp(
												delete_datacenters.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_14.setNull(6,
										java.sql.Types.DATE);
							}

							if (delete_datacenters.delete_date != null) {
								pstmt_tJDBCOutput_14.setTimestamp(
										7,
										new java.sql.Timestamp(
												delete_datacenters.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_14.setNull(7,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_14 = insertedCount_tJDBCOutput_14
										+ pstmt_tJDBCOutput_14.executeUpdate();
								nb_line_tJDBCOutput_14++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_14 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_14++;

							/**
							 * [tJDBCOutput_14 main ] stop
							 */

						} // End of branch "delete_datacenters"

						/**
						 * [tJDBCInput_15 end ] start
						 */

						currentComponent = "tJDBCInput_15";

					}
				} finally {
					if (rs_tJDBCInput_15 != null) {
						rs_tJDBCInput_15.close();
					}
					stmt_tJDBCInput_15.close();

				}
				globalMap.put("tJDBCInput_15_NB_LINE", nb_line_tJDBCInput_15);

				ok_Hash.put("tJDBCInput_15", true);
				end_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				/**
				 * [tJDBCInput_15 end ] stop
				 */

				/**
				 * [tMap_14 end ] start
				 */

				currentComponent = "tMap_14";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row15 != null) {
					tHash_Lookup_row15.endGet();
				}
				globalMap.remove("tHash_Lookup_row15");

				// ###############################

				ok_Hash.put("tMap_14", true);
				end_Hash.put("tMap_14", System.currentTimeMillis());

				/**
				 * [tMap_14 end ] stop
				 */

				/**
				 * [tJDBCOutput_14 end ] start
				 */

				currentComponent = "tJDBCOutput_14";

				if (pstmt_tJDBCOutput_14 != null) {

					pstmt_tJDBCOutput_14.close();

				}

				nb_line_deleted_tJDBCOutput_14 = nb_line_deleted_tJDBCOutput_14
						+ deletedCount_tJDBCOutput_14;
				nb_line_update_tJDBCOutput_14 = nb_line_update_tJDBCOutput_14
						+ updatedCount_tJDBCOutput_14;
				nb_line_inserted_tJDBCOutput_14 = nb_line_inserted_tJDBCOutput_14
						+ insertedCount_tJDBCOutput_14;
				nb_line_rejected_tJDBCOutput_14 = nb_line_rejected_tJDBCOutput_14
						+ rejectedCount_tJDBCOutput_14;

				globalMap.put("tJDBCOutput_14_NB_LINE", nb_line_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_14);

				ok_Hash.put("tJDBCOutput_14", true);
				end_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_14 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_15:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_14"
			globalMap.remove("tHash_Lookup_row15");

			try {

				/**
				 * [tJDBCInput_15 finally ] start
				 */

				currentComponent = "tJDBCInput_15";

				/**
				 * [tJDBCInput_15 finally ] stop
				 */

				/**
				 * [tMap_14 finally ] start
				 */

				currentComponent = "tMap_14";

				/**
				 * [tMap_14 finally ] stop
				 */

				/**
				 * [tJDBCOutput_14 finally ] start
				 */

				currentComponent = "tJDBCOutput_14";

				/**
				 * [tJDBCOutput_14 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 1);
	}

	public static class cluster_configurationStruct implements
			routines.system.IPersistableRow<cluster_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(cluster_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_1Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_39Process(globalMap);

				row1Struct row1 = new row1Struct();
				cluster_configurationStruct cluster_configuration = new cluster_configurationStruct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_1 = "INSERT INTO "
						+ "cluster_configuration"
						+ " (cluster_id,cluster_name,cluster_description,datacenter_id,cpu_name,compatibility_version,datacenter_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(insert_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tMap_1 begin ] start
				 */

				ok_Hash.put("tMap_1", false);
				start_Hash.put("tMap_1", System.currentTimeMillis());

				currentComponent = "tMap_1";

				int tos_count_tMap_1 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row35Struct> tHash_Lookup_row35 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row35Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row35Struct>) globalMap
						.get("tHash_Lookup_row35"));

				row35Struct row35HashKey = new row35Struct();
				row35Struct row35Default = new row35Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_1__Struct {
				}
				Var__tMap_1__Struct Var__tMap_1 = new Var__tMap_1__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				cluster_configurationStruct cluster_configuration_tmp = new cluster_configurationStruct();
				// ###############################

				/**
				 * [tMap_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "SELECT \n  cluster_id, \n  cluster_name, \n  cluster_description, \n  datacenter_id, \n  upper(cast(datacenter_id as char(36))) as datacenter_join_id,\n  cpu_name, \n  compatibility_version, \n  create_date, \n  update_date\nFROM dwh_cluster_configuration_history_view";

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);

				java.sql.ResultSet rs_tJDBCInput_1 = null;
				try {
					rs_tJDBCInput_1 = stmt_tJDBCInput_1
							.executeQuery(dbquery_tJDBCInput_1);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
							.getMetaData();
					int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
							.getColumnCount();

					String tmpContent_tJDBCInput_1 = null;

					while (rs_tJDBCInput_1.next()) {
						nb_line_tJDBCInput_1++;

						if (colQtyInRs_tJDBCInput_1 < 1) {
							row1.cluster_id = null;
						} else {

							if (rs_tJDBCInput_1.getObject(1) != null) {
								row1.cluster_id = rs_tJDBCInput_1.getObject(1);
							} else {
								row1.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 2) {
							row1.cluster_name = null;
						} else {

							row1.cluster_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 2, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 3) {
							row1.cluster_description = null;
						} else {

							row1.cluster_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 3, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 4) {
							row1.datacenter_id = null;
						} else {

							if (rs_tJDBCInput_1.getObject(4) != null) {
								row1.datacenter_id = rs_tJDBCInput_1
										.getObject(4);
							} else {
								row1.datacenter_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 5) {
							row1.datacenter_join_id = null;
						} else {

							row1.datacenter_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 5, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 6) {
							row1.cpu_name = null;
						} else {

							row1.cpu_name = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_1, 6, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 7) {
							row1.compatibility_version = null;
						} else {

							row1.compatibility_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 7, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 8) {
							row1.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_1 = null;
							try {
								date_tJDBCInput_1 = rs_tJDBCInput_1
										.getTimestamp(8);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_1 = rs_tJDBCInput_1.getDate(8);
							}
							row1.create_date = date_tJDBCInput_1;
						}
						if (colQtyInRs_tJDBCInput_1 < 9) {
							row1.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_1 = null;
							try {
								date_tJDBCInput_1 = rs_tJDBCInput_1
										.getTimestamp(9);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_1 = rs_tJDBCInput_1.getDate(9);
							}
							row1.update_date = date_tJDBCInput_1;
						}

						/**
						 * [tJDBCInput_1 begin ] stop
						 */

						/**
						 * [tJDBCInput_1 main ] start
						 */

						currentComponent = "tJDBCInput_1";

						tos_count_tJDBCInput_1++;

						/**
						 * [tJDBCInput_1 main ] stop
						 */

						/**
						 * [tMap_1 main ] start
						 */

						currentComponent = "tMap_1";

						boolean hasCasePrimitiveKeyWithNull_tMap_1 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_1 = false;
						boolean mainRowRejected_tMap_1 = false;

						if (

						(

						row1.update_date == null ? TalendDate.compareDate(
								row1.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row1.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row1'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row35"
							// /////////////////////////////////////////////

							boolean forceLooprow35 = false;

							row35Struct row35ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_1) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_1 = false;

								row35HashKey.datacenter_join_id = row1.datacenter_join_id;

								row35HashKey.hashCodeDirty = true;

								tHash_Lookup_row35.lookup(row35HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row35 != null
									&& tHash_Lookup_row35
											.getCount(row35HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row35' and it contains more one result from keys :  row35.datacenter_join_id = '"
								// + row35HashKey.datacenter_join_id + "'");
							} // G 071

							row35Struct row35 = null;

							row35Struct fromLookup_row35 = null;
							row35 = row35Default;

							if (tHash_Lookup_row35 != null
									&& tHash_Lookup_row35.hasNext()) { // G 099

								fromLookup_row35 = tHash_Lookup_row35.next();

							} // G 099

							if (fromLookup_row35 != null) {
								row35 = fromLookup_row35;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_1__Struct Var = Var__tMap_1;// ###############################
								// ###############################
								// # Output tables

								cluster_configuration = null;

								// # Output table : 'cluster_configuration'
								cluster_configuration_tmp.cluster_id = row1.cluster_id;
								cluster_configuration_tmp.cluster_name = StringHandling
										.TRIM(row1.cluster_name);
								cluster_configuration_tmp.cluster_description = StringHandling
										.TRIM(row1.cluster_description);
								cluster_configuration_tmp.datacenter_id = row1.datacenter_id;
								cluster_configuration_tmp.cpu_name = StringHandling
										.TRIM(row1.cpu_name);
								cluster_configuration_tmp.compatibility_version = StringHandling
										.TRIM(row1.compatibility_version);
								cluster_configuration_tmp.datacenter_configuration_version = row35.history_id;
								cluster_configuration_tmp.create_date = row1.create_date;
								cluster_configuration_tmp.update_date = row1.update_date;
								cluster_configuration_tmp.delete_date = null;
								cluster_configuration = cluster_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_1 = false;

							tos_count_tMap_1++;

							/**
							 * [tMap_1 main ] stop
							 */
							// Start of branch "cluster_configuration"
							if (cluster_configuration != null) {

								/**
								 * [tJDBCOutput_1 main ] start
								 */

								currentComponent = "tJDBCOutput_1";

								whetherReject_tJDBCOutput_1 = false;
								if (cluster_configuration.cluster_id == null) {
									pstmt_tJDBCOutput_1.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_1.setObject(1,
											cluster_configuration.cluster_id);
								}

								if (cluster_configuration.cluster_name == null) {
									pstmt_tJDBCOutput_1.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_1.setString(2,
											cluster_configuration.cluster_name);
								}

								if (cluster_configuration.cluster_description == null) {
									pstmt_tJDBCOutput_1.setNull(3,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_1
											.setString(
													3,
													cluster_configuration.cluster_description);
								}

								if (cluster_configuration.datacenter_id == null) {
									pstmt_tJDBCOutput_1.setNull(4,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_1
											.setObject(
													4,
													cluster_configuration.datacenter_id);
								}

								if (cluster_configuration.cpu_name == null) {
									pstmt_tJDBCOutput_1.setNull(5,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_1.setString(5,
											cluster_configuration.cpu_name);
								}

								if (cluster_configuration.compatibility_version == null) {
									pstmt_tJDBCOutput_1.setNull(6,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_1
											.setString(
													6,
													cluster_configuration.compatibility_version);
								}

								if (cluster_configuration.datacenter_configuration_version == null) {
									pstmt_tJDBCOutput_1.setNull(7,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_1
											.setInt(7,
													cluster_configuration.datacenter_configuration_version);
								}

								if (cluster_configuration.create_date != null) {
									pstmt_tJDBCOutput_1
											.setTimestamp(
													8,
													new java.sql.Timestamp(
															cluster_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_1.setNull(8,
											java.sql.Types.DATE);
								}

								if (cluster_configuration.update_date != null) {
									pstmt_tJDBCOutput_1
											.setTimestamp(
													9,
													new java.sql.Timestamp(
															cluster_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_1.setNull(9,
											java.sql.Types.DATE);
								}

								if (cluster_configuration.delete_date != null) {
									pstmt_tJDBCOutput_1
											.setTimestamp(
													10,
													new java.sql.Timestamp(
															cluster_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_1.setNull(10,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_1 = insertedCount_tJDBCOutput_1
											+ pstmt_tJDBCOutput_1
													.executeUpdate();
									nb_line_tJDBCOutput_1++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_1 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_1++;

								/**
								 * [tJDBCOutput_1 main ] stop
								 */

							} // End of branch "cluster_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row1'

						/**
						 * [tJDBCInput_1 end ] start
						 */

						currentComponent = "tJDBCInput_1";

					}
				} finally {
					if (rs_tJDBCInput_1 != null) {
						rs_tJDBCInput_1.close();
					}
					stmt_tJDBCInput_1.close();

				}
				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tMap_1 end ] start
				 */

				currentComponent = "tMap_1";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row35 != null) {
					tHash_Lookup_row35.endGet();
				}
				globalMap.remove("tHash_Lookup_row35");

				// ###############################

				ok_Hash.put("tMap_1", true);
				end_Hash.put("tMap_1", System.currentTimeMillis());

				/**
				 * [tMap_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_18Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_1"
			globalMap.remove("tHash_Lookup_row35");

			try {

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tMap_1 finally ] start
				 */

				currentComponent = "tMap_1";

				/**
				 * [tMap_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_1 finally ] start
				 */

				currentComponent = "tJDBCOutput_1";

				/**
				 * [tJDBCOutput_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public static class delete_clusterStruct implements
			routines.system.IPersistableRow<delete_clusterStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.cluster_id = (Object) dis.readObject();

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_clusterStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row17Struct implements
			routines.system.IPersistableRow<row17Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row17Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_18Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_18Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public String cluster_name;

		public String getCluster_name() {
			return this.cluster_name;
		}

		public String cluster_description;

		public String getCluster_description() {
			return this.cluster_description;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String cpu_name;

		public String getCpu_name() {
			return this.cpu_name;
		}

		public String compatibility_version;

		public String getCompatibility_version() {
			return this.compatibility_version;
		}

		public Integer datacenter_configuration_version;

		public Integer getDatacenter_configuration_version() {
			return this.datacenter_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.cluster_name = readString(dis);

					this.cluster_description = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.cpu_name = readString(dis);

					this.compatibility_version = readString(dis);

					this.datacenter_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// String

				writeString(this.cluster_name, dos);

				// String

				writeString(this.cluster_description, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.cpu_name, dos);

				// String

				writeString(this.compatibility_version, dos);

				// Integer

				writeInteger(this.datacenter_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",cluster_name=" + cluster_name);
			sb.append(",cluster_description=" + cluster_description);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",cpu_name=" + cpu_name);
			sb.append(",compatibility_version=" + compatibility_version);
			sb.append(",datacenter_configuration_version="
					+ String.valueOf(datacenter_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_18Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_18Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_17Process(globalMap);

				row17Struct row17 = new row17Struct();
				delete_clusterStruct delete_cluster = new delete_clusterStruct();

				/**
				 * [tJDBCOutput_15 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_15", false);
				start_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_15";

				int tos_count_tJDBCOutput_15 = 0;

				int nb_line_tJDBCOutput_15 = 0;
				int nb_line_update_tJDBCOutput_15 = 0;
				int nb_line_inserted_tJDBCOutput_15 = 0;
				int nb_line_deleted_tJDBCOutput_15 = 0;
				int nb_line_rejected_tJDBCOutput_15 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_15 = 0;

				int deletedCount_tJDBCOutput_15 = 0;
				int updatedCount_tJDBCOutput_15 = 0;
				int insertedCount_tJDBCOutput_15 = 0;
				int rejectedCount_tJDBCOutput_15 = 0;

				boolean whetherReject_tJDBCOutput_15 = false;

				java.sql.Connection connection_tJDBCOutput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_15 = "INSERT INTO "
						+ "cluster_configuration"
						+ " (cluster_id,cluster_name,cluster_description,datacenter_id,cpu_name,compatibility_version,datacenter_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_15 = connection_tJDBCOutput_15
						.prepareStatement(insert_tJDBCOutput_15);

				/**
				 * [tJDBCOutput_15 begin ] stop
				 */

				/**
				 * [tMap_15 begin ] start
				 */

				ok_Hash.put("tMap_15", false);
				start_Hash.put("tMap_15", System.currentTimeMillis());

				currentComponent = "tMap_15";

				int tos_count_tMap_15 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row16Struct> tHash_Lookup_row16 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row16Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row16Struct>) globalMap
						.get("tHash_Lookup_row16"));

				row16Struct row16HashKey = new row16Struct();
				row16Struct row16Default = new row16Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_15__Struct {
				}
				Var__tMap_15__Struct Var__tMap_15 = new Var__tMap_15__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_clusterStruct delete_cluster_tmp = new delete_clusterStruct();
				// ###############################

				/**
				 * [tMap_15 begin ] stop
				 */

				/**
				 * [tJDBCInput_18 begin ] start
				 */

				ok_Hash.put("tJDBCInput_18", false);
				start_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				currentComponent = "tJDBCInput_18";

				int tos_count_tJDBCInput_18 = 0;

				int nb_line_tJDBCInput_18 = 0;
				java.sql.Connection conn_tJDBCInput_18 = null;
				conn_tJDBCInput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_18 = conn_tJDBCInput_18
						.createStatement();

				String dbquery_tJDBCInput_18 = "SELECT history_id, \n  		cluster_id, \n  		upper(cast(cluster_id as char(36))) as cluster_join_id,\n  		cluster_name, \n  		cluster_description, \n  		datacenter_id, \n  		cpu_name, \n  		compatibility_version, \n  		datacenter_configuration_version, \n  		create_date, \n  		update_date\nFROM v4_4_latest_configuration_clusters";

				globalMap.put("tJDBCInput_18_QUERY", dbquery_tJDBCInput_18);

				java.sql.ResultSet rs_tJDBCInput_18 = null;
				try {
					rs_tJDBCInput_18 = stmt_tJDBCInput_18
							.executeQuery(dbquery_tJDBCInput_18);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_18 = rs_tJDBCInput_18
							.getMetaData();
					int colQtyInRs_tJDBCInput_18 = rsmd_tJDBCInput_18
							.getColumnCount();

					String tmpContent_tJDBCInput_18 = null;

					while (rs_tJDBCInput_18.next()) {
						nb_line_tJDBCInput_18++;

						if (colQtyInRs_tJDBCInput_18 < 1) {
							row17.history_id = null;
						} else {

							if (rs_tJDBCInput_18.getObject(1) != null) {
								row17.history_id = rs_tJDBCInput_18.getInt(1);
							} else {
								row17.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 2) {
							row17.cluster_id = null;
						} else {

							if (rs_tJDBCInput_18.getObject(2) != null) {
								row17.cluster_id = rs_tJDBCInput_18
										.getObject(2);
							} else {
								row17.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 3) {
							row17.cluster_join_id = null;
						} else {

							row17.cluster_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_18, 3, false);
						}
						if (colQtyInRs_tJDBCInput_18 < 4) {
							row17.cluster_name = null;
						} else {

							row17.cluster_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_18, 4, false);
						}
						if (colQtyInRs_tJDBCInput_18 < 5) {
							row17.cluster_description = null;
						} else {

							row17.cluster_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_18, 5, false);
						}
						if (colQtyInRs_tJDBCInput_18 < 6) {
							row17.datacenter_id = null;
						} else {

							if (rs_tJDBCInput_18.getObject(6) != null) {
								row17.datacenter_id = rs_tJDBCInput_18
										.getObject(6);
							} else {
								row17.datacenter_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 7) {
							row17.cpu_name = null;
						} else {

							row17.cpu_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_18, 7, false);
						}
						if (colQtyInRs_tJDBCInput_18 < 8) {
							row17.compatibility_version = null;
						} else {

							row17.compatibility_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_18, 8, false);
						}
						if (colQtyInRs_tJDBCInput_18 < 9) {
							row17.datacenter_configuration_version = null;
						} else {

							if (rs_tJDBCInput_18.getObject(9) != null) {
								row17.datacenter_configuration_version = rs_tJDBCInput_18
										.getInt(9);
							} else {
								row17.datacenter_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_18 < 10) {
							row17.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_18 = null;
							try {
								date_tJDBCInput_18 = rs_tJDBCInput_18
										.getTimestamp(10);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_18 = rs_tJDBCInput_18
										.getDate(10);
							}
							row17.create_date = date_tJDBCInput_18;
						}
						if (colQtyInRs_tJDBCInput_18 < 11) {
							row17.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_18 = null;
							try {
								date_tJDBCInput_18 = rs_tJDBCInput_18
										.getTimestamp(11);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_18 = rs_tJDBCInput_18
										.getDate(11);
							}
							row17.update_date = date_tJDBCInput_18;
						}

						/**
						 * [tJDBCInput_18 begin ] stop
						 */

						/**
						 * [tJDBCInput_18 main ] start
						 */

						currentComponent = "tJDBCInput_18";

						tos_count_tJDBCInput_18++;

						/**
						 * [tJDBCInput_18 main ] stop
						 */

						/**
						 * [tMap_15 main ] start
						 */

						currentComponent = "tMap_15";

						boolean hasCasePrimitiveKeyWithNull_tMap_15 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_15 = false;
						boolean mainRowRejected_tMap_15 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row16"
						// /////////////////////////////////////////////

						boolean forceLooprow16 = false;

						row16Struct row16ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_15) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_15 = false;

							row16HashKey.cluster_join_id = row17.cluster_join_id;

							row16HashKey.hashCodeDirty = true;

							tHash_Lookup_row16.lookup(row16HashKey);

							if (!tHash_Lookup_row16.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_15 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row16 != null
								&& tHash_Lookup_row16.getCount(row16HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row16' and it contains more one result from keys :  row16.cluster_join_id = '"
							// + row16HashKey.cluster_join_id + "'");
						} // G 071

						row16Struct row16 = null;

						row16Struct fromLookup_row16 = null;
						row16 = row16Default;

						if (tHash_Lookup_row16 != null
								&& tHash_Lookup_row16.hasNext()) { // G 099

							fromLookup_row16 = tHash_Lookup_row16.next();

						} // G 099

						if (fromLookup_row16 != null) {
							row16 = fromLookup_row16;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_15__Struct Var = Var__tMap_15;// ###############################
							// ###############################
							// # Output tables

							delete_cluster = null;

							if (!rejectedInnerJoin_tMap_15) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_cluster'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_15) {
								delete_cluster_tmp.cluster_id = row17.cluster_id;
								delete_cluster_tmp.cluster_name = row17.cluster_name;
								delete_cluster_tmp.cluster_description = row17.cluster_description;
								delete_cluster_tmp.datacenter_id = row17.datacenter_id;
								delete_cluster_tmp.cpu_name = row17.cpu_name;
								delete_cluster_tmp.compatibility_version = row17.compatibility_version;
								delete_cluster_tmp.datacenter_configuration_version = row17.datacenter_configuration_version;
								delete_cluster_tmp.create_date = row17.create_date;
								delete_cluster_tmp.update_date = context.runTime;
								delete_cluster_tmp.delete_date = context.runTime;
								delete_cluster = delete_cluster_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_15 = false;

						tos_count_tMap_15++;

						/**
						 * [tMap_15 main ] stop
						 */
						// Start of branch "delete_cluster"
						if (delete_cluster != null) {

							/**
							 * [tJDBCOutput_15 main ] start
							 */

							currentComponent = "tJDBCOutput_15";

							whetherReject_tJDBCOutput_15 = false;
							if (delete_cluster.cluster_id == null) {
								pstmt_tJDBCOutput_15.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_15.setObject(1,
										delete_cluster.cluster_id);
							}

							if (delete_cluster.cluster_name == null) {
								pstmt_tJDBCOutput_15.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_15.setString(2,
										delete_cluster.cluster_name);
							}

							if (delete_cluster.cluster_description == null) {
								pstmt_tJDBCOutput_15.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_15.setString(3,
										delete_cluster.cluster_description);
							}

							if (delete_cluster.datacenter_id == null) {
								pstmt_tJDBCOutput_15.setNull(4,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_15.setObject(4,
										delete_cluster.datacenter_id);
							}

							if (delete_cluster.cpu_name == null) {
								pstmt_tJDBCOutput_15.setNull(5,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_15.setString(5,
										delete_cluster.cpu_name);
							}

							if (delete_cluster.compatibility_version == null) {
								pstmt_tJDBCOutput_15.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_15.setString(6,
										delete_cluster.compatibility_version);
							}

							if (delete_cluster.datacenter_configuration_version == null) {
								pstmt_tJDBCOutput_15.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_15
										.setInt(7,
												delete_cluster.datacenter_configuration_version);
							}

							if (delete_cluster.create_date != null) {
								pstmt_tJDBCOutput_15.setTimestamp(
										8,
										new java.sql.Timestamp(
												delete_cluster.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_15.setNull(8,
										java.sql.Types.DATE);
							}

							if (delete_cluster.update_date != null) {
								pstmt_tJDBCOutput_15.setTimestamp(
										9,
										new java.sql.Timestamp(
												delete_cluster.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_15.setNull(9,
										java.sql.Types.DATE);
							}

							if (delete_cluster.delete_date != null) {
								pstmt_tJDBCOutput_15.setTimestamp(
										10,
										new java.sql.Timestamp(
												delete_cluster.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_15.setNull(10,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_15 = insertedCount_tJDBCOutput_15
										+ pstmt_tJDBCOutput_15.executeUpdate();
								nb_line_tJDBCOutput_15++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_15 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_15++;

							/**
							 * [tJDBCOutput_15 main ] stop
							 */

						} // End of branch "delete_cluster"

						/**
						 * [tJDBCInput_18 end ] start
						 */

						currentComponent = "tJDBCInput_18";

					}
				} finally {
					if (rs_tJDBCInput_18 != null) {
						rs_tJDBCInput_18.close();
					}
					stmt_tJDBCInput_18.close();

				}
				globalMap.put("tJDBCInput_18_NB_LINE", nb_line_tJDBCInput_18);

				ok_Hash.put("tJDBCInput_18", true);
				end_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				/**
				 * [tJDBCInput_18 end ] stop
				 */

				/**
				 * [tMap_15 end ] start
				 */

				currentComponent = "tMap_15";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row16 != null) {
					tHash_Lookup_row16.endGet();
				}
				globalMap.remove("tHash_Lookup_row16");

				// ###############################

				ok_Hash.put("tMap_15", true);
				end_Hash.put("tMap_15", System.currentTimeMillis());

				/**
				 * [tMap_15 end ] stop
				 */

				/**
				 * [tJDBCOutput_15 end ] start
				 */

				currentComponent = "tJDBCOutput_15";

				if (pstmt_tJDBCOutput_15 != null) {

					pstmt_tJDBCOutput_15.close();

				}

				nb_line_deleted_tJDBCOutput_15 = nb_line_deleted_tJDBCOutput_15
						+ deletedCount_tJDBCOutput_15;
				nb_line_update_tJDBCOutput_15 = nb_line_update_tJDBCOutput_15
						+ updatedCount_tJDBCOutput_15;
				nb_line_inserted_tJDBCOutput_15 = nb_line_inserted_tJDBCOutput_15
						+ insertedCount_tJDBCOutput_15;
				nb_line_rejected_tJDBCOutput_15 = nb_line_rejected_tJDBCOutput_15
						+ rejectedCount_tJDBCOutput_15;

				globalMap.put("tJDBCOutput_15_NB_LINE", nb_line_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_15);

				ok_Hash.put("tJDBCOutput_15", true);
				end_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_15 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_18:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_3Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_15"
			globalMap.remove("tHash_Lookup_row16");

			try {

				/**
				 * [tJDBCInput_18 finally ] start
				 */

				currentComponent = "tJDBCInput_18";

				/**
				 * [tJDBCInput_18 finally ] stop
				 */

				/**
				 * [tMap_15 finally ] start
				 */

				currentComponent = "tMap_15";

				/**
				 * [tMap_15 finally ] stop
				 */

				/**
				 * [tJDBCOutput_15 finally ] start
				 */

				currentComponent = "tJDBCOutput_15";

				/**
				 * [tJDBCOutput_15 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 1);
	}

	public static class storage_configurationStruct implements
			routines.system.IPersistableRow<storage_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public short storage_domain_type;

		public short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public short storage_type;

		public short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_name = readString(dis);

					this.storage_domain_type = dis.readShort();

					this.storage_type = dis.readShort();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_name, dos);

				// short

				dos.writeShort(this.storage_domain_type);

				// short

				dos.writeShort(this.storage_type);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(storage_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row5Struct implements
			routines.system.IPersistableRow<row5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public Short storage_domain_type;

		public Short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_type = null;
					} else {
						this.storage_domain_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_name, dos);

				// Short

				if (this.storage_domain_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_type);
				}

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row5Struct row5 = new row5Struct();
				storage_configurationStruct storage_configuration = new storage_configurationStruct();

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_3 = "INSERT INTO "
						+ "storage_domain_configuration"
						+ " (storage_domain_id,storage_domain_name,storage_domain_type,storage_type,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(insert_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());

				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				storage_configurationStruct storage_configuration_tmp = new storage_configurationStruct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT \n  storage_domain_id, \n  storage_domain_name, \n  storage_domain_type, \n  storage_type, \n  create_date, \n  update_date\nFROM dwh_storage_domain_configuration_history_view";

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);

				java.sql.ResultSet rs_tJDBCInput_3 = null;
				try {
					rs_tJDBCInput_3 = stmt_tJDBCInput_3
							.executeQuery(dbquery_tJDBCInput_3);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
							.getMetaData();
					int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
							.getColumnCount();

					String tmpContent_tJDBCInput_3 = null;

					while (rs_tJDBCInput_3.next()) {
						nb_line_tJDBCInput_3++;

						if (colQtyInRs_tJDBCInput_3 < 1) {
							row5.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_3.getObject(1) != null) {
								row5.storage_domain_id = rs_tJDBCInput_3
										.getObject(1);
							} else {
								row5.storage_domain_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 2) {
							row5.storage_domain_name = null;
						} else {

							row5.storage_domain_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_3, 2, false);
						}
						if (colQtyInRs_tJDBCInput_3 < 3) {
							row5.storage_domain_type = null;
						} else {

							if (rs_tJDBCInput_3.getObject(3) != null) {
								row5.storage_domain_type = rs_tJDBCInput_3
										.getShort(3);
							} else {
								row5.storage_domain_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 4) {
							row5.storage_type = null;
						} else {

							if (rs_tJDBCInput_3.getObject(4) != null) {
								row5.storage_type = rs_tJDBCInput_3.getShort(4);
							} else {
								row5.storage_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 5) {
							row5.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_3 = null;
							try {
								date_tJDBCInput_3 = rs_tJDBCInput_3
										.getTimestamp(5);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_3 = rs_tJDBCInput_3.getDate(5);
							}
							row5.create_date = date_tJDBCInput_3;
						}
						if (colQtyInRs_tJDBCInput_3 < 6) {
							row5.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_3 = null;
							try {
								date_tJDBCInput_3 = rs_tJDBCInput_3
										.getTimestamp(6);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_3 = rs_tJDBCInput_3.getDate(6);
							}
							row5.update_date = date_tJDBCInput_3;
						}

						/**
						 * [tJDBCInput_3 begin ] stop
						 */

						/**
						 * [tJDBCInput_3 main ] start
						 */

						currentComponent = "tJDBCInput_3";

						tos_count_tJDBCInput_3++;

						/**
						 * [tJDBCInput_3 main ] stop
						 */

						/**
						 * [tMap_3 main ] start
						 */

						currentComponent = "tMap_3";

						boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_3 = false;
						boolean mainRowRejected_tMap_3 = false;

						if (

						(

						row5.update_date == null ? TalendDate.compareDate(
								row5.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row5.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row5'
							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
								// ###############################
								// # Output tables

								storage_configuration = null;

								// # Output table : 'storage_configuration'
								storage_configuration_tmp.storage_domain_id = row5.storage_domain_id;
								storage_configuration_tmp.storage_domain_name = StringHandling
										.TRIM(row5.storage_domain_name);
								storage_configuration_tmp.storage_domain_type = row5.storage_domain_type;
								storage_configuration_tmp.storage_type = row5.storage_type;
								storage_configuration_tmp.create_date = row5.create_date;
								storage_configuration_tmp.update_date = row5.update_date;
								storage_configuration_tmp.delete_date = null;
								storage_configuration = storage_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_3 = false;

							tos_count_tMap_3++;

							/**
							 * [tMap_3 main ] stop
							 */
							// Start of branch "storage_configuration"
							if (storage_configuration != null) {

								/**
								 * [tJDBCOutput_3 main ] start
								 */

								currentComponent = "tJDBCOutput_3";

								whetherReject_tJDBCOutput_3 = false;
								if (storage_configuration.storage_domain_id == null) {
									pstmt_tJDBCOutput_3.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_3
											.setObject(
													1,
													storage_configuration.storage_domain_id);
								}

								if (storage_configuration.storage_domain_name == null) {
									pstmt_tJDBCOutput_3.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_3
											.setString(
													2,
													storage_configuration.storage_domain_name);
								}

								pstmt_tJDBCOutput_3
										.setShort(
												3,
												storage_configuration.storage_domain_type);

								pstmt_tJDBCOutput_3.setShort(4,
										storage_configuration.storage_type);

								if (storage_configuration.create_date != null) {
									pstmt_tJDBCOutput_3
											.setTimestamp(
													5,
													new java.sql.Timestamp(
															storage_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_3.setNull(5,
											java.sql.Types.DATE);
								}

								if (storage_configuration.update_date != null) {
									pstmt_tJDBCOutput_3
											.setTimestamp(
													6,
													new java.sql.Timestamp(
															storage_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_3.setNull(6,
											java.sql.Types.DATE);
								}

								if (storage_configuration.delete_date != null) {
									pstmt_tJDBCOutput_3
											.setTimestamp(
													7,
													new java.sql.Timestamp(
															storage_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_3.setNull(7,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_3 = insertedCount_tJDBCOutput_3
											+ pstmt_tJDBCOutput_3
													.executeUpdate();
									nb_line_tJDBCOutput_3++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_3 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_3++;

								/**
								 * [tJDBCOutput_3 main ] stop
								 */

							} // End of branch "storage_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row5'

						/**
						 * [tJDBCInput_3 end ] start
						 */

						currentComponent = "tJDBCInput_3";

					}
				} finally {
					if (rs_tJDBCInput_3 != null) {
						rs_tJDBCInput_3.close();
					}
					stmt_tJDBCInput_3.close();

				}
				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_3:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_20Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_3 finally ] start
				 */

				currentComponent = "tJDBCInput_3";

				/**
				 * [tJDBCInput_3 finally ] stop
				 */

				/**
				 * [tMap_3 finally ] start
				 */

				currentComponent = "tMap_3";

				/**
				 * [tMap_3 finally ] stop
				 */

				/**
				 * [tJDBCOutput_3 finally ] start
				 */

				currentComponent = "tJDBCOutput_3";

				/**
				 * [tJDBCOutput_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class delete_storageStruct implements
			routines.system.IPersistableRow<delete_storageStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public short storage_domain_type;

		public short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public short storage_type;

		public short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_name = readString(dis);

					this.storage_domain_type = dis.readShort();

					this.storage_type = dis.readShort();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_name, dos);

				// short

				dos.writeShort(this.storage_domain_type);

				// short

				dos.writeShort(this.storage_type);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_storageStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row19Struct implements
			routines.system.IPersistableRow<row19Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public Short storage_domain_type;

		public Short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_domain_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_type = null;
					} else {
						this.storage_domain_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// String

				writeString(this.storage_domain_name, dos);

				// Short

				if (this.storage_domain_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_type);
				}

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row19Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_20Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_20Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public String storage_domain_name;

		public String getStorage_domain_name() {
			return this.storage_domain_name;
		}

		public Short storage_domain_type;

		public Short getStorage_domain_type() {
			return this.storage_domain_type;
		}

		public Short storage_type;

		public Short getStorage_type() {
			return this.storage_type;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_domain_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.storage_domain_type = null;
					} else {
						this.storage_domain_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.storage_type = null;
					} else {
						this.storage_type = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// String

				writeString(this.storage_domain_name, dos);

				// Short

				if (this.storage_domain_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_domain_type);
				}

				// Short

				if (this.storage_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.storage_type);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_domain_name=" + storage_domain_name);
			sb.append(",storage_domain_type="
					+ String.valueOf(storage_domain_type));
			sb.append(",storage_type=" + String.valueOf(storage_type));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_20Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_20Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_19Process(globalMap);

				row19Struct row19 = new row19Struct();
				delete_storageStruct delete_storage = new delete_storageStruct();

				/**
				 * [tJDBCOutput_16 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_16", false);
				start_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_16";

				int tos_count_tJDBCOutput_16 = 0;

				int nb_line_tJDBCOutput_16 = 0;
				int nb_line_update_tJDBCOutput_16 = 0;
				int nb_line_inserted_tJDBCOutput_16 = 0;
				int nb_line_deleted_tJDBCOutput_16 = 0;
				int nb_line_rejected_tJDBCOutput_16 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_16 = 0;

				int deletedCount_tJDBCOutput_16 = 0;
				int updatedCount_tJDBCOutput_16 = 0;
				int insertedCount_tJDBCOutput_16 = 0;
				int rejectedCount_tJDBCOutput_16 = 0;

				boolean whetherReject_tJDBCOutput_16 = false;

				java.sql.Connection connection_tJDBCOutput_16 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_16 = "INSERT INTO "
						+ "storage_domain_configuration"
						+ " (storage_domain_id,storage_domain_name,storage_domain_type,storage_type,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_16 = connection_tJDBCOutput_16
						.prepareStatement(insert_tJDBCOutput_16);

				/**
				 * [tJDBCOutput_16 begin ] stop
				 */

				/**
				 * [tMap_16 begin ] start
				 */

				ok_Hash.put("tMap_16", false);
				start_Hash.put("tMap_16", System.currentTimeMillis());

				currentComponent = "tMap_16";

				int tos_count_tMap_16 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row18Struct> tHash_Lookup_row18 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row18Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row18Struct>) globalMap
						.get("tHash_Lookup_row18"));

				row18Struct row18HashKey = new row18Struct();
				row18Struct row18Default = new row18Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_16__Struct {
				}
				Var__tMap_16__Struct Var__tMap_16 = new Var__tMap_16__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_storageStruct delete_storage_tmp = new delete_storageStruct();
				// ###############################

				/**
				 * [tMap_16 begin ] stop
				 */

				/**
				 * [tJDBCInput_20 begin ] start
				 */

				ok_Hash.put("tJDBCInput_20", false);
				start_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				currentComponent = "tJDBCInput_20";

				int tos_count_tJDBCInput_20 = 0;

				int nb_line_tJDBCInput_20 = 0;
				java.sql.Connection conn_tJDBCInput_20 = null;
				conn_tJDBCInput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_20 = conn_tJDBCInput_20
						.createStatement();

				String dbquery_tJDBCInput_20 = "SELECT history_id, \n  		storage_domain_id, \n		upper(cast(storage_domain_id as char(36))) as storage_domain_join_id,\n 		storage_domain_name, \n 		storage_domain_type, \n  		storage_type, \n  		create_date, \n  		update_date\nFROM v4_4_latest_configuration_storage_domains";

				globalMap.put("tJDBCInput_20_QUERY", dbquery_tJDBCInput_20);

				java.sql.ResultSet rs_tJDBCInput_20 = null;
				try {
					rs_tJDBCInput_20 = stmt_tJDBCInput_20
							.executeQuery(dbquery_tJDBCInput_20);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_20 = rs_tJDBCInput_20
							.getMetaData();
					int colQtyInRs_tJDBCInput_20 = rsmd_tJDBCInput_20
							.getColumnCount();

					String tmpContent_tJDBCInput_20 = null;

					while (rs_tJDBCInput_20.next()) {
						nb_line_tJDBCInput_20++;

						if (colQtyInRs_tJDBCInput_20 < 1) {
							row19.history_id = null;
						} else {

							if (rs_tJDBCInput_20.getObject(1) != null) {
								row19.history_id = rs_tJDBCInput_20.getInt(1);
							} else {
								row19.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_20 < 2) {
							row19.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_20.getObject(2) != null) {
								row19.storage_domain_id = rs_tJDBCInput_20
										.getObject(2);
							} else {
								row19.storage_domain_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_20 < 3) {
							row19.storage_domain_join_id = null;
						} else {

							row19.storage_domain_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_20, 3, false);
						}
						if (colQtyInRs_tJDBCInput_20 < 4) {
							row19.storage_domain_name = null;
						} else {

							row19.storage_domain_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_20, 4, false);
						}
						if (colQtyInRs_tJDBCInput_20 < 5) {
							row19.storage_domain_type = null;
						} else {

							if (rs_tJDBCInput_20.getObject(5) != null) {
								row19.storage_domain_type = rs_tJDBCInput_20
										.getShort(5);
							} else {
								row19.storage_domain_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_20 < 6) {
							row19.storage_type = null;
						} else {

							if (rs_tJDBCInput_20.getObject(6) != null) {
								row19.storage_type = rs_tJDBCInput_20
										.getShort(6);
							} else {
								row19.storage_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_20 < 7) {
							row19.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_20 = null;
							try {
								date_tJDBCInput_20 = rs_tJDBCInput_20
										.getTimestamp(7);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_20 = rs_tJDBCInput_20
										.getDate(7);
							}
							row19.create_date = date_tJDBCInput_20;
						}
						if (colQtyInRs_tJDBCInput_20 < 8) {
							row19.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_20 = null;
							try {
								date_tJDBCInput_20 = rs_tJDBCInput_20
										.getTimestamp(8);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_20 = rs_tJDBCInput_20
										.getDate(8);
							}
							row19.update_date = date_tJDBCInput_20;
						}

						/**
						 * [tJDBCInput_20 begin ] stop
						 */

						/**
						 * [tJDBCInput_20 main ] start
						 */

						currentComponent = "tJDBCInput_20";

						tos_count_tJDBCInput_20++;

						/**
						 * [tJDBCInput_20 main ] stop
						 */

						/**
						 * [tMap_16 main ] start
						 */

						currentComponent = "tMap_16";

						boolean hasCasePrimitiveKeyWithNull_tMap_16 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_16 = false;
						boolean mainRowRejected_tMap_16 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row18"
						// /////////////////////////////////////////////

						boolean forceLooprow18 = false;

						row18Struct row18ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_16) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_16 = false;

							row18HashKey.storage_domain_join_id = row19.storage_domain_join_id;

							row18HashKey.hashCodeDirty = true;

							tHash_Lookup_row18.lookup(row18HashKey);

							if (!tHash_Lookup_row18.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_16 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row18 != null
								&& tHash_Lookup_row18.getCount(row18HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row18' and it contains more one result from keys :  row18.storage_domain_join_id = '"
							// + row18HashKey.storage_domain_join_id + "'");
						} // G 071

						row18Struct row18 = null;

						row18Struct fromLookup_row18 = null;
						row18 = row18Default;

						if (tHash_Lookup_row18 != null
								&& tHash_Lookup_row18.hasNext()) { // G 099

							fromLookup_row18 = tHash_Lookup_row18.next();

						} // G 099

						if (fromLookup_row18 != null) {
							row18 = fromLookup_row18;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_16__Struct Var = Var__tMap_16;// ###############################
							// ###############################
							// # Output tables

							delete_storage = null;

							if (!rejectedInnerJoin_tMap_16) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_storage'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_16) {
								delete_storage_tmp.storage_domain_id = row19.storage_domain_id;
								delete_storage_tmp.storage_domain_name = row19.storage_domain_name;
								delete_storage_tmp.storage_domain_type = row19.storage_domain_type;
								delete_storage_tmp.storage_type = row19.storage_type;
								delete_storage_tmp.create_date = row19.create_date;
								delete_storage_tmp.update_date = context.runTime;
								delete_storage_tmp.delete_date = context.runTime;
								delete_storage = delete_storage_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_16 = false;

						tos_count_tMap_16++;

						/**
						 * [tMap_16 main ] stop
						 */
						// Start of branch "delete_storage"
						if (delete_storage != null) {

							/**
							 * [tJDBCOutput_16 main ] start
							 */

							currentComponent = "tJDBCOutput_16";

							whetherReject_tJDBCOutput_16 = false;
							if (delete_storage.storage_domain_id == null) {
								pstmt_tJDBCOutput_16.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_16.setObject(1,
										delete_storage.storage_domain_id);
							}

							if (delete_storage.storage_domain_name == null) {
								pstmt_tJDBCOutput_16.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_16.setString(2,
										delete_storage.storage_domain_name);
							}

							pstmt_tJDBCOutput_16.setShort(3,
									delete_storage.storage_domain_type);

							pstmt_tJDBCOutput_16.setShort(4,
									delete_storage.storage_type);

							if (delete_storage.create_date != null) {
								pstmt_tJDBCOutput_16.setTimestamp(
										5,
										new java.sql.Timestamp(
												delete_storage.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_16.setNull(5,
										java.sql.Types.DATE);
							}

							if (delete_storage.update_date != null) {
								pstmt_tJDBCOutput_16.setTimestamp(
										6,
										new java.sql.Timestamp(
												delete_storage.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_16.setNull(6,
										java.sql.Types.DATE);
							}

							if (delete_storage.delete_date != null) {
								pstmt_tJDBCOutput_16.setTimestamp(
										7,
										new java.sql.Timestamp(
												delete_storage.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_16.setNull(7,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_16 = insertedCount_tJDBCOutput_16
										+ pstmt_tJDBCOutput_16.executeUpdate();
								nb_line_tJDBCOutput_16++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_16 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_16++;

							/**
							 * [tJDBCOutput_16 main ] stop
							 */

						} // End of branch "delete_storage"

						/**
						 * [tJDBCInput_20 end ] start
						 */

						currentComponent = "tJDBCInput_20";

					}
				} finally {
					if (rs_tJDBCInput_20 != null) {
						rs_tJDBCInput_20.close();
					}
					stmt_tJDBCInput_20.close();

				}
				globalMap.put("tJDBCInput_20_NB_LINE", nb_line_tJDBCInput_20);

				ok_Hash.put("tJDBCInput_20", true);
				end_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				/**
				 * [tJDBCInput_20 end ] stop
				 */

				/**
				 * [tMap_16 end ] start
				 */

				currentComponent = "tMap_16";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row18 != null) {
					tHash_Lookup_row18.endGet();
				}
				globalMap.remove("tHash_Lookup_row18");

				// ###############################

				ok_Hash.put("tMap_16", true);
				end_Hash.put("tMap_16", System.currentTimeMillis());

				/**
				 * [tMap_16 end ] stop
				 */

				/**
				 * [tJDBCOutput_16 end ] start
				 */

				currentComponent = "tJDBCOutput_16";

				if (pstmt_tJDBCOutput_16 != null) {

					pstmt_tJDBCOutput_16.close();

				}

				nb_line_deleted_tJDBCOutput_16 = nb_line_deleted_tJDBCOutput_16
						+ deletedCount_tJDBCOutput_16;
				nb_line_update_tJDBCOutput_16 = nb_line_update_tJDBCOutput_16
						+ updatedCount_tJDBCOutput_16;
				nb_line_inserted_tJDBCOutput_16 = nb_line_inserted_tJDBCOutput_16
						+ insertedCount_tJDBCOutput_16;
				nb_line_rejected_tJDBCOutput_16 = nb_line_rejected_tJDBCOutput_16
						+ rejectedCount_tJDBCOutput_16;

				globalMap.put("tJDBCOutput_16_NB_LINE", nb_line_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_16);

				ok_Hash.put("tJDBCOutput_16", true);
				end_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_16 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_20:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_33Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_16"
			globalMap.remove("tHash_Lookup_row18");

			try {

				/**
				 * [tJDBCInput_20 finally ] start
				 */

				currentComponent = "tJDBCInput_20";

				/**
				 * [tJDBCInput_20 finally ] stop
				 */

				/**
				 * [tMap_16 finally ] start
				 */

				currentComponent = "tMap_16";

				/**
				 * [tMap_16 finally ] stop
				 */

				/**
				 * [tJDBCOutput_16 finally ] start
				 */

				currentComponent = "tJDBCOutput_16";

				/**
				 * [tJDBCOutput_16 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 1);
	}

	public static class insert_new_dc_storage_connectionStruct
			implements
			routines.system.IPersistableRow<insert_new_dc_storage_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		public java.util.Date detach_date;

		public java.util.Date getDetach_date() {
			return this.detach_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_domain_id == null) ? 0
								: this.storage_domain_id.hashCode());

				result = prime
						* result
						+ ((this.datacenter_id == null) ? 0
								: this.datacenter_id.hashCode());

				result = prime
						* result
						+ ((this.attach_date == null) ? 0 : this.attach_date
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final insert_new_dc_storage_connectionStruct other = (insert_new_dc_storage_connectionStruct) obj;

			if (this.storage_domain_id == null) {
				if (other.storage_domain_id != null)
					return false;

			} else if (!this.storage_domain_id.equals(other.storage_domain_id))

				return false;

			if (this.datacenter_id == null) {
				if (other.datacenter_id != null)
					return false;

			} else if (!this.datacenter_id.equals(other.datacenter_id))

				return false;

			if (this.attach_date == null) {
				if (other.attach_date != null)
					return false;

			} else if (!this.attach_date.equals(other.attach_date))

				return false;

			return true;
		}

		public void copyDataTo(insert_new_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;
			other.detach_date = this.detach_date;

		}

		public void copyKeysDataTo(insert_new_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;

		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.datacenter_id = (Object) dis.readObject();

					this.attach_date = readDate(dis);

					this.detach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// Object

				dos.writeObject(this.datacenter_id);

				// java.util.Date

				writeDate(this.attach_date, dos);

				// java.util.Date

				writeDate(this.detach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append(",detach_date=" + String.valueOf(detach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(insert_new_dc_storage_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_domain_id,
					other.storage_domain_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.datacenter_id,
					other.datacenter_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.attach_date,
					other.attach_date);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row31Struct implements
			routines.system.IPersistableRow<row31Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_id;

		public Object getStorage_id() {
			return this.storage_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object storage_pool_id;

		public Object getStorage_pool_id() {
			return this.storage_pool_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_pool_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.storage_pool_id);

				// String

				writeString(this.datacenter_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_id=" + String.valueOf(storage_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_pool_id=" + String.valueOf(storage_pool_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row31Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_33Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_33Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object storage_id;

		public Object getStorage_id() {
			return this.storage_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object storage_pool_id;

		public Object getStorage_pool_id() {
			return this.storage_pool_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_id == null) ? 0 : this.storage_id
								.hashCode());

				result = prime
						* result
						+ ((this.storage_pool_id == null) ? 0
								: this.storage_pool_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final after_tJDBCInput_33Struct other = (after_tJDBCInput_33Struct) obj;

			if (this.storage_id == null) {
				if (other.storage_id != null)
					return false;

			} else if (!this.storage_id.equals(other.storage_id))

				return false;

			if (this.storage_pool_id == null) {
				if (other.storage_pool_id != null)
					return false;

			} else if (!this.storage_pool_id.equals(other.storage_pool_id))

				return false;

			return true;
		}

		public void copyDataTo(after_tJDBCInput_33Struct other) {

			other.storage_id = this.storage_id;
			other.storage_domain_join_id = this.storage_domain_join_id;
			other.storage_pool_id = this.storage_pool_id;
			other.datacenter_join_id = this.datacenter_join_id;

		}

		public void copyKeysDataTo(after_tJDBCInput_33Struct other) {

			other.storage_id = this.storage_id;
			other.storage_pool_id = this.storage_pool_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.storage_pool_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.storage_pool_id);

				// String

				writeString(this.datacenter_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_id=" + String.valueOf(storage_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",storage_pool_id=" + String.valueOf(storage_pool_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_33Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_id,
					other.storage_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.storage_pool_id,
					other.storage_pool_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_33Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_33_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_35Process(globalMap);

				row31Struct row31 = new row31Struct();
				insert_new_dc_storage_connectionStruct insert_new_dc_storage_connection = new insert_new_dc_storage_connectionStruct();

				/**
				 * [tJDBCOutput_23 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_23", false);
				start_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_23";

				int tos_count_tJDBCOutput_23 = 0;

				int nb_line_tJDBCOutput_23 = 0;
				int nb_line_update_tJDBCOutput_23 = 0;
				int nb_line_inserted_tJDBCOutput_23 = 0;
				int nb_line_deleted_tJDBCOutput_23 = 0;
				int nb_line_rejected_tJDBCOutput_23 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_23 = 0;

				int deletedCount_tJDBCOutput_23 = 0;
				int updatedCount_tJDBCOutput_23 = 0;
				int insertedCount_tJDBCOutput_23 = 0;
				int rejectedCount_tJDBCOutput_23 = 0;

				boolean whetherReject_tJDBCOutput_23 = false;

				java.sql.Connection connection_tJDBCOutput_23 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_23 = "INSERT INTO "
						+ "datacenter_storage_domain_map"
						+ " (storage_domain_id,datacenter_id,attach_date,detach_date) VALUES (?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_23 = connection_tJDBCOutput_23
						.prepareStatement(insert_tJDBCOutput_23);

				/**
				 * [tJDBCOutput_23 begin ] stop
				 */

				/**
				 * [tMap_23 begin ] start
				 */

				ok_Hash.put("tMap_23", false);
				start_Hash.put("tMap_23", System.currentTimeMillis());

				currentComponent = "tMap_23";

				int tos_count_tMap_23 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row33Struct> tHash_Lookup_row33 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row33Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row33Struct>) globalMap
						.get("tHash_Lookup_row33"));

				row33Struct row33HashKey = new row33Struct();
				row33Struct row33Default = new row33Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_23__Struct {
				}
				Var__tMap_23__Struct Var__tMap_23 = new Var__tMap_23__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				insert_new_dc_storage_connectionStruct insert_new_dc_storage_connection_tmp = new insert_new_dc_storage_connectionStruct();
				// ###############################

				/**
				 * [tMap_23 begin ] stop
				 */

				/**
				 * [tJDBCInput_33 begin ] start
				 */

				ok_Hash.put("tJDBCInput_33", false);
				start_Hash.put("tJDBCInput_33", System.currentTimeMillis());

				currentComponent = "tJDBCInput_33";

				int tos_count_tJDBCInput_33 = 0;

				int nb_line_tJDBCInput_33 = 0;
				java.sql.Connection conn_tJDBCInput_33 = null;
				conn_tJDBCInput_33 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_33 = conn_tJDBCInput_33
						.createStatement();

				String dbquery_tJDBCInput_33 = "SELECT storage_id,\n		upper(cast(storage_id as char(36))) as storage_domain_join_id,\n		storage_pool_id,\n		upper(cast(storage_pool_id as char(36))) as datacenter_join_id\nFROM  storage_pool_iso_map";

				globalMap.put("tJDBCInput_33_QUERY", dbquery_tJDBCInput_33);

				java.sql.ResultSet rs_tJDBCInput_33 = null;
				try {
					rs_tJDBCInput_33 = stmt_tJDBCInput_33
							.executeQuery(dbquery_tJDBCInput_33);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_33 = rs_tJDBCInput_33
							.getMetaData();
					int colQtyInRs_tJDBCInput_33 = rsmd_tJDBCInput_33
							.getColumnCount();

					String tmpContent_tJDBCInput_33 = null;

					while (rs_tJDBCInput_33.next()) {
						nb_line_tJDBCInput_33++;

						if (colQtyInRs_tJDBCInput_33 < 1) {
							row31.storage_id = null;
						} else {

							if (rs_tJDBCInput_33.getObject(1) != null) {
								row31.storage_id = rs_tJDBCInput_33
										.getObject(1);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_33 < 2) {
							row31.storage_domain_join_id = null;
						} else {

							row31.storage_domain_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_33, 2, false);
						}
						if (colQtyInRs_tJDBCInput_33 < 3) {
							row31.storage_pool_id = null;
						} else {

							if (rs_tJDBCInput_33.getObject(3) != null) {
								row31.storage_pool_id = rs_tJDBCInput_33
										.getObject(3);
							} else {
								throw new RuntimeException(
										"Null value in non-Nullable column");
							}
						}
						if (colQtyInRs_tJDBCInput_33 < 4) {
							row31.datacenter_join_id = null;
						} else {

							row31.datacenter_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_33, 4, false);
						}

						/**
						 * [tJDBCInput_33 begin ] stop
						 */

						/**
						 * [tJDBCInput_33 main ] start
						 */

						currentComponent = "tJDBCInput_33";

						tos_count_tJDBCInput_33++;

						/**
						 * [tJDBCInput_33 main ] stop
						 */

						/**
						 * [tMap_23 main ] start
						 */

						currentComponent = "tMap_23";

						boolean hasCasePrimitiveKeyWithNull_tMap_23 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_23 = false;
						boolean mainRowRejected_tMap_23 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row33"
						// /////////////////////////////////////////////

						boolean forceLooprow33 = false;

						row33Struct row33ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_23) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_23 = false;

							row33HashKey.storage_domain_join_id = row31.storage_domain_join_id;

							row33HashKey.datacenter_join_id = row31.datacenter_join_id;

							row33HashKey.hashCodeDirty = true;

							tHash_Lookup_row33.lookup(row33HashKey);

							if (!tHash_Lookup_row33.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_23 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row33 != null
								&& tHash_Lookup_row33.getCount(row33HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row33' and it contains more one result from keys :  row33.storage_domain_join_id = '"
							// + row33HashKey.storage_domain_join_id +
							// "', row33.datacenter_join_id = '" +
							// row33HashKey.datacenter_join_id + "'");
						} // G 071

						row33Struct row33 = null;

						row33Struct fromLookup_row33 = null;
						row33 = row33Default;

						if (tHash_Lookup_row33 != null
								&& tHash_Lookup_row33.hasNext()) { // G 099

							fromLookup_row33 = tHash_Lookup_row33.next();

						} // G 099

						if (fromLookup_row33 != null) {
							row33 = fromLookup_row33;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_23__Struct Var = Var__tMap_23;// ###############################
							// ###############################
							// # Output tables

							insert_new_dc_storage_connection = null;

							if (!rejectedInnerJoin_tMap_23) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table :
							// 'insert_new_dc_storage_connection'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_23) {
								insert_new_dc_storage_connection_tmp.storage_domain_id = row31.storage_id;
								insert_new_dc_storage_connection_tmp.datacenter_id = row31.storage_pool_id;
								insert_new_dc_storage_connection_tmp.attach_date = context.runTime;
								insert_new_dc_storage_connection_tmp.detach_date = null;
								insert_new_dc_storage_connection = insert_new_dc_storage_connection_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_23 = false;

						tos_count_tMap_23++;

						/**
						 * [tMap_23 main ] stop
						 */
						// Start of branch "insert_new_dc_storage_connection"
						if (insert_new_dc_storage_connection != null) {

							/**
							 * [tJDBCOutput_23 main ] start
							 */

							currentComponent = "tJDBCOutput_23";

							whetherReject_tJDBCOutput_23 = false;
							if (insert_new_dc_storage_connection.storage_domain_id == null) {
								pstmt_tJDBCOutput_23.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_23
										.setObject(
												1,
												insert_new_dc_storage_connection.storage_domain_id);
							}

							if (insert_new_dc_storage_connection.datacenter_id == null) {
								pstmt_tJDBCOutput_23.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_23
										.setObject(
												2,
												insert_new_dc_storage_connection.datacenter_id);
							}

							if (insert_new_dc_storage_connection.attach_date != null) {
								pstmt_tJDBCOutput_23
										.setTimestamp(
												3,
												new java.sql.Timestamp(
														insert_new_dc_storage_connection.attach_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_23.setNull(3,
										java.sql.Types.DATE);
							}

							if (insert_new_dc_storage_connection.detach_date != null) {
								pstmt_tJDBCOutput_23
										.setTimestamp(
												4,
												new java.sql.Timestamp(
														insert_new_dc_storage_connection.detach_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_23.setNull(4,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_23 = insertedCount_tJDBCOutput_23
										+ pstmt_tJDBCOutput_23.executeUpdate();
								nb_line_tJDBCOutput_23++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_23 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_23++;

							/**
							 * [tJDBCOutput_23 main ] stop
							 */

						} // End of branch "insert_new_dc_storage_connection"

						/**
						 * [tJDBCInput_33 end ] start
						 */

						currentComponent = "tJDBCInput_33";

					}
				} finally {
					if (rs_tJDBCInput_33 != null) {
						rs_tJDBCInput_33.close();
					}
					stmt_tJDBCInput_33.close();

				}
				globalMap.put("tJDBCInput_33_NB_LINE", nb_line_tJDBCInput_33);

				ok_Hash.put("tJDBCInput_33", true);
				end_Hash.put("tJDBCInput_33", System.currentTimeMillis());

				/**
				 * [tJDBCInput_33 end ] stop
				 */

				/**
				 * [tMap_23 end ] start
				 */

				currentComponent = "tMap_23";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row33 != null) {
					tHash_Lookup_row33.endGet();
				}
				globalMap.remove("tHash_Lookup_row33");

				// ###############################

				ok_Hash.put("tMap_23", true);
				end_Hash.put("tMap_23", System.currentTimeMillis());

				/**
				 * [tMap_23 end ] stop
				 */

				/**
				 * [tJDBCOutput_23 end ] start
				 */

				currentComponent = "tJDBCOutput_23";

				if (pstmt_tJDBCOutput_23 != null) {

					pstmt_tJDBCOutput_23.close();

				}

				nb_line_deleted_tJDBCOutput_23 = nb_line_deleted_tJDBCOutput_23
						+ deletedCount_tJDBCOutput_23;
				nb_line_update_tJDBCOutput_23 = nb_line_update_tJDBCOutput_23
						+ updatedCount_tJDBCOutput_23;
				nb_line_inserted_tJDBCOutput_23 = nb_line_inserted_tJDBCOutput_23
						+ insertedCount_tJDBCOutput_23;
				nb_line_rejected_tJDBCOutput_23 = nb_line_rejected_tJDBCOutput_23
						+ rejectedCount_tJDBCOutput_23;

				globalMap.put("tJDBCOutput_23_NB_LINE", nb_line_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_23);

				ok_Hash.put("tJDBCOutput_23", true);
				end_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_23 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_33:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_34Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_23"
			globalMap.remove("tHash_Lookup_row33");

			try {

				/**
				 * [tJDBCInput_33 finally ] start
				 */

				currentComponent = "tJDBCInput_33";

				/**
				 * [tJDBCInput_33 finally ] stop
				 */

				/**
				 * [tMap_23 finally ] start
				 */

				currentComponent = "tMap_23";

				/**
				 * [tMap_23 finally ] stop
				 */

				/**
				 * [tJDBCOutput_23 finally ] start
				 */

				currentComponent = "tJDBCOutput_23";

				/**
				 * [tJDBCOutput_23 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_33_SUBPROCESS_STATE", 1);
	}

	public static class delete_dc_storage_connectionStruct implements
			routines.system.IPersistableRow<delete_dc_storage_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		public java.util.Date detach_date;

		public java.util.Date getDetach_date() {
			return this.detach_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.storage_domain_id == null) ? 0
								: this.storage_domain_id.hashCode());

				result = prime
						* result
						+ ((this.datacenter_id == null) ? 0
								: this.datacenter_id.hashCode());

				result = prime
						* result
						+ ((this.attach_date == null) ? 0 : this.attach_date
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final delete_dc_storage_connectionStruct other = (delete_dc_storage_connectionStruct) obj;

			if (this.storage_domain_id == null) {
				if (other.storage_domain_id != null)
					return false;

			} else if (!this.storage_domain_id.equals(other.storage_domain_id))

				return false;

			if (this.datacenter_id == null) {
				if (other.datacenter_id != null)
					return false;

			} else if (!this.datacenter_id.equals(other.datacenter_id))

				return false;

			if (this.attach_date == null) {
				if (other.attach_date != null)
					return false;

			} else if (!this.attach_date.equals(other.attach_date))

				return false;

			return true;
		}

		public void copyDataTo(delete_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;
			other.detach_date = this.detach_date;

		}

		public void copyKeysDataTo(delete_dc_storage_connectionStruct other) {

			other.storage_domain_id = this.storage_domain_id;
			other.datacenter_id = this.datacenter_id;
			other.attach_date = this.attach_date;

		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.datacenter_id = (Object) dis.readObject();

					this.attach_date = readDate(dis);

					this.detach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// Object

				dos.writeObject(this.datacenter_id);

				// java.util.Date

				writeDate(this.attach_date, dos);

				// java.util.Date

				writeDate(this.detach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append(",detach_date=" + String.valueOf(detach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_dc_storage_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.storage_domain_id,
					other.storage_domain_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.datacenter_id,
					other.datacenter_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.attach_date,
					other.attach_date);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row30Struct implements
			routines.system.IPersistableRow<row30Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.attach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// java.util.Date

				writeDate(this.attach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row30Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_34Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_34Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String storage_domain_join_id;

		public String getStorage_domain_join_id() {
			return this.storage_domain_join_id;
		}

		public Object datacenter_id;

		public Object getDatacenter_id() {
			return this.datacenter_id;
		}

		public String datacenter_join_id;

		public String getDatacenter_join_id() {
			return this.datacenter_join_id;
		}

		public java.util.Date attach_date;

		public java.util.Date getAttach_date() {
			return this.attach_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.storage_domain_join_id = readString(dis);

					this.datacenter_id = (Object) dis.readObject();

					this.datacenter_join_id = readString(dis);

					this.attach_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.storage_domain_join_id, dos);

				// Object

				dos.writeObject(this.datacenter_id);

				// String

				writeString(this.datacenter_join_id, dos);

				// java.util.Date

				writeDate(this.attach_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",storage_domain_join_id=" + storage_domain_join_id);
			sb.append(",datacenter_id=" + String.valueOf(datacenter_id));
			sb.append(",datacenter_join_id=" + datacenter_join_id);
			sb.append(",attach_date=" + String.valueOf(attach_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_34Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_34Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_34_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_32Process(globalMap);

				row30Struct row30 = new row30Struct();
				delete_dc_storage_connectionStruct delete_dc_storage_connection = new delete_dc_storage_connectionStruct();

				/**
				 * [tJDBCOutput_24 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_24", false);
				start_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_24";

				int tos_count_tJDBCOutput_24 = 0;

				int updateKeyCount_tJDBCOutput_24 = 3;
				if (updateKeyCount_tJDBCOutput_24 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_24 = 0;
				int nb_line_update_tJDBCOutput_24 = 0;
				int nb_line_inserted_tJDBCOutput_24 = 0;
				int nb_line_deleted_tJDBCOutput_24 = 0;
				int nb_line_rejected_tJDBCOutput_24 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_24 = 0;

				int deletedCount_tJDBCOutput_24 = 0;
				int updatedCount_tJDBCOutput_24 = 0;
				int insertedCount_tJDBCOutput_24 = 0;
				int rejectedCount_tJDBCOutput_24 = 0;

				boolean whetherReject_tJDBCOutput_24 = false;

				java.sql.Connection connection_tJDBCOutput_24 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String update_tJDBCOutput_24 = "UPDATE "
						+ "datacenter_storage_domain_map"
						+ " SET detach_date = ? WHERE storage_domain_id = ? AND datacenter_id = ? AND attach_date = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_24 = connection_tJDBCOutput_24
						.prepareStatement(update_tJDBCOutput_24);

				/**
				 * [tJDBCOutput_24 begin ] stop
				 */

				/**
				 * [tMap_22 begin ] start
				 */

				ok_Hash.put("tMap_22", false);
				start_Hash.put("tMap_22", System.currentTimeMillis());

				currentComponent = "tMap_22";

				int tos_count_tMap_22 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row32Struct> tHash_Lookup_row32 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row32Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row32Struct>) globalMap
						.get("tHash_Lookup_row32"));

				row32Struct row32HashKey = new row32Struct();
				row32Struct row32Default = new row32Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_22__Struct {
				}
				Var__tMap_22__Struct Var__tMap_22 = new Var__tMap_22__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_dc_storage_connectionStruct delete_dc_storage_connection_tmp = new delete_dc_storage_connectionStruct();
				// ###############################

				/**
				 * [tMap_22 begin ] stop
				 */

				/**
				 * [tJDBCInput_34 begin ] start
				 */

				ok_Hash.put("tJDBCInput_34", false);
				start_Hash.put("tJDBCInput_34", System.currentTimeMillis());

				currentComponent = "tJDBCInput_34";

				int tos_count_tJDBCInput_34 = 0;

				int nb_line_tJDBCInput_34 = 0;
				java.sql.Connection conn_tJDBCInput_34 = null;
				conn_tJDBCInput_34 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_34 = conn_tJDBCInput_34
						.createStatement();

				String dbquery_tJDBCInput_34 = "SELECT storage_domain_id, \n		upper(cast(storage_domain_id as char(36))) as storage_domain_join_id, \n		datacenter_id, \n		upper(cast(datacenter_id as char(36))) as datacenter_join_id,\n		attach_date\nFROM  v4_4_latest_map_datacenters_storage_domains";

				globalMap.put("tJDBCInput_34_QUERY", dbquery_tJDBCInput_34);

				java.sql.ResultSet rs_tJDBCInput_34 = null;
				try {
					rs_tJDBCInput_34 = stmt_tJDBCInput_34
							.executeQuery(dbquery_tJDBCInput_34);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_34 = rs_tJDBCInput_34
							.getMetaData();
					int colQtyInRs_tJDBCInput_34 = rsmd_tJDBCInput_34
							.getColumnCount();

					String tmpContent_tJDBCInput_34 = null;

					while (rs_tJDBCInput_34.next()) {
						nb_line_tJDBCInput_34++;

						if (colQtyInRs_tJDBCInput_34 < 1) {
							row30.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_34.getObject(1) != null) {
								row30.storage_domain_id = rs_tJDBCInput_34
										.getObject(1);
							} else {
								row30.storage_domain_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_34 < 2) {
							row30.storage_domain_join_id = null;
						} else {

							row30.storage_domain_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_34, 2, false);
						}
						if (colQtyInRs_tJDBCInput_34 < 3) {
							row30.datacenter_id = null;
						} else {

							if (rs_tJDBCInput_34.getObject(3) != null) {
								row30.datacenter_id = rs_tJDBCInput_34
										.getObject(3);
							} else {
								row30.datacenter_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_34 < 4) {
							row30.datacenter_join_id = null;
						} else {

							row30.datacenter_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_34, 4, false);
						}
						if (colQtyInRs_tJDBCInput_34 < 5) {
							row30.attach_date = null;
						} else {

							java.util.Date date_tJDBCInput_34 = null;
							try {
								date_tJDBCInput_34 = rs_tJDBCInput_34
										.getTimestamp(5);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_34 = rs_tJDBCInput_34
										.getDate(5);
							}
							row30.attach_date = date_tJDBCInput_34;
						}

						/**
						 * [tJDBCInput_34 begin ] stop
						 */

						/**
						 * [tJDBCInput_34 main ] start
						 */

						currentComponent = "tJDBCInput_34";

						tos_count_tJDBCInput_34++;

						/**
						 * [tJDBCInput_34 main ] stop
						 */

						/**
						 * [tMap_22 main ] start
						 */

						currentComponent = "tMap_22";

						boolean hasCasePrimitiveKeyWithNull_tMap_22 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_22 = false;
						boolean mainRowRejected_tMap_22 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row32"
						// /////////////////////////////////////////////

						boolean forceLooprow32 = false;

						row32Struct row32ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_22) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_22 = false;

							row32HashKey.storage_domain_join_id = row30.storage_domain_join_id;

							row32HashKey.datacenter_join_id = row30.datacenter_join_id;

							row32HashKey.hashCodeDirty = true;

							tHash_Lookup_row32.lookup(row32HashKey);

							if (!tHash_Lookup_row32.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_22 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row32 != null
								&& tHash_Lookup_row32.getCount(row32HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row32' and it contains more one result from keys :  row32.storage_domain_join_id = '"
							// + row32HashKey.storage_domain_join_id +
							// "', row32.datacenter_join_id = '" +
							// row32HashKey.datacenter_join_id + "'");
						} // G 071

						row32Struct row32 = null;

						row32Struct fromLookup_row32 = null;
						row32 = row32Default;

						if (tHash_Lookup_row32 != null
								&& tHash_Lookup_row32.hasNext()) { // G 099

							fromLookup_row32 = tHash_Lookup_row32.next();

						} // G 099

						if (fromLookup_row32 != null) {
							row32 = fromLookup_row32;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_22__Struct Var = Var__tMap_22;// ###############################
							// ###############################
							// # Output tables

							delete_dc_storage_connection = null;

							if (!rejectedInnerJoin_tMap_22) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table :
							// 'delete_dc_storage_connection'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_22) {
								delete_dc_storage_connection_tmp.storage_domain_id = row30.storage_domain_id;
								delete_dc_storage_connection_tmp.datacenter_id = row30.datacenter_id;
								delete_dc_storage_connection_tmp.attach_date = row30.attach_date;
								delete_dc_storage_connection_tmp.detach_date = context.runTime;
								delete_dc_storage_connection = delete_dc_storage_connection_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_22 = false;

						tos_count_tMap_22++;

						/**
						 * [tMap_22 main ] stop
						 */
						// Start of branch "delete_dc_storage_connection"
						if (delete_dc_storage_connection != null) {

							/**
							 * [tJDBCOutput_24 main ] start
							 */

							currentComponent = "tJDBCOutput_24";

							whetherReject_tJDBCOutput_24 = false;
							if (delete_dc_storage_connection.detach_date != null) {
								pstmt_tJDBCOutput_24
										.setTimestamp(
												1,
												new java.sql.Timestamp(
														delete_dc_storage_connection.detach_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_24.setNull(1,
										java.sql.Types.DATE);
							}

							if (delete_dc_storage_connection.storage_domain_id == null) {
								pstmt_tJDBCOutput_24.setNull(2,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_24
										.setObject(
												2,
												delete_dc_storage_connection.storage_domain_id);
							}

							if (delete_dc_storage_connection.datacenter_id == null) {
								pstmt_tJDBCOutput_24.setNull(3,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_24
										.setObject(
												3,
												delete_dc_storage_connection.datacenter_id);
							}

							if (delete_dc_storage_connection.attach_date != null) {
								pstmt_tJDBCOutput_24
										.setTimestamp(
												4,
												new java.sql.Timestamp(
														delete_dc_storage_connection.attach_date
																.getTime()));
							} else {
								pstmt_tJDBCOutput_24.setNull(4,
										java.sql.Types.DATE);
							}

							try {
								updatedCount_tJDBCOutput_24 = updatedCount_tJDBCOutput_24
										+ pstmt_tJDBCOutput_24.executeUpdate();
								nb_line_tJDBCOutput_24++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_24 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_24++;

							/**
							 * [tJDBCOutput_24 main ] stop
							 */

						} // End of branch "delete_dc_storage_connection"

						/**
						 * [tJDBCInput_34 end ] start
						 */

						currentComponent = "tJDBCInput_34";

					}
				} finally {
					if (rs_tJDBCInput_34 != null) {
						rs_tJDBCInput_34.close();
					}
					stmt_tJDBCInput_34.close();

				}
				globalMap.put("tJDBCInput_34_NB_LINE", nb_line_tJDBCInput_34);

				ok_Hash.put("tJDBCInput_34", true);
				end_Hash.put("tJDBCInput_34", System.currentTimeMillis());

				/**
				 * [tJDBCInput_34 end ] stop
				 */

				/**
				 * [tMap_22 end ] start
				 */

				currentComponent = "tMap_22";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row32 != null) {
					tHash_Lookup_row32.endGet();
				}
				globalMap.remove("tHash_Lookup_row32");

				// ###############################

				ok_Hash.put("tMap_22", true);
				end_Hash.put("tMap_22", System.currentTimeMillis());

				/**
				 * [tMap_22 end ] stop
				 */

				/**
				 * [tJDBCOutput_24 end ] start
				 */

				currentComponent = "tJDBCOutput_24";

				if (pstmt_tJDBCOutput_24 != null) {

					pstmt_tJDBCOutput_24.close();

				}

				nb_line_deleted_tJDBCOutput_24 = nb_line_deleted_tJDBCOutput_24
						+ deletedCount_tJDBCOutput_24;
				nb_line_update_tJDBCOutput_24 = nb_line_update_tJDBCOutput_24
						+ updatedCount_tJDBCOutput_24;
				nb_line_inserted_tJDBCOutput_24 = nb_line_inserted_tJDBCOutput_24
						+ insertedCount_tJDBCOutput_24;
				nb_line_rejected_tJDBCOutput_24 = nb_line_rejected_tJDBCOutput_24
						+ rejectedCount_tJDBCOutput_24;

				globalMap.put("tJDBCOutput_24_NB_LINE", nb_line_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_24);

				ok_Hash.put("tJDBCOutput_24", true);
				end_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_24 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_34:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_4Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_22"
			globalMap.remove("tHash_Lookup_row32");

			try {

				/**
				 * [tJDBCInput_34 finally ] start
				 */

				currentComponent = "tJDBCInput_34";

				/**
				 * [tJDBCInput_34 finally ] stop
				 */

				/**
				 * [tMap_22 finally ] start
				 */

				currentComponent = "tMap_22";

				/**
				 * [tMap_22 finally ] stop
				 */

				/**
				 * [tJDBCOutput_24 finally ] start
				 */

				currentComponent = "tJDBCOutput_24";

				/**
				 * [tJDBCOutput_24 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_34_SUBPROCESS_STATE", 1);
	}

	public static class host_configurationStruct implements
			routines.system.IPersistableRow<host_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public short host_type;

		public short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public int vdsm_port;

		public int getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.host_type = dis.readShort();

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = dis.readInt();

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// short

				dos.writeShort(this.host_type);

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// int

				dos.writeInt(this.vdsm_port);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(host_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row7Struct implements
			routines.system.IPersistableRow<row7Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row7Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_4Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_40Process(globalMap);

				row7Struct row7 = new row7Struct();
				host_configurationStruct host_configuration = new host_configurationStruct();

				/**
				 * [tJDBCOutput_4 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_4", false);
				start_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_4";

				int tos_count_tJDBCOutput_4 = 0;

				int nb_line_tJDBCOutput_4 = 0;
				int nb_line_update_tJDBCOutput_4 = 0;
				int nb_line_inserted_tJDBCOutput_4 = 0;
				int nb_line_deleted_tJDBCOutput_4 = 0;
				int nb_line_rejected_tJDBCOutput_4 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_4 = 0;

				int deletedCount_tJDBCOutput_4 = 0;
				int updatedCount_tJDBCOutput_4 = 0;
				int insertedCount_tJDBCOutput_4 = 0;
				int rejectedCount_tJDBCOutput_4 = 0;

				boolean whetherReject_tJDBCOutput_4 = false;

				java.sql.Connection connection_tJDBCOutput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_4 = "INSERT INTO "
						+ "host_configuration"
						+ " (host_id,host_unique_id,host_name,cluster_id,host_type,fqdn_or_ip,memory_size_mb,swap_size_mb,cpu_model,number_of_cores,number_of_sockets,cpu_speed_mh,host_os,kernel_version,kvm_version,vdsm_version,vdsm_port,cluster_configuration_version,create_date,update_date,delete_date,threads_per_core,hardware_manufacturer,hardware_product_name,hardware_version,hardware_serial_number) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_4 = connection_tJDBCOutput_4
						.prepareStatement(insert_tJDBCOutput_4);

				/**
				 * [tJDBCOutput_4 begin ] stop
				 */

				/**
				 * [tMap_4 begin ] start
				 */

				ok_Hash.put("tMap_4", false);
				start_Hash.put("tMap_4", System.currentTimeMillis());

				currentComponent = "tMap_4";

				int tos_count_tMap_4 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row36Struct> tHash_Lookup_row36 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row36Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row36Struct>) globalMap
						.get("tHash_Lookup_row36"));

				row36Struct row36HashKey = new row36Struct();
				row36Struct row36Default = new row36Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_4__Struct {
				}
				Var__tMap_4__Struct Var__tMap_4 = new Var__tMap_4__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				host_configurationStruct host_configuration_tmp = new host_configurationStruct();
				// ###############################

				/**
				 * [tMap_4 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT \n  host_id, \n  host_unique_id, \n  host_name, \n  cluster_id,\n  upper(cast(cluster_id as char(36))) as cluster_join_id,  \n  host_type, \n  fqdn_or_ip, \n  memory_size_mb, \n  swap_size_mb, \n  cpu_model,\n  number_of_cores, \n  number_of_sockets,\n  cpu_speed_mh,\n  host_os, \n  kernel_version, \n  kvm_version, \n  vdsm_version, \n  vdsm_port,\n  threads_per_core,\n  hardware_manufacturer,\n  hardware_product_name,\n  hardware_version,\n  hardware_serial_number, \n  create_date, \n  update_date\nFROM dwh_host_configuration_history_view";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);

				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						if (colQtyInRs_tJDBCInput_4 < 1) {
							row7.host_id = null;
						} else {

							if (rs_tJDBCInput_4.getObject(1) != null) {
								row7.host_id = rs_tJDBCInput_4.getObject(1);
							} else {
								row7.host_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 2) {
							row7.host_unique_id = null;
						} else {

							row7.host_unique_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 2, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 3) {
							row7.host_name = null;
						} else {

							row7.host_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 3, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 4) {
							row7.cluster_id = null;
						} else {

							if (rs_tJDBCInput_4.getObject(4) != null) {
								row7.cluster_id = rs_tJDBCInput_4.getObject(4);
							} else {
								row7.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 5) {
							row7.cluster_join_id = null;
						} else {

							row7.cluster_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 5, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 6) {
							row7.host_type = null;
						} else {

							if (rs_tJDBCInput_4.getObject(6) != null) {
								row7.host_type = rs_tJDBCInput_4.getShort(6);
							} else {
								row7.host_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 7) {
							row7.fqdn_or_ip = null;
						} else {

							row7.fqdn_or_ip = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 7, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 8) {
							row7.memory_size_mb = null;
						} else {

							if (rs_tJDBCInput_4.getObject(8) != null) {
								row7.memory_size_mb = rs_tJDBCInput_4.getInt(8);
							} else {
								row7.memory_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 9) {
							row7.swap_size_mb = null;
						} else {

							if (rs_tJDBCInput_4.getObject(9) != null) {
								row7.swap_size_mb = rs_tJDBCInput_4.getInt(9);
							} else {
								row7.swap_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 10) {
							row7.cpu_model = null;
						} else {

							row7.cpu_model = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 10, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 11) {
							row7.number_of_cores = null;
						} else {

							if (rs_tJDBCInput_4.getObject(11) != null) {
								row7.number_of_cores = rs_tJDBCInput_4
										.getShort(11);
							} else {
								row7.number_of_cores = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 12) {
							row7.number_of_sockets = null;
						} else {

							if (rs_tJDBCInput_4.getObject(12) != null) {
								row7.number_of_sockets = rs_tJDBCInput_4
										.getShort(12);
							} else {
								row7.number_of_sockets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 13) {
							row7.cpu_speed_mh = null;
						} else {

							if (rs_tJDBCInput_4.getObject(13) != null) {
								row7.cpu_speed_mh = rs_tJDBCInput_4
										.getDouble(13);
							} else {
								row7.cpu_speed_mh = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 14) {
							row7.host_os = null;
						} else {

							row7.host_os = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_4, 14, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 15) {
							row7.kernel_version = null;
						} else {

							row7.kernel_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 15, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 16) {
							row7.kvm_version = null;
						} else {

							row7.kvm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 16, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 17) {
							row7.vdsm_version = null;
						} else {

							row7.vdsm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 17, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 18) {
							row7.vdsm_port = null;
						} else {

							if (rs_tJDBCInput_4.getObject(18) != null) {
								row7.vdsm_port = rs_tJDBCInput_4.getInt(18);
							} else {
								row7.vdsm_port = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 19) {
							row7.threads_per_core = null;
						} else {

							if (rs_tJDBCInput_4.getObject(19) != null) {
								row7.threads_per_core = rs_tJDBCInput_4
										.getShort(19);
							} else {
								row7.threads_per_core = null;
							}
						}
						if (colQtyInRs_tJDBCInput_4 < 20) {
							row7.hardware_manufacturer = null;
						} else {

							row7.hardware_manufacturer = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 20, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 21) {
							row7.hardware_product_name = null;
						} else {

							row7.hardware_product_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 21, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 22) {
							row7.hardware_version = null;
						} else {

							row7.hardware_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 22, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 23) {
							row7.hardware_serial_number = null;
						} else {

							row7.hardware_serial_number = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_4, 23, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 24) {
							row7.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_4 = null;
							try {
								date_tJDBCInput_4 = rs_tJDBCInput_4
										.getTimestamp(24);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_4 = rs_tJDBCInput_4.getDate(24);
							}
							row7.create_date = date_tJDBCInput_4;
						}
						if (colQtyInRs_tJDBCInput_4 < 25) {
							row7.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_4 = null;
							try {
								date_tJDBCInput_4 = rs_tJDBCInput_4
										.getTimestamp(25);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_4 = rs_tJDBCInput_4.getDate(25);
							}
							row7.update_date = date_tJDBCInput_4;
						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */

						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tMap_4 main ] start
						 */

						currentComponent = "tMap_4";

						boolean hasCasePrimitiveKeyWithNull_tMap_4 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_4 = false;
						boolean mainRowRejected_tMap_4 = false;

						if (

						(

						row7.update_date == null ? TalendDate.compareDate(
								row7.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row7.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row7'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row36"
							// /////////////////////////////////////////////

							boolean forceLooprow36 = false;

							row36Struct row36ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_4) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_4 = false;

								row36HashKey.cluster_join_id = row7.cluster_join_id;

								row36HashKey.hashCodeDirty = true;

								tHash_Lookup_row36.lookup(row36HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row36 != null
									&& tHash_Lookup_row36
											.getCount(row36HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row36' and it contains more one result from keys :  row36.cluster_join_id = '"
								// + row36HashKey.cluster_join_id + "'");
							} // G 071

							row36Struct row36 = null;

							row36Struct fromLookup_row36 = null;
							row36 = row36Default;

							if (tHash_Lookup_row36 != null
									&& tHash_Lookup_row36.hasNext()) { // G 099

								fromLookup_row36 = tHash_Lookup_row36.next();

							} // G 099

							if (fromLookup_row36 != null) {
								row36 = fromLookup_row36;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_4__Struct Var = Var__tMap_4;// ###############################
								// ###############################
								// # Output tables

								host_configuration = null;

								// # Output table : 'host_configuration'
								host_configuration_tmp.host_id = row7.host_id;
								host_configuration_tmp.host_unique_id = StringHandling
										.TRIM(row7.host_unique_id);
								host_configuration_tmp.host_name = StringHandling
										.TRIM(row7.host_name);
								host_configuration_tmp.cluster_id = row7.cluster_id;
								host_configuration_tmp.host_type = row7.host_type;
								host_configuration_tmp.fqdn_or_ip = StringHandling
										.TRIM(row7.fqdn_or_ip);
								host_configuration_tmp.memory_size_mb = row7.memory_size_mb;
								host_configuration_tmp.swap_size_mb = row7.swap_size_mb;
								host_configuration_tmp.cpu_model = StringHandling
										.TRIM(row7.cpu_model);
								host_configuration_tmp.number_of_cores = row7.number_of_cores;
								host_configuration_tmp.number_of_sockets = row7.number_of_sockets;
								host_configuration_tmp.cpu_speed_mh = row7.cpu_speed_mh;
								host_configuration_tmp.host_os = StringHandling
										.TRIM(row7.host_os);
								host_configuration_tmp.kernel_version = StringHandling
										.TRIM(row7.kernel_version);
								host_configuration_tmp.kvm_version = StringHandling
										.TRIM(row7.kvm_version);
								host_configuration_tmp.vdsm_version = StringHandling
										.TRIM(row7.vdsm_version);
								host_configuration_tmp.vdsm_port = row7.vdsm_port;
								host_configuration_tmp.cluster_configuration_version = row36.history_id;
								host_configuration_tmp.create_date = row7.create_date;
								host_configuration_tmp.update_date = row7.update_date;
								host_configuration_tmp.delete_date = null;
								host_configuration_tmp.threads_per_core = row7.threads_per_core;
								host_configuration_tmp.hardware_manufacturer = StringHandling
										.TRIM(row7.hardware_manufacturer);
								host_configuration_tmp.hardware_product_name = StringHandling
										.TRIM(row7.hardware_product_name);
								host_configuration_tmp.hardware_version = StringHandling
										.TRIM(row7.hardware_version);
								host_configuration_tmp.hardware_serial_number = StringHandling
										.TRIM(row7.hardware_serial_number);
								host_configuration = host_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_4 = false;

							tos_count_tMap_4++;

							/**
							 * [tMap_4 main ] stop
							 */
							// Start of branch "host_configuration"
							if (host_configuration != null) {

								/**
								 * [tJDBCOutput_4 main ] start
								 */

								currentComponent = "tJDBCOutput_4";

								whetherReject_tJDBCOutput_4 = false;
								if (host_configuration.host_id == null) {
									pstmt_tJDBCOutput_4.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_4.setObject(1,
											host_configuration.host_id);
								}

								if (host_configuration.host_unique_id == null) {
									pstmt_tJDBCOutput_4.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(2,
											host_configuration.host_unique_id);
								}

								if (host_configuration.host_name == null) {
									pstmt_tJDBCOutput_4.setNull(3,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(3,
											host_configuration.host_name);
								}

								if (host_configuration.cluster_id == null) {
									pstmt_tJDBCOutput_4.setNull(4,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_4.setObject(4,
											host_configuration.cluster_id);
								}

								pstmt_tJDBCOutput_4.setShort(5,
										host_configuration.host_type);

								if (host_configuration.fqdn_or_ip == null) {
									pstmt_tJDBCOutput_4.setNull(6,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(6,
											host_configuration.fqdn_or_ip);
								}

								if (host_configuration.memory_size_mb == null) {
									pstmt_tJDBCOutput_4.setNull(7,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_4.setInt(7,
											host_configuration.memory_size_mb);
								}

								if (host_configuration.swap_size_mb == null) {
									pstmt_tJDBCOutput_4.setNull(8,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_4.setInt(8,
											host_configuration.swap_size_mb);
								}

								if (host_configuration.cpu_model == null) {
									pstmt_tJDBCOutput_4.setNull(9,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(9,
											host_configuration.cpu_model);
								}

								if (host_configuration.number_of_cores == null) {
									pstmt_tJDBCOutput_4.setNull(10,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_4.setShort(10,
											host_configuration.number_of_cores);
								}

								if (host_configuration.number_of_sockets == null) {
									pstmt_tJDBCOutput_4.setNull(11,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_4
											.setShort(
													11,
													host_configuration.number_of_sockets);
								}

								if (host_configuration.cpu_speed_mh == null) {
									pstmt_tJDBCOutput_4.setNull(12,
											java.sql.Types.DOUBLE);
								} else {
									pstmt_tJDBCOutput_4.setDouble(12,
											host_configuration.cpu_speed_mh);
								}

								if (host_configuration.host_os == null) {
									pstmt_tJDBCOutput_4.setNull(13,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(13,
											host_configuration.host_os);
								}

								if (host_configuration.kernel_version == null) {
									pstmt_tJDBCOutput_4.setNull(14,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(14,
											host_configuration.kernel_version);
								}

								if (host_configuration.kvm_version == null) {
									pstmt_tJDBCOutput_4.setNull(15,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(15,
											host_configuration.kvm_version);
								}

								if (host_configuration.vdsm_version == null) {
									pstmt_tJDBCOutput_4.setNull(16,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4.setString(16,
											host_configuration.vdsm_version);
								}

								pstmt_tJDBCOutput_4.setInt(17,
										host_configuration.vdsm_port);

								if (host_configuration.cluster_configuration_version == null) {
									pstmt_tJDBCOutput_4.setNull(18,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_4
											.setInt(18,
													host_configuration.cluster_configuration_version);
								}

								if (host_configuration.create_date != null) {
									pstmt_tJDBCOutput_4
											.setTimestamp(
													19,
													new java.sql.Timestamp(
															host_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_4.setNull(19,
											java.sql.Types.DATE);
								}

								if (host_configuration.update_date != null) {
									pstmt_tJDBCOutput_4
											.setTimestamp(
													20,
													new java.sql.Timestamp(
															host_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_4.setNull(20,
											java.sql.Types.DATE);
								}

								if (host_configuration.delete_date != null) {
									pstmt_tJDBCOutput_4
											.setTimestamp(
													21,
													new java.sql.Timestamp(
															host_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_4.setNull(21,
											java.sql.Types.DATE);
								}

								if (host_configuration.threads_per_core == null) {
									pstmt_tJDBCOutput_4.setNull(22,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_4
											.setShort(
													22,
													host_configuration.threads_per_core);
								}

								if (host_configuration.hardware_manufacturer == null) {
									pstmt_tJDBCOutput_4.setNull(23,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4
											.setString(
													23,
													host_configuration.hardware_manufacturer);
								}

								if (host_configuration.hardware_product_name == null) {
									pstmt_tJDBCOutput_4.setNull(24,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4
											.setString(
													24,
													host_configuration.hardware_product_name);
								}

								if (host_configuration.hardware_version == null) {
									pstmt_tJDBCOutput_4.setNull(25,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4
											.setString(
													25,
													host_configuration.hardware_version);
								}

								if (host_configuration.hardware_serial_number == null) {
									pstmt_tJDBCOutput_4.setNull(26,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_4
											.setString(
													26,
													host_configuration.hardware_serial_number);
								}

								try {
									insertedCount_tJDBCOutput_4 = insertedCount_tJDBCOutput_4
											+ pstmt_tJDBCOutput_4
													.executeUpdate();
									nb_line_tJDBCOutput_4++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_4 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_4++;

								/**
								 * [tJDBCOutput_4 main ] stop
								 */

							} // End of branch "host_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row7'

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					if (rs_tJDBCInput_4 != null) {
						rs_tJDBCInput_4.close();
					}
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tMap_4 end ] start
				 */

				currentComponent = "tMap_4";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row36 != null) {
					tHash_Lookup_row36.endGet();
				}
				globalMap.remove("tHash_Lookup_row36");

				// ###############################

				ok_Hash.put("tMap_4", true);
				end_Hash.put("tMap_4", System.currentTimeMillis());

				/**
				 * [tMap_4 end ] stop
				 */

				/**
				 * [tJDBCOutput_4 end ] start
				 */

				currentComponent = "tJDBCOutput_4";

				if (pstmt_tJDBCOutput_4 != null) {

					pstmt_tJDBCOutput_4.close();

				}

				nb_line_deleted_tJDBCOutput_4 = nb_line_deleted_tJDBCOutput_4
						+ deletedCount_tJDBCOutput_4;
				nb_line_update_tJDBCOutput_4 = nb_line_update_tJDBCOutput_4
						+ updatedCount_tJDBCOutput_4;
				nb_line_inserted_tJDBCOutput_4 = nb_line_inserted_tJDBCOutput_4
						+ insertedCount_tJDBCOutput_4;
				nb_line_rejected_tJDBCOutput_4 = nb_line_rejected_tJDBCOutput_4
						+ rejectedCount_tJDBCOutput_4;

				globalMap.put("tJDBCOutput_4_NB_LINE", nb_line_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_4);

				ok_Hash.put("tJDBCOutput_4", true);
				end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_4 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_4:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_22Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_4"
			globalMap.remove("tHash_Lookup_row36");

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tMap_4 finally ] start
				 */

				currentComponent = "tMap_4";

				/**
				 * [tMap_4 finally ] stop
				 */

				/**
				 * [tJDBCOutput_4 finally ] start
				 */

				currentComponent = "tJDBCOutput_4";

				/**
				 * [tJDBCOutput_4 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class delete_hostsStruct implements
			routines.system.IPersistableRow<delete_hostsStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public short host_type;

		public short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public int vdsm_port;

		public int getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.host_type = dis.readShort();

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = dis.readInt();

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// short

				dos.writeShort(this.host_type);

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// int

				dos.writeInt(this.vdsm_port);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_hostsStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row21Struct implements
			routines.system.IPersistableRow<row21Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row21Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_22Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_22Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_22Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_22Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_21Process(globalMap);

				row21Struct row21 = new row21Struct();
				delete_hostsStruct delete_hosts = new delete_hostsStruct();

				/**
				 * [tJDBCOutput_17 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_17", false);
				start_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_17";

				int tos_count_tJDBCOutput_17 = 0;

				int nb_line_tJDBCOutput_17 = 0;
				int nb_line_update_tJDBCOutput_17 = 0;
				int nb_line_inserted_tJDBCOutput_17 = 0;
				int nb_line_deleted_tJDBCOutput_17 = 0;
				int nb_line_rejected_tJDBCOutput_17 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_17 = 0;

				int deletedCount_tJDBCOutput_17 = 0;
				int updatedCount_tJDBCOutput_17 = 0;
				int insertedCount_tJDBCOutput_17 = 0;
				int rejectedCount_tJDBCOutput_17 = 0;

				boolean whetherReject_tJDBCOutput_17 = false;

				java.sql.Connection connection_tJDBCOutput_17 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_17 = "INSERT INTO "
						+ "host_configuration"
						+ " (host_id,host_unique_id,host_name,cluster_id,host_type,fqdn_or_ip,memory_size_mb,swap_size_mb,cpu_model,number_of_cores,number_of_sockets,cpu_speed_mh,host_os,kernel_version,kvm_version,vdsm_version,vdsm_port,cluster_configuration_version,create_date,update_date,delete_date,threads_per_core,hardware_manufacturer,hardware_product_name,hardware_version,hardware_serial_number) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_17 = connection_tJDBCOutput_17
						.prepareStatement(insert_tJDBCOutput_17);

				/**
				 * [tJDBCOutput_17 begin ] stop
				 */

				/**
				 * [tMap_17 begin ] start
				 */

				ok_Hash.put("tMap_17", false);
				start_Hash.put("tMap_17", System.currentTimeMillis());

				currentComponent = "tMap_17";

				int tos_count_tMap_17 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row20Struct> tHash_Lookup_row20 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row20Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row20Struct>) globalMap
						.get("tHash_Lookup_row20"));

				row20Struct row20HashKey = new row20Struct();
				row20Struct row20Default = new row20Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_17__Struct {
				}
				Var__tMap_17__Struct Var__tMap_17 = new Var__tMap_17__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_hostsStruct delete_hosts_tmp = new delete_hostsStruct();
				// ###############################

				/**
				 * [tMap_17 begin ] stop
				 */

				/**
				 * [tJDBCInput_22 begin ] start
				 */

				ok_Hash.put("tJDBCInput_22", false);
				start_Hash.put("tJDBCInput_22", System.currentTimeMillis());

				currentComponent = "tJDBCInput_22";

				int tos_count_tJDBCInput_22 = 0;

				int nb_line_tJDBCInput_22 = 0;
				java.sql.Connection conn_tJDBCInput_22 = null;
				conn_tJDBCInput_22 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_22 = conn_tJDBCInput_22
						.createStatement();

				String dbquery_tJDBCInput_22 = "SELECT history_id, \n		host_id, \n		upper(cast(host_id as char(36))) as host_join_id,\n		host_unique_id, \n		host_name, \n		cluster_id, \n		host_type, \n		fqdn_or_ip, \n		memory_size_mb, \n		swap_size_mb,\n		cpu_model, \n		number_of_cores, \n        number_of_sockets,\n        cpu_speed_mh,\n		host_os,\n		kernel_version, \n		kvm_version, \n		vdsm_version, \n		vdsm_port, \n        threads_per_core,\n        hardware_manufacturer,\n        hardware_product_name,\n        hardware_version,\n        hardware_serial_number,\n		cluster_configuration_version, \n		create_date, \n		update_date\nFROM v4_4_latest_configuration_hosts";

				globalMap.put("tJDBCInput_22_QUERY", dbquery_tJDBCInput_22);

				java.sql.ResultSet rs_tJDBCInput_22 = null;
				try {
					rs_tJDBCInput_22 = stmt_tJDBCInput_22
							.executeQuery(dbquery_tJDBCInput_22);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_22 = rs_tJDBCInput_22
							.getMetaData();
					int colQtyInRs_tJDBCInput_22 = rsmd_tJDBCInput_22
							.getColumnCount();

					String tmpContent_tJDBCInput_22 = null;

					while (rs_tJDBCInput_22.next()) {
						nb_line_tJDBCInput_22++;

						if (colQtyInRs_tJDBCInput_22 < 1) {
							row21.history_id = null;
						} else {

							if (rs_tJDBCInput_22.getObject(1) != null) {
								row21.history_id = rs_tJDBCInput_22.getInt(1);
							} else {
								row21.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 2) {
							row21.host_id = null;
						} else {

							if (rs_tJDBCInput_22.getObject(2) != null) {
								row21.host_id = rs_tJDBCInput_22.getObject(2);
							} else {
								row21.host_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 3) {
							row21.host_join_id = null;
						} else {

							row21.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 3, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 4) {
							row21.host_unique_id = null;
						} else {

							row21.host_unique_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 4, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 5) {
							row21.host_name = null;
						} else {

							row21.host_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 5, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 6) {
							row21.cluster_id = null;
						} else {

							if (rs_tJDBCInput_22.getObject(6) != null) {
								row21.cluster_id = rs_tJDBCInput_22
										.getObject(6);
							} else {
								row21.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 7) {
							row21.host_type = null;
						} else {

							if (rs_tJDBCInput_22.getObject(7) != null) {
								row21.host_type = rs_tJDBCInput_22.getShort(7);
							} else {
								row21.host_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 8) {
							row21.fqdn_or_ip = null;
						} else {

							row21.fqdn_or_ip = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 8, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 9) {
							row21.memory_size_mb = null;
						} else {

							if (rs_tJDBCInput_22.getObject(9) != null) {
								row21.memory_size_mb = rs_tJDBCInput_22
										.getInt(9);
							} else {
								row21.memory_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 10) {
							row21.swap_size_mb = null;
						} else {

							if (rs_tJDBCInput_22.getObject(10) != null) {
								row21.swap_size_mb = rs_tJDBCInput_22
										.getInt(10);
							} else {
								row21.swap_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 11) {
							row21.cpu_model = null;
						} else {

							row21.cpu_model = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 11, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 12) {
							row21.number_of_cores = null;
						} else {

							if (rs_tJDBCInput_22.getObject(12) != null) {
								row21.number_of_cores = rs_tJDBCInput_22
										.getShort(12);
							} else {
								row21.number_of_cores = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 13) {
							row21.number_of_sockets = null;
						} else {

							if (rs_tJDBCInput_22.getObject(13) != null) {
								row21.number_of_sockets = rs_tJDBCInput_22
										.getShort(13);
							} else {
								row21.number_of_sockets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 14) {
							row21.cpu_speed_mh = null;
						} else {

							if (rs_tJDBCInput_22.getObject(14) != null) {
								row21.cpu_speed_mh = rs_tJDBCInput_22
										.getDouble(14);
							} else {
								row21.cpu_speed_mh = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 15) {
							row21.host_os = null;
						} else {

							row21.host_os = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_22, 15, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 16) {
							row21.kernel_version = null;
						} else {

							row21.kernel_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 16, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 17) {
							row21.kvm_version = null;
						} else {

							row21.kvm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 17, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 18) {
							row21.vdsm_version = null;
						} else {

							row21.vdsm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 18, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 19) {
							row21.vdsm_port = null;
						} else {

							if (rs_tJDBCInput_22.getObject(19) != null) {
								row21.vdsm_port = rs_tJDBCInput_22.getInt(19);
							} else {
								row21.vdsm_port = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 20) {
							row21.threads_per_core = null;
						} else {

							if (rs_tJDBCInput_22.getObject(20) != null) {
								row21.threads_per_core = rs_tJDBCInput_22
										.getShort(20);
							} else {
								row21.threads_per_core = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 21) {
							row21.hardware_manufacturer = null;
						} else {

							row21.hardware_manufacturer = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 21, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 22) {
							row21.hardware_product_name = null;
						} else {

							row21.hardware_product_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 22, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 23) {
							row21.hardware_version = null;
						} else {

							row21.hardware_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 23, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 24) {
							row21.hardware_serial_number = null;
						} else {

							row21.hardware_serial_number = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_22, 24, false);
						}
						if (colQtyInRs_tJDBCInput_22 < 25) {
							row21.cluster_configuration_version = null;
						} else {

							if (rs_tJDBCInput_22.getObject(25) != null) {
								row21.cluster_configuration_version = rs_tJDBCInput_22
										.getInt(25);
							} else {
								row21.cluster_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_22 < 26) {
							row21.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_22 = null;
							try {
								date_tJDBCInput_22 = rs_tJDBCInput_22
										.getTimestamp(26);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_22 = rs_tJDBCInput_22
										.getDate(26);
							}
							row21.create_date = date_tJDBCInput_22;
						}
						if (colQtyInRs_tJDBCInput_22 < 27) {
							row21.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_22 = null;
							try {
								date_tJDBCInput_22 = rs_tJDBCInput_22
										.getTimestamp(27);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_22 = rs_tJDBCInput_22
										.getDate(27);
							}
							row21.update_date = date_tJDBCInput_22;
						}

						/**
						 * [tJDBCInput_22 begin ] stop
						 */

						/**
						 * [tJDBCInput_22 main ] start
						 */

						currentComponent = "tJDBCInput_22";

						tos_count_tJDBCInput_22++;

						/**
						 * [tJDBCInput_22 main ] stop
						 */

						/**
						 * [tMap_17 main ] start
						 */

						currentComponent = "tMap_17";

						boolean hasCasePrimitiveKeyWithNull_tMap_17 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_17 = false;
						boolean mainRowRejected_tMap_17 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row20"
						// /////////////////////////////////////////////

						boolean forceLooprow20 = false;

						row20Struct row20ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_17) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_17 = false;

							row20HashKey.host_join_id = row21.host_join_id;

							row20HashKey.hashCodeDirty = true;

							tHash_Lookup_row20.lookup(row20HashKey);

							if (!tHash_Lookup_row20.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_17 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row20 != null
								&& tHash_Lookup_row20.getCount(row20HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row20' and it contains more one result from keys :  row20.host_join_id = '"
							// + row20HashKey.host_join_id + "'");
						} // G 071

						row20Struct row20 = null;

						row20Struct fromLookup_row20 = null;
						row20 = row20Default;

						if (tHash_Lookup_row20 != null
								&& tHash_Lookup_row20.hasNext()) { // G 099

							fromLookup_row20 = tHash_Lookup_row20.next();

						} // G 099

						if (fromLookup_row20 != null) {
							row20 = fromLookup_row20;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_17__Struct Var = Var__tMap_17;// ###############################
							// ###############################
							// # Output tables

							delete_hosts = null;

							if (!rejectedInnerJoin_tMap_17) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_hosts'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_17) {
								delete_hosts_tmp.host_id = row21.host_id;
								delete_hosts_tmp.host_unique_id = row21.host_unique_id;
								delete_hosts_tmp.host_name = row21.host_name;
								delete_hosts_tmp.cluster_id = row21.cluster_id;
								delete_hosts_tmp.host_type = row21.host_type;
								delete_hosts_tmp.fqdn_or_ip = row21.fqdn_or_ip;
								delete_hosts_tmp.memory_size_mb = row21.memory_size_mb;
								delete_hosts_tmp.swap_size_mb = row21.swap_size_mb;
								delete_hosts_tmp.cpu_model = row21.cpu_model;
								delete_hosts_tmp.number_of_cores = row21.number_of_cores;
								delete_hosts_tmp.number_of_sockets = row21.number_of_sockets;
								delete_hosts_tmp.cpu_speed_mh = row21.cpu_speed_mh;
								delete_hosts_tmp.host_os = row21.host_os;
								delete_hosts_tmp.kernel_version = row21.kernel_version;
								delete_hosts_tmp.kvm_version = row21.kvm_version;
								delete_hosts_tmp.vdsm_version = row21.vdsm_version;
								delete_hosts_tmp.vdsm_port = row21.vdsm_port;
								delete_hosts_tmp.cluster_configuration_version = row21.cluster_configuration_version;
								delete_hosts_tmp.create_date = row21.create_date;
								delete_hosts_tmp.update_date = context.runTime;
								delete_hosts_tmp.delete_date = context.runTime;
								delete_hosts_tmp.threads_per_core = row21.threads_per_core;
								delete_hosts_tmp.hardware_manufacturer = row21.hardware_manufacturer;
								delete_hosts_tmp.hardware_product_name = row21.hardware_product_name;
								delete_hosts_tmp.hardware_version = row21.hardware_version;
								delete_hosts_tmp.hardware_serial_number = row21.hardware_serial_number;
								delete_hosts = delete_hosts_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_17 = false;

						tos_count_tMap_17++;

						/**
						 * [tMap_17 main ] stop
						 */
						// Start of branch "delete_hosts"
						if (delete_hosts != null) {

							/**
							 * [tJDBCOutput_17 main ] start
							 */

							currentComponent = "tJDBCOutput_17";

							whetherReject_tJDBCOutput_17 = false;
							if (delete_hosts.host_id == null) {
								pstmt_tJDBCOutput_17.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_17.setObject(1,
										delete_hosts.host_id);
							}

							if (delete_hosts.host_unique_id == null) {
								pstmt_tJDBCOutput_17.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(2,
										delete_hosts.host_unique_id);
							}

							if (delete_hosts.host_name == null) {
								pstmt_tJDBCOutput_17.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(3,
										delete_hosts.host_name);
							}

							if (delete_hosts.cluster_id == null) {
								pstmt_tJDBCOutput_17.setNull(4,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_17.setObject(4,
										delete_hosts.cluster_id);
							}

							pstmt_tJDBCOutput_17.setShort(5,
									delete_hosts.host_type);

							if (delete_hosts.fqdn_or_ip == null) {
								pstmt_tJDBCOutput_17.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(6,
										delete_hosts.fqdn_or_ip);
							}

							if (delete_hosts.memory_size_mb == null) {
								pstmt_tJDBCOutput_17.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_17.setInt(7,
										delete_hosts.memory_size_mb);
							}

							if (delete_hosts.swap_size_mb == null) {
								pstmt_tJDBCOutput_17.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_17.setInt(8,
										delete_hosts.swap_size_mb);
							}

							if (delete_hosts.cpu_model == null) {
								pstmt_tJDBCOutput_17.setNull(9,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(9,
										delete_hosts.cpu_model);
							}

							if (delete_hosts.number_of_cores == null) {
								pstmt_tJDBCOutput_17.setNull(10,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_17.setShort(10,
										delete_hosts.number_of_cores);
							}

							if (delete_hosts.number_of_sockets == null) {
								pstmt_tJDBCOutput_17.setNull(11,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_17.setShort(11,
										delete_hosts.number_of_sockets);
							}

							if (delete_hosts.cpu_speed_mh == null) {
								pstmt_tJDBCOutput_17.setNull(12,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_17.setDouble(12,
										delete_hosts.cpu_speed_mh);
							}

							if (delete_hosts.host_os == null) {
								pstmt_tJDBCOutput_17.setNull(13,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(13,
										delete_hosts.host_os);
							}

							if (delete_hosts.kernel_version == null) {
								pstmt_tJDBCOutput_17.setNull(14,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(14,
										delete_hosts.kernel_version);
							}

							if (delete_hosts.kvm_version == null) {
								pstmt_tJDBCOutput_17.setNull(15,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(15,
										delete_hosts.kvm_version);
							}

							if (delete_hosts.vdsm_version == null) {
								pstmt_tJDBCOutput_17.setNull(16,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(16,
										delete_hosts.vdsm_version);
							}

							pstmt_tJDBCOutput_17.setInt(17,
									delete_hosts.vdsm_port);

							if (delete_hosts.cluster_configuration_version == null) {
								pstmt_tJDBCOutput_17.setNull(18,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_17
										.setInt(18,
												delete_hosts.cluster_configuration_version);
							}

							if (delete_hosts.create_date != null) {
								pstmt_tJDBCOutput_17.setTimestamp(
										19,
										new java.sql.Timestamp(
												delete_hosts.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_17.setNull(19,
										java.sql.Types.DATE);
							}

							if (delete_hosts.update_date != null) {
								pstmt_tJDBCOutput_17.setTimestamp(
										20,
										new java.sql.Timestamp(
												delete_hosts.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_17.setNull(20,
										java.sql.Types.DATE);
							}

							if (delete_hosts.delete_date != null) {
								pstmt_tJDBCOutput_17.setTimestamp(
										21,
										new java.sql.Timestamp(
												delete_hosts.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_17.setNull(21,
										java.sql.Types.DATE);
							}

							if (delete_hosts.threads_per_core == null) {
								pstmt_tJDBCOutput_17.setNull(22,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_17.setShort(22,
										delete_hosts.threads_per_core);
							}

							if (delete_hosts.hardware_manufacturer == null) {
								pstmt_tJDBCOutput_17.setNull(23,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(23,
										delete_hosts.hardware_manufacturer);
							}

							if (delete_hosts.hardware_product_name == null) {
								pstmt_tJDBCOutput_17.setNull(24,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(24,
										delete_hosts.hardware_product_name);
							}

							if (delete_hosts.hardware_version == null) {
								pstmt_tJDBCOutput_17.setNull(25,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(25,
										delete_hosts.hardware_version);
							}

							if (delete_hosts.hardware_serial_number == null) {
								pstmt_tJDBCOutput_17.setNull(26,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_17.setString(26,
										delete_hosts.hardware_serial_number);
							}

							try {
								insertedCount_tJDBCOutput_17 = insertedCount_tJDBCOutput_17
										+ pstmt_tJDBCOutput_17.executeUpdate();
								nb_line_tJDBCOutput_17++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_17 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_17++;

							/**
							 * [tJDBCOutput_17 main ] stop
							 */

						} // End of branch "delete_hosts"

						/**
						 * [tJDBCInput_22 end ] start
						 */

						currentComponent = "tJDBCInput_22";

					}
				} finally {
					if (rs_tJDBCInput_22 != null) {
						rs_tJDBCInput_22.close();
					}
					stmt_tJDBCInput_22.close();

				}
				globalMap.put("tJDBCInput_22_NB_LINE", nb_line_tJDBCInput_22);

				ok_Hash.put("tJDBCInput_22", true);
				end_Hash.put("tJDBCInput_22", System.currentTimeMillis());

				/**
				 * [tJDBCInput_22 end ] stop
				 */

				/**
				 * [tMap_17 end ] start
				 */

				currentComponent = "tMap_17";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row20 != null) {
					tHash_Lookup_row20.endGet();
				}
				globalMap.remove("tHash_Lookup_row20");

				// ###############################

				ok_Hash.put("tMap_17", true);
				end_Hash.put("tMap_17", System.currentTimeMillis());

				/**
				 * [tMap_17 end ] stop
				 */

				/**
				 * [tJDBCOutput_17 end ] start
				 */

				currentComponent = "tJDBCOutput_17";

				if (pstmt_tJDBCOutput_17 != null) {

					pstmt_tJDBCOutput_17.close();

				}

				nb_line_deleted_tJDBCOutput_17 = nb_line_deleted_tJDBCOutput_17
						+ deletedCount_tJDBCOutput_17;
				nb_line_update_tJDBCOutput_17 = nb_line_update_tJDBCOutput_17
						+ updatedCount_tJDBCOutput_17;
				nb_line_inserted_tJDBCOutput_17 = nb_line_inserted_tJDBCOutput_17
						+ insertedCount_tJDBCOutput_17;
				nb_line_rejected_tJDBCOutput_17 = nb_line_rejected_tJDBCOutput_17
						+ rejectedCount_tJDBCOutput_17;

				globalMap.put("tJDBCOutput_17_NB_LINE", nb_line_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_17);

				ok_Hash.put("tJDBCOutput_17", true);
				end_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_17 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_22:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_5Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_17"
			globalMap.remove("tHash_Lookup_row20");

			try {

				/**
				 * [tJDBCInput_22 finally ] start
				 */

				currentComponent = "tJDBCInput_22";

				/**
				 * [tJDBCInput_22 finally ] stop
				 */

				/**
				 * [tMap_17 finally ] start
				 */

				currentComponent = "tMap_17";

				/**
				 * [tMap_17 finally ] stop
				 */

				/**
				 * [tJDBCOutput_17 finally ] start
				 */

				currentComponent = "tJDBCOutput_17";

				/**
				 * [tJDBCOutput_17 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", 1);
	}

	public static class hinterface_configurationStruct implements
			routines.system.IPersistableRow<hinterface_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(hinterface_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_5Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_41Process(globalMap);

				row2Struct row2 = new row2Struct();
				hinterface_configurationStruct hinterface_configuration = new hinterface_configurationStruct();

				/**
				 * [tJDBCOutput_5 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_5", false);
				start_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_5";

				int tos_count_tJDBCOutput_5 = 0;

				int nb_line_tJDBCOutput_5 = 0;
				int nb_line_update_tJDBCOutput_5 = 0;
				int nb_line_inserted_tJDBCOutput_5 = 0;
				int nb_line_deleted_tJDBCOutput_5 = 0;
				int nb_line_rejected_tJDBCOutput_5 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_5 = 0;

				int deletedCount_tJDBCOutput_5 = 0;
				int updatedCount_tJDBCOutput_5 = 0;
				int insertedCount_tJDBCOutput_5 = 0;
				int rejectedCount_tJDBCOutput_5 = 0;

				boolean whetherReject_tJDBCOutput_5 = false;

				java.sql.Connection connection_tJDBCOutput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_5 = "INSERT INTO "
						+ "host_interface_configuration"
						+ " (host_interface_id,host_interface_name,host_id,host_interface_type,host_interface_speed_bps,mac_address,logical_network_name,ip_address,gateway,bond,bond_name,vlan_id,host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(insert_tJDBCOutput_5);

				/**
				 * [tJDBCOutput_5 begin ] stop
				 */

				/**
				 * [tMap_5 begin ] start
				 */

				ok_Hash.put("tMap_5", false);
				start_Hash.put("tMap_5", System.currentTimeMillis());

				currentComponent = "tMap_5";

				int tos_count_tMap_5 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row37Struct> tHash_Lookup_row37 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row37Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row37Struct>) globalMap
						.get("tHash_Lookup_row37"));

				row37Struct row37HashKey = new row37Struct();
				row37Struct row37Default = new row37Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_5__Struct {
				}
				Var__tMap_5__Struct Var__tMap_5 = new Var__tMap_5__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				hinterface_configurationStruct hinterface_configuration_tmp = new hinterface_configurationStruct();
				// ###############################

				/**
				 * [tMap_5 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT \n  host_interface_id, \n  host_interface_name, \n  host_id, \n  upper(cast(host_id as char(36))) as host_join_id,\n  host_interface_type, \n  host_interface_speed_bps, \n  mac_address, \n  logical_network_name, \n  ip_address, \n  gateway, \n  bond, \n  bond_name, \n  vlan_id, \n  create_date, \n  update_date\nFROM dwh_host_interface_configuration_history_view";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);

				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						if (colQtyInRs_tJDBCInput_5 < 1) {
							row2.host_interface_id = null;
						} else {

							if (rs_tJDBCInput_5.getObject(1) != null) {
								row2.host_interface_id = rs_tJDBCInput_5
										.getObject(1);
							} else {
								row2.host_interface_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 2) {
							row2.host_interface_name = null;
						} else {

							row2.host_interface_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 2, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 3) {
							row2.host_id = null;
						} else {

							if (rs_tJDBCInput_5.getObject(3) != null) {
								row2.host_id = rs_tJDBCInput_5.getObject(3);
							} else {
								row2.host_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 4) {
							row2.host_join_id = null;
						} else {

							row2.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 4, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 5) {
							row2.host_interface_type = null;
						} else {

							if (rs_tJDBCInput_5.getObject(5) != null) {
								row2.host_interface_type = rs_tJDBCInput_5
										.getShort(5);
							} else {
								row2.host_interface_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 6) {
							row2.host_interface_speed_bps = null;
						} else {

							if (rs_tJDBCInput_5.getObject(6) != null) {
								row2.host_interface_speed_bps = rs_tJDBCInput_5
										.getInt(6);
							} else {
								row2.host_interface_speed_bps = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 7) {
							row2.mac_address = null;
						} else {

							row2.mac_address = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 7, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 8) {
							row2.logical_network_name = null;
						} else {

							row2.logical_network_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 8, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 9) {
							row2.ip_address = null;
						} else {

							row2.ip_address = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 9, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 10) {
							row2.gateway = null;
						} else {

							row2.gateway = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_5, 10, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 11) {
							row2.bond = null;
						} else {

							if (rs_tJDBCInput_5.getObject(11) != null) {
								row2.bond = rs_tJDBCInput_5.getBoolean(11);
							} else {
								row2.bond = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 12) {
							row2.bond_name = null;
						} else {

							row2.bond_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 12, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 13) {
							row2.vlan_id = null;
						} else {

							if (rs_tJDBCInput_5.getObject(13) != null) {
								row2.vlan_id = rs_tJDBCInput_5.getInt(13);
							} else {
								row2.vlan_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_5 < 14) {
							row2.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_5 = null;
							try {
								date_tJDBCInput_5 = rs_tJDBCInput_5
										.getTimestamp(14);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_5 = rs_tJDBCInput_5.getDate(14);
							}
							row2.create_date = date_tJDBCInput_5;
						}
						if (colQtyInRs_tJDBCInput_5 < 15) {
							row2.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_5 = null;
							try {
								date_tJDBCInput_5 = rs_tJDBCInput_5
										.getTimestamp(15);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_5 = rs_tJDBCInput_5.getDate(15);
							}
							row2.update_date = date_tJDBCInput_5;
						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */

						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tMap_5 main ] start
						 */

						currentComponent = "tMap_5";

						boolean hasCasePrimitiveKeyWithNull_tMap_5 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_5 = false;
						boolean mainRowRejected_tMap_5 = false;

						if (

						(

						row2.update_date == null ? TalendDate.compareDate(
								row2.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row2.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row2'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row37"
							// /////////////////////////////////////////////

							boolean forceLooprow37 = false;

							row37Struct row37ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_5) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_5 = false;

								row37HashKey.host_join_id = row2.host_join_id;

								row37HashKey.hashCodeDirty = true;

								tHash_Lookup_row37.lookup(row37HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row37 != null
									&& tHash_Lookup_row37
											.getCount(row37HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row37' and it contains more one result from keys :  row37.host_join_id = '"
								// + row37HashKey.host_join_id + "'");
							} // G 071

							row37Struct row37 = null;

							row37Struct fromLookup_row37 = null;
							row37 = row37Default;

							if (tHash_Lookup_row37 != null
									&& tHash_Lookup_row37.hasNext()) { // G 099

								fromLookup_row37 = tHash_Lookup_row37.next();

							} // G 099

							if (fromLookup_row37 != null) {
								row37 = fromLookup_row37;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_5__Struct Var = Var__tMap_5;// ###############################
								// ###############################
								// # Output tables

								hinterface_configuration = null;

								// # Output table : 'hinterface_configuration'
								hinterface_configuration_tmp.host_interface_id = row2.host_interface_id;
								hinterface_configuration_tmp.host_interface_name = StringHandling
										.TRIM(row2.host_interface_name);
								hinterface_configuration_tmp.host_id = row2.host_id;
								hinterface_configuration_tmp.host_interface_type = row2.host_interface_type;
								hinterface_configuration_tmp.host_interface_speed_bps = row2.host_interface_speed_bps;
								hinterface_configuration_tmp.mac_address = StringHandling
										.TRIM(row2.mac_address);
								hinterface_configuration_tmp.logical_network_name = StringHandling
										.TRIM(row2.logical_network_name);
								hinterface_configuration_tmp.ip_address = StringHandling
										.TRIM(row2.ip_address);
								hinterface_configuration_tmp.gateway = StringHandling
										.TRIM(row2.gateway);
								hinterface_configuration_tmp.bond = row2.bond;
								hinterface_configuration_tmp.bond_name = StringHandling
										.TRIM(row2.bond_name);
								hinterface_configuration_tmp.vlan_id = row2.vlan_id;
								hinterface_configuration_tmp.host_configuration_version = row37.history_id;
								hinterface_configuration_tmp.create_date = row2.create_date;
								hinterface_configuration_tmp.update_date = row2.update_date;
								hinterface_configuration_tmp.delete_date = null;
								hinterface_configuration = hinterface_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_5 = false;

							tos_count_tMap_5++;

							/**
							 * [tMap_5 main ] stop
							 */
							// Start of branch "hinterface_configuration"
							if (hinterface_configuration != null) {

								/**
								 * [tJDBCOutput_5 main ] start
								 */

								currentComponent = "tJDBCOutput_5";

								whetherReject_tJDBCOutput_5 = false;
								if (hinterface_configuration.host_interface_id == null) {
									pstmt_tJDBCOutput_5.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_5
											.setObject(
													1,
													hinterface_configuration.host_interface_id);
								}

								if (hinterface_configuration.host_interface_name == null) {
									pstmt_tJDBCOutput_5.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5
											.setString(
													2,
													hinterface_configuration.host_interface_name);
								}

								if (hinterface_configuration.host_id == null) {
									pstmt_tJDBCOutput_5.setNull(3,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_5.setObject(3,
											hinterface_configuration.host_id);
								}

								if (hinterface_configuration.host_interface_type == null) {
									pstmt_tJDBCOutput_5.setNull(4,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5
											.setShort(
													4,
													hinterface_configuration.host_interface_type);
								}

								if (hinterface_configuration.host_interface_speed_bps == null) {
									pstmt_tJDBCOutput_5.setNull(5,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5
											.setInt(5,
													hinterface_configuration.host_interface_speed_bps);
								}

								if (hinterface_configuration.mac_address == null) {
									pstmt_tJDBCOutput_5.setNull(6,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5
											.setString(
													6,
													hinterface_configuration.mac_address);
								}

								if (hinterface_configuration.logical_network_name == null) {
									pstmt_tJDBCOutput_5.setNull(7,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5
											.setString(
													7,
													hinterface_configuration.logical_network_name);
								}

								if (hinterface_configuration.ip_address == null) {
									pstmt_tJDBCOutput_5.setNull(8,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5
											.setString(
													8,
													hinterface_configuration.ip_address);
								}

								if (hinterface_configuration.gateway == null) {
									pstmt_tJDBCOutput_5.setNull(9,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5.setString(9,
											hinterface_configuration.gateway);
								}

								if (hinterface_configuration.bond == null) {
									pstmt_tJDBCOutput_5.setNull(10,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_5.setBoolean(10,
											hinterface_configuration.bond);
								}

								if (hinterface_configuration.bond_name == null) {
									pstmt_tJDBCOutput_5.setNull(11,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_5.setString(11,
											hinterface_configuration.bond_name);
								}

								if (hinterface_configuration.vlan_id == null) {
									pstmt_tJDBCOutput_5.setNull(12,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5.setInt(12,
											hinterface_configuration.vlan_id);
								}

								if (hinterface_configuration.host_configuration_version == null) {
									pstmt_tJDBCOutput_5.setNull(13,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_5
											.setInt(13,
													hinterface_configuration.host_configuration_version);
								}

								if (hinterface_configuration.create_date != null) {
									pstmt_tJDBCOutput_5
											.setTimestamp(
													14,
													new java.sql.Timestamp(
															hinterface_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_5.setNull(14,
											java.sql.Types.DATE);
								}

								if (hinterface_configuration.update_date != null) {
									pstmt_tJDBCOutput_5
											.setTimestamp(
													15,
													new java.sql.Timestamp(
															hinterface_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_5.setNull(15,
											java.sql.Types.DATE);
								}

								if (hinterface_configuration.delete_date != null) {
									pstmt_tJDBCOutput_5
											.setTimestamp(
													16,
													new java.sql.Timestamp(
															hinterface_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_5.setNull(16,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_5 = insertedCount_tJDBCOutput_5
											+ pstmt_tJDBCOutput_5
													.executeUpdate();
									nb_line_tJDBCOutput_5++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_5 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_5++;

								/**
								 * [tJDBCOutput_5 main ] stop
								 */

							} // End of branch "hinterface_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row2'

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					if (rs_tJDBCInput_5 != null) {
						rs_tJDBCInput_5.close();
					}
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tMap_5 end ] start
				 */

				currentComponent = "tMap_5";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row37 != null) {
					tHash_Lookup_row37.endGet();
				}
				globalMap.remove("tHash_Lookup_row37");

				// ###############################

				ok_Hash.put("tMap_5", true);
				end_Hash.put("tMap_5", System.currentTimeMillis());

				/**
				 * [tMap_5 end ] stop
				 */

				/**
				 * [tJDBCOutput_5 end ] start
				 */

				currentComponent = "tJDBCOutput_5";

				if (pstmt_tJDBCOutput_5 != null) {

					pstmt_tJDBCOutput_5.close();

				}

				nb_line_deleted_tJDBCOutput_5 = nb_line_deleted_tJDBCOutput_5
						+ deletedCount_tJDBCOutput_5;
				nb_line_update_tJDBCOutput_5 = nb_line_update_tJDBCOutput_5
						+ updatedCount_tJDBCOutput_5;
				nb_line_inserted_tJDBCOutput_5 = nb_line_inserted_tJDBCOutput_5
						+ insertedCount_tJDBCOutput_5;
				nb_line_rejected_tJDBCOutput_5 = nb_line_rejected_tJDBCOutput_5
						+ rejectedCount_tJDBCOutput_5;

				globalMap.put("tJDBCOutput_5_NB_LINE", nb_line_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_5);

				ok_Hash.put("tJDBCOutput_5", true);
				end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_5 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_5:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_24Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_5"
			globalMap.remove("tHash_Lookup_row37");

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tMap_5 finally ] start
				 */

				currentComponent = "tMap_5";

				/**
				 * [tMap_5 finally ] stop
				 */

				/**
				 * [tJDBCOutput_5 finally ] start
				 */

				currentComponent = "tJDBCOutput_5";

				/**
				 * [tJDBCOutput_5 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class delete_hinterfaceStruct implements
			routines.system.IPersistableRow<delete_hinterfaceStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_hinterfaceStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row23Struct implements
			routines.system.IPersistableRow<row23Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_join_id = readString(dis);

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_join_id, dos);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row23Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_24Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_24Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object host_interface_id;

		public Object getHost_interface_id() {
			return this.host_interface_id;
		}

		public String host_interface_join_id;

		public String getHost_interface_join_id() {
			return this.host_interface_join_id;
		}

		public String host_interface_name;

		public String getHost_interface_name() {
			return this.host_interface_name;
		}

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public Short host_interface_type;

		public Short getHost_interface_type() {
			return this.host_interface_type;
		}

		public Integer host_interface_speed_bps;

		public Integer getHost_interface_speed_bps() {
			return this.host_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public String ip_address;

		public String getIp_address() {
			return this.ip_address;
		}

		public String gateway;

		public String getGateway() {
			return this.gateway;
		}

		public Boolean bond;

		public Boolean getBond() {
			return this.bond;
		}

		public String bond_name;

		public String getBond_name() {
			return this.bond_name;
		}

		public Integer vlan_id;

		public Integer getVlan_id() {
			return this.vlan_id;
		}

		public Integer host_configuration_version;

		public Integer getHost_configuration_version() {
			return this.host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.host_interface_id = (Object) dis.readObject();

					this.host_interface_join_id = readString(dis);

					this.host_interface_name = readString(dis);

					this.host_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.host_interface_type = null;
					} else {
						this.host_interface_type = dis.readShort();
					}

					this.host_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.ip_address = readString(dis);

					this.gateway = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.bond = null;
					} else {
						this.bond = dis.readBoolean();
					}

					this.bond_name = readString(dis);

					this.vlan_id = readInteger(dis);

					this.host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.host_interface_id);

				// String

				writeString(this.host_interface_join_id, dos);

				// String

				writeString(this.host_interface_name, dos);

				// Object

				dos.writeObject(this.host_id);

				// Short

				if (this.host_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_interface_type);
				}

				// Integer

				writeInteger(this.host_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// String

				writeString(this.ip_address, dos);

				// String

				writeString(this.gateway, dos);

				// Boolean

				if (this.bond == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.bond);
				}

				// String

				writeString(this.bond_name, dos);

				// Integer

				writeInteger(this.vlan_id, dos);

				// Integer

				writeInteger(this.host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",host_interface_id=" + String.valueOf(host_interface_id));
			sb.append(",host_interface_join_id=" + host_interface_join_id);
			sb.append(",host_interface_name=" + host_interface_name);
			sb.append(",host_id=" + String.valueOf(host_id));
			sb.append(",host_interface_type="
					+ String.valueOf(host_interface_type));
			sb.append(",host_interface_speed_bps="
					+ String.valueOf(host_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",ip_address=" + ip_address);
			sb.append(",gateway=" + gateway);
			sb.append(",bond=" + String.valueOf(bond));
			sb.append(",bond_name=" + bond_name);
			sb.append(",vlan_id=" + String.valueOf(vlan_id));
			sb.append(",host_configuration_version="
					+ String.valueOf(host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_24Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_24Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_23Process(globalMap);

				row23Struct row23 = new row23Struct();
				delete_hinterfaceStruct delete_hinterface = new delete_hinterfaceStruct();

				/**
				 * [tJDBCOutput_18 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_18", false);
				start_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_18";

				int tos_count_tJDBCOutput_18 = 0;

				int nb_line_tJDBCOutput_18 = 0;
				int nb_line_update_tJDBCOutput_18 = 0;
				int nb_line_inserted_tJDBCOutput_18 = 0;
				int nb_line_deleted_tJDBCOutput_18 = 0;
				int nb_line_rejected_tJDBCOutput_18 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_18 = 0;

				int deletedCount_tJDBCOutput_18 = 0;
				int updatedCount_tJDBCOutput_18 = 0;
				int insertedCount_tJDBCOutput_18 = 0;
				int rejectedCount_tJDBCOutput_18 = 0;

				boolean whetherReject_tJDBCOutput_18 = false;

				java.sql.Connection connection_tJDBCOutput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_18 = "INSERT INTO "
						+ "host_interface_configuration"
						+ " (host_interface_id,host_interface_name,host_id,host_interface_type,host_interface_speed_bps,mac_address,logical_network_name,ip_address,gateway,bond,bond_name,vlan_id,host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_18 = connection_tJDBCOutput_18
						.prepareStatement(insert_tJDBCOutput_18);

				/**
				 * [tJDBCOutput_18 begin ] stop
				 */

				/**
				 * [tMap_18 begin ] start
				 */

				ok_Hash.put("tMap_18", false);
				start_Hash.put("tMap_18", System.currentTimeMillis());

				currentComponent = "tMap_18";

				int tos_count_tMap_18 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row22Struct> tHash_Lookup_row22 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row22Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row22Struct>) globalMap
						.get("tHash_Lookup_row22"));

				row22Struct row22HashKey = new row22Struct();
				row22Struct row22Default = new row22Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_18__Struct {
				}
				Var__tMap_18__Struct Var__tMap_18 = new Var__tMap_18__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_hinterfaceStruct delete_hinterface_tmp = new delete_hinterfaceStruct();
				// ###############################

				/**
				 * [tMap_18 begin ] stop
				 */

				/**
				 * [tJDBCInput_24 begin ] start
				 */

				ok_Hash.put("tJDBCInput_24", false);
				start_Hash.put("tJDBCInput_24", System.currentTimeMillis());

				currentComponent = "tJDBCInput_24";

				int tos_count_tJDBCInput_24 = 0;

				int nb_line_tJDBCInput_24 = 0;
				java.sql.Connection conn_tJDBCInput_24 = null;
				conn_tJDBCInput_24 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_24 = conn_tJDBCInput_24
						.createStatement();

				String dbquery_tJDBCInput_24 = "SELECT \n  history_id, \n  host_interface_id, \n  upper(cast(host_interface_id as char(36))) as host_interface_join_id,\n  host_interface_name, \n  host_id, \n  host_interface_type, \n  host_interface_speed_bps, \n  mac_address, \n  logical_network_name, \n  ip_address, \n  gateway, \n  bond, \n  bond_name, \n  vlan_id, \n  host_configuration_version, \n  create_date, \n  update_date\nFROM v4_4_latest_configuration_hosts_interfaces";

				globalMap.put("tJDBCInput_24_QUERY", dbquery_tJDBCInput_24);

				java.sql.ResultSet rs_tJDBCInput_24 = null;
				try {
					rs_tJDBCInput_24 = stmt_tJDBCInput_24
							.executeQuery(dbquery_tJDBCInput_24);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_24 = rs_tJDBCInput_24
							.getMetaData();
					int colQtyInRs_tJDBCInput_24 = rsmd_tJDBCInput_24
							.getColumnCount();

					String tmpContent_tJDBCInput_24 = null;

					while (rs_tJDBCInput_24.next()) {
						nb_line_tJDBCInput_24++;

						if (colQtyInRs_tJDBCInput_24 < 1) {
							row23.history_id = null;
						} else {

							if (rs_tJDBCInput_24.getObject(1) != null) {
								row23.history_id = rs_tJDBCInput_24.getInt(1);
							} else {
								row23.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 2) {
							row23.host_interface_id = null;
						} else {

							if (rs_tJDBCInput_24.getObject(2) != null) {
								row23.host_interface_id = rs_tJDBCInput_24
										.getObject(2);
							} else {
								row23.host_interface_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 3) {
							row23.host_interface_join_id = null;
						} else {

							row23.host_interface_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_24, 3, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 4) {
							row23.host_interface_name = null;
						} else {

							row23.host_interface_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_24, 4, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 5) {
							row23.host_id = null;
						} else {

							if (rs_tJDBCInput_24.getObject(5) != null) {
								row23.host_id = rs_tJDBCInput_24.getObject(5);
							} else {
								row23.host_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 6) {
							row23.host_interface_type = null;
						} else {

							if (rs_tJDBCInput_24.getObject(6) != null) {
								row23.host_interface_type = rs_tJDBCInput_24
										.getShort(6);
							} else {
								row23.host_interface_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 7) {
							row23.host_interface_speed_bps = null;
						} else {

							if (rs_tJDBCInput_24.getObject(7) != null) {
								row23.host_interface_speed_bps = rs_tJDBCInput_24
										.getInt(7);
							} else {
								row23.host_interface_speed_bps = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 8) {
							row23.mac_address = null;
						} else {

							row23.mac_address = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_24, 8, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 9) {
							row23.logical_network_name = null;
						} else {

							row23.logical_network_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_24, 9, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 10) {
							row23.ip_address = null;
						} else {

							row23.ip_address = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_24, 10, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 11) {
							row23.gateway = null;
						} else {

							row23.gateway = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_24, 11, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 12) {
							row23.bond = null;
						} else {

							if (rs_tJDBCInput_24.getObject(12) != null) {
								row23.bond = rs_tJDBCInput_24.getBoolean(12);
							} else {
								row23.bond = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 13) {
							row23.bond_name = null;
						} else {

							row23.bond_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_24, 13, false);
						}
						if (colQtyInRs_tJDBCInput_24 < 14) {
							row23.vlan_id = null;
						} else {

							if (rs_tJDBCInput_24.getObject(14) != null) {
								row23.vlan_id = rs_tJDBCInput_24.getInt(14);
							} else {
								row23.vlan_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 15) {
							row23.host_configuration_version = null;
						} else {

							if (rs_tJDBCInput_24.getObject(15) != null) {
								row23.host_configuration_version = rs_tJDBCInput_24
										.getInt(15);
							} else {
								row23.host_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_24 < 16) {
							row23.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_24 = null;
							try {
								date_tJDBCInput_24 = rs_tJDBCInput_24
										.getTimestamp(16);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_24 = rs_tJDBCInput_24
										.getDate(16);
							}
							row23.create_date = date_tJDBCInput_24;
						}
						if (colQtyInRs_tJDBCInput_24 < 17) {
							row23.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_24 = null;
							try {
								date_tJDBCInput_24 = rs_tJDBCInput_24
										.getTimestamp(17);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_24 = rs_tJDBCInput_24
										.getDate(17);
							}
							row23.update_date = date_tJDBCInput_24;
						}

						/**
						 * [tJDBCInput_24 begin ] stop
						 */

						/**
						 * [tJDBCInput_24 main ] start
						 */

						currentComponent = "tJDBCInput_24";

						tos_count_tJDBCInput_24++;

						/**
						 * [tJDBCInput_24 main ] stop
						 */

						/**
						 * [tMap_18 main ] start
						 */

						currentComponent = "tMap_18";

						boolean hasCasePrimitiveKeyWithNull_tMap_18 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_18 = false;
						boolean mainRowRejected_tMap_18 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row22"
						// /////////////////////////////////////////////

						boolean forceLooprow22 = false;

						row22Struct row22ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_18) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_18 = false;

							row22HashKey.host_interface_join_id = row23.host_interface_join_id;

							row22HashKey.hashCodeDirty = true;

							tHash_Lookup_row22.lookup(row22HashKey);

							if (!tHash_Lookup_row22.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_18 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row22 != null
								&& tHash_Lookup_row22.getCount(row22HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row22' and it contains more one result from keys :  row22.host_interface_join_id = '"
							// + row22HashKey.host_interface_join_id + "'");
						} // G 071

						row22Struct row22 = null;

						row22Struct fromLookup_row22 = null;
						row22 = row22Default;

						if (tHash_Lookup_row22 != null
								&& tHash_Lookup_row22.hasNext()) { // G 099

							fromLookup_row22 = tHash_Lookup_row22.next();

						} // G 099

						if (fromLookup_row22 != null) {
							row22 = fromLookup_row22;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_18__Struct Var = Var__tMap_18;// ###############################
							// ###############################
							// # Output tables

							delete_hinterface = null;

							if (!rejectedInnerJoin_tMap_18) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_hinterface'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_18) {
								delete_hinterface_tmp.host_interface_id = row23.host_interface_id;
								delete_hinterface_tmp.host_interface_name = row23.host_interface_name;
								delete_hinterface_tmp.host_id = row23.host_id;
								delete_hinterface_tmp.host_interface_type = row23.host_interface_type;
								delete_hinterface_tmp.host_interface_speed_bps = row23.host_interface_speed_bps;
								delete_hinterface_tmp.mac_address = row23.mac_address;
								delete_hinterface_tmp.logical_network_name = row23.logical_network_name;
								delete_hinterface_tmp.ip_address = row23.ip_address;
								delete_hinterface_tmp.gateway = row23.gateway;
								delete_hinterface_tmp.bond = row23.bond;
								delete_hinterface_tmp.bond_name = row23.bond_name;
								delete_hinterface_tmp.vlan_id = row23.vlan_id;
								delete_hinterface_tmp.host_configuration_version = row23.host_configuration_version;
								delete_hinterface_tmp.create_date = row23.create_date;
								delete_hinterface_tmp.update_date = context.runTime;
								delete_hinterface_tmp.delete_date = context.runTime;
								delete_hinterface = delete_hinterface_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_18 = false;

						tos_count_tMap_18++;

						/**
						 * [tMap_18 main ] stop
						 */
						// Start of branch "delete_hinterface"
						if (delete_hinterface != null) {

							/**
							 * [tJDBCOutput_18 main ] start
							 */

							currentComponent = "tJDBCOutput_18";

							whetherReject_tJDBCOutput_18 = false;
							if (delete_hinterface.host_interface_id == null) {
								pstmt_tJDBCOutput_18.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_18.setObject(1,
										delete_hinterface.host_interface_id);
							}

							if (delete_hinterface.host_interface_name == null) {
								pstmt_tJDBCOutput_18.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_18.setString(2,
										delete_hinterface.host_interface_name);
							}

							if (delete_hinterface.host_id == null) {
								pstmt_tJDBCOutput_18.setNull(3,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_18.setObject(3,
										delete_hinterface.host_id);
							}

							if (delete_hinterface.host_interface_type == null) {
								pstmt_tJDBCOutput_18.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_18.setShort(4,
										delete_hinterface.host_interface_type);
							}

							if (delete_hinterface.host_interface_speed_bps == null) {
								pstmt_tJDBCOutput_18.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_18
										.setInt(5,
												delete_hinterface.host_interface_speed_bps);
							}

							if (delete_hinterface.mac_address == null) {
								pstmt_tJDBCOutput_18.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_18.setString(6,
										delete_hinterface.mac_address);
							}

							if (delete_hinterface.logical_network_name == null) {
								pstmt_tJDBCOutput_18.setNull(7,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_18.setString(7,
										delete_hinterface.logical_network_name);
							}

							if (delete_hinterface.ip_address == null) {
								pstmt_tJDBCOutput_18.setNull(8,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_18.setString(8,
										delete_hinterface.ip_address);
							}

							if (delete_hinterface.gateway == null) {
								pstmt_tJDBCOutput_18.setNull(9,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_18.setString(9,
										delete_hinterface.gateway);
							}

							if (delete_hinterface.bond == null) {
								pstmt_tJDBCOutput_18.setNull(10,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_18.setBoolean(10,
										delete_hinterface.bond);
							}

							if (delete_hinterface.bond_name == null) {
								pstmt_tJDBCOutput_18.setNull(11,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_18.setString(11,
										delete_hinterface.bond_name);
							}

							if (delete_hinterface.vlan_id == null) {
								pstmt_tJDBCOutput_18.setNull(12,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_18.setInt(12,
										delete_hinterface.vlan_id);
							}

							if (delete_hinterface.host_configuration_version == null) {
								pstmt_tJDBCOutput_18.setNull(13,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_18
										.setInt(13,
												delete_hinterface.host_configuration_version);
							}

							if (delete_hinterface.create_date != null) {
								pstmt_tJDBCOutput_18.setTimestamp(
										14,
										new java.sql.Timestamp(
												delete_hinterface.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_18.setNull(14,
										java.sql.Types.DATE);
							}

							if (delete_hinterface.update_date != null) {
								pstmt_tJDBCOutput_18.setTimestamp(
										15,
										new java.sql.Timestamp(
												delete_hinterface.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_18.setNull(15,
										java.sql.Types.DATE);
							}

							if (delete_hinterface.delete_date != null) {
								pstmt_tJDBCOutput_18.setTimestamp(
										16,
										new java.sql.Timestamp(
												delete_hinterface.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_18.setNull(16,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_18 = insertedCount_tJDBCOutput_18
										+ pstmt_tJDBCOutput_18.executeUpdate();
								nb_line_tJDBCOutput_18++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_18 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_18++;

							/**
							 * [tJDBCOutput_18 main ] stop
							 */

						} // End of branch "delete_hinterface"

						/**
						 * [tJDBCInput_24 end ] start
						 */

						currentComponent = "tJDBCInput_24";

					}
				} finally {
					if (rs_tJDBCInput_24 != null) {
						rs_tJDBCInput_24.close();
					}
					stmt_tJDBCInput_24.close();

				}
				globalMap.put("tJDBCInput_24_NB_LINE", nb_line_tJDBCInput_24);

				ok_Hash.put("tJDBCInput_24", true);
				end_Hash.put("tJDBCInput_24", System.currentTimeMillis());

				/**
				 * [tJDBCInput_24 end ] stop
				 */

				/**
				 * [tMap_18 end ] start
				 */

				currentComponent = "tMap_18";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row22 != null) {
					tHash_Lookup_row22.endGet();
				}
				globalMap.remove("tHash_Lookup_row22");

				// ###############################

				ok_Hash.put("tMap_18", true);
				end_Hash.put("tMap_18", System.currentTimeMillis());

				/**
				 * [tMap_18 end ] stop
				 */

				/**
				 * [tJDBCOutput_18 end ] start
				 */

				currentComponent = "tJDBCOutput_18";

				if (pstmt_tJDBCOutput_18 != null) {

					pstmt_tJDBCOutput_18.close();

				}

				nb_line_deleted_tJDBCOutput_18 = nb_line_deleted_tJDBCOutput_18
						+ deletedCount_tJDBCOutput_18;
				nb_line_update_tJDBCOutput_18 = nb_line_update_tJDBCOutput_18
						+ updatedCount_tJDBCOutput_18;
				nb_line_inserted_tJDBCOutput_18 = nb_line_inserted_tJDBCOutput_18
						+ insertedCount_tJDBCOutput_18;
				nb_line_rejected_tJDBCOutput_18 = nb_line_rejected_tJDBCOutput_18
						+ rejectedCount_tJDBCOutput_18;

				globalMap.put("tJDBCOutput_18_NB_LINE", nb_line_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_18);

				ok_Hash.put("tJDBCOutput_18", true);
				end_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_18 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_24:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_6Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_18"
			globalMap.remove("tHash_Lookup_row22");

			try {

				/**
				 * [tJDBCInput_24 finally ] start
				 */

				currentComponent = "tJDBCInput_24";

				/**
				 * [tJDBCInput_24 finally ] stop
				 */

				/**
				 * [tMap_18 finally ] start
				 */

				currentComponent = "tMap_18";

				/**
				 * [tMap_18 finally ] stop
				 */

				/**
				 * [tJDBCOutput_18 finally ] start
				 */

				currentComponent = "tJDBCOutput_18";

				/**
				 * [tJDBCOutput_18 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", 1);
	}

	public static class vm_configurationStruct implements
			routines.system.IPersistableRow<vm_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public short operating_system;

		public short getOperating_system() {
			return this.operating_system;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Object created_by_user_id;

		public Object getCreated_by_user_id() {
			return this.created_by_user_id;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					this.operating_system = dis.readShort();

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.created_by_user_id = (Object) dis.readObject();

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// short

				dos.writeShort(this.operating_system);

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Object

				dos.writeObject(this.created_by_user_id);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",created_by_user_id="
					+ String.valueOf(created_by_user_id));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public String default_host_join_id;

		public String getDefault_host_join_id() {
			return this.default_host_join_id;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Object created_by_user_id;

		public Object getCreated_by_user_id() {
			return this.created_by_user_id;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.default_host = (Object) dis.readObject();

					this.default_host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.created_by_user_id = (Object) dis.readObject();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// Object

				dos.writeObject(this.default_host);

				// String

				writeString(this.default_host_join_id, dos);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Object

				dos.writeObject(this.created_by_user_id);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",default_host_join_id=" + default_host_join_id);
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",created_by_user_id="
					+ String.valueOf(created_by_user_id));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_6Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public String default_host_join_id;

		public String getDefault_host_join_id() {
			return this.default_host_join_id;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Object created_by_user_id;

		public Object getCreated_by_user_id() {
			return this.created_by_user_id;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.default_host = (Object) dis.readObject();

					this.default_host_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.created_by_user_id = (Object) dis.readObject();

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// Object

				dos.writeObject(this.default_host);

				// String

				writeString(this.default_host_join_id, dos);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Object

				dos.writeObject(this.created_by_user_id);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",default_host_join_id=" + default_host_join_id);
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",created_by_user_id="
					+ String.valueOf(created_by_user_id));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_6Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_43Process(globalMap);
				tJDBCInput_42Process(globalMap);

				row4Struct row4 = new row4Struct();
				vm_configurationStruct vm_configuration = new vm_configurationStruct();

				/**
				 * [tJDBCOutput_6 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_6", false);
				start_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_6";

				int tos_count_tJDBCOutput_6 = 0;

				int nb_line_tJDBCOutput_6 = 0;
				int nb_line_update_tJDBCOutput_6 = 0;
				int nb_line_inserted_tJDBCOutput_6 = 0;
				int nb_line_deleted_tJDBCOutput_6 = 0;
				int nb_line_rejected_tJDBCOutput_6 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_6 = 0;

				int deletedCount_tJDBCOutput_6 = 0;
				int updatedCount_tJDBCOutput_6 = 0;
				int insertedCount_tJDBCOutput_6 = 0;
				int rejectedCount_tJDBCOutput_6 = 0;

				boolean whetherReject_tJDBCOutput_6 = false;

				java.sql.Connection connection_tJDBCOutput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_6 = "INSERT INTO "
						+ "vm_configuration"
						+ " (vm_id,vm_name,vm_description,vm_type,cluster_id,template_id,template_name,cpu_per_socket,number_of_sockets,memory_size_mb,operating_system,default_host,high_availability,initialized,stateless,fail_back,usb_policy,time_zone,vm_pool_id,vm_pool_name,created_by_user_id,cluster_configuration_version,default_host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(insert_tJDBCOutput_6);

				/**
				 * [tJDBCOutput_6 begin ] stop
				 */

				/**
				 * [tMap_6 begin ] start
				 */

				ok_Hash.put("tMap_6", false);
				start_Hash.put("tMap_6", System.currentTimeMillis());

				currentComponent = "tMap_6";

				int tos_count_tMap_6 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row38Struct> tHash_Lookup_row38 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row38Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row38Struct>) globalMap
						.get("tHash_Lookup_row38"));

				row38Struct row38HashKey = new row38Struct();
				row38Struct row38Default = new row38Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row39Struct> tHash_Lookup_row39 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row39Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row39Struct>) globalMap
						.get("tHash_Lookup_row39"));

				row39Struct row39HashKey = new row39Struct();
				row39Struct row39Default = new row39Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_6__Struct {
				}
				Var__tMap_6__Struct Var__tMap_6 = new Var__tMap_6__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_configurationStruct vm_configuration_tmp = new vm_configurationStruct();
				// ###############################

				/**
				 * [tMap_6 begin ] stop
				 */

				/**
				 * [tJDBCInput_6 begin ] start
				 */

				ok_Hash.put("tJDBCInput_6", false);
				start_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				currentComponent = "tJDBCInput_6";

				int tos_count_tJDBCInput_6 = 0;

				int nb_line_tJDBCInput_6 = 0;
				java.sql.Connection conn_tJDBCInput_6 = null;
				conn_tJDBCInput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_6 = conn_tJDBCInput_6
						.createStatement();

				String dbquery_tJDBCInput_6 = "SELECT \n  vm_id, \n  vm_name, \n  vm_description, \n  vm_type, \n  cluster_id,\n  upper(cast(cluster_id as char(36))) as cluster_join_id,  \n  template_id, \n  template_name, \n  cpu_per_socket, \n  number_of_sockets, \n  memory_size_mb, \n  operating_system, \n  default_host,\n  upper(cast(default_host as char(36))) as default_host_join_id,  \n  high_availability, \n  initialized, \n  stateless, \n  fail_back,  \n  usb_policy, \n  time_zone, \n  vm_pool_id,\n  vm_pool_name,\n  created_by_user_id,\n  create_date, \n  update_date\nFROM dwh_vm_configuration_history_view";

				globalMap.put("tJDBCInput_6_QUERY", dbquery_tJDBCInput_6);

				java.sql.ResultSet rs_tJDBCInput_6 = null;
				try {
					rs_tJDBCInput_6 = stmt_tJDBCInput_6
							.executeQuery(dbquery_tJDBCInput_6);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_6 = rs_tJDBCInput_6
							.getMetaData();
					int colQtyInRs_tJDBCInput_6 = rsmd_tJDBCInput_6
							.getColumnCount();

					String tmpContent_tJDBCInput_6 = null;

					while (rs_tJDBCInput_6.next()) {
						nb_line_tJDBCInput_6++;

						if (colQtyInRs_tJDBCInput_6 < 1) {
							row4.vm_id = null;
						} else {

							if (rs_tJDBCInput_6.getObject(1) != null) {
								row4.vm_id = rs_tJDBCInput_6.getObject(1);
							} else {
								row4.vm_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 2) {
							row4.vm_name = null;
						} else {

							row4.vm_name = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_6, 2, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 3) {
							row4.vm_description = null;
						} else {

							row4.vm_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 3, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 4) {
							row4.vm_type = null;
						} else {

							if (rs_tJDBCInput_6.getObject(4) != null) {
								row4.vm_type = rs_tJDBCInput_6.getShort(4);
							} else {
								row4.vm_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 5) {
							row4.cluster_id = null;
						} else {

							if (rs_tJDBCInput_6.getObject(5) != null) {
								row4.cluster_id = rs_tJDBCInput_6.getObject(5);
							} else {
								row4.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 6) {
							row4.cluster_join_id = null;
						} else {

							row4.cluster_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 6, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 7) {
							row4.template_id = null;
						} else {

							if (rs_tJDBCInput_6.getObject(7) != null) {
								row4.template_id = rs_tJDBCInput_6.getObject(7);
							} else {
								row4.template_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 8) {
							row4.template_name = null;
						} else {

							row4.template_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 8, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 9) {
							row4.cpu_per_socket = null;
						} else {

							if (rs_tJDBCInput_6.getObject(9) != null) {
								row4.cpu_per_socket = rs_tJDBCInput_6
										.getShort(9);
							} else {
								row4.cpu_per_socket = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 10) {
							row4.number_of_sockets = null;
						} else {

							if (rs_tJDBCInput_6.getObject(10) != null) {
								row4.number_of_sockets = rs_tJDBCInput_6
										.getShort(10);
							} else {
								row4.number_of_sockets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 11) {
							row4.memory_size_mb = null;
						} else {

							if (rs_tJDBCInput_6.getObject(11) != null) {
								row4.memory_size_mb = rs_tJDBCInput_6
										.getInt(11);
							} else {
								row4.memory_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 12) {
							row4.operating_system = null;
						} else {

							if (rs_tJDBCInput_6.getObject(12) != null) {
								row4.operating_system = rs_tJDBCInput_6
										.getShort(12);
							} else {
								row4.operating_system = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 13) {
							row4.default_host = null;
						} else {

							if (rs_tJDBCInput_6.getObject(13) != null) {
								row4.default_host = rs_tJDBCInput_6
										.getObject(13);
							} else {
								row4.default_host = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 14) {
							row4.default_host_join_id = null;
						} else {

							row4.default_host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 14, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 15) {
							row4.high_availability = null;
						} else {

							if (rs_tJDBCInput_6.getObject(15) != null) {
								row4.high_availability = rs_tJDBCInput_6
										.getBoolean(15);
							} else {
								row4.high_availability = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 16) {
							row4.initialized = null;
						} else {

							if (rs_tJDBCInput_6.getObject(16) != null) {
								row4.initialized = rs_tJDBCInput_6
										.getBoolean(16);
							} else {
								row4.initialized = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 17) {
							row4.stateless = null;
						} else {

							if (rs_tJDBCInput_6.getObject(17) != null) {
								row4.stateless = rs_tJDBCInput_6.getBoolean(17);
							} else {
								row4.stateless = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 18) {
							row4.fail_back = null;
						} else {

							if (rs_tJDBCInput_6.getObject(18) != null) {
								row4.fail_back = rs_tJDBCInput_6.getBoolean(18);
							} else {
								row4.fail_back = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 19) {
							row4.usb_policy = null;
						} else {

							if (rs_tJDBCInput_6.getObject(19) != null) {
								row4.usb_policy = rs_tJDBCInput_6.getShort(19);
							} else {
								row4.usb_policy = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 20) {
							row4.time_zone = null;
						} else {

							row4.time_zone = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 20, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 21) {
							row4.vm_pool_id = null;
						} else {

							if (rs_tJDBCInput_6.getObject(21) != null) {
								row4.vm_pool_id = rs_tJDBCInput_6.getObject(21);
							} else {
								row4.vm_pool_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 22) {
							row4.vm_pool_name = null;
						} else {

							row4.vm_pool_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_6, 22, false);
						}
						if (colQtyInRs_tJDBCInput_6 < 23) {
							row4.created_by_user_id = null;
						} else {

							if (rs_tJDBCInput_6.getObject(23) != null) {
								row4.created_by_user_id = rs_tJDBCInput_6
										.getObject(23);
							} else {
								row4.created_by_user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_6 < 24) {
							row4.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_6 = null;
							try {
								date_tJDBCInput_6 = rs_tJDBCInput_6
										.getTimestamp(24);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_6 = rs_tJDBCInput_6.getDate(24);
							}
							row4.create_date = date_tJDBCInput_6;
						}
						if (colQtyInRs_tJDBCInput_6 < 25) {
							row4.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_6 = null;
							try {
								date_tJDBCInput_6 = rs_tJDBCInput_6
										.getTimestamp(25);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_6 = rs_tJDBCInput_6.getDate(25);
							}
							row4.update_date = date_tJDBCInput_6;
						}

						/**
						 * [tJDBCInput_6 begin ] stop
						 */

						/**
						 * [tJDBCInput_6 main ] start
						 */

						currentComponent = "tJDBCInput_6";

						tos_count_tJDBCInput_6++;

						/**
						 * [tJDBCInput_6 main ] stop
						 */

						/**
						 * [tMap_6 main ] start
						 */

						currentComponent = "tMap_6";

						boolean hasCasePrimitiveKeyWithNull_tMap_6 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_6 = false;
						boolean mainRowRejected_tMap_6 = false;

						if (

						(

						row4.update_date == null ? TalendDate.compareDate(
								row4.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row4.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row4'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row38"
							// /////////////////////////////////////////////

							boolean forceLooprow38 = false;

							row38Struct row38ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_6) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_6 = false;

								row38HashKey.host_join_id = row4.default_host_join_id;

								row38HashKey.hashCodeDirty = true;

								tHash_Lookup_row38.lookup(row38HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row38 != null
									&& tHash_Lookup_row38
											.getCount(row38HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row38' and it contains more one result from keys :  row38.host_join_id = '"
								// + row38HashKey.host_join_id + "'");
							} // G 071

							row38Struct row38 = null;

							row38Struct fromLookup_row38 = null;
							row38 = row38Default;

							if (tHash_Lookup_row38 != null
									&& tHash_Lookup_row38.hasNext()) { // G 099

								fromLookup_row38 = tHash_Lookup_row38.next();

							} // G 099

							if (fromLookup_row38 != null) {
								row38 = fromLookup_row38;
							}

							// /////////////////////////////////////////////
							// Starting Lookup Table "row39"
							// /////////////////////////////////////////////

							boolean forceLooprow39 = false;

							row39Struct row39ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_6) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_6 = false;

								row39HashKey.cluster_join_id = row4.cluster_join_id;

								row39HashKey.hashCodeDirty = true;

								tHash_Lookup_row39.lookup(row39HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row39 != null
									&& tHash_Lookup_row39
											.getCount(row39HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row39' and it contains more one result from keys :  row39.cluster_join_id = '"
								// + row39HashKey.cluster_join_id + "'");
							} // G 071

							row39Struct row39 = null;

							row39Struct fromLookup_row39 = null;
							row39 = row39Default;

							if (tHash_Lookup_row39 != null
									&& tHash_Lookup_row39.hasNext()) { // G 099

								fromLookup_row39 = tHash_Lookup_row39.next();

							} // G 099

							if (fromLookup_row39 != null) {
								row39 = fromLookup_row39;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_6__Struct Var = Var__tMap_6;// ###############################
								// ###############################
								// # Output tables

								vm_configuration = null;

								// # Output table : 'vm_configuration'
								vm_configuration_tmp.vm_id = row4.vm_id;
								vm_configuration_tmp.vm_name = StringHandling
										.TRIM(row4.vm_name);
								vm_configuration_tmp.vm_description = StringHandling
										.TRIM(row4.vm_description);
								vm_configuration_tmp.vm_type = row4.vm_type;
								vm_configuration_tmp.cluster_id = row4.cluster_id;
								vm_configuration_tmp.template_id = row4.template_id;
								vm_configuration_tmp.template_name = StringHandling
										.TRIM(row4.template_name);
								vm_configuration_tmp.cpu_per_socket = row4.cpu_per_socket;
								vm_configuration_tmp.number_of_sockets = row4.number_of_sockets;
								vm_configuration_tmp.memory_size_mb = row4.memory_size_mb;
								vm_configuration_tmp.operating_system = row4.operating_system;
								vm_configuration_tmp.default_host = row4.default_host;
								vm_configuration_tmp.high_availability = row4.high_availability;
								vm_configuration_tmp.initialized = row4.initialized;
								vm_configuration_tmp.stateless = row4.stateless;
								vm_configuration_tmp.fail_back = row4.fail_back;
								vm_configuration_tmp.usb_policy = row4.usb_policy;
								vm_configuration_tmp.time_zone = StringHandling
										.TRIM(row4.time_zone);
								vm_configuration_tmp.vm_pool_id = row4.vm_pool_id;
								vm_configuration_tmp.vm_pool_name = row4.vm_pool_name;
								vm_configuration_tmp.created_by_user_id = row4.created_by_user_id;
								vm_configuration_tmp.cluster_configuration_version = row39.history_id;
								vm_configuration_tmp.default_host_configuration_version = row38.history_id;
								vm_configuration_tmp.create_date = row4.create_date;
								vm_configuration_tmp.update_date = row4.update_date;
								vm_configuration_tmp.delete_date = null;
								vm_configuration = vm_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_6 = false;

							tos_count_tMap_6++;

							/**
							 * [tMap_6 main ] stop
							 */
							// Start of branch "vm_configuration"
							if (vm_configuration != null) {

								/**
								 * [tJDBCOutput_6 main ] start
								 */

								currentComponent = "tJDBCOutput_6";

								whetherReject_tJDBCOutput_6 = false;
								if (vm_configuration.vm_id == null) {
									pstmt_tJDBCOutput_6.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_6.setObject(1,
											vm_configuration.vm_id);
								}

								if (vm_configuration.vm_name == null) {
									pstmt_tJDBCOutput_6.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_6.setString(2,
											vm_configuration.vm_name);
								}

								if (vm_configuration.vm_description == null) {
									pstmt_tJDBCOutput_6.setNull(3,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_6.setString(3,
											vm_configuration.vm_description);
								}

								if (vm_configuration.vm_type == null) {
									pstmt_tJDBCOutput_6.setNull(4,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6.setShort(4,
											vm_configuration.vm_type);
								}

								if (vm_configuration.cluster_id == null) {
									pstmt_tJDBCOutput_6.setNull(5,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_6.setObject(5,
											vm_configuration.cluster_id);
								}

								if (vm_configuration.template_id == null) {
									pstmt_tJDBCOutput_6.setNull(6,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_6.setObject(6,
											vm_configuration.template_id);
								}

								if (vm_configuration.template_name == null) {
									pstmt_tJDBCOutput_6.setNull(7,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_6.setString(7,
											vm_configuration.template_name);
								}

								if (vm_configuration.cpu_per_socket == null) {
									pstmt_tJDBCOutput_6.setNull(8,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6.setShort(8,
											vm_configuration.cpu_per_socket);
								}

								if (vm_configuration.number_of_sockets == null) {
									pstmt_tJDBCOutput_6.setNull(9,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6.setShort(9,
											vm_configuration.number_of_sockets);
								}

								if (vm_configuration.memory_size_mb == null) {
									pstmt_tJDBCOutput_6.setNull(10,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6.setInt(10,
											vm_configuration.memory_size_mb);
								}

								pstmt_tJDBCOutput_6.setShort(11,
										vm_configuration.operating_system);

								if (vm_configuration.default_host == null) {
									pstmt_tJDBCOutput_6.setNull(12,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_6.setObject(12,
											vm_configuration.default_host);
								}

								if (vm_configuration.high_availability == null) {
									pstmt_tJDBCOutput_6.setNull(13,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_6.setBoolean(13,
											vm_configuration.high_availability);
								}

								if (vm_configuration.initialized == null) {
									pstmt_tJDBCOutput_6.setNull(14,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_6.setBoolean(14,
											vm_configuration.initialized);
								}

								if (vm_configuration.stateless == null) {
									pstmt_tJDBCOutput_6.setNull(15,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_6.setBoolean(15,
											vm_configuration.stateless);
								}

								if (vm_configuration.fail_back == null) {
									pstmt_tJDBCOutput_6.setNull(16,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_6.setBoolean(16,
											vm_configuration.fail_back);
								}

								if (vm_configuration.usb_policy == null) {
									pstmt_tJDBCOutput_6.setNull(17,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6.setShort(17,
											vm_configuration.usb_policy);
								}

								if (vm_configuration.time_zone == null) {
									pstmt_tJDBCOutput_6.setNull(18,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_6.setString(18,
											vm_configuration.time_zone);
								}

								if (vm_configuration.vm_pool_id == null) {
									pstmt_tJDBCOutput_6.setNull(19,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_6.setObject(19,
											vm_configuration.vm_pool_id);
								}

								if (vm_configuration.vm_pool_name == null) {
									pstmt_tJDBCOutput_6.setNull(20,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_6.setString(20,
											vm_configuration.vm_pool_name);
								}

								if (vm_configuration.created_by_user_id == null) {
									pstmt_tJDBCOutput_6.setNull(21,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_6
											.setObject(
													21,
													vm_configuration.created_by_user_id);
								}

								if (vm_configuration.cluster_configuration_version == null) {
									pstmt_tJDBCOutput_6.setNull(22,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6
											.setInt(22,
													vm_configuration.cluster_configuration_version);
								}

								if (vm_configuration.default_host_configuration_version == null) {
									pstmt_tJDBCOutput_6.setNull(23,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_6
											.setInt(23,
													vm_configuration.default_host_configuration_version);
								}

								if (vm_configuration.create_date != null) {
									pstmt_tJDBCOutput_6
											.setTimestamp(
													24,
													new java.sql.Timestamp(
															vm_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_6.setNull(24,
											java.sql.Types.DATE);
								}

								if (vm_configuration.update_date != null) {
									pstmt_tJDBCOutput_6
											.setTimestamp(
													25,
													new java.sql.Timestamp(
															vm_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_6.setNull(25,
											java.sql.Types.DATE);
								}

								if (vm_configuration.delete_date != null) {
									pstmt_tJDBCOutput_6
											.setTimestamp(
													26,
													new java.sql.Timestamp(
															vm_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_6.setNull(26,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_6 = insertedCount_tJDBCOutput_6
											+ pstmt_tJDBCOutput_6
													.executeUpdate();
									nb_line_tJDBCOutput_6++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_6 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_6++;

								/**
								 * [tJDBCOutput_6 main ] stop
								 */

							} // End of branch "vm_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row4'

						/**
						 * [tJDBCInput_6 end ] start
						 */

						currentComponent = "tJDBCInput_6";

					}
				} finally {
					if (rs_tJDBCInput_6 != null) {
						rs_tJDBCInput_6.close();
					}
					stmt_tJDBCInput_6.close();

				}
				globalMap.put("tJDBCInput_6_NB_LINE", nb_line_tJDBCInput_6);

				ok_Hash.put("tJDBCInput_6", true);
				end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				/**
				 * [tJDBCInput_6 end ] stop
				 */

				/**
				 * [tMap_6 end ] start
				 */

				currentComponent = "tMap_6";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row38 != null) {
					tHash_Lookup_row38.endGet();
				}
				globalMap.remove("tHash_Lookup_row38");

				if (tHash_Lookup_row39 != null) {
					tHash_Lookup_row39.endGet();
				}
				globalMap.remove("tHash_Lookup_row39");

				// ###############################

				ok_Hash.put("tMap_6", true);
				end_Hash.put("tMap_6", System.currentTimeMillis());

				/**
				 * [tMap_6 end ] stop
				 */

				/**
				 * [tJDBCOutput_6 end ] start
				 */

				currentComponent = "tJDBCOutput_6";

				if (pstmt_tJDBCOutput_6 != null) {

					pstmt_tJDBCOutput_6.close();

				}

				nb_line_deleted_tJDBCOutput_6 = nb_line_deleted_tJDBCOutput_6
						+ deletedCount_tJDBCOutput_6;
				nb_line_update_tJDBCOutput_6 = nb_line_update_tJDBCOutput_6
						+ updatedCount_tJDBCOutput_6;
				nb_line_inserted_tJDBCOutput_6 = nb_line_inserted_tJDBCOutput_6
						+ insertedCount_tJDBCOutput_6;
				nb_line_rejected_tJDBCOutput_6 = nb_line_rejected_tJDBCOutput_6
						+ rejectedCount_tJDBCOutput_6;

				globalMap.put("tJDBCOutput_6_NB_LINE", nb_line_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_6);

				ok_Hash.put("tJDBCOutput_6", true);
				end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_6 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_6:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_26Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_6"
			globalMap.remove("tHash_Lookup_row38");

			// free memory for "tMap_6"
			globalMap.remove("tHash_Lookup_row39");

			try {

				/**
				 * [tJDBCInput_6 finally ] start
				 */

				currentComponent = "tJDBCInput_6";

				/**
				 * [tJDBCInput_6 finally ] stop
				 */

				/**
				 * [tMap_6 finally ] start
				 */

				currentComponent = "tMap_6";

				/**
				 * [tMap_6 finally ] stop
				 */

				/**
				 * [tJDBCOutput_6 finally ] start
				 */

				currentComponent = "tJDBCOutput_6";

				/**
				 * [tJDBCOutput_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 1);
	}

	public static class delete_vmsStruct implements
			routines.system.IPersistableRow<delete_vmsStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public short operating_system;

		public short getOperating_system() {
			return this.operating_system;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Object created_by_user_id;

		public Object getCreated_by_user_id() {
			return this.created_by_user_id;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					this.operating_system = dis.readShort();

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.created_by_user_id = (Object) dis.readObject();

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// short

				dos.writeShort(this.operating_system);

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Object

				dos.writeObject(this.created_by_user_id);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",created_by_user_id="
					+ String.valueOf(created_by_user_id));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vmsStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row25Struct implements
			routines.system.IPersistableRow<row25Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Object created_by_user_id;

		public Object getCreated_by_user_id() {
			return this.created_by_user_id;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.created_by_user_id = (Object) dis.readObject();

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Object

				dos.writeObject(this.created_by_user_id);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",created_by_user_id="
					+ String.valueOf(created_by_user_id));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row25Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_26Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_26Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String vm_name;

		public String getVm_name() {
			return this.vm_name;
		}

		public String vm_description;

		public String getVm_description() {
			return this.vm_description;
		}

		public Short vm_type;

		public Short getVm_type() {
			return this.vm_type;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public Object template_id;

		public Object getTemplate_id() {
			return this.template_id;
		}

		public String template_name;

		public String getTemplate_name() {
			return this.template_name;
		}

		public Short cpu_per_socket;

		public Short getCpu_per_socket() {
			return this.cpu_per_socket;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Short operating_system;

		public Short getOperating_system() {
			return this.operating_system;
		}

		public Object default_host;

		public Object getDefault_host() {
			return this.default_host;
		}

		public Boolean high_availability;

		public Boolean getHigh_availability() {
			return this.high_availability;
		}

		public Boolean initialized;

		public Boolean getInitialized() {
			return this.initialized;
		}

		public Boolean stateless;

		public Boolean getStateless() {
			return this.stateless;
		}

		public Boolean fail_back;

		public Boolean getFail_back() {
			return this.fail_back;
		}

		public Short usb_policy;

		public Short getUsb_policy() {
			return this.usb_policy;
		}

		public String time_zone;

		public String getTime_zone() {
			return this.time_zone;
		}

		public Object vm_pool_id;

		public Object getVm_pool_id() {
			return this.vm_pool_id;
		}

		public String vm_pool_name;

		public String getVm_pool_name() {
			return this.vm_pool_name;
		}

		public Object created_by_user_id;

		public Object getCreated_by_user_id() {
			return this.created_by_user_id;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public Integer default_host_configuration_version;

		public Integer getDefault_host_configuration_version() {
			return this.default_host_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.vm_name = readString(dis);

					this.vm_description = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_type = null;
					} else {
						this.vm_type = dis.readShort();
					}

					this.cluster_id = (Object) dis.readObject();

					this.template_id = (Object) dis.readObject();

					this.template_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.cpu_per_socket = null;
					} else {
						this.cpu_per_socket = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					this.memory_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.operating_system = null;
					} else {
						this.operating_system = dis.readShort();
					}

					this.default_host = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.high_availability = null;
					} else {
						this.high_availability = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.initialized = null;
					} else {
						this.initialized = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.stateless = null;
					} else {
						this.stateless = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.fail_back = null;
					} else {
						this.fail_back = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.usb_policy = null;
					} else {
						this.usb_policy = dis.readShort();
					}

					this.time_zone = readString(dis);

					this.vm_pool_id = (Object) dis.readObject();

					this.vm_pool_name = readString(dis);

					this.created_by_user_id = (Object) dis.readObject();

					this.cluster_configuration_version = readInteger(dis);

					this.default_host_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.vm_name, dos);

				// String

				writeString(this.vm_description, dos);

				// Short

				if (this.vm_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_type);
				}

				// Object

				dos.writeObject(this.cluster_id);

				// Object

				dos.writeObject(this.template_id);

				// String

				writeString(this.template_name, dos);

				// Short

				if (this.cpu_per_socket == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.cpu_per_socket);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Short

				if (this.operating_system == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.operating_system);
				}

				// Object

				dos.writeObject(this.default_host);

				// Boolean

				if (this.high_availability == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.high_availability);
				}

				// Boolean

				if (this.initialized == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.initialized);
				}

				// Boolean

				if (this.stateless == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.stateless);
				}

				// Boolean

				if (this.fail_back == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.fail_back);
				}

				// Short

				if (this.usb_policy == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.usb_policy);
				}

				// String

				writeString(this.time_zone, dos);

				// Object

				dos.writeObject(this.vm_pool_id);

				// String

				writeString(this.vm_pool_name, dos);

				// Object

				dos.writeObject(this.created_by_user_id);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// Integer

				writeInteger(this.default_host_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_name=" + vm_name);
			sb.append(",vm_description=" + vm_description);
			sb.append(",vm_type=" + String.valueOf(vm_type));
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",template_id=" + String.valueOf(template_id));
			sb.append(",template_name=" + template_name);
			sb.append(",cpu_per_socket=" + String.valueOf(cpu_per_socket));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",operating_system=" + String.valueOf(operating_system));
			sb.append(",default_host=" + String.valueOf(default_host));
			sb.append(",high_availability=" + String.valueOf(high_availability));
			sb.append(",initialized=" + String.valueOf(initialized));
			sb.append(",stateless=" + String.valueOf(stateless));
			sb.append(",fail_back=" + String.valueOf(fail_back));
			sb.append(",usb_policy=" + String.valueOf(usb_policy));
			sb.append(",time_zone=" + time_zone);
			sb.append(",vm_pool_id=" + String.valueOf(vm_pool_id));
			sb.append(",vm_pool_name=" + vm_pool_name);
			sb.append(",created_by_user_id="
					+ String.valueOf(created_by_user_id));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",default_host_configuration_version="
					+ String.valueOf(default_host_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_26Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_26Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_25Process(globalMap);

				row25Struct row25 = new row25Struct();
				delete_vmsStruct delete_vms = new delete_vmsStruct();

				/**
				 * [tJDBCOutput_19 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_19", false);
				start_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_19";

				int tos_count_tJDBCOutput_19 = 0;

				int nb_line_tJDBCOutput_19 = 0;
				int nb_line_update_tJDBCOutput_19 = 0;
				int nb_line_inserted_tJDBCOutput_19 = 0;
				int nb_line_deleted_tJDBCOutput_19 = 0;
				int nb_line_rejected_tJDBCOutput_19 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_19 = 0;

				int deletedCount_tJDBCOutput_19 = 0;
				int updatedCount_tJDBCOutput_19 = 0;
				int insertedCount_tJDBCOutput_19 = 0;
				int rejectedCount_tJDBCOutput_19 = 0;

				boolean whetherReject_tJDBCOutput_19 = false;

				java.sql.Connection connection_tJDBCOutput_19 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_19 = "INSERT INTO "
						+ "vm_configuration"
						+ " (vm_id,vm_name,vm_description,vm_type,cluster_id,template_id,template_name,cpu_per_socket,number_of_sockets,memory_size_mb,operating_system,default_host,high_availability,initialized,stateless,fail_back,usb_policy,time_zone,vm_pool_id,vm_pool_name,created_by_user_id,cluster_configuration_version,default_host_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_19 = connection_tJDBCOutput_19
						.prepareStatement(insert_tJDBCOutput_19);

				/**
				 * [tJDBCOutput_19 begin ] stop
				 */

				/**
				 * [tMap_19 begin ] start
				 */

				ok_Hash.put("tMap_19", false);
				start_Hash.put("tMap_19", System.currentTimeMillis());

				currentComponent = "tMap_19";

				int tos_count_tMap_19 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row24Struct> tHash_Lookup_row24 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row24Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row24Struct>) globalMap
						.get("tHash_Lookup_row24"));

				row24Struct row24HashKey = new row24Struct();
				row24Struct row24Default = new row24Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_19__Struct {
				}
				Var__tMap_19__Struct Var__tMap_19 = new Var__tMap_19__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_vmsStruct delete_vms_tmp = new delete_vmsStruct();
				// ###############################

				/**
				 * [tMap_19 begin ] stop
				 */

				/**
				 * [tJDBCInput_26 begin ] start
				 */

				ok_Hash.put("tJDBCInput_26", false);
				start_Hash.put("tJDBCInput_26", System.currentTimeMillis());

				currentComponent = "tJDBCInput_26";

				int tos_count_tJDBCInput_26 = 0;

				int nb_line_tJDBCInput_26 = 0;
				java.sql.Connection conn_tJDBCInput_26 = null;
				conn_tJDBCInput_26 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_26 = conn_tJDBCInput_26
						.createStatement();

				String dbquery_tJDBCInput_26 = "SELECT history_id, \n		vm_id, \n		upper(cast(vm_id as char(36))) as vm_join_id,\n		vm_name, \n		vm_description, \n		vm_type, \n		cluster_id, \n		template_id, \n		template_name, \n		cpu_per_socket, \n		number_of_sockets, \n		memory_size_mb, \n		operating_system, \n		default_host, \n		high_availability, \n		initialized, \n		stateless, \n		fail_back, \n		usb_policy, \n		time_zone, \n		vm_pool_id, \n		vm_pool_name,\n		created_by_user_id,\n		cluster_configuration_version, \n		default_host_configuration_version, \n		create_date, \n		update_date\nFROM v4_4_latest_configuration_vms";

				globalMap.put("tJDBCInput_26_QUERY", dbquery_tJDBCInput_26);

				java.sql.ResultSet rs_tJDBCInput_26 = null;
				try {
					rs_tJDBCInput_26 = stmt_tJDBCInput_26
							.executeQuery(dbquery_tJDBCInput_26);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_26 = rs_tJDBCInput_26
							.getMetaData();
					int colQtyInRs_tJDBCInput_26 = rsmd_tJDBCInput_26
							.getColumnCount();

					String tmpContent_tJDBCInput_26 = null;

					while (rs_tJDBCInput_26.next()) {
						nb_line_tJDBCInput_26++;

						if (colQtyInRs_tJDBCInput_26 < 1) {
							row25.history_id = null;
						} else {

							if (rs_tJDBCInput_26.getObject(1) != null) {
								row25.history_id = rs_tJDBCInput_26.getInt(1);
							} else {
								row25.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 2) {
							row25.vm_id = null;
						} else {

							if (rs_tJDBCInput_26.getObject(2) != null) {
								row25.vm_id = rs_tJDBCInput_26.getObject(2);
							} else {
								row25.vm_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 3) {
							row25.vm_join_id = null;
						} else {

							row25.vm_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_26, 3, false);
						}
						if (colQtyInRs_tJDBCInput_26 < 4) {
							row25.vm_name = null;
						} else {

							row25.vm_name = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_26, 4, false);
						}
						if (colQtyInRs_tJDBCInput_26 < 5) {
							row25.vm_description = null;
						} else {

							row25.vm_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_26, 5, false);
						}
						if (colQtyInRs_tJDBCInput_26 < 6) {
							row25.vm_type = null;
						} else {

							if (rs_tJDBCInput_26.getObject(6) != null) {
								row25.vm_type = rs_tJDBCInput_26.getShort(6);
							} else {
								row25.vm_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 7) {
							row25.cluster_id = null;
						} else {

							if (rs_tJDBCInput_26.getObject(7) != null) {
								row25.cluster_id = rs_tJDBCInput_26
										.getObject(7);
							} else {
								row25.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 8) {
							row25.template_id = null;
						} else {

							if (rs_tJDBCInput_26.getObject(8) != null) {
								row25.template_id = rs_tJDBCInput_26
										.getObject(8);
							} else {
								row25.template_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 9) {
							row25.template_name = null;
						} else {

							row25.template_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_26, 9, false);
						}
						if (colQtyInRs_tJDBCInput_26 < 10) {
							row25.cpu_per_socket = null;
						} else {

							if (rs_tJDBCInput_26.getObject(10) != null) {
								row25.cpu_per_socket = rs_tJDBCInput_26
										.getShort(10);
							} else {
								row25.cpu_per_socket = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 11) {
							row25.number_of_sockets = null;
						} else {

							if (rs_tJDBCInput_26.getObject(11) != null) {
								row25.number_of_sockets = rs_tJDBCInput_26
										.getShort(11);
							} else {
								row25.number_of_sockets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 12) {
							row25.memory_size_mb = null;
						} else {

							if (rs_tJDBCInput_26.getObject(12) != null) {
								row25.memory_size_mb = rs_tJDBCInput_26
										.getInt(12);
							} else {
								row25.memory_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 13) {
							row25.operating_system = null;
						} else {

							if (rs_tJDBCInput_26.getObject(13) != null) {
								row25.operating_system = rs_tJDBCInput_26
										.getShort(13);
							} else {
								row25.operating_system = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 14) {
							row25.default_host = null;
						} else {

							if (rs_tJDBCInput_26.getObject(14) != null) {
								row25.default_host = rs_tJDBCInput_26
										.getObject(14);
							} else {
								row25.default_host = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 15) {
							row25.high_availability = null;
						} else {

							if (rs_tJDBCInput_26.getObject(15) != null) {
								row25.high_availability = rs_tJDBCInput_26
										.getBoolean(15);
							} else {
								row25.high_availability = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 16) {
							row25.initialized = null;
						} else {

							if (rs_tJDBCInput_26.getObject(16) != null) {
								row25.initialized = rs_tJDBCInput_26
										.getBoolean(16);
							} else {
								row25.initialized = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 17) {
							row25.stateless = null;
						} else {

							if (rs_tJDBCInput_26.getObject(17) != null) {
								row25.stateless = rs_tJDBCInput_26
										.getBoolean(17);
							} else {
								row25.stateless = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 18) {
							row25.fail_back = null;
						} else {

							if (rs_tJDBCInput_26.getObject(18) != null) {
								row25.fail_back = rs_tJDBCInput_26
										.getBoolean(18);
							} else {
								row25.fail_back = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 19) {
							row25.usb_policy = null;
						} else {

							if (rs_tJDBCInput_26.getObject(19) != null) {
								row25.usb_policy = rs_tJDBCInput_26
										.getShort(19);
							} else {
								row25.usb_policy = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 20) {
							row25.time_zone = null;
						} else {

							row25.time_zone = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_26, 20, false);
						}
						if (colQtyInRs_tJDBCInput_26 < 21) {
							row25.vm_pool_id = null;
						} else {

							if (rs_tJDBCInput_26.getObject(21) != null) {
								row25.vm_pool_id = rs_tJDBCInput_26
										.getObject(21);
							} else {
								row25.vm_pool_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 22) {
							row25.vm_pool_name = null;
						} else {

							row25.vm_pool_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_26, 22, false);
						}
						if (colQtyInRs_tJDBCInput_26 < 23) {
							row25.created_by_user_id = null;
						} else {

							if (rs_tJDBCInput_26.getObject(23) != null) {
								row25.created_by_user_id = rs_tJDBCInput_26
										.getObject(23);
							} else {
								row25.created_by_user_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 24) {
							row25.cluster_configuration_version = null;
						} else {

							if (rs_tJDBCInput_26.getObject(24) != null) {
								row25.cluster_configuration_version = rs_tJDBCInput_26
										.getInt(24);
							} else {
								row25.cluster_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 25) {
							row25.default_host_configuration_version = null;
						} else {

							if (rs_tJDBCInput_26.getObject(25) != null) {
								row25.default_host_configuration_version = rs_tJDBCInput_26
										.getInt(25);
							} else {
								row25.default_host_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_26 < 26) {
							row25.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_26 = null;
							try {
								date_tJDBCInput_26 = rs_tJDBCInput_26
										.getTimestamp(26);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_26 = rs_tJDBCInput_26
										.getDate(26);
							}
							row25.create_date = date_tJDBCInput_26;
						}
						if (colQtyInRs_tJDBCInput_26 < 27) {
							row25.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_26 = null;
							try {
								date_tJDBCInput_26 = rs_tJDBCInput_26
										.getTimestamp(27);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_26 = rs_tJDBCInput_26
										.getDate(27);
							}
							row25.update_date = date_tJDBCInput_26;
						}

						/**
						 * [tJDBCInput_26 begin ] stop
						 */

						/**
						 * [tJDBCInput_26 main ] start
						 */

						currentComponent = "tJDBCInput_26";

						tos_count_tJDBCInput_26++;

						/**
						 * [tJDBCInput_26 main ] stop
						 */

						/**
						 * [tMap_19 main ] start
						 */

						currentComponent = "tMap_19";

						boolean hasCasePrimitiveKeyWithNull_tMap_19 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_19 = false;
						boolean mainRowRejected_tMap_19 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row24"
						// /////////////////////////////////////////////

						boolean forceLooprow24 = false;

						row24Struct row24ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_19) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_19 = false;

							row24HashKey.vm_join_id = row25.vm_join_id;

							row24HashKey.hashCodeDirty = true;

							tHash_Lookup_row24.lookup(row24HashKey);

							if (!tHash_Lookup_row24.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_19 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row24 != null
								&& tHash_Lookup_row24.getCount(row24HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row24' and it contains more one result from keys :  row24.vm_join_id = '"
							// + row24HashKey.vm_join_id + "'");
						} // G 071

						row24Struct row24 = null;

						row24Struct fromLookup_row24 = null;
						row24 = row24Default;

						if (tHash_Lookup_row24 != null
								&& tHash_Lookup_row24.hasNext()) { // G 099

							fromLookup_row24 = tHash_Lookup_row24.next();

						} // G 099

						if (fromLookup_row24 != null) {
							row24 = fromLookup_row24;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_19__Struct Var = Var__tMap_19;// ###############################
							// ###############################
							// # Output tables

							delete_vms = null;

							if (!rejectedInnerJoin_tMap_19) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_vms'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_19) {
								delete_vms_tmp.vm_id = row25.vm_id;
								delete_vms_tmp.vm_name = row25.vm_name;
								delete_vms_tmp.vm_description = row25.vm_description;
								delete_vms_tmp.vm_type = row25.vm_type;
								delete_vms_tmp.cluster_id = row25.cluster_id;
								delete_vms_tmp.template_id = row25.template_id;
								delete_vms_tmp.template_name = row25.template_name;
								delete_vms_tmp.cpu_per_socket = row25.cpu_per_socket;
								delete_vms_tmp.number_of_sockets = row25.number_of_sockets;
								delete_vms_tmp.memory_size_mb = row25.memory_size_mb;
								delete_vms_tmp.operating_system = row25.operating_system;
								delete_vms_tmp.default_host = row25.default_host;
								delete_vms_tmp.high_availability = row25.high_availability;
								delete_vms_tmp.initialized = row25.initialized;
								delete_vms_tmp.stateless = row25.stateless;
								delete_vms_tmp.fail_back = row25.fail_back;
								delete_vms_tmp.usb_policy = row25.usb_policy;
								delete_vms_tmp.time_zone = row25.time_zone;
								delete_vms_tmp.vm_pool_id = row25.vm_pool_id;
								delete_vms_tmp.vm_pool_name = row25.vm_pool_name;
								delete_vms_tmp.created_by_user_id = row25.created_by_user_id;
								delete_vms_tmp.cluster_configuration_version = row25.cluster_configuration_version;
								delete_vms_tmp.default_host_configuration_version = row25.default_host_configuration_version;
								delete_vms_tmp.create_date = row25.create_date;
								delete_vms_tmp.update_date = context.runTime;
								delete_vms_tmp.delete_date = context.runTime;
								delete_vms = delete_vms_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_19 = false;

						tos_count_tMap_19++;

						/**
						 * [tMap_19 main ] stop
						 */
						// Start of branch "delete_vms"
						if (delete_vms != null) {

							/**
							 * [tJDBCOutput_19 main ] start
							 */

							currentComponent = "tJDBCOutput_19";

							whetherReject_tJDBCOutput_19 = false;
							if (delete_vms.vm_id == null) {
								pstmt_tJDBCOutput_19.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_19.setObject(1,
										delete_vms.vm_id);
							}

							if (delete_vms.vm_name == null) {
								pstmt_tJDBCOutput_19.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_19.setString(2,
										delete_vms.vm_name);
							}

							if (delete_vms.vm_description == null) {
								pstmt_tJDBCOutput_19.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_19.setString(3,
										delete_vms.vm_description);
							}

							if (delete_vms.vm_type == null) {
								pstmt_tJDBCOutput_19.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19.setShort(4,
										delete_vms.vm_type);
							}

							if (delete_vms.cluster_id == null) {
								pstmt_tJDBCOutput_19.setNull(5,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_19.setObject(5,
										delete_vms.cluster_id);
							}

							if (delete_vms.template_id == null) {
								pstmt_tJDBCOutput_19.setNull(6,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_19.setObject(6,
										delete_vms.template_id);
							}

							if (delete_vms.template_name == null) {
								pstmt_tJDBCOutput_19.setNull(7,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_19.setString(7,
										delete_vms.template_name);
							}

							if (delete_vms.cpu_per_socket == null) {
								pstmt_tJDBCOutput_19.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19.setShort(8,
										delete_vms.cpu_per_socket);
							}

							if (delete_vms.number_of_sockets == null) {
								pstmt_tJDBCOutput_19.setNull(9,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19.setShort(9,
										delete_vms.number_of_sockets);
							}

							if (delete_vms.memory_size_mb == null) {
								pstmt_tJDBCOutput_19.setNull(10,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19.setInt(10,
										delete_vms.memory_size_mb);
							}

							pstmt_tJDBCOutput_19.setShort(11,
									delete_vms.operating_system);

							if (delete_vms.default_host == null) {
								pstmt_tJDBCOutput_19.setNull(12,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_19.setObject(12,
										delete_vms.default_host);
							}

							if (delete_vms.high_availability == null) {
								pstmt_tJDBCOutput_19.setNull(13,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_19.setBoolean(13,
										delete_vms.high_availability);
							}

							if (delete_vms.initialized == null) {
								pstmt_tJDBCOutput_19.setNull(14,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_19.setBoolean(14,
										delete_vms.initialized);
							}

							if (delete_vms.stateless == null) {
								pstmt_tJDBCOutput_19.setNull(15,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_19.setBoolean(15,
										delete_vms.stateless);
							}

							if (delete_vms.fail_back == null) {
								pstmt_tJDBCOutput_19.setNull(16,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_19.setBoolean(16,
										delete_vms.fail_back);
							}

							if (delete_vms.usb_policy == null) {
								pstmt_tJDBCOutput_19.setNull(17,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19.setShort(17,
										delete_vms.usb_policy);
							}

							if (delete_vms.time_zone == null) {
								pstmt_tJDBCOutput_19.setNull(18,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_19.setString(18,
										delete_vms.time_zone);
							}

							if (delete_vms.vm_pool_id == null) {
								pstmt_tJDBCOutput_19.setNull(19,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_19.setObject(19,
										delete_vms.vm_pool_id);
							}

							if (delete_vms.vm_pool_name == null) {
								pstmt_tJDBCOutput_19.setNull(20,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_19.setString(20,
										delete_vms.vm_pool_name);
							}

							if (delete_vms.created_by_user_id == null) {
								pstmt_tJDBCOutput_19.setNull(21,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_19.setObject(21,
										delete_vms.created_by_user_id);
							}

							if (delete_vms.cluster_configuration_version == null) {
								pstmt_tJDBCOutput_19.setNull(22,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19
										.setInt(22,
												delete_vms.cluster_configuration_version);
							}

							if (delete_vms.default_host_configuration_version == null) {
								pstmt_tJDBCOutput_19.setNull(23,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_19
										.setInt(23,
												delete_vms.default_host_configuration_version);
							}

							if (delete_vms.create_date != null) {
								pstmt_tJDBCOutput_19.setTimestamp(
										24,
										new java.sql.Timestamp(
												delete_vms.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_19.setNull(24,
										java.sql.Types.DATE);
							}

							if (delete_vms.update_date != null) {
								pstmt_tJDBCOutput_19.setTimestamp(
										25,
										new java.sql.Timestamp(
												delete_vms.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_19.setNull(25,
										java.sql.Types.DATE);
							}

							if (delete_vms.delete_date != null) {
								pstmt_tJDBCOutput_19.setTimestamp(
										26,
										new java.sql.Timestamp(
												delete_vms.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_19.setNull(26,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_19 = insertedCount_tJDBCOutput_19
										+ pstmt_tJDBCOutput_19.executeUpdate();
								nb_line_tJDBCOutput_19++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_19 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_19++;

							/**
							 * [tJDBCOutput_19 main ] stop
							 */

						} // End of branch "delete_vms"

						/**
						 * [tJDBCInput_26 end ] start
						 */

						currentComponent = "tJDBCInput_26";

					}
				} finally {
					if (rs_tJDBCInput_26 != null) {
						rs_tJDBCInput_26.close();
					}
					stmt_tJDBCInput_26.close();

				}
				globalMap.put("tJDBCInput_26_NB_LINE", nb_line_tJDBCInput_26);

				ok_Hash.put("tJDBCInput_26", true);
				end_Hash.put("tJDBCInput_26", System.currentTimeMillis());

				/**
				 * [tJDBCInput_26 end ] stop
				 */

				/**
				 * [tMap_19 end ] start
				 */

				currentComponent = "tMap_19";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row24 != null) {
					tHash_Lookup_row24.endGet();
				}
				globalMap.remove("tHash_Lookup_row24");

				// ###############################

				ok_Hash.put("tMap_19", true);
				end_Hash.put("tMap_19", System.currentTimeMillis());

				/**
				 * [tMap_19 end ] stop
				 */

				/**
				 * [tJDBCOutput_19 end ] start
				 */

				currentComponent = "tJDBCOutput_19";

				if (pstmt_tJDBCOutput_19 != null) {

					pstmt_tJDBCOutput_19.close();

				}

				nb_line_deleted_tJDBCOutput_19 = nb_line_deleted_tJDBCOutput_19
						+ deletedCount_tJDBCOutput_19;
				nb_line_update_tJDBCOutput_19 = nb_line_update_tJDBCOutput_19
						+ updatedCount_tJDBCOutput_19;
				nb_line_inserted_tJDBCOutput_19 = nb_line_inserted_tJDBCOutput_19
						+ insertedCount_tJDBCOutput_19;
				nb_line_rejected_tJDBCOutput_19 = nb_line_rejected_tJDBCOutput_19
						+ rejectedCount_tJDBCOutput_19;

				globalMap.put("tJDBCOutput_19_NB_LINE", nb_line_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_19);

				ok_Hash.put("tJDBCOutput_19", true);
				end_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_19 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_26:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_7Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_19"
			globalMap.remove("tHash_Lookup_row24");

			try {

				/**
				 * [tJDBCInput_26 finally ] start
				 */

				currentComponent = "tJDBCInput_26";

				/**
				 * [tJDBCInput_26 finally ] stop
				 */

				/**
				 * [tMap_19 finally ] start
				 */

				currentComponent = "tMap_19";

				/**
				 * [tMap_19 finally ] stop
				 */

				/**
				 * [tJDBCOutput_19 finally ] start
				 */

				currentComponent = "tJDBCOutput_19";

				/**
				 * [tJDBCOutput_19 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", 1);
	}

	public static class vm_disk_configurationStruct implements
			routines.system.IPersistableRow<vm_disk_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_description = readString(dis);

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.vm_disk_description, dos);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_name, dos);

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_disk_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row6Struct implements
			routines.system.IPersistableRow<row6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_name = readString(dis);

					this.vm_disk_description = readString(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_name, dos);

				// String

				writeString(this.vm_disk_description, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row6Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_7Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row6Struct row6 = new row6Struct();
				vm_disk_configurationStruct vm_disk_configuration = new vm_disk_configurationStruct();

				/**
				 * [tJDBCOutput_7 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_7", false);
				start_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_7";

				int tos_count_tJDBCOutput_7 = 0;

				int nb_line_tJDBCOutput_7 = 0;
				int nb_line_update_tJDBCOutput_7 = 0;
				int nb_line_inserted_tJDBCOutput_7 = 0;
				int nb_line_deleted_tJDBCOutput_7 = 0;
				int nb_line_rejected_tJDBCOutput_7 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_7 = 0;

				int deletedCount_tJDBCOutput_7 = 0;
				int updatedCount_tJDBCOutput_7 = 0;
				int insertedCount_tJDBCOutput_7 = 0;
				int rejectedCount_tJDBCOutput_7 = 0;

				boolean whetherReject_tJDBCOutput_7 = false;

				java.sql.Connection connection_tJDBCOutput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_7 = "INSERT INTO "
						+ "vm_disk_configuration"
						+ " (storage_domain_id,vm_disk_description,vm_disk_size_mb,vm_disk_type,vm_disk_format,create_date,update_date,delete_date,vm_disk_id,vm_disk_name,is_shared) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_7 = connection_tJDBCOutput_7
						.prepareStatement(insert_tJDBCOutput_7);

				/**
				 * [tJDBCOutput_7 begin ] stop
				 */

				/**
				 * [tMap_7 begin ] start
				 */

				ok_Hash.put("tMap_7", false);
				start_Hash.put("tMap_7", System.currentTimeMillis());

				currentComponent = "tMap_7";

				int tos_count_tMap_7 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_7__Struct {
				}
				Var__tMap_7__Struct Var__tMap_7 = new Var__tMap_7__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_disk_configurationStruct vm_disk_configuration_tmp = new vm_disk_configurationStruct();
				// ###############################

				/**
				 * [tMap_7 begin ] stop
				 */

				/**
				 * [tJDBCInput_7 begin ] start
				 */

				ok_Hash.put("tJDBCInput_7", false);
				start_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				currentComponent = "tJDBCInput_7";

				int tos_count_tJDBCInput_7 = 0;

				int nb_line_tJDBCInput_7 = 0;
				java.sql.Connection conn_tJDBCInput_7 = null;
				conn_tJDBCInput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_7 = conn_tJDBCInput_7
						.createStatement();

				String dbquery_tJDBCInput_7 = "SELECT vm_disk_id,\n        vm_disk_name,\n        vm_disk_description,\n		storage_domain_id,\n		vm_disk_size_mb,\n		vm_disk_type,\n		vm_disk_format,\n        is_shared,\n		create_date,\n		update_date \nFROM dwh_vm_disk_configuration_history_view";

				globalMap.put("tJDBCInput_7_QUERY", dbquery_tJDBCInput_7);

				java.sql.ResultSet rs_tJDBCInput_7 = null;
				try {
					rs_tJDBCInput_7 = stmt_tJDBCInput_7
							.executeQuery(dbquery_tJDBCInput_7);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_7 = rs_tJDBCInput_7
							.getMetaData();
					int colQtyInRs_tJDBCInput_7 = rsmd_tJDBCInput_7
							.getColumnCount();

					String tmpContent_tJDBCInput_7 = null;

					while (rs_tJDBCInput_7.next()) {
						nb_line_tJDBCInput_7++;

						if (colQtyInRs_tJDBCInput_7 < 1) {
							row6.vm_disk_id = null;
						} else {

							if (rs_tJDBCInput_7.getObject(1) != null) {
								row6.vm_disk_id = rs_tJDBCInput_7.getObject(1);
							} else {
								row6.vm_disk_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_7 < 2) {
							row6.vm_disk_name = null;
						} else {

							row6.vm_disk_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_7, 2, false);
						}
						if (colQtyInRs_tJDBCInput_7 < 3) {
							row6.vm_disk_description = null;
						} else {

							row6.vm_disk_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_7, 3, false);
						}
						if (colQtyInRs_tJDBCInput_7 < 4) {
							row6.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_7.getObject(4) != null) {
								row6.storage_domain_id = rs_tJDBCInput_7
										.getObject(4);
							} else {
								row6.storage_domain_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_7 < 5) {
							row6.vm_disk_size_mb = null;
						} else {

							if (rs_tJDBCInput_7.getObject(5) != null) {
								row6.vm_disk_size_mb = rs_tJDBCInput_7
										.getInt(5);
							} else {
								row6.vm_disk_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_7 < 6) {
							row6.vm_disk_type = null;
						} else {

							if (rs_tJDBCInput_7.getObject(6) != null) {
								row6.vm_disk_type = rs_tJDBCInput_7.getShort(6);
							} else {
								row6.vm_disk_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_7 < 7) {
							row6.vm_disk_format = null;
						} else {

							if (rs_tJDBCInput_7.getObject(7) != null) {
								row6.vm_disk_format = rs_tJDBCInput_7
										.getShort(7);
							} else {
								row6.vm_disk_format = null;
							}
						}
						if (colQtyInRs_tJDBCInput_7 < 8) {
							row6.is_shared = null;
						} else {

							if (rs_tJDBCInput_7.getObject(8) != null) {
								row6.is_shared = rs_tJDBCInput_7.getBoolean(8);
							} else {
								row6.is_shared = null;
							}
						}
						if (colQtyInRs_tJDBCInput_7 < 9) {
							row6.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_7 = null;
							try {
								date_tJDBCInput_7 = rs_tJDBCInput_7
										.getTimestamp(9);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_7 = rs_tJDBCInput_7.getDate(9);
							}
							row6.create_date = date_tJDBCInput_7;
						}
						if (colQtyInRs_tJDBCInput_7 < 10) {
							row6.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_7 = null;
							try {
								date_tJDBCInput_7 = rs_tJDBCInput_7
										.getTimestamp(10);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_7 = rs_tJDBCInput_7.getDate(10);
							}
							row6.update_date = date_tJDBCInput_7;
						}

						/**
						 * [tJDBCInput_7 begin ] stop
						 */

						/**
						 * [tJDBCInput_7 main ] start
						 */

						currentComponent = "tJDBCInput_7";

						tos_count_tJDBCInput_7++;

						/**
						 * [tJDBCInput_7 main ] stop
						 */

						/**
						 * [tMap_7 main ] start
						 */

						currentComponent = "tMap_7";

						boolean hasCasePrimitiveKeyWithNull_tMap_7 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_7 = false;
						boolean mainRowRejected_tMap_7 = false;

						if (

						(

						row6.update_date == null ? TalendDate.compareDate(
								row6.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row6.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row6'
							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_7__Struct Var = Var__tMap_7;// ###############################
								// ###############################
								// # Output tables

								vm_disk_configuration = null;

								// # Output table : 'vm_disk_configuration'
								vm_disk_configuration_tmp.storage_domain_id = row6.storage_domain_id;
								vm_disk_configuration_tmp.vm_disk_description = StringHandling
										.TRIM(row6.vm_disk_description);
								vm_disk_configuration_tmp.vm_disk_size_mb = row6.vm_disk_size_mb;
								vm_disk_configuration_tmp.vm_disk_type = row6.vm_disk_type;
								vm_disk_configuration_tmp.vm_disk_format = row6.vm_disk_format;
								vm_disk_configuration_tmp.create_date = row6.create_date;
								vm_disk_configuration_tmp.update_date = row6.update_date;
								vm_disk_configuration_tmp.delete_date = null;
								vm_disk_configuration_tmp.vm_disk_id = row6.vm_disk_id;
								vm_disk_configuration_tmp.vm_disk_name = row6.vm_disk_name;
								vm_disk_configuration_tmp.is_shared = row6.is_shared;
								vm_disk_configuration = vm_disk_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_7 = false;

							tos_count_tMap_7++;

							/**
							 * [tMap_7 main ] stop
							 */
							// Start of branch "vm_disk_configuration"
							if (vm_disk_configuration != null) {

								/**
								 * [tJDBCOutput_7 main ] start
								 */

								currentComponent = "tJDBCOutput_7";

								whetherReject_tJDBCOutput_7 = false;
								if (vm_disk_configuration.storage_domain_id == null) {
									pstmt_tJDBCOutput_7.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_7
											.setObject(
													1,
													vm_disk_configuration.storage_domain_id);
								}

								if (vm_disk_configuration.vm_disk_description == null) {
									pstmt_tJDBCOutput_7.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_7
											.setString(
													2,
													vm_disk_configuration.vm_disk_description);
								}

								if (vm_disk_configuration.vm_disk_size_mb == null) {
									pstmt_tJDBCOutput_7.setNull(3,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_7
											.setInt(3,
													vm_disk_configuration.vm_disk_size_mb);
								}

								if (vm_disk_configuration.vm_disk_type == null) {
									pstmt_tJDBCOutput_7.setNull(4,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_7.setShort(4,
											vm_disk_configuration.vm_disk_type);
								}

								if (vm_disk_configuration.vm_disk_format == null) {
									pstmt_tJDBCOutput_7.setNull(5,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_7
											.setShort(
													5,
													vm_disk_configuration.vm_disk_format);
								}

								if (vm_disk_configuration.create_date != null) {
									pstmt_tJDBCOutput_7
											.setTimestamp(
													6,
													new java.sql.Timestamp(
															vm_disk_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_7.setNull(6,
											java.sql.Types.DATE);
								}

								if (vm_disk_configuration.update_date != null) {
									pstmt_tJDBCOutput_7
											.setTimestamp(
													7,
													new java.sql.Timestamp(
															vm_disk_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_7.setNull(7,
											java.sql.Types.DATE);
								}

								if (vm_disk_configuration.delete_date != null) {
									pstmt_tJDBCOutput_7
											.setTimestamp(
													8,
													new java.sql.Timestamp(
															vm_disk_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_7.setNull(8,
											java.sql.Types.DATE);
								}

								if (vm_disk_configuration.vm_disk_id == null) {
									pstmt_tJDBCOutput_7.setNull(9,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_7.setObject(9,
											vm_disk_configuration.vm_disk_id);
								}

								if (vm_disk_configuration.vm_disk_name == null) {
									pstmt_tJDBCOutput_7.setNull(10,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_7.setString(10,
											vm_disk_configuration.vm_disk_name);
								}

								if (vm_disk_configuration.is_shared == null) {
									pstmt_tJDBCOutput_7.setNull(11,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_7.setBoolean(11,
											vm_disk_configuration.is_shared);
								}

								try {
									insertedCount_tJDBCOutput_7 = insertedCount_tJDBCOutput_7
											+ pstmt_tJDBCOutput_7
													.executeUpdate();
									nb_line_tJDBCOutput_7++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_7 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_7++;

								/**
								 * [tJDBCOutput_7 main ] stop
								 */

							} // End of branch "vm_disk_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row6'

						/**
						 * [tJDBCInput_7 end ] start
						 */

						currentComponent = "tJDBCInput_7";

					}
				} finally {
					if (rs_tJDBCInput_7 != null) {
						rs_tJDBCInput_7.close();
					}
					stmt_tJDBCInput_7.close();

				}
				globalMap.put("tJDBCInput_7_NB_LINE", nb_line_tJDBCInput_7);

				ok_Hash.put("tJDBCInput_7", true);
				end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				/**
				 * [tJDBCInput_7 end ] stop
				 */

				/**
				 * [tMap_7 end ] start
				 */

				currentComponent = "tMap_7";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_7", true);
				end_Hash.put("tMap_7", System.currentTimeMillis());

				/**
				 * [tMap_7 end ] stop
				 */

				/**
				 * [tJDBCOutput_7 end ] start
				 */

				currentComponent = "tJDBCOutput_7";

				if (pstmt_tJDBCOutput_7 != null) {

					pstmt_tJDBCOutput_7.close();

				}

				nb_line_deleted_tJDBCOutput_7 = nb_line_deleted_tJDBCOutput_7
						+ deletedCount_tJDBCOutput_7;
				nb_line_update_tJDBCOutput_7 = nb_line_update_tJDBCOutput_7
						+ updatedCount_tJDBCOutput_7;
				nb_line_inserted_tJDBCOutput_7 = nb_line_inserted_tJDBCOutput_7
						+ insertedCount_tJDBCOutput_7;
				nb_line_rejected_tJDBCOutput_7 = nb_line_rejected_tJDBCOutput_7
						+ rejectedCount_tJDBCOutput_7;

				globalMap.put("tJDBCOutput_7_NB_LINE", nb_line_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_7);

				ok_Hash.put("tJDBCOutput_7", true);
				end_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_7 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_7:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_28Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_7 finally ] start
				 */

				currentComponent = "tJDBCInput_7";

				/**
				 * [tJDBCInput_7 finally ] stop
				 */

				/**
				 * [tMap_7 finally ] start
				 */

				currentComponent = "tMap_7";

				/**
				 * [tMap_7 finally ] stop
				 */

				/**
				 * [tJDBCOutput_7 finally ] start
				 */

				currentComponent = "tJDBCOutput_7";

				/**
				 * [tJDBCOutput_7 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 1);
	}

	public static class delete_disksStruct implements
			routines.system.IPersistableRow<delete_disksStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_description = readString(dis);

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.storage_domain_id);

				// String

				writeString(this.vm_disk_description, dos);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_name, dos);

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_disksStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row27Struct implements
			routines.system.IPersistableRow<row27Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_disk_name = readString(dis);

					this.vm_disk_description = readString(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// String

				writeString(this.vm_disk_name, dos);

				// String

				writeString(this.vm_disk_description, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row27Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_28Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_28Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_disk_id;

		public Object getVm_disk_id() {
			return this.vm_disk_id;
		}

		public String vm_disk_join_id;

		public String getVm_disk_join_id() {
			return this.vm_disk_join_id;
		}

		public String vm_disk_name;

		public String getVm_disk_name() {
			return this.vm_disk_name;
		}

		public String vm_disk_description;

		public String getVm_disk_description() {
			return this.vm_disk_description;
		}

		public Object storage_domain_id;

		public Object getStorage_domain_id() {
			return this.storage_domain_id;
		}

		public Integer vm_disk_size_mb;

		public Integer getVm_disk_size_mb() {
			return this.vm_disk_size_mb;
		}

		public Short vm_disk_type;

		public Short getVm_disk_type() {
			return this.vm_disk_type;
		}

		public Short vm_disk_format;

		public Short getVm_disk_format() {
			return this.vm_disk_format;
		}

		public Boolean is_shared;

		public Boolean getIs_shared() {
			return this.is_shared;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_disk_id = (Object) dis.readObject();

					this.vm_disk_join_id = readString(dis);

					this.vm_disk_name = readString(dis);

					this.vm_disk_description = readString(dis);

					this.storage_domain_id = (Object) dis.readObject();

					this.vm_disk_size_mb = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_type = null;
					} else {
						this.vm_disk_type = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.vm_disk_format = null;
					} else {
						this.vm_disk_format = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_shared = null;
					} else {
						this.is_shared = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_disk_id);

				// String

				writeString(this.vm_disk_join_id, dos);

				// String

				writeString(this.vm_disk_name, dos);

				// String

				writeString(this.vm_disk_description, dos);

				// Object

				dos.writeObject(this.storage_domain_id);

				// Integer

				writeInteger(this.vm_disk_size_mb, dos);

				// Short

				if (this.vm_disk_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_type);
				}

				// Short

				if (this.vm_disk_format == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_disk_format);
				}

				// Boolean

				if (this.is_shared == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_shared);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_disk_id=" + String.valueOf(vm_disk_id));
			sb.append(",vm_disk_join_id=" + vm_disk_join_id);
			sb.append(",vm_disk_name=" + vm_disk_name);
			sb.append(",vm_disk_description=" + vm_disk_description);
			sb.append(",storage_domain_id=" + String.valueOf(storage_domain_id));
			sb.append(",vm_disk_size_mb=" + String.valueOf(vm_disk_size_mb));
			sb.append(",vm_disk_type=" + String.valueOf(vm_disk_type));
			sb.append(",vm_disk_format=" + String.valueOf(vm_disk_format));
			sb.append(",is_shared=" + String.valueOf(is_shared));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_28Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_28Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_28_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_27Process(globalMap);

				row27Struct row27 = new row27Struct();
				delete_disksStruct delete_disks = new delete_disksStruct();

				/**
				 * [tJDBCOutput_20 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_20", false);
				start_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_20";

				int tos_count_tJDBCOutput_20 = 0;

				int nb_line_tJDBCOutput_20 = 0;
				int nb_line_update_tJDBCOutput_20 = 0;
				int nb_line_inserted_tJDBCOutput_20 = 0;
				int nb_line_deleted_tJDBCOutput_20 = 0;
				int nb_line_rejected_tJDBCOutput_20 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_20 = 0;

				int deletedCount_tJDBCOutput_20 = 0;
				int updatedCount_tJDBCOutput_20 = 0;
				int insertedCount_tJDBCOutput_20 = 0;
				int rejectedCount_tJDBCOutput_20 = 0;

				boolean whetherReject_tJDBCOutput_20 = false;

				java.sql.Connection connection_tJDBCOutput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_20 = "INSERT INTO "
						+ "vm_disk_configuration"
						+ " (storage_domain_id,vm_disk_description,vm_disk_size_mb,vm_disk_type,vm_disk_format,create_date,update_date,delete_date,vm_disk_id,vm_disk_name,is_shared) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_20 = connection_tJDBCOutput_20
						.prepareStatement(insert_tJDBCOutput_20);

				/**
				 * [tJDBCOutput_20 begin ] stop
				 */

				/**
				 * [tMap_20 begin ] start
				 */

				ok_Hash.put("tMap_20", false);
				start_Hash.put("tMap_20", System.currentTimeMillis());

				currentComponent = "tMap_20";

				int tos_count_tMap_20 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row26Struct> tHash_Lookup_row26 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row26Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row26Struct>) globalMap
						.get("tHash_Lookup_row26"));

				row26Struct row26HashKey = new row26Struct();
				row26Struct row26Default = new row26Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_20__Struct {
				}
				Var__tMap_20__Struct Var__tMap_20 = new Var__tMap_20__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_disksStruct delete_disks_tmp = new delete_disksStruct();
				// ###############################

				/**
				 * [tMap_20 begin ] stop
				 */

				/**
				 * [tJDBCInput_28 begin ] start
				 */

				ok_Hash.put("tJDBCInput_28", false);
				start_Hash.put("tJDBCInput_28", System.currentTimeMillis());

				currentComponent = "tJDBCInput_28";

				int tos_count_tJDBCInput_28 = 0;

				int nb_line_tJDBCInput_28 = 0;
				java.sql.Connection conn_tJDBCInput_28 = null;
				conn_tJDBCInput_28 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_28 = conn_tJDBCInput_28
						.createStatement();

				String dbquery_tJDBCInput_28 = "SELECT	history_id, \n		vm_disk_id, \n		upper(cast(vm_disk_id as char(36))) as vm_disk_join_id,\n        vm_disk_name,\n        vm_disk_description,\n		storage_domain_id,\n		vm_disk_size_mb,\n		vm_disk_type, \n		vm_disk_format,\n        is_shared,\n		create_date, \n		update_date\nFROM v4_4_latest_configuration_vms_disks";

				globalMap.put("tJDBCInput_28_QUERY", dbquery_tJDBCInput_28);

				java.sql.ResultSet rs_tJDBCInput_28 = null;
				try {
					rs_tJDBCInput_28 = stmt_tJDBCInput_28
							.executeQuery(dbquery_tJDBCInput_28);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_28 = rs_tJDBCInput_28
							.getMetaData();
					int colQtyInRs_tJDBCInput_28 = rsmd_tJDBCInput_28
							.getColumnCount();

					String tmpContent_tJDBCInput_28 = null;

					while (rs_tJDBCInput_28.next()) {
						nb_line_tJDBCInput_28++;

						if (colQtyInRs_tJDBCInput_28 < 1) {
							row27.history_id = null;
						} else {

							if (rs_tJDBCInput_28.getObject(1) != null) {
								row27.history_id = rs_tJDBCInput_28.getInt(1);
							} else {
								row27.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 2) {
							row27.vm_disk_id = null;
						} else {

							if (rs_tJDBCInput_28.getObject(2) != null) {
								row27.vm_disk_id = rs_tJDBCInput_28
										.getObject(2);
							} else {
								row27.vm_disk_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 3) {
							row27.vm_disk_join_id = null;
						} else {

							row27.vm_disk_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_28, 3, false);
						}
						if (colQtyInRs_tJDBCInput_28 < 4) {
							row27.vm_disk_name = null;
						} else {

							row27.vm_disk_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_28, 4, false);
						}
						if (colQtyInRs_tJDBCInput_28 < 5) {
							row27.vm_disk_description = null;
						} else {

							row27.vm_disk_description = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_28, 5, false);
						}
						if (colQtyInRs_tJDBCInput_28 < 6) {
							row27.storage_domain_id = null;
						} else {

							if (rs_tJDBCInput_28.getObject(6) != null) {
								row27.storage_domain_id = rs_tJDBCInput_28
										.getObject(6);
							} else {
								row27.storage_domain_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 7) {
							row27.vm_disk_size_mb = null;
						} else {

							if (rs_tJDBCInput_28.getObject(7) != null) {
								row27.vm_disk_size_mb = rs_tJDBCInput_28
										.getInt(7);
							} else {
								row27.vm_disk_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 8) {
							row27.vm_disk_type = null;
						} else {

							if (rs_tJDBCInput_28.getObject(8) != null) {
								row27.vm_disk_type = rs_tJDBCInput_28
										.getShort(8);
							} else {
								row27.vm_disk_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 9) {
							row27.vm_disk_format = null;
						} else {

							if (rs_tJDBCInput_28.getObject(9) != null) {
								row27.vm_disk_format = rs_tJDBCInput_28
										.getShort(9);
							} else {
								row27.vm_disk_format = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 10) {
							row27.is_shared = null;
						} else {

							if (rs_tJDBCInput_28.getObject(10) != null) {
								row27.is_shared = rs_tJDBCInput_28
										.getBoolean(10);
							} else {
								row27.is_shared = null;
							}
						}
						if (colQtyInRs_tJDBCInput_28 < 11) {
							row27.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_28 = null;
							try {
								date_tJDBCInput_28 = rs_tJDBCInput_28
										.getTimestamp(11);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_28 = rs_tJDBCInput_28
										.getDate(11);
							}
							row27.create_date = date_tJDBCInput_28;
						}
						if (colQtyInRs_tJDBCInput_28 < 12) {
							row27.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_28 = null;
							try {
								date_tJDBCInput_28 = rs_tJDBCInput_28
										.getTimestamp(12);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_28 = rs_tJDBCInput_28
										.getDate(12);
							}
							row27.update_date = date_tJDBCInput_28;
						}

						/**
						 * [tJDBCInput_28 begin ] stop
						 */

						/**
						 * [tJDBCInput_28 main ] start
						 */

						currentComponent = "tJDBCInput_28";

						tos_count_tJDBCInput_28++;

						/**
						 * [tJDBCInput_28 main ] stop
						 */

						/**
						 * [tMap_20 main ] start
						 */

						currentComponent = "tMap_20";

						boolean hasCasePrimitiveKeyWithNull_tMap_20 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_20 = false;
						boolean mainRowRejected_tMap_20 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row26"
						// /////////////////////////////////////////////

						boolean forceLooprow26 = false;

						row26Struct row26ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_20) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_20 = false;

							row26HashKey.vm_disk_join_id = row27.vm_disk_join_id;

							row26HashKey.hashCodeDirty = true;

							tHash_Lookup_row26.lookup(row26HashKey);

							if (!tHash_Lookup_row26.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_20 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row26 != null
								&& tHash_Lookup_row26.getCount(row26HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row26' and it contains more one result from keys :  row26.vm_disk_join_id = '"
							// + row26HashKey.vm_disk_join_id + "'");
						} // G 071

						row26Struct row26 = null;

						row26Struct fromLookup_row26 = null;
						row26 = row26Default;

						if (tHash_Lookup_row26 != null
								&& tHash_Lookup_row26.hasNext()) { // G 099

							fromLookup_row26 = tHash_Lookup_row26.next();

						} // G 099

						if (fromLookup_row26 != null) {
							row26 = fromLookup_row26;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_20__Struct Var = Var__tMap_20;// ###############################
							// ###############################
							// # Output tables

							delete_disks = null;

							if (!rejectedInnerJoin_tMap_20) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_disks'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_20) {
								delete_disks_tmp.storage_domain_id = row27.storage_domain_id;
								delete_disks_tmp.vm_disk_description = row27.vm_disk_description;
								delete_disks_tmp.vm_disk_size_mb = row27.vm_disk_size_mb;
								delete_disks_tmp.vm_disk_type = row27.vm_disk_type;
								delete_disks_tmp.vm_disk_format = row27.vm_disk_format;
								delete_disks_tmp.create_date = row27.create_date;
								delete_disks_tmp.update_date = context.runTime;
								delete_disks_tmp.delete_date = context.runTime;
								delete_disks_tmp.vm_disk_id = row27.vm_disk_id;
								delete_disks_tmp.vm_disk_name = row27.vm_disk_name;
								delete_disks_tmp.is_shared = row27.is_shared;
								delete_disks = delete_disks_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_20 = false;

						tos_count_tMap_20++;

						/**
						 * [tMap_20 main ] stop
						 */
						// Start of branch "delete_disks"
						if (delete_disks != null) {

							/**
							 * [tJDBCOutput_20 main ] start
							 */

							currentComponent = "tJDBCOutput_20";

							whetherReject_tJDBCOutput_20 = false;
							if (delete_disks.storage_domain_id == null) {
								pstmt_tJDBCOutput_20.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_20.setObject(1,
										delete_disks.storage_domain_id);
							}

							if (delete_disks.vm_disk_description == null) {
								pstmt_tJDBCOutput_20.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_20.setString(2,
										delete_disks.vm_disk_description);
							}

							if (delete_disks.vm_disk_size_mb == null) {
								pstmt_tJDBCOutput_20.setNull(3,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_20.setInt(3,
										delete_disks.vm_disk_size_mb);
							}

							if (delete_disks.vm_disk_type == null) {
								pstmt_tJDBCOutput_20.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_20.setShort(4,
										delete_disks.vm_disk_type);
							}

							if (delete_disks.vm_disk_format == null) {
								pstmt_tJDBCOutput_20.setNull(5,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_20.setShort(5,
										delete_disks.vm_disk_format);
							}

							if (delete_disks.create_date != null) {
								pstmt_tJDBCOutput_20.setTimestamp(
										6,
										new java.sql.Timestamp(
												delete_disks.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_20.setNull(6,
										java.sql.Types.DATE);
							}

							if (delete_disks.update_date != null) {
								pstmt_tJDBCOutput_20.setTimestamp(
										7,
										new java.sql.Timestamp(
												delete_disks.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_20.setNull(7,
										java.sql.Types.DATE);
							}

							if (delete_disks.delete_date != null) {
								pstmt_tJDBCOutput_20.setTimestamp(
										8,
										new java.sql.Timestamp(
												delete_disks.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_20.setNull(8,
										java.sql.Types.DATE);
							}

							if (delete_disks.vm_disk_id == null) {
								pstmt_tJDBCOutput_20.setNull(9,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_20.setObject(9,
										delete_disks.vm_disk_id);
							}

							if (delete_disks.vm_disk_name == null) {
								pstmt_tJDBCOutput_20.setNull(10,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_20.setString(10,
										delete_disks.vm_disk_name);
							}

							if (delete_disks.is_shared == null) {
								pstmt_tJDBCOutput_20.setNull(11,
										java.sql.Types.BOOLEAN);
							} else {
								pstmt_tJDBCOutput_20.setBoolean(11,
										delete_disks.is_shared);
							}

							try {
								insertedCount_tJDBCOutput_20 = insertedCount_tJDBCOutput_20
										+ pstmt_tJDBCOutput_20.executeUpdate();
								nb_line_tJDBCOutput_20++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_20 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_20++;

							/**
							 * [tJDBCOutput_20 main ] stop
							 */

						} // End of branch "delete_disks"

						/**
						 * [tJDBCInput_28 end ] start
						 */

						currentComponent = "tJDBCInput_28";

					}
				} finally {
					if (rs_tJDBCInput_28 != null) {
						rs_tJDBCInput_28.close();
					}
					stmt_tJDBCInput_28.close();

				}
				globalMap.put("tJDBCInput_28_NB_LINE", nb_line_tJDBCInput_28);

				ok_Hash.put("tJDBCInput_28", true);
				end_Hash.put("tJDBCInput_28", System.currentTimeMillis());

				/**
				 * [tJDBCInput_28 end ] stop
				 */

				/**
				 * [tMap_20 end ] start
				 */

				currentComponent = "tMap_20";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row26 != null) {
					tHash_Lookup_row26.endGet();
				}
				globalMap.remove("tHash_Lookup_row26");

				// ###############################

				ok_Hash.put("tMap_20", true);
				end_Hash.put("tMap_20", System.currentTimeMillis());

				/**
				 * [tMap_20 end ] stop
				 */

				/**
				 * [tJDBCOutput_20 end ] start
				 */

				currentComponent = "tJDBCOutput_20";

				if (pstmt_tJDBCOutput_20 != null) {

					pstmt_tJDBCOutput_20.close();

				}

				nb_line_deleted_tJDBCOutput_20 = nb_line_deleted_tJDBCOutput_20
						+ deletedCount_tJDBCOutput_20;
				nb_line_update_tJDBCOutput_20 = nb_line_update_tJDBCOutput_20
						+ updatedCount_tJDBCOutput_20;
				nb_line_inserted_tJDBCOutput_20 = nb_line_inserted_tJDBCOutput_20
						+ insertedCount_tJDBCOutput_20;
				nb_line_rejected_tJDBCOutput_20 = nb_line_rejected_tJDBCOutput_20
						+ rejectedCount_tJDBCOutput_20;

				globalMap.put("tJDBCOutput_20_NB_LINE", nb_line_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_20);

				ok_Hash.put("tJDBCOutput_20", true);
				end_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_20 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_28:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_8Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_20"
			globalMap.remove("tHash_Lookup_row26");

			try {

				/**
				 * [tJDBCInput_28 finally ] start
				 */

				currentComponent = "tJDBCInput_28";

				/**
				 * [tJDBCInput_28 finally ] stop
				 */

				/**
				 * [tMap_20 finally ] start
				 */

				currentComponent = "tMap_20";

				/**
				 * [tMap_20 finally ] stop
				 */

				/**
				 * [tJDBCOutput_20 finally ] start
				 */

				currentComponent = "tJDBCOutput_20";

				/**
				 * [tJDBCOutput_20 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_28_SUBPROCESS_STATE", 1);
	}

	public static class vm_interface_configurationStruct implements
			routines.system.IPersistableRow<vm_interface_configurationStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					this.vm_id = (Object) dis.readObject();

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Object

				dos.writeObject(this.vm_id);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(vm_interface_configurationStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row8Struct implements
			routines.system.IPersistableRow<row8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_8Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_8Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_44Process(globalMap);

				row8Struct row8 = new row8Struct();
				vm_interface_configurationStruct vm_interface_configuration = new vm_interface_configurationStruct();

				/**
				 * [tJDBCOutput_8 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_8", false);
				start_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_8";

				int tos_count_tJDBCOutput_8 = 0;

				int nb_line_tJDBCOutput_8 = 0;
				int nb_line_update_tJDBCOutput_8 = 0;
				int nb_line_inserted_tJDBCOutput_8 = 0;
				int nb_line_deleted_tJDBCOutput_8 = 0;
				int nb_line_rejected_tJDBCOutput_8 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_8 = 0;

				int deletedCount_tJDBCOutput_8 = 0;
				int updatedCount_tJDBCOutput_8 = 0;
				int insertedCount_tJDBCOutput_8 = 0;
				int rejectedCount_tJDBCOutput_8 = 0;

				boolean whetherReject_tJDBCOutput_8 = false;

				java.sql.Connection connection_tJDBCOutput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_8 = "INSERT INTO "
						+ "vm_interface_configuration"
						+ " (vm_interface_id,vm_interface_name,vm_id,vm_interface_type,vm_interface_speed_bps,mac_address,logical_network_name,vm_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_8 = connection_tJDBCOutput_8
						.prepareStatement(insert_tJDBCOutput_8);

				/**
				 * [tJDBCOutput_8 begin ] stop
				 */

				/**
				 * [tMap_8 begin ] start
				 */

				ok_Hash.put("tMap_8", false);
				start_Hash.put("tMap_8", System.currentTimeMillis());

				currentComponent = "tMap_8";

				int tos_count_tMap_8 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row40Struct> tHash_Lookup_row40 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row40Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row40Struct>) globalMap
						.get("tHash_Lookup_row40"));

				row40Struct row40HashKey = new row40Struct();
				row40Struct row40Default = new row40Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_8__Struct {
				}
				Var__tMap_8__Struct Var__tMap_8 = new Var__tMap_8__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				vm_interface_configurationStruct vm_interface_configuration_tmp = new vm_interface_configurationStruct();
				// ###############################

				/**
				 * [tMap_8 begin ] stop
				 */

				/**
				 * [tJDBCInput_8 begin ] start
				 */

				ok_Hash.put("tJDBCInput_8", false);
				start_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				currentComponent = "tJDBCInput_8";

				int tos_count_tJDBCInput_8 = 0;

				int nb_line_tJDBCInput_8 = 0;
				java.sql.Connection conn_tJDBCInput_8 = null;
				conn_tJDBCInput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_8 = conn_tJDBCInput_8
						.createStatement();

				String dbquery_tJDBCInput_8 = "SELECT \n  vm_interface_id, \n  vm_interface_name, \n  vm_id, \n  upper(cast(vm_id as char(36))) as vm_join_id,\n  vm_interface_type, \n  vm_interface_speed_bps, \n  mac_address, \n  logical_network_name, \n  create_date, \n  update_date\nFROM dwh_vm_interface_configuration_history_view";

				globalMap.put("tJDBCInput_8_QUERY", dbquery_tJDBCInput_8);

				java.sql.ResultSet rs_tJDBCInput_8 = null;
				try {
					rs_tJDBCInput_8 = stmt_tJDBCInput_8
							.executeQuery(dbquery_tJDBCInput_8);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_8 = rs_tJDBCInput_8
							.getMetaData();
					int colQtyInRs_tJDBCInput_8 = rsmd_tJDBCInput_8
							.getColumnCount();

					String tmpContent_tJDBCInput_8 = null;

					while (rs_tJDBCInput_8.next()) {
						nb_line_tJDBCInput_8++;

						if (colQtyInRs_tJDBCInput_8 < 1) {
							row8.vm_interface_id = null;
						} else {

							if (rs_tJDBCInput_8.getObject(1) != null) {
								row8.vm_interface_id = rs_tJDBCInput_8
										.getObject(1);
							} else {
								row8.vm_interface_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 2) {
							row8.vm_interface_name = null;
						} else {

							row8.vm_interface_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_8, 2, false);
						}
						if (colQtyInRs_tJDBCInput_8 < 3) {
							row8.vm_id = null;
						} else {

							if (rs_tJDBCInput_8.getObject(3) != null) {
								row8.vm_id = rs_tJDBCInput_8.getObject(3);
							} else {
								row8.vm_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 4) {
							row8.vm_join_id = null;
						} else {

							row8.vm_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_8, 4, false);
						}
						if (colQtyInRs_tJDBCInput_8 < 5) {
							row8.vm_interface_type = null;
						} else {

							if (rs_tJDBCInput_8.getObject(5) != null) {
								row8.vm_interface_type = rs_tJDBCInput_8
										.getShort(5);
							} else {
								row8.vm_interface_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 6) {
							row8.vm_interface_speed_bps = null;
						} else {

							if (rs_tJDBCInput_8.getObject(6) != null) {
								row8.vm_interface_speed_bps = rs_tJDBCInput_8
										.getInt(6);
							} else {
								row8.vm_interface_speed_bps = null;
							}
						}
						if (colQtyInRs_tJDBCInput_8 < 7) {
							row8.mac_address = null;
						} else {

							row8.mac_address = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_8, 7, false);
						}
						if (colQtyInRs_tJDBCInput_8 < 8) {
							row8.logical_network_name = null;
						} else {

							row8.logical_network_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_8, 8, false);
						}
						if (colQtyInRs_tJDBCInput_8 < 9) {
							row8.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_8 = null;
							try {
								date_tJDBCInput_8 = rs_tJDBCInput_8
										.getTimestamp(9);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_8 = rs_tJDBCInput_8.getDate(9);
							}
							row8.create_date = date_tJDBCInput_8;
						}
						if (colQtyInRs_tJDBCInput_8 < 10) {
							row8.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_8 = null;
							try {
								date_tJDBCInput_8 = rs_tJDBCInput_8
										.getTimestamp(10);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_8 = rs_tJDBCInput_8.getDate(10);
							}
							row8.update_date = date_tJDBCInput_8;
						}

						/**
						 * [tJDBCInput_8 begin ] stop
						 */

						/**
						 * [tJDBCInput_8 main ] start
						 */

						currentComponent = "tJDBCInput_8";

						tos_count_tJDBCInput_8++;

						/**
						 * [tJDBCInput_8 main ] stop
						 */

						/**
						 * [tMap_8 main ] start
						 */

						currentComponent = "tMap_8";

						boolean hasCasePrimitiveKeyWithNull_tMap_8 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_8 = false;
						boolean mainRowRejected_tMap_8 = false;

						if (

						(

						row8.update_date == null ? TalendDate.compareDate(
								row8.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row8.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row8'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row40"
							// /////////////////////////////////////////////

							boolean forceLooprow40 = false;

							row40Struct row40ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_8) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_8 = false;

								row40HashKey.vm_join_id = row8.vm_join_id;

								row40HashKey.hashCodeDirty = true;

								tHash_Lookup_row40.lookup(row40HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row40 != null
									&& tHash_Lookup_row40
											.getCount(row40HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row40' and it contains more one result from keys :  row40.vm_join_id = '"
								// + row40HashKey.vm_join_id + "'");
							} // G 071

							row40Struct row40 = null;

							row40Struct fromLookup_row40 = null;
							row40 = row40Default;

							if (tHash_Lookup_row40 != null
									&& tHash_Lookup_row40.hasNext()) { // G 099

								fromLookup_row40 = tHash_Lookup_row40.next();

							} // G 099

							if (fromLookup_row40 != null) {
								row40 = fromLookup_row40;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_8__Struct Var = Var__tMap_8;// ###############################
								// ###############################
								// # Output tables

								vm_interface_configuration = null;

								// # Output table : 'vm_interface_configuration'
								vm_interface_configuration_tmp.vm_interface_id = row8.vm_interface_id;
								vm_interface_configuration_tmp.vm_interface_name = StringHandling
										.TRIM(row8.vm_interface_name);
								vm_interface_configuration_tmp.vm_id = row8.vm_id;
								vm_interface_configuration_tmp.vm_interface_type = row8.vm_interface_type;
								vm_interface_configuration_tmp.vm_interface_speed_bps = row8.vm_interface_speed_bps;
								vm_interface_configuration_tmp.mac_address = StringHandling
										.TRIM(row8.mac_address);
								vm_interface_configuration_tmp.logical_network_name = StringHandling
										.TRIM(row8.logical_network_name);
								vm_interface_configuration_tmp.vm_configuration_version = row40.history_id;
								vm_interface_configuration_tmp.create_date = row8.create_date;
								vm_interface_configuration_tmp.update_date = row8.update_date;
								vm_interface_configuration_tmp.delete_date = null;
								vm_interface_configuration = vm_interface_configuration_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_8 = false;

							tos_count_tMap_8++;

							/**
							 * [tMap_8 main ] stop
							 */
							// Start of branch "vm_interface_configuration"
							if (vm_interface_configuration != null) {

								/**
								 * [tJDBCOutput_8 main ] start
								 */

								currentComponent = "tJDBCOutput_8";

								whetherReject_tJDBCOutput_8 = false;
								if (vm_interface_configuration.vm_interface_id == null) {
									pstmt_tJDBCOutput_8.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_8
											.setObject(
													1,
													vm_interface_configuration.vm_interface_id);
								}

								if (vm_interface_configuration.vm_interface_name == null) {
									pstmt_tJDBCOutput_8.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_8
											.setString(
													2,
													vm_interface_configuration.vm_interface_name);
								}

								if (vm_interface_configuration.vm_id == null) {
									pstmt_tJDBCOutput_8.setNull(3,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_8.setObject(3,
											vm_interface_configuration.vm_id);
								}

								if (vm_interface_configuration.vm_interface_type == null) {
									pstmt_tJDBCOutput_8.setNull(4,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_8
											.setShort(
													4,
													vm_interface_configuration.vm_interface_type);
								}

								if (vm_interface_configuration.vm_interface_speed_bps == null) {
									pstmt_tJDBCOutput_8.setNull(5,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_8
											.setInt(5,
													vm_interface_configuration.vm_interface_speed_bps);
								}

								if (vm_interface_configuration.mac_address == null) {
									pstmt_tJDBCOutput_8.setNull(6,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_8
											.setString(
													6,
													vm_interface_configuration.mac_address);
								}

								if (vm_interface_configuration.logical_network_name == null) {
									pstmt_tJDBCOutput_8.setNull(7,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_8
											.setString(
													7,
													vm_interface_configuration.logical_network_name);
								}

								if (vm_interface_configuration.vm_configuration_version == null) {
									pstmt_tJDBCOutput_8.setNull(8,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_8
											.setInt(8,
													vm_interface_configuration.vm_configuration_version);
								}

								if (vm_interface_configuration.create_date != null) {
									pstmt_tJDBCOutput_8
											.setTimestamp(
													9,
													new java.sql.Timestamp(
															vm_interface_configuration.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_8.setNull(9,
											java.sql.Types.DATE);
								}

								if (vm_interface_configuration.update_date != null) {
									pstmt_tJDBCOutput_8
											.setTimestamp(
													10,
													new java.sql.Timestamp(
															vm_interface_configuration.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_8.setNull(10,
											java.sql.Types.DATE);
								}

								if (vm_interface_configuration.delete_date != null) {
									pstmt_tJDBCOutput_8
											.setTimestamp(
													11,
													new java.sql.Timestamp(
															vm_interface_configuration.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_8.setNull(11,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_8 = insertedCount_tJDBCOutput_8
											+ pstmt_tJDBCOutput_8
													.executeUpdate();
									nb_line_tJDBCOutput_8++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_8 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_8++;

								/**
								 * [tJDBCOutput_8 main ] stop
								 */

							} // End of branch "vm_interface_configuration"

						} // G_TM_M_280 close main tMap filter for table 'row8'

						/**
						 * [tJDBCInput_8 end ] start
						 */

						currentComponent = "tJDBCInput_8";

					}
				} finally {
					if (rs_tJDBCInput_8 != null) {
						rs_tJDBCInput_8.close();
					}
					stmt_tJDBCInput_8.close();

				}
				globalMap.put("tJDBCInput_8_NB_LINE", nb_line_tJDBCInput_8);

				ok_Hash.put("tJDBCInput_8", true);
				end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				/**
				 * [tJDBCInput_8 end ] stop
				 */

				/**
				 * [tMap_8 end ] start
				 */

				currentComponent = "tMap_8";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row40 != null) {
					tHash_Lookup_row40.endGet();
				}
				globalMap.remove("tHash_Lookup_row40");

				// ###############################

				ok_Hash.put("tMap_8", true);
				end_Hash.put("tMap_8", System.currentTimeMillis());

				/**
				 * [tMap_8 end ] stop
				 */

				/**
				 * [tJDBCOutput_8 end ] start
				 */

				currentComponent = "tJDBCOutput_8";

				if (pstmt_tJDBCOutput_8 != null) {

					pstmt_tJDBCOutput_8.close();

				}

				nb_line_deleted_tJDBCOutput_8 = nb_line_deleted_tJDBCOutput_8
						+ deletedCount_tJDBCOutput_8;
				nb_line_update_tJDBCOutput_8 = nb_line_update_tJDBCOutput_8
						+ updatedCount_tJDBCOutput_8;
				nb_line_inserted_tJDBCOutput_8 = nb_line_inserted_tJDBCOutput_8
						+ insertedCount_tJDBCOutput_8;
				nb_line_rejected_tJDBCOutput_8 = nb_line_rejected_tJDBCOutput_8
						+ rejectedCount_tJDBCOutput_8;

				globalMap.put("tJDBCOutput_8_NB_LINE", nb_line_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_8);

				ok_Hash.put("tJDBCOutput_8", true);
				end_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_8 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_8:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_30Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_8"
			globalMap.remove("tHash_Lookup_row40");

			try {

				/**
				 * [tJDBCInput_8 finally ] start
				 */

				currentComponent = "tJDBCInput_8";

				/**
				 * [tJDBCInput_8 finally ] stop
				 */

				/**
				 * [tMap_8 finally ] start
				 */

				currentComponent = "tMap_8";

				/**
				 * [tMap_8 finally ] stop
				 */

				/**
				 * [tJDBCOutput_8 finally ] start
				 */

				currentComponent = "tJDBCOutput_8";

				/**
				 * [tJDBCOutput_8 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 1);
	}

	public static class delete_vm_interfaceStruct implements
			routines.system.IPersistableRow<delete_vm_interfaceStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_name, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vm_interfaceStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row29Struct implements
			routines.system.IPersistableRow<row29Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_join_id = readString(dis);

					this.vm_interface_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_join_id, dos);

				// String

				writeString(this.vm_interface_name, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row29Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_30Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_30Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public Object vm_interface_id;

		public Object getVm_interface_id() {
			return this.vm_interface_id;
		}

		public String vm_interface_join_id;

		public String getVm_interface_join_id() {
			return this.vm_interface_join_id;
		}

		public String vm_interface_name;

		public String getVm_interface_name() {
			return this.vm_interface_name;
		}

		public Short vm_interface_type;

		public Short getVm_interface_type() {
			return this.vm_interface_type;
		}

		public Integer vm_interface_speed_bps;

		public Integer getVm_interface_speed_bps() {
			return this.vm_interface_speed_bps;
		}

		public String mac_address;

		public String getMac_address() {
			return this.mac_address;
		}

		public String logical_network_name;

		public String getLogical_network_name() {
			return this.logical_network_name;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.history_id = readInteger(dis);

					this.vm_interface_id = (Object) dis.readObject();

					this.vm_interface_join_id = readString(dis);

					this.vm_interface_name = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.vm_interface_type = null;
					} else {
						this.vm_interface_type = dis.readShort();
					}

					this.vm_interface_speed_bps = readInteger(dis);

					this.mac_address = readString(dis);

					this.logical_network_name = readString(dis);

					this.vm_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Integer

				writeInteger(this.history_id, dos);

				// Object

				dos.writeObject(this.vm_interface_id);

				// String

				writeString(this.vm_interface_join_id, dos);

				// String

				writeString(this.vm_interface_name, dos);

				// Short

				if (this.vm_interface_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.vm_interface_type);
				}

				// Integer

				writeInteger(this.vm_interface_speed_bps, dos);

				// String

				writeString(this.mac_address, dos);

				// String

				writeString(this.logical_network_name, dos);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",vm_interface_id=" + String.valueOf(vm_interface_id));
			sb.append(",vm_interface_join_id=" + vm_interface_join_id);
			sb.append(",vm_interface_name=" + vm_interface_name);
			sb.append(",vm_interface_type=" + String.valueOf(vm_interface_type));
			sb.append(",vm_interface_speed_bps="
					+ String.valueOf(vm_interface_speed_bps));
			sb.append(",mac_address=" + mac_address);
			sb.append(",logical_network_name=" + logical_network_name);
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_30Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_30Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_30_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_29Process(globalMap);

				row29Struct row29 = new row29Struct();
				delete_vm_interfaceStruct delete_vm_interface = new delete_vm_interfaceStruct();

				/**
				 * [tJDBCOutput_21 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_21", false);
				start_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_21";

				int tos_count_tJDBCOutput_21 = 0;

				int nb_line_tJDBCOutput_21 = 0;
				int nb_line_update_tJDBCOutput_21 = 0;
				int nb_line_inserted_tJDBCOutput_21 = 0;
				int nb_line_deleted_tJDBCOutput_21 = 0;
				int nb_line_rejected_tJDBCOutput_21 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_21 = 0;

				int deletedCount_tJDBCOutput_21 = 0;
				int updatedCount_tJDBCOutput_21 = 0;
				int insertedCount_tJDBCOutput_21 = 0;
				int rejectedCount_tJDBCOutput_21 = 0;

				boolean whetherReject_tJDBCOutput_21 = false;

				java.sql.Connection connection_tJDBCOutput_21 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_21 = "INSERT INTO "
						+ "vm_interface_configuration"
						+ " (vm_interface_id,vm_interface_name,vm_interface_type,vm_interface_speed_bps,mac_address,logical_network_name,vm_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_21 = connection_tJDBCOutput_21
						.prepareStatement(insert_tJDBCOutput_21);

				/**
				 * [tJDBCOutput_21 begin ] stop
				 */

				/**
				 * [tMap_21 begin ] start
				 */

				ok_Hash.put("tMap_21", false);
				start_Hash.put("tMap_21", System.currentTimeMillis());

				currentComponent = "tMap_21";

				int tos_count_tMap_21 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row28Struct> tHash_Lookup_row28 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row28Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row28Struct>) globalMap
						.get("tHash_Lookup_row28"));

				row28Struct row28HashKey = new row28Struct();
				row28Struct row28Default = new row28Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_21__Struct {
				}
				Var__tMap_21__Struct Var__tMap_21 = new Var__tMap_21__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_vm_interfaceStruct delete_vm_interface_tmp = new delete_vm_interfaceStruct();
				// ###############################

				/**
				 * [tMap_21 begin ] stop
				 */

				/**
				 * [tJDBCInput_30 begin ] start
				 */

				ok_Hash.put("tJDBCInput_30", false);
				start_Hash.put("tJDBCInput_30", System.currentTimeMillis());

				currentComponent = "tJDBCInput_30";

				int tos_count_tJDBCInput_30 = 0;

				int nb_line_tJDBCInput_30 = 0;
				java.sql.Connection conn_tJDBCInput_30 = null;
				conn_tJDBCInput_30 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_30 = conn_tJDBCInput_30
						.createStatement();

				String dbquery_tJDBCInput_30 = "SELECT \n  history_id, \n  vm_interface_id, \n  upper(cast(vm_interface_id as char(36))) as vm_interface_join_id,\n  vm_interface_name, \n  vm_interface_type, \n  vm_interface_speed_bps, \n  mac_address, \n  logical_network_name, \n  vm_configuration_version, \n  create_date, \n  update_date\nFROM v4_4_latest_configuration_vms_interfaces";

				globalMap.put("tJDBCInput_30_QUERY", dbquery_tJDBCInput_30);

				java.sql.ResultSet rs_tJDBCInput_30 = null;
				try {
					rs_tJDBCInput_30 = stmt_tJDBCInput_30
							.executeQuery(dbquery_tJDBCInput_30);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_30 = rs_tJDBCInput_30
							.getMetaData();
					int colQtyInRs_tJDBCInput_30 = rsmd_tJDBCInput_30
							.getColumnCount();

					String tmpContent_tJDBCInput_30 = null;

					while (rs_tJDBCInput_30.next()) {
						nb_line_tJDBCInput_30++;

						if (colQtyInRs_tJDBCInput_30 < 1) {
							row29.history_id = null;
						} else {

							if (rs_tJDBCInput_30.getObject(1) != null) {
								row29.history_id = rs_tJDBCInput_30.getInt(1);
							} else {
								row29.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_30 < 2) {
							row29.vm_interface_id = null;
						} else {

							if (rs_tJDBCInput_30.getObject(2) != null) {
								row29.vm_interface_id = rs_tJDBCInput_30
										.getObject(2);
							} else {
								row29.vm_interface_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_30 < 3) {
							row29.vm_interface_join_id = null;
						} else {

							row29.vm_interface_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_30, 3, false);
						}
						if (colQtyInRs_tJDBCInput_30 < 4) {
							row29.vm_interface_name = null;
						} else {

							row29.vm_interface_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_30, 4, false);
						}
						if (colQtyInRs_tJDBCInput_30 < 5) {
							row29.vm_interface_type = null;
						} else {

							if (rs_tJDBCInput_30.getObject(5) != null) {
								row29.vm_interface_type = rs_tJDBCInput_30
										.getShort(5);
							} else {
								row29.vm_interface_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_30 < 6) {
							row29.vm_interface_speed_bps = null;
						} else {

							if (rs_tJDBCInput_30.getObject(6) != null) {
								row29.vm_interface_speed_bps = rs_tJDBCInput_30
										.getInt(6);
							} else {
								row29.vm_interface_speed_bps = null;
							}
						}
						if (colQtyInRs_tJDBCInput_30 < 7) {
							row29.mac_address = null;
						} else {

							row29.mac_address = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_30, 7, false);
						}
						if (colQtyInRs_tJDBCInput_30 < 8) {
							row29.logical_network_name = null;
						} else {

							row29.logical_network_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_30, 8, false);
						}
						if (colQtyInRs_tJDBCInput_30 < 9) {
							row29.vm_configuration_version = null;
						} else {

							if (rs_tJDBCInput_30.getObject(9) != null) {
								row29.vm_configuration_version = rs_tJDBCInput_30
										.getInt(9);
							} else {
								row29.vm_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_30 < 10) {
							row29.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_30 = null;
							try {
								date_tJDBCInput_30 = rs_tJDBCInput_30
										.getTimestamp(10);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_30 = rs_tJDBCInput_30
										.getDate(10);
							}
							row29.create_date = date_tJDBCInput_30;
						}
						if (colQtyInRs_tJDBCInput_30 < 11) {
							row29.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_30 = null;
							try {
								date_tJDBCInput_30 = rs_tJDBCInput_30
										.getTimestamp(11);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_30 = rs_tJDBCInput_30
										.getDate(11);
							}
							row29.update_date = date_tJDBCInput_30;
						}

						/**
						 * [tJDBCInput_30 begin ] stop
						 */

						/**
						 * [tJDBCInput_30 main ] start
						 */

						currentComponent = "tJDBCInput_30";

						tos_count_tJDBCInput_30++;

						/**
						 * [tJDBCInput_30 main ] stop
						 */

						/**
						 * [tMap_21 main ] start
						 */

						currentComponent = "tMap_21";

						boolean hasCasePrimitiveKeyWithNull_tMap_21 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_21 = false;
						boolean mainRowRejected_tMap_21 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row28"
						// /////////////////////////////////////////////

						boolean forceLooprow28 = false;

						row28Struct row28ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_21) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_21 = false;

							row28HashKey.vm_interface_join_id = row29.vm_interface_join_id;

							row28HashKey.hashCodeDirty = true;

							tHash_Lookup_row28.lookup(row28HashKey);

							if (!tHash_Lookup_row28.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_21 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row28 != null
								&& tHash_Lookup_row28.getCount(row28HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row28' and it contains more one result from keys :  row28.vm_interface_join_id = '"
							// + row28HashKey.vm_interface_join_id + "'");
						} // G 071

						row28Struct row28 = null;

						row28Struct fromLookup_row28 = null;
						row28 = row28Default;

						if (tHash_Lookup_row28 != null
								&& tHash_Lookup_row28.hasNext()) { // G 099

							fromLookup_row28 = tHash_Lookup_row28.next();

						} // G 099

						if (fromLookup_row28 != null) {
							row28 = fromLookup_row28;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_21__Struct Var = Var__tMap_21;// ###############################
							// ###############################
							// # Output tables

							delete_vm_interface = null;

							if (!rejectedInnerJoin_tMap_21) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'delete_vm_interface'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_21) {
								delete_vm_interface_tmp.vm_interface_id = row29.vm_interface_id;
								delete_vm_interface_tmp.vm_interface_name = row29.vm_interface_name;
								delete_vm_interface_tmp.vm_interface_type = row29.vm_interface_type;
								delete_vm_interface_tmp.vm_interface_speed_bps = row29.vm_interface_speed_bps;
								delete_vm_interface_tmp.mac_address = row29.mac_address;
								delete_vm_interface_tmp.logical_network_name = row29.logical_network_name;
								delete_vm_interface_tmp.vm_configuration_version = row29.vm_configuration_version;
								delete_vm_interface_tmp.create_date = row29.create_date;
								delete_vm_interface_tmp.update_date = context.runTime;
								delete_vm_interface_tmp.delete_date = context.runTime;
								delete_vm_interface = delete_vm_interface_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_21 = false;

						tos_count_tMap_21++;

						/**
						 * [tMap_21 main ] stop
						 */
						// Start of branch "delete_vm_interface"
						if (delete_vm_interface != null) {

							/**
							 * [tJDBCOutput_21 main ] start
							 */

							currentComponent = "tJDBCOutput_21";

							whetherReject_tJDBCOutput_21 = false;
							if (delete_vm_interface.vm_interface_id == null) {
								pstmt_tJDBCOutput_21.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_21.setObject(1,
										delete_vm_interface.vm_interface_id);
							}

							if (delete_vm_interface.vm_interface_name == null) {
								pstmt_tJDBCOutput_21.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_21.setString(2,
										delete_vm_interface.vm_interface_name);
							}

							if (delete_vm_interface.vm_interface_type == null) {
								pstmt_tJDBCOutput_21.setNull(3,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_21.setShort(3,
										delete_vm_interface.vm_interface_type);
							}

							if (delete_vm_interface.vm_interface_speed_bps == null) {
								pstmt_tJDBCOutput_21.setNull(4,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_21
										.setInt(4,
												delete_vm_interface.vm_interface_speed_bps);
							}

							if (delete_vm_interface.mac_address == null) {
								pstmt_tJDBCOutput_21.setNull(5,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_21.setString(5,
										delete_vm_interface.mac_address);
							}

							if (delete_vm_interface.logical_network_name == null) {
								pstmt_tJDBCOutput_21.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_21
										.setString(
												6,
												delete_vm_interface.logical_network_name);
							}

							if (delete_vm_interface.vm_configuration_version == null) {
								pstmt_tJDBCOutput_21.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_21
										.setInt(7,
												delete_vm_interface.vm_configuration_version);
							}

							if (delete_vm_interface.create_date != null) {
								pstmt_tJDBCOutput_21.setTimestamp(
										8,
										new java.sql.Timestamp(
												delete_vm_interface.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_21.setNull(8,
										java.sql.Types.DATE);
							}

							if (delete_vm_interface.update_date != null) {
								pstmt_tJDBCOutput_21.setTimestamp(
										9,
										new java.sql.Timestamp(
												delete_vm_interface.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_21.setNull(9,
										java.sql.Types.DATE);
							}

							if (delete_vm_interface.delete_date != null) {
								pstmt_tJDBCOutput_21.setTimestamp(
										10,
										new java.sql.Timestamp(
												delete_vm_interface.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_21.setNull(10,
										java.sql.Types.DATE);
							}

							try {
								insertedCount_tJDBCOutput_21 = insertedCount_tJDBCOutput_21
										+ pstmt_tJDBCOutput_21.executeUpdate();
								nb_line_tJDBCOutput_21++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_21 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_21++;

							/**
							 * [tJDBCOutput_21 main ] stop
							 */

						} // End of branch "delete_vm_interface"

						/**
						 * [tJDBCInput_30 end ] start
						 */

						currentComponent = "tJDBCInput_30";

					}
				} finally {
					if (rs_tJDBCInput_30 != null) {
						rs_tJDBCInput_30.close();
					}
					stmt_tJDBCInput_30.close();

				}
				globalMap.put("tJDBCInput_30_NB_LINE", nb_line_tJDBCInput_30);

				ok_Hash.put("tJDBCInput_30", true);
				end_Hash.put("tJDBCInput_30", System.currentTimeMillis());

				/**
				 * [tJDBCInput_30 end ] stop
				 */

				/**
				 * [tMap_21 end ] start
				 */

				currentComponent = "tMap_21";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row28 != null) {
					tHash_Lookup_row28.endGet();
				}
				globalMap.remove("tHash_Lookup_row28");

				// ###############################

				ok_Hash.put("tMap_21", true);
				end_Hash.put("tMap_21", System.currentTimeMillis());

				/**
				 * [tMap_21 end ] stop
				 */

				/**
				 * [tJDBCOutput_21 end ] start
				 */

				currentComponent = "tJDBCOutput_21";

				if (pstmt_tJDBCOutput_21 != null) {

					pstmt_tJDBCOutput_21.close();

				}

				nb_line_deleted_tJDBCOutput_21 = nb_line_deleted_tJDBCOutput_21
						+ deletedCount_tJDBCOutput_21;
				nb_line_update_tJDBCOutput_21 = nb_line_update_tJDBCOutput_21
						+ updatedCount_tJDBCOutput_21;
				nb_line_inserted_tJDBCOutput_21 = nb_line_inserted_tJDBCOutput_21
						+ insertedCount_tJDBCOutput_21;
				nb_line_rejected_tJDBCOutput_21 = nb_line_rejected_tJDBCOutput_21
						+ rejectedCount_tJDBCOutput_21;

				globalMap.put("tJDBCOutput_21_NB_LINE", nb_line_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_21);

				ok_Hash.put("tJDBCOutput_21", true);
				end_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_21 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_30:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_53Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_21"
			globalMap.remove("tHash_Lookup_row28");

			try {

				/**
				 * [tJDBCInput_30 finally ] start
				 */

				currentComponent = "tJDBCInput_30";

				/**
				 * [tJDBCInput_30 finally ] stop
				 */

				/**
				 * [tMap_21 finally ] start
				 */

				currentComponent = "tMap_21";

				/**
				 * [tMap_21 finally ] stop
				 */

				/**
				 * [tJDBCOutput_21 finally ] start
				 */

				currentComponent = "tJDBCOutput_21";

				/**
				 * [tJDBCOutput_21 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_30_SUBPROCESS_STATE", 1);
	}

	public static class insert_new_vm_device_connectionStruct
			implements
			routines.system.IPersistableRow<insert_new_vm_device_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public boolean is_managed;

		public boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public boolean is_readonly;

		public boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.device_id = (Object) dis.readObject();

					this.type = readString(dis);

					this.address = readString(dis);

					this.is_managed = dis.readBoolean();

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					this.is_readonly = dis.readBoolean();

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// boolean

				dos.writeBoolean(this.is_managed);

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// boolean

				dos.writeBoolean(this.is_readonly);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(insert_new_vm_device_connectionStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row45Struct implements
			routines.system.IPersistableRow<row45Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row45Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_53Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_53Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_53Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_53Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_53_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_54Process(globalMap);
				tJDBCInput_65Process(globalMap);
				tJDBCInput_66Process(globalMap);

				row45Struct row45 = new row45Struct();
				insert_new_vm_device_connectionStruct insert_new_vm_device_connection = new insert_new_vm_device_connectionStruct();

				/**
				 * [tJDBCOutput_31 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_31", false);
				start_Hash.put("tJDBCOutput_31", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_31";

				int tos_count_tJDBCOutput_31 = 0;

				int nb_line_tJDBCOutput_31 = 0;
				int nb_line_update_tJDBCOutput_31 = 0;
				int nb_line_inserted_tJDBCOutput_31 = 0;
				int nb_line_deleted_tJDBCOutput_31 = 0;
				int nb_line_rejected_tJDBCOutput_31 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_31 = 0;

				int deletedCount_tJDBCOutput_31 = 0;
				int updatedCount_tJDBCOutput_31 = 0;
				int insertedCount_tJDBCOutput_31 = 0;
				int rejectedCount_tJDBCOutput_31 = 0;

				boolean whetherReject_tJDBCOutput_31 = false;

				java.sql.Connection connection_tJDBCOutput_31 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_31 = "INSERT INTO "
						+ "vm_device_history"
						+ " (vm_id,device_id,type,address,is_managed,is_plugged,is_readonly,vm_configuration_version,device_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_31 = connection_tJDBCOutput_31
						.prepareStatement(insert_tJDBCOutput_31);

				/**
				 * [tJDBCOutput_31 begin ] stop
				 */

				/**
				 * [tMap_31 begin ] start
				 */

				ok_Hash.put("tMap_31", false);
				start_Hash.put("tMap_31", System.currentTimeMillis());

				currentComponent = "tMap_31";

				int tos_count_tMap_31 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row46Struct> tHash_Lookup_row46 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row46Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row46Struct>) globalMap
						.get("tHash_Lookup_row46"));

				row46Struct row46HashKey = new row46Struct();
				row46Struct row46Default = new row46Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row53Struct> tHash_Lookup_row53 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row53Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row53Struct>) globalMap
						.get("tHash_Lookup_row53"));

				row53Struct row53HashKey = new row53Struct();
				row53Struct row53Default = new row53Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row54Struct> tHash_Lookup_row54 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row54Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row54Struct>) globalMap
						.get("tHash_Lookup_row54"));

				row54Struct row54HashKey = new row54Struct();
				row54Struct row54Default = new row54Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_31__Struct {
				}
				Var__tMap_31__Struct Var__tMap_31 = new Var__tMap_31__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				insert_new_vm_device_connectionStruct insert_new_vm_device_connection_tmp = new insert_new_vm_device_connectionStruct();
				// ###############################

				/**
				 * [tMap_31 begin ] stop
				 */

				/**
				 * [tJDBCInput_53 begin ] start
				 */

				ok_Hash.put("tJDBCInput_53", false);
				start_Hash.put("tJDBCInput_53", System.currentTimeMillis());

				currentComponent = "tJDBCInput_53";

				int tos_count_tJDBCInput_53 = 0;

				int nb_line_tJDBCInput_53 = 0;
				java.sql.Connection conn_tJDBCInput_53 = null;
				conn_tJDBCInput_53 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_53 = conn_tJDBCInput_53
						.createStatement();

				String dbquery_tJDBCInput_53 = "SELECT \n  device_id,\n  upper(cast(device_id as char(36))) as device_join_id,\n  vm_id,\n  upper(cast(vm_id as char(36))) as vm_join_id,\n  type, \n  address, \n  is_managed, \n  is_plugged, \n  is_readonly,\n  create_date,\n  update_date\nFROM dwh_vm_device_history_view";

				globalMap.put("tJDBCInput_53_QUERY", dbquery_tJDBCInput_53);

				java.sql.ResultSet rs_tJDBCInput_53 = null;
				try {
					rs_tJDBCInput_53 = stmt_tJDBCInput_53
							.executeQuery(dbquery_tJDBCInput_53);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_53 = rs_tJDBCInput_53
							.getMetaData();
					int colQtyInRs_tJDBCInput_53 = rsmd_tJDBCInput_53
							.getColumnCount();

					String tmpContent_tJDBCInput_53 = null;

					while (rs_tJDBCInput_53.next()) {
						nb_line_tJDBCInput_53++;

						if (colQtyInRs_tJDBCInput_53 < 1) {
							row45.device_id = null;
						} else {

							if (rs_tJDBCInput_53.getObject(1) != null) {
								row45.device_id = rs_tJDBCInput_53.getObject(1);
							} else {
								row45.device_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_53 < 2) {
							row45.device_join_id = null;
						} else {

							row45.device_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_53, 2, false);
						}
						if (colQtyInRs_tJDBCInput_53 < 3) {
							row45.vm_id = null;
						} else {

							if (rs_tJDBCInput_53.getObject(3) != null) {
								row45.vm_id = rs_tJDBCInput_53.getObject(3);
							} else {
								row45.vm_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_53 < 4) {
							row45.vm_join_id = null;
						} else {

							row45.vm_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_53, 4, false);
						}
						if (colQtyInRs_tJDBCInput_53 < 5) {
							row45.type = null;
						} else {

							row45.type = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_53, 5, false);
						}
						if (colQtyInRs_tJDBCInput_53 < 6) {
							row45.address = null;
						} else {

							row45.address = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_53, 6, false);
						}
						if (colQtyInRs_tJDBCInput_53 < 7) {
							row45.is_managed = null;
						} else {

							if (rs_tJDBCInput_53.getObject(7) != null) {
								row45.is_managed = rs_tJDBCInput_53
										.getBoolean(7);
							} else {
								row45.is_managed = null;
							}
						}
						if (colQtyInRs_tJDBCInput_53 < 8) {
							row45.is_plugged = null;
						} else {

							if (rs_tJDBCInput_53.getObject(8) != null) {
								row45.is_plugged = rs_tJDBCInput_53
										.getBoolean(8);
							} else {
								row45.is_plugged = null;
							}
						}
						if (colQtyInRs_tJDBCInput_53 < 9) {
							row45.is_readonly = null;
						} else {

							if (rs_tJDBCInput_53.getObject(9) != null) {
								row45.is_readonly = rs_tJDBCInput_53
										.getBoolean(9);
							} else {
								row45.is_readonly = null;
							}
						}
						if (colQtyInRs_tJDBCInput_53 < 10) {
							row45.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_53 = null;
							try {
								date_tJDBCInput_53 = rs_tJDBCInput_53
										.getTimestamp(10);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_53 = rs_tJDBCInput_53
										.getDate(10);
							}
							row45.create_date = date_tJDBCInput_53;
						}
						if (colQtyInRs_tJDBCInput_53 < 11) {
							row45.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_53 = null;
							try {
								date_tJDBCInput_53 = rs_tJDBCInput_53
										.getTimestamp(11);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_53 = rs_tJDBCInput_53
										.getDate(11);
							}
							row45.update_date = date_tJDBCInput_53;
						}

						/**
						 * [tJDBCInput_53 begin ] stop
						 */

						/**
						 * [tJDBCInput_53 main ] start
						 */

						currentComponent = "tJDBCInput_53";

						tos_count_tJDBCInput_53++;

						/**
						 * [tJDBCInput_53 main ] stop
						 */

						/**
						 * [tMap_31 main ] start
						 */

						currentComponent = "tMap_31";

						boolean hasCasePrimitiveKeyWithNull_tMap_31 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_31 = false;
						boolean mainRowRejected_tMap_31 = false;

						if (

						(

						row45.update_date == null ? TalendDate.compareDate(
								row45.create_date, context.runTime) <= 0
								: TalendDate.compareDate(row45.update_date,
										context.runTime) <= 0

						)

						) { // G_TM_M_280

							// CALL close main tMap filter for table 'row45'

							// /////////////////////////////////////////////
							// Starting Lookup Table "row46"
							// /////////////////////////////////////////////

							boolean forceLooprow46 = false;

							row46Struct row46ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_31) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_31 = false;

								row46HashKey.vm_join_id = row45.vm_join_id;

								row46HashKey.hashCodeDirty = true;

								tHash_Lookup_row46.lookup(row46HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row46 != null
									&& tHash_Lookup_row46
											.getCount(row46HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row46' and it contains more one result from keys :  row46.vm_join_id = '"
								// + row46HashKey.vm_join_id + "'");
							} // G 071

							row46Struct row46 = null;

							row46Struct fromLookup_row46 = null;
							row46 = row46Default;

							if (tHash_Lookup_row46 != null
									&& tHash_Lookup_row46.hasNext()) { // G 099

								fromLookup_row46 = tHash_Lookup_row46.next();

							} // G 099

							if (fromLookup_row46 != null) {
								row46 = fromLookup_row46;
							}

							// /////////////////////////////////////////////
							// Starting Lookup Table "row53"
							// /////////////////////////////////////////////

							boolean forceLooprow53 = false;

							row53Struct row53ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_31) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_31 = false;

								row53HashKey.vm_interface_join_id = row45.device_join_id;

								row53HashKey.hashCodeDirty = true;

								tHash_Lookup_row53.lookup(row53HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row53 != null
									&& tHash_Lookup_row53
											.getCount(row53HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row53' and it contains more one result from keys :  row53.vm_interface_join_id = '"
								// + row53HashKey.vm_interface_join_id + "'");
							} // G 071

							row53Struct row53 = null;

							row53Struct fromLookup_row53 = null;
							row53 = row53Default;

							if (tHash_Lookup_row53 != null
									&& tHash_Lookup_row53.hasNext()) { // G 099

								fromLookup_row53 = tHash_Lookup_row53.next();

							} // G 099

							if (fromLookup_row53 != null) {
								row53 = fromLookup_row53;
							}

							// /////////////////////////////////////////////
							// Starting Lookup Table "row54"
							// /////////////////////////////////////////////

							boolean forceLooprow54 = false;

							row54Struct row54ObjectFromLookup = null;

							if (!rejectedInnerJoin_tMap_31) { // G_TM_M_020

								hasCasePrimitiveKeyWithNull_tMap_31 = false;

								row54HashKey.vm_disk_join_id = row45.device_join_id;

								row54HashKey.hashCodeDirty = true;

								tHash_Lookup_row54.lookup(row54HashKey);

							} // G_TM_M_020

							if (tHash_Lookup_row54 != null
									&& tHash_Lookup_row54
											.getCount(row54HashKey) > 1) { // G
																			// 071

								// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row54' and it contains more one result from keys :  row54.vm_disk_join_id = '"
								// + row54HashKey.vm_disk_join_id + "'");
							} // G 071

							row54Struct row54 = null;

							row54Struct fromLookup_row54 = null;
							row54 = row54Default;

							if (tHash_Lookup_row54 != null
									&& tHash_Lookup_row54.hasNext()) { // G 099

								fromLookup_row54 = tHash_Lookup_row54.next();

							} // G 099

							if (fromLookup_row54 != null) {
								row54 = fromLookup_row54;
							}

							// ###############################
							{ // start of Var scope

								// ###############################
								// # Vars tables

								Var__tMap_31__Struct Var = Var__tMap_31;// ###############################
								// ###############################
								// # Output tables

								insert_new_vm_device_connection = null;

								// # Output table :
								// 'insert_new_vm_device_connection'
								insert_new_vm_device_connection_tmp.vm_id = row45.vm_id;
								insert_new_vm_device_connection_tmp.device_id = row45.device_id;
								insert_new_vm_device_connection_tmp.type = row45.type;
								insert_new_vm_device_connection_tmp.address = row45.address;
								insert_new_vm_device_connection_tmp.is_managed = row45.is_managed;
								insert_new_vm_device_connection_tmp.is_plugged = row45.is_plugged;
								insert_new_vm_device_connection_tmp.is_readonly = row45.is_readonly;
								insert_new_vm_device_connection_tmp.vm_configuration_version = row46.history_id;
								insert_new_vm_device_connection_tmp.device_configuration_version = row53.history_id != null ? row53.history_id
										: row54.history_id;
								insert_new_vm_device_connection_tmp.create_date = row45.create_date;
								insert_new_vm_device_connection_tmp.update_date = row45.update_date;
								insert_new_vm_device_connection_tmp.delete_date = null;
								insert_new_vm_device_connection = insert_new_vm_device_connection_tmp;
								// ###############################

							} // end of Var scope

							rejectedInnerJoin_tMap_31 = false;

							tos_count_tMap_31++;

							/**
							 * [tMap_31 main ] stop
							 */
							// Start of branch "insert_new_vm_device_connection"
							if (insert_new_vm_device_connection != null) {

								/**
								 * [tJDBCOutput_31 main ] start
								 */

								currentComponent = "tJDBCOutput_31";

								whetherReject_tJDBCOutput_31 = false;
								if (insert_new_vm_device_connection.vm_id == null) {
									pstmt_tJDBCOutput_31.setNull(1,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_31
											.setObject(
													1,
													insert_new_vm_device_connection.vm_id);
								}

								if (insert_new_vm_device_connection.device_id == null) {
									pstmt_tJDBCOutput_31.setNull(2,
											java.sql.Types.OTHER);
								} else {
									pstmt_tJDBCOutput_31
											.setObject(
													2,
													insert_new_vm_device_connection.device_id);
								}

								if (insert_new_vm_device_connection.type == null) {
									pstmt_tJDBCOutput_31.setNull(3,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_31
											.setString(
													3,
													insert_new_vm_device_connection.type);
								}

								if (insert_new_vm_device_connection.address == null) {
									pstmt_tJDBCOutput_31.setNull(4,
											java.sql.Types.VARCHAR);
								} else {
									pstmt_tJDBCOutput_31
											.setString(
													4,
													insert_new_vm_device_connection.address);
								}

								pstmt_tJDBCOutput_31
										.setBoolean(
												5,
												insert_new_vm_device_connection.is_managed);

								if (insert_new_vm_device_connection.is_plugged == null) {
									pstmt_tJDBCOutput_31.setNull(6,
											java.sql.Types.BOOLEAN);
								} else {
									pstmt_tJDBCOutput_31
											.setBoolean(
													6,
													insert_new_vm_device_connection.is_plugged);
								}

								pstmt_tJDBCOutput_31
										.setBoolean(
												7,
												insert_new_vm_device_connection.is_readonly);

								if (insert_new_vm_device_connection.vm_configuration_version == null) {
									pstmt_tJDBCOutput_31.setNull(8,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_31
											.setInt(8,
													insert_new_vm_device_connection.vm_configuration_version);
								}

								if (insert_new_vm_device_connection.device_configuration_version == null) {
									pstmt_tJDBCOutput_31.setNull(9,
											java.sql.Types.INTEGER);
								} else {
									pstmt_tJDBCOutput_31
											.setInt(9,
													insert_new_vm_device_connection.device_configuration_version);
								}

								if (insert_new_vm_device_connection.create_date != null) {
									pstmt_tJDBCOutput_31
											.setTimestamp(
													10,
													new java.sql.Timestamp(
															insert_new_vm_device_connection.create_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_31.setNull(10,
											java.sql.Types.DATE);
								}

								if (insert_new_vm_device_connection.update_date != null) {
									pstmt_tJDBCOutput_31
											.setTimestamp(
													11,
													new java.sql.Timestamp(
															insert_new_vm_device_connection.update_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_31.setNull(11,
											java.sql.Types.DATE);
								}

								if (insert_new_vm_device_connection.delete_date != null) {
									pstmt_tJDBCOutput_31
											.setTimestamp(
													12,
													new java.sql.Timestamp(
															insert_new_vm_device_connection.delete_date
																	.getTime()));
								} else {
									pstmt_tJDBCOutput_31.setNull(12,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_31 = insertedCount_tJDBCOutput_31
											+ pstmt_tJDBCOutput_31
													.executeUpdate();
									nb_line_tJDBCOutput_31++;
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_31 = true;
									throw (e);
								}

								tos_count_tJDBCOutput_31++;

								/**
								 * [tJDBCOutput_31 main ] stop
								 */

							} // End of branch "insert_new_vm_device_connection"

						} // G_TM_M_280 close main tMap filter for table 'row45'

						/**
						 * [tJDBCInput_53 end ] start
						 */

						currentComponent = "tJDBCInput_53";

					}
				} finally {
					if (rs_tJDBCInput_53 != null) {
						rs_tJDBCInput_53.close();
					}
					stmt_tJDBCInput_53.close();

				}
				globalMap.put("tJDBCInput_53_NB_LINE", nb_line_tJDBCInput_53);

				ok_Hash.put("tJDBCInput_53", true);
				end_Hash.put("tJDBCInput_53", System.currentTimeMillis());

				/**
				 * [tJDBCInput_53 end ] stop
				 */

				/**
				 * [tMap_31 end ] start
				 */

				currentComponent = "tMap_31";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row46 != null) {
					tHash_Lookup_row46.endGet();
				}
				globalMap.remove("tHash_Lookup_row46");

				if (tHash_Lookup_row53 != null) {
					tHash_Lookup_row53.endGet();
				}
				globalMap.remove("tHash_Lookup_row53");

				if (tHash_Lookup_row54 != null) {
					tHash_Lookup_row54.endGet();
				}
				globalMap.remove("tHash_Lookup_row54");

				// ###############################

				ok_Hash.put("tMap_31", true);
				end_Hash.put("tMap_31", System.currentTimeMillis());

				/**
				 * [tMap_31 end ] stop
				 */

				/**
				 * [tJDBCOutput_31 end ] start
				 */

				currentComponent = "tJDBCOutput_31";

				if (pstmt_tJDBCOutput_31 != null) {

					pstmt_tJDBCOutput_31.close();

				}

				nb_line_deleted_tJDBCOutput_31 = nb_line_deleted_tJDBCOutput_31
						+ deletedCount_tJDBCOutput_31;
				nb_line_update_tJDBCOutput_31 = nb_line_update_tJDBCOutput_31
						+ updatedCount_tJDBCOutput_31;
				nb_line_inserted_tJDBCOutput_31 = nb_line_inserted_tJDBCOutput_31
						+ insertedCount_tJDBCOutput_31;
				nb_line_rejected_tJDBCOutput_31 = nb_line_rejected_tJDBCOutput_31
						+ rejectedCount_tJDBCOutput_31;

				globalMap.put("tJDBCOutput_31_NB_LINE", nb_line_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_31);
				globalMap.put("tJDBCOutput_31_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_31);

				ok_Hash.put("tJDBCOutput_31", true);
				end_Hash.put("tJDBCOutput_31", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_31 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_53:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_56Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_31"
			globalMap.remove("tHash_Lookup_row46");

			// free memory for "tMap_31"
			globalMap.remove("tHash_Lookup_row53");

			// free memory for "tMap_31"
			globalMap.remove("tHash_Lookup_row54");

			try {

				/**
				 * [tJDBCInput_53 finally ] start
				 */

				currentComponent = "tJDBCInput_53";

				/**
				 * [tJDBCInput_53 finally ] stop
				 */

				/**
				 * [tMap_31 finally ] start
				 */

				currentComponent = "tMap_31";

				/**
				 * [tMap_31 finally ] stop
				 */

				/**
				 * [tJDBCOutput_31 finally ] start
				 */

				currentComponent = "tJDBCOutput_31";

				/**
				 * [tJDBCOutput_31 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_53_SUBPROCESS_STATE", 1);
	}

	public static class delete_vm_device_connectionStruct implements
			routines.system.IPersistableRow<delete_vm_device_connectionStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public boolean is_managed;

		public boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public boolean is_readonly;

		public boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result
						+ ((this.vm_id == null) ? 0 : this.vm_id.hashCode());

				result = prime
						* result
						+ ((this.device_id == null) ? 0 : this.device_id
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final delete_vm_device_connectionStruct other = (delete_vm_device_connectionStruct) obj;

			if (this.vm_id == null) {
				if (other.vm_id != null)
					return false;

			} else if (!this.vm_id.equals(other.vm_id))

				return false;

			if (this.device_id == null) {
				if (other.device_id != null)
					return false;

			} else if (!this.device_id.equals(other.device_id))

				return false;

			return true;
		}

		public void copyDataTo(delete_vm_device_connectionStruct other) {

			other.vm_id = this.vm_id;
			other.device_id = this.device_id;
			other.type = this.type;
			other.address = this.address;
			other.is_managed = this.is_managed;
			other.is_plugged = this.is_plugged;
			other.is_readonly = this.is_readonly;
			other.vm_configuration_version = this.vm_configuration_version;
			other.device_configuration_version = this.device_configuration_version;
			other.create_date = this.create_date;
			other.update_date = this.update_date;
			other.delete_date = this.delete_date;

		}

		public void copyKeysDataTo(delete_vm_device_connectionStruct other) {

			other.vm_id = this.vm_id;
			other.device_id = this.device_id;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.device_id = (Object) dis.readObject();

					this.type = readString(dis);

					this.address = readString(dis);

					this.is_managed = dis.readBoolean();

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					this.is_readonly = dis.readBoolean();

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// boolean

				dos.writeBoolean(this.is_managed);

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// boolean

				dos.writeBoolean(this.is_readonly);

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(delete_vm_device_connectionStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.vm_id, other.vm_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.device_id, other.device_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row48Struct implements
			routines.system.IPersistableRow<row48Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row48Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_56Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_56Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[0];

		public Object vm_id;

		public Object getVm_id() {
			return this.vm_id;
		}

		public String vm_join_id;

		public String getVm_join_id() {
			return this.vm_join_id;
		}

		public Object device_id;

		public Object getDevice_id() {
			return this.device_id;
		}

		public String device_join_id;

		public String getDevice_join_id() {
			return this.device_join_id;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String address;

		public String getAddress() {
			return this.address;
		}

		public Boolean is_managed;

		public Boolean getIs_managed() {
			return this.is_managed;
		}

		public Boolean is_plugged;

		public Boolean getIs_plugged() {
			return this.is_plugged;
		}

		public Boolean is_readonly;

		public Boolean getIs_readonly() {
			return this.is_readonly;
		}

		public Integer vm_configuration_version;

		public Integer getVm_configuration_version() {
			return this.vm_configuration_version;
		}

		public Integer device_configuration_version;

		public Integer getDevice_configuration_version() {
			return this.device_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ConfigurationSync, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ConfigurationSync) {

				try {

					int length = 0;

					this.vm_id = (Object) dis.readObject();

					this.vm_join_id = readString(dis);

					this.device_id = (Object) dis.readObject();

					this.device_join_id = readString(dis);

					this.type = readString(dis);

					this.address = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.is_managed = null;
					} else {
						this.is_managed = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_plugged = null;
					} else {
						this.is_plugged = dis.readBoolean();
					}

					length = dis.readByte();
					if (length == -1) {
						this.is_readonly = null;
					} else {
						this.is_readonly = dis.readBoolean();
					}

					this.vm_configuration_version = readInteger(dis);

					this.device_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.vm_id);

				// String

				writeString(this.vm_join_id, dos);

				// Object

				dos.writeObject(this.device_id);

				// String

				writeString(this.device_join_id, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.address, dos);

				// Boolean

				if (this.is_managed == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_managed);
				}

				// Boolean

				if (this.is_plugged == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_plugged);
				}

				// Boolean

				if (this.is_readonly == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeBoolean(this.is_readonly);
				}

				// Integer

				writeInteger(this.vm_configuration_version, dos);

				// Integer

				writeInteger(this.device_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("vm_id=" + String.valueOf(vm_id));
			sb.append(",vm_join_id=" + vm_join_id);
			sb.append(",device_id=" + String.valueOf(device_id));
			sb.append(",device_join_id=" + device_join_id);
			sb.append(",type=" + type);
			sb.append(",address=" + address);
			sb.append(",is_managed=" + String.valueOf(is_managed));
			sb.append(",is_plugged=" + String.valueOf(is_plugged));
			sb.append(",is_readonly=" + String.valueOf(is_readonly));
			sb.append(",vm_configuration_version="
					+ String.valueOf(vm_configuration_version));
			sb.append(",device_configuration_version="
					+ String.valueOf(device_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_56Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_56Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_56_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_55Process(globalMap);

				row48Struct row48 = new row48Struct();
				delete_vm_device_connectionStruct delete_vm_device_connection = new delete_vm_device_connectionStruct();

				/**
				 * [tJDBCOutput_32 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_32", false);
				start_Hash.put("tJDBCOutput_32", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_32";

				int tos_count_tJDBCOutput_32 = 0;

				int nb_line_tJDBCOutput_32 = 0;
				int nb_line_update_tJDBCOutput_32 = 0;
				int nb_line_inserted_tJDBCOutput_32 = 0;
				int nb_line_deleted_tJDBCOutput_32 = 0;
				int nb_line_rejected_tJDBCOutput_32 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_32 = 0;

				int deletedCount_tJDBCOutput_32 = 0;
				int updatedCount_tJDBCOutput_32 = 0;
				int insertedCount_tJDBCOutput_32 = 0;
				int rejectedCount_tJDBCOutput_32 = 0;

				boolean whetherReject_tJDBCOutput_32 = false;

				java.sql.Connection connection_tJDBCOutput_32 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String insert_tJDBCOutput_32 = "INSERT INTO "
						+ "vm_device_history"
						+ " (vm_id,device_id,type,address,is_managed,is_plugged,is_readonly,vm_configuration_version,device_configuration_version,create_date,update_date,delete_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_32 = connection_tJDBCOutput_32
						.prepareStatement(insert_tJDBCOutput_32);

				/**
				 * [tJDBCOutput_32 begin ] stop
				 */

				/**
				 * [tMap_32 begin ] start
				 */

				ok_Hash.put("tMap_32", false);
				start_Hash.put("tMap_32", System.currentTimeMillis());

				currentComponent = "tMap_32";

				int tos_count_tMap_32 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct> tHash_Lookup_row47 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row47Struct>) globalMap
						.get("tHash_Lookup_row47"));

				row47Struct row47HashKey = new row47Struct();
				row47Struct row47Default = new row47Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_32__Struct {
				}
				Var__tMap_32__Struct Var__tMap_32 = new Var__tMap_32__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				delete_vm_device_connectionStruct delete_vm_device_connection_tmp = new delete_vm_device_connectionStruct();
				// ###############################

				/**
				 * [tMap_32 begin ] stop
				 */

				/**
				 * [tJDBCInput_56 begin ] start
				 */

				ok_Hash.put("tJDBCInput_56", false);
				start_Hash.put("tJDBCInput_56", System.currentTimeMillis());

				currentComponent = "tJDBCInput_56";

				int tos_count_tJDBCInput_56 = 0;

				int nb_line_tJDBCInput_56 = 0;
				java.sql.Connection conn_tJDBCInput_56 = null;
				conn_tJDBCInput_56 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_56 = conn_tJDBCInput_56
						.createStatement();

				String dbquery_tJDBCInput_56 = "SELECT\n  vm_id,\n  upper(cast(vm_id as char(36))) as vm_join_id,\n  device_id, \n  upper(cast(device_id as char(36))) as device_join_id,\n  type, \n  address, \n  is_managed, \n  is_plugged, \n  is_readonly, \n  vm_configuration_version, \n  device_configuration_version, \n  create_date\nFROM v4_4_latest_configuration_vms_devices";

				globalMap.put("tJDBCInput_56_QUERY", dbquery_tJDBCInput_56);

				java.sql.ResultSet rs_tJDBCInput_56 = null;
				try {
					rs_tJDBCInput_56 = stmt_tJDBCInput_56
							.executeQuery(dbquery_tJDBCInput_56);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_56 = rs_tJDBCInput_56
							.getMetaData();
					int colQtyInRs_tJDBCInput_56 = rsmd_tJDBCInput_56
							.getColumnCount();

					String tmpContent_tJDBCInput_56 = null;

					while (rs_tJDBCInput_56.next()) {
						nb_line_tJDBCInput_56++;

						if (colQtyInRs_tJDBCInput_56 < 1) {
							row48.vm_id = null;
						} else {

							if (rs_tJDBCInput_56.getObject(1) != null) {
								row48.vm_id = rs_tJDBCInput_56.getObject(1);
							} else {
								row48.vm_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 2) {
							row48.vm_join_id = null;
						} else {

							row48.vm_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_56, 2, false);
						}
						if (colQtyInRs_tJDBCInput_56 < 3) {
							row48.device_id = null;
						} else {

							if (rs_tJDBCInput_56.getObject(3) != null) {
								row48.device_id = rs_tJDBCInput_56.getObject(3);
							} else {
								row48.device_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 4) {
							row48.device_join_id = null;
						} else {

							row48.device_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_56, 4, false);
						}
						if (colQtyInRs_tJDBCInput_56 < 5) {
							row48.type = null;
						} else {

							row48.type = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_56, 5, false);
						}
						if (colQtyInRs_tJDBCInput_56 < 6) {
							row48.address = null;
						} else {

							row48.address = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_56, 6, false);
						}
						if (colQtyInRs_tJDBCInput_56 < 7) {
							row48.is_managed = null;
						} else {

							if (rs_tJDBCInput_56.getObject(7) != null) {
								row48.is_managed = rs_tJDBCInput_56
										.getBoolean(7);
							} else {
								row48.is_managed = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 8) {
							row48.is_plugged = null;
						} else {

							if (rs_tJDBCInput_56.getObject(8) != null) {
								row48.is_plugged = rs_tJDBCInput_56
										.getBoolean(8);
							} else {
								row48.is_plugged = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 9) {
							row48.is_readonly = null;
						} else {

							if (rs_tJDBCInput_56.getObject(9) != null) {
								row48.is_readonly = rs_tJDBCInput_56
										.getBoolean(9);
							} else {
								row48.is_readonly = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 10) {
							row48.vm_configuration_version = null;
						} else {

							if (rs_tJDBCInput_56.getObject(10) != null) {
								row48.vm_configuration_version = rs_tJDBCInput_56
										.getInt(10);
							} else {
								row48.vm_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 11) {
							row48.device_configuration_version = null;
						} else {

							if (rs_tJDBCInput_56.getObject(11) != null) {
								row48.device_configuration_version = rs_tJDBCInput_56
										.getInt(11);
							} else {
								row48.device_configuration_version = null;
							}
						}
						if (colQtyInRs_tJDBCInput_56 < 12) {
							row48.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_56 = null;
							try {
								date_tJDBCInput_56 = rs_tJDBCInput_56
										.getTimestamp(12);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_56 = rs_tJDBCInput_56
										.getDate(12);
							}
							row48.create_date = date_tJDBCInput_56;
						}

						/**
						 * [tJDBCInput_56 begin ] stop
						 */

						/**
						 * [tJDBCInput_56 main ] start
						 */

						currentComponent = "tJDBCInput_56";

						tos_count_tJDBCInput_56++;

						/**
						 * [tJDBCInput_56 main ] stop
						 */

						/**
						 * [tMap_32 main ] start
						 */

						currentComponent = "tMap_32";

						boolean hasCasePrimitiveKeyWithNull_tMap_32 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_32 = false;
						boolean mainRowRejected_tMap_32 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row47"
						// /////////////////////////////////////////////

						boolean forceLooprow47 = false;

						row47Struct row47ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_32) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_32 = false;

							row47HashKey.device_join_id = row48.device_join_id;

							row47HashKey.vm_join_id = row48.vm_join_id;

							row47HashKey.hashCodeDirty = true;

							tHash_Lookup_row47.lookup(row47HashKey);

							if (!tHash_Lookup_row47.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_32 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row47 != null
								&& tHash_Lookup_row47.getCount(row47HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row47' and it contains more one result from keys :  row47.device_join_id = '"
							// + row47HashKey.device_join_id +
							// "', row47.vm_join_id = '" +
							// row47HashKey.vm_join_id + "'");
						} // G 071

						row47Struct row47 = null;

						row47Struct fromLookup_row47 = null;
						row47 = row47Default;

						if (tHash_Lookup_row47 != null
								&& tHash_Lookup_row47.hasNext()) { // G 099

							fromLookup_row47 = tHash_Lookup_row47.next();

						} // G 099

						if (fromLookup_row47 != null) {
		