/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.AddIfAbsentStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.CapabilityRegistration;
import org.jboss.as.clustering.controller.DescribedAddStepHandler;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class BoottimeAddStepHandler
extends AbstractBoottimeAddStepHandler
implements Registration<ManagementResourceRegistration>,
DescribedAddStepHandler {
    private final AddStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;

    public BoottimeAddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        super(descriptor.getAttributes());
        this.descriptor = descriptor;
        this.handler = handler;
    }

    @Override
    public AddStepHandlerDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (AttributeDefinition definition : this.descriptor.getExtraParameters()) {
            definition.validateOperation(operation);
        }
        super.populateModel(context, operation, resource);
        BoottimeAddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredChildren(), (r, path) -> r.hasChild(path));
        BoottimeAddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredSingletonChildren(), (r, path) -> r.hasChildren(path.getKey()));
    }

    private static void addRequiredChildren(OperationContext context, Collection<PathElement> paths, BiPredicate<Resource, PathElement> present) {
        for (PathElement path : paths) {
            context.addStep(Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path})), (OperationStepHandler)new AddIfAbsentStepHandler(present), OperationContext.Stage.MODEL);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.handler.installServices(context, resource.getModel());
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            this.handler.removeServices(context, resource.getModel());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        this.descriptor.getCapabilities().forEach(capability -> context.registerCapability(capability.resolve(address)));
        ModelNode model = resource.getModel();
        this.attributes.stream().filter(attribute -> model.hasDefined(attribute.getName()) || attribute.hasCapabilityRequirements()).forEach(attribute -> attribute.addCapabilityRequirements(context, model.get(attribute.getName())));
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.descriptor.getDescriptionResolver()).withFlag(OperationEntry.Flag.RESTART_NONE);
        Stream.concat(this.descriptor.getAttributes().stream(), this.descriptor.getExtraParameters().stream()).forEach(attribute -> builder.addParameter(attribute));
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this);
        ReloadRequiredWriteAttributeHandler writeAttributeHandler = new ReloadRequiredWriteAttributeHandler(this.descriptor.getAttributes());
        this.descriptor.getAttributes().forEach(arg_0 -> BoottimeAddStepHandler.lambda$register$6(registration, (OperationStepHandler)writeAttributeHandler, arg_0));
        new CapabilityRegistration(this.descriptor.getCapabilities()).register(registration);
    }

    private static /* synthetic */ void lambda$register$6(ManagementResourceRegistration managementResourceRegistration, OperationStepHandler operationStepHandler, AttributeDefinition attribute) {
        managementResourceRegistration.registerReadWriteAttribute(attribute, null, operationStepHandler);
    }
}

