/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.extension.ExtensionResourceDefinition;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.ValidateAddressOperationHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.GlobalInstallationReportHandler;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.transform.SubsystemDescriptionDump;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.HostRegistrations;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.ApplyExtensionsHandler;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.operations.GenericModelDescribeOperationHandler;
import org.jboss.as.domain.controller.operations.LocalHostNameOperationHandler;
import org.jboss.as.domain.controller.operations.ProcessTypeHandler;
import org.jboss.as.domain.controller.operations.ResolveExpressionOnDomainHandler;
import org.jboss.as.domain.controller.operations.SocketBindingGroupResourceDefinition;
import org.jboss.as.domain.controller.operations.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadURLHandler;
import org.jboss.as.domain.controller.resources.DomainDeploymentResourceDefinition;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.domain.controller.resources.HostConnectionResourceDefinition;
import org.jboss.as.domain.controller.resources.HostExcludeResourceDefinition;
import org.jboss.as.domain.controller.resources.ProfileResourceDefinition;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.domain.controller.transformers.DomainTransformers;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.mgmt.DomainHostExcludeRegistry;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResourceDefinition;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayDefinition;
import org.jboss.as.server.operations.ServerVersionOperations;
import org.jboss.as.server.services.net.InterfaceAddHandler;
import org.jboss.as.server.services.net.InterfaceRemoveHandler;
import org.jboss.as.server.services.net.InterfaceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DomainRootDefinition
extends SimpleResourceDefinition {
    private static final ParameterValidator NOT_NULL_STRING_LENGTH_ONE_VALIDATOR = new StringLengthValidator(1, false, false);
    public static final AttributeDefinition NAMESPACES = new SimpleMapAttributeDefinition.Builder(new PropertiesAttributeDefinition.Builder("namespaces", false).build()).build();
    public static final AttributeDefinition SCHEMA_LOCATIONS = new SimpleMapAttributeDefinition.Builder(new PropertiesAttributeDefinition.Builder("schema-locations", false).build()).build();
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDefaultValue(new ModelNode("Unnamed Domain"))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_NAMES)).build();
    public static final SimpleAttributeDefinition RELEASE_VERSION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"release-version", (ModelType)ModelType.STRING, (boolean)false).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR)).build();
    public static final SimpleAttributeDefinition RELEASE_CODENAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"release-codename", (ModelType)ModelType.STRING, (boolean)false).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR)).build();
    public static final SimpleAttributeDefinition PRODUCT_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"product-name", (ModelType)ModelType.STRING, (boolean)true).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR)).build();
    public static final SimpleAttributeDefinition PRODUCT_VERSION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"product-version", (ModelType)ModelType.STRING, (boolean)true).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MAJOR_VERSION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-major-version", (ModelType)ModelType.INT, (boolean)false).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MINOR_VERSION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-minor-version", (ModelType)ModelType.INT, (boolean)false).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MICRO_VERSION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-micro-version", (ModelType)ModelType.INT, (boolean)false).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    public static final SimpleAttributeDefinition PROCESS_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"process-type", (ModelType)ModelType.STRING).setStorageRuntime()).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR)).build();
    public static final SimpleAttributeDefinition LAUNCH_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"launch-type", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(ServerEnvironment.LaunchType.class, false, false))).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition LOCAL_HOST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"local-host-name", (ModelType)ModelType.STRING, (boolean)true).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR)).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition ORGANIZATION_IDENTIFIER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"domain-organization", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build();
    private final DomainController domainController;
    private final LocalHostControllerInfo hostControllerInfo;
    private final HostControllerEnvironment environment;
    private final ExtensibleConfigurationPersister configurationPersister;
    private final ContentRepository contentRepo;
    private final HostFileRepository fileRepository;
    private final boolean isMaster;
    private final ExtensionRegistry extensionRegistry;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final PathManagerService pathManager;
    private final DelegatingConfigurableAuthorizer authorizer;
    private final HostRegistrations hostRegistrations;
    private final DomainHostExcludeRegistry domainHostExcludeRegistry;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public DomainRootDefinition(DomainController domainController, HostControllerEnvironment environment, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepo, HostFileRepository fileRepository, boolean isMaster, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager, DelegatingConfigurableAuthorizer authorizer, HostRegistrations hostRegistrations, DomainHostExcludeRegistry domainHostExcludeRegistry, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        super(null, DomainResolver.getResolver("domain", false));
        this.domainController = domainController;
        this.isMaster = isMaster;
        this.environment = environment;
        this.hostControllerInfo = hostControllerInfo;
        this.configurationPersister = configurationPersister;
        this.contentRepo = contentRepo;
        this.fileRepository = fileRepository;
        this.extensionRegistry = extensionRegistry;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.pathManager = pathManager;
        this.authorizer = authorizer;
        this.hostRegistrations = hostRegistrations;
        this.domainHostExcludeRegistry = domainHostExcludeRegistry;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)NAME, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{NAME}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ORGANIZATION_IDENTIFIER, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{ORGANIZATION_IDENTIFIER}));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PROCESS_TYPE, (OperationStepHandler)(this.isMaster ? ProcessTypeHandler.MASTER : ProcessTypeHandler.SLAVE));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAUNCH_TYPE, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String launchType = DomainRootDefinition.this.environment.getProcessType() == ProcessType.EMBEDDED_HOST_CONTROLLER ? "EMBEDDED" : ServerEnvironment.LaunchType.DOMAIN.toString();
                context.getResult().set(launchType);
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LOCAL_HOST_NAME, (OperationStepHandler)new LocalHostNameOperationHandler(this.hostControllerInfo));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MAJOR_VERSION, null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MINOR_VERSION, null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MICRO_VERSION, null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RELEASE_VERSION, null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RELEASE_CODENAME, null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PRODUCT_NAME, null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PRODUCT_VERSION, null);
        resourceRegistration.registerReadOnlyAttribute(NAMESPACES, ServerVersionOperations.DefaultEmptyListAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(SCHEMA_LOCATIONS, ServerVersionOperations.DefaultEmptyListAttributeHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        XmlMarshallingHandler xmh = new XmlMarshallingHandler((ConfigurationPersister)this.configurationPersister);
        resourceRegistration.registerOperationHandler((OperationDefinition)XmlMarshallingHandler.DEFINITION, (OperationStepHandler)xmh);
        resourceRegistration.registerOperationHandler(NamespaceAddHandler.DEFINITION, (OperationStepHandler)NamespaceAddHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(NamespaceRemoveHandler.DEFINITION, (OperationStepHandler)NamespaceRemoveHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(SchemaLocationAddHandler.DEFINITION, (OperationStepHandler)SchemaLocationAddHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(SchemaLocationRemoveHandler.DEFINITION, (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)GlobalInstallationReportHandler.DEFINITION, GlobalInstallationReportHandler.createDomainOperation(), false);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericModelDescribeOperationHandler.DEFINITION, (OperationStepHandler)GenericModelDescribeOperationHandler.INSTANCE, true);
        if (this.isMaster) {
            DeploymentUploadURLHandler.registerMaster(resourceRegistration, this.contentRepo);
            DeploymentUploadStreamAttachmentHandler.registerMaster(resourceRegistration, this.contentRepo);
            DeploymentUploadBytesHandler.registerMaster(resourceRegistration, this.contentRepo);
            SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)this.configurationPersister);
            resourceRegistration.registerOperationHandler(SnapshotDeleteHandler.DEFINITION, (OperationStepHandler)snapshotDelete);
            SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)this.configurationPersister);
            resourceRegistration.registerOperationHandler(SnapshotListHandler.DEFINITION, (OperationStepHandler)snapshotList);
            SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)this.configurationPersister);
            resourceRegistration.registerOperationHandler(SnapshotTakeHandler.DEFINITION, (OperationStepHandler)snapshotTake);
            SubsystemDescriptionDump dumper = new SubsystemDescriptionDump(this.extensionRegistry);
            resourceRegistration.registerOperationHandler(SubsystemDescriptionDump.DEFINITION, (OperationStepHandler)dumper);
        } else {
            DeploymentUploadURLHandler.registerSlave(resourceRegistration);
            DeploymentUploadStreamAttachmentHandler.registerSlave(resourceRegistration);
            DeploymentUploadBytesHandler.registerSlave(resourceRegistration);
            ApplyExtensionsHandler aexh = new ApplyExtensionsHandler(this.extensionRegistry, this.hostControllerInfo, this.ignoredDomainResourceRegistry);
            resourceRegistration.registerOperationHandler((OperationDefinition)ApplyExtensionsHandler.DEFINITION, (OperationStepHandler)aexh);
        }
        resourceRegistration.registerOperationHandler(DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_DEFINITION, (OperationStepHandler)(this.isMaster ? new DeploymentFullReplaceHandler(this.contentRepo) : new DeploymentFullReplaceHandler(this.fileRepository)));
        resourceRegistration.registerOperationHandler(ValidateAddressOperationHandler.DEFINITION, (OperationStepHandler)ValidateAddressOperationHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(ResolveExpressionOnDomainHandler.DEFINITION, (OperationStepHandler)ResolveExpressionOnDomainHandler.INSTANCE);
        DomainServerLifecycleHandlers.registerDomainHandlers(resourceRegistration);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForDomainOrHost((SystemPropertyResourceDefinition.Location)SystemPropertyResourceDefinition.Location.DOMAIN));
        resourceRegistration.registerSubModel((ResourceDefinition)new InterfaceResourceDefinition(InterfaceAddHandler.NAMED_INSTANCE, (org.jboss.as.controller.operations.common.InterfaceRemoveHandler)InterfaceRemoveHandler.INSTANCE, false, false));
        ManagementResourceRegistration coreMgmt = resourceRegistration.registerSubModel((ResourceDefinition)CoreManagementResourceDefinition.forDomain((DelegatingConfigurableAuthorizer)this.authorizer));
        coreMgmt.registerSubModel((ResourceDefinition)new HostConnectionResourceDefinition(this.hostRegistrations));
        resourceRegistration.registerSubModel((ResourceDefinition)new ProfileResourceDefinition(this.hostControllerInfo, this.ignoredDomainResourceRegistry));
        resourceRegistration.registerSubModel((ResourceDefinition)PathResourceDefinition.createNamed((PathManagerService)this.pathManager));
        DomainDeploymentResourceDefinition domainDeploymentDefinition = this.isMaster ? DomainDeploymentResourceDefinition.createForDomainMaster(this.contentRepo) : DomainDeploymentResourceDefinition.createForDomainSlave(this.environment.isBackupDomainFiles(), this.fileRepository, this.contentRepo);
        resourceRegistration.registerSubModel((ResourceDefinition)domainDeploymentDefinition);
        resourceRegistration.registerSubModel((ResourceDefinition)new DeploymentOverlayDefinition(true, this.contentRepo, (DeploymentFileRepository)this.fileRepository));
        if (this.isMaster || this.environment.isBackupDomainFiles()) {
            resourceRegistration.registerSubModel((ResourceDefinition)new ServerGroupResourceDefinition(this.isMaster, this.hostControllerInfo, this.fileRepository));
        } else {
            resourceRegistration.registerSubModel((ResourceDefinition)new ServerGroupResourceDefinition(this.isMaster, this.hostControllerInfo, this.fileRepository, this.contentRepo));
        }
        resourceRegistration.registerSubModel((ResourceDefinition)SocketBindingGroupResourceDefinition.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)new ManagedDMRContentTypeResourceDefinition(this.contentRepo, "rollout-plan", PathElement.pathElement((String)"management-client-content", (String)"rollout-plans"), (ParameterValidator)new RolloutPlanValidator(), DomainResolver.getResolver("rollout-plans"), DomainResolver.getResolver("rollout-plan")));
        ExtensionRegistryType registryType = this.isMaster ? ExtensionRegistryType.MASTER : ExtensionRegistryType.SLAVE;
        resourceRegistration.registerSubModel((ResourceDefinition)new ExtensionResourceDefinition(this.extensionRegistry, true, registryType, this.rootResourceRegistrationProvider));
        resourceRegistration.registerSubModel((ResourceDefinition)new HostExcludeResourceDefinition(this.domainHostExcludeRegistry));
        DomainTransformers.initializeDomainRegistry(this.extensionRegistry.getTransformerRegistry());
    }

    public void initialize(ManagementResourceRegistration resourceRegistration) {
        this.registerAttributes(resourceRegistration);
        this.registerOperations(resourceRegistration);
        this.registerChildren(resourceRegistration);
    }

    public static class RolloutPlanValidator
    extends AbstractParameterValidator {
        private static final List<String> ALLOWED_SERVER_GROUP_CHILDREN = Arrays.asList("rolling-to-servers", "max-failure-percentage", "max-failed-servers");

        public void validateParameter(String parameterName, ModelNode plan) throws OperationFailedException {
            Set keys;
            if (plan == null) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.nullVar("plan").getLocalizedMessage());
            }
            if (!plan.hasDefined("rollout-plan")) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.requiredChildIsMissing("rollout-plan", "rollout-plan", plan.toString()));
            }
            ModelNode rolloutPlan1 = plan.get("rollout-plan");
            try {
                keys = rolloutPlan1.keys();
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.requiredChildIsMissing("rollout-plan", "in-series", plan.toString()));
            }
            if (!keys.contains("in-series")) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.requiredChildIsMissing("rollout-plan", "in-series", plan.toString()));
            }
            if (keys.size() > 2 || keys.size() == 2 && !keys.contains("rollback-across-groups")) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.unrecognizedChildren("rollout-plan", "in-series, rollback-across-groups", plan.toString()));
            }
            ModelNode inSeries = rolloutPlan1.get("in-series");
            if (!inSeries.isDefined()) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.requiredChildIsMissing("rollout-plan", "in-series", plan.toString()));
            }
            List groups = inSeries.asList();
            if (groups.isEmpty()) {
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.inSeriesIsMissingGroups(plan.toString()));
            }
            for (ModelNode group : groups) {
                if (group.hasDefined("server-group")) {
                    Set groupKeys;
                    ModelNode serverGroup = group.get("server-group");
                    try {
                        groupKeys = serverGroup.keys();
                    }
                    catch (IllegalArgumentException e) {
                        throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.serverGroupExpectsSingleChild(plan.toString()));
                    }
                    if (groupKeys.size() != 1) {
                        throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.serverGroupExpectsSingleChild(plan.toString()));
                    }
                    RolloutPlanValidator.validateInSeriesServerGroup(serverGroup.asProperty().getValue());
                    continue;
                }
                if (group.hasDefined("concurrent-groups")) {
                    ModelNode concurrent = group.get("concurrent-groups");
                    for (ModelNode child : concurrent.asList()) {
                        RolloutPlanValidator.validateInSeriesServerGroup(child.asProperty().getValue());
                    }
                    continue;
                }
                throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.unexpectedInSeriesGroup(plan.toString()));
            }
        }

        public static void validateInSeriesServerGroup(ModelNode serverGroup) throws OperationFailedException {
            if (serverGroup.isDefined()) {
                try {
                    Set specKeys = serverGroup.keys();
                    if (!ALLOWED_SERVER_GROUP_CHILDREN.containsAll(specKeys)) {
                        throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.unrecognizedChildren("server-group", ALLOWED_SERVER_GROUP_CHILDREN.toString(), specKeys.toString()));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

