/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class ALPN {
    public static final JDK9ALPNMethods JDK_9_ALPN_METHODS = AccessController.doPrivileged(new PrivilegedAction<JDK9ALPNMethods>(){

        @Override
        public JDK9ALPNMethods run() {
            try {
                Method setApplicationProtocols = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
                Method getApplicationProtocol = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
                UndertowLogger.ROOT_LOGGER.debug("Using JDK9 ALPN");
                return new JDK9ALPNMethods(setApplicationProtocols, getApplicationProtocol);
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.debug("JDK9 ALPN not supported", e);
                return null;
            }
        }
    });

    private ALPN() {
    }

    public static class JDK9ALPNMethods {
        private final Method setApplicationProtocols;
        private final Method getApplicationProtocol;

        JDK9ALPNMethods(Method setApplicationProtocols, Method getApplicationProtocol) {
            this.setApplicationProtocols = setApplicationProtocols;
            this.getApplicationProtocol = getApplicationProtocol;
        }

        public Method getApplicationProtocol() {
            return this.getApplicationProtocol;
        }

        public Method setApplicationProtocols() {
            return this.setApplicationProtocols;
        }
    }
}

