/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.util.Date;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.spi.BeanRemovedException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TimerTask<T extends TimerImpl>
implements Runnable {
    protected final String timedObjectId;
    protected final String timerId;
    protected final TimerServiceImpl timerService;
    private volatile boolean cancelled = false;

    public TimerTask(T timer) {
        if (timer == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerIsNull();
        }
        this.timedObjectId = ((TimerImpl)timer).getTimedObjectId();
        this.timerId = ((TimerImpl)timer).getId();
        this.timerService = ((TimerImpl)timer).getTimerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block30: {
            TimerImpl timer;
            ClassLoader old;
            block28: {
                Date now;
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                old = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.getClass());
                                timer = this.timerService.getTimer(this.timerId);
                                if (!this.cancelled) break block24;
                                EjbLogger.EJB3_TIMER_LOGGER.debugf("Timer task was cancelled for %s", timer);
                                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                                return;
                            }
                            now = new Date();
                            EjbLogger.EJB3_TIMER_LOGGER.debugf("Timer task invoked at: %s for timer %s", now, timer);
                            if (!timer.isInRetry()) break block25;
                            EjbLogger.EJB3_TIMER_LOGGER.skipInvokeTimeoutDuringRetry(timer, now);
                            timer.setNextTimeout(this.calculateNextTimeout(timer));
                            this.timerService.persistTimer(timer, false);
                            this.scheduleTimeoutIfRequired(timer);
                            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                            return;
                        }
                        if (timer.getState() != TimerState.IN_TIMEOUT && timer.getState() != TimerState.RETRY_TIMEOUT) break block26;
                        EjbLogger.EJB3_TIMER_LOGGER.skipOverlappingInvokeTimeout(timer, now);
                        timer.setNextTimeout(this.calculateNextTimeout(timer));
                        this.timerService.persistTimer(timer, false);
                        this.scheduleTimeoutIfRequired(timer);
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                        return;
                    }
                    if (this.timerService.shouldRun(timer)) break block27;
                    EjbLogger.EJB3_TIMER_LOGGER.debugf("Skipping execution of timer for %s as it is being run on another node or the execution is suppressed by configuration", timer.getTimedObjectId());
                    timer.setNextTimeout(this.calculateNextTimeout(timer));
                    this.scheduleTimeoutIfRequired(timer);
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                    return;
                }
                timer.lock();
                if (timer.isActive()) break block28;
                EjbLogger.EJB3_TIMER_LOGGER.debug("Timer is not active, skipping this scheduled execution at: " + now + "for " + timer);
                timer.unlock();
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                return;
            }
            try {
                block29: {
                    timer.setPreviousRun(new Date());
                    Date nextTimeout = this.calculateNextTimeout(timer);
                    timer.setNextTimeout(nextTimeout);
                    timer.setTimerState(TimerState.IN_TIMEOUT);
                    this.timerService.persistTimer(timer, false);
                    break block29;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        timer.unlock();
                    }
                }
                try {
                    this.callTimeout(timer);
                    break block30;
                }
                catch (BeanRemovedException e) {
                    EjbLogger.EJB3_TIMER_LOGGER.debugf("Removing timer %s as EJB has been removed ", timer);
                    timer.cancel();
                    break block30;
                }
                catch (Exception e) {
                    EjbLogger.EJB3_TIMER_LOGGER.errorInvokeTimeout(timer, e);
                    try {
                        EjbLogger.EJB3_TIMER_LOGGER.timerRetried(timer);
                        this.retryTimeout(timer);
                    }
                    catch (Exception retryException) {
                        EjbLogger.EJB3_TIMER_LOGGER.errorDuringRetryTimeout(timer, retryException);
                    }
                    break block30;
                }
                finally {
                    this.postTimeoutProcessing(timer);
                }
                {
                    catch (Exception e) {
                        EjbLogger.EJB3_TIMER_LOGGER.exceptionRunningTimerTask(timer, this.timedObjectId, e);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
            }
        }
    }

    protected void scheduleTimeoutIfRequired(TimerImpl timer) {
    }

    protected void callTimeout(TimerImpl timer) throws Exception {
        this.invokeBeanMethod(timer);
    }

    protected void invokeBeanMethod(TimerImpl timer) throws Exception {
        this.timerService.getInvoker().callTimeout(timer);
    }

    protected Date calculateNextTimeout(TimerImpl timer) {
        long intervalDuration = timer.getInterval();
        if (intervalDuration > 0L) {
            long now = new Date().getTime();
            long nextExpiration = timer.getNextExpiration().getTime();
            int periods = (int)((now - nextExpiration) / intervalDuration);
            return new Date(nextExpiration + (long)periods * intervalDuration + intervalDuration);
        }
        return null;
    }

    protected void retryTimeout(TimerImpl timer) throws Exception {
        if (timer.isActive()) {
            EjbLogger.EJB3_TIMER_LOGGER.retryingTimeout(timer);
            timer.setTimerState(TimerState.RETRY_TIMEOUT);
            this.timerService.persistTimer(timer, false);
            this.callTimeout(timer);
        } else {
            EjbLogger.EJB3_TIMER_LOGGER.timerNotActive(timer);
        }
    }

    protected void postTimeoutProcessing(TimerImpl timer) {
        timer.lock();
        try {
            TimerState timerState = timer.getState();
            if (timerState != TimerState.CANCELED && timerState != TimerState.EXPIRED) {
                if (timer.getInterval() == 0L) {
                    this.timerService.expireTimer(timer);
                } else {
                    timer.setTimerState(TimerState.ACTIVE);
                }
                this.timerService.persistTimer(timer, false);
            }
        }
        finally {
            timer.unlock();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }
}

