/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.server.logging.ServerLogger;

public class SystemExiter {
    private static Exiter exiter;
    private static final AtomicBoolean logged;

    public static void initialize(Exiter exiter) {
        SystemExiter.exiter = exiter;
    }

    public static void abort(final int status) {
        SystemExiter.logAndExit(new ExitLogger(){

            @Override
            public void logExit() {
                ServerLogger.ROOT_LOGGER.aborting(status);
            }
        }, status);
    }

    @Deprecated
    public static void exit(int status) {
        SystemExiter.getExiter().exit(status);
    }

    public static void logBeforeExit(ExitLogger logger2) {
        try {
            if (logged.compareAndSet(false, true)) {
                logger2.logExit();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logAndExit(ExitLogger logger2, int status) {
        SystemExiter.logBeforeExit(logger2);
        SystemExiter.getExiter().exit(status);
        logged.set(false);
    }

    private static Exiter getExiter() {
        return exiter == null ? Exiter.DEFAULT : exiter;
    }

    static {
        logged = new AtomicBoolean(false);
    }

    public static interface ExitLogger {
        public void logExit();
    }

    private static class DefaultExiter
    implements Exiter {
        private DefaultExiter() {
        }

        @Override
        public void exit(int status) {
            System.exit(status);
        }
    }

    public static interface Exiter {
        public static final Exiter DEFAULT = new DefaultExiter();

        public void exit(int var1);
    }
}

