/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ForwardQueue;

@MBean(description="Forwards unicast messages to the current coordinator")
public class FORWARD_TO_COORD
extends Protocol {
    protected volatile Address coord = null;
    protected volatile Address local_addr;
    protected final AtomicLong current_id = new AtomicLong(0L);
    protected final ForwardQueue fwd_queue = new ForwardQueue(this.log);
    protected volatile boolean received_not_coord;

    @ManagedAttribute(description="Number of messages for which no ack has been received yet")
    public int getForwardTableSize() {
        return this.fwd_queue.size();
    }

    @ManagedAttribute(description="Total number of all seqnos maintained for all receivers")
    public int getDeliveryTableSize() {
        return this.fwd_queue.deliveryTableSize();
    }

    @Override
    public List<Integer> providedUpServices() {
        return Collections.singletonList(105);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.received_not_coord = false;
        this.fwd_queue.setUpProt(this.up_prot);
        this.fwd_queue.setDownProt(this.down_prot);
        this.fwd_queue.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.fwd_queue.stop();
        this.coord = null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 105: {
                Address target = this.coord;
                if (target == null) {
                    throw new IllegalStateException("coord is null; dropping message");
                }
                Message msg = (Message)evt.getArg();
                long msg_id = this.getNextId();
                ForwardHeader hdr = new ForwardHeader(1, msg_id);
                msg.putHeader(this.id, hdr);
                msg.setDest(target);
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": forwarding message with id=" + msg_id + " to current coordinator " + target);
                }
                this.fwd_queue.send(msg_id, msg);
                return null;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.fwd_queue.setLocalAddr(this.local_addr);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        ForwardHeader hdr = (ForwardHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        long msg_id = hdr.getId();
        Address sender = msg.getSrc();
        switch (hdr.getType()) {
            case 1: {
                if (this.local_addr != null && !this.local_addr.equals(this.coord)) {
                    this.log.warn(this.local_addr + ": received a message with id=" + msg_id + " from " + sender + ", but I'm not coordinator (" + this.coord + " is); dropping the message");
                    this.sendNotCoord(sender, msg_id);
                    return null;
                }
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": received a message with id=" + msg_id + " from " + sender);
                    }
                    this.fwd_queue.receive(msg_id, msg);
                    Object var6_5 = null;
                    return var6_5;
                }
                finally {
                    this.sendAck(sender, msg_id);
                }
            }
            case 2: {
                this.fwd_queue.ack(msg_id);
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": received an ack from " + sender + " for " + msg_id);
                }
                return null;
            }
            case 3: {
                if (!this.received_not_coord) {
                    this.received_not_coord = true;
                }
                return null;
            }
        }
        return null;
    }

    protected long getNextId() {
        return this.current_id.incrementAndGet();
    }

    protected void handleViewChange(View view) {
        boolean coord_changed;
        Address new_coord = view.getCoord();
        boolean bl = coord_changed = !Objects.equals(this.coord, new_coord);
        if (coord_changed || this.received_not_coord) {
            if (this.received_not_coord) {
                this.received_not_coord = false;
            }
            this.fwd_queue.flush(new_coord, view.getMembers());
            this.coord = new_coord;
        }
    }

    protected void sendAck(Address target, long ack_id) {
        this.send(target, ack_id, (byte)2);
    }

    protected void sendNotCoord(Address target, long ack_id) {
        this.send(target, ack_id, (byte)3);
    }

    protected void send(Address target, long ack_id, byte type) {
        this.down_prot.down(new Message(target).putHeader(this.id, new ForwardHeader(type, ack_id)));
    }

    protected static class ForwardHeader
    extends Header {
        protected static final byte MSG = 1;
        protected static final byte ACK = 2;
        protected static final byte NOT_COORD = 3;
        protected byte type;
        protected long id;

        public ForwardHeader() {
        }

        public ForwardHeader(byte type, long id) {
            this.type = type;
            this.id = id;
        }

        @Override
        public Supplier<? extends Header> create() {
            return ForwardHeader::new;
        }

        @Override
        public short getMagicId() {
            return 81;
        }

        public long getId() {
            return this.id;
        }

        public byte getType() {
            return this.type;
        }

        @Override
        public int serializedSize() {
            return 1 + Bits.size(this.id);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Bits.writeLong(this.id, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.id = Bits.readLong(in);
        }

        @Override
        public String toString() {
            return ForwardHeader.typeToString(this.type) + "(" + this.id + ")";
        }

        protected static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "MSG";
                }
                case 2: {
                    return "ACK";
                }
                case 3: {
                    return "NOT_COORD";
                }
            }
            return "n/a";
        }
    }
}

