/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm authorizationRealm;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = authenticationRealm;
        this.authorizationRealm = authorizationRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(evidence);
        try {
            Identity identity;
            block8: {
                RealmIdentity authorizationIdentity = this.authorizationRealm.getRealmIdentity(evidence);
                try {
                    Identity identity2 = new Identity(authenticationIdentity, authorizationIdentity);
                    ok = true;
                    identity = identity2;
                    if (ok) break block8;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        authorizationIdentity.dispose();
                    }
                    throw throwable;
                }
                authorizationIdentity.dispose();
            }
            return identity;
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(principal);
        try {
            Identity identity;
            block8: {
                RealmIdentity authorizationIdentity = this.authorizationRealm.getRealmIdentity(principal);
                try {
                    Identity identity2 = new Identity(authenticationIdentity, authorizationIdentity);
                    ok = true;
                    identity = identity2;
                    if (ok) break block8;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        authorizationIdentity.dispose();
                    }
                    throw throwable;
                }
                authorizationIdentity.dispose();
            }
            return identity;
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
            }
        }
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.authenticationRealm.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public void handleRealmEvent(RealmEvent event) {
        if (event instanceof RealmAuthenticationEvent) {
            this.authenticationRealm.handleRealmEvent(event);
        } else if (event instanceof RealmAuthorizationEvent) {
            this.authorizationRealm.handleRealmEvent(event);
        } else {
            SecurityRealm.safeHandleRealmEvent((SecurityRealm)this.authenticationRealm, (RealmEvent)event);
            SecurityRealm.safeHandleRealmEvent((SecurityRealm)this.authorizationRealm, (RealmEvent)event);
        }
    }

    static final class Identity
    implements RealmIdentity {
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity authorizationIdentity;

        Identity(RealmIdentity authenticationIdentity, RealmIdentity authorizationIdentity) {
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentity = authorizationIdentity;
        }

        public Principal getRealmIdentityPrincipal() {
            return this.authenticationIdentity.getRealmIdentityPrincipal();
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return (C)this.authenticationIdentity.getCredential(credentialType, algorithmName, parameterSpec);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return (C)this.authenticationIdentity.getCredential(credentialType, algorithmName);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return (C)this.authenticationIdentity.getCredential(credentialType);
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyEvidence(evidence);
        }

        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.authorizationIdentity.getAuthorizationIdentity();
        }

        public void dispose() {
            this.authenticationIdentity.dispose();
            this.authorizationIdentity.dispose();
        }
    }
}

